/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SingletonServiceBaseMBean;
import weblogic.management.mbeans.custom.SingletonService;
import weblogic.utils.collections.CombinedIterator;

public class SingletonServiceBaseMBeanImpl
extends ConfigurationMBeanImpl
implements SingletonServiceBaseMBean,
Serializable {
    private int _AdditionalMigrationAttempts;
    private ServerMBean _HostingServer;
    private int _MillisToSleepBetweenAttempts;
    private String _Name;
    private ServerMBean _UserPreferredServer;
    private SingletonService _customizer;
    private static SchemaHelper2 _schemaHelper;

    public SingletonServiceBaseMBeanImpl() {
        try {
            this._customizer = new SingletonService(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public SingletonServiceBaseMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new SingletonService(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ServerMBean getHostingServer() {
        return this._customizer.getHostingServer();
    }

    public String getHostingServerAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getHostingServer();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isHostingServerSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setHostingServerAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean serverMBean = this._HostingServer;
            this._initializeProperty(7);
            this._postSet(7, serverMBean, this._HostingServer);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ServerMBean.class, new ReferenceManager.Resolver(this, 7){

                public void resolveReference(Object object) {
                    try {
                        SingletonServiceBaseMBeanImpl.this.setHostingServer((ServerMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setHostingServer(ServerMBean serverMBean) {
        ServerMBean serverMBean2;
        if (serverMBean != null) {
            serverMBean2 = new ResolvedReference(this, 7, (AbstractDescriptorBean)serverMBean){

                protected Object getPropertyValue() {
                    return SingletonServiceBaseMBeanImpl.this.getHostingServer();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBean, (ResolvedReference)serverMBean2);
        }
        serverMBean2 = this._HostingServer;
        this._HostingServer = serverMBean;
        this._postSet(7, serverMBean2, serverMBean);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public ServerMBean getUserPreferredServer() {
        return this._customizer.getUserPreferredServer();
    }

    public String getUserPreferredServerAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getUserPreferredServer();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isUserPreferredServerSet() {
        return this._isSet(8);
    }

    public void setUserPreferredServerAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean serverMBean = this._UserPreferredServer;
            this._initializeProperty(8);
            this._postSet(8, serverMBean, this._UserPreferredServer);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ServerMBean.class, new ReferenceManager.Resolver(this, 8){

                public void resolveReference(Object object) {
                    try {
                        SingletonServiceBaseMBeanImpl.this.setUserPreferredServer((ServerMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setUserPreferredServer(ServerMBean serverMBean) {
        ServerMBean serverMBean2;
        if (serverMBean != null) {
            serverMBean2 = new ResolvedReference(this, 8, (AbstractDescriptorBean)serverMBean){

                protected Object getPropertyValue() {
                    return SingletonServiceBaseMBeanImpl.this.getUserPreferredServer();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBean, (ResolvedReference)serverMBean2);
        }
        serverMBean2 = this.getUserPreferredServer();
        this._customizer.setUserPreferredServer(serverMBean);
        this._postSet(8, serverMBean2, serverMBean);
    }

    public int getAdditionalMigrationAttempts() {
        return this._AdditionalMigrationAttempts;
    }

    public boolean isAdditionalMigrationAttemptsSet() {
        return this._isSet(9);
    }

    public void setAdditionalMigrationAttempts(int n) {
        int n2 = this._AdditionalMigrationAttempts;
        this._AdditionalMigrationAttempts = n;
        this._postSet(9, n2, n);
    }

    public int getMillisToSleepBetweenAttempts() {
        return this._MillisToSleepBetweenAttempts;
    }

    public boolean isMillisToSleepBetweenAttemptsSet() {
        return this._isSet(10);
    }

    public void setMillisToSleepBetweenAttempts(int n) {
        int n2 = this._MillisToSleepBetweenAttempts;
        this._MillisToSleepBetweenAttempts = n;
        this._postSet(10, n2, n);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 9;
        }
        try {
            switch (n) {
                case 9: {
                    this._AdditionalMigrationAttempts = 2;
                    if (bl) break;
                }
                case 7: {
                    this._HostingServer = null;
                    if (bl) break;
                }
                case 10: {
                    this._MillisToSleepBetweenAttempts = 300000;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 8: {
                    this._customizer.setUserPreferredServer(null);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "SingletonServiceBase";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AdditionalMigrationAttempts")) {
            int n = this._AdditionalMigrationAttempts;
            this._AdditionalMigrationAttempts = (Integer)object;
            this._postSet(9, n, this._AdditionalMigrationAttempts);
            return;
        }
        if (string.equals("HostingServer")) {
            ServerMBean serverMBean = this._HostingServer;
            this._HostingServer = (ServerMBean)object;
            this._postSet(7, serverMBean, this._HostingServer);
            return;
        }
        if (string.equals("MillisToSleepBetweenAttempts")) {
            int n = this._MillisToSleepBetweenAttempts;
            this._MillisToSleepBetweenAttempts = (Integer)object;
            this._postSet(10, n, this._MillisToSleepBetweenAttempts);
            return;
        }
        if (string.equals("Name")) {
            String string2 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string2, this._Name);
            return;
        }
        if (string.equals("UserPreferredServer")) {
            ServerMBean serverMBean = this._UserPreferredServer;
            this._UserPreferredServer = (ServerMBean)object;
            this._postSet(8, serverMBean, this._UserPreferredServer);
            return;
        }
        if (string.equals("customizer")) {
            SingletonService singletonService = this._customizer;
            this._customizer = (SingletonService)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AdditionalMigrationAttempts")) {
            return new Integer(this._AdditionalMigrationAttempts);
        }
        if (string.equals("HostingServer")) {
            return this._HostingServer;
        }
        if (string.equals("MillisToSleepBetweenAttempts")) {
            return new Integer(this._MillisToSleepBetweenAttempts);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("UserPreferredServer")) {
            return this._UserPreferredServer;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 29: {
                    if (!string.equals("additional-migration-attempts")) break;
                    return 9;
                }
                case 14: {
                    if (!string.equals("hosting-server")) break;
                    return 7;
                }
                case 32: {
                    if (!string.equals("millis-to-sleep-between-attempts")) break;
                    return 10;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 21: {
                    if (!string.equals("user-preferred-server")) break;
                    return 8;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 9: {
                    return "additional-migration-attempts";
                }
                case 7: {
                    return "hosting-server";
                }
                case 10: {
                    return "millis-to-sleep-between-attempts";
                }
                case 2: {
                    return "name";
                }
                case 8: {
                    return "user-preferred-server";
                }
            }
            return super.getElementName(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private SingletonServiceBaseMBeanImpl bean;

        protected Helper(SingletonServiceBaseMBeanImpl singletonServiceBaseMBeanImpl) {
            super(singletonServiceBaseMBeanImpl);
            this.bean = singletonServiceBaseMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 9: {
                    return "AdditionalMigrationAttempts";
                }
                case 7: {
                    return "HostingServer";
                }
                case 10: {
                    return "MillisToSleepBetweenAttempts";
                }
                case 2: {
                    return "Name";
                }
                case 8: {
                    return "UserPreferredServer";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AdditionalMigrationAttempts")) {
                return 9;
            }
            if (string.equals("HostingServer")) {
                return 7;
            }
            if (string.equals("MillisToSleepBetweenAttempts")) {
                return 10;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("UserPreferredServer")) {
                return 8;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAdditionalMigrationAttemptsSet()) {
                    stringBuffer.append("AdditionalMigrationAttempts");
                    stringBuffer.append(String.valueOf(this.bean.getAdditionalMigrationAttempts()));
                }
                if (this.bean.isHostingServerSet()) {
                    stringBuffer.append("HostingServer");
                    stringBuffer.append(String.valueOf(this.bean.getHostingServer()));
                }
                if (this.bean.isMillisToSleepBetweenAttemptsSet()) {
                    stringBuffer.append("MillisToSleepBetweenAttempts");
                    stringBuffer.append(String.valueOf(this.bean.getMillisToSleepBetweenAttempts()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isUserPreferredServerSet()) {
                    stringBuffer.append("UserPreferredServer");
                    stringBuffer.append(String.valueOf(this.bean.getUserPreferredServer()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                SingletonServiceBaseMBeanImpl singletonServiceBaseMBeanImpl = (SingletonServiceBaseMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AdditionalMigrationAttempts", this.bean.getAdditionalMigrationAttempts(), singletonServiceBaseMBeanImpl.getAdditionalMigrationAttempts(), false);
                this.computeDiff("HostingServer", this.bean.getHostingServer(), singletonServiceBaseMBeanImpl.getHostingServer(), true);
                this.computeDiff("MillisToSleepBetweenAttempts", this.bean.getMillisToSleepBetweenAttempts(), singletonServiceBaseMBeanImpl.getMillisToSleepBetweenAttempts(), false);
                this.computeDiff("Name", this.bean.getName(), singletonServiceBaseMBeanImpl.getName(), false);
                this.computeDiff("UserPreferredServer", this.bean.getUserPreferredServer(), singletonServiceBaseMBeanImpl.getUserPreferredServer(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                SingletonServiceBaseMBeanImpl singletonServiceBaseMBeanImpl = (SingletonServiceBaseMBeanImpl)beanUpdateEvent.getSourceBean();
                SingletonServiceBaseMBeanImpl singletonServiceBaseMBeanImpl2 = (SingletonServiceBaseMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AdditionalMigrationAttempts")) {
                    singletonServiceBaseMBeanImpl.setAdditionalMigrationAttempts(singletonServiceBaseMBeanImpl2.getAdditionalMigrationAttempts());
                    singletonServiceBaseMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("HostingServer")) {
                    singletonServiceBaseMBeanImpl.setHostingServerAsString(singletonServiceBaseMBeanImpl2.getHostingServerAsString());
                    singletonServiceBaseMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("MillisToSleepBetweenAttempts")) {
                    singletonServiceBaseMBeanImpl.setMillisToSleepBetweenAttempts(singletonServiceBaseMBeanImpl2.getMillisToSleepBetweenAttempts());
                    singletonServiceBaseMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("Name")) {
                    singletonServiceBaseMBeanImpl.setName(singletonServiceBaseMBeanImpl2.getName());
                    singletonServiceBaseMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("UserPreferredServer")) {
                    singletonServiceBaseMBeanImpl.setUserPreferredServerAsString(singletonServiceBaseMBeanImpl2.getUserPreferredServerAsString());
                    singletonServiceBaseMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                SingletonServiceBaseMBeanImpl singletonServiceBaseMBeanImpl = (SingletonServiceBaseMBeanImpl)abstractDescriptorBean;
                super.finishCopy(singletonServiceBaseMBeanImpl, bl, list);
                if ((list == null || !list.contains("AdditionalMigrationAttempts")) && this.bean.isAdditionalMigrationAttemptsSet()) {
                    singletonServiceBaseMBeanImpl.setAdditionalMigrationAttempts(this.bean.getAdditionalMigrationAttempts());
                }
                if ((list == null || !list.contains("HostingServer")) && this.bean.isHostingServerSet()) {
                    singletonServiceBaseMBeanImpl._unSet(singletonServiceBaseMBeanImpl, 7);
                    singletonServiceBaseMBeanImpl.setHostingServerAsString(this.bean.getHostingServerAsString());
                }
                if ((list == null || !list.contains("MillisToSleepBetweenAttempts")) && this.bean.isMillisToSleepBetweenAttemptsSet()) {
                    singletonServiceBaseMBeanImpl.setMillisToSleepBetweenAttempts(this.bean.getMillisToSleepBetweenAttempts());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    singletonServiceBaseMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("UserPreferredServer")) && this.bean.isUserPreferredServerSet()) {
                    singletonServiceBaseMBeanImpl._unSet(singletonServiceBaseMBeanImpl, 8);
                    singletonServiceBaseMBeanImpl.setUserPreferredServerAsString(this.bean.getUserPreferredServerAsString());
                }
                return singletonServiceBaseMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getHostingServer(), clazz, object);
            this.inferSubTree(this.bean.getUserPreferredServer(), clazz, object);
        }
    }
}

