/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.ServerMBeanImpl;
import weblogic.management.configuration.SingletonServiceBaseMBeanImpl;
import weblogic.management.configuration.SingletonServiceMBean;
import weblogic.management.mbeans.custom.SingletonService;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class SingletonServiceMBeanImpl
extends SingletonServiceBaseMBeanImpl
implements SingletonServiceMBean,
Serializable {
    private ServerMBean[] _AllCandidateServers;
    private String _ClassName;
    private ClusterMBean _Cluster;
    private ServerMBean[] _ConstrainedCandidateServers;
    private ServerMBean _HostingServer;
    private String _Name;
    private ServerMBean _UserPreferredServer;
    private SingletonService _customizer;
    private static SchemaHelper2 _schemaHelper;

    public SingletonServiceMBeanImpl() {
        try {
            this._customizer = new SingletonService(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public SingletonServiceMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new SingletonService(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getClassName() {
        if (!this._isSet(11)) {
            try {
                return this.getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._ClassName;
    }

    public ServerMBean getHostingServer() {
        return this._customizer.getHostingServer();
    }

    public String getHostingServerAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getHostingServer();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isClassNameSet() {
        return this._isSet(11);
    }

    public boolean isHostingServerSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setHostingServerAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean serverMBean = this._HostingServer;
            this._initializeProperty(7);
            this._postSet(7, serverMBean, this._HostingServer);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ServerMBean.class, new ReferenceManager.Resolver(this, 7){

                public void resolveReference(Object object) {
                    try {
                        SingletonServiceMBeanImpl.this.setHostingServer((ServerMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setClassName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"ClassName", (Object)string);
        String string2 = this._ClassName;
        this._ClassName = string;
        this._postSet(11, string2, string);
    }

    public void setHostingServer(ServerMBean serverMBean) {
        ServerMBean serverMBean2;
        if (serverMBean != null) {
            serverMBean2 = new ResolvedReference(this, 7, (AbstractDescriptorBean)serverMBean){

                protected Object getPropertyValue() {
                    return SingletonServiceMBeanImpl.this.getHostingServer();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBean, (ResolvedReference)serverMBean2);
        }
        serverMBean2 = this._HostingServer;
        this._HostingServer = serverMBean;
        this._postSet(7, serverMBean2, serverMBean);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public ServerMBean[] getConstrainedCandidateServers() {
        return this._ConstrainedCandidateServers;
    }

    public String getConstrainedCandidateServersAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getConstrainedCandidateServers());
    }

    public ServerMBean getUserPreferredServer() {
        return this._customizer.getUserPreferredServer();
    }

    public String getUserPreferredServerAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getUserPreferredServer();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isConstrainedCandidateServersSet() {
        return this._isSet(12);
    }

    public boolean isUserPreferredServerSet() {
        return this._isSet(8);
    }

    public void setConstrainedCandidateServersAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean[] serverMBeanArray = this._ConstrainedCandidateServers;
            this._initializeProperty(12);
            this._postSet(12, serverMBeanArray, this._ConstrainedCandidateServers);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._ConstrainedCandidateServers);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, ServerMBean.class, new ReferenceManager.Resolver(this, 12){

                    public void resolveReference(Object object) {
                        try {
                            SingletonServiceMBeanImpl.this.addConstrainedCandidateServer((ServerMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (ServerMBean serverMBean : this._ConstrainedCandidateServers) {
                    if (!string2.equals(serverMBean.getName())) continue;
                    try {
                        this.removeConstrainedCandidateServer(serverMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setUserPreferredServerAsString(String string) {
        if (string == null || string.length() == 0) {
            ServerMBean serverMBean = this._UserPreferredServer;
            this._initializeProperty(8);
            this._postSet(8, serverMBean, this._UserPreferredServer);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ServerMBean.class, new ReferenceManager.Resolver(this, 8){

                public void resolveReference(Object object) {
                    try {
                        SingletonServiceMBeanImpl.this.setUserPreferredServer((ServerMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setConstrainedCandidateServers(ServerMBean[] serverMBeanArray) throws InvalidAttributeValueException {
        serverMBeanArray = serverMBeanArray == null ? new ServerMBeanImpl[]{} : serverMBeanArray;
        serverMBeanArray = (ServerMBean[])this._getHelper()._cleanAndValidateArray((Object)serverMBeanArray, ServerMBean.class);
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (serverMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 12, (AbstractDescriptorBean)serverMBeanArray[i]){

                protected Object getPropertyValue() {
                    return SingletonServiceMBeanImpl.this.getConstrainedCandidateServers();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBeanArray[i], resolvedReference);
        }
        ServerMBean[] serverMBeanArray2 = this._ConstrainedCandidateServers;
        this._ConstrainedCandidateServers = serverMBeanArray;
        this._postSet(12, serverMBeanArray2, serverMBeanArray);
    }

    public void setUserPreferredServer(ServerMBean serverMBean) {
        ServerMBean serverMBean2;
        if (serverMBean != null) {
            serverMBean2 = new ResolvedReference(this, 8, (AbstractDescriptorBean)serverMBean){

                protected Object getPropertyValue() {
                    return SingletonServiceMBeanImpl.this.getUserPreferredServer();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)serverMBean, (ResolvedReference)serverMBean2);
        }
        serverMBean2 = this.getUserPreferredServer();
        this._customizer.setUserPreferredServer(serverMBean);
        this._postSet(8, serverMBean2, serverMBean);
    }

    public boolean addConstrainedCandidateServer(ServerMBean serverMBean) throws InvalidAttributeValueException {
        this._getHelper()._ensureNonNull((Object)serverMBean);
        if (!((AbstractDescriptorBean)serverMBean).isChildProperty((DescriptorBean)this, 12)) {
            ServerMBean[] serverMBeanArray = this._isSet(12) ? (ServerMBean[])this._getHelper()._extendArray((Object)this.getConstrainedCandidateServers(), ServerMBean.class, (Object)serverMBean) : new ServerMBean[]{serverMBean};
            try {
                this.setConstrainedCandidateServers(serverMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeConstrainedCandidateServer(ServerMBean serverMBean) throws InvalidAttributeValueException {
        ServerMBean[] serverMBeanArray = this.getConstrainedCandidateServers();
        ServerMBean[] serverMBeanArray2 = (ServerMBean[])this._getHelper()._removeElement((Object)serverMBeanArray, ServerMBean.class, (Object)serverMBean);
        if (serverMBeanArray2.length != serverMBeanArray.length) {
            try {
                this.setConstrainedCandidateServers(serverMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public ClusterMBean getCluster() {
        return this._Cluster;
    }

    public String getClusterAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getCluster();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isClusterSet() {
        return this._isSet(13);
    }

    public void setClusterAsString(String string) {
        if (string == null || string.length() == 0) {
            ClusterMBean clusterMBean = this._Cluster;
            this._initializeProperty(13);
            this._postSet(13, clusterMBean, this._Cluster);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, ClusterMBean.class, new ReferenceManager.Resolver(this, 13){

                public void resolveReference(Object object) {
                    try {
                        SingletonServiceMBeanImpl.this.setCluster((ClusterMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setCluster(ClusterMBean clusterMBean) {
        ClusterMBean clusterMBean2;
        if (clusterMBean != null) {
            clusterMBean2 = new ResolvedReference(this, 13, (AbstractDescriptorBean)clusterMBean){

                protected Object getPropertyValue() {
                    return SingletonServiceMBeanImpl.this.getCluster();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)clusterMBean, (ResolvedReference)clusterMBean2);
        }
        clusterMBean2 = this._Cluster;
        this._Cluster = clusterMBean;
        this._postSet(13, clusterMBean2, clusterMBean);
    }

    public void addAllCandidateServer(ServerMBean serverMBean) {
        this._getHelper()._ensureNonNull((Object)serverMBean);
        if (!((AbstractDescriptorBean)serverMBean).isChildProperty((DescriptorBean)this, 14)) {
            ServerMBean[] serverMBeanArray = (ServerMBean[])this._getHelper()._extendArray((Object)this.getAllCandidateServers(), ServerMBean.class, (Object)serverMBean);
            try {
                this.setAllCandidateServers(serverMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public ServerMBean[] getAllCandidateServers() {
        return this._customizer.getAllCandidateServers();
    }

    public boolean isAllCandidateServersSet() {
        return this._isSet(14);
    }

    public void removeAllCandidateServer(ServerMBean serverMBean) {
        ServerMBean[] serverMBeanArray = this.getAllCandidateServers();
        ServerMBean[] serverMBeanArray2 = (ServerMBean[])this._getHelper()._removeElement((Object)serverMBeanArray, ServerMBean.class, (Object)serverMBean);
        if (serverMBeanArray2.length != serverMBeanArray.length) {
            try {
                this.setAllCandidateServers(serverMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setAllCandidateServers(ServerMBean[] serverMBeanArray) {
        serverMBeanArray = serverMBeanArray == null ? new ServerMBeanImpl[]{} : serverMBeanArray;
        this._AllCandidateServers = serverMBeanArray;
    }

    public boolean isCandidate(ServerMBean serverMBean) {
        return this._customizer.isCandidate(serverMBean);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 14;
        }
        try {
            switch (n) {
                case 14: {
                    this._AllCandidateServers = new ServerMBean[0];
                    if (bl) break;
                }
                case 11: {
                    this._ClassName = null;
                    if (bl) break;
                }
                case 13: {
                    this._Cluster = null;
                    if (bl) break;
                }
                case 12: {
                    this._ConstrainedCandidateServers = new ServerMBean[0];
                    if (bl) break;
                }
                case 7: {
                    this._HostingServer = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 8: {
                    this._customizer.setUserPreferredServer(null);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "SingletonService";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AllCandidateServers")) {
            ServerMBean[] serverMBeanArray = this._AllCandidateServers;
            this._AllCandidateServers = (ServerMBean[])object;
            this._postSet(14, serverMBeanArray, this._AllCandidateServers);
            return;
        }
        if (string.equals("ClassName")) {
            String string2 = this._ClassName;
            this._ClassName = (String)object;
            this._postSet(11, string2, this._ClassName);
            return;
        }
        if (string.equals("Cluster")) {
            ClusterMBean clusterMBean = this._Cluster;
            this._Cluster = (ClusterMBean)object;
            this._postSet(13, clusterMBean, this._Cluster);
            return;
        }
        if (string.equals("ConstrainedCandidateServers")) {
            ServerMBean[] serverMBeanArray = this._ConstrainedCandidateServers;
            this._ConstrainedCandidateServers = (ServerMBean[])object;
            this._postSet(12, serverMBeanArray, this._ConstrainedCandidateServers);
            return;
        }
        if (string.equals("HostingServer")) {
            ServerMBean serverMBean = this._HostingServer;
            this._HostingServer = (ServerMBean)object;
            this._postSet(7, serverMBean, this._HostingServer);
            return;
        }
        if (string.equals("Name")) {
            String string3 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string3, this._Name);
            return;
        }
        if (string.equals("UserPreferredServer")) {
            ServerMBean serverMBean = this._UserPreferredServer;
            this._UserPreferredServer = (ServerMBean)object;
            this._postSet(8, serverMBean, this._UserPreferredServer);
            return;
        }
        if (string.equals("customizer")) {
            SingletonService singletonService = this._customizer;
            this._customizer = (SingletonService)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AllCandidateServers")) {
            return this._AllCandidateServers;
        }
        if (string.equals("ClassName")) {
            return this._ClassName;
        }
        if (string.equals("Cluster")) {
            return this._Cluster;
        }
        if (string.equals("ConstrainedCandidateServers")) {
            return this._ConstrainedCandidateServers;
        }
        if (string.equals("HostingServer")) {
            return this._HostingServer;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("UserPreferredServer")) {
            return this._UserPreferredServer;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends SingletonServiceBaseMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 20: {
                    if (!string.equals("all-candidate-server")) break;
                    return 14;
                }
                case 10: {
                    if (!string.equals("class-name")) break;
                    return 11;
                }
                case 7: {
                    if (!string.equals("cluster")) break;
                    return 13;
                }
                case 28: {
                    if (!string.equals("constrained-candidate-server")) break;
                    return 12;
                }
                case 14: {
                    if (!string.equals("hosting-server")) break;
                    return 7;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 21: {
                    if (!string.equals("user-preferred-server")) break;
                    return 8;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 14: {
                    return "all-candidate-server";
                }
                case 11: {
                    return "class-name";
                }
                case 13: {
                    return "cluster";
                }
                case 12: {
                    return "constrained-candidate-server";
                }
                case 7: {
                    return "hosting-server";
                }
                case 2: {
                    return "name";
                }
                case 8: {
                    return "user-preferred-server";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 14: {
                    return true;
                }
                case 12: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends SingletonServiceBaseMBeanImpl.Helper {
        private SingletonServiceMBeanImpl bean;

        protected Helper(SingletonServiceMBeanImpl singletonServiceMBeanImpl) {
            super(singletonServiceMBeanImpl);
            this.bean = singletonServiceMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 14: {
                    return "AllCandidateServers";
                }
                case 11: {
                    return "ClassName";
                }
                case 13: {
                    return "Cluster";
                }
                case 12: {
                    return "ConstrainedCandidateServers";
                }
                case 7: {
                    return "HostingServer";
                }
                case 2: {
                    return "Name";
                }
                case 8: {
                    return "UserPreferredServer";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AllCandidateServers")) {
                return 14;
            }
            if (string.equals("ClassName")) {
                return 11;
            }
            if (string.equals("Cluster")) {
                return 13;
            }
            if (string.equals("ConstrainedCandidateServers")) {
                return 12;
            }
            if (string.equals("HostingServer")) {
                return 7;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("UserPreferredServer")) {
                return 8;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAllCandidateServersSet()) {
                    stringBuffer.append("AllCandidateServers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getAllCandidateServers())));
                }
                if (this.bean.isClassNameSet()) {
                    stringBuffer.append("ClassName");
                    stringBuffer.append(String.valueOf(this.bean.getClassName()));
                }
                if (this.bean.isClusterSet()) {
                    stringBuffer.append("Cluster");
                    stringBuffer.append(String.valueOf(this.bean.getCluster()));
                }
                if (this.bean.isConstrainedCandidateServersSet()) {
                    stringBuffer.append("ConstrainedCandidateServers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getConstrainedCandidateServers())));
                }
                if (this.bean.isHostingServerSet()) {
                    stringBuffer.append("HostingServer");
                    stringBuffer.append(String.valueOf(this.bean.getHostingServer()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isUserPreferredServerSet()) {
                    stringBuffer.append("UserPreferredServer");
                    stringBuffer.append(String.valueOf(this.bean.getUserPreferredServer()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                SingletonServiceMBeanImpl singletonServiceMBeanImpl = (SingletonServiceMBeanImpl)abstractDescriptorBean;
                this.computeDiff("ClassName", this.bean.getClassName(), singletonServiceMBeanImpl.getClassName(), false);
                this.computeDiff("Cluster", this.bean.getCluster(), singletonServiceMBeanImpl.getCluster(), false);
                this.computeDiff("ConstrainedCandidateServers", this.bean.getConstrainedCandidateServers(), singletonServiceMBeanImpl.getConstrainedCandidateServers(), false);
                this.computeDiff("HostingServer", this.bean.getHostingServer(), singletonServiceMBeanImpl.getHostingServer(), true);
                this.computeDiff("Name", this.bean.getName(), singletonServiceMBeanImpl.getName(), false);
                this.computeDiff("UserPreferredServer", this.bean.getUserPreferredServer(), singletonServiceMBeanImpl.getUserPreferredServer(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                SingletonServiceMBeanImpl singletonServiceMBeanImpl = (SingletonServiceMBeanImpl)beanUpdateEvent.getSourceBean();
                SingletonServiceMBeanImpl singletonServiceMBeanImpl2 = (SingletonServiceMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("AllCandidateServers")) {
                    if (string.equals("ClassName")) {
                        singletonServiceMBeanImpl.setClassName(singletonServiceMBeanImpl2.getClassName());
                        singletonServiceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("Cluster")) {
                        singletonServiceMBeanImpl.setClusterAsString(singletonServiceMBeanImpl2.getClusterAsString());
                        singletonServiceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("ConstrainedCandidateServers")) {
                        singletonServiceMBeanImpl.setConstrainedCandidateServersAsString(singletonServiceMBeanImpl2.getConstrainedCandidateServersAsString());
                        singletonServiceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("HostingServer")) {
                        singletonServiceMBeanImpl.setHostingServerAsString(singletonServiceMBeanImpl2.getHostingServerAsString());
                        singletonServiceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                    } else if (string.equals("Name")) {
                        singletonServiceMBeanImpl.setName(singletonServiceMBeanImpl2.getName());
                        singletonServiceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (string.equals("UserPreferredServer")) {
                        singletonServiceMBeanImpl.setUserPreferredServerAsString(singletonServiceMBeanImpl2.getUserPreferredServerAsString());
                        singletonServiceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                SingletonServiceMBeanImpl singletonServiceMBeanImpl = (SingletonServiceMBeanImpl)abstractDescriptorBean;
                super.finishCopy(singletonServiceMBeanImpl, bl, list);
                if ((list == null || !list.contains("ClassName")) && this.bean.isClassNameSet()) {
                    singletonServiceMBeanImpl.setClassName(this.bean.getClassName());
                }
                if ((list == null || !list.contains("Cluster")) && this.bean.isClusterSet()) {
                    singletonServiceMBeanImpl._unSet((AbstractDescriptorBean)singletonServiceMBeanImpl, 13);
                    singletonServiceMBeanImpl.setClusterAsString(this.bean.getClusterAsString());
                }
                if ((list == null || !list.contains("ConstrainedCandidateServers")) && this.bean.isConstrainedCandidateServersSet()) {
                    singletonServiceMBeanImpl._unSet(singletonServiceMBeanImpl, 12);
                    singletonServiceMBeanImpl.setConstrainedCandidateServersAsString(this.bean.getConstrainedCandidateServersAsString());
                }
                if ((list == null || !list.contains("HostingServer")) && this.bean.isHostingServerSet()) {
                    singletonServiceMBeanImpl._unSet(singletonServiceMBeanImpl, 7);
                    singletonServiceMBeanImpl.setHostingServerAsString(this.bean.getHostingServerAsString());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    singletonServiceMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("UserPreferredServer")) && this.bean.isUserPreferredServerSet()) {
                    singletonServiceMBeanImpl._unSet(singletonServiceMBeanImpl, 8);
                    singletonServiceMBeanImpl.setUserPreferredServerAsString(this.bean.getUserPreferredServerAsString());
                }
                return singletonServiceMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getAllCandidateServers(), clazz, object);
            this.inferSubTree(this.bean.getCluster(), clazz, object);
            this.inferSubTree(this.bean.getConstrainedCandidateServers(), clazz, object);
            this.inferSubTree(this.bean.getHostingServer(), clazz, object);
            this.inferSubTree(this.bean.getUserPreferredServer(), clazz, object);
        }
    }
}

