/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.DomainTargetHelper;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class TargetInfoMBeanImpl
extends ConfigurationMBeanImpl
implements TargetInfoMBean,
Serializable {
    private String _CompatibilityName;
    private String _ModuleType;
    private String _Name;
    private TargetMBean[] _Targets;
    private static SchemaHelper2 _schemaHelper;

    public TargetInfoMBeanImpl() {
        this._initializeProperty(-1);
    }

    public TargetInfoMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._Name;
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        String string2 = this._Name;
        this._Name = string;
        this._postSet(2, string2, string);
    }

    public TargetMBean[] getTargets() {
        if (!this._isSet(7)) {
            try {
                return DomainTargetHelper.getDefaultTargets(this, this.getValue("Targets"));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._Targets;
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            TargetInfoMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        DomainTargetHelper.validateTargets(this);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return TargetInfoMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this._Targets;
        this._Targets = targetMBeanArray;
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public void addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = this._isSet(7) ? (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean) : new TargetMBean[]{targetMBean};
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public String getModuleType() {
        return this._ModuleType;
    }

    public boolean isModuleTypeSet() {
        return this._isSet(8);
    }

    public void setModuleType(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ModuleType;
        this._ModuleType = string;
        this._postSet(8, string2, string);
    }

    public String getCompatibilityName() {
        return this._CompatibilityName;
    }

    public boolean isCompatibilityNameSet() {
        return this._isSet(9);
    }

    public void setCompatibilityName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._CompatibilityName;
        this._CompatibilityName = string;
        this._postSet(9, string2, string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 9;
        }
        try {
            switch (n) {
                case 9: {
                    this._CompatibilityName = null;
                    if (bl) break;
                }
                case 8: {
                    this._ModuleType = null;
                    if (bl) break;
                }
                case 2: {
                    this._Name = null;
                    if (bl) break;
                }
                case 7: {
                    this._Targets = new TargetMBean[0];
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "TargetInfo";
    }

    public void putValue(String string, Object object) {
        if (string.equals("CompatibilityName")) {
            String string2 = this._CompatibilityName;
            this._CompatibilityName = (String)object;
            this._postSet(9, string2, this._CompatibilityName);
            return;
        }
        if (string.equals("ModuleType")) {
            String string3 = this._ModuleType;
            this._ModuleType = (String)object;
            this._postSet(8, string3, this._ModuleType);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("CompatibilityName")) {
            return this._CompatibilityName;
        }
        if (string.equals("ModuleType")) {
            return this._ModuleType;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 18: {
                    if (!string.equals("compatibility-name")) break;
                    return 9;
                }
                case 11: {
                    if (!string.equals("module-type")) break;
                    return 8;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 9: {
                    return "compatibility-name";
                }
                case 8: {
                    return "module-type";
                }
                case 2: {
                    return "name";
                }
                case 7: {
                    return "target";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private TargetInfoMBeanImpl bean;

        protected Helper(TargetInfoMBeanImpl targetInfoMBeanImpl) {
            super(targetInfoMBeanImpl);
            this.bean = targetInfoMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 9: {
                    return "CompatibilityName";
                }
                case 8: {
                    return "ModuleType";
                }
                case 2: {
                    return "Name";
                }
                case 7: {
                    return "Targets";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("CompatibilityName")) {
                return 9;
            }
            if (string.equals("ModuleType")) {
                return 8;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCompatibilityNameSet()) {
                    stringBuffer.append("CompatibilityName");
                    stringBuffer.append(String.valueOf(this.bean.getCompatibilityName()));
                }
                if (this.bean.isModuleTypeSet()) {
                    stringBuffer.append("ModuleType");
                    stringBuffer.append(String.valueOf(this.bean.getModuleType()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                TargetInfoMBeanImpl targetInfoMBeanImpl = (TargetInfoMBeanImpl)abstractDescriptorBean;
                this.computeDiff("CompatibilityName", this.bean.getCompatibilityName(), targetInfoMBeanImpl.getCompatibilityName(), false);
                this.computeDiff("ModuleType", this.bean.getModuleType(), targetInfoMBeanImpl.getModuleType(), false);
                this.computeDiff("Name", this.bean.getName(), targetInfoMBeanImpl.getName(), false);
                this.computeDiff("Targets", this.bean.getTargets(), targetInfoMBeanImpl.getTargets(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                TargetInfoMBeanImpl targetInfoMBeanImpl = (TargetInfoMBeanImpl)beanUpdateEvent.getSourceBean();
                TargetInfoMBeanImpl targetInfoMBeanImpl2 = (TargetInfoMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("CompatibilityName")) {
                    targetInfoMBeanImpl.setCompatibilityName(targetInfoMBeanImpl2.getCompatibilityName());
                    targetInfoMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("ModuleType")) {
                    targetInfoMBeanImpl.setModuleType(targetInfoMBeanImpl2.getModuleType());
                    targetInfoMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("Name")) {
                    targetInfoMBeanImpl.setName(targetInfoMBeanImpl2.getName());
                    targetInfoMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("Targets")) {
                    targetInfoMBeanImpl.setTargetsAsString(targetInfoMBeanImpl2.getTargetsAsString());
                    targetInfoMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                TargetInfoMBeanImpl targetInfoMBeanImpl = (TargetInfoMBeanImpl)abstractDescriptorBean;
                super.finishCopy(targetInfoMBeanImpl, bl, list);
                if ((list == null || !list.contains("CompatibilityName")) && this.bean.isCompatibilityNameSet()) {
                    targetInfoMBeanImpl.setCompatibilityName(this.bean.getCompatibilityName());
                }
                if ((list == null || !list.contains("ModuleType")) && this.bean.isModuleTypeSet()) {
                    targetInfoMBeanImpl.setModuleType(this.bean.getModuleType());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    targetInfoMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    targetInfoMBeanImpl._unSet(targetInfoMBeanImpl, 7);
                    targetInfoMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                return targetInfoMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

