/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.JDBCStoreMBeanImpl;
import weblogic.management.configuration.JMSLegalHelper;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.configuration.TransactionLogJDBCStoreMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class TransactionLogJDBCStoreMBeanImpl
extends JDBCStoreMBeanImpl
implements TransactionLogJDBCStoreMBean,
Serializable {
    private boolean _Enabled;
    private int _MaxRetrySecondsBeforeTLOGFail;
    private int _MaxRetrySecondsBeforeTXException;
    private String _PrefixName;
    private int _RetryIntervalSeconds;
    private TargetMBean[] _Targets;
    private static SchemaHelper2 _schemaHelper;

    public TransactionLogJDBCStoreMBeanImpl() {
        this._initializeProperty(-1);
    }

    public TransactionLogJDBCStoreMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String getPrefixName() {
        if (!this._isSet(7)) {
            try {
                return "TLOG_" + ((ServerMBean)this.getParent()).getName() + "_";
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._PrefixName;
    }

    public TargetMBean[] getTargets() {
        return this._Targets;
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public boolean isPrefixNameSet() {
        return this._isSet(7);
    }

    public boolean isTargetsSet() {
        return this._isSet(9);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(9);
            this._postSet(9, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 9){

                    public void resolveReference(Object object) {
                        try {
                            TransactionLogJDBCStoreMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setPrefixName(String string) {
        string = string == null ? null : string.trim();
        JMSLegalHelper.validateJDBCPrefix(string);
        String string2 = this._PrefixName;
        this._PrefixName = string;
        this._postSet(7, string2, string);
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 9, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return TransactionLogJDBCStoreMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this._Targets;
        this._Targets = targetMBeanArray;
        this._postSet(9, targetMBeanArray2, targetMBeanArray);
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 9)) {
            TargetMBean[] targetMBeanArray = this._isSet(9) ? (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean) : new TargetMBean[]{targetMBean};
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean isEnabled() {
        return this._Enabled;
    }

    public boolean isEnabledSet() {
        return this._isSet(21);
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this._Enabled;
        this._Enabled = bl;
        this._postSet(21, bl2, bl);
    }

    public int getMaxRetrySecondsBeforeTLOGFail() {
        return this._MaxRetrySecondsBeforeTLOGFail;
    }

    public boolean isMaxRetrySecondsBeforeTLOGFailSet() {
        return this._isSet(22);
    }

    public void setMaxRetrySecondsBeforeTLOGFail(int n) {
        LegalChecks.checkInRange((String)"MaxRetrySecondsBeforeTLOGFail", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._MaxRetrySecondsBeforeTLOGFail;
        this._MaxRetrySecondsBeforeTLOGFail = n;
        this._postSet(22, n2, n);
    }

    public int getMaxRetrySecondsBeforeTXException() {
        return this._MaxRetrySecondsBeforeTXException;
    }

    public boolean isMaxRetrySecondsBeforeTXExceptionSet() {
        return this._isSet(23);
    }

    public void setMaxRetrySecondsBeforeTXException(int n) {
        LegalChecks.checkInRange((String)"MaxRetrySecondsBeforeTXException", (long)n, (long)0L, (long)300L);
        int n2 = this._MaxRetrySecondsBeforeTXException;
        this._MaxRetrySecondsBeforeTXException = n;
        this._postSet(23, n2, n);
    }

    public int getRetryIntervalSeconds() {
        return this._RetryIntervalSeconds;
    }

    public boolean isRetryIntervalSecondsSet() {
        return this._isSet(24);
    }

    public void setRetryIntervalSeconds(int n) {
        LegalChecks.checkInRange((String)"RetryIntervalSeconds", (long)n, (long)1L, (long)60L);
        int n2 = this._RetryIntervalSeconds;
        this._RetryIntervalSeconds = n;
        this._postSet(24, n2, n);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 22;
        }
        try {
            switch (n) {
                case 22: {
                    this._MaxRetrySecondsBeforeTLOGFail = 300;
                    if (bl) break;
                }
                case 23: {
                    this._MaxRetrySecondsBeforeTXException = 60;
                    if (bl) break;
                }
                case 7: {
                    this._PrefixName = null;
                    if (bl) break;
                }
                case 24: {
                    this._RetryIntervalSeconds = 5;
                    if (bl) break;
                }
                case 9: {
                    this._Targets = new TargetMBean[0];
                    if (bl) break;
                }
                case 21: {
                    this._Enabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "TransactionLogJDBCStore";
    }

    public void putValue(String string, Object object) {
        if (string.equals("Enabled")) {
            boolean bl = this._Enabled;
            this._Enabled = (Boolean)object;
            this._postSet(21, bl, this._Enabled);
            return;
        }
        if (string.equals("MaxRetrySecondsBeforeTLOGFail")) {
            int n = this._MaxRetrySecondsBeforeTLOGFail;
            this._MaxRetrySecondsBeforeTLOGFail = (Integer)object;
            this._postSet(22, n, this._MaxRetrySecondsBeforeTLOGFail);
            return;
        }
        if (string.equals("MaxRetrySecondsBeforeTXException")) {
            int n = this._MaxRetrySecondsBeforeTXException;
            this._MaxRetrySecondsBeforeTXException = (Integer)object;
            this._postSet(23, n, this._MaxRetrySecondsBeforeTXException);
            return;
        }
        if (string.equals("PrefixName")) {
            String string2 = this._PrefixName;
            this._PrefixName = (String)object;
            this._postSet(7, string2, this._PrefixName);
            return;
        }
        if (string.equals("RetryIntervalSeconds")) {
            int n = this._RetryIntervalSeconds;
            this._RetryIntervalSeconds = (Integer)object;
            this._postSet(24, n, this._RetryIntervalSeconds);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(9, targetMBeanArray, this._Targets);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("Enabled")) {
            return new Boolean(this._Enabled);
        }
        if (string.equals("MaxRetrySecondsBeforeTLOGFail")) {
            return new Integer(this._MaxRetrySecondsBeforeTLOGFail);
        }
        if (string.equals("MaxRetrySecondsBeforeTXException")) {
            return new Integer(this._MaxRetrySecondsBeforeTXException);
        }
        if (string.equals("PrefixName")) {
            return this._PrefixName;
        }
        if (string.equals("RetryIntervalSeconds")) {
            return new Integer(this._RetryIntervalSeconds);
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends JDBCStoreMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 33: {
                    if (!string.equals("max-retry-seconds-beforetlog-fail")) break;
                    return 22;
                }
                case 36: {
                    if (!string.equals("max-retry-seconds-beforetx-exception")) break;
                    return 23;
                }
                case 11: {
                    if (!string.equals("prefix-name")) break;
                    return 7;
                }
                case 22: {
                    if (!string.equals("retry-interval-seconds")) break;
                    return 24;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 9;
                }
                case 7: {
                    if (!string.equals("enabled")) break;
                    return 21;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 22: {
                    return "max-retry-seconds-beforetlog-fail";
                }
                case 23: {
                    return "max-retry-seconds-beforetx-exception";
                }
                case 7: {
                    return "prefix-name";
                }
                case 24: {
                    return "retry-interval-seconds";
                }
                case 9: {
                    return "target";
                }
                case 21: {
                    return "enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 9: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 22: {
                    return true;
                }
                case 23: {
                    return true;
                }
                case 24: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends JDBCStoreMBeanImpl.Helper {
        private TransactionLogJDBCStoreMBeanImpl bean;

        protected Helper(TransactionLogJDBCStoreMBeanImpl transactionLogJDBCStoreMBeanImpl) {
            super(transactionLogJDBCStoreMBeanImpl);
            this.bean = transactionLogJDBCStoreMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 22: {
                    return "MaxRetrySecondsBeforeTLOGFail";
                }
                case 23: {
                    return "MaxRetrySecondsBeforeTXException";
                }
                case 7: {
                    return "PrefixName";
                }
                case 24: {
                    return "RetryIntervalSeconds";
                }
                case 9: {
                    return "Targets";
                }
                case 21: {
                    return "Enabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("MaxRetrySecondsBeforeTLOGFail")) {
                return 22;
            }
            if (string.equals("MaxRetrySecondsBeforeTXException")) {
                return 23;
            }
            if (string.equals("PrefixName")) {
                return 7;
            }
            if (string.equals("RetryIntervalSeconds")) {
                return 24;
            }
            if (string.equals("Targets")) {
                return 9;
            }
            if (string.equals("Enabled")) {
                return 21;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isMaxRetrySecondsBeforeTLOGFailSet()) {
                    stringBuffer.append("MaxRetrySecondsBeforeTLOGFail");
                    stringBuffer.append(String.valueOf(this.bean.getMaxRetrySecondsBeforeTLOGFail()));
                }
                if (this.bean.isMaxRetrySecondsBeforeTXExceptionSet()) {
                    stringBuffer.append("MaxRetrySecondsBeforeTXException");
                    stringBuffer.append(String.valueOf(this.bean.getMaxRetrySecondsBeforeTXException()));
                }
                if (this.bean.isPrefixNameSet()) {
                    stringBuffer.append("PrefixName");
                    stringBuffer.append(String.valueOf(this.bean.getPrefixName()));
                }
                if (this.bean.isRetryIntervalSecondsSet()) {
                    stringBuffer.append("RetryIntervalSeconds");
                    stringBuffer.append(String.valueOf(this.bean.getRetryIntervalSeconds()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isEnabledSet()) {
                    stringBuffer.append("Enabled");
                    stringBuffer.append(String.valueOf(this.bean.isEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                TransactionLogJDBCStoreMBeanImpl transactionLogJDBCStoreMBeanImpl = (TransactionLogJDBCStoreMBeanImpl)abstractDescriptorBean;
                this.computeDiff("MaxRetrySecondsBeforeTLOGFail", this.bean.getMaxRetrySecondsBeforeTLOGFail(), transactionLogJDBCStoreMBeanImpl.getMaxRetrySecondsBeforeTLOGFail(), true);
                this.computeDiff("MaxRetrySecondsBeforeTXException", this.bean.getMaxRetrySecondsBeforeTXException(), transactionLogJDBCStoreMBeanImpl.getMaxRetrySecondsBeforeTXException(), true);
                this.computeDiff("PrefixName", this.bean.getPrefixName(), transactionLogJDBCStoreMBeanImpl.getPrefixName(), true);
                this.computeDiff("RetryIntervalSeconds", this.bean.getRetryIntervalSeconds(), transactionLogJDBCStoreMBeanImpl.getRetryIntervalSeconds(), true);
                this.computeDiff("Targets", this.bean.getTargets(), transactionLogJDBCStoreMBeanImpl.getTargets(), false);
                this.computeDiff("Enabled", this.bean.isEnabled(), transactionLogJDBCStoreMBeanImpl.isEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                TransactionLogJDBCStoreMBeanImpl transactionLogJDBCStoreMBeanImpl = (TransactionLogJDBCStoreMBeanImpl)beanUpdateEvent.getSourceBean();
                TransactionLogJDBCStoreMBeanImpl transactionLogJDBCStoreMBeanImpl2 = (TransactionLogJDBCStoreMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("MaxRetrySecondsBeforeTLOGFail")) {
                    transactionLogJDBCStoreMBeanImpl.setMaxRetrySecondsBeforeTLOGFail(transactionLogJDBCStoreMBeanImpl2.getMaxRetrySecondsBeforeTLOGFail());
                    transactionLogJDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("MaxRetrySecondsBeforeTXException")) {
                    transactionLogJDBCStoreMBeanImpl.setMaxRetrySecondsBeforeTXException(transactionLogJDBCStoreMBeanImpl2.getMaxRetrySecondsBeforeTXException());
                    transactionLogJDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("PrefixName")) {
                    transactionLogJDBCStoreMBeanImpl.setPrefixName(transactionLogJDBCStoreMBeanImpl2.getPrefixName());
                    transactionLogJDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("RetryIntervalSeconds")) {
                    transactionLogJDBCStoreMBeanImpl.setRetryIntervalSeconds(transactionLogJDBCStoreMBeanImpl2.getRetryIntervalSeconds());
                    transactionLogJDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("Targets")) {
                    transactionLogJDBCStoreMBeanImpl.setTargetsAsString(transactionLogJDBCStoreMBeanImpl2.getTargetsAsString());
                    transactionLogJDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("Enabled")) {
                    transactionLogJDBCStoreMBeanImpl.setEnabled(transactionLogJDBCStoreMBeanImpl2.isEnabled());
                    transactionLogJDBCStoreMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                TransactionLogJDBCStoreMBeanImpl transactionLogJDBCStoreMBeanImpl = (TransactionLogJDBCStoreMBeanImpl)abstractDescriptorBean;
                super.finishCopy(transactionLogJDBCStoreMBeanImpl, bl, list);
                if ((list == null || !list.contains("MaxRetrySecondsBeforeTLOGFail")) && this.bean.isMaxRetrySecondsBeforeTLOGFailSet()) {
                    transactionLogJDBCStoreMBeanImpl.setMaxRetrySecondsBeforeTLOGFail(this.bean.getMaxRetrySecondsBeforeTLOGFail());
                }
                if ((list == null || !list.contains("MaxRetrySecondsBeforeTXException")) && this.bean.isMaxRetrySecondsBeforeTXExceptionSet()) {
                    transactionLogJDBCStoreMBeanImpl.setMaxRetrySecondsBeforeTXException(this.bean.getMaxRetrySecondsBeforeTXException());
                }
                if ((list == null || !list.contains("PrefixName")) && this.bean.isPrefixNameSet()) {
                    transactionLogJDBCStoreMBeanImpl.setPrefixName(this.bean.getPrefixName());
                }
                if ((list == null || !list.contains("RetryIntervalSeconds")) && this.bean.isRetryIntervalSecondsSet()) {
                    transactionLogJDBCStoreMBeanImpl.setRetryIntervalSeconds(this.bean.getRetryIntervalSeconds());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    transactionLogJDBCStoreMBeanImpl._unSet(transactionLogJDBCStoreMBeanImpl, 9);
                    transactionLogJDBCStoreMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if ((list == null || !list.contains("Enabled")) && this.bean.isEnabledSet()) {
                    transactionLogJDBCStoreMBeanImpl.setEnabled(this.bean.isEnabled());
                }
                return transactionLogJDBCStoreMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getTargets(), clazz, object);
        }
    }
}

