/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import com.oracle.vmm.client.AdapterInfo;
import com.oracle.vmm.client.VMMConnector;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VMMAdapterValidator {
    public static String TOO_MANY_PARTS_MSG = "Adapter may not have more than two parts separated by '_'";
    public static String NULL_EMPTY_MSG = "Adapter name and/or version may not be null or empty string";
    public static String NOT_FOUND_MSG = "Specified adapter name/version cannot be found: ";

    public static void validateAdapter(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(NULL_EMPTY_MSG);
        }
        String[] stringArray = string.split("_");
        if (stringArray.length > 2) {
            throw new IllegalArgumentException(TOO_MANY_PARTS_MSG);
        }
        for (String string2 : VMMAdapterValidator.getAvailableAdapters()) {
            if (!string.equals(string2)) continue;
            return;
        }
        throw new IllegalArgumentException(NOT_FOUND_MSG + string);
    }

    public static void validateAdapterName(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(NULL_EMPTY_MSG);
        }
        for (String string2 : VMMAdapterValidator.getAvailableAdapters()) {
            if (!string2.startsWith(string + "_")) continue;
            return;
        }
        throw new IllegalArgumentException(NOT_FOUND_MSG + string);
    }

    public static void validateAdapterVersion(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException(NULL_EMPTY_MSG);
        }
        for (String string2 : VMMAdapterValidator.getAvailableAdapters()) {
            if (!string2.endsWith("_" + string)) continue;
            return;
        }
        throw new IllegalArgumentException(NOT_FOUND_MSG + string);
    }

    public static List<String> getAvailableAdapters() {
        List list = VMMConnector.getAvailableAdapters();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (AdapterInfo adapterInfo : list) {
                arrayList.add(adapterInfo.getVmmType() + "_" + adapterInfo.getVmmApiVersion());
            }
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        List<String> list = VMMAdapterValidator.getAvailableAdapters();
        if (list != null) {
            for (String string : list) {
                System.out.println(string);
            }
        }
    }
}

