/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.LoggingLegalHelper;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WebServerLogMBean;
import weblogic.management.configuration.WebServerLogMBeanImpl;
import weblogic.management.configuration.WebServerMBeanImpl;
import weblogic.management.mbeans.custom.VirtualHost;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class VirtualHostMBeanImpl
extends WebServerMBeanImpl
implements VirtualHostMBean,
Serializable {
    private int _LogFileCount;
    private String _LogFileFormat;
    private boolean _LogFileLimitEnabled;
    private String _LogFileName;
    private int _LogRotationPeriodMins;
    private String _LogRotationTimeBegin;
    private String _LogRotationType;
    private boolean _LogTimeInGMT;
    private boolean _LoggingEnabled;
    private String _Name;
    private String _NetworkAccessPoint;
    private Set _ServerNames;
    private String[] _VirtualHostNames;
    private VirtualHost _customizer;
    private static SchemaHelper2 _schemaHelper;

    public VirtualHostMBeanImpl() {
        try {
            this._customizer = new VirtualHost(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public VirtualHostMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new VirtualHost(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public Set getServerNames() {
        return this._customizer.getServerNames();
    }

    public String[] getVirtualHostNames() {
        return this._VirtualHostNames;
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isServerNamesSet() {
        return this._isSet(49);
    }

    public boolean isVirtualHostNamesSet() {
        return this._isSet(50);
    }

    public void setServerNames(Set set) throws InvalidAttributeValueException {
        this._ServerNames = set;
    }

    public void setLoggingEnabled(boolean bl) {
        boolean bl2 = this.isLoggingEnabled();
        this._customizer.setLoggingEnabled(bl);
        this._postSet(10, bl2, bl);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setVirtualHostNames(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._VirtualHostNames;
        this._VirtualHostNames = stringArray;
        this._postSet(50, stringArray2, stringArray);
    }

    public String getNetworkAccessPoint() {
        return this._NetworkAccessPoint;
    }

    public boolean isLoggingEnabled() {
        return this._customizer.isLoggingEnabled();
    }

    public boolean isLoggingEnabledSet() {
        return this._isSet(10);
    }

    public boolean isNetworkAccessPointSet() {
        return this._isSet(51);
    }

    public String getLogFileFormat() {
        return this._customizer.getLogFileFormat();
    }

    public boolean isLogFileFormatSet() {
        return this._isSet(11);
    }

    public void setNetworkAccessPoint(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._NetworkAccessPoint;
        this._NetworkAccessPoint = string;
        this._postSet(51, string2, string);
    }

    public void setLogFileFormat(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"common", "extended"};
        string = LegalChecks.checkInEnum((String)"LogFileFormat", (String)string, (String[])stringArray);
        String string2 = this.getLogFileFormat();
        this._customizer.setLogFileFormat(string);
        this._postSet(11, string2, string);
    }

    public boolean getLogTimeInGMT() {
        return this._customizer.getLogTimeInGMT();
    }

    public boolean isLogTimeInGMTSet() {
        return this._isSet(12);
    }

    public void setLogTimeInGMT(boolean bl) {
        boolean bl2 = this.getLogTimeInGMT();
        this._customizer.setLogTimeInGMT(bl);
        this._postSet(12, bl2, bl);
    }

    public String getLogFileName() {
        return this._customizer.getLogFileName();
    }

    public boolean isLogFileNameSet() {
        return this._isSet(13);
    }

    public void setLogFileName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getLogFileName();
        this._customizer.setLogFileName(string);
        this._postSet(13, string2, string);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public String getLogRotationType() {
        return this._customizer.getLogRotationType();
    }

    public boolean isLogRotationTypeSet() {
        return this._isSet(19);
    }

    public void setLogRotationType(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"size", "date"};
        string = LegalChecks.checkInEnum((String)"LogRotationType", (String)string, (String[])stringArray);
        String string2 = this.getLogRotationType();
        this._customizer.setLogRotationType(string);
        this._postSet(19, string2, string);
    }

    public int getLogRotationPeriodMins() {
        return this._customizer.getLogRotationPeriodMins();
    }

    public boolean isLogRotationPeriodMinsSet() {
        return this._isSet(20);
    }

    public void setLogRotationPeriodMins(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LogRotationPeriodMins", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this.getLogRotationPeriodMins();
        try {
            this._customizer.setLogRotationPeriodMins(n);
        }
        catch (DistributedManagementException distributedManagementException) {
            throw new UndeclaredThrowableException(distributedManagementException);
        }
        this._postSet(20, n2, n);
    }

    public String getLogRotationTimeBegin() {
        return this._customizer.getLogRotationTimeBegin();
    }

    public boolean isLogRotationTimeBeginSet() {
        return this._isSet(23);
    }

    public void setLogRotationTimeBegin(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LoggingLegalHelper.validateWebServerLogRotationTimeBegin(string);
        String string2 = this.getLogRotationTimeBegin();
        this._customizer.setLogRotationTimeBegin(string);
        this._postSet(23, string2, string);
    }

    public boolean isLogFileLimitEnabled() {
        return this._customizer.isLogFileLimitEnabled();
    }

    public boolean isLogFileLimitEnabledSet() {
        return this._isSet(45);
    }

    public void setLogFileLimitEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isLogFileLimitEnabled();
        this._customizer.setLogFileLimitEnabled(bl);
        this._postSet(45, bl2, bl);
    }

    public int getLogFileCount() {
        return this._customizer.getLogFileCount();
    }

    public boolean isLogFileCountSet() {
        return this._isSet(46);
    }

    public void setLogFileCount(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LogFileCount", (long)n, (long)1L, (long)9999L);
        int n2 = this.getLogFileCount();
        this._customizer.setLogFileCount(n);
        this._postSet(46, n2, n);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 46;
        }
        try {
            switch (n) {
                case 46: {
                    this._customizer.setLogFileCount(7);
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setLogFileFormat("common");
                    if (bl) break;
                }
                case 13: {
                    this._customizer.setLogFileName("logs/access.log");
                    if (bl) break;
                }
                case 20: {
                    this._customizer.setLogRotationPeriodMins(1440);
                    if (bl) break;
                }
                case 23: {
                    this._customizer.setLogRotationTimeBegin(null);
                    if (bl) break;
                }
                case 19: {
                    this._customizer.setLogRotationType("size");
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setLogTimeInGMT(false);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 51: {
                    this._NetworkAccessPoint = null;
                    if (bl) break;
                }
                case 49: {
                    this._ServerNames = null;
                    if (bl) break;
                }
                case 50: {
                    this._VirtualHostNames = new String[0];
                    if (bl) break;
                }
                case 45: {
                    this._customizer.setLogFileLimitEnabled(false);
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setLoggingEnabled(true);
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "VirtualHost";
    }

    public void putValue(String string, Object object) {
        if (string.equals("LogFileCount")) {
            int n = this._LogFileCount;
            this._LogFileCount = (Integer)object;
            this._postSet(46, n, this._LogFileCount);
            return;
        }
        if (string.equals("LogFileFormat")) {
            String string2 = this._LogFileFormat;
            this._LogFileFormat = (String)object;
            this._postSet(11, string2, this._LogFileFormat);
            return;
        }
        if (string.equals("LogFileLimitEnabled")) {
            boolean bl = this._LogFileLimitEnabled;
            this._LogFileLimitEnabled = (Boolean)object;
            this._postSet(45, bl, this._LogFileLimitEnabled);
            return;
        }
        if (string.equals("LogFileName")) {
            String string3 = this._LogFileName;
            this._LogFileName = (String)object;
            this._postSet(13, string3, this._LogFileName);
            return;
        }
        if (string.equals("LogRotationPeriodMins")) {
            int n = this._LogRotationPeriodMins;
            this._LogRotationPeriodMins = (Integer)object;
            this._postSet(20, n, this._LogRotationPeriodMins);
            return;
        }
        if (string.equals("LogRotationTimeBegin")) {
            String string4 = this._LogRotationTimeBegin;
            this._LogRotationTimeBegin = (String)object;
            this._postSet(23, string4, this._LogRotationTimeBegin);
            return;
        }
        if (string.equals("LogRotationType")) {
            String string5 = this._LogRotationType;
            this._LogRotationType = (String)object;
            this._postSet(19, string5, this._LogRotationType);
            return;
        }
        if (string.equals("LogTimeInGMT")) {
            boolean bl = this._LogTimeInGMT;
            this._LogTimeInGMT = (Boolean)object;
            this._postSet(12, bl, this._LogTimeInGMT);
            return;
        }
        if (string.equals("LoggingEnabled")) {
            boolean bl = this._LoggingEnabled;
            this._LoggingEnabled = (Boolean)object;
            this._postSet(10, bl, this._LoggingEnabled);
            return;
        }
        if (string.equals("Name")) {
            String string6 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string6, this._Name);
            return;
        }
        if (string.equals("NetworkAccessPoint")) {
            String string7 = this._NetworkAccessPoint;
            this._NetworkAccessPoint = (String)object;
            this._postSet(51, string7, this._NetworkAccessPoint);
            return;
        }
        if (string.equals("ServerNames")) {
            Set set = this._ServerNames;
            this._ServerNames = (Set)object;
            this._postSet(49, set, this._ServerNames);
            return;
        }
        if (string.equals("VirtualHostNames")) {
            String[] stringArray = this._VirtualHostNames;
            this._VirtualHostNames = (String[])object;
            this._postSet(50, stringArray, this._VirtualHostNames);
            return;
        }
        if (string.equals("customizer")) {
            VirtualHost virtualHost = this._customizer;
            this._customizer = (VirtualHost)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("LogFileCount")) {
            return new Integer(this._LogFileCount);
        }
        if (string.equals("LogFileFormat")) {
            return this._LogFileFormat;
        }
        if (string.equals("LogFileLimitEnabled")) {
            return new Boolean(this._LogFileLimitEnabled);
        }
        if (string.equals("LogFileName")) {
            return this._LogFileName;
        }
        if (string.equals("LogRotationPeriodMins")) {
            return new Integer(this._LogRotationPeriodMins);
        }
        if (string.equals("LogRotationTimeBegin")) {
            return this._LogRotationTimeBegin;
        }
        if (string.equals("LogRotationType")) {
            return this._LogRotationType;
        }
        if (string.equals("LogTimeInGMT")) {
            return new Boolean(this._LogTimeInGMT);
        }
        if (string.equals("LoggingEnabled")) {
            return new Boolean(this._LoggingEnabled);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("NetworkAccessPoint")) {
            return this._NetworkAccessPoint;
        }
        if (string.equals("ServerNames")) {
            return this._ServerNames;
        }
        if (string.equals("VirtualHostNames")) {
            return this._VirtualHostNames;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends WebServerMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 14: {
                    if (string.equals("log-file-count")) {
                        return 46;
                    }
                    if (!string.equals("log-time-ingmt")) break;
                    return 12;
                }
                case 15: {
                    if (string.equals("log-file-format")) {
                        return 11;
                    }
                    if (!string.equals("logging-enabled")) break;
                    return 10;
                }
                case 13: {
                    if (!string.equals("log-file-name")) break;
                    return 13;
                }
                case 24: {
                    if (!string.equals("log-rotation-period-mins")) break;
                    return 20;
                }
                case 23: {
                    if (!string.equals("log-rotation-time-begin")) break;
                    return 23;
                }
                case 17: {
                    if (string.equals("log-rotation-type")) {
                        return 19;
                    }
                    if (!string.equals("virtual-host-name")) break;
                    return 50;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 20: {
                    if (!string.equals("network-access-point")) break;
                    return 51;
                }
                case 12: {
                    if (!string.equals("server-names")) break;
                    return 49;
                }
                case 22: {
                    if (!string.equals("log-file-limit-enabled")) break;
                    return 45;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 9: {
                    return new WebServerLogMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 46: {
                    return "log-file-count";
                }
                case 11: {
                    return "log-file-format";
                }
                case 13: {
                    return "log-file-name";
                }
                case 20: {
                    return "log-rotation-period-mins";
                }
                case 23: {
                    return "log-rotation-time-begin";
                }
                case 19: {
                    return "log-rotation-type";
                }
                case 12: {
                    return "log-time-ingmt";
                }
                case 2: {
                    return "name";
                }
                case 51: {
                    return "network-access-point";
                }
                case 49: {
                    return "server-names";
                }
                case 50: {
                    return "virtual-host-name";
                }
                case 45: {
                    return "log-file-limit-enabled";
                }
                case 10: {
                    return "logging-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
                case 50: {
                    return true;
                }
                case 44: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 9: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 48: {
                    return true;
                }
                case 32: {
                    return true;
                }
                case 31: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 16: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 17: {
                    return true;
                }
                case 22: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 20: {
                    return true;
                }
                case 23: {
                    return true;
                }
                case 19: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 18: {
                    return true;
                }
                case 21: {
                    return true;
                }
                case 50: {
                    return true;
                }
                case 47: {
                    return true;
                }
                case 38: {
                    return true;
                }
                case 35: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 37: {
                    return true;
                }
                case 36: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends WebServerMBeanImpl.Helper {
        private VirtualHostMBeanImpl bean;

        protected Helper(VirtualHostMBeanImpl virtualHostMBeanImpl) {
            super(virtualHostMBeanImpl);
            this.bean = virtualHostMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 46: {
                    return "LogFileCount";
                }
                case 11: {
                    return "LogFileFormat";
                }
                case 13: {
                    return "LogFileName";
                }
                case 20: {
                    return "LogRotationPeriodMins";
                }
                case 23: {
                    return "LogRotationTimeBegin";
                }
                case 19: {
                    return "LogRotationType";
                }
                case 12: {
                    return "LogTimeInGMT";
                }
                case 2: {
                    return "Name";
                }
                case 51: {
                    return "NetworkAccessPoint";
                }
                case 49: {
                    return "ServerNames";
                }
                case 50: {
                    return "VirtualHostNames";
                }
                case 45: {
                    return "LogFileLimitEnabled";
                }
                case 10: {
                    return "LoggingEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("LogFileCount")) {
                return 46;
            }
            if (string.equals("LogFileFormat")) {
                return 11;
            }
            if (string.equals("LogFileName")) {
                return 13;
            }
            if (string.equals("LogRotationPeriodMins")) {
                return 20;
            }
            if (string.equals("LogRotationTimeBegin")) {
                return 23;
            }
            if (string.equals("LogRotationType")) {
                return 19;
            }
            if (string.equals("LogTimeInGMT")) {
                return 12;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("NetworkAccessPoint")) {
                return 51;
            }
            if (string.equals("ServerNames")) {
                return 49;
            }
            if (string.equals("VirtualHostNames")) {
                return 50;
            }
            if (string.equals("LogFileLimitEnabled")) {
                return 45;
            }
            if (string.equals("LoggingEnabled")) {
                return 10;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            if (this.bean.getWebServerLog() != null) {
                arrayList.add(new ArrayIterator((Object[])new WebServerLogMBean[]{this.bean.getWebServerLog()}));
            }
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isLogFileCountSet()) {
                    stringBuffer.append("LogFileCount");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileCount()));
                }
                if (this.bean.isLogFileFormatSet()) {
                    stringBuffer.append("LogFileFormat");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileFormat()));
                }
                if (this.bean.isLogFileNameSet()) {
                    stringBuffer.append("LogFileName");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileName()));
                }
                if (this.bean.isLogRotationPeriodMinsSet()) {
                    stringBuffer.append("LogRotationPeriodMins");
                    stringBuffer.append(String.valueOf(this.bean.getLogRotationPeriodMins()));
                }
                if (this.bean.isLogRotationTimeBeginSet()) {
                    stringBuffer.append("LogRotationTimeBegin");
                    stringBuffer.append(String.valueOf(this.bean.getLogRotationTimeBegin()));
                }
                if (this.bean.isLogRotationTypeSet()) {
                    stringBuffer.append("LogRotationType");
                    stringBuffer.append(String.valueOf(this.bean.getLogRotationType()));
                }
                if (this.bean.isLogTimeInGMTSet()) {
                    stringBuffer.append("LogTimeInGMT");
                    stringBuffer.append(String.valueOf(this.bean.getLogTimeInGMT()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isNetworkAccessPointSet()) {
                    stringBuffer.append("NetworkAccessPoint");
                    stringBuffer.append(String.valueOf(this.bean.getNetworkAccessPoint()));
                }
                if (this.bean.isServerNamesSet()) {
                    stringBuffer.append("ServerNames");
                    stringBuffer.append(String.valueOf(this.bean.getServerNames()));
                }
                if (this.bean.isVirtualHostNamesSet()) {
                    stringBuffer.append("VirtualHostNames");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getVirtualHostNames())));
                }
                if (this.bean.isLogFileLimitEnabledSet()) {
                    stringBuffer.append("LogFileLimitEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isLogFileLimitEnabled()));
                }
                if (this.bean.isLoggingEnabledSet()) {
                    stringBuffer.append("LoggingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isLoggingEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                VirtualHostMBeanImpl virtualHostMBeanImpl = (VirtualHostMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogFileCount", this.bean.getLogFileCount(), virtualHostMBeanImpl.getLogFileCount(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogFileFormat", this.bean.getLogFileFormat(), virtualHostMBeanImpl.getLogFileFormat(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogFileName", this.bean.getLogFileName(), virtualHostMBeanImpl.getLogFileName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogRotationPeriodMins", this.bean.getLogRotationPeriodMins(), virtualHostMBeanImpl.getLogRotationPeriodMins(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogRotationTimeBegin", this.bean.getLogRotationTimeBegin(), virtualHostMBeanImpl.getLogRotationTimeBegin(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogRotationType", this.bean.getLogRotationType(), virtualHostMBeanImpl.getLogRotationType(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogTimeInGMT", this.bean.getLogTimeInGMT(), virtualHostMBeanImpl.getLogTimeInGMT(), false);
                }
                this.computeDiff("Name", this.bean.getName(), virtualHostMBeanImpl.getName(), false);
                this.computeDiff("NetworkAccessPoint", this.bean.getNetworkAccessPoint(), virtualHostMBeanImpl.getNetworkAccessPoint(), false);
                this.computeDiff("VirtualHostNames", this.bean.getVirtualHostNames(), virtualHostMBeanImpl.getVirtualHostNames(), false);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogFileLimitEnabled", this.bean.isLogFileLimitEnabled(), virtualHostMBeanImpl.isLogFileLimitEnabled(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LoggingEnabled", this.bean.isLoggingEnabled(), virtualHostMBeanImpl.isLoggingEnabled(), false);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                VirtualHostMBeanImpl virtualHostMBeanImpl = (VirtualHostMBeanImpl)beanUpdateEvent.getSourceBean();
                VirtualHostMBeanImpl virtualHostMBeanImpl2 = (VirtualHostMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("LogFileCount")) {
                    virtualHostMBeanImpl.setLogFileCount(virtualHostMBeanImpl2.getLogFileCount());
                    virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 46);
                } else if (string.equals("LogFileFormat")) {
                    virtualHostMBeanImpl.setLogFileFormat(virtualHostMBeanImpl2.getLogFileFormat());
                    virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("LogFileName")) {
                    virtualHostMBeanImpl.setLogFileName(virtualHostMBeanImpl2.getLogFileName());
                    virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("LogRotationPeriodMins")) {
                    virtualHostMBeanImpl.setLogRotationPeriodMins(virtualHostMBeanImpl2.getLogRotationPeriodMins());
                    virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("LogRotationTimeBegin")) {
                    virtualHostMBeanImpl.setLogRotationTimeBegin(virtualHostMBeanImpl2.getLogRotationTimeBegin());
                    virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("LogRotationType")) {
                    virtualHostMBeanImpl.setLogRotationType(virtualHostMBeanImpl2.getLogRotationType());
                    virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("LogTimeInGMT")) {
                    virtualHostMBeanImpl.setLogTimeInGMT(virtualHostMBeanImpl2.getLogTimeInGMT());
                    virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("Name")) {
                    virtualHostMBeanImpl.setName(virtualHostMBeanImpl2.getName());
                    virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("NetworkAccessPoint")) {
                    virtualHostMBeanImpl.setNetworkAccessPoint(virtualHostMBeanImpl2.getNetworkAccessPoint());
                    virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 51);
                } else if (!string.equals("ServerNames")) {
                    if (string.equals("VirtualHostNames")) {
                        virtualHostMBeanImpl.setVirtualHostNames(virtualHostMBeanImpl2.getVirtualHostNames());
                        virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 50);
                    } else if (string.equals("LogFileLimitEnabled")) {
                        virtualHostMBeanImpl.setLogFileLimitEnabled(virtualHostMBeanImpl2.isLogFileLimitEnabled());
                        virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 45);
                    } else if (string.equals("LoggingEnabled")) {
                        virtualHostMBeanImpl.setLoggingEnabled(virtualHostMBeanImpl2.isLoggingEnabled());
                        virtualHostMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                VirtualHostMBeanImpl virtualHostMBeanImpl = (VirtualHostMBeanImpl)abstractDescriptorBean;
                super.finishCopy(virtualHostMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("LogFileCount")) && this.bean.isLogFileCountSet()) {
                    virtualHostMBeanImpl.setLogFileCount(this.bean.getLogFileCount());
                }
                if (bl && (list == null || !list.contains("LogFileFormat")) && this.bean.isLogFileFormatSet()) {
                    virtualHostMBeanImpl.setLogFileFormat(this.bean.getLogFileFormat());
                }
                if (bl && (list == null || !list.contains("LogFileName")) && this.bean.isLogFileNameSet()) {
                    virtualHostMBeanImpl.setLogFileName(this.bean.getLogFileName());
                }
                if (bl && (list == null || !list.contains("LogRotationPeriodMins")) && this.bean.isLogRotationPeriodMinsSet()) {
                    virtualHostMBeanImpl.setLogRotationPeriodMins(this.bean.getLogRotationPeriodMins());
                }
                if (bl && (list == null || !list.contains("LogRotationTimeBegin")) && this.bean.isLogRotationTimeBeginSet()) {
                    virtualHostMBeanImpl.setLogRotationTimeBegin(this.bean.getLogRotationTimeBegin());
                }
                if (bl && (list == null || !list.contains("LogRotationType")) && this.bean.isLogRotationTypeSet()) {
                    virtualHostMBeanImpl.setLogRotationType(this.bean.getLogRotationType());
                }
                if (bl && (list == null || !list.contains("LogTimeInGMT")) && this.bean.isLogTimeInGMTSet()) {
                    virtualHostMBeanImpl.setLogTimeInGMT(this.bean.getLogTimeInGMT());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    virtualHostMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("NetworkAccessPoint")) && this.bean.isNetworkAccessPointSet()) {
                    virtualHostMBeanImpl.setNetworkAccessPoint(this.bean.getNetworkAccessPoint());
                }
                if ((list == null || !list.contains("VirtualHostNames")) && this.bean.isVirtualHostNamesSet()) {
                    String[] stringArray = this.bean.getVirtualHostNames();
                    virtualHostMBeanImpl.setVirtualHostNames(stringArray == null ? null : (String[])stringArray.clone());
                }
                if (bl && (list == null || !list.contains("LogFileLimitEnabled")) && this.bean.isLogFileLimitEnabledSet()) {
                    virtualHostMBeanImpl.setLogFileLimitEnabled(this.bean.isLogFileLimitEnabled());
                }
                if (bl && (list == null || !list.contains("LoggingEnabled")) && this.bean.isLoggingEnabledSet()) {
                    virtualHostMBeanImpl.setLoggingEnabled(this.bean.isLoggingEnabled());
                }
                return virtualHostMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

