/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.WLDFDataRetirementMBean;
import weblogic.management.configuration.WLDFValidator;
import weblogic.utils.collections.CombinedIterator;

public class WLDFDataRetirementMBeanImpl
extends ConfigurationMBeanImpl
implements WLDFDataRetirementMBean,
Serializable {
    private String _ArchiveName;
    private boolean _Enabled;
    private int _RetirementPeriod;
    private int _RetirementTime;
    private static SchemaHelper2 _schemaHelper;

    public WLDFDataRetirementMBeanImpl() {
        this._initializeProperty(-1);
    }

    public WLDFDataRetirementMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public boolean isEnabled() {
        return this._Enabled;
    }

    public boolean isEnabledSet() {
        return this._isSet(7);
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this._Enabled;
        this._Enabled = bl;
        this._postSet(7, bl2, bl);
    }

    public String getArchiveName() {
        return this._ArchiveName;
    }

    public boolean isArchiveNameSet() {
        return this._isSet(8);
    }

    public void setArchiveName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        WLDFValidator.validateDataRetirementArchiveName(this, string);
        String string2 = this._ArchiveName;
        this._ArchiveName = string;
        this._postSet(8, string2, string);
    }

    public int getRetirementTime() {
        return this._RetirementTime;
    }

    public boolean isRetirementTimeSet() {
        return this._isSet(9);
    }

    public void setRetirementTime(int n) {
        WLDFValidator.validateDataRetirementTime(this, n);
        int n2 = this._RetirementTime;
        this._RetirementTime = n;
        this._postSet(9, n2, n);
    }

    public int getRetirementPeriod() {
        return this._RetirementPeriod;
    }

    public boolean isRetirementPeriodSet() {
        return this._isSet(10);
    }

    public void setRetirementPeriod(int n) {
        LegalChecks.checkMin((String)"RetirementPeriod", (int)n, (int)1);
        int n2 = this._RetirementPeriod;
        this._RetirementPeriod = n;
        this._postSet(10, n2, n);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 8;
        }
        try {
            switch (n) {
                case 8: {
                    this._ArchiveName = null;
                    if (bl) break;
                }
                case 10: {
                    this._RetirementPeriod = 24;
                    if (bl) break;
                }
                case 9: {
                    this._RetirementTime = 0;
                    if (bl) break;
                }
                case 7: {
                    this._Enabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "WLDFDataRetirement";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ArchiveName")) {
            String string2 = this._ArchiveName;
            this._ArchiveName = (String)object;
            this._postSet(8, string2, this._ArchiveName);
            return;
        }
        if (string.equals("Enabled")) {
            boolean bl = this._Enabled;
            this._Enabled = (Boolean)object;
            this._postSet(7, bl, this._Enabled);
            return;
        }
        if (string.equals("RetirementPeriod")) {
            int n = this._RetirementPeriod;
            this._RetirementPeriod = (Integer)object;
            this._postSet(10, n, this._RetirementPeriod);
            return;
        }
        if (string.equals("RetirementTime")) {
            int n = this._RetirementTime;
            this._RetirementTime = (Integer)object;
            this._postSet(9, n, this._RetirementTime);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ArchiveName")) {
            return this._ArchiveName;
        }
        if (string.equals("Enabled")) {
            return new Boolean(this._Enabled);
        }
        if (string.equals("RetirementPeriod")) {
            return new Integer(this._RetirementPeriod);
        }
        if (string.equals("RetirementTime")) {
            return new Integer(this._RetirementTime);
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 12: {
                    if (!string.equals("archive-name")) break;
                    return 8;
                }
                case 17: {
                    if (!string.equals("retirement-period")) break;
                    return 10;
                }
                case 15: {
                    if (!string.equals("retirement-time")) break;
                    return 9;
                }
                case 7: {
                    if (!string.equals("enabled")) break;
                    return 7;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 8: {
                    return "archive-name";
                }
                case 10: {
                    return "retirement-period";
                }
                case 9: {
                    return "retirement-time";
                }
                case 7: {
                    return "enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private WLDFDataRetirementMBeanImpl bean;

        protected Helper(WLDFDataRetirementMBeanImpl wLDFDataRetirementMBeanImpl) {
            super(wLDFDataRetirementMBeanImpl);
            this.bean = wLDFDataRetirementMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 8: {
                    return "ArchiveName";
                }
                case 10: {
                    return "RetirementPeriod";
                }
                case 9: {
                    return "RetirementTime";
                }
                case 7: {
                    return "Enabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ArchiveName")) {
                return 8;
            }
            if (string.equals("RetirementPeriod")) {
                return 10;
            }
            if (string.equals("RetirementTime")) {
                return 9;
            }
            if (string.equals("Enabled")) {
                return 7;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isArchiveNameSet()) {
                    stringBuffer.append("ArchiveName");
                    stringBuffer.append(String.valueOf(this.bean.getArchiveName()));
                }
                if (this.bean.isRetirementPeriodSet()) {
                    stringBuffer.append("RetirementPeriod");
                    stringBuffer.append(String.valueOf(this.bean.getRetirementPeriod()));
                }
                if (this.bean.isRetirementTimeSet()) {
                    stringBuffer.append("RetirementTime");
                    stringBuffer.append(String.valueOf(this.bean.getRetirementTime()));
                }
                if (this.bean.isEnabledSet()) {
                    stringBuffer.append("Enabled");
                    stringBuffer.append(String.valueOf(this.bean.isEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WLDFDataRetirementMBeanImpl wLDFDataRetirementMBeanImpl = (WLDFDataRetirementMBeanImpl)abstractDescriptorBean;
                this.computeDiff("ArchiveName", this.bean.getArchiveName(), wLDFDataRetirementMBeanImpl.getArchiveName(), true);
                this.computeDiff("RetirementPeriod", this.bean.getRetirementPeriod(), wLDFDataRetirementMBeanImpl.getRetirementPeriod(), true);
                this.computeDiff("RetirementTime", this.bean.getRetirementTime(), wLDFDataRetirementMBeanImpl.getRetirementTime(), true);
                this.computeDiff("Enabled", this.bean.isEnabled(), wLDFDataRetirementMBeanImpl.isEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WLDFDataRetirementMBeanImpl wLDFDataRetirementMBeanImpl = (WLDFDataRetirementMBeanImpl)beanUpdateEvent.getSourceBean();
                WLDFDataRetirementMBeanImpl wLDFDataRetirementMBeanImpl2 = (WLDFDataRetirementMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("ArchiveName")) {
                    wLDFDataRetirementMBeanImpl.setArchiveName(wLDFDataRetirementMBeanImpl2.getArchiveName());
                    wLDFDataRetirementMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("RetirementPeriod")) {
                    wLDFDataRetirementMBeanImpl.setRetirementPeriod(wLDFDataRetirementMBeanImpl2.getRetirementPeriod());
                    wLDFDataRetirementMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("RetirementTime")) {
                    wLDFDataRetirementMBeanImpl.setRetirementTime(wLDFDataRetirementMBeanImpl2.getRetirementTime());
                    wLDFDataRetirementMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("Enabled")) {
                    wLDFDataRetirementMBeanImpl.setEnabled(wLDFDataRetirementMBeanImpl2.isEnabled());
                    wLDFDataRetirementMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                WLDFDataRetirementMBeanImpl wLDFDataRetirementMBeanImpl = (WLDFDataRetirementMBeanImpl)abstractDescriptorBean;
                super.finishCopy(wLDFDataRetirementMBeanImpl, bl, list);
                if ((list == null || !list.contains("ArchiveName")) && this.bean.isArchiveNameSet()) {
                    wLDFDataRetirementMBeanImpl.setArchiveName(this.bean.getArchiveName());
                }
                if ((list == null || !list.contains("RetirementPeriod")) && this.bean.isRetirementPeriodSet()) {
                    wLDFDataRetirementMBeanImpl.setRetirementPeriod(this.bean.getRetirementPeriod());
                }
                if ((list == null || !list.contains("RetirementTime")) && this.bean.isRetirementTimeSet()) {
                    wLDFDataRetirementMBeanImpl.setRetirementTime(this.bean.getRetirementTime());
                }
                if ((list == null || !list.contains("Enabled")) && this.bean.isEnabledSet()) {
                    wLDFDataRetirementMBeanImpl.setEnabled(this.bean.isEnabled());
                }
                return wLDFDataRetirementMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

