/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.WLDFDataRetirementByAgeMBean;
import weblogic.management.configuration.WLDFDataRetirementByAgeMBeanImpl;
import weblogic.management.configuration.WLDFDataRetirementMBean;
import weblogic.management.configuration.WLDFDataRetirementMBeanImpl;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.mbeans.custom.WLDFServerDiagnostic;
import weblogic.utils.ArrayUtils;
import weblogic.utils.PlatformConstants;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class WLDFServerDiagnosticMBeanImpl
extends ConfigurationMBeanImpl
implements WLDFServerDiagnosticMBean,
Serializable {
    private boolean _DataRetirementEnabled;
    private boolean _DataRetirementTestModeEnabled;
    private boolean _DiagnosticContextEnabled;
    private String _DiagnosticDataArchiveType;
    private JDBCSystemResourceMBean _DiagnosticJDBCResource;
    private int _DiagnosticStoreBlockSize;
    private String _DiagnosticStoreDir;
    private boolean _DiagnosticStoreFileLockingEnabled;
    private int _DiagnosticStoreIoBufferSize;
    private long _DiagnosticStoreMaxFileSize;
    private int _DiagnosticStoreMaxWindowBufferSize;
    private int _DiagnosticStoreMinWindowBufferSize;
    private long _EventPersistenceInterval;
    private long _EventsImageCaptureInterval;
    private String _ImageDir;
    private int _ImageTimeout;
    private String _Name;
    private int _PreferredStoreSizeLimit;
    private int _StoreSizeCheckPeriod;
    private boolean _SynchronousEventPersistenceEnabled;
    private WLDFDataRetirementByAgeMBean[] _WLDFDataRetirementByAges;
    private WLDFDataRetirementMBean[] _WLDFDataRetirements;
    private String _WLDFDiagnosticVolume;
    private WLDFServerDiagnostic _customizer;
    private static SchemaHelper2 _schemaHelper;

    public WLDFServerDiagnosticMBeanImpl() {
        try {
            this._customizer = new WLDFServerDiagnostic(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public WLDFServerDiagnosticMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new WLDFServerDiagnostic(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getImageDir() {
        if (!this._isSet(7)) {
            try {
                return "logs" + PlatformConstants.FILE_SEP + "diagnostic_images";
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._ImageDir;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isImageDirSet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setImageDir(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ImageDir;
        this._ImageDir = string;
        this._postSet(7, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public int getImageTimeout() {
        return this._ImageTimeout;
    }

    public boolean isImageTimeoutSet() {
        return this._isSet(8);
    }

    public void setImageTimeout(int n) {
        LegalChecks.checkInRange((String)"ImageTimeout", (long)n, (long)0L, (long)1440L);
        int n2 = this._ImageTimeout;
        this._ImageTimeout = n;
        this._postSet(8, n2, n);
    }

    public long getEventsImageCaptureInterval() {
        return this._EventsImageCaptureInterval;
    }

    public boolean isEventsImageCaptureIntervalSet() {
        return this._isSet(9);
    }

    public void setEventsImageCaptureInterval(long l) {
        long l2 = this._EventsImageCaptureInterval;
        this._EventsImageCaptureInterval = l;
        this._postSet(9, l2, l);
    }

    public String getDiagnosticStoreDir() {
        return this._DiagnosticStoreDir;
    }

    public boolean isDiagnosticStoreDirSet() {
        return this._isSet(10);
    }

    public void setDiagnosticStoreDir(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._DiagnosticStoreDir;
        this._DiagnosticStoreDir = string;
        this._postSet(10, string2, string);
    }

    public boolean isDiagnosticStoreFileLockingEnabled() {
        return this._DiagnosticStoreFileLockingEnabled;
    }

    public boolean isDiagnosticStoreFileLockingEnabledSet() {
        return this._isSet(11);
    }

    public void setDiagnosticStoreFileLockingEnabled(boolean bl) {
        boolean bl2 = this._DiagnosticStoreFileLockingEnabled;
        this._DiagnosticStoreFileLockingEnabled = bl;
        this._postSet(11, bl2, bl);
    }

    public int getDiagnosticStoreMinWindowBufferSize() {
        return this._DiagnosticStoreMinWindowBufferSize;
    }

    public boolean isDiagnosticStoreMinWindowBufferSizeSet() {
        return this._isSet(12);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setDiagnosticStoreMinWindowBufferSize(int n) {
        LegalChecks.checkInRange((String)"DiagnosticStoreMinWindowBufferSize", (long)n, (long)-1L, (long)0x40000000L);
        int n2 = this._DiagnosticStoreMinWindowBufferSize;
        this._DiagnosticStoreMinWindowBufferSize = n;
        this._postSet(12, n2, n);
    }

    public int getDiagnosticStoreMaxWindowBufferSize() {
        return this._DiagnosticStoreMaxWindowBufferSize;
    }

    public boolean isDiagnosticStoreMaxWindowBufferSizeSet() {
        return this._isSet(13);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setDiagnosticStoreMaxWindowBufferSize(int n) {
        LegalChecks.checkInRange((String)"DiagnosticStoreMaxWindowBufferSize", (long)n, (long)-1L, (long)0x40000000L);
        int n2 = this._DiagnosticStoreMaxWindowBufferSize;
        this._DiagnosticStoreMaxWindowBufferSize = n;
        this._postSet(13, n2, n);
    }

    public int getDiagnosticStoreIoBufferSize() {
        return this._DiagnosticStoreIoBufferSize;
    }

    public boolean isDiagnosticStoreIoBufferSizeSet() {
        return this._isSet(14);
    }

    public void setDiagnosticStoreIoBufferSize(int n) {
        LegalChecks.checkInRange((String)"DiagnosticStoreIoBufferSize", (long)n, (long)-1L, (long)0x4000000L);
        int n2 = this._DiagnosticStoreIoBufferSize;
        this._DiagnosticStoreIoBufferSize = n;
        this._postSet(14, n2, n);
    }

    public long getDiagnosticStoreMaxFileSize() {
        return this._DiagnosticStoreMaxFileSize;
    }

    public boolean isDiagnosticStoreMaxFileSizeSet() {
        return this._isSet(15);
    }

    public void setDiagnosticStoreMaxFileSize(long l) {
        LegalChecks.checkMin((String)"DiagnosticStoreMaxFileSize", (long)l, (long)0xA00000L);
        long l2 = this._DiagnosticStoreMaxFileSize;
        this._DiagnosticStoreMaxFileSize = l;
        this._postSet(15, l2, l);
    }

    public int getDiagnosticStoreBlockSize() {
        return this._DiagnosticStoreBlockSize;
    }

    public boolean isDiagnosticStoreBlockSizeSet() {
        return this._isSet(16);
    }

    public void setDiagnosticStoreBlockSize(int n) {
        LegalChecks.checkInRange((String)"DiagnosticStoreBlockSize", (long)n, (long)-1L, (long)8192L);
        int n2 = this._DiagnosticStoreBlockSize;
        this._DiagnosticStoreBlockSize = n;
        this._postSet(16, n2, n);
    }

    public String getDiagnosticDataArchiveType() {
        return this._DiagnosticDataArchiveType;
    }

    public boolean isDiagnosticDataArchiveTypeSet() {
        return this._isSet(17);
    }

    public void setDiagnosticDataArchiveType(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"FileStoreArchive", "JDBCArchive"};
        string = LegalChecks.checkInEnum((String)"DiagnosticDataArchiveType", (String)string, (String[])stringArray);
        String string2 = this._DiagnosticDataArchiveType;
        this._DiagnosticDataArchiveType = string;
        this._postSet(17, string2, string);
    }

    public JDBCSystemResourceMBean getDiagnosticJDBCResource() {
        return this._DiagnosticJDBCResource;
    }

    public String getDiagnosticJDBCResourceAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDiagnosticJDBCResource();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDiagnosticJDBCResourceSet() {
        return this._isSet(18);
    }

    public void setDiagnosticJDBCResourceAsString(String string) {
        if (string == null || string.length() == 0) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._DiagnosticJDBCResource;
            this._initializeProperty(18);
            this._postSet(18, jDBCSystemResourceMBean, this._DiagnosticJDBCResource);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, JDBCSystemResourceMBean.class, new ReferenceManager.Resolver(this, 18){

                public void resolveReference(Object object) {
                    try {
                        WLDFServerDiagnosticMBeanImpl.this.setDiagnosticJDBCResource((JDBCSystemResourceMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setDiagnosticJDBCResource(JDBCSystemResourceMBean jDBCSystemResourceMBean) {
        JDBCSystemResourceMBean jDBCSystemResourceMBean2;
        if (jDBCSystemResourceMBean != null) {
            jDBCSystemResourceMBean2 = new ResolvedReference(this, 18, (AbstractDescriptorBean)jDBCSystemResourceMBean){

                protected Object getPropertyValue() {
                    return WLDFServerDiagnosticMBeanImpl.this.getDiagnosticJDBCResource();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)jDBCSystemResourceMBean, (ResolvedReference)jDBCSystemResourceMBean2);
        }
        jDBCSystemResourceMBean2 = this._DiagnosticJDBCResource;
        this._DiagnosticJDBCResource = jDBCSystemResourceMBean;
        this._postSet(18, jDBCSystemResourceMBean2, jDBCSystemResourceMBean);
    }

    public boolean isSynchronousEventPersistenceEnabled() {
        return this._SynchronousEventPersistenceEnabled;
    }

    public boolean isSynchronousEventPersistenceEnabledSet() {
        return this._isSet(19);
    }

    public void setSynchronousEventPersistenceEnabled(boolean bl) {
        boolean bl2 = this._SynchronousEventPersistenceEnabled;
        this._SynchronousEventPersistenceEnabled = bl;
        this._postSet(19, bl2, bl);
    }

    public long getEventPersistenceInterval() {
        return this._EventPersistenceInterval;
    }

    public boolean isEventPersistenceIntervalSet() {
        return this._isSet(20);
    }

    public void setEventPersistenceInterval(long l) {
        long l2 = this._EventPersistenceInterval;
        this._EventPersistenceInterval = l;
        this._postSet(20, l2, l);
    }

    public boolean isDiagnosticContextEnabled() {
        return this._DiagnosticContextEnabled;
    }

    public boolean isDiagnosticContextEnabledSet() {
        return this._isSet(21);
    }

    public void setDiagnosticContextEnabled(boolean bl) {
        boolean bl2 = this._DiagnosticContextEnabled;
        this._DiagnosticContextEnabled = bl;
        this._postSet(21, bl2, bl);
    }

    public boolean isDataRetirementTestModeEnabled() {
        return this._DataRetirementTestModeEnabled;
    }

    public boolean isDataRetirementTestModeEnabledSet() {
        return this._isSet(22);
    }

    public void setDataRetirementTestModeEnabled(boolean bl) {
        boolean bl2 = this._DataRetirementTestModeEnabled;
        this._DataRetirementTestModeEnabled = bl;
        this._postSet(22, bl2, bl);
    }

    public boolean isDataRetirementEnabled() {
        return this._DataRetirementEnabled;
    }

    public boolean isDataRetirementEnabledSet() {
        return this._isSet(23);
    }

    public void setDataRetirementEnabled(boolean bl) {
        boolean bl2 = this._DataRetirementEnabled;
        this._DataRetirementEnabled = bl;
        this._postSet(23, bl2, bl);
    }

    public int getPreferredStoreSizeLimit() {
        return this._PreferredStoreSizeLimit;
    }

    public boolean isPreferredStoreSizeLimitSet() {
        return this._isSet(24);
    }

    public void setPreferredStoreSizeLimit(int n) {
        LegalChecks.checkMin((String)"PreferredStoreSizeLimit", (int)n, (int)10);
        int n2 = this._PreferredStoreSizeLimit;
        this._PreferredStoreSizeLimit = n;
        this._postSet(24, n2, n);
    }

    public int getStoreSizeCheckPeriod() {
        return this._StoreSizeCheckPeriod;
    }

    public boolean isStoreSizeCheckPeriodSet() {
        return this._isSet(25);
    }

    public void setStoreSizeCheckPeriod(int n) {
        LegalChecks.checkMin((String)"StoreSizeCheckPeriod", (int)n, (int)1);
        int n2 = this._StoreSizeCheckPeriod;
        this._StoreSizeCheckPeriod = n;
        this._postSet(25, n2, n);
    }

    public void addWLDFDataRetirement(WLDFDataRetirementMBean wLDFDataRetirementMBean) {
        this._getHelper()._ensureNonNull((Object)wLDFDataRetirementMBean);
        if (!((AbstractDescriptorBean)wLDFDataRetirementMBean).isChildProperty((DescriptorBean)this, 26)) {
            WLDFDataRetirementMBean[] wLDFDataRetirementMBeanArray = (WLDFDataRetirementMBean[])this._getHelper()._extendArray((Object)this.getWLDFDataRetirements(), WLDFDataRetirementMBean.class, (Object)wLDFDataRetirementMBean);
            try {
                this.setWLDFDataRetirements(wLDFDataRetirementMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFDataRetirementMBean[] getWLDFDataRetirements() {
        return this._customizer.getWLDFDataRetirements();
    }

    public boolean isWLDFDataRetirementsSet() {
        return this._isSet(26);
    }

    public void removeWLDFDataRetirement(WLDFDataRetirementMBean wLDFDataRetirementMBean) {
        WLDFDataRetirementMBean[] wLDFDataRetirementMBeanArray = this.getWLDFDataRetirements();
        WLDFDataRetirementMBean[] wLDFDataRetirementMBeanArray2 = (WLDFDataRetirementMBean[])this._getHelper()._removeElement((Object)wLDFDataRetirementMBeanArray, WLDFDataRetirementMBean.class, (Object)wLDFDataRetirementMBean);
        if (wLDFDataRetirementMBeanArray2.length != wLDFDataRetirementMBeanArray.length) {
            try {
                this.setWLDFDataRetirements(wLDFDataRetirementMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setWLDFDataRetirements(WLDFDataRetirementMBean[] wLDFDataRetirementMBeanArray) throws InvalidAttributeValueException {
        wLDFDataRetirementMBeanArray = wLDFDataRetirementMBeanArray == null ? new WLDFDataRetirementMBeanImpl[]{} : wLDFDataRetirementMBeanArray;
        this._WLDFDataRetirements = wLDFDataRetirementMBeanArray;
    }

    public WLDFDataRetirementMBean lookupWLDFDataRetirement(String string) {
        return this._customizer.lookupWLDFDataRetirement(string);
    }

    public void addWLDFDataRetirementByAge(WLDFDataRetirementByAgeMBean wLDFDataRetirementByAgeMBean) {
        this._getHelper()._ensureNonNull((Object)wLDFDataRetirementByAgeMBean);
        if (!((AbstractDescriptorBean)wLDFDataRetirementByAgeMBean).isChildProperty((DescriptorBean)this, 27)) {
            WLDFDataRetirementByAgeMBean[] wLDFDataRetirementByAgeMBeanArray = this._isSet(27) ? (WLDFDataRetirementByAgeMBean[])this._getHelper()._extendArray((Object)this.getWLDFDataRetirementByAges(), WLDFDataRetirementByAgeMBean.class, (Object)wLDFDataRetirementByAgeMBean) : new WLDFDataRetirementByAgeMBean[]{wLDFDataRetirementByAgeMBean};
            try {
                this.setWLDFDataRetirementByAges(wLDFDataRetirementByAgeMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFDataRetirementByAgeMBean[] getWLDFDataRetirementByAges() {
        return this._WLDFDataRetirementByAges;
    }

    public boolean isWLDFDataRetirementByAgesSet() {
        return this._isSet(27);
    }

    public void removeWLDFDataRetirementByAge(WLDFDataRetirementByAgeMBean wLDFDataRetirementByAgeMBean) {
        this.destroyWLDFDataRetirementByAge(wLDFDataRetirementByAgeMBean);
    }

    public void setWLDFDataRetirementByAges(WLDFDataRetirementByAgeMBean[] wLDFDataRetirementByAgeMBeanArray) throws InvalidAttributeValueException {
        wLDFDataRetirementByAgeMBeanArray = wLDFDataRetirementByAgeMBeanArray == null ? new WLDFDataRetirementByAgeMBeanImpl[]{} : wLDFDataRetirementByAgeMBeanArray;
        for (int i = 0; i < wLDFDataRetirementByAgeMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFDataRetirementByAgeMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 27)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        WLDFDataRetirementByAgeMBean[] wLDFDataRetirementByAgeMBeanArray2 = this._WLDFDataRetirementByAges;
        this._WLDFDataRetirementByAges = wLDFDataRetirementByAgeMBeanArray;
        this._postSet(27, wLDFDataRetirementByAgeMBeanArray2, wLDFDataRetirementByAgeMBeanArray);
    }

    public WLDFDataRetirementByAgeMBean createWLDFDataRetirementByAge(String string) {
        WLDFDataRetirementByAgeMBeanImpl wLDFDataRetirementByAgeMBeanImpl = new WLDFDataRetirementByAgeMBeanImpl(this, -1);
        try {
            wLDFDataRetirementByAgeMBeanImpl.setName(string);
            this.addWLDFDataRetirementByAge(wLDFDataRetirementByAgeMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return wLDFDataRetirementByAgeMBeanImpl;
    }

    public void destroyWLDFDataRetirementByAge(WLDFDataRetirementByAgeMBean wLDFDataRetirementByAgeMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(wLDFDataRetirementByAgeMBean, 27);
                WLDFDataRetirementByAgeMBean[] wLDFDataRetirementByAgeMBeanArray = this.getWLDFDataRetirementByAges();
                WLDFDataRetirementByAgeMBean[] wLDFDataRetirementByAgeMBeanArray2 = (WLDFDataRetirementByAgeMBean[])this._getHelper()._removeElement((Object)wLDFDataRetirementByAgeMBeanArray, WLDFDataRetirementByAgeMBean.class, (Object)wLDFDataRetirementByAgeMBean);
                if (wLDFDataRetirementByAgeMBeanArray.length == wLDFDataRetirementByAgeMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)wLDFDataRetirementByAgeMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)wLDFDataRetirementByAgeMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setWLDFDataRetirementByAges(wLDFDataRetirementByAgeMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public WLDFDataRetirementByAgeMBean lookupWLDFDataRetirementByAge(String string) {
        for (WLDFDataRetirementByAgeMBeanImpl wLDFDataRetirementByAgeMBeanImpl : Arrays.asList((Object[])this._WLDFDataRetirementByAges)) {
            String string2 = string;
            if (!wLDFDataRetirementByAgeMBeanImpl.getName().equals(string2)) continue;
            return wLDFDataRetirementByAgeMBeanImpl;
        }
        return null;
    }

    public String getWLDFDiagnosticVolume() {
        return this._WLDFDiagnosticVolume;
    }

    public boolean isWLDFDiagnosticVolumeSet() {
        return this._isSet(28);
    }

    public void setWLDFDiagnosticVolume(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Off", "Low", "Medium", "High"};
        string = LegalChecks.checkInEnum((String)"WLDFDiagnosticVolume", (String)string, (String[])stringArray);
        String string2 = this._WLDFDiagnosticVolume;
        this._WLDFDiagnosticVolume = string;
        this._postSet(28, string2, string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 17;
        }
        try {
            switch (n) {
                case 17: {
                    this._DiagnosticDataArchiveType = "FileStoreArchive";
                    if (bl) break;
                }
                case 18: {
                    this._DiagnosticJDBCResource = null;
                    if (bl) break;
                }
                case 16: {
                    this._DiagnosticStoreBlockSize = -1;
                    if (bl) break;
                }
                case 10: {
                    this._DiagnosticStoreDir = "data/store/diagnostics";
                    if (bl) break;
                }
                case 14: {
                    this._DiagnosticStoreIoBufferSize = -1;
                    if (bl) break;
                }
                case 15: {
                    this._DiagnosticStoreMaxFileSize = 0x50000000L;
                    if (bl) break;
                }
                case 13: {
                    this._DiagnosticStoreMaxWindowBufferSize = -1;
                    if (bl) break;
                }
                case 12: {
                    this._DiagnosticStoreMinWindowBufferSize = -1;
                    if (bl) break;
                }
                case 20: {
                    this._EventPersistenceInterval = 5000L;
                    if (bl) break;
                }
                case 9: {
                    this._EventsImageCaptureInterval = 60000L;
                    if (bl) break;
                }
                case 7: {
                    this._ImageDir = null;
                    if (bl) break;
                }
                case 8: {
                    this._ImageTimeout = 1;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 24: {
                    this._PreferredStoreSizeLimit = 100;
                    if (bl) break;
                }
                case 25: {
                    this._StoreSizeCheckPeriod = 1;
                    if (bl) break;
                }
                case 27: {
                    this._WLDFDataRetirementByAges = new WLDFDataRetirementByAgeMBean[0];
                    if (bl) break;
                }
                case 26: {
                    this._WLDFDataRetirements = new WLDFDataRetirementMBean[0];
                    if (bl) break;
                }
                case 28: {
                    this._WLDFDiagnosticVolume = "Low";
                    if (bl) break;
                }
                case 23: {
                    this._DataRetirementEnabled = true;
                    if (bl) break;
                }
                case 22: {
                    this._DataRetirementTestModeEnabled = false;
                    if (bl) break;
                }
                case 21: {
                    this._DiagnosticContextEnabled = false;
                    if (bl) break;
                }
                case 11: {
                    this._DiagnosticStoreFileLockingEnabled = true;
                    if (bl) break;
                }
                case 19: {
                    this._SynchronousEventPersistenceEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "WLDFServerDiagnostic";
    }

    public void putValue(String string, Object object) {
        if (string.equals("DataRetirementEnabled")) {
            boolean bl = this._DataRetirementEnabled;
            this._DataRetirementEnabled = (Boolean)object;
            this._postSet(23, bl, this._DataRetirementEnabled);
            return;
        }
        if (string.equals("DataRetirementTestModeEnabled")) {
            boolean bl = this._DataRetirementTestModeEnabled;
            this._DataRetirementTestModeEnabled = (Boolean)object;
            this._postSet(22, bl, this._DataRetirementTestModeEnabled);
            return;
        }
        if (string.equals("DiagnosticContextEnabled")) {
            boolean bl = this._DiagnosticContextEnabled;
            this._DiagnosticContextEnabled = (Boolean)object;
            this._postSet(21, bl, this._DiagnosticContextEnabled);
            return;
        }
        if (string.equals("DiagnosticDataArchiveType")) {
            String string2 = this._DiagnosticDataArchiveType;
            this._DiagnosticDataArchiveType = (String)object;
            this._postSet(17, string2, this._DiagnosticDataArchiveType);
            return;
        }
        if (string.equals("DiagnosticJDBCResource")) {
            JDBCSystemResourceMBean jDBCSystemResourceMBean = this._DiagnosticJDBCResource;
            this._DiagnosticJDBCResource = (JDBCSystemResourceMBean)object;
            this._postSet(18, jDBCSystemResourceMBean, this._DiagnosticJDBCResource);
            return;
        }
        if (string.equals("DiagnosticStoreBlockSize")) {
            int n = this._DiagnosticStoreBlockSize;
            this._DiagnosticStoreBlockSize = (Integer)object;
            this._postSet(16, n, this._DiagnosticStoreBlockSize);
            return;
        }
        if (string.equals("DiagnosticStoreDir")) {
            String string3 = this._DiagnosticStoreDir;
            this._DiagnosticStoreDir = (String)object;
            this._postSet(10, string3, this._DiagnosticStoreDir);
            return;
        }
        if (string.equals("DiagnosticStoreFileLockingEnabled")) {
            boolean bl = this._DiagnosticStoreFileLockingEnabled;
            this._DiagnosticStoreFileLockingEnabled = (Boolean)object;
            this._postSet(11, bl, this._DiagnosticStoreFileLockingEnabled);
            return;
        }
        if (string.equals("DiagnosticStoreIoBufferSize")) {
            int n = this._DiagnosticStoreIoBufferSize;
            this._DiagnosticStoreIoBufferSize = (Integer)object;
            this._postSet(14, n, this._DiagnosticStoreIoBufferSize);
            return;
        }
        if (string.equals("DiagnosticStoreMaxFileSize")) {
            long l = this._DiagnosticStoreMaxFileSize;
            this._DiagnosticStoreMaxFileSize = (Long)object;
            this._postSet(15, l, this._DiagnosticStoreMaxFileSize);
            return;
        }
        if (string.equals("DiagnosticStoreMaxWindowBufferSize")) {
            int n = this._DiagnosticStoreMaxWindowBufferSize;
            this._DiagnosticStoreMaxWindowBufferSize = (Integer)object;
            this._postSet(13, n, this._DiagnosticStoreMaxWindowBufferSize);
            return;
        }
        if (string.equals("DiagnosticStoreMinWindowBufferSize")) {
            int n = this._DiagnosticStoreMinWindowBufferSize;
            this._DiagnosticStoreMinWindowBufferSize = (Integer)object;
            this._postSet(12, n, this._DiagnosticStoreMinWindowBufferSize);
            return;
        }
        if (string.equals("EventPersistenceInterval")) {
            long l = this._EventPersistenceInterval;
            this._EventPersistenceInterval = (Long)object;
            this._postSet(20, l, this._EventPersistenceInterval);
            return;
        }
        if (string.equals("EventsImageCaptureInterval")) {
            long l = this._EventsImageCaptureInterval;
            this._EventsImageCaptureInterval = (Long)object;
            this._postSet(9, l, this._EventsImageCaptureInterval);
            return;
        }
        if (string.equals("ImageDir")) {
            String string4 = this._ImageDir;
            this._ImageDir = (String)object;
            this._postSet(7, string4, this._ImageDir);
            return;
        }
        if (string.equals("ImageTimeout")) {
            int n = this._ImageTimeout;
            this._ImageTimeout = (Integer)object;
            this._postSet(8, n, this._ImageTimeout);
            return;
        }
        if (string.equals("Name")) {
            String string5 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string5, this._Name);
            return;
        }
        if (string.equals("PreferredStoreSizeLimit")) {
            int n = this._PreferredStoreSizeLimit;
            this._PreferredStoreSizeLimit = (Integer)object;
            this._postSet(24, n, this._PreferredStoreSizeLimit);
            return;
        }
        if (string.equals("StoreSizeCheckPeriod")) {
            int n = this._StoreSizeCheckPeriod;
            this._StoreSizeCheckPeriod = (Integer)object;
            this._postSet(25, n, this._StoreSizeCheckPeriod);
            return;
        }
        if (string.equals("SynchronousEventPersistenceEnabled")) {
            boolean bl = this._SynchronousEventPersistenceEnabled;
            this._SynchronousEventPersistenceEnabled = (Boolean)object;
            this._postSet(19, bl, this._SynchronousEventPersistenceEnabled);
            return;
        }
        if (string.equals("WLDFDataRetirementByAges")) {
            WLDFDataRetirementByAgeMBean[] wLDFDataRetirementByAgeMBeanArray = this._WLDFDataRetirementByAges;
            this._WLDFDataRetirementByAges = (WLDFDataRetirementByAgeMBean[])object;
            this._postSet(27, wLDFDataRetirementByAgeMBeanArray, this._WLDFDataRetirementByAges);
            return;
        }
        if (string.equals("WLDFDataRetirements")) {
            WLDFDataRetirementMBean[] wLDFDataRetirementMBeanArray = this._WLDFDataRetirements;
            this._WLDFDataRetirements = (WLDFDataRetirementMBean[])object;
            this._postSet(26, wLDFDataRetirementMBeanArray, this._WLDFDataRetirements);
            return;
        }
        if (string.equals("WLDFDiagnosticVolume")) {
            String string6 = this._WLDFDiagnosticVolume;
            this._WLDFDiagnosticVolume = (String)object;
            this._postSet(28, string6, this._WLDFDiagnosticVolume);
            return;
        }
        if (string.equals("customizer")) {
            WLDFServerDiagnostic wLDFServerDiagnostic = this._customizer;
            this._customizer = (WLDFServerDiagnostic)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("DataRetirementEnabled")) {
            return new Boolean(this._DataRetirementEnabled);
        }
        if (string.equals("DataRetirementTestModeEnabled")) {
            return new Boolean(this._DataRetirementTestModeEnabled);
        }
        if (string.equals("DiagnosticContextEnabled")) {
            return new Boolean(this._DiagnosticContextEnabled);
        }
        if (string.equals("DiagnosticDataArchiveType")) {
            return this._DiagnosticDataArchiveType;
        }
        if (string.equals("DiagnosticJDBCResource")) {
            return this._DiagnosticJDBCResource;
        }
        if (string.equals("DiagnosticStoreBlockSize")) {
            return new Integer(this._DiagnosticStoreBlockSize);
        }
        if (string.equals("DiagnosticStoreDir")) {
            return this._DiagnosticStoreDir;
        }
        if (string.equals("DiagnosticStoreFileLockingEnabled")) {
            return new Boolean(this._DiagnosticStoreFileLockingEnabled);
        }
        if (string.equals("DiagnosticStoreIoBufferSize")) {
            return new Integer(this._DiagnosticStoreIoBufferSize);
        }
        if (string.equals("DiagnosticStoreMaxFileSize")) {
            return new Long(this._DiagnosticStoreMaxFileSize);
        }
        if (string.equals("DiagnosticStoreMaxWindowBufferSize")) {
            return new Integer(this._DiagnosticStoreMaxWindowBufferSize);
        }
        if (string.equals("DiagnosticStoreMinWindowBufferSize")) {
            return new Integer(this._DiagnosticStoreMinWindowBufferSize);
        }
        if (string.equals("EventPersistenceInterval")) {
            return new Long(this._EventPersistenceInterval);
        }
        if (string.equals("EventsImageCaptureInterval")) {
            return new Long(this._EventsImageCaptureInterval);
        }
        if (string.equals("ImageDir")) {
            return this._ImageDir;
        }
        if (string.equals("ImageTimeout")) {
            return new Integer(this._ImageTimeout);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("PreferredStoreSizeLimit")) {
            return new Integer(this._PreferredStoreSizeLimit);
        }
        if (string.equals("StoreSizeCheckPeriod")) {
            return new Integer(this._StoreSizeCheckPeriod);
        }
        if (string.equals("SynchronousEventPersistenceEnabled")) {
            return new Boolean(this._SynchronousEventPersistenceEnabled);
        }
        if (string.equals("WLDFDataRetirementByAges")) {
            return this._WLDFDataRetirementByAges;
        }
        if (string.equals("WLDFDataRetirements")) {
            return this._WLDFDataRetirements;
        }
        if (string.equals("WLDFDiagnosticVolume")) {
            return this._WLDFDiagnosticVolume;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 28: {
                    if (!string.equals("diagnostic-data-archive-type")) break;
                    return 17;
                }
                case 24: {
                    if (!string.equals("diagnostic-jdbc-resource")) break;
                    return 18;
                }
                case 27: {
                    if (string.equals("diagnostic-store-block-size")) {
                        return 16;
                    }
                    if (!string.equals("wldf-data-retirement-by-age")) break;
                    return 27;
                }
                case 20: {
                    if (string.equals("diagnostic-store-dir")) {
                        return 10;
                    }
                    if (!string.equals("wldf-data-retirement")) break;
                    return 26;
                }
                case 31: {
                    if (!string.equals("diagnostic-store-io-buffer-size")) break;
                    return 14;
                }
                case 30: {
                    if (!string.equals("diagnostic-store-max-file-size")) break;
                    return 15;
                }
                case 39: {
                    if (string.equals("diagnostic-store-max-window-buffer-size")) {
                        return 13;
                    }
                    if (!string.equals("diagnostic-store-min-window-buffer-size")) break;
                    return 12;
                }
                case 26: {
                    if (string.equals("event-persistence-interval")) {
                        return 20;
                    }
                    if (string.equals("preferred-store-size-limit")) {
                        return 24;
                    }
                    if (!string.equals("diagnostic-context-enabled")) break;
                    return 21;
                }
                case 29: {
                    if (!string.equals("events-image-capture-interval")) break;
                    return 9;
                }
                case 9: {
                    if (!string.equals("image-dir")) break;
                    return 7;
                }
                case 13: {
                    if (!string.equals("image-timeout")) break;
                    return 8;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 23: {
                    if (string.equals("store-size-check-period")) {
                        return 25;
                    }
                    if (!string.equals("data-retirement-enabled")) break;
                    return 23;
                }
                case 22: {
                    if (!string.equals("wldf-diagnostic-volume")) break;
                    return 28;
                }
                case 33: {
                    if (!string.equals("data-retirement-test-mode-enabled")) break;
                    return 22;
                }
                case 37: {
                    if (string.equals("diagnostic-store-file-locking-enabled")) {
                        return 11;
                    }
                    if (!string.equals("synchronous-event-persistence-enabled")) break;
                    return 19;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 27: {
                    return new WLDFDataRetirementByAgeMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 17: {
                    return "diagnostic-data-archive-type";
                }
                case 18: {
                    return "diagnostic-jdbc-resource";
                }
                case 16: {
                    return "diagnostic-store-block-size";
                }
                case 10: {
                    return "diagnostic-store-dir";
                }
                case 14: {
                    return "diagnostic-store-io-buffer-size";
                }
                case 15: {
                    return "diagnostic-store-max-file-size";
                }
                case 13: {
                    return "diagnostic-store-max-window-buffer-size";
                }
                case 12: {
                    return "diagnostic-store-min-window-buffer-size";
                }
                case 20: {
                    return "event-persistence-interval";
                }
                case 9: {
                    return "events-image-capture-interval";
                }
                case 7: {
                    return "image-dir";
                }
                case 8: {
                    return "image-timeout";
                }
                case 2: {
                    return "name";
                }
                case 24: {
                    return "preferred-store-size-limit";
                }
                case 25: {
                    return "store-size-check-period";
                }
                case 27: {
                    return "wldf-data-retirement-by-age";
                }
                case 26: {
                    return "wldf-data-retirement";
                }
                case 28: {
                    return "wldf-diagnostic-volume";
                }
                case 23: {
                    return "data-retirement-enabled";
                }
                case 22: {
                    return "data-retirement-test-mode-enabled";
                }
                case 21: {
                    return "diagnostic-context-enabled";
                }
                case 11: {
                    return "diagnostic-store-file-locking-enabled";
                }
                case 19: {
                    return "synchronous-event-persistence-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 27: {
                    return true;
                }
                case 26: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 27: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private WLDFServerDiagnosticMBeanImpl bean;

        protected Helper(WLDFServerDiagnosticMBeanImpl wLDFServerDiagnosticMBeanImpl) {
            super(wLDFServerDiagnosticMBeanImpl);
            this.bean = wLDFServerDiagnosticMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 17: {
                    return "DiagnosticDataArchiveType";
                }
                case 18: {
                    return "DiagnosticJDBCResource";
                }
                case 16: {
                    return "DiagnosticStoreBlockSize";
                }
                case 10: {
                    return "DiagnosticStoreDir";
                }
                case 14: {
                    return "DiagnosticStoreIoBufferSize";
                }
                case 15: {
                    return "DiagnosticStoreMaxFileSize";
                }
                case 13: {
                    return "DiagnosticStoreMaxWindowBufferSize";
                }
                case 12: {
                    return "DiagnosticStoreMinWindowBufferSize";
                }
                case 20: {
                    return "EventPersistenceInterval";
                }
                case 9: {
                    return "EventsImageCaptureInterval";
                }
                case 7: {
                    return "ImageDir";
                }
                case 8: {
                    return "ImageTimeout";
                }
                case 2: {
                    return "Name";
                }
                case 24: {
                    return "PreferredStoreSizeLimit";
                }
                case 25: {
                    return "StoreSizeCheckPeriod";
                }
                case 27: {
                    return "WLDFDataRetirementByAges";
                }
                case 26: {
                    return "WLDFDataRetirements";
                }
                case 28: {
                    return "WLDFDiagnosticVolume";
                }
                case 23: {
                    return "DataRetirementEnabled";
                }
                case 22: {
                    return "DataRetirementTestModeEnabled";
                }
                case 21: {
                    return "DiagnosticContextEnabled";
                }
                case 11: {
                    return "DiagnosticStoreFileLockingEnabled";
                }
                case 19: {
                    return "SynchronousEventPersistenceEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("DiagnosticDataArchiveType")) {
                return 17;
            }
            if (string.equals("DiagnosticJDBCResource")) {
                return 18;
            }
            if (string.equals("DiagnosticStoreBlockSize")) {
                return 16;
            }
            if (string.equals("DiagnosticStoreDir")) {
                return 10;
            }
            if (string.equals("DiagnosticStoreIoBufferSize")) {
                return 14;
            }
            if (string.equals("DiagnosticStoreMaxFileSize")) {
                return 15;
            }
            if (string.equals("DiagnosticStoreMaxWindowBufferSize")) {
                return 13;
            }
            if (string.equals("DiagnosticStoreMinWindowBufferSize")) {
                return 12;
            }
            if (string.equals("EventPersistenceInterval")) {
                return 20;
            }
            if (string.equals("EventsImageCaptureInterval")) {
                return 9;
            }
            if (string.equals("ImageDir")) {
                return 7;
            }
            if (string.equals("ImageTimeout")) {
                return 8;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("PreferredStoreSizeLimit")) {
                return 24;
            }
            if (string.equals("StoreSizeCheckPeriod")) {
                return 25;
            }
            if (string.equals("WLDFDataRetirementByAges")) {
                return 27;
            }
            if (string.equals("WLDFDataRetirements")) {
                return 26;
            }
            if (string.equals("WLDFDiagnosticVolume")) {
                return 28;
            }
            if (string.equals("DataRetirementEnabled")) {
                return 23;
            }
            if (string.equals("DataRetirementTestModeEnabled")) {
                return 22;
            }
            if (string.equals("DiagnosticContextEnabled")) {
                return 21;
            }
            if (string.equals("DiagnosticStoreFileLockingEnabled")) {
                return 11;
            }
            if (string.equals("SynchronousEventPersistenceEnabled")) {
                return 19;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getWLDFDataRetirementByAges()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isDiagnosticDataArchiveTypeSet()) {
                    stringBuffer.append("DiagnosticDataArchiveType");
                    stringBuffer.append(String.valueOf(this.bean.getDiagnosticDataArchiveType()));
                }
                if (this.bean.isDiagnosticJDBCResourceSet()) {
                    stringBuffer.append("DiagnosticJDBCResource");
                    stringBuffer.append(String.valueOf(this.bean.getDiagnosticJDBCResource()));
                }
                if (this.bean.isDiagnosticStoreBlockSizeSet()) {
                    stringBuffer.append("DiagnosticStoreBlockSize");
                    stringBuffer.append(String.valueOf(this.bean.getDiagnosticStoreBlockSize()));
                }
                if (this.bean.isDiagnosticStoreDirSet()) {
                    stringBuffer.append("DiagnosticStoreDir");
                    stringBuffer.append(String.valueOf(this.bean.getDiagnosticStoreDir()));
                }
                if (this.bean.isDiagnosticStoreIoBufferSizeSet()) {
                    stringBuffer.append("DiagnosticStoreIoBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getDiagnosticStoreIoBufferSize()));
                }
                if (this.bean.isDiagnosticStoreMaxFileSizeSet()) {
                    stringBuffer.append("DiagnosticStoreMaxFileSize");
                    stringBuffer.append(String.valueOf(this.bean.getDiagnosticStoreMaxFileSize()));
                }
                if (this.bean.isDiagnosticStoreMaxWindowBufferSizeSet()) {
                    stringBuffer.append("DiagnosticStoreMaxWindowBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getDiagnosticStoreMaxWindowBufferSize()));
                }
                if (this.bean.isDiagnosticStoreMinWindowBufferSizeSet()) {
                    stringBuffer.append("DiagnosticStoreMinWindowBufferSize");
                    stringBuffer.append(String.valueOf(this.bean.getDiagnosticStoreMinWindowBufferSize()));
                }
                if (this.bean.isEventPersistenceIntervalSet()) {
                    stringBuffer.append("EventPersistenceInterval");
                    stringBuffer.append(String.valueOf(this.bean.getEventPersistenceInterval()));
                }
                if (this.bean.isEventsImageCaptureIntervalSet()) {
                    stringBuffer.append("EventsImageCaptureInterval");
                    stringBuffer.append(String.valueOf(this.bean.getEventsImageCaptureInterval()));
                }
                if (this.bean.isImageDirSet()) {
                    stringBuffer.append("ImageDir");
                    stringBuffer.append(String.valueOf(this.bean.getImageDir()));
                }
                if (this.bean.isImageTimeoutSet()) {
                    stringBuffer.append("ImageTimeout");
                    stringBuffer.append(String.valueOf(this.bean.getImageTimeout()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isPreferredStoreSizeLimitSet()) {
                    stringBuffer.append("PreferredStoreSizeLimit");
                    stringBuffer.append(String.valueOf(this.bean.getPreferredStoreSizeLimit()));
                }
                if (this.bean.isStoreSizeCheckPeriodSet()) {
                    stringBuffer.append("StoreSizeCheckPeriod");
                    stringBuffer.append(String.valueOf(this.bean.getStoreSizeCheckPeriod()));
                }
                l2 = 0L;
                for (int i = 0; i < this.bean.getWLDFDataRetirementByAges().length; ++i) {
                    l2 ^= this.computeChildHashValue(this.bean.getWLDFDataRetirementByAges()[i]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isWLDFDataRetirementsSet()) {
                    stringBuffer.append("WLDFDataRetirements");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getWLDFDataRetirements())));
                }
                if (this.bean.isWLDFDiagnosticVolumeSet()) {
                    stringBuffer.append("WLDFDiagnosticVolume");
                    stringBuffer.append(String.valueOf(this.bean.getWLDFDiagnosticVolume()));
                }
                if (this.bean.isDataRetirementEnabledSet()) {
                    stringBuffer.append("DataRetirementEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDataRetirementEnabled()));
                }
                if (this.bean.isDataRetirementTestModeEnabledSet()) {
                    stringBuffer.append("DataRetirementTestModeEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDataRetirementTestModeEnabled()));
                }
                if (this.bean.isDiagnosticContextEnabledSet()) {
                    stringBuffer.append("DiagnosticContextEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDiagnosticContextEnabled()));
                }
                if (this.bean.isDiagnosticStoreFileLockingEnabledSet()) {
                    stringBuffer.append("DiagnosticStoreFileLockingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDiagnosticStoreFileLockingEnabled()));
                }
                if (this.bean.isSynchronousEventPersistenceEnabledSet()) {
                    stringBuffer.append("SynchronousEventPersistenceEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSynchronousEventPersistenceEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WLDFServerDiagnosticMBeanImpl wLDFServerDiagnosticMBeanImpl = (WLDFServerDiagnosticMBeanImpl)abstractDescriptorBean;
                this.computeDiff("DiagnosticDataArchiveType", this.bean.getDiagnosticDataArchiveType(), wLDFServerDiagnosticMBeanImpl.getDiagnosticDataArchiveType(), false);
                this.computeDiff("DiagnosticJDBCResource", this.bean.getDiagnosticJDBCResource(), wLDFServerDiagnosticMBeanImpl.getDiagnosticJDBCResource(), false);
                this.computeDiff("DiagnosticStoreBlockSize", this.bean.getDiagnosticStoreBlockSize(), wLDFServerDiagnosticMBeanImpl.getDiagnosticStoreBlockSize(), false);
                this.computeDiff("DiagnosticStoreDir", this.bean.getDiagnosticStoreDir(), wLDFServerDiagnosticMBeanImpl.getDiagnosticStoreDir(), false);
                this.computeDiff("DiagnosticStoreIoBufferSize", this.bean.getDiagnosticStoreIoBufferSize(), wLDFServerDiagnosticMBeanImpl.getDiagnosticStoreIoBufferSize(), false);
                this.computeDiff("DiagnosticStoreMaxFileSize", this.bean.getDiagnosticStoreMaxFileSize(), wLDFServerDiagnosticMBeanImpl.getDiagnosticStoreMaxFileSize(), false);
                this.computeDiff("DiagnosticStoreMaxWindowBufferSize", this.bean.getDiagnosticStoreMaxWindowBufferSize(), wLDFServerDiagnosticMBeanImpl.getDiagnosticStoreMaxWindowBufferSize(), false);
                this.computeDiff("DiagnosticStoreMinWindowBufferSize", this.bean.getDiagnosticStoreMinWindowBufferSize(), wLDFServerDiagnosticMBeanImpl.getDiagnosticStoreMinWindowBufferSize(), false);
                this.computeDiff("EventPersistenceInterval", this.bean.getEventPersistenceInterval(), wLDFServerDiagnosticMBeanImpl.getEventPersistenceInterval(), true);
                this.computeDiff("EventsImageCaptureInterval", this.bean.getEventsImageCaptureInterval(), wLDFServerDiagnosticMBeanImpl.getEventsImageCaptureInterval(), true);
                this.computeDiff("ImageDir", this.bean.getImageDir(), wLDFServerDiagnosticMBeanImpl.getImageDir(), true);
                this.computeDiff("ImageTimeout", this.bean.getImageTimeout(), wLDFServerDiagnosticMBeanImpl.getImageTimeout(), true);
                this.computeDiff("Name", this.bean.getName(), wLDFServerDiagnosticMBeanImpl.getName(), false);
                this.computeDiff("PreferredStoreSizeLimit", this.bean.getPreferredStoreSizeLimit(), wLDFServerDiagnosticMBeanImpl.getPreferredStoreSizeLimit(), true);
                this.computeDiff("StoreSizeCheckPeriod", this.bean.getStoreSizeCheckPeriod(), wLDFServerDiagnosticMBeanImpl.getStoreSizeCheckPeriod(), true);
                this.computeChildDiff("WLDFDataRetirementByAges", this.bean.getWLDFDataRetirementByAges(), wLDFServerDiagnosticMBeanImpl.getWLDFDataRetirementByAges(), true);
                this.computeDiff("WLDFDiagnosticVolume", this.bean.getWLDFDiagnosticVolume(), wLDFServerDiagnosticMBeanImpl.getWLDFDiagnosticVolume(), true);
                this.computeDiff("DataRetirementEnabled", this.bean.isDataRetirementEnabled(), wLDFServerDiagnosticMBeanImpl.isDataRetirementEnabled(), true);
                this.computeDiff("DataRetirementTestModeEnabled", this.bean.isDataRetirementTestModeEnabled(), wLDFServerDiagnosticMBeanImpl.isDataRetirementTestModeEnabled(), false);
                this.computeDiff("DiagnosticContextEnabled", this.bean.isDiagnosticContextEnabled(), wLDFServerDiagnosticMBeanImpl.isDiagnosticContextEnabled(), true);
                this.computeDiff("DiagnosticStoreFileLockingEnabled", this.bean.isDiagnosticStoreFileLockingEnabled(), wLDFServerDiagnosticMBeanImpl.isDiagnosticStoreFileLockingEnabled(), false);
                this.computeDiff("SynchronousEventPersistenceEnabled", this.bean.isSynchronousEventPersistenceEnabled(), wLDFServerDiagnosticMBeanImpl.isSynchronousEventPersistenceEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WLDFServerDiagnosticMBeanImpl wLDFServerDiagnosticMBeanImpl = (WLDFServerDiagnosticMBeanImpl)beanUpdateEvent.getSourceBean();
                WLDFServerDiagnosticMBeanImpl wLDFServerDiagnosticMBeanImpl2 = (WLDFServerDiagnosticMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("DiagnosticDataArchiveType")) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticDataArchiveType(wLDFServerDiagnosticMBeanImpl2.getDiagnosticDataArchiveType());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("DiagnosticJDBCResource")) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticJDBCResourceAsString(wLDFServerDiagnosticMBeanImpl2.getDiagnosticJDBCResourceAsString());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("DiagnosticStoreBlockSize")) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreBlockSize(wLDFServerDiagnosticMBeanImpl2.getDiagnosticStoreBlockSize());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("DiagnosticStoreDir")) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreDir(wLDFServerDiagnosticMBeanImpl2.getDiagnosticStoreDir());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("DiagnosticStoreIoBufferSize")) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreIoBufferSize(wLDFServerDiagnosticMBeanImpl2.getDiagnosticStoreIoBufferSize());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("DiagnosticStoreMaxFileSize")) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreMaxFileSize(wLDFServerDiagnosticMBeanImpl2.getDiagnosticStoreMaxFileSize());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("DiagnosticStoreMaxWindowBufferSize")) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreMaxWindowBufferSize(wLDFServerDiagnosticMBeanImpl2.getDiagnosticStoreMaxWindowBufferSize());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("DiagnosticStoreMinWindowBufferSize")) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreMinWindowBufferSize(wLDFServerDiagnosticMBeanImpl2.getDiagnosticStoreMinWindowBufferSize());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("EventPersistenceInterval")) {
                    wLDFServerDiagnosticMBeanImpl.setEventPersistenceInterval(wLDFServerDiagnosticMBeanImpl2.getEventPersistenceInterval());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("EventsImageCaptureInterval")) {
                    wLDFServerDiagnosticMBeanImpl.setEventsImageCaptureInterval(wLDFServerDiagnosticMBeanImpl2.getEventsImageCaptureInterval());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("ImageDir")) {
                    wLDFServerDiagnosticMBeanImpl.setImageDir(wLDFServerDiagnosticMBeanImpl2.getImageDir());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("ImageTimeout")) {
                    wLDFServerDiagnosticMBeanImpl.setImageTimeout(wLDFServerDiagnosticMBeanImpl2.getImageTimeout());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("Name")) {
                    wLDFServerDiagnosticMBeanImpl.setName(wLDFServerDiagnosticMBeanImpl2.getName());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("PreferredStoreSizeLimit")) {
                    wLDFServerDiagnosticMBeanImpl.setPreferredStoreSizeLimit(wLDFServerDiagnosticMBeanImpl2.getPreferredStoreSizeLimit());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("StoreSizeCheckPeriod")) {
                    wLDFServerDiagnosticMBeanImpl.setStoreSizeCheckPeriod(wLDFServerDiagnosticMBeanImpl2.getStoreSizeCheckPeriod());
                    wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("WLDFDataRetirementByAges")) {
                    if (n == 2) {
                        propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                        wLDFServerDiagnosticMBeanImpl.addWLDFDataRetirementByAge((WLDFDataRetirementByAgeMBean)propertyUpdate.getAddedObject());
                    } else if (n == 3) {
                        wLDFServerDiagnosticMBeanImpl.removeWLDFDataRetirementByAge((WLDFDataRetirementByAgeMBean)propertyUpdate.getRemovedObject());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    if (wLDFServerDiagnosticMBeanImpl.getWLDFDataRetirementByAges() == null || wLDFServerDiagnosticMBeanImpl.getWLDFDataRetirementByAges().length == 0) {
                        wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                    }
                } else if (!string.equals("WLDFDataRetirements")) {
                    if (string.equals("WLDFDiagnosticVolume")) {
                        wLDFServerDiagnosticMBeanImpl.setWLDFDiagnosticVolume(wLDFServerDiagnosticMBeanImpl2.getWLDFDiagnosticVolume());
                        wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                    } else if (string.equals("DataRetirementEnabled")) {
                        wLDFServerDiagnosticMBeanImpl.setDataRetirementEnabled(wLDFServerDiagnosticMBeanImpl2.isDataRetirementEnabled());
                        wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                    } else if (string.equals("DataRetirementTestModeEnabled")) {
                        wLDFServerDiagnosticMBeanImpl.setDataRetirementTestModeEnabled(wLDFServerDiagnosticMBeanImpl2.isDataRetirementTestModeEnabled());
                        wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                    } else if (string.equals("DiagnosticContextEnabled")) {
                        wLDFServerDiagnosticMBeanImpl.setDiagnosticContextEnabled(wLDFServerDiagnosticMBeanImpl2.isDiagnosticContextEnabled());
                        wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    } else if (string.equals("DiagnosticStoreFileLockingEnabled")) {
                        wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreFileLockingEnabled(wLDFServerDiagnosticMBeanImpl2.isDiagnosticStoreFileLockingEnabled());
                        wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("SynchronousEventPersistenceEnabled")) {
                        wLDFServerDiagnosticMBeanImpl.setSynchronousEventPersistenceEnabled(wLDFServerDiagnosticMBeanImpl2.isSynchronousEventPersistenceEnabled());
                        wLDFServerDiagnosticMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    } else {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                WLDFServerDiagnosticMBeanImpl wLDFServerDiagnosticMBeanImpl = (WLDFServerDiagnosticMBeanImpl)abstractDescriptorBean;
                super.finishCopy(wLDFServerDiagnosticMBeanImpl, bl, list);
                if ((list == null || !list.contains("DiagnosticDataArchiveType")) && this.bean.isDiagnosticDataArchiveTypeSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticDataArchiveType(this.bean.getDiagnosticDataArchiveType());
                }
                if ((list == null || !list.contains("DiagnosticJDBCResource")) && this.bean.isDiagnosticJDBCResourceSet()) {
                    wLDFServerDiagnosticMBeanImpl._unSet(wLDFServerDiagnosticMBeanImpl, 18);
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticJDBCResourceAsString(this.bean.getDiagnosticJDBCResourceAsString());
                }
                if ((list == null || !list.contains("DiagnosticStoreBlockSize")) && this.bean.isDiagnosticStoreBlockSizeSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreBlockSize(this.bean.getDiagnosticStoreBlockSize());
                }
                if ((list == null || !list.contains("DiagnosticStoreDir")) && this.bean.isDiagnosticStoreDirSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreDir(this.bean.getDiagnosticStoreDir());
                }
                if ((list == null || !list.contains("DiagnosticStoreIoBufferSize")) && this.bean.isDiagnosticStoreIoBufferSizeSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreIoBufferSize(this.bean.getDiagnosticStoreIoBufferSize());
                }
                if ((list == null || !list.contains("DiagnosticStoreMaxFileSize")) && this.bean.isDiagnosticStoreMaxFileSizeSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreMaxFileSize(this.bean.getDiagnosticStoreMaxFileSize());
                }
                if ((list == null || !list.contains("DiagnosticStoreMaxWindowBufferSize")) && this.bean.isDiagnosticStoreMaxWindowBufferSizeSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreMaxWindowBufferSize(this.bean.getDiagnosticStoreMaxWindowBufferSize());
                }
                if ((list == null || !list.contains("DiagnosticStoreMinWindowBufferSize")) && this.bean.isDiagnosticStoreMinWindowBufferSizeSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreMinWindowBufferSize(this.bean.getDiagnosticStoreMinWindowBufferSize());
                }
                if ((list == null || !list.contains("EventPersistenceInterval")) && this.bean.isEventPersistenceIntervalSet()) {
                    wLDFServerDiagnosticMBeanImpl.setEventPersistenceInterval(this.bean.getEventPersistenceInterval());
                }
                if ((list == null || !list.contains("EventsImageCaptureInterval")) && this.bean.isEventsImageCaptureIntervalSet()) {
                    wLDFServerDiagnosticMBeanImpl.setEventsImageCaptureInterval(this.bean.getEventsImageCaptureInterval());
                }
                if ((list == null || !list.contains("ImageDir")) && this.bean.isImageDirSet()) {
                    wLDFServerDiagnosticMBeanImpl.setImageDir(this.bean.getImageDir());
                }
                if ((list == null || !list.contains("ImageTimeout")) && this.bean.isImageTimeoutSet()) {
                    wLDFServerDiagnosticMBeanImpl.setImageTimeout(this.bean.getImageTimeout());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    wLDFServerDiagnosticMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("PreferredStoreSizeLimit")) && this.bean.isPreferredStoreSizeLimitSet()) {
                    wLDFServerDiagnosticMBeanImpl.setPreferredStoreSizeLimit(this.bean.getPreferredStoreSizeLimit());
                }
                if ((list == null || !list.contains("StoreSizeCheckPeriod")) && this.bean.isStoreSizeCheckPeriodSet()) {
                    wLDFServerDiagnosticMBeanImpl.setStoreSizeCheckPeriod(this.bean.getStoreSizeCheckPeriod());
                }
                if (!(list != null && list.contains("WLDFDataRetirementByAges") || !this.bean.isWLDFDataRetirementByAgesSet() || wLDFServerDiagnosticMBeanImpl._isSet(27))) {
                    WLDFDataRetirementByAgeMBean[] wLDFDataRetirementByAgeMBeanArray = this.bean.getWLDFDataRetirementByAges();
                    WLDFDataRetirementByAgeMBean[] wLDFDataRetirementByAgeMBeanArray2 = new WLDFDataRetirementByAgeMBean[wLDFDataRetirementByAgeMBeanArray.length];
                    for (int i = 0; i < wLDFDataRetirementByAgeMBeanArray2.length; ++i) {
                        wLDFDataRetirementByAgeMBeanArray2[i] = (WLDFDataRetirementByAgeMBean)this.createCopy((AbstractDescriptorBean)wLDFDataRetirementByAgeMBeanArray[i], bl);
                    }
                    wLDFServerDiagnosticMBeanImpl.setWLDFDataRetirementByAges(wLDFDataRetirementByAgeMBeanArray2);
                }
                if ((list == null || !list.contains("WLDFDiagnosticVolume")) && this.bean.isWLDFDiagnosticVolumeSet()) {
                    wLDFServerDiagnosticMBeanImpl.setWLDFDiagnosticVolume(this.bean.getWLDFDiagnosticVolume());
                }
                if ((list == null || !list.contains("DataRetirementEnabled")) && this.bean.isDataRetirementEnabledSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDataRetirementEnabled(this.bean.isDataRetirementEnabled());
                }
                if ((list == null || !list.contains("DataRetirementTestModeEnabled")) && this.bean.isDataRetirementTestModeEnabledSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDataRetirementTestModeEnabled(this.bean.isDataRetirementTestModeEnabled());
                }
                if ((list == null || !list.contains("DiagnosticContextEnabled")) && this.bean.isDiagnosticContextEnabledSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticContextEnabled(this.bean.isDiagnosticContextEnabled());
                }
                if ((list == null || !list.contains("DiagnosticStoreFileLockingEnabled")) && this.bean.isDiagnosticStoreFileLockingEnabledSet()) {
                    wLDFServerDiagnosticMBeanImpl.setDiagnosticStoreFileLockingEnabled(this.bean.isDiagnosticStoreFileLockingEnabled());
                }
                if ((list == null || !list.contains("SynchronousEventPersistenceEnabled")) && this.bean.isSynchronousEventPersistenceEnabledSet()) {
                    wLDFServerDiagnosticMBeanImpl.setSynchronousEventPersistenceEnabled(this.bean.isSynchronousEventPersistenceEnabled());
                }
                return wLDFServerDiagnosticMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getDiagnosticJDBCResource(), clazz, object);
            this.inferSubTree(this.bean.getWLDFDataRetirementByAges(), clazz, object);
            this.inferSubTree(this.bean.getWLDFDataRetirements(), clazz, object);
        }
    }
}

