/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.diagnostics.descriptor.WLDFResourceBean;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.SubDeploymentMBeanImpl;
import weblogic.management.configuration.SystemResourceMBeanImpl;
import weblogic.management.configuration.WLDFSystemResourceMBean;
import weblogic.management.mbeans.custom.WLDFSystemResource;
import weblogic.utils.FileUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class WLDFSystemResourceMBeanImpl
extends SystemResourceMBeanImpl
implements WLDFSystemResourceMBean,
Serializable {
    private String _Description;
    private String _DescriptorFileName;
    private String _Name;
    private DescriptorBean _Resource;
    private WLDFResourceBean _WLDFResource;
    private WLDFSystemResource _customizer;
    private static SchemaHelper2 _schemaHelper;

    public WLDFSystemResourceMBeanImpl() {
        try {
            this._customizer = new WLDFSystemResource(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public WLDFSystemResourceMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new WLDFSystemResource(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getDescriptorFileName() {
        if (!this._isSet(14)) {
            try {
                return "diagnostics/" + FileUtils.mapNameToFileName((String)this.getName()) + ".xml";
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getDescriptorFileName();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public WLDFResourceBean getWLDFResource() {
        return this._customizer.getWLDFResource();
    }

    public boolean isDescriptorFileNameSet() {
        return this._isSet(14);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isWLDFResourceSet() {
        return this._isSet(16);
    }

    public void setWLDFResource(WLDFResourceBean wLDFResourceBean) throws InvalidAttributeValueException {
        this._WLDFResource = wLDFResourceBean;
    }

    public DescriptorBean getResource() {
        return this._customizer.getResource();
    }

    public boolean isResourceSet() {
        return this._isSet(15);
    }

    public void setDescriptorFileName(String string) {
        string = string == null ? null : string.trim();
        String string2 = this.getDescriptorFileName();
        this._customizer.setDescriptorFileName(string);
        this._postSet(14, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setResource(DescriptorBean descriptorBean) throws InvalidAttributeValueException {
        this._Resource = descriptorBean;
    }

    public String getDescription() {
        return this._Description;
    }

    public boolean isDescriptionSet() {
        return this._isSet(17);
    }

    public void setDescription(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._Description;
        this._Description = string;
        this._postSet(17, string2, string);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _preDestroy() {
        this._customizer._preDestroy();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 17;
        }
        try {
            switch (n) {
                case 17: {
                    this._Description = null;
                    if (bl) break;
                }
                case 14: {
                    this._customizer.setDescriptorFileName(null);
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 15: {
                    this._Resource = null;
                    if (bl) break;
                }
                case 16: {
                    this._WLDFResource = null;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "WLDFSystemResource";
    }

    public void putValue(String string, Object object) {
        if (string.equals("Description")) {
            String string2 = this._Description;
            this._Description = (String)object;
            this._postSet(17, string2, this._Description);
            return;
        }
        if (string.equals("DescriptorFileName")) {
            String string3 = this._DescriptorFileName;
            this._DescriptorFileName = (String)object;
            this._postSet(14, string3, this._DescriptorFileName);
            return;
        }
        if (string.equals("Name")) {
            String string4 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string4, this._Name);
            return;
        }
        if (string.equals("Resource")) {
            DescriptorBean descriptorBean = this._Resource;
            this._Resource = (DescriptorBean)object;
            this._postSet(15, descriptorBean, this._Resource);
            return;
        }
        if (string.equals("WLDFResource")) {
            WLDFResourceBean wLDFResourceBean = this._WLDFResource;
            this._WLDFResource = (WLDFResourceBean)object;
            this._postSet(16, wLDFResourceBean, this._WLDFResource);
            return;
        }
        if (string.equals("customizer")) {
            WLDFSystemResource wLDFSystemResource = this._customizer;
            this._customizer = (WLDFSystemResource)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("Description")) {
            return this._Description;
        }
        if (string.equals("DescriptorFileName")) {
            return this._DescriptorFileName;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("Resource")) {
            return this._Resource;
        }
        if (string.equals("WLDFResource")) {
            return this._WLDFResource;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends SystemResourceMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 11: {
                    if (!string.equals("description")) break;
                    return 17;
                }
                case 20: {
                    if (!string.equals("descriptor-file-name")) break;
                    return 14;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 8: {
                    if (!string.equals("resource")) break;
                    return 15;
                }
                case 13: {
                    if (!string.equals("wldf-resource")) break;
                    return 16;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 11: {
                    return new SubDeploymentMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 17: {
                    return "description";
                }
                case 14: {
                    return "descriptor-file-name";
                }
                case 2: {
                    return "name";
                }
                case 15: {
                    return "resource";
                }
                case 16: {
                    return "wldf-resource";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 11: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 11: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends SystemResourceMBeanImpl.Helper {
        private WLDFSystemResourceMBeanImpl bean;

        protected Helper(WLDFSystemResourceMBeanImpl wLDFSystemResourceMBeanImpl) {
            super(wLDFSystemResourceMBeanImpl);
            this.bean = wLDFSystemResourceMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 17: {
                    return "Description";
                }
                case 14: {
                    return "DescriptorFileName";
                }
                case 2: {
                    return "Name";
                }
                case 15: {
                    return "Resource";
                }
                case 16: {
                    return "WLDFResource";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("Description")) {
                return 17;
            }
            if (string.equals("DescriptorFileName")) {
                return 14;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("Resource")) {
                return 15;
            }
            if (string.equals("WLDFResource")) {
                return 16;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getSubDeployments()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isDescriptionSet()) {
                    stringBuffer.append("Description");
                    stringBuffer.append(String.valueOf(this.bean.getDescription()));
                }
                if (this.bean.isDescriptorFileNameSet()) {
                    stringBuffer.append("DescriptorFileName");
                    stringBuffer.append(String.valueOf(this.bean.getDescriptorFileName()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isResourceSet()) {
                    stringBuffer.append("Resource");
                    stringBuffer.append(String.valueOf(this.bean.getResource()));
                }
                if (this.bean.isWLDFResourceSet()) {
                    stringBuffer.append("WLDFResource");
                    stringBuffer.append(String.valueOf(this.bean.getWLDFResource()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WLDFSystemResourceMBeanImpl wLDFSystemResourceMBeanImpl = (WLDFSystemResourceMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Description", this.bean.getDescription(), wLDFSystemResourceMBeanImpl.getDescription(), true);
                this.computeDiff("DescriptorFileName", this.bean.getDescriptorFileName(), wLDFSystemResourceMBeanImpl.getDescriptorFileName(), false);
                this.computeDiff("Name", this.bean.getName(), wLDFSystemResourceMBeanImpl.getName(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WLDFSystemResourceMBeanImpl wLDFSystemResourceMBeanImpl = (WLDFSystemResourceMBeanImpl)beanUpdateEvent.getSourceBean();
                WLDFSystemResourceMBeanImpl wLDFSystemResourceMBeanImpl2 = (WLDFSystemResourceMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("Description")) {
                    wLDFSystemResourceMBeanImpl.setDescription(wLDFSystemResourceMBeanImpl2.getDescription());
                    wLDFSystemResourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("DescriptorFileName")) {
                    wLDFSystemResourceMBeanImpl.setDescriptorFileName(wLDFSystemResourceMBeanImpl2.getDescriptorFileName());
                    wLDFSystemResourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("Name")) {
                    wLDFSystemResourceMBeanImpl.setName(wLDFSystemResourceMBeanImpl2.getName());
                    wLDFSystemResourceMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (!string.equals("Resource") && !string.equals("WLDFResource")) {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                WLDFSystemResourceMBeanImpl wLDFSystemResourceMBeanImpl = (WLDFSystemResourceMBeanImpl)abstractDescriptorBean;
                super.finishCopy(wLDFSystemResourceMBeanImpl, bl, list);
                if ((list == null || !list.contains("Description")) && this.bean.isDescriptionSet()) {
                    wLDFSystemResourceMBeanImpl.setDescription(this.bean.getDescription());
                }
                if ((list == null || !list.contains("DescriptorFileName")) && this.bean.isDescriptorFileNameSet()) {
                    wLDFSystemResourceMBeanImpl.setDescriptorFileName(this.bean.getDescriptorFileName());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    wLDFSystemResourceMBeanImpl.setName(this.bean.getName());
                }
                return wLDFSystemResourceMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getResource(), clazz, object);
        }
    }
}

