/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.WLDFSystemResourceMBean;
import weblogic.utils.ArrayUtils;

public class WLDFSystemResourceValidator {
    public static void validateWLDFSystemResources(DomainMBean domainMBean) {
        WLDFSystemResourceMBean[] wLDFSystemResourceMBeanArray = domainMBean.getWLDFSystemResources();
        if (wLDFSystemResourceMBeanArray == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < wLDFSystemResourceMBeanArray.length; ++i) {
            TargetMBean[] targetMBeanArray = wLDFSystemResourceMBeanArray[i].getTargets();
            if (targetMBeanArray == null) continue;
            targetMBeanArray = WLDFSystemResourceValidator.getServersInTargets(targetMBeanArray);
            for (int j = 0; j < targetMBeanArray.length; ++j) {
                String string = targetMBeanArray[j].getName();
                if (hashSet.contains(string)) {
                    throw new IllegalArgumentException(DiagnosticsLogger.logTargettingMultipleWLDFSystemResourcesToServerLoggable((String)string).getMessage());
                }
                hashSet.add(string);
            }
        }
    }

    private static ServerMBean[] getServersInTargets(TargetMBean[] targetMBeanArray) {
        ArrayList<TargetMBean> arrayList = new ArrayList<TargetMBean>();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (targetMBean instanceof ServerMBean) {
                arrayList.add(targetMBean);
                continue;
            }
            if (targetMBean instanceof ClusterMBean) {
                ClusterMBean clusterMBean = (ClusterMBean)targetMBean;
                ArrayUtils.addAll(arrayList, (Object[])clusterMBean.getServers());
                continue;
            }
            throw new AssertionError((Object)"The list of targets contained a non-server or a non-cluster member");
        }
        ServerMBean[] serverMBeanArray = new ServerMBean[arrayList.size()];
        arrayList.toArray(serverMBeanArray);
        return serverMBeanArray;
    }
}

