/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import weblogic.diagnostics.i18n.DiagnosticsLogger;
import weblogic.diagnostics.i18n.DiagnosticsTextTextFormatter;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JDBCSystemResourceMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.WLDFDataRetirementMBean;
import weblogic.management.configuration.WLDFServerDiagnosticMBean;
import weblogic.management.configuration.WLDFSystemResourceMBean;
import weblogic.utils.ArrayUtils;

public class WLDFValidator {
    private static final DiagnosticsTextTextFormatter DIAG_TXT_FMT = DiagnosticsTextTextFormatter.getInstance();

    public static void validateWLDFSystemResources(DomainMBean domainMBean) {
        WLDFSystemResourceMBean[] wLDFSystemResourceMBeanArray = domainMBean.getWLDFSystemResources();
        if (wLDFSystemResourceMBeanArray == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < wLDFSystemResourceMBeanArray.length; ++i) {
            TargetMBean[] targetMBeanArray = wLDFSystemResourceMBeanArray[i].getTargets();
            if (targetMBeanArray == null) continue;
            targetMBeanArray = WLDFValidator.getServersInTargets(targetMBeanArray);
            for (int j = 0; j < targetMBeanArray.length; ++j) {
                String string = targetMBeanArray[j].getName();
                if (hashSet.contains(string)) {
                    throw new IllegalArgumentException(DiagnosticsLogger.logTargettingMultipleWLDFSystemResourcesToServerLoggable((String)string).getMessage());
                }
                hashSet.add(string);
            }
        }
    }

    public static void validateWLDFServerDiagnosticConfiguration(DomainMBean domainMBean) {
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = serverMBeanArray[i].getServerDiagnosticConfig();
            String string = wLDFServerDiagnosticMBean.getDiagnosticDataArchiveType();
            if (string.equals("JDBCArchive")) {
                JDBCSystemResourceMBean jDBCSystemResourceMBean = wLDFServerDiagnosticMBean.getDiagnosticJDBCResource();
                if (jDBCSystemResourceMBean == null) {
                    throw new IllegalArgumentException(DIAG_TXT_FMT.getNoJDBCSystemResourceConfiguredText(serverMBeanArray[i].getName()));
                }
                TargetMBean[] targetMBeanArray = jDBCSystemResourceMBean.getTargets();
                if (targetMBeanArray != null) {
                    ServerMBean[] serverMBeanArray2 = WLDFValidator.getServersInTargets(targetMBeanArray);
                    HashSet<String> hashSet = new HashSet<String>();
                    for (int j = 0; j < targetMBeanArray.length; ++j) {
                        hashSet.add(targetMBeanArray[j].getName());
                    }
                    if (!hashSet.contains(serverMBeanArray[i].getName())) {
                        throw new IllegalArgumentException(DIAG_TXT_FMT.getJDBCSystemResourceNotTargettedToServer(serverMBeanArray[i].getName(), jDBCSystemResourceMBean.getName()));
                    }
                } else {
                    throw new IllegalArgumentException(DIAG_TXT_FMT.getJDBCSystemResourceNotTargettedToServer(serverMBeanArray[i].getName(), jDBCSystemResourceMBean.getName()));
                }
            }
            WLDFValidator.validateDataRetirements(wLDFServerDiagnosticMBean);
        }
    }

    private static void validateDataRetirements(WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean) {
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        WLDFDataRetirementMBean[] wLDFDataRetirementMBeanArray = wLDFServerDiagnosticMBean.getWLDFDataRetirements();
        int n = wLDFDataRetirementMBeanArray != null ? wLDFDataRetirementMBeanArray.length : 0;
        for (int i = 0; i < n; ++i) {
            Object object = wLDFDataRetirementMBeanArray[i].getArchiveName();
            if (object != null) {
                object = ((String)object).trim();
            }
            if (object == null || ((String)object).length() <= 0) continue;
            Object object2 = (Integer)hashMap.get(object);
            int n2 = object2 != null ? (Integer)object2 : 0;
            hashMap.put(object, new Integer(n2 + 1));
        }
        Object object = null;
        for (Object object2 : hashMap.keySet()) {
            Integer n3 = (Integer)hashMap.get(object2);
            int n4 = n3 != null ? n3 : 0;
            if (n4 <= 1) continue;
            if (object == null) {
                object = object2;
                continue;
            }
            object = (String)object + "," + (String)object2;
        }
        if (object != null) {
            throw new IllegalArgumentException(DIAG_TXT_FMT.getDuplicateRetirementsErrorText(object));
        }
    }

    static ServerMBean[] getServersInTargets(TargetMBean[] targetMBeanArray) {
        ArrayList<TargetMBean> arrayList = new ArrayList<TargetMBean>();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (targetMBean instanceof ServerMBean) {
                arrayList.add(targetMBean);
                continue;
            }
            if (targetMBean instanceof ClusterMBean) {
                ClusterMBean clusterMBean = (ClusterMBean)targetMBean;
                ArrayUtils.addAll(arrayList, (Object[])clusterMBean.getServers());
                continue;
            }
            throw new AssertionError((Object)"The list of targets contained a non-server or a non-cluster member");
        }
        ServerMBean[] serverMBeanArray = new ServerMBean[arrayList.size()];
        arrayList.toArray(serverMBeanArray);
        return serverMBeanArray;
    }

    public static void validateDataRetirementArchiveName(WLDFDataRetirementMBean wLDFDataRetirementMBean, String string) throws IllegalArgumentException {
        ConfigurationValidator.validateName(string);
        WLDFServerDiagnosticMBean wLDFServerDiagnosticMBean = (WLDFServerDiagnosticMBean)wLDFDataRetirementMBean.getParent();
        WLDFDataRetirementMBean[] wLDFDataRetirementMBeanArray = wLDFServerDiagnosticMBean != null ? wLDFServerDiagnosticMBean.getWLDFDataRetirements() : null;
        int n = wLDFDataRetirementMBeanArray != null ? wLDFDataRetirementMBeanArray.length : 0;
        for (int i = 0; i < n; ++i) {
            WLDFDataRetirementMBean wLDFDataRetirementMBean2 = wLDFDataRetirementMBeanArray[i];
            if (wLDFDataRetirementMBean2.getName().equals(wLDFDataRetirementMBean.getName()) || !string.equals(wLDFDataRetirementMBean2.getArchiveName())) continue;
            throw new IllegalArgumentException(DIAG_TXT_FMT.getDuplicateRetirementsErrorText(string));
        }
        if (string.equals("HarvestedDataArchive") || string.equals("EventsDataArchive") || string.startsWith("CUSTOM/")) {
            return;
        }
        throw new IllegalArgumentException(DIAG_TXT_FMT.getInvalidArchiveNameForDataRetirementText(string, "HarvestedDataArchive | EventsDataArchive | CUSTOM/xxx"));
    }

    public static void validateDataRetirementTime(WLDFDataRetirementMBean wLDFDataRetirementMBean, int n) throws IllegalArgumentException {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException(DIAG_TXT_FMT.getInvalidRetirementTimeText(wLDFDataRetirementMBean.getName(), n));
        }
    }
}

