/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.WLECConnectionPoolMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class WLECConnectionPoolMBeanImpl
extends DeploymentMBeanImpl
implements WLECConnectionPoolMBean,
Serializable {
    private String _ApplicationPassword;
    private byte[] _ApplicationPasswordEncrypted;
    private boolean _CertificateAuthenticationEnabled;
    private String[] _FailoverAddresses;
    private int _MaximumEncryptionLevel;
    private int _MaximumPoolSize;
    private int _MinimumEncryptionLevel;
    private int _MinimumPoolSize;
    private String[] _PrimaryAddresses;
    private boolean _SecurityContextEnabled;
    private String _UserName;
    private String _UserPassword;
    private byte[] _UserPasswordEncrypted;
    private String _UserRole;
    private String _WLEDomain;
    private static SchemaHelper2 _schemaHelper;

    public WLECConnectionPoolMBeanImpl() {
        this._initializeProperty(-1);
    }

    public WLECConnectionPoolMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public String[] getPrimaryAddresses() {
        return this._PrimaryAddresses;
    }

    public boolean isPrimaryAddressesSet() {
        return this._isSet(9);
    }

    public void setPrimaryAddresses(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._PrimaryAddresses;
        this._PrimaryAddresses = stringArray;
        this._postSet(9, stringArray2, stringArray);
    }

    public boolean addPrimaryAddress(String string) throws InvalidAttributeValueException {
        this._getHelper()._ensureNonNull((Object)string);
        String[] stringArray = this._isSet(9) ? (String[])this._getHelper()._extendArray((Object)this.getPrimaryAddresses(), String.class, (Object)string) : new String[]{string};
        try {
            this.setPrimaryAddresses(stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return true;
    }

    public boolean removePrimaryAddress(String string) {
        String[] stringArray = this.getPrimaryAddresses();
        String[] stringArray2 = (String[])this._getHelper()._removeElement((Object)stringArray, String.class, (Object)string);
        if (stringArray2.length != stringArray.length) {
            try {
                this.setPrimaryAddresses(stringArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public String[] getFailoverAddresses() {
        return this._FailoverAddresses;
    }

    public boolean isFailoverAddressesSet() {
        return this._isSet(10);
    }

    public void setFailoverAddresses(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        String[] stringArray2 = this._FailoverAddresses;
        this._FailoverAddresses = stringArray;
        this._postSet(10, stringArray2, stringArray);
    }

    public boolean addFailoverAddress(String string) throws InvalidAttributeValueException {
        this._getHelper()._ensureNonNull((Object)string);
        String[] stringArray = this._isSet(10) ? (String[])this._getHelper()._extendArray((Object)this.getFailoverAddresses(), String.class, (Object)string) : new String[]{string};
        try {
            this.setFailoverAddresses(stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return true;
    }

    public boolean removeFailoverAddress(String string) {
        String[] stringArray = this.getFailoverAddresses();
        String[] stringArray2 = (String[])this._getHelper()._removeElement((Object)stringArray, String.class, (Object)string);
        if (stringArray2.length != stringArray.length) {
            try {
                this.setFailoverAddresses(stringArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public int getMinimumPoolSize() {
        return this._MinimumPoolSize;
    }

    public boolean isMinimumPoolSizeSet() {
        return this._isSet(11);
    }

    public void setMinimumPoolSize(int n) throws InvalidAttributeValueException {
        int n2 = this._MinimumPoolSize;
        this._MinimumPoolSize = n;
        this._postSet(11, n2, n);
    }

    public int getMaximumPoolSize() {
        return this._MaximumPoolSize;
    }

    public boolean isMaximumPoolSizeSet() {
        return this._isSet(12);
    }

    public void setMaximumPoolSize(int n) throws InvalidAttributeValueException {
        int n2 = this._MaximumPoolSize;
        this._MaximumPoolSize = n;
        this._postSet(12, n2, n);
    }

    public String getUserName() {
        return this._UserName;
    }

    public boolean isUserNameSet() {
        return this._isSet(13);
    }

    public void setUserName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._UserName;
        this._UserName = string;
        this._postSet(13, string2, string);
    }

    public String getUserPassword() {
        byte[] byArray = this.getUserPasswordEncrypted();
        return byArray == null ? null : this._decrypt("UserPassword", byArray);
    }

    public boolean isUserPasswordSet() {
        return this.isUserPasswordEncryptedSet();
    }

    public void setUserPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setUserPasswordEncrypted(string == null ? null : this._encrypt("UserPassword", string));
    }

    public byte[] getUserPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._UserPasswordEncrypted);
    }

    public String getUserPasswordEncryptedAsString() {
        byte[] byArray = this.getUserPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isUserPasswordEncryptedSet() {
        return this._isSet(15);
    }

    public void setUserPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setUserPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getApplicationPassword() {
        byte[] byArray = this.getApplicationPasswordEncrypted();
        return byArray == null ? null : this._decrypt("ApplicationPassword", byArray);
    }

    public boolean isApplicationPasswordSet() {
        return this.isApplicationPasswordEncryptedSet();
    }

    public void setApplicationPassword(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setApplicationPasswordEncrypted(string == null ? null : this._encrypt("ApplicationPassword", string));
    }

    public byte[] getApplicationPasswordEncrypted() {
        return this._getHelper()._cloneArray(this._ApplicationPasswordEncrypted);
    }

    public String getApplicationPasswordEncryptedAsString() {
        byte[] byArray = this.getApplicationPasswordEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isApplicationPasswordEncryptedSet() {
        return this._isSet(17);
    }

    public void setApplicationPasswordEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setApplicationPasswordEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getUserRole() {
        return this._UserRole;
    }

    public boolean isUserRoleSet() {
        return this._isSet(18);
    }

    public void setUserRole(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._UserRole;
        this._UserRole = string;
        this._postSet(18, string2, string);
    }

    public String getWLEDomain() {
        return this._WLEDomain;
    }

    public boolean isWLEDomainSet() {
        return this._isSet(19);
    }

    public void setWLEDomain(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._WLEDomain;
        this._WLEDomain = string;
        this._postSet(19, string2, string);
    }

    public int getMinimumEncryptionLevel() {
        return this._MinimumEncryptionLevel;
    }

    public boolean isMinimumEncryptionLevelSet() {
        return this._isSet(20);
    }

    public void setMinimumEncryptionLevel(int n) throws InvalidAttributeValueException {
        int n2 = this._MinimumEncryptionLevel;
        this._MinimumEncryptionLevel = n;
        this._postSet(20, n2, n);
    }

    public int getMaximumEncryptionLevel() {
        return this._MaximumEncryptionLevel;
    }

    public boolean isMaximumEncryptionLevelSet() {
        return this._isSet(21);
    }

    public void setMaximumEncryptionLevel(int n) throws InvalidAttributeValueException {
        int n2 = this._MaximumEncryptionLevel;
        this._MaximumEncryptionLevel = n;
        this._postSet(21, n2, n);
    }

    public boolean isCertificateAuthenticationEnabled() {
        return this._CertificateAuthenticationEnabled;
    }

    public boolean isCertificateAuthenticationEnabledSet() {
        return this._isSet(22);
    }

    public void setCertificateAuthenticationEnabled(boolean bl) {
        boolean bl2 = this._CertificateAuthenticationEnabled;
        this._CertificateAuthenticationEnabled = bl;
        this._postSet(22, bl2, bl);
    }

    public boolean isSecurityContextEnabled() {
        return this._SecurityContextEnabled;
    }

    public boolean isSecurityContextEnabledSet() {
        return this._isSet(23);
    }

    public void setSecurityContextEnabled(boolean bl) {
        boolean bl2 = this._SecurityContextEnabled;
        this._SecurityContextEnabled = bl;
        this._postSet(23, bl2, bl);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public void setApplicationPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._ApplicationPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: ApplicationPasswordEncrypted of WLECConnectionPoolMBean");
        }
        this._getHelper()._clearArray(this._ApplicationPasswordEncrypted);
        this._ApplicationPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(17, byArray2, byArray);
    }

    public void setUserPasswordEncrypted(byte[] byArray) {
        byte[] byArray2 = this._UserPasswordEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: UserPasswordEncrypted of WLECConnectionPoolMBean");
        }
        this._getHelper()._clearArray(this._UserPasswordEncrypted);
        this._UserPasswordEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(15, byArray2, byArray);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 16) {
                this._markSet(17, false);
            }
            if (n == 14) {
                this._markSet(15, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 16;
        }
        try {
            switch (n) {
                case 16: {
                    this._ApplicationPasswordEncrypted = null;
                    if (bl) break;
                }
                case 17: {
                    this._ApplicationPasswordEncrypted = null;
                    if (bl) break;
                }
                case 10: {
                    this._FailoverAddresses = new String[0];
                    if (bl) break;
                }
                case 21: {
                    this._MaximumEncryptionLevel = 128;
                    if (bl) break;
                }
                case 12: {
                    this._MaximumPoolSize = 1;
                    if (bl) break;
                }
                case 20: {
                    this._MinimumEncryptionLevel = 40;
                    if (bl) break;
                }
                case 11: {
                    this._MinimumPoolSize = 1;
                    if (bl) break;
                }
                case 9: {
                    this._PrimaryAddresses = new String[0];
                    if (bl) break;
                }
                case 13: {
                    this._UserName = null;
                    if (bl) break;
                }
                case 14: {
                    this._UserPasswordEncrypted = null;
                    if (bl) break;
                }
                case 15: {
                    this._UserPasswordEncrypted = null;
                    if (bl) break;
                }
                case 18: {
                    this._UserRole = null;
                    if (bl) break;
                }
                case 19: {
                    this._WLEDomain = null;
                    if (bl) break;
                }
                case 22: {
                    this._CertificateAuthenticationEnabled = false;
                    if (bl) break;
                }
                case 23: {
                    this._SecurityContextEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "WLECConnectionPool";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ApplicationPassword")) {
            String string2 = this._ApplicationPassword;
            this._ApplicationPassword = (String)object;
            this._postSet(16, string2, this._ApplicationPassword);
            return;
        }
        if (string.equals("ApplicationPasswordEncrypted")) {
            byte[] byArray = this._ApplicationPasswordEncrypted;
            this._ApplicationPasswordEncrypted = (byte[])object;
            this._postSet(17, byArray, this._ApplicationPasswordEncrypted);
            return;
        }
        if (string.equals("CertificateAuthenticationEnabled")) {
            boolean bl = this._CertificateAuthenticationEnabled;
            this._CertificateAuthenticationEnabled = (Boolean)object;
            this._postSet(22, bl, this._CertificateAuthenticationEnabled);
            return;
        }
        if (string.equals("FailoverAddresses")) {
            String[] stringArray = this._FailoverAddresses;
            this._FailoverAddresses = (String[])object;
            this._postSet(10, stringArray, this._FailoverAddresses);
            return;
        }
        if (string.equals("MaximumEncryptionLevel")) {
            int n = this._MaximumEncryptionLevel;
            this._MaximumEncryptionLevel = (Integer)object;
            this._postSet(21, n, this._MaximumEncryptionLevel);
            return;
        }
        if (string.equals("MaximumPoolSize")) {
            int n = this._MaximumPoolSize;
            this._MaximumPoolSize = (Integer)object;
            this._postSet(12, n, this._MaximumPoolSize);
            return;
        }
        if (string.equals("MinimumEncryptionLevel")) {
            int n = this._MinimumEncryptionLevel;
            this._MinimumEncryptionLevel = (Integer)object;
            this._postSet(20, n, this._MinimumEncryptionLevel);
            return;
        }
        if (string.equals("MinimumPoolSize")) {
            int n = this._MinimumPoolSize;
            this._MinimumPoolSize = (Integer)object;
            this._postSet(11, n, this._MinimumPoolSize);
            return;
        }
        if (string.equals("PrimaryAddresses")) {
            String[] stringArray = this._PrimaryAddresses;
            this._PrimaryAddresses = (String[])object;
            this._postSet(9, stringArray, this._PrimaryAddresses);
            return;
        }
        if (string.equals("SecurityContextEnabled")) {
            boolean bl = this._SecurityContextEnabled;
            this._SecurityContextEnabled = (Boolean)object;
            this._postSet(23, bl, this._SecurityContextEnabled);
            return;
        }
        if (string.equals("UserName")) {
            String string3 = this._UserName;
            this._UserName = (String)object;
            this._postSet(13, string3, this._UserName);
            return;
        }
        if (string.equals("UserPassword")) {
            String string4 = this._UserPassword;
            this._UserPassword = (String)object;
            this._postSet(14, string4, this._UserPassword);
            return;
        }
        if (string.equals("UserPasswordEncrypted")) {
            byte[] byArray = this._UserPasswordEncrypted;
            this._UserPasswordEncrypted = (byte[])object;
            this._postSet(15, byArray, this._UserPasswordEncrypted);
            return;
        }
        if (string.equals("UserRole")) {
            String string5 = this._UserRole;
            this._UserRole = (String)object;
            this._postSet(18, string5, this._UserRole);
            return;
        }
        if (string.equals("WLEDomain")) {
            String string6 = this._WLEDomain;
            this._WLEDomain = (String)object;
            this._postSet(19, string6, this._WLEDomain);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ApplicationPassword")) {
            return this._ApplicationPassword;
        }
        if (string.equals("ApplicationPasswordEncrypted")) {
            return this._ApplicationPasswordEncrypted;
        }
        if (string.equals("CertificateAuthenticationEnabled")) {
            return new Boolean(this._CertificateAuthenticationEnabled);
        }
        if (string.equals("FailoverAddresses")) {
            return this._FailoverAddresses;
        }
        if (string.equals("MaximumEncryptionLevel")) {
            return new Integer(this._MaximumEncryptionLevel);
        }
        if (string.equals("MaximumPoolSize")) {
            return new Integer(this._MaximumPoolSize);
        }
        if (string.equals("MinimumEncryptionLevel")) {
            return new Integer(this._MinimumEncryptionLevel);
        }
        if (string.equals("MinimumPoolSize")) {
            return new Integer(this._MinimumPoolSize);
        }
        if (string.equals("PrimaryAddresses")) {
            return this._PrimaryAddresses;
        }
        if (string.equals("SecurityContextEnabled")) {
            return new Boolean(this._SecurityContextEnabled);
        }
        if (string.equals("UserName")) {
            return this._UserName;
        }
        if (string.equals("UserPassword")) {
            return this._UserPassword;
        }
        if (string.equals("UserPasswordEncrypted")) {
            return this._UserPasswordEncrypted;
        }
        if (string.equals("UserRole")) {
            return this._UserRole;
        }
        if (string.equals("WLEDomain")) {
            return this._WLEDomain;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 20: {
                    if (!string.equals("application-password")) break;
                    return 16;
                }
                case 30: {
                    if (!string.equals("application-password-encrypted")) break;
                    return 17;
                }
                case 16: {
                    if (!string.equals("failover-address")) break;
                    return 10;
                }
                case 24: {
                    if (string.equals("maximum-encryption-level")) {
                        return 21;
                    }
                    if (string.equals("minimum-encryption-level")) {
                        return 20;
                    }
                    if (!string.equals("security-context-enabled")) break;
                    return 23;
                }
                case 17: {
                    if (string.equals("maximum-pool-size")) {
                        return 12;
                    }
                    if (!string.equals("minimum-pool-size")) break;
                    return 11;
                }
                case 15: {
                    if (!string.equals("primary-address")) break;
                    return 9;
                }
                case 9: {
                    if (string.equals("user-name")) {
                        return 13;
                    }
                    if (!string.equals("user-role")) break;
                    return 18;
                }
                case 13: {
                    if (!string.equals("user-password")) break;
                    return 14;
                }
                case 23: {
                    if (!string.equals("user-password-encrypted")) break;
                    return 15;
                }
                case 10: {
                    if (!string.equals("wle-domain")) break;
                    return 19;
                }
                case 34: {
                    if (!string.equals("certificate-authentication-enabled")) break;
                    return 22;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 16: {
                    return "application-password";
                }
                case 17: {
                    return "application-password-encrypted";
                }
                case 10: {
                    return "failover-address";
                }
                case 21: {
                    return "maximum-encryption-level";
                }
                case 12: {
                    return "maximum-pool-size";
                }
                case 20: {
                    return "minimum-encryption-level";
                }
                case 11: {
                    return "minimum-pool-size";
                }
                case 9: {
                    return "primary-address";
                }
                case 13: {
                    return "user-name";
                }
                case 14: {
                    return "user-password";
                }
                case 15: {
                    return "user-password-encrypted";
                }
                case 18: {
                    return "user-role";
                }
                case 19: {
                    return "wle-domain";
                }
                case 22: {
                    return "certificate-authentication-enabled";
                }
                case 23: {
                    return "security-context-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 7: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private WLECConnectionPoolMBeanImpl bean;

        protected Helper(WLECConnectionPoolMBeanImpl wLECConnectionPoolMBeanImpl) {
            super(wLECConnectionPoolMBeanImpl);
            this.bean = wLECConnectionPoolMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 16: {
                    return "ApplicationPassword";
                }
                case 17: {
                    return "ApplicationPasswordEncrypted";
                }
                case 10: {
                    return "FailoverAddresses";
                }
                case 21: {
                    return "MaximumEncryptionLevel";
                }
                case 12: {
                    return "MaximumPoolSize";
                }
                case 20: {
                    return "MinimumEncryptionLevel";
                }
                case 11: {
                    return "MinimumPoolSize";
                }
                case 9: {
                    return "PrimaryAddresses";
                }
                case 13: {
                    return "UserName";
                }
                case 14: {
                    return "UserPassword";
                }
                case 15: {
                    return "UserPasswordEncrypted";
                }
                case 18: {
                    return "UserRole";
                }
                case 19: {
                    return "WLEDomain";
                }
                case 22: {
                    return "CertificateAuthenticationEnabled";
                }
                case 23: {
                    return "SecurityContextEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ApplicationPassword")) {
                return 16;
            }
            if (string.equals("ApplicationPasswordEncrypted")) {
                return 17;
            }
            if (string.equals("FailoverAddresses")) {
                return 10;
            }
            if (string.equals("MaximumEncryptionLevel")) {
                return 21;
            }
            if (string.equals("MaximumPoolSize")) {
                return 12;
            }
            if (string.equals("MinimumEncryptionLevel")) {
                return 20;
            }
            if (string.equals("MinimumPoolSize")) {
                return 11;
            }
            if (string.equals("PrimaryAddresses")) {
                return 9;
            }
            if (string.equals("UserName")) {
                return 13;
            }
            if (string.equals("UserPassword")) {
                return 14;
            }
            if (string.equals("UserPasswordEncrypted")) {
                return 15;
            }
            if (string.equals("UserRole")) {
                return 18;
            }
            if (string.equals("WLEDomain")) {
                return 19;
            }
            if (string.equals("CertificateAuthenticationEnabled")) {
                return 22;
            }
            if (string.equals("SecurityContextEnabled")) {
                return 23;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isApplicationPasswordSet()) {
                    stringBuffer.append("ApplicationPassword");
                    stringBuffer.append(String.valueOf(this.bean.getApplicationPassword()));
                }
                if (this.bean.isApplicationPasswordEncryptedSet()) {
                    stringBuffer.append("ApplicationPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getApplicationPasswordEncrypted())));
                }
                if (this.bean.isFailoverAddressesSet()) {
                    stringBuffer.append("FailoverAddresses");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getFailoverAddresses())));
                }
                if (this.bean.isMaximumEncryptionLevelSet()) {
                    stringBuffer.append("MaximumEncryptionLevel");
                    stringBuffer.append(String.valueOf(this.bean.getMaximumEncryptionLevel()));
                }
                if (this.bean.isMaximumPoolSizeSet()) {
                    stringBuffer.append("MaximumPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaximumPoolSize()));
                }
                if (this.bean.isMinimumEncryptionLevelSet()) {
                    stringBuffer.append("MinimumEncryptionLevel");
                    stringBuffer.append(String.valueOf(this.bean.getMinimumEncryptionLevel()));
                }
                if (this.bean.isMinimumPoolSizeSet()) {
                    stringBuffer.append("MinimumPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getMinimumPoolSize()));
                }
                if (this.bean.isPrimaryAddressesSet()) {
                    stringBuffer.append("PrimaryAddresses");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getPrimaryAddresses())));
                }
                if (this.bean.isUserNameSet()) {
                    stringBuffer.append("UserName");
                    stringBuffer.append(String.valueOf(this.bean.getUserName()));
                }
                if (this.bean.isUserPasswordSet()) {
                    stringBuffer.append("UserPassword");
                    stringBuffer.append(String.valueOf(this.bean.getUserPassword()));
                }
                if (this.bean.isUserPasswordEncryptedSet()) {
                    stringBuffer.append("UserPasswordEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getUserPasswordEncrypted())));
                }
                if (this.bean.isUserRoleSet()) {
                    stringBuffer.append("UserRole");
                    stringBuffer.append(String.valueOf(this.bean.getUserRole()));
                }
                if (this.bean.isWLEDomainSet()) {
                    stringBuffer.append("WLEDomain");
                    stringBuffer.append(String.valueOf(this.bean.getWLEDomain()));
                }
                if (this.bean.isCertificateAuthenticationEnabledSet()) {
                    stringBuffer.append("CertificateAuthenticationEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCertificateAuthenticationEnabled()));
                }
                if (this.bean.isSecurityContextEnabledSet()) {
                    stringBuffer.append("SecurityContextEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSecurityContextEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WLECConnectionPoolMBeanImpl wLECConnectionPoolMBeanImpl = (WLECConnectionPoolMBeanImpl)abstractDescriptorBean;
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("ApplicationPasswordEncrypted", this.bean.getApplicationPasswordEncrypted(), wLECConnectionPoolMBeanImpl.getApplicationPasswordEncrypted(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("FailoverAddresses", this.bean.getFailoverAddresses(), wLECConnectionPoolMBeanImpl.getFailoverAddresses(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MaximumEncryptionLevel", this.bean.getMaximumEncryptionLevel(), wLECConnectionPoolMBeanImpl.getMaximumEncryptionLevel(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MaximumPoolSize", this.bean.getMaximumPoolSize(), wLECConnectionPoolMBeanImpl.getMaximumPoolSize(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MinimumEncryptionLevel", this.bean.getMinimumEncryptionLevel(), wLECConnectionPoolMBeanImpl.getMinimumEncryptionLevel(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MinimumPoolSize", this.bean.getMinimumPoolSize(), wLECConnectionPoolMBeanImpl.getMinimumPoolSize(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("PrimaryAddresses", this.bean.getPrimaryAddresses(), wLECConnectionPoolMBeanImpl.getPrimaryAddresses(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("UserName", this.bean.getUserName(), wLECConnectionPoolMBeanImpl.getUserName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("UserPasswordEncrypted", this.bean.getUserPasswordEncrypted(), wLECConnectionPoolMBeanImpl.getUserPasswordEncrypted(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("UserRole", this.bean.getUserRole(), wLECConnectionPoolMBeanImpl.getUserRole(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("WLEDomain", this.bean.getWLEDomain(), wLECConnectionPoolMBeanImpl.getWLEDomain(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("CertificateAuthenticationEnabled", this.bean.isCertificateAuthenticationEnabled(), wLECConnectionPoolMBeanImpl.isCertificateAuthenticationEnabled(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("SecurityContextEnabled", this.bean.isSecurityContextEnabled(), wLECConnectionPoolMBeanImpl.isSecurityContextEnabled(), false);
                }
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WLECConnectionPoolMBeanImpl wLECConnectionPoolMBeanImpl = (WLECConnectionPoolMBeanImpl)beanUpdateEvent.getSourceBean();
                WLECConnectionPoolMBeanImpl wLECConnectionPoolMBeanImpl2 = (WLECConnectionPoolMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("ApplicationPassword")) {
                    if (string.equals("ApplicationPasswordEncrypted")) {
                        wLECConnectionPoolMBeanImpl.setApplicationPasswordEncrypted(wLECConnectionPoolMBeanImpl2.getApplicationPasswordEncrypted());
                        wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("FailoverAddresses")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject(propertyUpdate.getAddedObject());
                            wLECConnectionPoolMBeanImpl.addFailoverAddress((String)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            wLECConnectionPoolMBeanImpl.removeFailoverAddress((String)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (wLECConnectionPoolMBeanImpl.getFailoverAddresses() == null || wLECConnectionPoolMBeanImpl.getFailoverAddresses().length == 0) {
                            wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                        }
                    } else if (string.equals("MaximumEncryptionLevel")) {
                        wLECConnectionPoolMBeanImpl.setMaximumEncryptionLevel(wLECConnectionPoolMBeanImpl2.getMaximumEncryptionLevel());
                        wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    } else if (string.equals("MaximumPoolSize")) {
                        wLECConnectionPoolMBeanImpl.setMaximumPoolSize(wLECConnectionPoolMBeanImpl2.getMaximumPoolSize());
                        wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                    } else if (string.equals("MinimumEncryptionLevel")) {
                        wLECConnectionPoolMBeanImpl.setMinimumEncryptionLevel(wLECConnectionPoolMBeanImpl2.getMinimumEncryptionLevel());
                        wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                    } else if (string.equals("MinimumPoolSize")) {
                        wLECConnectionPoolMBeanImpl.setMinimumPoolSize(wLECConnectionPoolMBeanImpl2.getMinimumPoolSize());
                        wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                    } else if (string.equals("PrimaryAddresses")) {
                        if (n == 2) {
                            propertyUpdate.resetAddedObject(propertyUpdate.getAddedObject());
                            wLECConnectionPoolMBeanImpl.addPrimaryAddress((String)propertyUpdate.getAddedObject());
                        } else if (n == 3) {
                            wLECConnectionPoolMBeanImpl.removePrimaryAddress((String)propertyUpdate.getRemovedObject());
                        } else {
                            throw new AssertionError((Object)("Invalid type: " + n));
                        }
                        if (wLECConnectionPoolMBeanImpl.getPrimaryAddresses() == null || wLECConnectionPoolMBeanImpl.getPrimaryAddresses().length == 0) {
                            wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                        }
                    } else if (string.equals("UserName")) {
                        wLECConnectionPoolMBeanImpl.setUserName(wLECConnectionPoolMBeanImpl2.getUserName());
                        wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (!string.equals("UserPassword")) {
                        if (string.equals("UserPasswordEncrypted")) {
                            wLECConnectionPoolMBeanImpl.setUserPasswordEncrypted(wLECConnectionPoolMBeanImpl2.getUserPasswordEncrypted());
                            wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                        } else if (string.equals("UserRole")) {
                            wLECConnectionPoolMBeanImpl.setUserRole(wLECConnectionPoolMBeanImpl2.getUserRole());
                            wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                        } else if (string.equals("WLEDomain")) {
                            wLECConnectionPoolMBeanImpl.setWLEDomain(wLECConnectionPoolMBeanImpl2.getWLEDomain());
                            wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                        } else if (string.equals("CertificateAuthenticationEnabled")) {
                            wLECConnectionPoolMBeanImpl.setCertificateAuthenticationEnabled(wLECConnectionPoolMBeanImpl2.isCertificateAuthenticationEnabled());
                            wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                        } else if (string.equals("SecurityContextEnabled")) {
                            wLECConnectionPoolMBeanImpl.setSecurityContextEnabled(wLECConnectionPoolMBeanImpl2.isSecurityContextEnabled());
                            wLECConnectionPoolMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                        } else {
                            super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                Object[] objectArray;
                WLECConnectionPoolMBeanImpl wLECConnectionPoolMBeanImpl = (WLECConnectionPoolMBeanImpl)abstractDescriptorBean;
                super.finishCopy(wLECConnectionPoolMBeanImpl, bl, list);
                if (bl && (list == null || !list.contains("ApplicationPasswordEncrypted")) && this.bean.isApplicationPasswordEncryptedSet()) {
                    objectArray = this.bean.getApplicationPasswordEncrypted();
                    wLECConnectionPoolMBeanImpl.setApplicationPasswordEncrypted(objectArray == null ? null : (byte[])objectArray.clone());
                }
                if (bl && (list == null || !list.contains("FailoverAddresses")) && this.bean.isFailoverAddressesSet()) {
                    objectArray = this.bean.getFailoverAddresses();
                    wLECConnectionPoolMBeanImpl.setFailoverAddresses(objectArray == null ? null : (String[])((String[])objectArray).clone());
                }
                if (bl && (list == null || !list.contains("MaximumEncryptionLevel")) && this.bean.isMaximumEncryptionLevelSet()) {
                    wLECConnectionPoolMBeanImpl.setMaximumEncryptionLevel(this.bean.getMaximumEncryptionLevel());
                }
                if (bl && (list == null || !list.contains("MaximumPoolSize")) && this.bean.isMaximumPoolSizeSet()) {
                    wLECConnectionPoolMBeanImpl.setMaximumPoolSize(this.bean.getMaximumPoolSize());
                }
                if (bl && (list == null || !list.contains("MinimumEncryptionLevel")) && this.bean.isMinimumEncryptionLevelSet()) {
                    wLECConnectionPoolMBeanImpl.setMinimumEncryptionLevel(this.bean.getMinimumEncryptionLevel());
                }
                if (bl && (list == null || !list.contains("MinimumPoolSize")) && this.bean.isMinimumPoolSizeSet()) {
                    wLECConnectionPoolMBeanImpl.setMinimumPoolSize(this.bean.getMinimumPoolSize());
                }
                if (bl && (list == null || !list.contains("PrimaryAddresses")) && this.bean.isPrimaryAddressesSet()) {
                    objectArray = this.bean.getPrimaryAddresses();
                    wLECConnectionPoolMBeanImpl.setPrimaryAddresses(objectArray == null ? null : (String[])((String[])objectArray).clone());
                }
                if (bl && (list == null || !list.contains("UserName")) && this.bean.isUserNameSet()) {
                    wLECConnectionPoolMBeanImpl.setUserName(this.bean.getUserName());
                }
                if (bl && (list == null || !list.contains("UserPasswordEncrypted")) && this.bean.isUserPasswordEncryptedSet()) {
                    objectArray = this.bean.getUserPasswordEncrypted();
                    wLECConnectionPoolMBeanImpl.setUserPasswordEncrypted(objectArray == null ? null : (byte[])objectArray.clone());
                }
                if (bl && (list == null || !list.contains("UserRole")) && this.bean.isUserRoleSet()) {
                    wLECConnectionPoolMBeanImpl.setUserRole(this.bean.getUserRole());
                }
                if (bl && (list == null || !list.contains("WLEDomain")) && this.bean.isWLEDomainSet()) {
                    wLECConnectionPoolMBeanImpl.setWLEDomain(this.bean.getWLEDomain());
                }
                if (bl && (list == null || !list.contains("CertificateAuthenticationEnabled")) && this.bean.isCertificateAuthenticationEnabledSet()) {
                    wLECConnectionPoolMBeanImpl.setCertificateAuthenticationEnabled(this.bean.isCertificateAuthenticationEnabled());
                }
                if (bl && (list == null || !list.contains("SecurityContextEnabled")) && this.bean.isSecurityContextEnabledSet()) {
                    wLECConnectionPoolMBeanImpl.setSecurityContextEnabled(this.bean.isSecurityContextEnabled());
                }
                return wLECConnectionPoolMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

