/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.util.StringTokenizer;
import javax.management.InvalidAttributeValueException;
import weblogic.logging.Loggable;
import weblogic.management.configuration.WTCLocalTuxDomMBean;
import weblogic.management.configuration.WTCRemoteTuxDomMBean;
import weblogic.utils.net.InetAddressHelper;
import weblogic.wtc.WTCLogger;

public final class WTCLegalHelper {
    public static boolean isMinLteMax(WTCLocalTuxDomMBean wTCLocalTuxDomMBean, String string) throws InvalidAttributeValueException {
        String string2 = wTCLocalTuxDomMBean.getMaxEncryptBits();
        if (Integer.parseInt(string, 10) > Integer.parseInt(string2, 10)) {
            String string3 = wTCLocalTuxDomMBean.getAccessPointId();
            Loggable loggable = WTCLogger.logMinEncryptBitsGreaterThanMaxEncryptBitsLoggable("Local", string3);
            throw new InvalidAttributeValueException(loggable.getMessage());
        }
        return true;
    }

    public static boolean isMinLteMax(WTCRemoteTuxDomMBean wTCRemoteTuxDomMBean, String string) throws InvalidAttributeValueException {
        String string2 = wTCRemoteTuxDomMBean.getMaxEncryptBits();
        if (Integer.parseInt(string, 10) > Integer.parseInt(string2, 10)) {
            String string3 = wTCRemoteTuxDomMBean.getAccessPointId();
            Loggable loggable = WTCLogger.logMinEncryptBitsGreaterThanMaxEncryptBitsLoggable("Remote", string3);
            throw new InvalidAttributeValueException(loggable.getMessage());
        }
        return true;
    }

    public static boolean isMaxGteMin(WTCLocalTuxDomMBean wTCLocalTuxDomMBean, String string) throws InvalidAttributeValueException {
        String string2 = wTCLocalTuxDomMBean.getMinEncryptBits();
        if (Integer.parseInt(string, 10) < Integer.parseInt(string2, 10)) {
            String string3 = wTCLocalTuxDomMBean.getAccessPointId();
            Loggable loggable = WTCLogger.logMinEncryptBitsGreaterThanMaxEncryptBitsLoggable("Local", string3);
            throw new InvalidAttributeValueException(loggable.getMessage());
        }
        return true;
    }

    public static boolean isMaxGteMin(WTCRemoteTuxDomMBean wTCRemoteTuxDomMBean, String string) throws InvalidAttributeValueException {
        String string2 = wTCRemoteTuxDomMBean.getMinEncryptBits();
        if (Integer.parseInt(string, 10) < Integer.parseInt(string2, 10)) {
            String string3 = wTCRemoteTuxDomMBean.getAccessPointId();
            Loggable loggable = WTCLogger.logMinEncryptBitsGreaterThanMaxEncryptBitsLoggable("Remote", string3);
            throw new InvalidAttributeValueException(loggable.getMessage());
        }
        return true;
    }

    public static boolean checkNWAddrFormat(String string, String string2) throws InvalidAttributeValueException {
        String string3;
        if (string2 != null && string2.toLowerCase().startsWith("sdp://")) {
            string2 = string2.substring(4);
        }
        if (InetAddressHelper.isIPV6Address((String)string2)) {
            return true;
        }
        boolean bl = true;
        int n = 0;
        if (string2 != null) {
            n = string2.indexOf(58);
        }
        if (string2 == null || !string2.startsWith("//") || n < 3 || n + 1 >= string2.length()) {
            bl = false;
        }
        if (bl && Character.isDigit((string3 = string2.substring(2, n)).charAt(0))) {
            int n2 = 0;
            int n3 = 0;
            String string4 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ".");
            while (stringTokenizer.hasMoreTokens()) {
                block15: {
                    string4 = stringTokenizer.nextToken();
                    try {
                        n3 = Integer.parseInt(string4, 10);
                        if (n3 < 0 || n3 > 255) {
                            bl = false;
                        }
                        break block15;
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    break;
                }
                ++n2;
            }
            if (n2 != 4) {
                bl = false;
            }
        }
        if (bl) {
            try {
                if (Integer.parseInt(string2.substring(n + 1), 10) < 0) {
                    bl = false;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        if (!bl) {
            string3 = WTCLogger.logInvalidMBeanAttrLoggable("NWAddr", string);
            throw new InvalidAttributeValueException(string3.getMessage());
        }
        return true;
    }

    public static boolean isNWAddrFormat(String string, String string2) throws InvalidAttributeValueException {
        if (string2 == null) {
            return WTCLegalHelper.checkNWAddrFormat(string, string2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
            if (WTCLegalHelper.checkNWAddrFormat(string, stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public static void validateWTCLocalTuxDom(WTCLocalTuxDomMBean wTCLocalTuxDomMBean) throws IllegalArgumentException {
        String string = wTCLocalTuxDomMBean.getName();
        String string2 = wTCLocalTuxDomMBean.getNWAddr();
        String string3 = wTCLocalTuxDomMBean.getMinEncryptBits();
        String string4 = wTCLocalTuxDomMBean.getMaxEncryptBits();
        try {
            if (!WTCLegalHelper.isNWAddrFormat(string, string2)) {
                throw new IllegalArgumentException("Invalid value for NWAddr: " + string2);
            }
            if (!WTCLegalHelper.isMinLteMax(wTCLocalTuxDomMBean, string3)) {
                String string5 = "Invalid value for MinEncryptBits: " + string3;
                throw new IllegalArgumentException(string5);
            }
            if (!WTCLegalHelper.isMaxGteMin(wTCLocalTuxDomMBean, string4)) {
                String string6 = "Invalid value for MaxEncryptBits: " + string4;
                throw new IllegalArgumentException(string6);
            }
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new IllegalArgumentException(invalidAttributeValueException.getMessage());
        }
    }

    public static void validateWTCRemoteTuxDom(WTCRemoteTuxDomMBean wTCRemoteTuxDomMBean) throws IllegalArgumentException {
        String string = wTCRemoteTuxDomMBean.getName();
        String string2 = wTCRemoteTuxDomMBean.getNWAddr();
        String string3 = wTCRemoteTuxDomMBean.getMinEncryptBits();
        String string4 = wTCRemoteTuxDomMBean.getMaxEncryptBits();
        try {
            if (!WTCLegalHelper.isNWAddrFormat(string, string2)) {
                throw new IllegalArgumentException("Invalid value for NWAddr: " + string2);
            }
            if (!WTCLegalHelper.isMinLteMax(wTCRemoteTuxDomMBean, string3)) {
                String string5 = "Invalid value for MinEncryptBits: " + string3;
                throw new IllegalArgumentException(string5);
            }
            if (!WTCLegalHelper.isMaxGteMin(wTCRemoteTuxDomMBean, string4)) {
                String string6 = "Invalid value for MaxEncryptBits: " + string4;
                throw new IllegalArgumentException(string6);
            }
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new IllegalArgumentException(invalidAttributeValueException.getMessage());
        }
    }
}

