/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.WTCLegalHelper;
import weblogic.management.configuration.WTCLocalTuxDomMBean;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class WTCLocalTuxDomMBeanImpl
extends ConfigurationMBeanImpl
implements WTCLocalTuxDomMBean,
Serializable {
    private String _AccessPoint;
    private String _AccessPointId;
    private long _BlockTime;
    private int _CmpLimit;
    private String _ConnPrincipalName;
    private String _ConnectionPolicy;
    private String _IdentityKeyStoreFileName;
    private String _IdentityKeyStorePassPhrase;
    private byte[] _IdentityKeyStorePassPhraseEncrypted;
    private String _Interoperate;
    private int _KeepAlive;
    private int _KeepAliveWait;
    private String _KeyStoresLocation;
    private String _MaxEncryptBits;
    private long _MaxRetries;
    private String _MinEncryptBits;
    private String _NWAddr;
    private String _PrivateKeyAlias;
    private String _PrivateKeyPassPhrase;
    private byte[] _PrivateKeyPassPhraseEncrypted;
    private long _RetryInterval;
    private String _Security;
    private String _TrustKeyStoreFileName;
    private String _TrustKeyStorePassPhrase;
    private byte[] _TrustKeyStorePassPhraseEncrypted;
    private String _UseSSL;
    private static SchemaHelper2 _schemaHelper;

    public WTCLocalTuxDomMBeanImpl() {
        this._initializeProperty(-1);
    }

    public WTCLocalTuxDomMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public void setAccessPoint(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"AccessPoint", (Object)string);
        String string2 = this._AccessPoint;
        this._AccessPoint = string;
        this._postSet(7, string2, string);
    }

    public String getAccessPoint() {
        return this._AccessPoint;
    }

    public boolean isAccessPointSet() {
        return this._isSet(7);
    }

    public void setAccessPointId(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"AccessPointId", (Object)string);
        String string2 = this._AccessPointId;
        this._AccessPointId = string;
        this._postSet(8, string2, string);
    }

    public String getAccessPointId() {
        return this._AccessPointId;
    }

    public boolean isAccessPointIdSet() {
        return this._isSet(8);
    }

    public void setSecurity(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"NONE", "APP_PW", "DM_PW"};
        string = LegalChecks.checkInEnum((String)"Security", (String)string, (String[])stringArray);
        String string2 = this._Security;
        this._Security = string;
        this._postSet(9, string2, string);
    }

    public String getSecurity() {
        return this._Security;
    }

    public boolean isSecuritySet() {
        return this._isSet(9);
    }

    public void setConnectionPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"ON_DEMAND", "ON_STARTUP", "INCOMING_ONLY"};
        string = LegalChecks.checkInEnum((String)"ConnectionPolicy", (String)string, (String[])stringArray);
        String string2 = this._ConnectionPolicy;
        this._ConnectionPolicy = string;
        this._postSet(10, string2, string);
    }

    public String getConnectionPolicy() {
        return this._ConnectionPolicy;
    }

    public boolean isConnectionPolicySet() {
        return this._isSet(10);
    }

    public void setConnPrincipalName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ConnPrincipalName;
        this._ConnPrincipalName = string;
        this._postSet(11, string2, string);
    }

    public String getConnPrincipalName() {
        return this._ConnPrincipalName;
    }

    public boolean isConnPrincipalNameSet() {
        return this._isSet(11);
    }

    public void setRetryInterval(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RetryInterval", (long)l, (long)0L, (long)Integer.MAX_VALUE);
        long l2 = this._RetryInterval;
        this._RetryInterval = l;
        this._postSet(12, l2, l);
    }

    public long getRetryInterval() {
        return this._RetryInterval;
    }

    public boolean isRetryIntervalSet() {
        return this._isSet(12);
    }

    public void setMaxRetries(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MaxRetries", (long)l, (long)0L, (long)Long.MAX_VALUE);
        long l2 = this._MaxRetries;
        this._MaxRetries = l;
        this._postSet(13, l2, l);
    }

    public long getMaxRetries() {
        return this._MaxRetries;
    }

    public boolean isMaxRetriesSet() {
        return this._isSet(13);
    }

    public void setBlockTime(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"BlockTime", (long)l, (long)0L, (long)Integer.MAX_VALUE);
        long l2 = this._BlockTime;
        this._BlockTime = l;
        this._postSet(14, l2, l);
    }

    public long getBlockTime() {
        return this._BlockTime;
    }

    public boolean isBlockTimeSet() {
        return this._isSet(14);
    }

    public void setNWAddr(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._NWAddr;
        this._NWAddr = string;
        this._postSet(15, string2, string);
    }

    public String getNWAddr() {
        return this._NWAddr;
    }

    public boolean isNWAddrSet() {
        return this._isSet(15);
    }

    public void setCmpLimit(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"CmpLimit", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._CmpLimit;
        this._CmpLimit = n;
        this._postSet(16, n2, n);
    }

    public int getCmpLimit() {
        return this._CmpLimit;
    }

    public boolean isCmpLimitSet() {
        return this._isSet(16);
    }

    public void setMinEncryptBits(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"0", "40", "56", "128", "256"};
        string = LegalChecks.checkInEnum((String)"MinEncryptBits", (String)string, (String[])stringArray);
        String string2 = this._MinEncryptBits;
        this._MinEncryptBits = string;
        this._postSet(17, string2, string);
    }

    public String getMinEncryptBits() {
        return this._MinEncryptBits;
    }

    public boolean isMinEncryptBitsSet() {
        return this._isSet(17);
    }

    public void setMaxEncryptBits(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"0", "40", "56", "128", "256"};
        string = LegalChecks.checkInEnum((String)"MaxEncryptBits", (String)string, (String[])stringArray);
        String string2 = this._MaxEncryptBits;
        this._MaxEncryptBits = string;
        this._postSet(18, string2, string);
    }

    public String getMaxEncryptBits() {
        return this._MaxEncryptBits;
    }

    public boolean isMaxEncryptBitsSet() {
        return this._isSet(18);
    }

    public void setInteroperate(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Yes", "No"};
        string = LegalChecks.checkInEnum((String)"Interoperate", (String)string, (String[])stringArray);
        String string2 = this._Interoperate;
        this._Interoperate = string;
        this._postSet(19, string2, string);
    }

    public String getInteroperate() {
        return this._Interoperate;
    }

    public boolean isInteroperateSet() {
        return this._isSet(19);
    }

    public void setKeepAlive(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"KeepAlive", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._KeepAlive;
        this._KeepAlive = n;
        this._postSet(20, n2, n);
    }

    public int getKeepAlive() {
        return this._KeepAlive;
    }

    public boolean isKeepAliveSet() {
        return this._isSet(20);
    }

    public void setKeepAliveWait(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"KeepAliveWait", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._KeepAliveWait;
        this._KeepAliveWait = n;
        this._postSet(21, n2, n);
    }

    public int getKeepAliveWait() {
        return this._KeepAliveWait;
    }

    public boolean isKeepAliveWaitSet() {
        return this._isSet(21);
    }

    public String getUseSSL() {
        return this._UseSSL;
    }

    public boolean isUseSSLSet() {
        return this._isSet(22);
    }

    public void setUseSSL(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"Off", "TwoWay", "OneWay"};
        string = LegalChecks.checkInEnum((String)"UseSSL", (String)string, (String[])stringArray);
        String string2 = this._UseSSL;
        this._UseSSL = string;
        this._postSet(22, string2, string);
    }

    public String getKeyStoresLocation() {
        return this._KeyStoresLocation;
    }

    public boolean isKeyStoresLocationSet() {
        return this._isSet(23);
    }

    public void setKeyStoresLocation(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"WLS Stores", "Custom Stores"};
        string = LegalChecks.checkInEnum((String)"KeyStoresLocation", (String)string, (String[])stringArray);
        String string2 = this._KeyStoresLocation;
        this._KeyStoresLocation = string;
        this._postSet(23, string2, string);
    }

    public String getIdentityKeyStoreFileName() {
        return this._IdentityKeyStoreFileName;
    }

    public boolean isIdentityKeyStoreFileNameSet() {
        return this._isSet(24);
    }

    public void setIdentityKeyStoreFileName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._IdentityKeyStoreFileName;
        this._IdentityKeyStoreFileName = string;
        this._postSet(24, string2, string);
    }

    public String getIdentityKeyStorePassPhrase() {
        byte[] byArray = this.getIdentityKeyStorePassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("IdentityKeyStorePassPhrase", byArray);
    }

    public boolean isIdentityKeyStorePassPhraseSet() {
        return this.isIdentityKeyStorePassPhraseEncryptedSet();
    }

    public void setIdentityKeyStorePassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setIdentityKeyStorePassPhraseEncrypted(string == null ? null : this._encrypt("IdentityKeyStorePassPhrase", string));
    }

    public byte[] getIdentityKeyStorePassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._IdentityKeyStorePassPhraseEncrypted);
    }

    public String getIdentityKeyStorePassPhraseEncryptedAsString() {
        byte[] byArray = this.getIdentityKeyStorePassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isIdentityKeyStorePassPhraseEncryptedSet() {
        return this._isSet(26);
    }

    public void setIdentityKeyStorePassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setIdentityKeyStorePassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getPrivateKeyAlias() {
        return this._PrivateKeyAlias;
    }

    public boolean isPrivateKeyAliasSet() {
        return this._isSet(27);
    }

    public void setPrivateKeyAlias(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._PrivateKeyAlias;
        this._PrivateKeyAlias = string;
        this._postSet(27, string2, string);
    }

    public String getPrivateKeyPassPhrase() {
        byte[] byArray = this.getPrivateKeyPassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("PrivateKeyPassPhrase", byArray);
    }

    public boolean isPrivateKeyPassPhraseSet() {
        return this.isPrivateKeyPassPhraseEncryptedSet();
    }

    public void setPrivateKeyPassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setPrivateKeyPassPhraseEncrypted(string == null ? null : this._encrypt("PrivateKeyPassPhrase", string));
    }

    public byte[] getPrivateKeyPassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._PrivateKeyPassPhraseEncrypted);
    }

    public String getPrivateKeyPassPhraseEncryptedAsString() {
        byte[] byArray = this.getPrivateKeyPassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isPrivateKeyPassPhraseEncryptedSet() {
        return this._isSet(29);
    }

    public void setPrivateKeyPassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setPrivateKeyPassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public String getTrustKeyStoreFileName() {
        return this._TrustKeyStoreFileName;
    }

    public boolean isTrustKeyStoreFileNameSet() {
        return this._isSet(30);
    }

    public void setTrustKeyStoreFileName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._TrustKeyStoreFileName;
        this._TrustKeyStoreFileName = string;
        this._postSet(30, string2, string);
    }

    public String getTrustKeyStorePassPhrase() {
        byte[] byArray = this.getTrustKeyStorePassPhraseEncrypted();
        return byArray == null ? null : this._decrypt("TrustKeyStorePassPhrase", byArray);
    }

    public boolean isTrustKeyStorePassPhraseSet() {
        return this.isTrustKeyStorePassPhraseEncryptedSet();
    }

    public void setTrustKeyStorePassPhrase(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        this.setTrustKeyStorePassPhraseEncrypted(string == null ? null : this._encrypt("TrustKeyStorePassPhrase", string));
    }

    public byte[] getTrustKeyStorePassPhraseEncrypted() {
        return this._getHelper()._cloneArray(this._TrustKeyStorePassPhraseEncrypted);
    }

    public String getTrustKeyStorePassPhraseEncryptedAsString() {
        byte[] byArray = this.getTrustKeyStorePassPhraseEncrypted();
        return byArray == null ? null : new String(byArray);
    }

    public boolean isTrustKeyStorePassPhraseEncryptedSet() {
        return this._isSet(32);
    }

    public void setTrustKeyStorePassPhraseEncryptedAsString(String string) {
        try {
            byte[] byArray = string == null ? null : string.getBytes();
            this.setTrustKeyStorePassPhraseEncrypted(byArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        WTCLegalHelper.validateWTCLocalTuxDom(this);
    }

    public void setIdentityKeyStorePassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._IdentityKeyStorePassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: IdentityKeyStorePassPhraseEncrypted of WTCLocalTuxDomMBean");
        }
        this._getHelper()._clearArray(this._IdentityKeyStorePassPhraseEncrypted);
        this._IdentityKeyStorePassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(26, byArray2, byArray);
    }

    public void setPrivateKeyPassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._PrivateKeyPassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: PrivateKeyPassPhraseEncrypted of WTCLocalTuxDomMBean");
        }
        this._getHelper()._clearArray(this._PrivateKeyPassPhraseEncrypted);
        this._PrivateKeyPassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(29, byArray2, byArray);
    }

    public void setTrustKeyStorePassPhraseEncrypted(byte[] byArray) {
        byte[] byArray2 = this._TrustKeyStorePassPhraseEncrypted;
        if (this._isProductionModeEnabled() && byArray != null && !this._isEncrypted(byArray)) {
            throw new IllegalArgumentException("In production mode, it's not allowed to set a clear text value to the property: TrustKeyStorePassPhraseEncrypted of WTCLocalTuxDomMBean");
        }
        this._getHelper()._clearArray(this._TrustKeyStorePassPhraseEncrypted);
        this._TrustKeyStorePassPhraseEncrypted = this._getHelper()._cloneArray(byArray);
        this._postSet(32, byArray2, byArray);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
            if (n == 25) {
                this._markSet(26, false);
            }
            if (n == 28) {
                this._markSet(29, false);
            }
            if (n == 31) {
                this._markSet(32, false);
            }
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 7;
        }
        try {
            switch (n) {
                case 7: {
                    this._AccessPoint = "myLAP";
                    if (bl) break;
                }
                case 8: {
                    this._AccessPointId = "myLAPId";
                    if (bl) break;
                }
                case 14: {
                    this._BlockTime = 60L;
                    if (bl) break;
                }
                case 16: {
                    this._CmpLimit = Integer.MAX_VALUE;
                    if (bl) break;
                }
                case 11: {
                    this._ConnPrincipalName = null;
                    if (bl) break;
                }
                case 10: {
                    this._ConnectionPolicy = "ON_DEMAND";
                    if (bl) break;
                }
                case 24: {
                    this._IdentityKeyStoreFileName = null;
                    if (bl) break;
                }
                case 25: {
                    this._IdentityKeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 26: {
                    this._IdentityKeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 19: {
                    this._Interoperate = "No";
                    if (bl) break;
                }
                case 20: {
                    this._KeepAlive = 0;
                    if (bl) break;
                }
                case 21: {
                    this._KeepAliveWait = 0;
                    if (bl) break;
                }
                case 23: {
                    this._KeyStoresLocation = "Custom Stores";
                    if (bl) break;
                }
                case 18: {
                    this._MaxEncryptBits = "128";
                    if (bl) break;
                }
                case 13: {
                    this._MaxRetries = Long.MAX_VALUE;
                    if (bl) break;
                }
                case 17: {
                    this._MinEncryptBits = "0";
                    if (bl) break;
                }
                case 15: {
                    this._NWAddr = "//localhost:8901";
                    if (bl) break;
                }
                case 27: {
                    this._PrivateKeyAlias = null;
                    if (bl) break;
                }
                case 28: {
                    this._PrivateKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 29: {
                    this._PrivateKeyPassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 12: {
                    this._RetryInterval = 60L;
                    if (bl) break;
                }
                case 9: {
                    this._Security = "NONE";
                    if (bl) break;
                }
                case 30: {
                    this._TrustKeyStoreFileName = null;
                    if (bl) break;
                }
                case 31: {
                    this._TrustKeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 32: {
                    this._TrustKeyStorePassPhraseEncrypted = null;
                    if (bl) break;
                }
                case 22: {
                    this._UseSSL = "Off";
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "WTCLocalTuxDom";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AccessPoint")) {
            String string2 = this._AccessPoint;
            this._AccessPoint = (String)object;
            this._postSet(7, string2, this._AccessPoint);
            return;
        }
        if (string.equals("AccessPointId")) {
            String string3 = this._AccessPointId;
            this._AccessPointId = (String)object;
            this._postSet(8, string3, this._AccessPointId);
            return;
        }
        if (string.equals("BlockTime")) {
            long l = this._BlockTime;
            this._BlockTime = (Long)object;
            this._postSet(14, l, this._BlockTime);
            return;
        }
        if (string.equals("CmpLimit")) {
            int n = this._CmpLimit;
            this._CmpLimit = (Integer)object;
            this._postSet(16, n, this._CmpLimit);
            return;
        }
        if (string.equals("ConnPrincipalName")) {
            String string4 = this._ConnPrincipalName;
            this._ConnPrincipalName = (String)object;
            this._postSet(11, string4, this._ConnPrincipalName);
            return;
        }
        if (string.equals("ConnectionPolicy")) {
            String string5 = this._ConnectionPolicy;
            this._ConnectionPolicy = (String)object;
            this._postSet(10, string5, this._ConnectionPolicy);
            return;
        }
        if (string.equals("IdentityKeyStoreFileName")) {
            String string6 = this._IdentityKeyStoreFileName;
            this._IdentityKeyStoreFileName = (String)object;
            this._postSet(24, string6, this._IdentityKeyStoreFileName);
            return;
        }
        if (string.equals("IdentityKeyStorePassPhrase")) {
            String string7 = this._IdentityKeyStorePassPhrase;
            this._IdentityKeyStorePassPhrase = (String)object;
            this._postSet(25, string7, this._IdentityKeyStorePassPhrase);
            return;
        }
        if (string.equals("IdentityKeyStorePassPhraseEncrypted")) {
            byte[] byArray = this._IdentityKeyStorePassPhraseEncrypted;
            this._IdentityKeyStorePassPhraseEncrypted = (byte[])object;
            this._postSet(26, byArray, this._IdentityKeyStorePassPhraseEncrypted);
            return;
        }
        if (string.equals("Interoperate")) {
            String string8 = this._Interoperate;
            this._Interoperate = (String)object;
            this._postSet(19, string8, this._Interoperate);
            return;
        }
        if (string.equals("KeepAlive")) {
            int n = this._KeepAlive;
            this._KeepAlive = (Integer)object;
            this._postSet(20, n, this._KeepAlive);
            return;
        }
        if (string.equals("KeepAliveWait")) {
            int n = this._KeepAliveWait;
            this._KeepAliveWait = (Integer)object;
            this._postSet(21, n, this._KeepAliveWait);
            return;
        }
        if (string.equals("KeyStoresLocation")) {
            String string9 = this._KeyStoresLocation;
            this._KeyStoresLocation = (String)object;
            this._postSet(23, string9, this._KeyStoresLocation);
            return;
        }
        if (string.equals("MaxEncryptBits")) {
            String string10 = this._MaxEncryptBits;
            this._MaxEncryptBits = (String)object;
            this._postSet(18, string10, this._MaxEncryptBits);
            return;
        }
        if (string.equals("MaxRetries")) {
            long l = this._MaxRetries;
            this._MaxRetries = (Long)object;
            this._postSet(13, l, this._MaxRetries);
            return;
        }
        if (string.equals("MinEncryptBits")) {
            String string11 = this._MinEncryptBits;
            this._MinEncryptBits = (String)object;
            this._postSet(17, string11, this._MinEncryptBits);
            return;
        }
        if (string.equals("NWAddr")) {
            String string12 = this._NWAddr;
            this._NWAddr = (String)object;
            this._postSet(15, string12, this._NWAddr);
            return;
        }
        if (string.equals("PrivateKeyAlias")) {
            String string13 = this._PrivateKeyAlias;
            this._PrivateKeyAlias = (String)object;
            this._postSet(27, string13, this._PrivateKeyAlias);
            return;
        }
        if (string.equals("PrivateKeyPassPhrase")) {
            String string14 = this._PrivateKeyPassPhrase;
            this._PrivateKeyPassPhrase = (String)object;
            this._postSet(28, string14, this._PrivateKeyPassPhrase);
            return;
        }
        if (string.equals("PrivateKeyPassPhraseEncrypted")) {
            byte[] byArray = this._PrivateKeyPassPhraseEncrypted;
            this._PrivateKeyPassPhraseEncrypted = (byte[])object;
            this._postSet(29, byArray, this._PrivateKeyPassPhraseEncrypted);
            return;
        }
        if (string.equals("RetryInterval")) {
            long l = this._RetryInterval;
            this._RetryInterval = (Long)object;
            this._postSet(12, l, this._RetryInterval);
            return;
        }
        if (string.equals("Security")) {
            String string15 = this._Security;
            this._Security = (String)object;
            this._postSet(9, string15, this._Security);
            return;
        }
        if (string.equals("TrustKeyStoreFileName")) {
            String string16 = this._TrustKeyStoreFileName;
            this._TrustKeyStoreFileName = (String)object;
            this._postSet(30, string16, this._TrustKeyStoreFileName);
            return;
        }
        if (string.equals("TrustKeyStorePassPhrase")) {
            String string17 = this._TrustKeyStorePassPhrase;
            this._TrustKeyStorePassPhrase = (String)object;
            this._postSet(31, string17, this._TrustKeyStorePassPhrase);
            return;
        }
        if (string.equals("TrustKeyStorePassPhraseEncrypted")) {
            byte[] byArray = this._TrustKeyStorePassPhraseEncrypted;
            this._TrustKeyStorePassPhraseEncrypted = (byte[])object;
            this._postSet(32, byArray, this._TrustKeyStorePassPhraseEncrypted);
            return;
        }
        if (string.equals("UseSSL")) {
            String string18 = this._UseSSL;
            this._UseSSL = (String)object;
            this._postSet(22, string18, this._UseSSL);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AccessPoint")) {
            return this._AccessPoint;
        }
        if (string.equals("AccessPointId")) {
            return this._AccessPointId;
        }
        if (string.equals("BlockTime")) {
            return new Long(this._BlockTime);
        }
        if (string.equals("CmpLimit")) {
            return new Integer(this._CmpLimit);
        }
        if (string.equals("ConnPrincipalName")) {
            return this._ConnPrincipalName;
        }
        if (string.equals("ConnectionPolicy")) {
            return this._ConnectionPolicy;
        }
        if (string.equals("IdentityKeyStoreFileName")) {
            return this._IdentityKeyStoreFileName;
        }
        if (string.equals("IdentityKeyStorePassPhrase")) {
            return this._IdentityKeyStorePassPhrase;
        }
        if (string.equals("IdentityKeyStorePassPhraseEncrypted")) {
            return this._IdentityKeyStorePassPhraseEncrypted;
        }
        if (string.equals("Interoperate")) {
            return this._Interoperate;
        }
        if (string.equals("KeepAlive")) {
            return new Integer(this._KeepAlive);
        }
        if (string.equals("KeepAliveWait")) {
            return new Integer(this._KeepAliveWait);
        }
        if (string.equals("KeyStoresLocation")) {
            return this._KeyStoresLocation;
        }
        if (string.equals("MaxEncryptBits")) {
            return this._MaxEncryptBits;
        }
        if (string.equals("MaxRetries")) {
            return new Long(this._MaxRetries);
        }
        if (string.equals("MinEncryptBits")) {
            return this._MinEncryptBits;
        }
        if (string.equals("NWAddr")) {
            return this._NWAddr;
        }
        if (string.equals("PrivateKeyAlias")) {
            return this._PrivateKeyAlias;
        }
        if (string.equals("PrivateKeyPassPhrase")) {
            return this._PrivateKeyPassPhrase;
        }
        if (string.equals("PrivateKeyPassPhraseEncrypted")) {
            return this._PrivateKeyPassPhraseEncrypted;
        }
        if (string.equals("RetryInterval")) {
            return new Long(this._RetryInterval);
        }
        if (string.equals("Security")) {
            return this._Security;
        }
        if (string.equals("TrustKeyStoreFileName")) {
            return this._TrustKeyStoreFileName;
        }
        if (string.equals("TrustKeyStorePassPhrase")) {
            return this._TrustKeyStorePassPhrase;
        }
        if (string.equals("TrustKeyStorePassPhraseEncrypted")) {
            return this._TrustKeyStorePassPhraseEncrypted;
        }
        if (string.equals("UseSSL")) {
            return this._UseSSL;
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            LegalChecks.checkNonNull((String)"AccessPoint", (Object)"myLAP");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property AccessPoint in WTCLocalTuxDomMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonNull((String)"AccessPointId", (Object)"myLAPId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property AccessPointId in WTCLocalTuxDomMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 12: {
                    if (string.equals("access-point")) {
                        return 7;
                    }
                    if (!string.equals("interoperate")) break;
                    return 19;
                }
                case 15: {
                    if (string.equals("access-point-id")) {
                        return 8;
                    }
                    if (!string.equals("keep-alive-wait")) break;
                    return 21;
                }
                case 10: {
                    if (string.equals("block-time")) {
                        return 14;
                    }
                    if (!string.equals("keep-alive")) break;
                    return 20;
                }
                case 9: {
                    if (!string.equals("cmp-limit")) break;
                    return 16;
                }
                case 19: {
                    if (string.equals("conn-principal-name")) {
                        return 11;
                    }
                    if (!string.equals("key-stores-location")) break;
                    return 23;
                }
                case 17: {
                    if (string.equals("connection-policy")) {
                        return 10;
                    }
                    if (!string.equals("private-key-alias")) break;
                    return 27;
                }
                case 28: {
                    if (!string.equals("identity-key-store-file-name")) break;
                    return 24;
                }
                case 30: {
                    if (!string.equals("identity-key-store-pass-phrase")) break;
                    return 25;
                }
                case 40: {
                    if (!string.equals("identity-key-store-pass-phrase-encrypted")) break;
                    return 26;
                }
                case 16: {
                    if (string.equals("max-encrypt-bits")) {
                        return 18;
                    }
                    if (!string.equals("min-encrypt-bits")) break;
                    return 17;
                }
                case 11: {
                    if (!string.equals("max-retries")) break;
                    return 13;
                }
                case 7: {
                    if (!string.equals("nw-addr")) break;
                    return 15;
                }
                case 23: {
                    if (!string.equals("private-key-pass-phrase")) break;
                    return 28;
                }
                case 33: {
                    if (!string.equals("private-key-pass-phrase-encrypted")) break;
                    return 29;
                }
                case 14: {
                    if (!string.equals("retry-interval")) break;
                    return 12;
                }
                case 8: {
                    if (!string.equals("security")) break;
                    return 9;
                }
                case 25: {
                    if (!string.equals("trust-key-store-file-name")) break;
                    return 30;
                }
                case 27: {
                    if (!string.equals("trust-key-store-pass-phrase")) break;
                    return 31;
                }
                case 37: {
                    if (!string.equals("trust-key-store-pass-phrase-encrypted")) break;
                    return 32;
                }
                case 6: {
                    if (!string.equals("usessl")) break;
                    return 22;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 7: {
                    return "access-point";
                }
                case 8: {
                    return "access-point-id";
                }
                case 14: {
                    return "block-time";
                }
                case 16: {
                    return "cmp-limit";
                }
                case 11: {
                    return "conn-principal-name";
                }
                case 10: {
                    return "connection-policy";
                }
                case 24: {
                    return "identity-key-store-file-name";
                }
                case 25: {
                    return "identity-key-store-pass-phrase";
                }
                case 26: {
                    return "identity-key-store-pass-phrase-encrypted";
                }
                case 19: {
                    return "interoperate";
                }
                case 20: {
                    return "keep-alive";
                }
                case 21: {
                    return "keep-alive-wait";
                }
                case 23: {
                    return "key-stores-location";
                }
                case 18: {
                    return "max-encrypt-bits";
                }
                case 13: {
                    return "max-retries";
                }
                case 17: {
                    return "min-encrypt-bits";
                }
                case 15: {
                    return "nw-addr";
                }
                case 27: {
                    return "private-key-alias";
                }
                case 28: {
                    return "private-key-pass-phrase";
                }
                case 29: {
                    return "private-key-pass-phrase-encrypted";
                }
                case 12: {
                    return "retry-interval";
                }
                case 9: {
                    return "security";
                }
                case 30: {
                    return "trust-key-store-file-name";
                }
                case 31: {
                    return "trust-key-store-pass-phrase";
                }
                case 32: {
                    return "trust-key-store-pass-phrase-encrypted";
                }
                case 22: {
                    return "usessl";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                default: 
            }
            return super.isArray(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private WTCLocalTuxDomMBeanImpl bean;

        protected Helper(WTCLocalTuxDomMBeanImpl wTCLocalTuxDomMBeanImpl) {
            super(wTCLocalTuxDomMBeanImpl);
            this.bean = wTCLocalTuxDomMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 7: {
                    return "AccessPoint";
                }
                case 8: {
                    return "AccessPointId";
                }
                case 14: {
                    return "BlockTime";
                }
                case 16: {
                    return "CmpLimit";
                }
                case 11: {
                    return "ConnPrincipalName";
                }
                case 10: {
                    return "ConnectionPolicy";
                }
                case 24: {
                    return "IdentityKeyStoreFileName";
                }
                case 25: {
                    return "IdentityKeyStorePassPhrase";
                }
                case 26: {
                    return "IdentityKeyStorePassPhraseEncrypted";
                }
                case 19: {
                    return "Interoperate";
                }
                case 20: {
                    return "KeepAlive";
                }
                case 21: {
                    return "KeepAliveWait";
                }
                case 23: {
                    return "KeyStoresLocation";
                }
                case 18: {
                    return "MaxEncryptBits";
                }
                case 13: {
                    return "MaxRetries";
                }
                case 17: {
                    return "MinEncryptBits";
                }
                case 15: {
                    return "NWAddr";
                }
                case 27: {
                    return "PrivateKeyAlias";
                }
                case 28: {
                    return "PrivateKeyPassPhrase";
                }
                case 29: {
                    return "PrivateKeyPassPhraseEncrypted";
                }
                case 12: {
                    return "RetryInterval";
                }
                case 9: {
                    return "Security";
                }
                case 30: {
                    return "TrustKeyStoreFileName";
                }
                case 31: {
                    return "TrustKeyStorePassPhrase";
                }
                case 32: {
                    return "TrustKeyStorePassPhraseEncrypted";
                }
                case 22: {
                    return "UseSSL";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AccessPoint")) {
                return 7;
            }
            if (string.equals("AccessPointId")) {
                return 8;
            }
            if (string.equals("BlockTime")) {
                return 14;
            }
            if (string.equals("CmpLimit")) {
                return 16;
            }
            if (string.equals("ConnPrincipalName")) {
                return 11;
            }
            if (string.equals("ConnectionPolicy")) {
                return 10;
            }
            if (string.equals("IdentityKeyStoreFileName")) {
                return 24;
            }
            if (string.equals("IdentityKeyStorePassPhrase")) {
                return 25;
            }
            if (string.equals("IdentityKeyStorePassPhraseEncrypted")) {
                return 26;
            }
            if (string.equals("Interoperate")) {
                return 19;
            }
            if (string.equals("KeepAlive")) {
                return 20;
            }
            if (string.equals("KeepAliveWait")) {
                return 21;
            }
            if (string.equals("KeyStoresLocation")) {
                return 23;
            }
            if (string.equals("MaxEncryptBits")) {
                return 18;
            }
            if (string.equals("MaxRetries")) {
                return 13;
            }
            if (string.equals("MinEncryptBits")) {
                return 17;
            }
            if (string.equals("NWAddr")) {
                return 15;
            }
            if (string.equals("PrivateKeyAlias")) {
                return 27;
            }
            if (string.equals("PrivateKeyPassPhrase")) {
                return 28;
            }
            if (string.equals("PrivateKeyPassPhraseEncrypted")) {
                return 29;
            }
            if (string.equals("RetryInterval")) {
                return 12;
            }
            if (string.equals("Security")) {
                return 9;
            }
            if (string.equals("TrustKeyStoreFileName")) {
                return 30;
            }
            if (string.equals("TrustKeyStorePassPhrase")) {
                return 31;
            }
            if (string.equals("TrustKeyStorePassPhraseEncrypted")) {
                return 32;
            }
            if (string.equals("UseSSL")) {
                return 22;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAccessPointSet()) {
                    stringBuffer.append("AccessPoint");
                    stringBuffer.append(String.valueOf(this.bean.getAccessPoint()));
                }
                if (this.bean.isAccessPointIdSet()) {
                    stringBuffer.append("AccessPointId");
                    stringBuffer.append(String.valueOf(this.bean.getAccessPointId()));
                }
                if (this.bean.isBlockTimeSet()) {
                    stringBuffer.append("BlockTime");
                    stringBuffer.append(String.valueOf(this.bean.getBlockTime()));
                }
                if (this.bean.isCmpLimitSet()) {
                    stringBuffer.append("CmpLimit");
                    stringBuffer.append(String.valueOf(this.bean.getCmpLimit()));
                }
                if (this.bean.isConnPrincipalNameSet()) {
                    stringBuffer.append("ConnPrincipalName");
                    stringBuffer.append(String.valueOf(this.bean.getConnPrincipalName()));
                }
                if (this.bean.isConnectionPolicySet()) {
                    stringBuffer.append("ConnectionPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionPolicy()));
                }
                if (this.bean.isIdentityKeyStoreFileNameSet()) {
                    stringBuffer.append("IdentityKeyStoreFileName");
                    stringBuffer.append(String.valueOf(this.bean.getIdentityKeyStoreFileName()));
                }
                if (this.bean.isIdentityKeyStorePassPhraseSet()) {
                    stringBuffer.append("IdentityKeyStorePassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getIdentityKeyStorePassPhrase()));
                }
                if (this.bean.isIdentityKeyStorePassPhraseEncryptedSet()) {
                    stringBuffer.append("IdentityKeyStorePassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getIdentityKeyStorePassPhraseEncrypted())));
                }
                if (this.bean.isInteroperateSet()) {
                    stringBuffer.append("Interoperate");
                    stringBuffer.append(String.valueOf(this.bean.getInteroperate()));
                }
                if (this.bean.isKeepAliveSet()) {
                    stringBuffer.append("KeepAlive");
                    stringBuffer.append(String.valueOf(this.bean.getKeepAlive()));
                }
                if (this.bean.isKeepAliveWaitSet()) {
                    stringBuffer.append("KeepAliveWait");
                    stringBuffer.append(String.valueOf(this.bean.getKeepAliveWait()));
                }
                if (this.bean.isKeyStoresLocationSet()) {
                    stringBuffer.append("KeyStoresLocation");
                    stringBuffer.append(String.valueOf(this.bean.getKeyStoresLocation()));
                }
                if (this.bean.isMaxEncryptBitsSet()) {
                    stringBuffer.append("MaxEncryptBits");
                    stringBuffer.append(String.valueOf(this.bean.getMaxEncryptBits()));
                }
                if (this.bean.isMaxRetriesSet()) {
                    stringBuffer.append("MaxRetries");
                    stringBuffer.append(String.valueOf(this.bean.getMaxRetries()));
                }
                if (this.bean.isMinEncryptBitsSet()) {
                    stringBuffer.append("MinEncryptBits");
                    stringBuffer.append(String.valueOf(this.bean.getMinEncryptBits()));
                }
                if (this.bean.isNWAddrSet()) {
                    stringBuffer.append("NWAddr");
                    stringBuffer.append(String.valueOf(this.bean.getNWAddr()));
                }
                if (this.bean.isPrivateKeyAliasSet()) {
                    stringBuffer.append("PrivateKeyAlias");
                    stringBuffer.append(String.valueOf(this.bean.getPrivateKeyAlias()));
                }
                if (this.bean.isPrivateKeyPassPhraseSet()) {
                    stringBuffer.append("PrivateKeyPassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getPrivateKeyPassPhrase()));
                }
                if (this.bean.isPrivateKeyPassPhraseEncryptedSet()) {
                    stringBuffer.append("PrivateKeyPassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getPrivateKeyPassPhraseEncrypted())));
                }
                if (this.bean.isRetryIntervalSet()) {
                    stringBuffer.append("RetryInterval");
                    stringBuffer.append(String.valueOf(this.bean.getRetryInterval()));
                }
                if (this.bean.isSecuritySet()) {
                    stringBuffer.append("Security");
                    stringBuffer.append(String.valueOf(this.bean.getSecurity()));
                }
                if (this.bean.isTrustKeyStoreFileNameSet()) {
                    stringBuffer.append("TrustKeyStoreFileName");
                    stringBuffer.append(String.valueOf(this.bean.getTrustKeyStoreFileName()));
                }
                if (this.bean.isTrustKeyStorePassPhraseSet()) {
                    stringBuffer.append("TrustKeyStorePassPhrase");
                    stringBuffer.append(String.valueOf(this.bean.getTrustKeyStorePassPhrase()));
                }
                if (this.bean.isTrustKeyStorePassPhraseEncryptedSet()) {
                    stringBuffer.append("TrustKeyStorePassPhraseEncrypted");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((byte[])this.bean.getTrustKeyStorePassPhraseEncrypted())));
                }
                if (this.bean.isUseSSLSet()) {
                    stringBuffer.append("UseSSL");
                    stringBuffer.append(String.valueOf(this.bean.getUseSSL()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WTCLocalTuxDomMBeanImpl wTCLocalTuxDomMBeanImpl = (WTCLocalTuxDomMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AccessPoint", this.bean.getAccessPoint(), wTCLocalTuxDomMBeanImpl.getAccessPoint(), true);
                this.computeDiff("AccessPointId", this.bean.getAccessPointId(), wTCLocalTuxDomMBeanImpl.getAccessPointId(), true);
                this.computeDiff("BlockTime", this.bean.getBlockTime(), wTCLocalTuxDomMBeanImpl.getBlockTime(), true);
                this.computeDiff("CmpLimit", this.bean.getCmpLimit(), wTCLocalTuxDomMBeanImpl.getCmpLimit(), true);
                this.computeDiff("ConnPrincipalName", this.bean.getConnPrincipalName(), wTCLocalTuxDomMBeanImpl.getConnPrincipalName(), true);
                this.computeDiff("ConnectionPolicy", this.bean.getConnectionPolicy(), wTCLocalTuxDomMBeanImpl.getConnectionPolicy(), true);
                this.computeDiff("IdentityKeyStoreFileName", this.bean.getIdentityKeyStoreFileName(), wTCLocalTuxDomMBeanImpl.getIdentityKeyStoreFileName(), true);
                this.computeDiff("IdentityKeyStorePassPhraseEncrypted", this.bean.getIdentityKeyStorePassPhraseEncrypted(), wTCLocalTuxDomMBeanImpl.getIdentityKeyStorePassPhraseEncrypted(), true);
                this.computeDiff("Interoperate", this.bean.getInteroperate(), wTCLocalTuxDomMBeanImpl.getInteroperate(), true);
                this.computeDiff("KeepAlive", this.bean.getKeepAlive(), wTCLocalTuxDomMBeanImpl.getKeepAlive(), true);
                this.computeDiff("KeepAliveWait", this.bean.getKeepAliveWait(), wTCLocalTuxDomMBeanImpl.getKeepAliveWait(), true);
                this.computeDiff("KeyStoresLocation", this.bean.getKeyStoresLocation(), wTCLocalTuxDomMBeanImpl.getKeyStoresLocation(), true);
                this.computeDiff("MaxEncryptBits", this.bean.getMaxEncryptBits(), wTCLocalTuxDomMBeanImpl.getMaxEncryptBits(), true);
                this.computeDiff("MaxRetries", this.bean.getMaxRetries(), wTCLocalTuxDomMBeanImpl.getMaxRetries(), true);
                this.computeDiff("MinEncryptBits", this.bean.getMinEncryptBits(), wTCLocalTuxDomMBeanImpl.getMinEncryptBits(), true);
                this.computeDiff("NWAddr", this.bean.getNWAddr(), wTCLocalTuxDomMBeanImpl.getNWAddr(), true);
                this.computeDiff("PrivateKeyAlias", this.bean.getPrivateKeyAlias(), wTCLocalTuxDomMBeanImpl.getPrivateKeyAlias(), true);
                this.computeDiff("PrivateKeyPassPhraseEncrypted", this.bean.getPrivateKeyPassPhraseEncrypted(), wTCLocalTuxDomMBeanImpl.getPrivateKeyPassPhraseEncrypted(), true);
                this.computeDiff("RetryInterval", this.bean.getRetryInterval(), wTCLocalTuxDomMBeanImpl.getRetryInterval(), true);
                this.computeDiff("Security", this.bean.getSecurity(), wTCLocalTuxDomMBeanImpl.getSecurity(), true);
                this.computeDiff("TrustKeyStoreFileName", this.bean.getTrustKeyStoreFileName(), wTCLocalTuxDomMBeanImpl.getTrustKeyStoreFileName(), true);
                this.computeDiff("TrustKeyStorePassPhraseEncrypted", this.bean.getTrustKeyStorePassPhraseEncrypted(), wTCLocalTuxDomMBeanImpl.getTrustKeyStorePassPhraseEncrypted(), true);
                this.computeDiff("UseSSL", this.bean.getUseSSL(), wTCLocalTuxDomMBeanImpl.getUseSSL(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WTCLocalTuxDomMBeanImpl wTCLocalTuxDomMBeanImpl = (WTCLocalTuxDomMBeanImpl)beanUpdateEvent.getSourceBean();
                WTCLocalTuxDomMBeanImpl wTCLocalTuxDomMBeanImpl2 = (WTCLocalTuxDomMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AccessPoint")) {
                    wTCLocalTuxDomMBeanImpl.setAccessPoint(wTCLocalTuxDomMBeanImpl2.getAccessPoint());
                    wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("AccessPointId")) {
                    wTCLocalTuxDomMBeanImpl.setAccessPointId(wTCLocalTuxDomMBeanImpl2.getAccessPointId());
                    wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("BlockTime")) {
                    wTCLocalTuxDomMBeanImpl.setBlockTime(wTCLocalTuxDomMBeanImpl2.getBlockTime());
                    wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("CmpLimit")) {
                    wTCLocalTuxDomMBeanImpl.setCmpLimit(wTCLocalTuxDomMBeanImpl2.getCmpLimit());
                    wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("ConnPrincipalName")) {
                    wTCLocalTuxDomMBeanImpl.setConnPrincipalName(wTCLocalTuxDomMBeanImpl2.getConnPrincipalName());
                    wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("ConnectionPolicy")) {
                    wTCLocalTuxDomMBeanImpl.setConnectionPolicy(wTCLocalTuxDomMBeanImpl2.getConnectionPolicy());
                    wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("IdentityKeyStoreFileName")) {
                    wTCLocalTuxDomMBeanImpl.setIdentityKeyStoreFileName(wTCLocalTuxDomMBeanImpl2.getIdentityKeyStoreFileName());
                    wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (!string.equals("IdentityKeyStorePassPhrase")) {
                    if (string.equals("IdentityKeyStorePassPhraseEncrypted")) {
                        wTCLocalTuxDomMBeanImpl.setIdentityKeyStorePassPhraseEncrypted(wTCLocalTuxDomMBeanImpl2.getIdentityKeyStorePassPhraseEncrypted());
                        wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                    } else if (string.equals("Interoperate")) {
                        wTCLocalTuxDomMBeanImpl.setInteroperate(wTCLocalTuxDomMBeanImpl2.getInteroperate());
                        wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                    } else if (string.equals("KeepAlive")) {
                        wTCLocalTuxDomMBeanImpl.setKeepAlive(wTCLocalTuxDomMBeanImpl2.getKeepAlive());
                        wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                    } else if (string.equals("KeepAliveWait")) {
                        wTCLocalTuxDomMBeanImpl.setKeepAliveWait(wTCLocalTuxDomMBeanImpl2.getKeepAliveWait());
                        wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                    } else if (string.equals("KeyStoresLocation")) {
                        wTCLocalTuxDomMBeanImpl.setKeyStoresLocation(wTCLocalTuxDomMBeanImpl2.getKeyStoresLocation());
                        wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                    } else if (string.equals("MaxEncryptBits")) {
                        wTCLocalTuxDomMBeanImpl.setMaxEncryptBits(wTCLocalTuxDomMBeanImpl2.getMaxEncryptBits());
                        wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                    } else if (string.equals("MaxRetries")) {
                        wTCLocalTuxDomMBeanImpl.setMaxRetries(wTCLocalTuxDomMBeanImpl2.getMaxRetries());
                        wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                    } else if (string.equals("MinEncryptBits")) {
                        wTCLocalTuxDomMBeanImpl.setMinEncryptBits(wTCLocalTuxDomMBeanImpl2.getMinEncryptBits());
                        wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                    } else if (string.equals("NWAddr")) {
                        wTCLocalTuxDomMBeanImpl.setNWAddr(wTCLocalTuxDomMBeanImpl2.getNWAddr());
                        wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                    } else if (string.equals("PrivateKeyAlias")) {
                        wTCLocalTuxDomMBeanImpl.setPrivateKeyAlias(wTCLocalTuxDomMBeanImpl2.getPrivateKeyAlias());
                        wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                    } else if (!string.equals("PrivateKeyPassPhrase")) {
                        if (string.equals("PrivateKeyPassPhraseEncrypted")) {
                            wTCLocalTuxDomMBeanImpl.setPrivateKeyPassPhraseEncrypted(wTCLocalTuxDomMBeanImpl2.getPrivateKeyPassPhraseEncrypted());
                            wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                        } else if (string.equals("RetryInterval")) {
                            wTCLocalTuxDomMBeanImpl.setRetryInterval(wTCLocalTuxDomMBeanImpl2.getRetryInterval());
                            wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                        } else if (string.equals("Security")) {
                            wTCLocalTuxDomMBeanImpl.setSecurity(wTCLocalTuxDomMBeanImpl2.getSecurity());
                            wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                        } else if (string.equals("TrustKeyStoreFileName")) {
                            wTCLocalTuxDomMBeanImpl.setTrustKeyStoreFileName(wTCLocalTuxDomMBeanImpl2.getTrustKeyStoreFileName());
                            wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                        } else if (!string.equals("TrustKeyStorePassPhrase")) {
                            if (string.equals("TrustKeyStorePassPhraseEncrypted")) {
                                wTCLocalTuxDomMBeanImpl.setTrustKeyStorePassPhraseEncrypted(wTCLocalTuxDomMBeanImpl2.getTrustKeyStorePassPhraseEncrypted());
                                wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                            } else if (string.equals("UseSSL")) {
                                wTCLocalTuxDomMBeanImpl.setUseSSL(wTCLocalTuxDomMBeanImpl2.getUseSSL());
                                wTCLocalTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                            } else {
                                super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                byte[] byArray;
                WTCLocalTuxDomMBeanImpl wTCLocalTuxDomMBeanImpl = (WTCLocalTuxDomMBeanImpl)abstractDescriptorBean;
                super.finishCopy(wTCLocalTuxDomMBeanImpl, bl, list);
                if ((list == null || !list.contains("AccessPoint")) && this.bean.isAccessPointSet()) {
                    wTCLocalTuxDomMBeanImpl.setAccessPoint(this.bean.getAccessPoint());
                }
                if ((list == null || !list.contains("AccessPointId")) && this.bean.isAccessPointIdSet()) {
                    wTCLocalTuxDomMBeanImpl.setAccessPointId(this.bean.getAccessPointId());
                }
                if ((list == null || !list.contains("BlockTime")) && this.bean.isBlockTimeSet()) {
                    wTCLocalTuxDomMBeanImpl.setBlockTime(this.bean.getBlockTime());
                }
                if ((list == null || !list.contains("CmpLimit")) && this.bean.isCmpLimitSet()) {
                    wTCLocalTuxDomMBeanImpl.setCmpLimit(this.bean.getCmpLimit());
                }
                if ((list == null || !list.contains("ConnPrincipalName")) && this.bean.isConnPrincipalNameSet()) {
                    wTCLocalTuxDomMBeanImpl.setConnPrincipalName(this.bean.getConnPrincipalName());
                }
                if ((list == null || !list.contains("ConnectionPolicy")) && this.bean.isConnectionPolicySet()) {
                    wTCLocalTuxDomMBeanImpl.setConnectionPolicy(this.bean.getConnectionPolicy());
                }
                if ((list == null || !list.contains("IdentityKeyStoreFileName")) && this.bean.isIdentityKeyStoreFileNameSet()) {
                    wTCLocalTuxDomMBeanImpl.setIdentityKeyStoreFileName(this.bean.getIdentityKeyStoreFileName());
                }
                if ((list == null || !list.contains("IdentityKeyStorePassPhraseEncrypted")) && this.bean.isIdentityKeyStorePassPhraseEncryptedSet()) {
                    byArray = this.bean.getIdentityKeyStorePassPhraseEncrypted();
                    wTCLocalTuxDomMBeanImpl.setIdentityKeyStorePassPhraseEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("Interoperate")) && this.bean.isInteroperateSet()) {
                    wTCLocalTuxDomMBeanImpl.setInteroperate(this.bean.getInteroperate());
                }
                if ((list == null || !list.contains("KeepAlive")) && this.bean.isKeepAliveSet()) {
                    wTCLocalTuxDomMBeanImpl.setKeepAlive(this.bean.getKeepAlive());
                }
                if ((list == null || !list.contains("KeepAliveWait")) && this.bean.isKeepAliveWaitSet()) {
                    wTCLocalTuxDomMBeanImpl.setKeepAliveWait(this.bean.getKeepAliveWait());
                }
                if ((list == null || !list.contains("KeyStoresLocation")) && this.bean.isKeyStoresLocationSet()) {
                    wTCLocalTuxDomMBeanImpl.setKeyStoresLocation(this.bean.getKeyStoresLocation());
                }
                if ((list == null || !list.contains("MaxEncryptBits")) && this.bean.isMaxEncryptBitsSet()) {
                    wTCLocalTuxDomMBeanImpl.setMaxEncryptBits(this.bean.getMaxEncryptBits());
                }
                if ((list == null || !list.contains("MaxRetries")) && this.bean.isMaxRetriesSet()) {
                    wTCLocalTuxDomMBeanImpl.setMaxRetries(this.bean.getMaxRetries());
                }
                if ((list == null || !list.contains("MinEncryptBits")) && this.bean.isMinEncryptBitsSet()) {
                    wTCLocalTuxDomMBeanImpl.setMinEncryptBits(this.bean.getMinEncryptBits());
                }
                if ((list == null || !list.contains("NWAddr")) && this.bean.isNWAddrSet()) {
                    wTCLocalTuxDomMBeanImpl.setNWAddr(this.bean.getNWAddr());
                }
                if ((list == null || !list.contains("PrivateKeyAlias")) && this.bean.isPrivateKeyAliasSet()) {
                    wTCLocalTuxDomMBeanImpl.setPrivateKeyAlias(this.bean.getPrivateKeyAlias());
                }
                if ((list == null || !list.contains("PrivateKeyPassPhraseEncrypted")) && this.bean.isPrivateKeyPassPhraseEncryptedSet()) {
                    byArray = this.bean.getPrivateKeyPassPhraseEncrypted();
                    wTCLocalTuxDomMBeanImpl.setPrivateKeyPassPhraseEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("RetryInterval")) && this.bean.isRetryIntervalSet()) {
                    wTCLocalTuxDomMBeanImpl.setRetryInterval(this.bean.getRetryInterval());
                }
                if ((list == null || !list.contains("Security")) && this.bean.isSecuritySet()) {
                    wTCLocalTuxDomMBeanImpl.setSecurity(this.bean.getSecurity());
                }
                if ((list == null || !list.contains("TrustKeyStoreFileName")) && this.bean.isTrustKeyStoreFileNameSet()) {
                    wTCLocalTuxDomMBeanImpl.setTrustKeyStoreFileName(this.bean.getTrustKeyStoreFileName());
                }
                if ((list == null || !list.contains("TrustKeyStorePassPhraseEncrypted")) && this.bean.isTrustKeyStorePassPhraseEncryptedSet()) {
                    byArray = this.bean.getTrustKeyStorePassPhraseEncrypted();
                    wTCLocalTuxDomMBeanImpl.setTrustKeyStorePassPhraseEncrypted(byArray == null ? null : (byte[])byArray.clone());
                }
                if ((list == null || !list.contains("UseSSL")) && this.bean.isUseSSLSet()) {
                    wTCLocalTuxDomMBeanImpl.setUseSSL(this.bean.getUseSSL());
                }
                return wTCLocalTuxDomMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

