/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorValidateException;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.WTCLegalHelper;
import weblogic.management.configuration.WTCRemoteTuxDomMBean;
import weblogic.utils.collections.CombinedIterator;

public class WTCRemoteTuxDomMBeanImpl
extends ConfigurationMBeanImpl
implements WTCRemoteTuxDomMBean,
Serializable {
    private String _AccessPoint;
    private String _AccessPointId;
    private String _AclPolicy;
    private boolean _AllowAnonymous;
    private String _AppKey;
    private int _CmpLimit;
    private String _ConnPrincipalName;
    private String _ConnectionPolicy;
    private String _CredentialPolicy;
    private String _CustomAppKeyClass;
    private String _CustomAppKeyClassParam;
    private int _DefaultAppKey;
    private String _FederationName;
    private String _FederationURL;
    private int _KeepAlive;
    private int _KeepAliveWait;
    private String _LocalAccessPoint;
    private String _MaxEncryptBits;
    private long _MaxRetries;
    private String _MinEncryptBits;
    private String _NWAddr;
    private long _RetryInterval;
    private String _TpUsrFile;
    private String _TuxedoGidKw;
    private String _TuxedoUidKw;
    private static SchemaHelper2 _schemaHelper;

    public WTCRemoteTuxDomMBeanImpl() {
        this._initializeProperty(-1);
    }

    public WTCRemoteTuxDomMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public void setAccessPoint(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"AccessPoint", (Object)string);
        String string2 = this._AccessPoint;
        this._AccessPoint = string;
        this._postSet(7, string2, string);
    }

    public String getAccessPoint() {
        return this._AccessPoint;
    }

    public boolean isAccessPointSet() {
        return this._isSet(7);
    }

    public void setAccessPointId(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"AccessPointId", (Object)string);
        String string2 = this._AccessPointId;
        this._AccessPointId = string;
        this._postSet(8, string2, string);
    }

    public String getAccessPointId() {
        return this._AccessPointId;
    }

    public boolean isAccessPointIdSet() {
        return this._isSet(8);
    }

    public void setConnectionPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"ON_DEMAND", "ON_STARTUP", "INCOMING_ONLY", "LOCAL"};
        string = LegalChecks.checkInEnum((String)"ConnectionPolicy", (String)string, (String[])stringArray);
        String string2 = this._ConnectionPolicy;
        this._ConnectionPolicy = string;
        this._postSet(9, string2, string);
    }

    public String getConnectionPolicy() {
        return this._ConnectionPolicy;
    }

    public boolean isConnectionPolicySet() {
        return this._isSet(9);
    }

    public void setAclPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"GLOBAL", "LOCAL"};
        string = LegalChecks.checkInEnum((String)"AclPolicy", (String)string, (String[])stringArray);
        String string2 = this._AclPolicy;
        this._AclPolicy = string;
        this._postSet(10, string2, string);
    }

    public String getAclPolicy() {
        return this._AclPolicy;
    }

    public boolean isAclPolicySet() {
        return this._isSet(10);
    }

    public void setCredentialPolicy(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"GLOBAL", "LOCAL"};
        string = LegalChecks.checkInEnum((String)"CredentialPolicy", (String)string, (String[])stringArray);
        String string2 = this._CredentialPolicy;
        this._CredentialPolicy = string;
        this._postSet(11, string2, string);
    }

    public String getCredentialPolicy() {
        return this._CredentialPolicy;
    }

    public boolean isCredentialPolicySet() {
        return this._isSet(11);
    }

    public void setTpUsrFile(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._TpUsrFile;
        this._TpUsrFile = string;
        this._postSet(12, string2, string);
    }

    public String getTpUsrFile() {
        return this._TpUsrFile;
    }

    public boolean isTpUsrFileSet() {
        return this._isSet(12);
    }

    public void setLocalAccessPoint(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonNull((String)"LocalAccessPoint", (Object)string);
        String string2 = this._LocalAccessPoint;
        this._LocalAccessPoint = string;
        this._postSet(13, string2, string);
    }

    public String getLocalAccessPoint() {
        return this._LocalAccessPoint;
    }

    public boolean isLocalAccessPointSet() {
        return this._isSet(13);
    }

    public void setConnPrincipalName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._ConnPrincipalName;
        this._ConnPrincipalName = string;
        this._postSet(14, string2, string);
    }

    public String getConnPrincipalName() {
        return this._ConnPrincipalName;
    }

    public boolean isConnPrincipalNameSet() {
        return this._isSet(14);
    }

    public void setRetryInterval(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"RetryInterval", (long)l, (long)-1L, (long)Integer.MAX_VALUE);
        long l2 = this._RetryInterval;
        this._RetryInterval = l;
        this._postSet(15, l2, l);
    }

    public long getRetryInterval() {
        return this._RetryInterval;
    }

    public boolean isRetryIntervalSet() {
        return this._isSet(15);
    }

    public void setMaxRetries(long l) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"MaxRetries", (long)l, (long)-1L, (long)Long.MAX_VALUE);
        long l2 = this._MaxRetries;
        this._MaxRetries = l;
        this._postSet(16, l2, l);
    }

    public long getMaxRetries() {
        return this._MaxRetries;
    }

    public boolean isMaxRetriesSet() {
        return this._isSet(16);
    }

    public void setNWAddr(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._NWAddr;
        this._NWAddr = string;
        this._postSet(17, string2, string);
    }

    public String getNWAddr() {
        return this._NWAddr;
    }

    public boolean isNWAddrSet() {
        return this._isSet(17);
    }

    public void setFederationURL(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._FederationURL;
        this._FederationURL = string;
        this._postSet(18, string2, string);
    }

    public String getFederationURL() {
        return this._FederationURL;
    }

    public boolean isFederationURLSet() {
        return this._isSet(18);
    }

    public void setFederationName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._FederationName;
        this._FederationName = string;
        this._postSet(19, string2, string);
    }

    public String getFederationName() {
        return this._FederationName;
    }

    public boolean isFederationNameSet() {
        return this._isSet(19);
    }

    public void setCmpLimit(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"CmpLimit", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._CmpLimit;
        this._CmpLimit = n;
        this._postSet(20, n2, n);
    }

    public int getCmpLimit() {
        return this._CmpLimit;
    }

    public boolean isCmpLimitSet() {
        return this._isSet(20);
    }

    public void setMinEncryptBits(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"0", "40", "56", "128"};
        string = LegalChecks.checkInEnum((String)"MinEncryptBits", (String)string, (String[])stringArray);
        String string2 = this._MinEncryptBits;
        this._MinEncryptBits = string;
        this._postSet(21, string2, string);
    }

    public String getMinEncryptBits() {
        return this._MinEncryptBits;
    }

    public boolean isMinEncryptBitsSet() {
        return this._isSet(21);
    }

    public void setMaxEncryptBits(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"0", "40", "56", "128"};
        string = LegalChecks.checkInEnum((String)"MaxEncryptBits", (String)string, (String[])stringArray);
        String string2 = this._MaxEncryptBits;
        this._MaxEncryptBits = string;
        this._postSet(22, string2, string);
    }

    public String getMaxEncryptBits() {
        return this._MaxEncryptBits;
    }

    public boolean isMaxEncryptBitsSet() {
        return this._isSet(22);
    }

    public void setAppKey(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"TpUsrFile", "LDAP", "Custom"};
        string = LegalChecks.checkInEnum((String)"AppKey", (String)string, (String[])stringArray);
        String string2 = this._AppKey;
        this._AppKey = string;
        this._postSet(23, string2, string);
    }

    public String getAppKey() {
        return this._AppKey;
    }

    public boolean isAppKeySet() {
        return this._isSet(23);
    }

    public void setAllowAnonymous(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._AllowAnonymous;
        this._AllowAnonymous = bl;
        this._postSet(24, bl2, bl);
    }

    public boolean getAllowAnonymous() {
        return this._AllowAnonymous;
    }

    public boolean isAllowAnonymousSet() {
        return this._isSet(24);
    }

    public void setDefaultAppKey(int n) throws InvalidAttributeValueException {
        int n2 = this._DefaultAppKey;
        this._DefaultAppKey = n;
        this._postSet(25, n2, n);
    }

    public int getDefaultAppKey() {
        return this._DefaultAppKey;
    }

    public boolean isDefaultAppKeySet() {
        return this._isSet(25);
    }

    public void setTuxedoUidKw(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._TuxedoUidKw;
        this._TuxedoUidKw = string;
        this._postSet(26, string2, string);
    }

    public String getTuxedoUidKw() {
        return this._TuxedoUidKw;
    }

    public boolean isTuxedoUidKwSet() {
        return this._isSet(26);
    }

    public void setTuxedoGidKw(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._TuxedoGidKw;
        this._TuxedoGidKw = string;
        this._postSet(27, string2, string);
    }

    public String getTuxedoGidKw() {
        return this._TuxedoGidKw;
    }

    public boolean isTuxedoGidKwSet() {
        return this._isSet(27);
    }

    public void setCustomAppKeyClass(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._CustomAppKeyClass;
        this._CustomAppKeyClass = string;
        this._postSet(28, string2, string);
    }

    public String getCustomAppKeyClass() {
        return this._CustomAppKeyClass;
    }

    public boolean isCustomAppKeyClassSet() {
        return this._isSet(28);
    }

    public void setCustomAppKeyClassParam(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._CustomAppKeyClassParam;
        this._CustomAppKeyClassParam = string;
        this._postSet(29, string2, string);
    }

    public String getCustomAppKeyClassParam() {
        return this._CustomAppKeyClassParam;
    }

    public boolean isCustomAppKeyClassParamSet() {
        return this._isSet(29);
    }

    public void setKeepAlive(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"KeepAlive", (long)n, (long)-1L, (long)Integer.MAX_VALUE);
        int n2 = this._KeepAlive;
        this._KeepAlive = n;
        this._postSet(30, n2, n);
    }

    public int getKeepAlive() {
        return this._KeepAlive;
    }

    public boolean isKeepAliveSet() {
        return this._isSet(30);
    }

    public void setKeepAliveWait(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"KeepAliveWait", (long)n, (long)0L, (long)Integer.MAX_VALUE);
        int n2 = this._KeepAliveWait;
        this._KeepAliveWait = n;
        this._postSet(31, n2, n);
    }

    public int getKeepAliveWait() {
        return this._KeepAliveWait;
    }

    public boolean isKeepAliveWaitSet() {
        return this._isSet(31);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
        WTCLegalHelper.validateWTCRemoteTuxDom(this);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 7;
        }
        try {
            switch (n) {
                case 7: {
                    this._AccessPoint = "myRAP";
                    if (bl) break;
                }
                case 8: {
                    this._AccessPointId = "myRAPId";
                    if (bl) break;
                }
                case 10: {
                    this._AclPolicy = "LOCAL";
                    if (bl) break;
                }
                case 24: {
                    this._AllowAnonymous = false;
                    if (bl) break;
                }
                case 23: {
                    this._AppKey = "TpUsrFile";
                    if (bl) break;
                }
                case 20: {
                    this._CmpLimit = Integer.MAX_VALUE;
                    if (bl) break;
                }
                case 14: {
                    this._ConnPrincipalName = null;
                    if (bl) break;
                }
                case 9: {
                    this._ConnectionPolicy = "LOCAL";
                    if (bl) break;
                }
                case 11: {
                    this._CredentialPolicy = "LOCAL";
                    if (bl) break;
                }
                case 28: {
                    this._CustomAppKeyClass = null;
                    if (bl) break;
                }
                case 29: {
                    this._CustomAppKeyClassParam = null;
                    if (bl) break;
                }
                case 25: {
                    this._DefaultAppKey = -1;
                    if (bl) break;
                }
                case 19: {
                    this._FederationName = null;
                    if (bl) break;
                }
                case 18: {
                    this._FederationURL = null;
                    if (bl) break;
                }
                case 30: {
                    this._KeepAlive = 0;
                    if (bl) break;
                }
                case 31: {
                    this._KeepAliveWait = 0;
                    if (bl) break;
                }
                case 13: {
                    this._LocalAccessPoint = "myLAP";
                    if (bl) break;
                }
                case 22: {
                    this._MaxEncryptBits = "128";
                    if (bl) break;
                }
                case 16: {
                    this._MaxRetries = -1L;
                    if (bl) break;
                }
                case 21: {
                    this._MinEncryptBits = "0";
                    if (bl) break;
                }
                case 17: {
                    this._NWAddr = "//localhost:8902";
                    if (bl) break;
                }
                case 15: {
                    this._RetryInterval = -1L;
                    if (bl) break;
                }
                case 12: {
                    this._TpUsrFile = null;
                    if (bl) break;
                }
                case 27: {
                    this._TuxedoGidKw = "TUXEDO_GID";
                    if (bl) break;
                }
                case 26: {
                    this._TuxedoUidKw = "TUXEDO_UID";
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "WTCRemoteTuxDom";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AccessPoint")) {
            String string2 = this._AccessPoint;
            this._AccessPoint = (String)object;
            this._postSet(7, string2, this._AccessPoint);
            return;
        }
        if (string.equals("AccessPointId")) {
            String string3 = this._AccessPointId;
            this._AccessPointId = (String)object;
            this._postSet(8, string3, this._AccessPointId);
            return;
        }
        if (string.equals("AclPolicy")) {
            String string4 = this._AclPolicy;
            this._AclPolicy = (String)object;
            this._postSet(10, string4, this._AclPolicy);
            return;
        }
        if (string.equals("AllowAnonymous")) {
            boolean bl = this._AllowAnonymous;
            this._AllowAnonymous = (Boolean)object;
            this._postSet(24, bl, this._AllowAnonymous);
            return;
        }
        if (string.equals("AppKey")) {
            String string5 = this._AppKey;
            this._AppKey = (String)object;
            this._postSet(23, string5, this._AppKey);
            return;
        }
        if (string.equals("CmpLimit")) {
            int n = this._CmpLimit;
            this._CmpLimit = (Integer)object;
            this._postSet(20, n, this._CmpLimit);
            return;
        }
        if (string.equals("ConnPrincipalName")) {
            String string6 = this._ConnPrincipalName;
            this._ConnPrincipalName = (String)object;
            this._postSet(14, string6, this._ConnPrincipalName);
            return;
        }
        if (string.equals("ConnectionPolicy")) {
            String string7 = this._ConnectionPolicy;
            this._ConnectionPolicy = (String)object;
            this._postSet(9, string7, this._ConnectionPolicy);
            return;
        }
        if (string.equals("CredentialPolicy")) {
            String string8 = this._CredentialPolicy;
            this._CredentialPolicy = (String)object;
            this._postSet(11, string8, this._CredentialPolicy);
            return;
        }
        if (string.equals("CustomAppKeyClass")) {
            String string9 = this._CustomAppKeyClass;
            this._CustomAppKeyClass = (String)object;
            this._postSet(28, string9, this._CustomAppKeyClass);
            return;
        }
        if (string.equals("CustomAppKeyClassParam")) {
            String string10 = this._CustomAppKeyClassParam;
            this._CustomAppKeyClassParam = (String)object;
            this._postSet(29, string10, this._CustomAppKeyClassParam);
            return;
        }
        if (string.equals("DefaultAppKey")) {
            int n = this._DefaultAppKey;
            this._DefaultAppKey = (Integer)object;
            this._postSet(25, n, this._DefaultAppKey);
            return;
        }
        if (string.equals("FederationName")) {
            String string11 = this._FederationName;
            this._FederationName = (String)object;
            this._postSet(19, string11, this._FederationName);
            return;
        }
        if (string.equals("FederationURL")) {
            String string12 = this._FederationURL;
            this._FederationURL = (String)object;
            this._postSet(18, string12, this._FederationURL);
            return;
        }
        if (string.equals("KeepAlive")) {
            int n = this._KeepAlive;
            this._KeepAlive = (Integer)object;
            this._postSet(30, n, this._KeepAlive);
            return;
        }
        if (string.equals("KeepAliveWait")) {
            int n = this._KeepAliveWait;
            this._KeepAliveWait = (Integer)object;
            this._postSet(31, n, this._KeepAliveWait);
            return;
        }
        if (string.equals("LocalAccessPoint")) {
            String string13 = this._LocalAccessPoint;
            this._LocalAccessPoint = (String)object;
            this._postSet(13, string13, this._LocalAccessPoint);
            return;
        }
        if (string.equals("MaxEncryptBits")) {
            String string14 = this._MaxEncryptBits;
            this._MaxEncryptBits = (String)object;
            this._postSet(22, string14, this._MaxEncryptBits);
            return;
        }
        if (string.equals("MaxRetries")) {
            long l = this._MaxRetries;
            this._MaxRetries = (Long)object;
            this._postSet(16, l, this._MaxRetries);
            return;
        }
        if (string.equals("MinEncryptBits")) {
            String string15 = this._MinEncryptBits;
            this._MinEncryptBits = (String)object;
            this._postSet(21, string15, this._MinEncryptBits);
            return;
        }
        if (string.equals("NWAddr")) {
            String string16 = this._NWAddr;
            this._NWAddr = (String)object;
            this._postSet(17, string16, this._NWAddr);
            return;
        }
        if (string.equals("RetryInterval")) {
            long l = this._RetryInterval;
            this._RetryInterval = (Long)object;
            this._postSet(15, l, this._RetryInterval);
            return;
        }
        if (string.equals("TpUsrFile")) {
            String string17 = this._TpUsrFile;
            this._TpUsrFile = (String)object;
            this._postSet(12, string17, this._TpUsrFile);
            return;
        }
        if (string.equals("TuxedoGidKw")) {
            String string18 = this._TuxedoGidKw;
            this._TuxedoGidKw = (String)object;
            this._postSet(27, string18, this._TuxedoGidKw);
            return;
        }
        if (string.equals("TuxedoUidKw")) {
            String string19 = this._TuxedoUidKw;
            this._TuxedoUidKw = (String)object;
            this._postSet(26, string19, this._TuxedoUidKw);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AccessPoint")) {
            return this._AccessPoint;
        }
        if (string.equals("AccessPointId")) {
            return this._AccessPointId;
        }
        if (string.equals("AclPolicy")) {
            return this._AclPolicy;
        }
        if (string.equals("AllowAnonymous")) {
            return new Boolean(this._AllowAnonymous);
        }
        if (string.equals("AppKey")) {
            return this._AppKey;
        }
        if (string.equals("CmpLimit")) {
            return new Integer(this._CmpLimit);
        }
        if (string.equals("ConnPrincipalName")) {
            return this._ConnPrincipalName;
        }
        if (string.equals("ConnectionPolicy")) {
            return this._ConnectionPolicy;
        }
        if (string.equals("CredentialPolicy")) {
            return this._CredentialPolicy;
        }
        if (string.equals("CustomAppKeyClass")) {
            return this._CustomAppKeyClass;
        }
        if (string.equals("CustomAppKeyClassParam")) {
            return this._CustomAppKeyClassParam;
        }
        if (string.equals("DefaultAppKey")) {
            return new Integer(this._DefaultAppKey);
        }
        if (string.equals("FederationName")) {
            return this._FederationName;
        }
        if (string.equals("FederationURL")) {
            return this._FederationURL;
        }
        if (string.equals("KeepAlive")) {
            return new Integer(this._KeepAlive);
        }
        if (string.equals("KeepAliveWait")) {
            return new Integer(this._KeepAliveWait);
        }
        if (string.equals("LocalAccessPoint")) {
            return this._LocalAccessPoint;
        }
        if (string.equals("MaxEncryptBits")) {
            return this._MaxEncryptBits;
        }
        if (string.equals("MaxRetries")) {
            return new Long(this._MaxRetries);
        }
        if (string.equals("MinEncryptBits")) {
            return this._MinEncryptBits;
        }
        if (string.equals("NWAddr")) {
            return this._NWAddr;
        }
        if (string.equals("RetryInterval")) {
            return new Long(this._RetryInterval);
        }
        if (string.equals("TpUsrFile")) {
            return this._TpUsrFile;
        }
        if (string.equals("TuxedoGidKw")) {
            return this._TuxedoGidKw;
        }
        if (string.equals("TuxedoUidKw")) {
            return this._TuxedoUidKw;
        }
        return super.getValue(string);
    }

    public static void validateGeneration() {
        try {
            LegalChecks.checkNonNull((String)"AccessPoint", (Object)"myRAP");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property AccessPoint in WTCRemoteTuxDomMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonNull((String)"AccessPointId", (Object)"myRAPId");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property AccessPointId in WTCRemoteTuxDomMBean" + illegalArgumentException.getMessage());
        }
        try {
            LegalChecks.checkNonNull((String)"LocalAccessPoint", (Object)"myLAP");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DescriptorValidateException("The default value for the property  is null. Properties annotated with false value on @legalZeroLength or @legalNull  should either have @required/@derivedDefault annotations or have a non-null value on @default annotation. Refer annotation legalNull on property LocalAccessPoint in WTCRemoteTuxDomMBean" + illegalArgumentException.getMessage());
        }
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 12: {
                    if (!string.equals("access-point")) break;
                    return 7;
                }
                case 15: {
                    if (string.equals("access-point-id")) {
                        return 8;
                    }
                    if (string.equals("allow-anonymous")) {
                        return 24;
                    }
                    if (string.equals("default-app-key")) {
                        return 25;
                    }
                    if (string.equals("federation-name")) {
                        return 19;
                    }
                    if (!string.equals("keep-alive-wait")) break;
                    return 31;
                }
                case 10: {
                    if (string.equals("acl-policy")) {
                        return 10;
                    }
                    if (!string.equals("keep-alive")) break;
                    return 30;
                }
                case 7: {
                    if (string.equals("app-key")) {
                        return 23;
                    }
                    if (!string.equals("nw-addr")) break;
                    return 17;
                }
                case 9: {
                    if (!string.equals("cmp-limit")) break;
                    return 20;
                }
                case 19: {
                    if (!string.equals("conn-principal-name")) break;
                    return 14;
                }
                case 17: {
                    if (string.equals("connection-policy")) {
                        return 9;
                    }
                    if (!string.equals("credential-policy")) break;
                    return 11;
                }
                case 20: {
                    if (!string.equals("custom-app-key-class")) break;
                    return 28;
                }
                case 26: {
                    if (!string.equals("custom-app-key-class-param")) break;
                    return 29;
                }
                case 14: {
                    if (string.equals("federation-url")) {
                        return 18;
                    }
                    if (!string.equals("retry-interval")) break;
                    return 15;
                }
                case 18: {
                    if (!string.equals("local-access-point")) break;
                    return 13;
                }
                case 16: {
                    if (string.equals("max-encrypt-bits")) {
                        return 22;
                    }
                    if (!string.equals("min-encrypt-bits")) break;
                    return 21;
                }
                case 11: {
                    if (string.equals("max-retries")) {
                        return 16;
                    }
                    if (!string.equals("tp-usr-file")) break;
                    return 12;
                }
                case 13: {
                    if (string.equals("tuxedo-gid-kw")) {
                        return 27;
                    }
                    if (!string.equals("tuxedo-uid-kw")) break;
                    return 26;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 7: {
                    return "access-point";
                }
                case 8: {
                    return "access-point-id";
                }
                case 10: {
                    return "acl-policy";
                }
                case 24: {
                    return "allow-anonymous";
                }
                case 23: {
                    return "app-key";
                }
                case 20: {
                    return "cmp-limit";
                }
                case 14: {
                    return "conn-principal-name";
                }
                case 9: {
                    return "connection-policy";
                }
                case 11: {
                    return "credential-policy";
                }
                case 28: {
                    return "custom-app-key-class";
                }
                case 29: {
                    return "custom-app-key-class-param";
                }
                case 25: {
                    return "default-app-key";
                }
                case 19: {
                    return "federation-name";
                }
                case 18: {
                    return "federation-url";
                }
                case 30: {
                    return "keep-alive";
                }
                case 31: {
                    return "keep-alive-wait";
                }
                case 13: {
                    return "local-access-point";
                }
                case 22: {
                    return "max-encrypt-bits";
                }
                case 16: {
                    return "max-retries";
                }
                case 21: {
                    return "min-encrypt-bits";
                }
                case 17: {
                    return "nw-addr";
                }
                case 15: {
                    return "retry-interval";
                }
                case 12: {
                    return "tp-usr-file";
                }
                case 27: {
                    return "tuxedo-gid-kw";
                }
                case 26: {
                    return "tuxedo-uid-kw";
                }
            }
            return super.getElementName(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private WTCRemoteTuxDomMBeanImpl bean;

        protected Helper(WTCRemoteTuxDomMBeanImpl wTCRemoteTuxDomMBeanImpl) {
            super(wTCRemoteTuxDomMBeanImpl);
            this.bean = wTCRemoteTuxDomMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 7: {
                    return "AccessPoint";
                }
                case 8: {
                    return "AccessPointId";
                }
                case 10: {
                    return "AclPolicy";
                }
                case 24: {
                    return "AllowAnonymous";
                }
                case 23: {
                    return "AppKey";
                }
                case 20: {
                    return "CmpLimit";
                }
                case 14: {
                    return "ConnPrincipalName";
                }
                case 9: {
                    return "ConnectionPolicy";
                }
                case 11: {
                    return "CredentialPolicy";
                }
                case 28: {
                    return "CustomAppKeyClass";
                }
                case 29: {
                    return "CustomAppKeyClassParam";
                }
                case 25: {
                    return "DefaultAppKey";
                }
                case 19: {
                    return "FederationName";
                }
                case 18: {
                    return "FederationURL";
                }
                case 30: {
                    return "KeepAlive";
                }
                case 31: {
                    return "KeepAliveWait";
                }
                case 13: {
                    return "LocalAccessPoint";
                }
                case 22: {
                    return "MaxEncryptBits";
                }
                case 16: {
                    return "MaxRetries";
                }
                case 21: {
                    return "MinEncryptBits";
                }
                case 17: {
                    return "NWAddr";
                }
                case 15: {
                    return "RetryInterval";
                }
                case 12: {
                    return "TpUsrFile";
                }
                case 27: {
                    return "TuxedoGidKw";
                }
                case 26: {
                    return "TuxedoUidKw";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("AccessPoint")) {
                return 7;
            }
            if (string.equals("AccessPointId")) {
                return 8;
            }
            if (string.equals("AclPolicy")) {
                return 10;
            }
            if (string.equals("AllowAnonymous")) {
                return 24;
            }
            if (string.equals("AppKey")) {
                return 23;
            }
            if (string.equals("CmpLimit")) {
                return 20;
            }
            if (string.equals("ConnPrincipalName")) {
                return 14;
            }
            if (string.equals("ConnectionPolicy")) {
                return 9;
            }
            if (string.equals("CredentialPolicy")) {
                return 11;
            }
            if (string.equals("CustomAppKeyClass")) {
                return 28;
            }
            if (string.equals("CustomAppKeyClassParam")) {
                return 29;
            }
            if (string.equals("DefaultAppKey")) {
                return 25;
            }
            if (string.equals("FederationName")) {
                return 19;
            }
            if (string.equals("FederationURL")) {
                return 18;
            }
            if (string.equals("KeepAlive")) {
                return 30;
            }
            if (string.equals("KeepAliveWait")) {
                return 31;
            }
            if (string.equals("LocalAccessPoint")) {
                return 13;
            }
            if (string.equals("MaxEncryptBits")) {
                return 22;
            }
            if (string.equals("MaxRetries")) {
                return 16;
            }
            if (string.equals("MinEncryptBits")) {
                return 21;
            }
            if (string.equals("NWAddr")) {
                return 17;
            }
            if (string.equals("RetryInterval")) {
                return 15;
            }
            if (string.equals("TpUsrFile")) {
                return 12;
            }
            if (string.equals("TuxedoGidKw")) {
                return 27;
            }
            if (string.equals("TuxedoUidKw")) {
                return 26;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isAccessPointSet()) {
                    stringBuffer.append("AccessPoint");
                    stringBuffer.append(String.valueOf(this.bean.getAccessPoint()));
                }
                if (this.bean.isAccessPointIdSet()) {
                    stringBuffer.append("AccessPointId");
                    stringBuffer.append(String.valueOf(this.bean.getAccessPointId()));
                }
                if (this.bean.isAclPolicySet()) {
                    stringBuffer.append("AclPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getAclPolicy()));
                }
                if (this.bean.isAllowAnonymousSet()) {
                    stringBuffer.append("AllowAnonymous");
                    stringBuffer.append(String.valueOf(this.bean.getAllowAnonymous()));
                }
                if (this.bean.isAppKeySet()) {
                    stringBuffer.append("AppKey");
                    stringBuffer.append(String.valueOf(this.bean.getAppKey()));
                }
                if (this.bean.isCmpLimitSet()) {
                    stringBuffer.append("CmpLimit");
                    stringBuffer.append(String.valueOf(this.bean.getCmpLimit()));
                }
                if (this.bean.isConnPrincipalNameSet()) {
                    stringBuffer.append("ConnPrincipalName");
                    stringBuffer.append(String.valueOf(this.bean.getConnPrincipalName()));
                }
                if (this.bean.isConnectionPolicySet()) {
                    stringBuffer.append("ConnectionPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getConnectionPolicy()));
                }
                if (this.bean.isCredentialPolicySet()) {
                    stringBuffer.append("CredentialPolicy");
                    stringBuffer.append(String.valueOf(this.bean.getCredentialPolicy()));
                }
                if (this.bean.isCustomAppKeyClassSet()) {
                    stringBuffer.append("CustomAppKeyClass");
                    stringBuffer.append(String.valueOf(this.bean.getCustomAppKeyClass()));
                }
                if (this.bean.isCustomAppKeyClassParamSet()) {
                    stringBuffer.append("CustomAppKeyClassParam");
                    stringBuffer.append(String.valueOf(this.bean.getCustomAppKeyClassParam()));
                }
                if (this.bean.isDefaultAppKeySet()) {
                    stringBuffer.append("DefaultAppKey");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultAppKey()));
                }
                if (this.bean.isFederationNameSet()) {
                    stringBuffer.append("FederationName");
                    stringBuffer.append(String.valueOf(this.bean.getFederationName()));
                }
                if (this.bean.isFederationURLSet()) {
                    stringBuffer.append("FederationURL");
                    stringBuffer.append(String.valueOf(this.bean.getFederationURL()));
                }
                if (this.bean.isKeepAliveSet()) {
                    stringBuffer.append("KeepAlive");
                    stringBuffer.append(String.valueOf(this.bean.getKeepAlive()));
                }
                if (this.bean.isKeepAliveWaitSet()) {
                    stringBuffer.append("KeepAliveWait");
                    stringBuffer.append(String.valueOf(this.bean.getKeepAliveWait()));
                }
                if (this.bean.isLocalAccessPointSet()) {
                    stringBuffer.append("LocalAccessPoint");
                    stringBuffer.append(String.valueOf(this.bean.getLocalAccessPoint()));
                }
                if (this.bean.isMaxEncryptBitsSet()) {
                    stringBuffer.append("MaxEncryptBits");
                    stringBuffer.append(String.valueOf(this.bean.getMaxEncryptBits()));
                }
                if (this.bean.isMaxRetriesSet()) {
                    stringBuffer.append("MaxRetries");
                    stringBuffer.append(String.valueOf(this.bean.getMaxRetries()));
                }
                if (this.bean.isMinEncryptBitsSet()) {
                    stringBuffer.append("MinEncryptBits");
                    stringBuffer.append(String.valueOf(this.bean.getMinEncryptBits()));
                }
                if (this.bean.isNWAddrSet()) {
                    stringBuffer.append("NWAddr");
                    stringBuffer.append(String.valueOf(this.bean.getNWAddr()));
                }
                if (this.bean.isRetryIntervalSet()) {
                    stringBuffer.append("RetryInterval");
                    stringBuffer.append(String.valueOf(this.bean.getRetryInterval()));
                }
                if (this.bean.isTpUsrFileSet()) {
                    stringBuffer.append("TpUsrFile");
                    stringBuffer.append(String.valueOf(this.bean.getTpUsrFile()));
                }
                if (this.bean.isTuxedoGidKwSet()) {
                    stringBuffer.append("TuxedoGidKw");
                    stringBuffer.append(String.valueOf(this.bean.getTuxedoGidKw()));
                }
                if (this.bean.isTuxedoUidKwSet()) {
                    stringBuffer.append("TuxedoUidKw");
                    stringBuffer.append(String.valueOf(this.bean.getTuxedoUidKw()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WTCRemoteTuxDomMBeanImpl wTCRemoteTuxDomMBeanImpl = (WTCRemoteTuxDomMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AccessPoint", this.bean.getAccessPoint(), wTCRemoteTuxDomMBeanImpl.getAccessPoint(), true);
                this.computeDiff("AccessPointId", this.bean.getAccessPointId(), wTCRemoteTuxDomMBeanImpl.getAccessPointId(), true);
                this.computeDiff("AclPolicy", this.bean.getAclPolicy(), wTCRemoteTuxDomMBeanImpl.getAclPolicy(), true);
                this.computeDiff("AllowAnonymous", this.bean.getAllowAnonymous(), wTCRemoteTuxDomMBeanImpl.getAllowAnonymous(), true);
                this.computeDiff("AppKey", this.bean.getAppKey(), wTCRemoteTuxDomMBeanImpl.getAppKey(), true);
                this.computeDiff("CmpLimit", this.bean.getCmpLimit(), wTCRemoteTuxDomMBeanImpl.getCmpLimit(), true);
                this.computeDiff("ConnPrincipalName", this.bean.getConnPrincipalName(), wTCRemoteTuxDomMBeanImpl.getConnPrincipalName(), true);
                this.computeDiff("ConnectionPolicy", this.bean.getConnectionPolicy(), wTCRemoteTuxDomMBeanImpl.getConnectionPolicy(), true);
                this.computeDiff("CredentialPolicy", this.bean.getCredentialPolicy(), wTCRemoteTuxDomMBeanImpl.getCredentialPolicy(), true);
                this.computeDiff("CustomAppKeyClass", this.bean.getCustomAppKeyClass(), wTCRemoteTuxDomMBeanImpl.getCustomAppKeyClass(), true);
                this.computeDiff("CustomAppKeyClassParam", this.bean.getCustomAppKeyClassParam(), wTCRemoteTuxDomMBeanImpl.getCustomAppKeyClassParam(), true);
                this.computeDiff("DefaultAppKey", this.bean.getDefaultAppKey(), wTCRemoteTuxDomMBeanImpl.getDefaultAppKey(), true);
                this.computeDiff("FederationName", this.bean.getFederationName(), wTCRemoteTuxDomMBeanImpl.getFederationName(), true);
                this.computeDiff("FederationURL", this.bean.getFederationURL(), wTCRemoteTuxDomMBeanImpl.getFederationURL(), true);
                this.computeDiff("KeepAlive", this.bean.getKeepAlive(), wTCRemoteTuxDomMBeanImpl.getKeepAlive(), true);
                this.computeDiff("KeepAliveWait", this.bean.getKeepAliveWait(), wTCRemoteTuxDomMBeanImpl.getKeepAliveWait(), true);
                this.computeDiff("LocalAccessPoint", this.bean.getLocalAccessPoint(), wTCRemoteTuxDomMBeanImpl.getLocalAccessPoint(), true);
                this.computeDiff("MaxEncryptBits", this.bean.getMaxEncryptBits(), wTCRemoteTuxDomMBeanImpl.getMaxEncryptBits(), true);
                this.computeDiff("MaxRetries", this.bean.getMaxRetries(), wTCRemoteTuxDomMBeanImpl.getMaxRetries(), true);
                this.computeDiff("MinEncryptBits", this.bean.getMinEncryptBits(), wTCRemoteTuxDomMBeanImpl.getMinEncryptBits(), true);
                this.computeDiff("NWAddr", this.bean.getNWAddr(), wTCRemoteTuxDomMBeanImpl.getNWAddr(), true);
                this.computeDiff("RetryInterval", this.bean.getRetryInterval(), wTCRemoteTuxDomMBeanImpl.getRetryInterval(), true);
                this.computeDiff("TpUsrFile", this.bean.getTpUsrFile(), wTCRemoteTuxDomMBeanImpl.getTpUsrFile(), true);
                this.computeDiff("TuxedoGidKw", this.bean.getTuxedoGidKw(), wTCRemoteTuxDomMBeanImpl.getTuxedoGidKw(), true);
                this.computeDiff("TuxedoUidKw", this.bean.getTuxedoUidKw(), wTCRemoteTuxDomMBeanImpl.getTuxedoUidKw(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WTCRemoteTuxDomMBeanImpl wTCRemoteTuxDomMBeanImpl = (WTCRemoteTuxDomMBeanImpl)beanUpdateEvent.getSourceBean();
                WTCRemoteTuxDomMBeanImpl wTCRemoteTuxDomMBeanImpl2 = (WTCRemoteTuxDomMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("AccessPoint")) {
                    wTCRemoteTuxDomMBeanImpl.setAccessPoint(wTCRemoteTuxDomMBeanImpl2.getAccessPoint());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("AccessPointId")) {
                    wTCRemoteTuxDomMBeanImpl.setAccessPointId(wTCRemoteTuxDomMBeanImpl2.getAccessPointId());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("AclPolicy")) {
                    wTCRemoteTuxDomMBeanImpl.setAclPolicy(wTCRemoteTuxDomMBeanImpl2.getAclPolicy());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("AllowAnonymous")) {
                    wTCRemoteTuxDomMBeanImpl.setAllowAnonymous(wTCRemoteTuxDomMBeanImpl2.getAllowAnonymous());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("AppKey")) {
                    wTCRemoteTuxDomMBeanImpl.setAppKey(wTCRemoteTuxDomMBeanImpl2.getAppKey());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("CmpLimit")) {
                    wTCRemoteTuxDomMBeanImpl.setCmpLimit(wTCRemoteTuxDomMBeanImpl2.getCmpLimit());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("ConnPrincipalName")) {
                    wTCRemoteTuxDomMBeanImpl.setConnPrincipalName(wTCRemoteTuxDomMBeanImpl2.getConnPrincipalName());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("ConnectionPolicy")) {
                    wTCRemoteTuxDomMBeanImpl.setConnectionPolicy(wTCRemoteTuxDomMBeanImpl2.getConnectionPolicy());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("CredentialPolicy")) {
                    wTCRemoteTuxDomMBeanImpl.setCredentialPolicy(wTCRemoteTuxDomMBeanImpl2.getCredentialPolicy());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("CustomAppKeyClass")) {
                    wTCRemoteTuxDomMBeanImpl.setCustomAppKeyClass(wTCRemoteTuxDomMBeanImpl2.getCustomAppKeyClass());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (string.equals("CustomAppKeyClassParam")) {
                    wTCRemoteTuxDomMBeanImpl.setCustomAppKeyClassParam(wTCRemoteTuxDomMBeanImpl2.getCustomAppKeyClassParam());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                } else if (string.equals("DefaultAppKey")) {
                    wTCRemoteTuxDomMBeanImpl.setDefaultAppKey(wTCRemoteTuxDomMBeanImpl2.getDefaultAppKey());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("FederationName")) {
                    wTCRemoteTuxDomMBeanImpl.setFederationName(wTCRemoteTuxDomMBeanImpl2.getFederationName());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("FederationURL")) {
                    wTCRemoteTuxDomMBeanImpl.setFederationURL(wTCRemoteTuxDomMBeanImpl2.getFederationURL());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("KeepAlive")) {
                    wTCRemoteTuxDomMBeanImpl.setKeepAlive(wTCRemoteTuxDomMBeanImpl2.getKeepAlive());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                } else if (string.equals("KeepAliveWait")) {
                    wTCRemoteTuxDomMBeanImpl.setKeepAliveWait(wTCRemoteTuxDomMBeanImpl2.getKeepAliveWait());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                } else if (string.equals("LocalAccessPoint")) {
                    wTCRemoteTuxDomMBeanImpl.setLocalAccessPoint(wTCRemoteTuxDomMBeanImpl2.getLocalAccessPoint());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("MaxEncryptBits")) {
                    wTCRemoteTuxDomMBeanImpl.setMaxEncryptBits(wTCRemoteTuxDomMBeanImpl2.getMaxEncryptBits());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("MaxRetries")) {
                    wTCRemoteTuxDomMBeanImpl.setMaxRetries(wTCRemoteTuxDomMBeanImpl2.getMaxRetries());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("MinEncryptBits")) {
                    wTCRemoteTuxDomMBeanImpl.setMinEncryptBits(wTCRemoteTuxDomMBeanImpl2.getMinEncryptBits());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("NWAddr")) {
                    wTCRemoteTuxDomMBeanImpl.setNWAddr(wTCRemoteTuxDomMBeanImpl2.getNWAddr());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("RetryInterval")) {
                    wTCRemoteTuxDomMBeanImpl.setRetryInterval(wTCRemoteTuxDomMBeanImpl2.getRetryInterval());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("TpUsrFile")) {
                    wTCRemoteTuxDomMBeanImpl.setTpUsrFile(wTCRemoteTuxDomMBeanImpl2.getTpUsrFile());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("TuxedoGidKw")) {
                    wTCRemoteTuxDomMBeanImpl.setTuxedoGidKw(wTCRemoteTuxDomMBeanImpl2.getTuxedoGidKw());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("TuxedoUidKw")) {
                    wTCRemoteTuxDomMBeanImpl.setTuxedoUidKw(wTCRemoteTuxDomMBeanImpl2.getTuxedoUidKw());
                    wTCRemoteTuxDomMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                WTCRemoteTuxDomMBeanImpl wTCRemoteTuxDomMBeanImpl = (WTCRemoteTuxDomMBeanImpl)abstractDescriptorBean;
                super.finishCopy(wTCRemoteTuxDomMBeanImpl, bl, list);
                if ((list == null || !list.contains("AccessPoint")) && this.bean.isAccessPointSet()) {
                    wTCRemoteTuxDomMBeanImpl.setAccessPoint(this.bean.getAccessPoint());
                }
                if ((list == null || !list.contains("AccessPointId")) && this.bean.isAccessPointIdSet()) {
                    wTCRemoteTuxDomMBeanImpl.setAccessPointId(this.bean.getAccessPointId());
                }
                if ((list == null || !list.contains("AclPolicy")) && this.bean.isAclPolicySet()) {
                    wTCRemoteTuxDomMBeanImpl.setAclPolicy(this.bean.getAclPolicy());
                }
                if ((list == null || !list.contains("AllowAnonymous")) && this.bean.isAllowAnonymousSet()) {
                    wTCRemoteTuxDomMBeanImpl.setAllowAnonymous(this.bean.getAllowAnonymous());
                }
                if ((list == null || !list.contains("AppKey")) && this.bean.isAppKeySet()) {
                    wTCRemoteTuxDomMBeanImpl.setAppKey(this.bean.getAppKey());
                }
                if ((list == null || !list.contains("CmpLimit")) && this.bean.isCmpLimitSet()) {
                    wTCRemoteTuxDomMBeanImpl.setCmpLimit(this.bean.getCmpLimit());
                }
                if ((list == null || !list.contains("ConnPrincipalName")) && this.bean.isConnPrincipalNameSet()) {
                    wTCRemoteTuxDomMBeanImpl.setConnPrincipalName(this.bean.getConnPrincipalName());
                }
                if ((list == null || !list.contains("ConnectionPolicy")) && this.bean.isConnectionPolicySet()) {
                    wTCRemoteTuxDomMBeanImpl.setConnectionPolicy(this.bean.getConnectionPolicy());
                }
                if ((list == null || !list.contains("CredentialPolicy")) && this.bean.isCredentialPolicySet()) {
                    wTCRemoteTuxDomMBeanImpl.setCredentialPolicy(this.bean.getCredentialPolicy());
                }
                if ((list == null || !list.contains("CustomAppKeyClass")) && this.bean.isCustomAppKeyClassSet()) {
                    wTCRemoteTuxDomMBeanImpl.setCustomAppKeyClass(this.bean.getCustomAppKeyClass());
                }
                if ((list == null || !list.contains("CustomAppKeyClassParam")) && this.bean.isCustomAppKeyClassParamSet()) {
                    wTCRemoteTuxDomMBeanImpl.setCustomAppKeyClassParam(this.bean.getCustomAppKeyClassParam());
                }
                if ((list == null || !list.contains("DefaultAppKey")) && this.bean.isDefaultAppKeySet()) {
                    wTCRemoteTuxDomMBeanImpl.setDefaultAppKey(this.bean.getDefaultAppKey());
                }
                if ((list == null || !list.contains("FederationName")) && this.bean.isFederationNameSet()) {
                    wTCRemoteTuxDomMBeanImpl.setFederationName(this.bean.getFederationName());
                }
                if ((list == null || !list.contains("FederationURL")) && this.bean.isFederationURLSet()) {
                    wTCRemoteTuxDomMBeanImpl.setFederationURL(this.bean.getFederationURL());
                }
                if ((list == null || !list.contains("KeepAlive")) && this.bean.isKeepAliveSet()) {
                    wTCRemoteTuxDomMBeanImpl.setKeepAlive(this.bean.getKeepAlive());
                }
                if ((list == null || !list.contains("KeepAliveWait")) && this.bean.isKeepAliveWaitSet()) {
                    wTCRemoteTuxDomMBeanImpl.setKeepAliveWait(this.bean.getKeepAliveWait());
                }
                if ((list == null || !list.contains("LocalAccessPoint")) && this.bean.isLocalAccessPointSet()) {
                    wTCRemoteTuxDomMBeanImpl.setLocalAccessPoint(this.bean.getLocalAccessPoint());
                }
                if ((list == null || !list.contains("MaxEncryptBits")) && this.bean.isMaxEncryptBitsSet()) {
                    wTCRemoteTuxDomMBeanImpl.setMaxEncryptBits(this.bean.getMaxEncryptBits());
                }
                if ((list == null || !list.contains("MaxRetries")) && this.bean.isMaxRetriesSet()) {
                    wTCRemoteTuxDomMBeanImpl.setMaxRetries(this.bean.getMaxRetries());
                }
                if ((list == null || !list.contains("MinEncryptBits")) && this.bean.isMinEncryptBitsSet()) {
                    wTCRemoteTuxDomMBeanImpl.setMinEncryptBits(this.bean.getMinEncryptBits());
                }
                if ((list == null || !list.contains("NWAddr")) && this.bean.isNWAddrSet()) {
                    wTCRemoteTuxDomMBeanImpl.setNWAddr(this.bean.getNWAddr());
                }
                if ((list == null || !list.contains("RetryInterval")) && this.bean.isRetryIntervalSet()) {
                    wTCRemoteTuxDomMBeanImpl.setRetryInterval(this.bean.getRetryInterval());
                }
                if ((list == null || !list.contains("TpUsrFile")) && this.bean.isTpUsrFileSet()) {
                    wTCRemoteTuxDomMBeanImpl.setTpUsrFile(this.bean.getTpUsrFile());
                }
                if ((list == null || !list.contains("TuxedoGidKw")) && this.bean.isTuxedoGidKwSet()) {
                    wTCRemoteTuxDomMBeanImpl.setTuxedoGidKw(this.bean.getTuxedoGidKw());
                }
                if ((list == null || !list.contains("TuxedoUidKw")) && this.bean.isTuxedoUidKwSet()) {
                    wTCRemoteTuxDomMBeanImpl.setTuxedoUidKw(this.bean.getTuxedoUidKw());
                }
                return wTCRemoteTuxDomMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

