/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBeanImpl;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.TargetMBeanImpl;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.VirtualHostMBeanImpl;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.configuration.WebServerMBeanImpl;
import weblogic.management.mbeans.custom.WebAppComponent;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class WebAppComponentMBeanImpl
extends ComponentMBeanImpl
implements WebAppComponentMBean,
Serializable {
    private TargetMBean[] _ActivatedTargets;
    private ApplicationMBean _Application;
    private String _AuthFilter;
    private String _AuthRealmName;
    private boolean _CleanupSessionFilesEnabled;
    private String _ContextPath;
    private boolean _DebugEnabled;
    private String _DefaultServlet;
    private VirtualHostMBean[] _DeployedVirtualHosts;
    private String _DocumentRoot;
    private boolean _IndexDirectoryEnabled;
    private String[] _IndexFiles;
    private String _MimeTypeDefault;
    private Map _MimeTypes;
    private String _Name;
    private boolean _PreferWebInfClasses;
    private String _ServletClasspath;
    private boolean _ServletExtensionCaseSensitive;
    private int _ServletReloadCheckSecs;
    private String[] _Servlets;
    private int _SessionCacheSize;
    private String _SessionCookieComment;
    private String _SessionCookieDomain;
    private int _SessionCookieMaxAgeSecs;
    private String _SessionCookieName;
    private String _SessionCookiePath;
    private boolean _SessionCookiesEnabled;
    private boolean _SessionDebuggable;
    private int _SessionIDLength;
    private int _SessionInvalidationIntervalSecs;
    private int _SessionJDBCConnectionTimeoutSecs;
    private String _SessionMainAttribute;
    private boolean _SessionMonitoringEnabled;
    private String _SessionPersistentStoreCookieName;
    private String _SessionPersistentStoreDir;
    private String _SessionPersistentStorePool;
    private boolean _SessionPersistentStoreShared;
    private String _SessionPersistentStoreTable;
    private String _SessionPersistentStoreType;
    private int _SessionSwapIntervalSecs;
    private int _SessionTimeoutSecs;
    private boolean _SessionTrackingEnabled;
    private boolean _SessionURLRewritingEnabled;
    private int _SingleThreadedServletPoolSize;
    private TargetMBean[] _Targets;
    private VirtualHostMBean[] _VirtualHosts;
    private WebServerMBean[] _WebServers;
    private WebAppComponent _customizer;
    private static SchemaHelper2 _schemaHelper;

    public WebAppComponentMBeanImpl() {
        try {
            this._customizer = new WebAppComponent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public WebAppComponentMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new WebAppComponent(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public ApplicationMBean getApplication() {
        return this._customizer.getApplication();
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public int getSessionCookieMaxAgeSecs() {
        return this._SessionCookieMaxAgeSecs;
    }

    public TargetMBean[] getTargets() {
        return this._customizer.getTargets();
    }

    public String getTargetsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getTargets());
    }

    public WebServerMBean[] getWebServers() {
        return this._WebServers;
    }

    public boolean isApplicationSet() {
        return this._isSet(9);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isSessionCookieMaxAgeSecsSet() {
        return this._isSet(15);
    }

    public boolean isTargetsSet() {
        return this._isSet(7);
    }

    public boolean isWebServersSet() {
        return this._isSet(12);
    }

    public void setTargetsAsString(String string) {
        if (string == null || string.length() == 0) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._initializeProperty(7);
            this._postSet(7, targetMBeanArray, this._Targets);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._Targets);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, TargetMBean.class, new ReferenceManager.Resolver(this, 7){

                    public void resolveReference(Object object) {
                        try {
                            WebAppComponentMBeanImpl.this.addTarget((TargetMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (TargetMBean targetMBean : this._Targets) {
                    if (!string2.equals(targetMBean.getName())) continue;
                    try {
                        this.removeTarget(targetMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setApplication(ApplicationMBean applicationMBean) throws InvalidAttributeValueException {
        this._customizer.setApplication(applicationMBean);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public void setSessionCookieMaxAgeSecs(int n) throws InvalidAttributeValueException {
        this._SessionCookieMaxAgeSecs = n;
    }

    public void setTargets(TargetMBean[] targetMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        targetMBeanArray = (TargetMBean[])this._getHelper()._cleanAndValidateArray((Object)targetMBeanArray, TargetMBean.class);
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (targetMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 7, (AbstractDescriptorBean)targetMBeanArray[i]){

                protected Object getPropertyValue() {
                    return WebAppComponentMBeanImpl.this.getTargets();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)targetMBeanArray[i], resolvedReference);
        }
        TargetMBean[] targetMBeanArray2 = this.getTargets();
        this._customizer.setTargets(targetMBeanArray);
        this._postSet(7, targetMBeanArray2, targetMBeanArray);
    }

    public void setWebServers(WebServerMBean[] webServerMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        webServerMBeanArray = webServerMBeanArray == null ? new WebServerMBeanImpl[]{} : webServerMBeanArray;
        this._WebServers = webServerMBeanArray;
    }

    public boolean addTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 7)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean addWebServer(WebServerMBean webServerMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)webServerMBean);
        if (!((AbstractDescriptorBean)webServerMBean).isChildProperty((DescriptorBean)this, 12)) {
            WebServerMBean[] webServerMBeanArray = (WebServerMBean[])this._getHelper()._extendArray((Object)this.getWebServers(), WebServerMBean.class, (Object)webServerMBean);
            try {
                this.setWebServers(webServerMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public int getSessionInvalidationIntervalSecs() {
        return this._SessionInvalidationIntervalSecs;
    }

    public boolean isSessionInvalidationIntervalSecsSet() {
        return this._isSet(16);
    }

    public boolean removeTarget(TargetMBean targetMBean) throws InvalidAttributeValueException, DistributedManagementException {
        TargetMBean[] targetMBeanArray = this.getTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public boolean removeWebServer(WebServerMBean webServerMBean) throws DistributedManagementException {
        WebServerMBean[] webServerMBeanArray = this.getWebServers();
        WebServerMBean[] webServerMBeanArray2 = (WebServerMBean[])this._getHelper()._removeElement((Object)webServerMBeanArray, WebServerMBean.class, (Object)webServerMBean);
        if (webServerMBeanArray2.length != webServerMBeanArray.length) {
            try {
                this.setWebServers(webServerMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setSessionInvalidationIntervalSecs(int n) throws InvalidAttributeValueException {
        this._SessionInvalidationIntervalSecs = n;
    }

    public TargetMBean[] getActivatedTargets() {
        return this._customizer.getActivatedTargets();
    }

    public int getSessionJDBCConnectionTimeoutSecs() {
        return this._SessionJDBCConnectionTimeoutSecs;
    }

    public VirtualHostMBean[] getVirtualHosts() {
        return this._VirtualHosts;
    }

    public String getVirtualHostsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getVirtualHosts());
    }

    public boolean isActivatedTargetsSet() {
        return this._isSet(11);
    }

    public boolean isSessionJDBCConnectionTimeoutSecsSet() {
        return this._isSet(17);
    }

    public boolean isVirtualHostsSet() {
        return this._isSet(13);
    }

    public void setVirtualHostsAsString(String string) {
        if (string == null || string.length() == 0) {
            VirtualHostMBean[] virtualHostMBeanArray = this._VirtualHosts;
            this._initializeProperty(13);
            this._postSet(13, virtualHostMBeanArray, this._VirtualHosts);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._VirtualHosts);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, VirtualHostMBean.class, new ReferenceManager.Resolver(this, 13){

                    public void resolveReference(Object object) {
                        try {
                            WebAppComponentMBeanImpl.this.addVirtualHost((VirtualHostMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (VirtualHostMBean virtualHostMBean : this._VirtualHosts) {
                    if (!string2.equals(virtualHostMBean.getName())) continue;
                    try {
                        this.removeVirtualHost(virtualHostMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void addActivatedTarget(TargetMBean targetMBean) {
        this._getHelper()._ensureNonNull((Object)targetMBean);
        if (!((AbstractDescriptorBean)targetMBean).isChildProperty((DescriptorBean)this, 11)) {
            TargetMBean[] targetMBeanArray = (TargetMBean[])this._getHelper()._extendArray((Object)this.getActivatedTargets(), TargetMBean.class, (Object)targetMBean);
            try {
                this.setActivatedTargets(targetMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setSessionJDBCConnectionTimeoutSecs(int n) throws InvalidAttributeValueException {
        this._SessionJDBCConnectionTimeoutSecs = n;
    }

    public void setVirtualHosts(VirtualHostMBean[] virtualHostMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        virtualHostMBeanArray = virtualHostMBeanArray == null ? new VirtualHostMBeanImpl[]{} : virtualHostMBeanArray;
        virtualHostMBeanArray = (VirtualHostMBean[])this._getHelper()._cleanAndValidateArray((Object)virtualHostMBeanArray, VirtualHostMBean.class);
        for (int i = 0; i < virtualHostMBeanArray.length; ++i) {
            if (virtualHostMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 13, (AbstractDescriptorBean)virtualHostMBeanArray[i]){

                protected Object getPropertyValue() {
                    return WebAppComponentMBeanImpl.this.getVirtualHosts();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)virtualHostMBeanArray[i], resolvedReference);
        }
        VirtualHostMBean[] virtualHostMBeanArray2 = this._VirtualHosts;
        this._VirtualHosts = virtualHostMBeanArray;
        this._postSet(13, virtualHostMBeanArray2, virtualHostMBeanArray);
    }

    public boolean addVirtualHost(VirtualHostMBean virtualHostMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)virtualHostMBean);
        if (!((AbstractDescriptorBean)virtualHostMBean).isChildProperty((DescriptorBean)this, 13)) {
            VirtualHostMBean[] virtualHostMBeanArray = this._isSet(13) ? (VirtualHostMBean[])this._getHelper()._extendArray((Object)this.getVirtualHosts(), VirtualHostMBean.class, (Object)virtualHostMBean) : new VirtualHostMBean[]{virtualHostMBean};
            try {
                this.setVirtualHosts(virtualHostMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public int getSessionTimeoutSecs() {
        return this._SessionTimeoutSecs;
    }

    public boolean isSessionTimeoutSecsSet() {
        return this._isSet(18);
    }

    public void removeActivatedTarget(TargetMBean targetMBean) {
        TargetMBean[] targetMBeanArray = this.getActivatedTargets();
        TargetMBean[] targetMBeanArray2 = (TargetMBean[])this._getHelper()._removeElement((Object)targetMBeanArray, TargetMBean.class, (Object)targetMBean);
        if (targetMBeanArray2.length != targetMBeanArray.length) {
            try {
                this.setActivatedTargets(targetMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public boolean removeVirtualHost(VirtualHostMBean virtualHostMBean) throws DistributedManagementException {
        VirtualHostMBean[] virtualHostMBeanArray = this.getVirtualHosts();
        VirtualHostMBean[] virtualHostMBeanArray2 = (VirtualHostMBean[])this._getHelper()._removeElement((Object)virtualHostMBeanArray, VirtualHostMBean.class, (Object)virtualHostMBean);
        if (virtualHostMBeanArray2.length != virtualHostMBeanArray.length) {
            try {
                this.setVirtualHosts(virtualHostMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setActivatedTargets(TargetMBean[] targetMBeanArray) {
        targetMBeanArray = targetMBeanArray == null ? new TargetMBeanImpl[]{} : targetMBeanArray;
        this._ActivatedTargets = targetMBeanArray;
    }

    public void setSessionTimeoutSecs(int n) throws InvalidAttributeValueException {
        this._SessionTimeoutSecs = n;
    }

    public boolean activated(TargetMBean targetMBean) {
        return this._customizer.activated(targetMBean);
    }

    public void addDeployedVirtualHost(VirtualHostMBean virtualHostMBean) {
        this._getHelper()._ensureNonNull((Object)virtualHostMBean);
        if (!((AbstractDescriptorBean)virtualHostMBean).isChildProperty((DescriptorBean)this, 14)) {
            VirtualHostMBean[] virtualHostMBeanArray = (VirtualHostMBean[])this._getHelper()._extendArray((Object)this.getDeployedVirtualHosts(), VirtualHostMBean.class, (Object)virtualHostMBean);
            try {
                this.setDeployedVirtualHosts(virtualHostMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public VirtualHostMBean[] getDeployedVirtualHosts() {
        return this._DeployedVirtualHosts;
    }

    public String getMimeTypeDefault() {
        return this._MimeTypeDefault;
    }

    public boolean isDeployedVirtualHostsSet() {
        return this._isSet(14);
    }

    public boolean isMimeTypeDefaultSet() {
        return this._isSet(19);
    }

    public void removeDeployedVirtualHost(VirtualHostMBean virtualHostMBean) {
        VirtualHostMBean[] virtualHostMBeanArray = this.getDeployedVirtualHosts();
        VirtualHostMBean[] virtualHostMBeanArray2 = (VirtualHostMBean[])this._getHelper()._removeElement((Object)virtualHostMBeanArray, VirtualHostMBean.class, (Object)virtualHostMBean);
        if (virtualHostMBeanArray2.length != virtualHostMBeanArray.length) {
            try {
                this.setDeployedVirtualHosts(virtualHostMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void refreshDDsIfNeeded(String[] stringArray) {
        this._customizer.refreshDDsIfNeeded(stringArray);
    }

    public void setDeployedVirtualHosts(VirtualHostMBean[] virtualHostMBeanArray) {
        virtualHostMBeanArray = virtualHostMBeanArray == null ? new VirtualHostMBeanImpl[]{} : virtualHostMBeanArray;
        this._DeployedVirtualHosts = virtualHostMBeanArray;
    }

    public void setMimeTypeDefault(String string) throws InvalidAttributeValueException {
        this._MimeTypeDefault = string = string == null ? null : string.trim();
    }

    public Map getMimeTypes() {
        return this._MimeTypes;
    }

    public boolean isMimeTypesSet() {
        return this._isSet(20);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public void setMimeTypes(Map map) throws InvalidAttributeValueException {
        this._MimeTypes = map;
    }

    public String getDocumentRoot() {
        return this._DocumentRoot;
    }

    public boolean isDocumentRootSet() {
        return this._isSet(21);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setDocumentRoot(String string) throws InvalidAttributeValueException {
        this._DocumentRoot = string = string == null ? null : string.trim();
    }

    public String getDefaultServlet() {
        return this._DefaultServlet;
    }

    public boolean isDefaultServletSet() {
        return this._isSet(22);
    }

    public void setDefaultServlet(String string) throws InvalidAttributeValueException {
        this._DefaultServlet = string = string == null ? null : string.trim();
    }

    public boolean isIndexDirectoryEnabled() {
        return this._IndexDirectoryEnabled;
    }

    public boolean isIndexDirectoryEnabledSet() {
        return this._isSet(23);
    }

    public void setIndexDirectoryEnabled(boolean bl) {
        boolean bl2 = this._IndexDirectoryEnabled;
        this._IndexDirectoryEnabled = bl;
        this._postSet(23, bl2, bl);
    }

    public String[] getIndexFiles() {
        return this._IndexFiles;
    }

    public boolean isIndexFilesSet() {
        return this._isSet(24);
    }

    public void setIndexFiles(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        this._IndexFiles = stringArray;
    }

    public boolean addIndexFile(String string) {
        this._getHelper()._ensureNonNull((Object)string);
        String[] stringArray = (String[])this._getHelper()._extendArray((Object)this.getIndexFiles(), String.class, (Object)string);
        try {
            this.setIndexFiles(stringArray);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return true;
    }

    public boolean removeIndexFile(String string) {
        String[] stringArray = this.getIndexFiles();
        String[] stringArray2 = (String[])this._getHelper()._removeElement((Object)stringArray, String.class, (Object)string);
        if (stringArray2.length != stringArray.length) {
            try {
                this.setIndexFiles(stringArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public String getServletClasspath() {
        return this._ServletClasspath;
    }

    public boolean isServletClasspathSet() {
        return this._isSet(25);
    }

    public void setServletClasspath(String string) throws InvalidAttributeValueException {
        this._ServletClasspath = string = string == null ? null : string.trim();
    }

    public boolean isServletExtensionCaseSensitive() {
        return this._ServletExtensionCaseSensitive;
    }

    public boolean isServletExtensionCaseSensitiveSet() {
        return this._isSet(26);
    }

    public void setServletExtensionCaseSensitive(boolean bl) {
        this._ServletExtensionCaseSensitive = bl;
    }

    public int getServletReloadCheckSecs() {
        return this._ServletReloadCheckSecs;
    }

    public boolean isServletReloadCheckSecsSet() {
        return this._isSet(27);
    }

    public void setServletReloadCheckSecs(int n) throws InvalidAttributeValueException {
        int n2 = this._ServletReloadCheckSecs;
        this._ServletReloadCheckSecs = n;
        this._postSet(27, n2, n);
    }

    public int getSingleThreadedServletPoolSize() {
        return this._SingleThreadedServletPoolSize;
    }

    public boolean isSingleThreadedServletPoolSizeSet() {
        return this._isSet(28);
    }

    public void setSingleThreadedServletPoolSize(int n) throws InvalidAttributeValueException {
        int n2 = this._SingleThreadedServletPoolSize;
        this._SingleThreadedServletPoolSize = n;
        this._postSet(28, n2, n);
    }

    public String[] getServlets() {
        return this._Servlets;
    }

    public boolean isServletsSet() {
        return this._isSet(29);
    }

    public void setServlets(String[] stringArray) throws InvalidAttributeValueException {
        stringArray = stringArray == null ? new String[]{} : stringArray;
        stringArray = this._getHelper()._trimElements(stringArray);
        this._Servlets = stringArray;
    }

    public String getAuthRealmName() {
        return this._AuthRealmName;
    }

    public boolean isAuthRealmNameSet() {
        return this._isSet(30);
    }

    public void setAuthRealmName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._AuthRealmName;
        this._AuthRealmName = string;
        this._postSet(30, string2, string);
    }

    public String getAuthFilter() {
        return this._AuthFilter;
    }

    public boolean isAuthFilterSet() {
        return this._isSet(31);
    }

    public void setAuthFilter(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._AuthFilter;
        this._AuthFilter = string;
        this._postSet(31, string2, string);
    }

    public boolean isDebugEnabled() {
        return this._DebugEnabled;
    }

    public boolean isDebugEnabledSet() {
        return this._isSet(32);
    }

    public void setDebugEnabled(boolean bl) {
        this._DebugEnabled = bl;
    }

    public boolean isSessionURLRewritingEnabled() {
        return this._SessionURLRewritingEnabled;
    }

    public boolean isSessionURLRewritingEnabledSet() {
        return this._isSet(33);
    }

    public void setSessionURLRewritingEnabled(boolean bl) {
        boolean bl2 = this._SessionURLRewritingEnabled;
        this._SessionURLRewritingEnabled = bl;
        this._postSet(33, bl2, bl);
    }

    public int getSessionIDLength() {
        return this._SessionIDLength;
    }

    public boolean isSessionIDLengthSet() {
        return this._isSet(34);
    }

    public void setSessionIDLength(int n) throws InvalidAttributeValueException {
        this._SessionIDLength = n;
    }

    public int getSessionCacheSize() {
        return this._SessionCacheSize;
    }

    public boolean isSessionCacheSizeSet() {
        return this._isSet(35);
    }

    public void setSessionCacheSize(int n) throws InvalidAttributeValueException {
        this._SessionCacheSize = n;
    }

    public boolean isSessionCookiesEnabled() {
        return this._SessionCookiesEnabled;
    }

    public boolean isSessionCookiesEnabledSet() {
        return this._isSet(36);
    }

    public void setSessionCookiesEnabled(boolean bl) {
        this._SessionCookiesEnabled = bl;
    }

    public boolean isSessionTrackingEnabled() {
        return this._SessionTrackingEnabled;
    }

    public boolean isSessionTrackingEnabledSet() {
        return this._isSet(37);
    }

    public void setSessionTrackingEnabled(boolean bl) {
        this._SessionTrackingEnabled = bl;
    }

    public String getSessionCookieComment() {
        return this._SessionCookieComment;
    }

    public boolean isSessionCookieCommentSet() {
        return this._isSet(38);
    }

    public void setSessionCookieComment(String string) throws InvalidAttributeValueException {
        this._SessionCookieComment = string = string == null ? null : string.trim();
    }

    public String getSessionCookieDomain() {
        return this._SessionCookieDomain;
    }

    public boolean isSessionCookieDomainSet() {
        return this._isSet(39);
    }

    public void setSessionCookieDomain(String string) throws InvalidAttributeValueException {
        this._SessionCookieDomain = string = string == null ? null : string.trim();
    }

    public String getSessionCookieName() {
        return this._SessionCookieName;
    }

    public boolean isSessionCookieNameSet() {
        return this._isSet(40);
    }

    public void setSessionCookieName(String string) throws InvalidAttributeValueException {
        this._SessionCookieName = string = string == null ? null : string.trim();
    }

    public String getSessionCookiePath() {
        return this._SessionCookiePath;
    }

    public boolean isSessionCookiePathSet() {
        return this._isSet(41);
    }

    public void setSessionCookiePath(String string) throws InvalidAttributeValueException {
        this._SessionCookiePath = string = string == null ? null : string.trim();
    }

    public String getSessionPersistentStoreDir() {
        return this._SessionPersistentStoreDir;
    }

    public boolean isSessionPersistentStoreDirSet() {
        return this._isSet(42);
    }

    public void setSessionPersistentStoreDir(String string) throws InvalidAttributeValueException {
        this._SessionPersistentStoreDir = string = string == null ? null : string.trim();
    }

    public String getSessionPersistentStorePool() {
        return this._SessionPersistentStorePool;
    }

    public boolean isSessionPersistentStorePoolSet() {
        return this._isSet(43);
    }

    public void setSessionPersistentStorePool(String string) throws InvalidAttributeValueException {
        this._SessionPersistentStorePool = string = string == null ? null : string.trim();
    }

    public String getSessionPersistentStoreTable() {
        return this._SessionPersistentStoreTable;
    }

    public boolean isSessionPersistentStoreTableSet() {
        return this._isSet(44);
    }

    public void setSessionPersistentStoreTable(String string) throws InvalidAttributeValueException {
        this._SessionPersistentStoreTable = string = string == null ? null : string.trim();
    }

    public boolean isSessionPersistentStoreShared() {
        return this._SessionPersistentStoreShared;
    }

    public boolean isSessionPersistentStoreSharedSet() {
        return this._isSet(45);
    }

    public void setSessionPersistentStoreShared(boolean bl) {
        this._SessionPersistentStoreShared = bl;
    }

    public String getSessionPersistentStoreType() {
        return this._SessionPersistentStoreType;
    }

    public boolean isSessionPersistentStoreTypeSet() {
        return this._isSet(46);
    }

    public void setSessionPersistentStoreType(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"memory", "file", "jdbc", "replicated", "cookie", "replicated_if_clustered"};
        this._SessionPersistentStoreType = string = LegalChecks.checkInEnum((String)"SessionPersistentStoreType", (String)string, (String[])stringArray);
    }

    public String getSessionPersistentStoreCookieName() {
        return this._SessionPersistentStoreCookieName;
    }

    public boolean isSessionPersistentStoreCookieNameSet() {
        return this._isSet(47);
    }

    public void setSessionPersistentStoreCookieName(String string) throws InvalidAttributeValueException {
        this._SessionPersistentStoreCookieName = string = string == null ? null : string.trim();
    }

    public int getSessionSwapIntervalSecs() {
        return this._SessionSwapIntervalSecs;
    }

    public boolean isSessionSwapIntervalSecsSet() {
        return this._isSet(48);
    }

    public void setSessionSwapIntervalSecs(int n) throws InvalidAttributeValueException {
        this._SessionSwapIntervalSecs = n;
    }

    public void setSessionDebuggable(boolean bl) {
        this._SessionDebuggable = bl;
    }

    public boolean isSessionDebuggable() {
        return this._SessionDebuggable;
    }

    public boolean isSessionDebuggableSet() {
        return this._isSet(49);
    }

    public void setCleanupSessionFilesEnabled(boolean bl) {
        this._CleanupSessionFilesEnabled = bl;
    }

    public boolean isCleanupSessionFilesEnabled() {
        return this._CleanupSessionFilesEnabled;
    }

    public boolean isCleanupSessionFilesEnabledSet() {
        return this._isSet(50);
    }

    public String getContextPath() {
        return this._ContextPath;
    }

    public boolean isContextPathSet() {
        return this._isSet(51);
    }

    public void setContextPath(String string) throws InvalidAttributeValueException, DistributedManagementException {
        this._ContextPath = string = string == null ? null : string.trim();
    }

    public String getSessionMainAttribute() {
        return this._SessionMainAttribute;
    }

    public boolean isSessionMainAttributeSet() {
        return this._isSet(52);
    }

    public void setSessionMainAttribute(String string) throws InvalidAttributeValueException {
        this._SessionMainAttribute = string = string == null ? null : string.trim();
    }

    public boolean isSessionMonitoringEnabled() {
        return this._SessionMonitoringEnabled;
    }

    public boolean isSessionMonitoringEnabledSet() {
        return this._isSet(53);
    }

    public void setSessionMonitoringEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._SessionMonitoringEnabled;
        this._SessionMonitoringEnabled = bl;
        this._postSet(53, bl2, bl);
    }

    public boolean isPreferWebInfClasses() {
        return this._PreferWebInfClasses;
    }

    public boolean isPreferWebInfClassesSet() {
        return this._isSet(54);
    }

    public void setPreferWebInfClasses(boolean bl) {
        boolean bl2 = this._PreferWebInfClasses;
        this._PreferWebInfClasses = bl;
        this._postSet(54, bl2, bl);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 11;
        }
        try {
            switch (n) {
                case 11: {
                    this._ActivatedTargets = new TargetMBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._customizer.setApplication(null);
                    if (bl) break;
                }
                case 31: {
                    this._AuthFilter = null;
                    if (bl) break;
                }
                case 30: {
                    this._AuthRealmName = "weblogic";
                    if (bl) break;
                }
                case 51: {
                    this._ContextPath = null;
                    if (bl) break;
                }
                case 22: {
                    this._DefaultServlet = null;
                    if (bl) break;
                }
                case 14: {
                    this._DeployedVirtualHosts = new VirtualHostMBean[0];
                    if (bl) break;
                }
                case 21: {
                    this._DocumentRoot = null;
                    if (bl) break;
                }
                case 24: {
                    this._IndexFiles = StringHelper.split((String[])INDEX_FILES);
                    if (bl) break;
                }
                case 19: {
                    this._MimeTypeDefault = "text/plain";
                    if (bl) break;
                }
                case 20: {
                    this._MimeTypes = null;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 25: {
                    this._ServletClasspath = null;
                    if (bl) break;
                }
                case 27: {
                    this._ServletReloadCheckSecs = 1;
                    if (bl) break;
                }
                case 29: {
                    this._Servlets = new String[0];
                    if (bl) break;
                }
                case 35: {
                    this._SessionCacheSize = 1024;
                    if (bl) break;
                }
                case 38: {
                    this._SessionCookieComment = "Weblogic Server Session Tracking Cookie";
                    if (bl) break;
                }
                case 39: {
                    this._SessionCookieDomain = null;
                    if (bl) break;
                }
                case 15: {
                    this._SessionCookieMaxAgeSecs = -1;
                    if (bl) break;
                }
                case 40: {
                    this._SessionCookieName = "JSESSIONID";
                    if (bl) break;
                }
                case 41: {
                    this._SessionCookiePath = null;
                    if (bl) break;
                }
                case 34: {
                    this._SessionIDLength = 52;
                    if (bl) break;
                }
                case 16: {
                    this._SessionInvalidationIntervalSecs = 60;
                    if (bl) break;
                }
                case 17: {
                    this._SessionJDBCConnectionTimeoutSecs = 120;
                    if (bl) break;
                }
                case 52: {
                    this._SessionMainAttribute = "ConsoleAttribute";
                    if (bl) break;
                }
                case 47: {
                    this._SessionPersistentStoreCookieName = "WLCOOKIE";
                    if (bl) break;
                }
                case 42: {
                    this._SessionPersistentStoreDir = "session_db";
                    if (bl) break;
                }
                case 43: {
                    this._SessionPersistentStorePool = null;
                    if (bl) break;
                }
                case 44: {
                    this._SessionPersistentStoreTable = "wl_servlet_sessions";
                    if (bl) break;
                }
                case 46: {
                    this._SessionPersistentStoreType = "memory";
                    if (bl) break;
                }
                case 48: {
                    this._SessionSwapIntervalSecs = 10;
                    if (bl) break;
                }
                case 18: {
                    this._SessionTimeoutSecs = 3600;
                    if (bl) break;
                }
                case 28: {
                    this._SingleThreadedServletPoolSize = 5;
                    if (bl) break;
                }
                case 7: {
                    this._customizer.setTargets(new TargetMBean[0]);
                    if (bl) break;
                }
                case 13: {
                    this._VirtualHosts = new VirtualHostMBean[0];
                    if (bl) break;
                }
                case 12: {
                    this._WebServers = new WebServerMBean[0];
                    if (bl) break;
                }
                case 50: {
                    this._CleanupSessionFilesEnabled = false;
                    if (bl) break;
                }
                case 32: {
                    this._DebugEnabled = false;
                    if (bl) break;
                }
                case 23: {
                    this._IndexDirectoryEnabled = false;
                    if (bl) break;
                }
                case 54: {
                    this._PreferWebInfClasses = false;
                    if (bl) break;
                }
                case 26: {
                    this._ServletExtensionCaseSensitive = false;
                    if (bl) break;
                }
                case 36: {
                    this._SessionCookiesEnabled = true;
                    if (bl) break;
                }
                case 49: {
                    this._SessionDebuggable = false;
                    if (bl) break;
                }
                case 53: {
                    this._SessionMonitoringEnabled = false;
                    if (bl) break;
                }
                case 45: {
                    this._SessionPersistentStoreShared = false;
                    if (bl) break;
                }
                case 37: {
                    this._SessionTrackingEnabled = true;
                    if (bl) break;
                }
                case 33: {
                    this._SessionURLRewritingEnabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "WebAppComponent";
    }

    public void putValue(String string, Object object) {
        if (string.equals("ActivatedTargets")) {
            TargetMBean[] targetMBeanArray = this._ActivatedTargets;
            this._ActivatedTargets = (TargetMBean[])object;
            this._postSet(11, targetMBeanArray, this._ActivatedTargets);
            return;
        }
        if (string.equals("Application")) {
            ApplicationMBean applicationMBean = this._Application;
            this._Application = (ApplicationMBean)object;
            this._postSet(9, applicationMBean, this._Application);
            return;
        }
        if (string.equals("AuthFilter")) {
            String string2 = this._AuthFilter;
            this._AuthFilter = (String)object;
            this._postSet(31, string2, this._AuthFilter);
            return;
        }
        if (string.equals("AuthRealmName")) {
            String string3 = this._AuthRealmName;
            this._AuthRealmName = (String)object;
            this._postSet(30, string3, this._AuthRealmName);
            return;
        }
        if (string.equals("CleanupSessionFilesEnabled")) {
            boolean bl = this._CleanupSessionFilesEnabled;
            this._CleanupSessionFilesEnabled = (Boolean)object;
            this._postSet(50, bl, this._CleanupSessionFilesEnabled);
            return;
        }
        if (string.equals("ContextPath")) {
            String string4 = this._ContextPath;
            this._ContextPath = (String)object;
            this._postSet(51, string4, this._ContextPath);
            return;
        }
        if (string.equals("DebugEnabled")) {
            boolean bl = this._DebugEnabled;
            this._DebugEnabled = (Boolean)object;
            this._postSet(32, bl, this._DebugEnabled);
            return;
        }
        if (string.equals("DefaultServlet")) {
            String string5 = this._DefaultServlet;
            this._DefaultServlet = (String)object;
            this._postSet(22, string5, this._DefaultServlet);
            return;
        }
        if (string.equals("DeployedVirtualHosts")) {
            VirtualHostMBean[] virtualHostMBeanArray = this._DeployedVirtualHosts;
            this._DeployedVirtualHosts = (VirtualHostMBean[])object;
            this._postSet(14, virtualHostMBeanArray, this._DeployedVirtualHosts);
            return;
        }
        if (string.equals("DocumentRoot")) {
            String string6 = this._DocumentRoot;
            this._DocumentRoot = (String)object;
            this._postSet(21, string6, this._DocumentRoot);
            return;
        }
        if (string.equals("IndexDirectoryEnabled")) {
            boolean bl = this._IndexDirectoryEnabled;
            this._IndexDirectoryEnabled = (Boolean)object;
            this._postSet(23, bl, this._IndexDirectoryEnabled);
            return;
        }
        if (string.equals("IndexFiles")) {
            String[] stringArray = this._IndexFiles;
            this._IndexFiles = (String[])object;
            this._postSet(24, stringArray, this._IndexFiles);
            return;
        }
        if (string.equals("MimeTypeDefault")) {
            String string7 = this._MimeTypeDefault;
            this._MimeTypeDefault = (String)object;
            this._postSet(19, string7, this._MimeTypeDefault);
            return;
        }
        if (string.equals("MimeTypes")) {
            Map map = this._MimeTypes;
            this._MimeTypes = (Map)object;
            this._postSet(20, map, this._MimeTypes);
            return;
        }
        if (string.equals("Name")) {
            String string8 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string8, this._Name);
            return;
        }
        if (string.equals("PreferWebInfClasses")) {
            boolean bl = this._PreferWebInfClasses;
            this._PreferWebInfClasses = (Boolean)object;
            this._postSet(54, bl, this._PreferWebInfClasses);
            return;
        }
        if (string.equals("ServletClasspath")) {
            String string9 = this._ServletClasspath;
            this._ServletClasspath = (String)object;
            this._postSet(25, string9, this._ServletClasspath);
            return;
        }
        if (string.equals("ServletExtensionCaseSensitive")) {
            boolean bl = this._ServletExtensionCaseSensitive;
            this._ServletExtensionCaseSensitive = (Boolean)object;
            this._postSet(26, bl, this._ServletExtensionCaseSensitive);
            return;
        }
        if (string.equals("ServletReloadCheckSecs")) {
            int n = this._ServletReloadCheckSecs;
            this._ServletReloadCheckSecs = (Integer)object;
            this._postSet(27, n, this._ServletReloadCheckSecs);
            return;
        }
        if (string.equals("Servlets")) {
            String[] stringArray = this._Servlets;
            this._Servlets = (String[])object;
            this._postSet(29, stringArray, this._Servlets);
            return;
        }
        if (string.equals("SessionCacheSize")) {
            int n = this._SessionCacheSize;
            this._SessionCacheSize = (Integer)object;
            this._postSet(35, n, this._SessionCacheSize);
            return;
        }
        if (string.equals("SessionCookieComment")) {
            String string10 = this._SessionCookieComment;
            this._SessionCookieComment = (String)object;
            this._postSet(38, string10, this._SessionCookieComment);
            return;
        }
        if (string.equals("SessionCookieDomain")) {
            String string11 = this._SessionCookieDomain;
            this._SessionCookieDomain = (String)object;
            this._postSet(39, string11, this._SessionCookieDomain);
            return;
        }
        if (string.equals("SessionCookieMaxAgeSecs")) {
            int n = this._SessionCookieMaxAgeSecs;
            this._SessionCookieMaxAgeSecs = (Integer)object;
            this._postSet(15, n, this._SessionCookieMaxAgeSecs);
            return;
        }
        if (string.equals("SessionCookieName")) {
            String string12 = this._SessionCookieName;
            this._SessionCookieName = (String)object;
            this._postSet(40, string12, this._SessionCookieName);
            return;
        }
        if (string.equals("SessionCookiePath")) {
            String string13 = this._SessionCookiePath;
            this._SessionCookiePath = (String)object;
            this._postSet(41, string13, this._SessionCookiePath);
            return;
        }
        if (string.equals("SessionCookiesEnabled")) {
            boolean bl = this._SessionCookiesEnabled;
            this._SessionCookiesEnabled = (Boolean)object;
            this._postSet(36, bl, this._SessionCookiesEnabled);
            return;
        }
        if (string.equals("SessionDebuggable")) {
            boolean bl = this._SessionDebuggable;
            this._SessionDebuggable = (Boolean)object;
            this._postSet(49, bl, this._SessionDebuggable);
            return;
        }
        if (string.equals("SessionIDLength")) {
            int n = this._SessionIDLength;
            this._SessionIDLength = (Integer)object;
            this._postSet(34, n, this._SessionIDLength);
            return;
        }
        if (string.equals("SessionInvalidationIntervalSecs")) {
            int n = this._SessionInvalidationIntervalSecs;
            this._SessionInvalidationIntervalSecs = (Integer)object;
            this._postSet(16, n, this._SessionInvalidationIntervalSecs);
            return;
        }
        if (string.equals("SessionJDBCConnectionTimeoutSecs")) {
            int n = this._SessionJDBCConnectionTimeoutSecs;
            this._SessionJDBCConnectionTimeoutSecs = (Integer)object;
            this._postSet(17, n, this._SessionJDBCConnectionTimeoutSecs);
            return;
        }
        if (string.equals("SessionMainAttribute")) {
            String string14 = this._SessionMainAttribute;
            this._SessionMainAttribute = (String)object;
            this._postSet(52, string14, this._SessionMainAttribute);
            return;
        }
        if (string.equals("SessionMonitoringEnabled")) {
            boolean bl = this._SessionMonitoringEnabled;
            this._SessionMonitoringEnabled = (Boolean)object;
            this._postSet(53, bl, this._SessionMonitoringEnabled);
            return;
        }
        if (string.equals("SessionPersistentStoreCookieName")) {
            String string15 = this._SessionPersistentStoreCookieName;
            this._SessionPersistentStoreCookieName = (String)object;
            this._postSet(47, string15, this._SessionPersistentStoreCookieName);
            return;
        }
        if (string.equals("SessionPersistentStoreDir")) {
            String string16 = this._SessionPersistentStoreDir;
            this._SessionPersistentStoreDir = (String)object;
            this._postSet(42, string16, this._SessionPersistentStoreDir);
            return;
        }
        if (string.equals("SessionPersistentStorePool")) {
            String string17 = this._SessionPersistentStorePool;
            this._SessionPersistentStorePool = (String)object;
            this._postSet(43, string17, this._SessionPersistentStorePool);
            return;
        }
        if (string.equals("SessionPersistentStoreShared")) {
            boolean bl = this._SessionPersistentStoreShared;
            this._SessionPersistentStoreShared = (Boolean)object;
            this._postSet(45, bl, this._SessionPersistentStoreShared);
            return;
        }
        if (string.equals("SessionPersistentStoreTable")) {
            String string18 = this._SessionPersistentStoreTable;
            this._SessionPersistentStoreTable = (String)object;
            this._postSet(44, string18, this._SessionPersistentStoreTable);
            return;
        }
        if (string.equals("SessionPersistentStoreType")) {
            String string19 = this._SessionPersistentStoreType;
            this._SessionPersistentStoreType = (String)object;
            this._postSet(46, string19, this._SessionPersistentStoreType);
            return;
        }
        if (string.equals("SessionSwapIntervalSecs")) {
            int n = this._SessionSwapIntervalSecs;
            this._SessionSwapIntervalSecs = (Integer)object;
            this._postSet(48, n, this._SessionSwapIntervalSecs);
            return;
        }
        if (string.equals("SessionTimeoutSecs")) {
            int n = this._SessionTimeoutSecs;
            this._SessionTimeoutSecs = (Integer)object;
            this._postSet(18, n, this._SessionTimeoutSecs);
            return;
        }
        if (string.equals("SessionTrackingEnabled")) {
            boolean bl = this._SessionTrackingEnabled;
            this._SessionTrackingEnabled = (Boolean)object;
            this._postSet(37, bl, this._SessionTrackingEnabled);
            return;
        }
        if (string.equals("SessionURLRewritingEnabled")) {
            boolean bl = this._SessionURLRewritingEnabled;
            this._SessionURLRewritingEnabled = (Boolean)object;
            this._postSet(33, bl, this._SessionURLRewritingEnabled);
            return;
        }
        if (string.equals("SingleThreadedServletPoolSize")) {
            int n = this._SingleThreadedServletPoolSize;
            this._SingleThreadedServletPoolSize = (Integer)object;
            this._postSet(28, n, this._SingleThreadedServletPoolSize);
            return;
        }
        if (string.equals("Targets")) {
            TargetMBean[] targetMBeanArray = this._Targets;
            this._Targets = (TargetMBean[])object;
            this._postSet(7, targetMBeanArray, this._Targets);
            return;
        }
        if (string.equals("VirtualHosts")) {
            VirtualHostMBean[] virtualHostMBeanArray = this._VirtualHosts;
            this._VirtualHosts = (VirtualHostMBean[])object;
            this._postSet(13, virtualHostMBeanArray, this._VirtualHosts);
            return;
        }
        if (string.equals("WebServers")) {
            WebServerMBean[] webServerMBeanArray = this._WebServers;
            this._WebServers = (WebServerMBean[])object;
            this._postSet(12, webServerMBeanArray, this._WebServers);
            return;
        }
        if (string.equals("customizer")) {
            WebAppComponent webAppComponent = this._customizer;
            this._customizer = (WebAppComponent)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("ActivatedTargets")) {
            return this._ActivatedTargets;
        }
        if (string.equals("Application")) {
            return this._Application;
        }
        if (string.equals("AuthFilter")) {
            return this._AuthFilter;
        }
        if (string.equals("AuthRealmName")) {
            return this._AuthRealmName;
        }
        if (string.equals("CleanupSessionFilesEnabled")) {
            return new Boolean(this._CleanupSessionFilesEnabled);
        }
        if (string.equals("ContextPath")) {
            return this._ContextPath;
        }
        if (string.equals("DebugEnabled")) {
            return new Boolean(this._DebugEnabled);
        }
        if (string.equals("DefaultServlet")) {
            return this._DefaultServlet;
        }
        if (string.equals("DeployedVirtualHosts")) {
            return this._DeployedVirtualHosts;
        }
        if (string.equals("DocumentRoot")) {
            return this._DocumentRoot;
        }
        if (string.equals("IndexDirectoryEnabled")) {
            return new Boolean(this._IndexDirectoryEnabled);
        }
        if (string.equals("IndexFiles")) {
            return this._IndexFiles;
        }
        if (string.equals("MimeTypeDefault")) {
            return this._MimeTypeDefault;
        }
        if (string.equals("MimeTypes")) {
            return this._MimeTypes;
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("PreferWebInfClasses")) {
            return new Boolean(this._PreferWebInfClasses);
        }
        if (string.equals("ServletClasspath")) {
            return this._ServletClasspath;
        }
        if (string.equals("ServletExtensionCaseSensitive")) {
            return new Boolean(this._ServletExtensionCaseSensitive);
        }
        if (string.equals("ServletReloadCheckSecs")) {
            return new Integer(this._ServletReloadCheckSecs);
        }
        if (string.equals("Servlets")) {
            return this._Servlets;
        }
        if (string.equals("SessionCacheSize")) {
            return new Integer(this._SessionCacheSize);
        }
        if (string.equals("SessionCookieComment")) {
            return this._SessionCookieComment;
        }
        if (string.equals("SessionCookieDomain")) {
            return this._SessionCookieDomain;
        }
        if (string.equals("SessionCookieMaxAgeSecs")) {
            return new Integer(this._SessionCookieMaxAgeSecs);
        }
        if (string.equals("SessionCookieName")) {
            return this._SessionCookieName;
        }
        if (string.equals("SessionCookiePath")) {
            return this._SessionCookiePath;
        }
        if (string.equals("SessionCookiesEnabled")) {
            return new Boolean(this._SessionCookiesEnabled);
        }
        if (string.equals("SessionDebuggable")) {
            return new Boolean(this._SessionDebuggable);
        }
        if (string.equals("SessionIDLength")) {
            return new Integer(this._SessionIDLength);
        }
        if (string.equals("SessionInvalidationIntervalSecs")) {
            return new Integer(this._SessionInvalidationIntervalSecs);
        }
        if (string.equals("SessionJDBCConnectionTimeoutSecs")) {
            return new Integer(this._SessionJDBCConnectionTimeoutSecs);
        }
        if (string.equals("SessionMainAttribute")) {
            return this._SessionMainAttribute;
        }
        if (string.equals("SessionMonitoringEnabled")) {
            return new Boolean(this._SessionMonitoringEnabled);
        }
        if (string.equals("SessionPersistentStoreCookieName")) {
            return this._SessionPersistentStoreCookieName;
        }
        if (string.equals("SessionPersistentStoreDir")) {
            return this._SessionPersistentStoreDir;
        }
        if (string.equals("SessionPersistentStorePool")) {
            return this._SessionPersistentStorePool;
        }
        if (string.equals("SessionPersistentStoreShared")) {
            return new Boolean(this._SessionPersistentStoreShared);
        }
        if (string.equals("SessionPersistentStoreTable")) {
            return this._SessionPersistentStoreTable;
        }
        if (string.equals("SessionPersistentStoreType")) {
            return this._SessionPersistentStoreType;
        }
        if (string.equals("SessionSwapIntervalSecs")) {
            return new Integer(this._SessionSwapIntervalSecs);
        }
        if (string.equals("SessionTimeoutSecs")) {
            return new Integer(this._SessionTimeoutSecs);
        }
        if (string.equals("SessionTrackingEnabled")) {
            return new Boolean(this._SessionTrackingEnabled);
        }
        if (string.equals("SessionURLRewritingEnabled")) {
            return new Boolean(this._SessionURLRewritingEnabled);
        }
        if (string.equals("SingleThreadedServletPoolSize")) {
            return new Integer(this._SingleThreadedServletPoolSize);
        }
        if (string.equals("Targets")) {
            return this._Targets;
        }
        if (string.equals("VirtualHosts")) {
            return this._VirtualHosts;
        }
        if (string.equals("WebServers")) {
            return this._WebServers;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ComponentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 16: {
                    if (string.equals("activated-target")) {
                        return 11;
                    }
                    if (!string.equals("sessionid-length")) break;
                    return 34;
                }
                case 11: {
                    if (string.equals("application")) {
                        return 9;
                    }
                    if (!string.equals("auth-filter")) break;
                    return 31;
                }
                case 15: {
                    if (string.equals("auth-realm-name")) {
                        return 30;
                    }
                    if (!string.equals("default-servlet")) break;
                    return 22;
                }
                case 12: {
                    if (string.equals("context-path")) {
                        return 51;
                    }
                    if (!string.equals("virtual-host")) break;
                    return 13;
                }
                case 21: {
                    if (string.equals("deployed-virtual-host")) {
                        return 14;
                    }
                    if (!string.equals("session-cookie-domain")) break;
                    return 39;
                }
                case 13: {
                    if (string.equals("document-root")) {
                        return 21;
                    }
                    if (!string.equals("debug-enabled")) break;
                    return 32;
                }
                case 10: {
                    if (string.equals("index-file")) {
                        return 24;
                    }
                    if (string.equals("mime-types")) {
                        return 20;
                    }
                    if (!string.equals("web-server")) break;
                    return 12;
                }
                case 17: {
                    if (string.equals("mime-type-default")) {
                        return 19;
                    }
                    if (!string.equals("servlet-classpath")) break;
                    return 25;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 25: {
                    if (!string.equals("servlet-reload-check-secs")) break;
                    return 27;
                }
                case 7: {
                    if (!string.equals("servlet")) break;
                    return 29;
                }
                case 18: {
                    if (string.equals("session-cache-size")) {
                        return 35;
                    }
                    if (!string.equals("session-debuggable")) break;
                    return 49;
                }
                case 22: {
                    if (string.equals("session-cookie-comment")) {
                        return 38;
                    }
                    if (string.equals("session-main-attribute")) {
                        return 52;
                    }
                    if (!string.equals("prefer-web-inf-classes")) break;
                    return 54;
                }
                case 27: {
                    if (!string.equals("session-cookie-max-age-secs")) break;
                    return 15;
                }
                case 19: {
                    if (string.equals("session-cookie-name")) {
                        return 40;
                    }
                    if (!string.equals("session-cookie-path")) break;
                    return 41;
                }
                case 34: {
                    if (!string.equals("session-invalidation-interval-secs")) break;
                    return 16;
                }
                case 36: {
                    if (string.equals("session-jdbc-connection-timeout-secs")) {
                        return 17;
                    }
                    if (!string.equals("session-persistent-store-cookie-name")) break;
                    return 47;
                }
                case 28: {
                    if (!string.equals("session-persistent-store-dir")) break;
                    return 42;
                }
                case 29: {
                    if (string.equals("session-persistent-store-pool")) {
                        return 43;
                    }
                    if (string.equals("session-persistent-store-type")) {
                        return 46;
                    }
                    if (string.equals("cleanup-session-files-enabled")) {
                        return 50;
                    }
                    if (!string.equals("session-url-rewriting-enabled")) break;
                    return 33;
                }
                case 30: {
                    if (!string.equals("session-persistent-store-table")) break;
                    return 44;
                }
                case 26: {
                    if (string.equals("session-swap-interval-secs")) {
                        return 48;
                    }
                    if (!string.equals("session-monitoring-enabled")) break;
                    return 53;
                }
                case 20: {
                    if (!string.equals("session-timeout-secs")) break;
                    return 18;
                }
                case 33: {
                    if (!string.equals("single-threaded-servlet-pool-size")) break;
                    return 28;
                }
                case 6: {
                    if (!string.equals("target")) break;
                    return 7;
                }
                case 23: {
                    if (string.equals("index-directory-enabled")) {
                        return 23;
                    }
                    if (!string.equals("session-cookies-enabled")) break;
                    return 36;
                }
                case 32: {
                    if (!string.equals("servlet-extension-case-sensitive")) break;
                    return 26;
                }
                case 31: {
                    if (!string.equals("session-persistent-store-shared")) break;
                    return 45;
                }
                case 24: {
                    if (!string.equals("session-tracking-enabled")) break;
                    return 37;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 11: {
                    return "activated-target";
                }
                case 9: {
                    return "application";
                }
                case 31: {
                    return "auth-filter";
                }
                case 30: {
                    return "auth-realm-name";
                }
                case 51: {
                    return "context-path";
                }
                case 22: {
                    return "default-servlet";
                }
                case 14: {
                    return "deployed-virtual-host";
                }
                case 21: {
                    return "document-root";
                }
                case 24: {
                    return "index-file";
                }
                case 19: {
                    return "mime-type-default";
                }
                case 20: {
                    return "mime-types";
                }
                case 2: {
                    return "name";
                }
                case 25: {
                    return "servlet-classpath";
                }
                case 27: {
                    return "servlet-reload-check-secs";
                }
                case 29: {
                    return "servlet";
                }
                case 35: {
                    return "session-cache-size";
                }
                case 38: {
                    return "session-cookie-comment";
                }
                case 39: {
                    return "session-cookie-domain";
                }
                case 15: {
                    return "session-cookie-max-age-secs";
                }
                case 40: {
                    return "session-cookie-name";
                }
                case 41: {
                    return "session-cookie-path";
                }
                case 34: {
                    return "sessionid-length";
                }
                case 16: {
                    return "session-invalidation-interval-secs";
                }
                case 17: {
                    return "session-jdbc-connection-timeout-secs";
                }
                case 52: {
                    return "session-main-attribute";
                }
                case 47: {
                    return "session-persistent-store-cookie-name";
                }
                case 42: {
                    return "session-persistent-store-dir";
                }
                case 43: {
                    return "session-persistent-store-pool";
                }
                case 44: {
                    return "session-persistent-store-table";
                }
                case 46: {
                    return "session-persistent-store-type";
                }
                case 48: {
                    return "session-swap-interval-secs";
                }
                case 18: {
                    return "session-timeout-secs";
                }
                case 28: {
                    return "single-threaded-servlet-pool-size";
                }
                case 7: {
                    return "target";
                }
                case 13: {
                    return "virtual-host";
                }
                case 12: {
                    return "web-server";
                }
                case 50: {
                    return "cleanup-session-files-enabled";
                }
                case 32: {
                    return "debug-enabled";
                }
                case 23: {
                    return "index-directory-enabled";
                }
                case 54: {
                    return "prefer-web-inf-classes";
                }
                case 26: {
                    return "servlet-extension-case-sensitive";
                }
                case 36: {
                    return "session-cookies-enabled";
                }
                case 49: {
                    return "session-debuggable";
                }
                case 53: {
                    return "session-monitoring-enabled";
                }
                case 45: {
                    return "session-persistent-store-shared";
                }
                case 37: {
                    return "session-tracking-enabled";
                }
                case 33: {
                    return "session-url-rewriting-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 11: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 24: {
                    return true;
                }
                case 29: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 12: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ComponentMBeanImpl.Helper {
        private WebAppComponentMBeanImpl bean;

        protected Helper(WebAppComponentMBeanImpl webAppComponentMBeanImpl) {
            super(webAppComponentMBeanImpl);
            this.bean = webAppComponentMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 11: {
                    return "ActivatedTargets";
                }
                case 9: {
                    return "Application";
                }
                case 31: {
                    return "AuthFilter";
                }
                case 30: {
                    return "AuthRealmName";
                }
                case 51: {
                    return "ContextPath";
                }
                case 22: {
                    return "DefaultServlet";
                }
                case 14: {
                    return "DeployedVirtualHosts";
                }
                case 21: {
                    return "DocumentRoot";
                }
                case 24: {
                    return "IndexFiles";
                }
                case 19: {
                    return "MimeTypeDefault";
                }
                case 20: {
                    return "MimeTypes";
                }
                case 2: {
                    return "Name";
                }
                case 25: {
                    return "ServletClasspath";
                }
                case 27: {
                    return "ServletReloadCheckSecs";
                }
                case 29: {
                    return "Servlets";
                }
                case 35: {
                    return "SessionCacheSize";
                }
                case 38: {
                    return "SessionCookieComment";
                }
                case 39: {
                    return "SessionCookieDomain";
                }
                case 15: {
                    return "SessionCookieMaxAgeSecs";
                }
                case 40: {
                    return "SessionCookieName";
                }
                case 41: {
                    return "SessionCookiePath";
                }
                case 34: {
                    return "SessionIDLength";
                }
                case 16: {
                    return "SessionInvalidationIntervalSecs";
                }
                case 17: {
                    return "SessionJDBCConnectionTimeoutSecs";
                }
                case 52: {
                    return "SessionMainAttribute";
                }
                case 47: {
                    return "SessionPersistentStoreCookieName";
                }
                case 42: {
                    return "SessionPersistentStoreDir";
                }
                case 43: {
                    return "SessionPersistentStorePool";
                }
                case 44: {
                    return "SessionPersistentStoreTable";
                }
                case 46: {
                    return "SessionPersistentStoreType";
                }
                case 48: {
                    return "SessionSwapIntervalSecs";
                }
                case 18: {
                    return "SessionTimeoutSecs";
                }
                case 28: {
                    return "SingleThreadedServletPoolSize";
                }
                case 7: {
                    return "Targets";
                }
                case 13: {
                    return "VirtualHosts";
                }
                case 12: {
                    return "WebServers";
                }
                case 50: {
                    return "CleanupSessionFilesEnabled";
                }
                case 32: {
                    return "DebugEnabled";
                }
                case 23: {
                    return "IndexDirectoryEnabled";
                }
                case 54: {
                    return "PreferWebInfClasses";
                }
                case 26: {
                    return "ServletExtensionCaseSensitive";
                }
                case 36: {
                    return "SessionCookiesEnabled";
                }
                case 49: {
                    return "SessionDebuggable";
                }
                case 53: {
                    return "SessionMonitoringEnabled";
                }
                case 45: {
                    return "SessionPersistentStoreShared";
                }
                case 37: {
                    return "SessionTrackingEnabled";
                }
                case 33: {
                    return "SessionURLRewritingEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("ActivatedTargets")) {
                return 11;
            }
            if (string.equals("Application")) {
                return 9;
            }
            if (string.equals("AuthFilter")) {
                return 31;
            }
            if (string.equals("AuthRealmName")) {
                return 30;
            }
            if (string.equals("ContextPath")) {
                return 51;
            }
            if (string.equals("DefaultServlet")) {
                return 22;
            }
            if (string.equals("DeployedVirtualHosts")) {
                return 14;
            }
            if (string.equals("DocumentRoot")) {
                return 21;
            }
            if (string.equals("IndexFiles")) {
                return 24;
            }
            if (string.equals("MimeTypeDefault")) {
                return 19;
            }
            if (string.equals("MimeTypes")) {
                return 20;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("ServletClasspath")) {
                return 25;
            }
            if (string.equals("ServletReloadCheckSecs")) {
                return 27;
            }
            if (string.equals("Servlets")) {
                return 29;
            }
            if (string.equals("SessionCacheSize")) {
                return 35;
            }
            if (string.equals("SessionCookieComment")) {
                return 38;
            }
            if (string.equals("SessionCookieDomain")) {
                return 39;
            }
            if (string.equals("SessionCookieMaxAgeSecs")) {
                return 15;
            }
            if (string.equals("SessionCookieName")) {
                return 40;
            }
            if (string.equals("SessionCookiePath")) {
                return 41;
            }
            if (string.equals("SessionIDLength")) {
                return 34;
            }
            if (string.equals("SessionInvalidationIntervalSecs")) {
                return 16;
            }
            if (string.equals("SessionJDBCConnectionTimeoutSecs")) {
                return 17;
            }
            if (string.equals("SessionMainAttribute")) {
                return 52;
            }
            if (string.equals("SessionPersistentStoreCookieName")) {
                return 47;
            }
            if (string.equals("SessionPersistentStoreDir")) {
                return 42;
            }
            if (string.equals("SessionPersistentStorePool")) {
                return 43;
            }
            if (string.equals("SessionPersistentStoreTable")) {
                return 44;
            }
            if (string.equals("SessionPersistentStoreType")) {
                return 46;
            }
            if (string.equals("SessionSwapIntervalSecs")) {
                return 48;
            }
            if (string.equals("SessionTimeoutSecs")) {
                return 18;
            }
            if (string.equals("SingleThreadedServletPoolSize")) {
                return 28;
            }
            if (string.equals("Targets")) {
                return 7;
            }
            if (string.equals("VirtualHosts")) {
                return 13;
            }
            if (string.equals("WebServers")) {
                return 12;
            }
            if (string.equals("CleanupSessionFilesEnabled")) {
                return 50;
            }
            if (string.equals("DebugEnabled")) {
                return 32;
            }
            if (string.equals("IndexDirectoryEnabled")) {
                return 23;
            }
            if (string.equals("PreferWebInfClasses")) {
                return 54;
            }
            if (string.equals("ServletExtensionCaseSensitive")) {
                return 26;
            }
            if (string.equals("SessionCookiesEnabled")) {
                return 36;
            }
            if (string.equals("SessionDebuggable")) {
                return 49;
            }
            if (string.equals("SessionMonitoringEnabled")) {
                return 53;
            }
            if (string.equals("SessionPersistentStoreShared")) {
                return 45;
            }
            if (string.equals("SessionTrackingEnabled")) {
                return 37;
            }
            if (string.equals("SessionURLRewritingEnabled")) {
                return 33;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isActivatedTargetsSet()) {
                    stringBuffer.append("ActivatedTargets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getActivatedTargets())));
                }
                if (this.bean.isApplicationSet()) {
                    stringBuffer.append("Application");
                    stringBuffer.append(String.valueOf(this.bean.getApplication()));
                }
                if (this.bean.isAuthFilterSet()) {
                    stringBuffer.append("AuthFilter");
                    stringBuffer.append(String.valueOf(this.bean.getAuthFilter()));
                }
                if (this.bean.isAuthRealmNameSet()) {
                    stringBuffer.append("AuthRealmName");
                    stringBuffer.append(String.valueOf(this.bean.getAuthRealmName()));
                }
                if (this.bean.isContextPathSet()) {
                    stringBuffer.append("ContextPath");
                    stringBuffer.append(String.valueOf(this.bean.getContextPath()));
                }
                if (this.bean.isDefaultServletSet()) {
                    stringBuffer.append("DefaultServlet");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultServlet()));
                }
                if (this.bean.isDeployedVirtualHostsSet()) {
                    stringBuffer.append("DeployedVirtualHosts");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getDeployedVirtualHosts())));
                }
                if (this.bean.isDocumentRootSet()) {
                    stringBuffer.append("DocumentRoot");
                    stringBuffer.append(String.valueOf(this.bean.getDocumentRoot()));
                }
                if (this.bean.isIndexFilesSet()) {
                    stringBuffer.append("IndexFiles");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getIndexFiles())));
                }
                if (this.bean.isMimeTypeDefaultSet()) {
                    stringBuffer.append("MimeTypeDefault");
                    stringBuffer.append(String.valueOf(this.bean.getMimeTypeDefault()));
                }
                if (this.bean.isMimeTypesSet()) {
                    stringBuffer.append("MimeTypes");
                    stringBuffer.append(String.valueOf(this.bean.getMimeTypes()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isServletClasspathSet()) {
                    stringBuffer.append("ServletClasspath");
                    stringBuffer.append(String.valueOf(this.bean.getServletClasspath()));
                }
                if (this.bean.isServletReloadCheckSecsSet()) {
                    stringBuffer.append("ServletReloadCheckSecs");
                    stringBuffer.append(String.valueOf(this.bean.getServletReloadCheckSecs()));
                }
                if (this.bean.isServletsSet()) {
                    stringBuffer.append("Servlets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getServlets())));
                }
                if (this.bean.isSessionCacheSizeSet()) {
                    stringBuffer.append("SessionCacheSize");
                    stringBuffer.append(String.valueOf(this.bean.getSessionCacheSize()));
                }
                if (this.bean.isSessionCookieCommentSet()) {
                    stringBuffer.append("SessionCookieComment");
                    stringBuffer.append(String.valueOf(this.bean.getSessionCookieComment()));
                }
                if (this.bean.isSessionCookieDomainSet()) {
                    stringBuffer.append("SessionCookieDomain");
                    stringBuffer.append(String.valueOf(this.bean.getSessionCookieDomain()));
                }
                if (this.bean.isSessionCookieMaxAgeSecsSet()) {
                    stringBuffer.append("SessionCookieMaxAgeSecs");
                    stringBuffer.append(String.valueOf(this.bean.getSessionCookieMaxAgeSecs()));
                }
                if (this.bean.isSessionCookieNameSet()) {
                    stringBuffer.append("SessionCookieName");
                    stringBuffer.append(String.valueOf(this.bean.getSessionCookieName()));
                }
                if (this.bean.isSessionCookiePathSet()) {
                    stringBuffer.append("SessionCookiePath");
                    stringBuffer.append(String.valueOf(this.bean.getSessionCookiePath()));
                }
                if (this.bean.isSessionIDLengthSet()) {
                    stringBuffer.append("SessionIDLength");
                    stringBuffer.append(String.valueOf(this.bean.getSessionIDLength()));
                }
                if (this.bean.isSessionInvalidationIntervalSecsSet()) {
                    stringBuffer.append("SessionInvalidationIntervalSecs");
                    stringBuffer.append(String.valueOf(this.bean.getSessionInvalidationIntervalSecs()));
                }
                if (this.bean.isSessionJDBCConnectionTimeoutSecsSet()) {
                    stringBuffer.append("SessionJDBCConnectionTimeoutSecs");
                    stringBuffer.append(String.valueOf(this.bean.getSessionJDBCConnectionTimeoutSecs()));
                }
                if (this.bean.isSessionMainAttributeSet()) {
                    stringBuffer.append("SessionMainAttribute");
                    stringBuffer.append(String.valueOf(this.bean.getSessionMainAttribute()));
                }
                if (this.bean.isSessionPersistentStoreCookieNameSet()) {
                    stringBuffer.append("SessionPersistentStoreCookieName");
                    stringBuffer.append(String.valueOf(this.bean.getSessionPersistentStoreCookieName()));
                }
                if (this.bean.isSessionPersistentStoreDirSet()) {
                    stringBuffer.append("SessionPersistentStoreDir");
                    stringBuffer.append(String.valueOf(this.bean.getSessionPersistentStoreDir()));
                }
                if (this.bean.isSessionPersistentStorePoolSet()) {
                    stringBuffer.append("SessionPersistentStorePool");
                    stringBuffer.append(String.valueOf(this.bean.getSessionPersistentStorePool()));
                }
                if (this.bean.isSessionPersistentStoreTableSet()) {
                    stringBuffer.append("SessionPersistentStoreTable");
                    stringBuffer.append(String.valueOf(this.bean.getSessionPersistentStoreTable()));
                }
                if (this.bean.isSessionPersistentStoreTypeSet()) {
                    stringBuffer.append("SessionPersistentStoreType");
                    stringBuffer.append(String.valueOf(this.bean.getSessionPersistentStoreType()));
                }
                if (this.bean.isSessionSwapIntervalSecsSet()) {
                    stringBuffer.append("SessionSwapIntervalSecs");
                    stringBuffer.append(String.valueOf(this.bean.getSessionSwapIntervalSecs()));
                }
                if (this.bean.isSessionTimeoutSecsSet()) {
                    stringBuffer.append("SessionTimeoutSecs");
                    stringBuffer.append(String.valueOf(this.bean.getSessionTimeoutSecs()));
                }
                if (this.bean.isSingleThreadedServletPoolSizeSet()) {
                    stringBuffer.append("SingleThreadedServletPoolSize");
                    stringBuffer.append(String.valueOf(this.bean.getSingleThreadedServletPoolSize()));
                }
                if (this.bean.isTargetsSet()) {
                    stringBuffer.append("Targets");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getTargets())));
                }
                if (this.bean.isVirtualHostsSet()) {
                    stringBuffer.append("VirtualHosts");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getVirtualHosts())));
                }
                if (this.bean.isWebServersSet()) {
                    stringBuffer.append("WebServers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getWebServers())));
                }
                if (this.bean.isCleanupSessionFilesEnabledSet()) {
                    stringBuffer.append("CleanupSessionFilesEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isCleanupSessionFilesEnabled()));
                }
                if (this.bean.isDebugEnabledSet()) {
                    stringBuffer.append("DebugEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDebugEnabled()));
                }
                if (this.bean.isIndexDirectoryEnabledSet()) {
                    stringBuffer.append("IndexDirectoryEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isIndexDirectoryEnabled()));
                }
                if (this.bean.isPreferWebInfClassesSet()) {
                    stringBuffer.append("PreferWebInfClasses");
                    stringBuffer.append(String.valueOf(this.bean.isPreferWebInfClasses()));
                }
                if (this.bean.isServletExtensionCaseSensitiveSet()) {
                    stringBuffer.append("ServletExtensionCaseSensitive");
                    stringBuffer.append(String.valueOf(this.bean.isServletExtensionCaseSensitive()));
                }
                if (this.bean.isSessionCookiesEnabledSet()) {
                    stringBuffer.append("SessionCookiesEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSessionCookiesEnabled()));
                }
                if (this.bean.isSessionDebuggableSet()) {
                    stringBuffer.append("SessionDebuggable");
                    stringBuffer.append(String.valueOf(this.bean.isSessionDebuggable()));
                }
                if (this.bean.isSessionMonitoringEnabledSet()) {
                    stringBuffer.append("SessionMonitoringEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSessionMonitoringEnabled()));
                }
                if (this.bean.isSessionPersistentStoreSharedSet()) {
                    stringBuffer.append("SessionPersistentStoreShared");
                    stringBuffer.append(String.valueOf(this.bean.isSessionPersistentStoreShared()));
                }
                if (this.bean.isSessionTrackingEnabledSet()) {
                    stringBuffer.append("SessionTrackingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSessionTrackingEnabled()));
                }
                if (this.bean.isSessionURLRewritingEnabledSet()) {
                    stringBuffer.append("SessionURLRewritingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSessionURLRewritingEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WebAppComponentMBeanImpl webAppComponentMBeanImpl = (WebAppComponentMBeanImpl)abstractDescriptorBean;
                this.computeDiff("AuthFilter", this.bean.getAuthFilter(), webAppComponentMBeanImpl.getAuthFilter(), false);
                this.computeDiff("AuthRealmName", this.bean.getAuthRealmName(), webAppComponentMBeanImpl.getAuthRealmName(), false);
                this.computeDiff("Name", this.bean.getName(), webAppComponentMBeanImpl.getName(), false);
                this.computeDiff("ServletReloadCheckSecs", this.bean.getServletReloadCheckSecs(), webAppComponentMBeanImpl.getServletReloadCheckSecs(), false);
                this.computeDiff("SingleThreadedServletPoolSize", this.bean.getSingleThreadedServletPoolSize(), webAppComponentMBeanImpl.getSingleThreadedServletPoolSize(), false);
                this.computeDiff("Targets", this.bean.getTargets(), webAppComponentMBeanImpl.getTargets(), true);
                this.computeDiff("VirtualHosts", this.bean.getVirtualHosts(), webAppComponentMBeanImpl.getVirtualHosts(), true);
                this.computeDiff("IndexDirectoryEnabled", this.bean.isIndexDirectoryEnabled(), webAppComponentMBeanImpl.isIndexDirectoryEnabled(), false);
                this.computeDiff("PreferWebInfClasses", this.bean.isPreferWebInfClasses(), webAppComponentMBeanImpl.isPreferWebInfClasses(), false);
                this.computeDiff("SessionMonitoringEnabled", this.bean.isSessionMonitoringEnabled(), webAppComponentMBeanImpl.isSessionMonitoringEnabled(), false);
                this.computeDiff("SessionURLRewritingEnabled", this.bean.isSessionURLRewritingEnabled(), webAppComponentMBeanImpl.isSessionURLRewritingEnabled(), false);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WebAppComponentMBeanImpl webAppComponentMBeanImpl = (WebAppComponentMBeanImpl)beanUpdateEvent.getSourceBean();
                WebAppComponentMBeanImpl webAppComponentMBeanImpl2 = (WebAppComponentMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("ActivatedTargets") && !string.equals("Application")) {
                    if (string.equals("AuthFilter")) {
                        webAppComponentMBeanImpl.setAuthFilter(webAppComponentMBeanImpl2.getAuthFilter());
                        webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                    } else if (string.equals("AuthRealmName")) {
                        webAppComponentMBeanImpl.setAuthRealmName(webAppComponentMBeanImpl2.getAuthRealmName());
                        webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                    } else if (!(string.equals("ContextPath") || string.equals("DefaultServlet") || string.equals("DeployedVirtualHosts") || string.equals("DocumentRoot") || string.equals("IndexFiles") || string.equals("MimeTypeDefault") || string.equals("MimeTypes"))) {
                        if (string.equals("Name")) {
                            webAppComponentMBeanImpl.setName(webAppComponentMBeanImpl2.getName());
                            webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                        } else if (!string.equals("ServletClasspath")) {
                            if (string.equals("ServletReloadCheckSecs")) {
                                webAppComponentMBeanImpl.setServletReloadCheckSecs(webAppComponentMBeanImpl2.getServletReloadCheckSecs());
                                webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                            } else if (!(string.equals("Servlets") || string.equals("SessionCacheSize") || string.equals("SessionCookieComment") || string.equals("SessionCookieDomain") || string.equals("SessionCookieMaxAgeSecs") || string.equals("SessionCookieName") || string.equals("SessionCookiePath") || string.equals("SessionIDLength") || string.equals("SessionInvalidationIntervalSecs") || string.equals("SessionJDBCConnectionTimeoutSecs") || string.equals("SessionMainAttribute") || string.equals("SessionPersistentStoreCookieName") || string.equals("SessionPersistentStoreDir") || string.equals("SessionPersistentStorePool") || string.equals("SessionPersistentStoreTable") || string.equals("SessionPersistentStoreType") || string.equals("SessionSwapIntervalSecs") || string.equals("SessionTimeoutSecs"))) {
                                if (string.equals("SingleThreadedServletPoolSize")) {
                                    webAppComponentMBeanImpl.setSingleThreadedServletPoolSize(webAppComponentMBeanImpl2.getSingleThreadedServletPoolSize());
                                    webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                                } else if (string.equals("Targets")) {
                                    webAppComponentMBeanImpl.setTargetsAsString(webAppComponentMBeanImpl2.getTargetsAsString());
                                    webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                                } else if (string.equals("VirtualHosts")) {
                                    webAppComponentMBeanImpl.setVirtualHostsAsString(webAppComponentMBeanImpl2.getVirtualHostsAsString());
                                    webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                                } else if (!(string.equals("WebServers") || string.equals("CleanupSessionFilesEnabled") || string.equals("DebugEnabled"))) {
                                    if (string.equals("IndexDirectoryEnabled")) {
                                        webAppComponentMBeanImpl.setIndexDirectoryEnabled(webAppComponentMBeanImpl2.isIndexDirectoryEnabled());
                                        webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                                    } else if (string.equals("PreferWebInfClasses")) {
                                        webAppComponentMBeanImpl.setPreferWebInfClasses(webAppComponentMBeanImpl2.isPreferWebInfClasses());
                                        webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 54);
                                    } else if (!(string.equals("ServletExtensionCaseSensitive") || string.equals("SessionCookiesEnabled") || string.equals("SessionDebuggable"))) {
                                        if (string.equals("SessionMonitoringEnabled")) {
                                            webAppComponentMBeanImpl.setSessionMonitoringEnabled(webAppComponentMBeanImpl2.isSessionMonitoringEnabled());
                                            webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 53);
                                        } else if (!string.equals("SessionPersistentStoreShared") && !string.equals("SessionTrackingEnabled")) {
                                            if (string.equals("SessionURLRewritingEnabled")) {
                                                webAppComponentMBeanImpl.setSessionURLRewritingEnabled(webAppComponentMBeanImpl2.isSessionURLRewritingEnabled());
                                                webAppComponentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                                            } else {
                                                super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                WebAppComponentMBeanImpl webAppComponentMBeanImpl = (WebAppComponentMBeanImpl)abstractDescriptorBean;
                super.finishCopy(webAppComponentMBeanImpl, bl, list);
                if ((list == null || !list.contains("AuthFilter")) && this.bean.isAuthFilterSet()) {
                    webAppComponentMBeanImpl.setAuthFilter(this.bean.getAuthFilter());
                }
                if ((list == null || !list.contains("AuthRealmName")) && this.bean.isAuthRealmNameSet()) {
                    webAppComponentMBeanImpl.setAuthRealmName(this.bean.getAuthRealmName());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    webAppComponentMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("ServletReloadCheckSecs")) && this.bean.isServletReloadCheckSecsSet()) {
                    webAppComponentMBeanImpl.setServletReloadCheckSecs(this.bean.getServletReloadCheckSecs());
                }
                if ((list == null || !list.contains("SingleThreadedServletPoolSize")) && this.bean.isSingleThreadedServletPoolSizeSet()) {
                    webAppComponentMBeanImpl.setSingleThreadedServletPoolSize(this.bean.getSingleThreadedServletPoolSize());
                }
                if ((list == null || !list.contains("Targets")) && this.bean.isTargetsSet()) {
                    webAppComponentMBeanImpl._unSet(webAppComponentMBeanImpl, 7);
                    webAppComponentMBeanImpl.setTargetsAsString(this.bean.getTargetsAsString());
                }
                if ((list == null || !list.contains("VirtualHosts")) && this.bean.isVirtualHostsSet()) {
                    webAppComponentMBeanImpl._unSet(webAppComponentMBeanImpl, 13);
                    webAppComponentMBeanImpl.setVirtualHostsAsString(this.bean.getVirtualHostsAsString());
                }
                if ((list == null || !list.contains("IndexDirectoryEnabled")) && this.bean.isIndexDirectoryEnabledSet()) {
                    webAppComponentMBeanImpl.setIndexDirectoryEnabled(this.bean.isIndexDirectoryEnabled());
                }
                if ((list == null || !list.contains("PreferWebInfClasses")) && this.bean.isPreferWebInfClassesSet()) {
                    webAppComponentMBeanImpl.setPreferWebInfClasses(this.bean.isPreferWebInfClasses());
                }
                if ((list == null || !list.contains("SessionMonitoringEnabled")) && this.bean.isSessionMonitoringEnabledSet()) {
                    webAppComponentMBeanImpl.setSessionMonitoringEnabled(this.bean.isSessionMonitoringEnabled());
                }
                if ((list == null || !list.contains("SessionURLRewritingEnabled")) && this.bean.isSessionURLRewritingEnabledSet()) {
                    webAppComponentMBeanImpl.setSessionURLRewritingEnabled(this.bean.isSessionURLRewritingEnabled());
                }
                return webAppComponentMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getActivatedTargets(), clazz, object);
            this.inferSubTree(this.bean.getApplication(), clazz, object);
            this.inferSubTree(this.bean.getDeployedVirtualHosts(), clazz, object);
            this.inferSubTree(this.bean.getTargets(), clazz, object);
            this.inferSubTree(this.bean.getVirtualHosts(), clazz, object);
            this.inferSubTree(this.bean.getWebServers(), clazz, object);
        }
    }
}

