/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.WebAppContainerMBean;
import weblogic.utils.collections.CombinedIterator;

public class WebAppContainerMBeanImpl
extends ConfigurationMBeanImpl
implements WebAppContainerMBean,
Serializable {
    private boolean _AllowAllRoles;
    private boolean _AuthCookieEnabled;
    private boolean _ChangeSessionIDOnAuthentication;
    private boolean _ClientCertProxyEnabled;
    private boolean _FilterDispatchedRequestsEnabled;
    private boolean _HttpTraceSupportEnabled;
    private boolean _JSPCompilerBackwardsCompatible;
    private int _MaxPostSize;
    private int _MaxPostTimeSecs;
    private String _MimeMappingFile;
    private boolean _OptimisticSerialization;
    private boolean _OverloadProtectionEnabled;
    private String _P3PHeaderValue;
    private int _PostTimeoutSecs;
    private boolean _ReloginEnabled;
    private boolean _RetainOriginalURL;
    private boolean _RtexprvalueJspParamName;
    private boolean _ServletAuthenticationFormURL;
    private int _ServletReloadCheckSecs;
    private boolean _ShowArchivedRealPathEnabled;
    private boolean _WAPEnabled;
    private boolean _WeblogicPluginEnabled;
    private boolean _WorkContextPropagationEnabled;
    private String _XPoweredByHeaderLevel;
    private static SchemaHelper2 _schemaHelper;

    public WebAppContainerMBeanImpl() {
        this._initializeProperty(-1);
    }

    public WebAppContainerMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public boolean isReloginEnabled() {
        return this._ReloginEnabled;
    }

    public boolean isReloginEnabledSet() {
        return this._isSet(7);
    }

    public void setReloginEnabled(boolean bl) {
        boolean bl2 = this._ReloginEnabled;
        this._ReloginEnabled = bl;
        this._postSet(7, bl2, bl);
    }

    public boolean isAllowAllRoles() {
        return this._AllowAllRoles;
    }

    public boolean isAllowAllRolesSet() {
        return this._isSet(8);
    }

    public void setAllowAllRoles(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._AllowAllRoles;
        this._AllowAllRoles = bl;
        this._postSet(8, bl2, bl);
    }

    public boolean isFilterDispatchedRequestsEnabled() {
        return this._FilterDispatchedRequestsEnabled;
    }

    public boolean isFilterDispatchedRequestsEnabledSet() {
        return this._isSet(9);
    }

    public void setFilterDispatchedRequestsEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this._FilterDispatchedRequestsEnabled;
        this._FilterDispatchedRequestsEnabled = bl;
        this._postSet(9, bl2, bl);
    }

    public boolean isOverloadProtectionEnabled() {
        return this._OverloadProtectionEnabled;
    }

    public boolean isOverloadProtectionEnabledSet() {
        return this._isSet(10);
    }

    public void setOverloadProtectionEnabled(boolean bl) {
        boolean bl2 = this._OverloadProtectionEnabled;
        this._OverloadProtectionEnabled = bl;
        this._postSet(10, bl2, bl);
    }

    public String getXPoweredByHeaderLevel() {
        return this._XPoweredByHeaderLevel;
    }

    public boolean isXPoweredByHeaderLevelSet() {
        return this._isSet(11);
    }

    public void setXPoweredByHeaderLevel(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"NONE", "SHORT", "MEDIUM", "FULL"};
        string = LegalChecks.checkInEnum((String)"XPoweredByHeaderLevel", (String)string, (String[])stringArray);
        String string2 = this._XPoweredByHeaderLevel;
        this._XPoweredByHeaderLevel = string;
        this._postSet(11, string2, string);
    }

    public String getMimeMappingFile() {
        return this._MimeMappingFile;
    }

    public boolean isMimeMappingFileSet() {
        return this._isSet(12);
    }

    public void setMimeMappingFile(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._MimeMappingFile;
        this._MimeMappingFile = string;
        this._postSet(12, string2, string);
    }

    public boolean isOptimisticSerialization() {
        return this._OptimisticSerialization;
    }

    public boolean isOptimisticSerializationSet() {
        return this._isSet(13);
    }

    public void setOptimisticSerialization(boolean bl) {
        boolean bl2 = this._OptimisticSerialization;
        this._OptimisticSerialization = bl;
        this._postSet(13, bl2, bl);
    }

    public boolean isRetainOriginalURL() {
        return this._RetainOriginalURL;
    }

    public boolean isRetainOriginalURLSet() {
        return this._isSet(14);
    }

    public void setRetainOriginalURL(boolean bl) {
        boolean bl2 = this._RetainOriginalURL;
        this._RetainOriginalURL = bl;
        this._postSet(14, bl2, bl);
    }

    public boolean isServletAuthenticationFormURL() {
        return this._ServletAuthenticationFormURL;
    }

    public boolean isServletAuthenticationFormURLSet() {
        return this._isSet(15);
    }

    public void setServletAuthenticationFormURL(boolean bl) {
        boolean bl2 = this._ServletAuthenticationFormURL;
        this._ServletAuthenticationFormURL = bl;
        this._postSet(15, bl2, bl);
    }

    public boolean isRtexprvalueJspParamName() {
        return this._RtexprvalueJspParamName;
    }

    public boolean isRtexprvalueJspParamNameSet() {
        return this._isSet(16);
    }

    public void setRtexprvalueJspParamName(boolean bl) {
        boolean bl2 = this._RtexprvalueJspParamName;
        this._RtexprvalueJspParamName = bl;
        this._postSet(16, bl2, bl);
    }

    public void setClientCertProxyEnabled(boolean bl) {
        boolean bl2 = this._ClientCertProxyEnabled;
        this._ClientCertProxyEnabled = bl;
        this._postSet(17, bl2, bl);
    }

    public boolean isClientCertProxyEnabled() {
        return this._ClientCertProxyEnabled;
    }

    public boolean isClientCertProxyEnabledSet() {
        return this._isSet(17);
    }

    public void setHttpTraceSupportEnabled(boolean bl) {
        boolean bl2 = this._HttpTraceSupportEnabled;
        this._HttpTraceSupportEnabled = bl;
        this._postSet(18, bl2, bl);
    }

    public boolean isHttpTraceSupportEnabled() {
        return this._HttpTraceSupportEnabled;
    }

    public boolean isHttpTraceSupportEnabledSet() {
        return this._isSet(18);
    }

    public void setWeblogicPluginEnabled(boolean bl) {
        boolean bl2 = this._WeblogicPluginEnabled;
        this._WeblogicPluginEnabled = bl;
        this._postSet(19, bl2, bl);
    }

    public boolean isWeblogicPluginEnabled() {
        return this._WeblogicPluginEnabled;
    }

    public boolean isWeblogicPluginEnabledSet() {
        return this._isSet(19);
    }

    public void setAuthCookieEnabled(boolean bl) {
        boolean bl2 = this._AuthCookieEnabled;
        this._AuthCookieEnabled = bl;
        this._postSet(20, bl2, bl);
    }

    public boolean isAuthCookieEnabled() {
        return this._AuthCookieEnabled;
    }

    public boolean isAuthCookieEnabledSet() {
        return this._isSet(20);
    }

    public void setWAPEnabled(boolean bl) {
        boolean bl2 = this._WAPEnabled;
        this._WAPEnabled = bl;
        this._postSet(21, bl2, bl);
    }

    public boolean isWAPEnabled() {
        return this._WAPEnabled;
    }

    public boolean isWAPEnabledSet() {
        return this._isSet(21);
    }

    public void setPostTimeoutSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"PostTimeoutSecs", (long)n, (long)0L, (long)120L);
        int n2 = this._PostTimeoutSecs;
        this._PostTimeoutSecs = n;
        this._postSet(22, n2, n);
    }

    public int getPostTimeoutSecs() {
        return this._PostTimeoutSecs;
    }

    public boolean isPostTimeoutSecsSet() {
        return this._isSet(22);
    }

    public void setMaxPostTimeSecs(int n) throws InvalidAttributeValueException {
        int n2 = this._MaxPostTimeSecs;
        this._MaxPostTimeSecs = n;
        this._postSet(23, n2, n);
    }

    public int getMaxPostTimeSecs() {
        return this._MaxPostTimeSecs;
    }

    public boolean isMaxPostTimeSecsSet() {
        return this._isSet(23);
    }

    public void setMaxPostSize(int n) throws InvalidAttributeValueException {
        int n2 = this._MaxPostSize;
        this._MaxPostSize = n;
        this._postSet(24, n2, n);
    }

    public int getMaxPostSize() {
        return this._MaxPostSize;
    }

    public boolean isMaxPostSizeSet() {
        return this._isSet(24);
    }

    public boolean isWorkContextPropagationEnabled() {
        return this._WorkContextPropagationEnabled;
    }

    public boolean isWorkContextPropagationEnabledSet() {
        return this._isSet(25);
    }

    public void setWorkContextPropagationEnabled(boolean bl) {
        boolean bl2 = this._WorkContextPropagationEnabled;
        this._WorkContextPropagationEnabled = bl;
        this._postSet(25, bl2, bl);
    }

    public void setP3PHeaderValue(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._P3PHeaderValue;
        this._P3PHeaderValue = string;
        this._postSet(26, string2, string);
    }

    public String getP3PHeaderValue() {
        return this._P3PHeaderValue;
    }

    public boolean isP3PHeaderValueSet() {
        return this._isSet(26);
    }

    public boolean isJSPCompilerBackwardsCompatible() {
        return this._JSPCompilerBackwardsCompatible;
    }

    public boolean isJSPCompilerBackwardsCompatibleSet() {
        return this._isSet(27);
    }

    public void setJSPCompilerBackwardsCompatible(boolean bl) {
        boolean bl2 = this._JSPCompilerBackwardsCompatible;
        this._JSPCompilerBackwardsCompatible = bl;
        this._postSet(27, bl2, bl);
    }

    public int getServletReloadCheckSecs() {
        if (!this._isSet(28)) {
            return this._isProductionModeEnabled() ? -1 : 1;
        }
        return this._ServletReloadCheckSecs;
    }

    public boolean isServletReloadCheckSecsSet() {
        return this._isSet(28);
    }

    public void setServletReloadCheckSecs(int n) {
        int n2 = this._ServletReloadCheckSecs;
        this._ServletReloadCheckSecs = n;
        this._postSet(28, n2, n);
    }

    public boolean isShowArchivedRealPathEnabled() {
        return this._ShowArchivedRealPathEnabled;
    }

    public boolean isShowArchivedRealPathEnabledSet() {
        return this._isSet(29);
    }

    public void setShowArchivedRealPathEnabled(boolean bl) {
        boolean bl2 = this._ShowArchivedRealPathEnabled;
        this._ShowArchivedRealPathEnabled = bl;
        this._postSet(29, bl2, bl);
    }

    public boolean isChangeSessionIDOnAuthentication() {
        return this._ChangeSessionIDOnAuthentication;
    }

    public boolean isChangeSessionIDOnAuthenticationSet() {
        return this._isSet(30);
    }

    public void setChangeSessionIDOnAuthentication(boolean bl) {
        boolean bl2 = this._ChangeSessionIDOnAuthentication;
        this._ChangeSessionIDOnAuthentication = bl;
        this._postSet(30, bl2, bl);
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 24;
        }
        try {
            switch (n) {
                case 24: {
                    this._MaxPostSize = -1;
                    if (bl) break;
                }
                case 23: {
                    this._MaxPostTimeSecs = -1;
                    if (bl) break;
                }
                case 12: {
                    this._MimeMappingFile = "./config/mimemappings.properties";
                    if (bl) break;
                }
                case 26: {
                    this._P3PHeaderValue = null;
                    if (bl) break;
                }
                case 22: {
                    this._PostTimeoutSecs = 30;
                    if (bl) break;
                }
                case 28: {
                    this._ServletReloadCheckSecs = 1;
                    if (bl) break;
                }
                case 11: {
                    this._XPoweredByHeaderLevel = "SHORT";
                    if (bl) break;
                }
                case 8: {
                    this._AllowAllRoles = false;
                    if (bl) break;
                }
                case 20: {
                    this._AuthCookieEnabled = true;
                    if (bl) break;
                }
                case 30: {
                    this._ChangeSessionIDOnAuthentication = true;
                    if (bl) break;
                }
                case 17: {
                    this._ClientCertProxyEnabled = false;
                    if (bl) break;
                }
                case 9: {
                    this._FilterDispatchedRequestsEnabled = false;
                    if (bl) break;
                }
                case 18: {
                    this._HttpTraceSupportEnabled = false;
                    if (bl) break;
                }
                case 27: {
                    this._JSPCompilerBackwardsCompatible = false;
                    if (bl) break;
                }
                case 13: {
                    this._OptimisticSerialization = false;
                    if (bl) break;
                }
                case 10: {
                    this._OverloadProtectionEnabled = false;
                    if (bl) break;
                }
                case 7: {
                    this._ReloginEnabled = false;
                    if (bl) break;
                }
                case 14: {
                    this._RetainOriginalURL = false;
                    if (bl) break;
                }
                case 16: {
                    this._RtexprvalueJspParamName = false;
                    if (bl) break;
                }
                case 15: {
                    this._ServletAuthenticationFormURL = true;
                    if (bl) break;
                }
                case 29: {
                    this._ShowArchivedRealPathEnabled = false;
                    if (bl) break;
                }
                case 21: {
                    this._WAPEnabled = false;
                    if (bl) break;
                }
                case 19: {
                    this._WeblogicPluginEnabled = false;
                    if (bl) break;
                }
                case 25: {
                    this._WorkContextPropagationEnabled = true;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "WebAppContainer";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AllowAllRoles")) {
            boolean bl = this._AllowAllRoles;
            this._AllowAllRoles = (Boolean)object;
            this._postSet(8, bl, this._AllowAllRoles);
            return;
        }
        if (string.equals("AuthCookieEnabled")) {
            boolean bl = this._AuthCookieEnabled;
            this._AuthCookieEnabled = (Boolean)object;
            this._postSet(20, bl, this._AuthCookieEnabled);
            return;
        }
        if (string.equals("ChangeSessionIDOnAuthentication")) {
            boolean bl = this._ChangeSessionIDOnAuthentication;
            this._ChangeSessionIDOnAuthentication = (Boolean)object;
            this._postSet(30, bl, this._ChangeSessionIDOnAuthentication);
            return;
        }
        if (string.equals("ClientCertProxyEnabled")) {
            boolean bl = this._ClientCertProxyEnabled;
            this._ClientCertProxyEnabled = (Boolean)object;
            this._postSet(17, bl, this._ClientCertProxyEnabled);
            return;
        }
        if (string.equals("FilterDispatchedRequestsEnabled")) {
            boolean bl = this._FilterDispatchedRequestsEnabled;
            this._FilterDispatchedRequestsEnabled = (Boolean)object;
            this._postSet(9, bl, this._FilterDispatchedRequestsEnabled);
            return;
        }
        if (string.equals("HttpTraceSupportEnabled")) {
            boolean bl = this._HttpTraceSupportEnabled;
            this._HttpTraceSupportEnabled = (Boolean)object;
            this._postSet(18, bl, this._HttpTraceSupportEnabled);
            return;
        }
        if (string.equals("JSPCompilerBackwardsCompatible")) {
            boolean bl = this._JSPCompilerBackwardsCompatible;
            this._JSPCompilerBackwardsCompatible = (Boolean)object;
            this._postSet(27, bl, this._JSPCompilerBackwardsCompatible);
            return;
        }
        if (string.equals("MaxPostSize")) {
            int n = this._MaxPostSize;
            this._MaxPostSize = (Integer)object;
            this._postSet(24, n, this._MaxPostSize);
            return;
        }
        if (string.equals("MaxPostTimeSecs")) {
            int n = this._MaxPostTimeSecs;
            this._MaxPostTimeSecs = (Integer)object;
            this._postSet(23, n, this._MaxPostTimeSecs);
            return;
        }
        if (string.equals("MimeMappingFile")) {
            String string2 = this._MimeMappingFile;
            this._MimeMappingFile = (String)object;
            this._postSet(12, string2, this._MimeMappingFile);
            return;
        }
        if (string.equals("OptimisticSerialization")) {
            boolean bl = this._OptimisticSerialization;
            this._OptimisticSerialization = (Boolean)object;
            this._postSet(13, bl, this._OptimisticSerialization);
            return;
        }
        if (string.equals("OverloadProtectionEnabled")) {
            boolean bl = this._OverloadProtectionEnabled;
            this._OverloadProtectionEnabled = (Boolean)object;
            this._postSet(10, bl, this._OverloadProtectionEnabled);
            return;
        }
        if (string.equals("P3PHeaderValue")) {
            String string3 = this._P3PHeaderValue;
            this._P3PHeaderValue = (String)object;
            this._postSet(26, string3, this._P3PHeaderValue);
            return;
        }
        if (string.equals("PostTimeoutSecs")) {
            int n = this._PostTimeoutSecs;
            this._PostTimeoutSecs = (Integer)object;
            this._postSet(22, n, this._PostTimeoutSecs);
            return;
        }
        if (string.equals("ReloginEnabled")) {
            boolean bl = this._ReloginEnabled;
            this._ReloginEnabled = (Boolean)object;
            this._postSet(7, bl, this._ReloginEnabled);
            return;
        }
        if (string.equals("RetainOriginalURL")) {
            boolean bl = this._RetainOriginalURL;
            this._RetainOriginalURL = (Boolean)object;
            this._postSet(14, bl, this._RetainOriginalURL);
            return;
        }
        if (string.equals("RtexprvalueJspParamName")) {
            boolean bl = this._RtexprvalueJspParamName;
            this._RtexprvalueJspParamName = (Boolean)object;
            this._postSet(16, bl, this._RtexprvalueJspParamName);
            return;
        }
        if (string.equals("ServletAuthenticationFormURL")) {
            boolean bl = this._ServletAuthenticationFormURL;
            this._ServletAuthenticationFormURL = (Boolean)object;
            this._postSet(15, bl, this._ServletAuthenticationFormURL);
            return;
        }
        if (string.equals("ServletReloadCheckSecs")) {
            int n = this._ServletReloadCheckSecs;
            this._ServletReloadCheckSecs = (Integer)object;
            this._postSet(28, n, this._ServletReloadCheckSecs);
            return;
        }
        if (string.equals("ShowArchivedRealPathEnabled")) {
            boolean bl = this._ShowArchivedRealPathEnabled;
            this._ShowArchivedRealPathEnabled = (Boolean)object;
            this._postSet(29, bl, this._ShowArchivedRealPathEnabled);
            return;
        }
        if (string.equals("WAPEnabled")) {
            boolean bl = this._WAPEnabled;
            this._WAPEnabled = (Boolean)object;
            this._postSet(21, bl, this._WAPEnabled);
            return;
        }
        if (string.equals("WeblogicPluginEnabled")) {
            boolean bl = this._WeblogicPluginEnabled;
            this._WeblogicPluginEnabled = (Boolean)object;
            this._postSet(19, bl, this._WeblogicPluginEnabled);
            return;
        }
        if (string.equals("WorkContextPropagationEnabled")) {
            boolean bl = this._WorkContextPropagationEnabled;
            this._WorkContextPropagationEnabled = (Boolean)object;
            this._postSet(25, bl, this._WorkContextPropagationEnabled);
            return;
        }
        if (string.equals("XPoweredByHeaderLevel")) {
            String string4 = this._XPoweredByHeaderLevel;
            this._XPoweredByHeaderLevel = (String)object;
            this._postSet(11, string4, this._XPoweredByHeaderLevel);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AllowAllRoles")) {
            return new Boolean(this._AllowAllRoles);
        }
        if (string.equals("AuthCookieEnabled")) {
            return new Boolean(this._AuthCookieEnabled);
        }
        if (string.equals("ChangeSessionIDOnAuthentication")) {
            return new Boolean(this._ChangeSessionIDOnAuthentication);
        }
        if (string.equals("ClientCertProxyEnabled")) {
            return new Boolean(this._ClientCertProxyEnabled);
        }
        if (string.equals("FilterDispatchedRequestsEnabled")) {
            return new Boolean(this._FilterDispatchedRequestsEnabled);
        }
        if (string.equals("HttpTraceSupportEnabled")) {
            return new Boolean(this._HttpTraceSupportEnabled);
        }
        if (string.equals("JSPCompilerBackwardsCompatible")) {
            return new Boolean(this._JSPCompilerBackwardsCompatible);
        }
        if (string.equals("MaxPostSize")) {
            return new Integer(this._MaxPostSize);
        }
        if (string.equals("MaxPostTimeSecs")) {
            return new Integer(this._MaxPostTimeSecs);
        }
        if (string.equals("MimeMappingFile")) {
            return this._MimeMappingFile;
        }
        if (string.equals("OptimisticSerialization")) {
            return new Boolean(this._OptimisticSerialization);
        }
        if (string.equals("OverloadProtectionEnabled")) {
            return new Boolean(this._OverloadProtectionEnabled);
        }
        if (string.equals("P3PHeaderValue")) {
            return this._P3PHeaderValue;
        }
        if (string.equals("PostTimeoutSecs")) {
            return new Integer(this._PostTimeoutSecs);
        }
        if (string.equals("ReloginEnabled")) {
            return new Boolean(this._ReloginEnabled);
        }
        if (string.equals("RetainOriginalURL")) {
            return new Boolean(this._RetainOriginalURL);
        }
        if (string.equals("RtexprvalueJspParamName")) {
            return new Boolean(this._RtexprvalueJspParamName);
        }
        if (string.equals("ServletAuthenticationFormURL")) {
            return new Boolean(this._ServletAuthenticationFormURL);
        }
        if (string.equals("ServletReloadCheckSecs")) {
            return new Integer(this._ServletReloadCheckSecs);
        }
        if (string.equals("ShowArchivedRealPathEnabled")) {
            return new Boolean(this._ShowArchivedRealPathEnabled);
        }
        if (string.equals("WAPEnabled")) {
            return new Boolean(this._WAPEnabled);
        }
        if (string.equals("WeblogicPluginEnabled")) {
            return new Boolean(this._WeblogicPluginEnabled);
        }
        if (string.equals("WorkContextPropagationEnabled")) {
            return new Boolean(this._WorkContextPropagationEnabled);
        }
        if (string.equals("XPoweredByHeaderLevel")) {
            return this._XPoweredByHeaderLevel;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 13: {
                    if (!string.equals("max-post-size")) break;
                    return 24;
                }
                case 18: {
                    if (!string.equals("max-post-time-secs")) break;
                    return 23;
                }
                case 17: {
                    if (string.equals("mime-mapping-file")) {
                        return 12;
                    }
                    if (!string.equals("post-timeout-secs")) break;
                    return 22;
                }
                case 16: {
                    if (!string.equals("p3p-header-value")) break;
                    return 26;
                }
                case 25: {
                    if (string.equals("servlet-reload-check-secs")) {
                        return 28;
                    }
                    if (string.equals("x-powered-by-header-level")) {
                        return 11;
                    }
                    if (!string.equals("client-cert-proxy-enabled")) break;
                    return 17;
                }
                case 15: {
                    if (string.equals("allow-all-roles")) {
                        return 8;
                    }
                    if (!string.equals("relogin-enabled")) break;
                    return 7;
                }
                case 19: {
                    if (string.equals("auth-cookie-enabled")) {
                        return 20;
                    }
                    if (!string.equals("retain-original-url")) break;
                    return 14;
                }
                case 34: {
                    if (string.equals("change-sessionid-on-authentication")) {
                        return 30;
                    }
                    if (!string.equals("filter-dispatched-requests-enabled")) break;
                    return 9;
                }
                case 26: {
                    if (string.equals("http-trace-support-enabled")) {
                        return 18;
                    }
                    if (!string.equals("rtexprvalue-jsp-param-name")) break;
                    return 16;
                }
                case 33: {
                    if (!string.equals("jsp-compiler-backwards-compatible")) break;
                    return 27;
                }
                case 24: {
                    if (!string.equals("optimistic-serialization")) break;
                    return 13;
                }
                case 27: {
                    if (!string.equals("overload-protection-enabled")) break;
                    return 10;
                }
                case 31: {
                    if (string.equals("servlet-authentication-form-url")) {
                        return 15;
                    }
                    if (!string.equals("show-archived-real-path-enabled")) break;
                    return 29;
                }
                case 11: {
                    if (!string.equals("wap-enabled")) break;
                    return 21;
                }
                case 23: {
                    if (!string.equals("weblogic-plugin-enabled")) break;
                    return 19;
                }
                case 32: {
                    if (!string.equals("work-context-propagation-enabled")) break;
                    return 25;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 24: {
                    return "max-post-size";
                }
                case 23: {
                    return "max-post-time-secs";
                }
                case 12: {
                    return "mime-mapping-file";
                }
                case 26: {
                    return "p3p-header-value";
                }
                case 22: {
                    return "post-timeout-secs";
                }
                case 28: {
                    return "servlet-reload-check-secs";
                }
                case 11: {
                    return "x-powered-by-header-level";
                }
                case 8: {
                    return "allow-all-roles";
                }
                case 20: {
                    return "auth-cookie-enabled";
                }
                case 30: {
                    return "change-sessionid-on-authentication";
                }
                case 17: {
                    return "client-cert-proxy-enabled";
                }
                case 9: {
                    return "filter-dispatched-requests-enabled";
                }
                case 18: {
                    return "http-trace-support-enabled";
                }
                case 27: {
                    return "jsp-compiler-backwards-compatible";
                }
                case 13: {
                    return "optimistic-serialization";
                }
                case 10: {
                    return "overload-protection-enabled";
                }
                case 7: {
                    return "relogin-enabled";
                }
                case 14: {
                    return "retain-original-url";
                }
                case 16: {
                    return "rtexprvalue-jsp-param-name";
                }
                case 15: {
                    return "servlet-authentication-form-url";
                }
                case 29: {
                    return "show-archived-real-path-enabled";
                }
                case 21: {
                    return "wap-enabled";
                }
                case 19: {
                    return "weblogic-plugin-enabled";
                }
                case 25: {
                    return "work-context-propagation-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 24: {
                    return true;
                }
                case 23: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 26: {
                    return true;
                }
                case 22: {
                    return true;
                }
                case 28: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 20: {
                    return true;
                }
                case 17: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 18: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 16: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 21: {
                    return true;
                }
                case 19: {
                    return true;
                }
                case 25: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private WebAppContainerMBeanImpl bean;

        protected Helper(WebAppContainerMBeanImpl webAppContainerMBeanImpl) {
            super(webAppContainerMBeanImpl);
            this.bean = webAppContainerMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 24: {
                    return "MaxPostSize";
                }
                case 23: {
                    return "MaxPostTimeSecs";
                }
                case 12: {
                    return "MimeMappingFile";
                }
                case 26: {
                    return "P3PHeaderValue";
                }
                case 22: {
                    return "PostTimeoutSecs";
                }
                case 28: {
                    return "ServletReloadCheckSecs";
                }
                case 11: {
                    return "XPoweredByHeaderLevel";
                }
                case 8: {
                    return "AllowAllRoles";
                }
                case 20: {
                    return "AuthCookieEnabled";
                }
                case 30: {
                    return "ChangeSessionIDOnAuthentication";
                }
                case 17: {
                    return "ClientCertProxyEnabled";
                }
                case 9: {
                    return "FilterDispatchedRequestsEnabled";
                }
                case 18: {
                    return "HttpTraceSupportEnabled";
                }
                case 27: {
                    return "JSPCompilerBackwardsCompatible";
                }
                case 13: {
                    return "OptimisticSerialization";
                }
                case 10: {
                    return "OverloadProtectionEnabled";
                }
                case 7: {
                    return "ReloginEnabled";
                }
                case 14: {
                    return "RetainOriginalURL";
                }
                case 16: {
                    return "RtexprvalueJspParamName";
                }
                case 15: {
                    return "ServletAuthenticationFormURL";
                }
                case 29: {
                    return "ShowArchivedRealPathEnabled";
                }
                case 21: {
                    return "WAPEnabled";
                }
                case 19: {
                    return "WeblogicPluginEnabled";
                }
                case 25: {
                    return "WorkContextPropagationEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("MaxPostSize")) {
                return 24;
            }
            if (string.equals("MaxPostTimeSecs")) {
                return 23;
            }
            if (string.equals("MimeMappingFile")) {
                return 12;
            }
            if (string.equals("P3PHeaderValue")) {
                return 26;
            }
            if (string.equals("PostTimeoutSecs")) {
                return 22;
            }
            if (string.equals("ServletReloadCheckSecs")) {
                return 28;
            }
            if (string.equals("XPoweredByHeaderLevel")) {
                return 11;
            }
            if (string.equals("AllowAllRoles")) {
                return 8;
            }
            if (string.equals("AuthCookieEnabled")) {
                return 20;
            }
            if (string.equals("ChangeSessionIDOnAuthentication")) {
                return 30;
            }
            if (string.equals("ClientCertProxyEnabled")) {
                return 17;
            }
            if (string.equals("FilterDispatchedRequestsEnabled")) {
                return 9;
            }
            if (string.equals("HttpTraceSupportEnabled")) {
                return 18;
            }
            if (string.equals("JSPCompilerBackwardsCompatible")) {
                return 27;
            }
            if (string.equals("OptimisticSerialization")) {
                return 13;
            }
            if (string.equals("OverloadProtectionEnabled")) {
                return 10;
            }
            if (string.equals("ReloginEnabled")) {
                return 7;
            }
            if (string.equals("RetainOriginalURL")) {
                return 14;
            }
            if (string.equals("RtexprvalueJspParamName")) {
                return 16;
            }
            if (string.equals("ServletAuthenticationFormURL")) {
                return 15;
            }
            if (string.equals("ShowArchivedRealPathEnabled")) {
                return 29;
            }
            if (string.equals("WAPEnabled")) {
                return 21;
            }
            if (string.equals("WeblogicPluginEnabled")) {
                return 19;
            }
            if (string.equals("WorkContextPropagationEnabled")) {
                return 25;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isMaxPostSizeSet()) {
                    stringBuffer.append("MaxPostSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxPostSize()));
                }
                if (this.bean.isMaxPostTimeSecsSet()) {
                    stringBuffer.append("MaxPostTimeSecs");
                    stringBuffer.append(String.valueOf(this.bean.getMaxPostTimeSecs()));
                }
                if (this.bean.isMimeMappingFileSet()) {
                    stringBuffer.append("MimeMappingFile");
                    stringBuffer.append(String.valueOf(this.bean.getMimeMappingFile()));
                }
                if (this.bean.isP3PHeaderValueSet()) {
                    stringBuffer.append("P3PHeaderValue");
                    stringBuffer.append(String.valueOf(this.bean.getP3PHeaderValue()));
                }
                if (this.bean.isPostTimeoutSecsSet()) {
                    stringBuffer.append("PostTimeoutSecs");
                    stringBuffer.append(String.valueOf(this.bean.getPostTimeoutSecs()));
                }
                if (this.bean.isServletReloadCheckSecsSet()) {
                    stringBuffer.append("ServletReloadCheckSecs");
                    stringBuffer.append(String.valueOf(this.bean.getServletReloadCheckSecs()));
                }
                if (this.bean.isXPoweredByHeaderLevelSet()) {
                    stringBuffer.append("XPoweredByHeaderLevel");
                    stringBuffer.append(String.valueOf(this.bean.getXPoweredByHeaderLevel()));
                }
                if (this.bean.isAllowAllRolesSet()) {
                    stringBuffer.append("AllowAllRoles");
                    stringBuffer.append(String.valueOf(this.bean.isAllowAllRoles()));
                }
                if (this.bean.isAuthCookieEnabledSet()) {
                    stringBuffer.append("AuthCookieEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isAuthCookieEnabled()));
                }
                if (this.bean.isChangeSessionIDOnAuthenticationSet()) {
                    stringBuffer.append("ChangeSessionIDOnAuthentication");
                    stringBuffer.append(String.valueOf(this.bean.isChangeSessionIDOnAuthentication()));
                }
                if (this.bean.isClientCertProxyEnabledSet()) {
                    stringBuffer.append("ClientCertProxyEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isClientCertProxyEnabled()));
                }
                if (this.bean.isFilterDispatchedRequestsEnabledSet()) {
                    stringBuffer.append("FilterDispatchedRequestsEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isFilterDispatchedRequestsEnabled()));
                }
                if (this.bean.isHttpTraceSupportEnabledSet()) {
                    stringBuffer.append("HttpTraceSupportEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isHttpTraceSupportEnabled()));
                }
                if (this.bean.isJSPCompilerBackwardsCompatibleSet()) {
                    stringBuffer.append("JSPCompilerBackwardsCompatible");
                    stringBuffer.append(String.valueOf(this.bean.isJSPCompilerBackwardsCompatible()));
                }
                if (this.bean.isOptimisticSerializationSet()) {
                    stringBuffer.append("OptimisticSerialization");
                    stringBuffer.append(String.valueOf(this.bean.isOptimisticSerialization()));
                }
                if (this.bean.isOverloadProtectionEnabledSet()) {
                    stringBuffer.append("OverloadProtectionEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isOverloadProtectionEnabled()));
                }
                if (this.bean.isReloginEnabledSet()) {
                    stringBuffer.append("ReloginEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isReloginEnabled()));
                }
                if (this.bean.isRetainOriginalURLSet()) {
                    stringBuffer.append("RetainOriginalURL");
                    stringBuffer.append(String.valueOf(this.bean.isRetainOriginalURL()));
                }
                if (this.bean.isRtexprvalueJspParamNameSet()) {
                    stringBuffer.append("RtexprvalueJspParamName");
                    stringBuffer.append(String.valueOf(this.bean.isRtexprvalueJspParamName()));
                }
                if (this.bean.isServletAuthenticationFormURLSet()) {
                    stringBuffer.append("ServletAuthenticationFormURL");
                    stringBuffer.append(String.valueOf(this.bean.isServletAuthenticationFormURL()));
                }
                if (this.bean.isShowArchivedRealPathEnabledSet()) {
                    stringBuffer.append("ShowArchivedRealPathEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isShowArchivedRealPathEnabled()));
                }
                if (this.bean.isWAPEnabledSet()) {
                    stringBuffer.append("WAPEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isWAPEnabled()));
                }
                if (this.bean.isWeblogicPluginEnabledSet()) {
                    stringBuffer.append("WeblogicPluginEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isWeblogicPluginEnabled()));
                }
                if (this.bean.isWorkContextPropagationEnabledSet()) {
                    stringBuffer.append("WorkContextPropagationEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isWorkContextPropagationEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WebAppContainerMBeanImpl webAppContainerMBeanImpl = (WebAppContainerMBeanImpl)abstractDescriptorBean;
                this.computeDiff("MaxPostSize", this.bean.getMaxPostSize(), webAppContainerMBeanImpl.getMaxPostSize(), true);
                this.computeDiff("MaxPostTimeSecs", this.bean.getMaxPostTimeSecs(), webAppContainerMBeanImpl.getMaxPostTimeSecs(), true);
                this.computeDiff("MimeMappingFile", this.bean.getMimeMappingFile(), webAppContainerMBeanImpl.getMimeMappingFile(), false);
                this.computeDiff("P3PHeaderValue", this.bean.getP3PHeaderValue(), webAppContainerMBeanImpl.getP3PHeaderValue(), false);
                this.computeDiff("PostTimeoutSecs", this.bean.getPostTimeoutSecs(), webAppContainerMBeanImpl.getPostTimeoutSecs(), true);
                this.computeDiff("ServletReloadCheckSecs", this.bean.getServletReloadCheckSecs(), webAppContainerMBeanImpl.getServletReloadCheckSecs(), true);
                this.computeDiff("XPoweredByHeaderLevel", this.bean.getXPoweredByHeaderLevel(), webAppContainerMBeanImpl.getXPoweredByHeaderLevel(), true);
                this.computeDiff("AllowAllRoles", this.bean.isAllowAllRoles(), webAppContainerMBeanImpl.isAllowAllRoles(), false);
                this.computeDiff("AuthCookieEnabled", this.bean.isAuthCookieEnabled(), webAppContainerMBeanImpl.isAuthCookieEnabled(), true);
                this.computeDiff("ChangeSessionIDOnAuthentication", this.bean.isChangeSessionIDOnAuthentication(), webAppContainerMBeanImpl.isChangeSessionIDOnAuthentication(), false);
                this.computeDiff("ClientCertProxyEnabled", this.bean.isClientCertProxyEnabled(), webAppContainerMBeanImpl.isClientCertProxyEnabled(), false);
                this.computeDiff("FilterDispatchedRequestsEnabled", this.bean.isFilterDispatchedRequestsEnabled(), webAppContainerMBeanImpl.isFilterDispatchedRequestsEnabled(), false);
                this.computeDiff("HttpTraceSupportEnabled", this.bean.isHttpTraceSupportEnabled(), webAppContainerMBeanImpl.isHttpTraceSupportEnabled(), true);
                this.computeDiff("JSPCompilerBackwardsCompatible", this.bean.isJSPCompilerBackwardsCompatible(), webAppContainerMBeanImpl.isJSPCompilerBackwardsCompatible(), false);
                this.computeDiff("OptimisticSerialization", this.bean.isOptimisticSerialization(), webAppContainerMBeanImpl.isOptimisticSerialization(), false);
                this.computeDiff("OverloadProtectionEnabled", this.bean.isOverloadProtectionEnabled(), webAppContainerMBeanImpl.isOverloadProtectionEnabled(), true);
                this.computeDiff("ReloginEnabled", this.bean.isReloginEnabled(), webAppContainerMBeanImpl.isReloginEnabled(), false);
                this.computeDiff("RetainOriginalURL", this.bean.isRetainOriginalURL(), webAppContainerMBeanImpl.isRetainOriginalURL(), false);
                this.computeDiff("RtexprvalueJspParamName", this.bean.isRtexprvalueJspParamName(), webAppContainerMBeanImpl.isRtexprvalueJspParamName(), false);
                this.computeDiff("ServletAuthenticationFormURL", this.bean.isServletAuthenticationFormURL(), webAppContainerMBeanImpl.isServletAuthenticationFormURL(), false);
                this.computeDiff("ShowArchivedRealPathEnabled", this.bean.isShowArchivedRealPathEnabled(), webAppContainerMBeanImpl.isShowArchivedRealPathEnabled(), false);
                this.computeDiff("WAPEnabled", this.bean.isWAPEnabled(), webAppContainerMBeanImpl.isWAPEnabled(), true);
                this.computeDiff("WeblogicPluginEnabled", this.bean.isWeblogicPluginEnabled(), webAppContainerMBeanImpl.isWeblogicPluginEnabled(), true);
                this.computeDiff("WorkContextPropagationEnabled", this.bean.isWorkContextPropagationEnabled(), webAppContainerMBeanImpl.isWorkContextPropagationEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WebAppContainerMBeanImpl webAppContainerMBeanImpl = (WebAppContainerMBeanImpl)beanUpdateEvent.getSourceBean();
                WebAppContainerMBeanImpl webAppContainerMBeanImpl2 = (WebAppContainerMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("MaxPostSize")) {
                    webAppContainerMBeanImpl.setMaxPostSize(webAppContainerMBeanImpl2.getMaxPostSize());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("MaxPostTimeSecs")) {
                    webAppContainerMBeanImpl.setMaxPostTimeSecs(webAppContainerMBeanImpl2.getMaxPostTimeSecs());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("MimeMappingFile")) {
                    webAppContainerMBeanImpl.setMimeMappingFile(webAppContainerMBeanImpl2.getMimeMappingFile());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("P3PHeaderValue")) {
                    webAppContainerMBeanImpl.setP3PHeaderValue(webAppContainerMBeanImpl2.getP3PHeaderValue());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("PostTimeoutSecs")) {
                    webAppContainerMBeanImpl.setPostTimeoutSecs(webAppContainerMBeanImpl2.getPostTimeoutSecs());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("ServletReloadCheckSecs")) {
                    webAppContainerMBeanImpl.setServletReloadCheckSecs(webAppContainerMBeanImpl2.getServletReloadCheckSecs());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (string.equals("XPoweredByHeaderLevel")) {
                    webAppContainerMBeanImpl.setXPoweredByHeaderLevel(webAppContainerMBeanImpl2.getXPoweredByHeaderLevel());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("AllowAllRoles")) {
                    webAppContainerMBeanImpl.setAllowAllRoles(webAppContainerMBeanImpl2.isAllowAllRoles());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                } else if (string.equals("AuthCookieEnabled")) {
                    webAppContainerMBeanImpl.setAuthCookieEnabled(webAppContainerMBeanImpl2.isAuthCookieEnabled());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("ChangeSessionIDOnAuthentication")) {
                    webAppContainerMBeanImpl.setChangeSessionIDOnAuthentication(webAppContainerMBeanImpl2.isChangeSessionIDOnAuthentication());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                } else if (string.equals("ClientCertProxyEnabled")) {
                    webAppContainerMBeanImpl.setClientCertProxyEnabled(webAppContainerMBeanImpl2.isClientCertProxyEnabled());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("FilterDispatchedRequestsEnabled")) {
                    webAppContainerMBeanImpl.setFilterDispatchedRequestsEnabled(webAppContainerMBeanImpl2.isFilterDispatchedRequestsEnabled());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("HttpTraceSupportEnabled")) {
                    webAppContainerMBeanImpl.setHttpTraceSupportEnabled(webAppContainerMBeanImpl2.isHttpTraceSupportEnabled());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("JSPCompilerBackwardsCompatible")) {
                    webAppContainerMBeanImpl.setJSPCompilerBackwardsCompatible(webAppContainerMBeanImpl2.isJSPCompilerBackwardsCompatible());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("OptimisticSerialization")) {
                    webAppContainerMBeanImpl.setOptimisticSerialization(webAppContainerMBeanImpl2.isOptimisticSerialization());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("OverloadProtectionEnabled")) {
                    webAppContainerMBeanImpl.setOverloadProtectionEnabled(webAppContainerMBeanImpl2.isOverloadProtectionEnabled());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("ReloginEnabled")) {
                    webAppContainerMBeanImpl.setReloginEnabled(webAppContainerMBeanImpl2.isReloginEnabled());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (string.equals("RetainOriginalURL")) {
                    webAppContainerMBeanImpl.setRetainOriginalURL(webAppContainerMBeanImpl2.isRetainOriginalURL());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("RtexprvalueJspParamName")) {
                    webAppContainerMBeanImpl.setRtexprvalueJspParamName(webAppContainerMBeanImpl2.isRtexprvalueJspParamName());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("ServletAuthenticationFormURL")) {
                    webAppContainerMBeanImpl.setServletAuthenticationFormURL(webAppContainerMBeanImpl2.isServletAuthenticationFormURL());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("ShowArchivedRealPathEnabled")) {
                    webAppContainerMBeanImpl.setShowArchivedRealPathEnabled(webAppContainerMBeanImpl2.isShowArchivedRealPathEnabled());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                } else if (string.equals("WAPEnabled")) {
                    webAppContainerMBeanImpl.setWAPEnabled(webAppContainerMBeanImpl2.isWAPEnabled());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("WeblogicPluginEnabled")) {
                    webAppContainerMBeanImpl.setWeblogicPluginEnabled(webAppContainerMBeanImpl2.isWeblogicPluginEnabled());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("WorkContextPropagationEnabled")) {
                    webAppContainerMBeanImpl.setWorkContextPropagationEnabled(webAppContainerMBeanImpl2.isWorkContextPropagationEnabled());
                    webAppContainerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                WebAppContainerMBeanImpl webAppContainerMBeanImpl = (WebAppContainerMBeanImpl)abstractDescriptorBean;
                super.finishCopy(webAppContainerMBeanImpl, bl, list);
                if ((list == null || !list.contains("MaxPostSize")) && this.bean.isMaxPostSizeSet()) {
                    webAppContainerMBeanImpl.setMaxPostSize(this.bean.getMaxPostSize());
                }
                if ((list == null || !list.contains("MaxPostTimeSecs")) && this.bean.isMaxPostTimeSecsSet()) {
                    webAppContainerMBeanImpl.setMaxPostTimeSecs(this.bean.getMaxPostTimeSecs());
                }
                if ((list == null || !list.contains("MimeMappingFile")) && this.bean.isMimeMappingFileSet()) {
                    webAppContainerMBeanImpl.setMimeMappingFile(this.bean.getMimeMappingFile());
                }
                if ((list == null || !list.contains("P3PHeaderValue")) && this.bean.isP3PHeaderValueSet()) {
                    webAppContainerMBeanImpl.setP3PHeaderValue(this.bean.getP3PHeaderValue());
                }
                if ((list == null || !list.contains("PostTimeoutSecs")) && this.bean.isPostTimeoutSecsSet()) {
                    webAppContainerMBeanImpl.setPostTimeoutSecs(this.bean.getPostTimeoutSecs());
                }
                if ((list == null || !list.contains("ServletReloadCheckSecs")) && this.bean.isServletReloadCheckSecsSet()) {
                    webAppContainerMBeanImpl.setServletReloadCheckSecs(this.bean.getServletReloadCheckSecs());
                }
                if ((list == null || !list.contains("XPoweredByHeaderLevel")) && this.bean.isXPoweredByHeaderLevelSet()) {
                    webAppContainerMBeanImpl.setXPoweredByHeaderLevel(this.bean.getXPoweredByHeaderLevel());
                }
                if ((list == null || !list.contains("AllowAllRoles")) && this.bean.isAllowAllRolesSet()) {
                    webAppContainerMBeanImpl.setAllowAllRoles(this.bean.isAllowAllRoles());
                }
                if ((list == null || !list.contains("AuthCookieEnabled")) && this.bean.isAuthCookieEnabledSet()) {
                    webAppContainerMBeanImpl.setAuthCookieEnabled(this.bean.isAuthCookieEnabled());
                }
                if ((list == null || !list.contains("ChangeSessionIDOnAuthentication")) && this.bean.isChangeSessionIDOnAuthenticationSet()) {
                    webAppContainerMBeanImpl.setChangeSessionIDOnAuthentication(this.bean.isChangeSessionIDOnAuthentication());
                }
                if ((list == null || !list.contains("ClientCertProxyEnabled")) && this.bean.isClientCertProxyEnabledSet()) {
                    webAppContainerMBeanImpl.setClientCertProxyEnabled(this.bean.isClientCertProxyEnabled());
                }
                if ((list == null || !list.contains("FilterDispatchedRequestsEnabled")) && this.bean.isFilterDispatchedRequestsEnabledSet()) {
                    webAppContainerMBeanImpl.setFilterDispatchedRequestsEnabled(this.bean.isFilterDispatchedRequestsEnabled());
                }
                if ((list == null || !list.contains("HttpTraceSupportEnabled")) && this.bean.isHttpTraceSupportEnabledSet()) {
                    webAppContainerMBeanImpl.setHttpTraceSupportEnabled(this.bean.isHttpTraceSupportEnabled());
                }
                if ((list == null || !list.contains("JSPCompilerBackwardsCompatible")) && this.bean.isJSPCompilerBackwardsCompatibleSet()) {
                    webAppContainerMBeanImpl.setJSPCompilerBackwardsCompatible(this.bean.isJSPCompilerBackwardsCompatible());
                }
                if ((list == null || !list.contains("OptimisticSerialization")) && this.bean.isOptimisticSerializationSet()) {
                    webAppContainerMBeanImpl.setOptimisticSerialization(this.bean.isOptimisticSerialization());
                }
                if ((list == null || !list.contains("OverloadProtectionEnabled")) && this.bean.isOverloadProtectionEnabledSet()) {
                    webAppContainerMBeanImpl.setOverloadProtectionEnabled(this.bean.isOverloadProtectionEnabled());
                }
                if ((list == null || !list.contains("ReloginEnabled")) && this.bean.isReloginEnabledSet()) {
                    webAppContainerMBeanImpl.setReloginEnabled(this.bean.isReloginEnabled());
                }
                if ((list == null || !list.contains("RetainOriginalURL")) && this.bean.isRetainOriginalURLSet()) {
                    webAppContainerMBeanImpl.setRetainOriginalURL(this.bean.isRetainOriginalURL());
                }
                if ((list == null || !list.contains("RtexprvalueJspParamName")) && this.bean.isRtexprvalueJspParamNameSet()) {
                    webAppContainerMBeanImpl.setRtexprvalueJspParamName(this.bean.isRtexprvalueJspParamName());
                }
                if ((list == null || !list.contains("ServletAuthenticationFormURL")) && this.bean.isServletAuthenticationFormURLSet()) {
                    webAppContainerMBeanImpl.setServletAuthenticationFormURL(this.bean.isServletAuthenticationFormURL());
                }
                if ((list == null || !list.contains("ShowArchivedRealPathEnabled")) && this.bean.isShowArchivedRealPathEnabledSet()) {
                    webAppContainerMBeanImpl.setShowArchivedRealPathEnabled(this.bean.isShowArchivedRealPathEnabled());
                }
                if ((list == null || !list.contains("WAPEnabled")) && this.bean.isWAPEnabledSet()) {
                    webAppContainerMBeanImpl.setWAPEnabled(this.bean.isWAPEnabled());
                }
                if ((list == null || !list.contains("WeblogicPluginEnabled")) && this.bean.isWeblogicPluginEnabledSet()) {
                    webAppContainerMBeanImpl.setWeblogicPluginEnabled(this.bean.isWeblogicPluginEnabled());
                }
                if ((list == null || !list.contains("WorkContextPropagationEnabled")) && this.bean.isWorkContextPropagationEnabledSet()) {
                    webAppContainerMBeanImpl.setWorkContextPropagationEnabled(this.bean.isWorkContextPropagationEnabled());
                }
                return webAppContainerMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
        }
    }
}

