/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.InvalidAttributeValueException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.VirtualHostMBeanImpl;
import weblogic.management.configuration.WebDeploymentMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.configuration.WebServerMBeanImpl;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.CombinedIterator;

public class WebDeploymentMBeanImpl
extends DeploymentMBeanImpl
implements WebDeploymentMBean,
Serializable {
    private VirtualHostMBean[] _DeployedVirtualHosts;
    private VirtualHostMBean[] _VirtualHosts;
    private WebServerMBean[] _WebServers;
    private static SchemaHelper2 _schemaHelper;

    public WebDeploymentMBeanImpl() {
        this._initializeProperty(-1);
    }

    public WebDeploymentMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        this._initializeProperty(-1);
    }

    public WebServerMBean[] getWebServers() {
        return this._WebServers;
    }

    public boolean isWebServersSet() {
        return this._isSet(9);
    }

    public void setWebServers(WebServerMBean[] webServerMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        webServerMBeanArray = webServerMBeanArray == null ? new WebServerMBeanImpl[]{} : webServerMBeanArray;
        this._WebServers = webServerMBeanArray;
    }

    public boolean addWebServer(WebServerMBean webServerMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)webServerMBean);
        if (!((AbstractDescriptorBean)webServerMBean).isChildProperty((DescriptorBean)this, 9)) {
            WebServerMBean[] webServerMBeanArray = (WebServerMBean[])this._getHelper()._extendArray((Object)this.getWebServers(), WebServerMBean.class, (Object)webServerMBean);
            try {
                this.setWebServers(webServerMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeWebServer(WebServerMBean webServerMBean) throws DistributedManagementException {
        WebServerMBean[] webServerMBeanArray = this.getWebServers();
        WebServerMBean[] webServerMBeanArray2 = (WebServerMBean[])this._getHelper()._removeElement((Object)webServerMBeanArray, WebServerMBean.class, (Object)webServerMBean);
        if (webServerMBeanArray2.length != webServerMBeanArray.length) {
            try {
                this.setWebServers(webServerMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public VirtualHostMBean[] getVirtualHosts() {
        return this._VirtualHosts;
    }

    public String getVirtualHostsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getVirtualHosts());
    }

    public boolean isVirtualHostsSet() {
        return this._isSet(10);
    }

    public void setVirtualHostsAsString(String string) {
        if (string == null || string.length() == 0) {
            VirtualHostMBean[] virtualHostMBeanArray = this._VirtualHosts;
            this._initializeProperty(10);
            this._postSet(10, virtualHostMBeanArray, this._VirtualHosts);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._VirtualHosts);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, VirtualHostMBean.class, new ReferenceManager.Resolver(this, 10){

                    public void resolveReference(Object object) {
                        try {
                            WebDeploymentMBeanImpl.this.addVirtualHost((VirtualHostMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (VirtualHostMBean virtualHostMBean : this._VirtualHosts) {
                    if (!string2.equals(virtualHostMBean.getName())) continue;
                    try {
                        this.removeVirtualHost(virtualHostMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setVirtualHosts(VirtualHostMBean[] virtualHostMBeanArray) throws InvalidAttributeValueException, DistributedManagementException {
        virtualHostMBeanArray = virtualHostMBeanArray == null ? new VirtualHostMBeanImpl[]{} : virtualHostMBeanArray;
        virtualHostMBeanArray = (VirtualHostMBean[])this._getHelper()._cleanAndValidateArray((Object)virtualHostMBeanArray, VirtualHostMBean.class);
        for (int i = 0; i < virtualHostMBeanArray.length; ++i) {
            if (virtualHostMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 10, (AbstractDescriptorBean)virtualHostMBeanArray[i]){

                protected Object getPropertyValue() {
                    return WebDeploymentMBeanImpl.this.getVirtualHosts();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)virtualHostMBeanArray[i], resolvedReference);
        }
        VirtualHostMBean[] virtualHostMBeanArray2 = this._VirtualHosts;
        this._VirtualHosts = virtualHostMBeanArray;
        this._postSet(10, virtualHostMBeanArray2, virtualHostMBeanArray);
    }

    public boolean addVirtualHost(VirtualHostMBean virtualHostMBean) throws InvalidAttributeValueException, DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)virtualHostMBean);
        if (!((AbstractDescriptorBean)virtualHostMBean).isChildProperty((DescriptorBean)this, 10)) {
            VirtualHostMBean[] virtualHostMBeanArray = this._isSet(10) ? (VirtualHostMBean[])this._getHelper()._extendArray((Object)this.getVirtualHosts(), VirtualHostMBean.class, (Object)virtualHostMBean) : new VirtualHostMBean[]{virtualHostMBean};
            try {
                this.setVirtualHosts(virtualHostMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeVirtualHost(VirtualHostMBean virtualHostMBean) throws DistributedManagementException {
        VirtualHostMBean[] virtualHostMBeanArray = this.getVirtualHosts();
        VirtualHostMBean[] virtualHostMBeanArray2 = (VirtualHostMBean[])this._getHelper()._removeElement((Object)virtualHostMBeanArray, VirtualHostMBean.class, (Object)virtualHostMBean);
        if (virtualHostMBeanArray2.length != virtualHostMBeanArray.length) {
            try {
                this.setVirtualHosts(virtualHostMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void addDeployedVirtualHost(VirtualHostMBean virtualHostMBean) {
        this._getHelper()._ensureNonNull((Object)virtualHostMBean);
        if (!((AbstractDescriptorBean)virtualHostMBean).isChildProperty((DescriptorBean)this, 11)) {
            VirtualHostMBean[] virtualHostMBeanArray = (VirtualHostMBean[])this._getHelper()._extendArray((Object)this.getDeployedVirtualHosts(), VirtualHostMBean.class, (Object)virtualHostMBean);
            try {
                this.setDeployedVirtualHosts(virtualHostMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public VirtualHostMBean[] getDeployedVirtualHosts() {
        return this._DeployedVirtualHosts;
    }

    public boolean isDeployedVirtualHostsSet() {
        return this._isSet(11);
    }

    public void removeDeployedVirtualHost(VirtualHostMBean virtualHostMBean) {
        VirtualHostMBean[] virtualHostMBeanArray = this.getDeployedVirtualHosts();
        VirtualHostMBean[] virtualHostMBeanArray2 = (VirtualHostMBean[])this._getHelper()._removeElement((Object)virtualHostMBeanArray, VirtualHostMBean.class, (Object)virtualHostMBean);
        if (virtualHostMBeanArray2.length != virtualHostMBeanArray.length) {
            try {
                this.setDeployedVirtualHosts(virtualHostMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setDeployedVirtualHosts(VirtualHostMBean[] virtualHostMBeanArray) {
        virtualHostMBeanArray = virtualHostMBeanArray == null ? new VirtualHostMBeanImpl[]{} : virtualHostMBeanArray;
        this._DeployedVirtualHosts = virtualHostMBeanArray;
    }

    public Object _getKey() {
        return super._getKey();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 11;
        }
        try {
            switch (n) {
                case 11: {
                    this._DeployedVirtualHosts = new VirtualHostMBean[0];
                    if (bl) break;
                }
                case 10: {
                    this._VirtualHosts = new VirtualHostMBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._WebServers = new WebServerMBean[0];
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "WebDeployment";
    }

    public void putValue(String string, Object object) {
        if (string.equals("DeployedVirtualHosts")) {
            VirtualHostMBean[] virtualHostMBeanArray = this._DeployedVirtualHosts;
            this._DeployedVirtualHosts = (VirtualHostMBean[])object;
            this._postSet(11, virtualHostMBeanArray, this._DeployedVirtualHosts);
            return;
        }
        if (string.equals("VirtualHosts")) {
            VirtualHostMBean[] virtualHostMBeanArray = this._VirtualHosts;
            this._VirtualHosts = (VirtualHostMBean[])object;
            this._postSet(10, virtualHostMBeanArray, this._VirtualHosts);
            return;
        }
        if (string.equals("WebServers")) {
            WebServerMBean[] webServerMBeanArray = this._WebServers;
            this._WebServers = (WebServerMBean[])object;
            this._postSet(9, webServerMBeanArray, this._WebServers);
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("DeployedVirtualHosts")) {
            return this._DeployedVirtualHosts;
        }
        if (string.equals("VirtualHosts")) {
            return this._VirtualHosts;
        }
        if (string.equals("WebServers")) {
            return this._WebServers;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 21: {
                    if (!string.equals("deployed-virtual-host")) break;
                    return 11;
                }
                case 12: {
                    if (!string.equals("virtual-host")) break;
                    return 10;
                }
                case 10: {
                    if (!string.equals("web-server")) break;
                    return 9;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                default: 
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 11: {
                    return "deployed-virtual-host";
                }
                case 10: {
                    return "virtual-host";
                }
                case 9: {
                    return "web-server";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 11: {
                    return true;
                }
                case 7: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                default: 
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private WebDeploymentMBeanImpl bean;

        protected Helper(WebDeploymentMBeanImpl webDeploymentMBeanImpl) {
            super(webDeploymentMBeanImpl);
            this.bean = webDeploymentMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 11: {
                    return "DeployedVirtualHosts";
                }
                case 10: {
                    return "VirtualHosts";
                }
                case 9: {
                    return "WebServers";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("DeployedVirtualHosts")) {
                return 11;
            }
            if (string.equals("VirtualHosts")) {
                return 10;
            }
            if (string.equals("WebServers")) {
                return 9;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList arrayList = new ArrayList();
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isDeployedVirtualHostsSet()) {
                    stringBuffer.append("DeployedVirtualHosts");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getDeployedVirtualHosts())));
                }
                if (this.bean.isVirtualHostsSet()) {
                    stringBuffer.append("VirtualHosts");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getVirtualHosts())));
                }
                if (this.bean.isWebServersSet()) {
                    stringBuffer.append("WebServers");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getWebServers())));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WebDeploymentMBeanImpl webDeploymentMBeanImpl = (WebDeploymentMBeanImpl)abstractDescriptorBean;
                this.computeDiff("VirtualHosts", this.bean.getVirtualHosts(), webDeploymentMBeanImpl.getVirtualHosts(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WebDeploymentMBeanImpl webDeploymentMBeanImpl = (WebDeploymentMBeanImpl)beanUpdateEvent.getSourceBean();
                WebDeploymentMBeanImpl webDeploymentMBeanImpl2 = (WebDeploymentMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (!string.equals("DeployedVirtualHosts")) {
                    if (string.equals("VirtualHosts")) {
                        webDeploymentMBeanImpl.setVirtualHostsAsString(webDeploymentMBeanImpl2.getVirtualHostsAsString());
                        webDeploymentMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                    } else if (!string.equals("WebServers")) {
                        super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                WebDeploymentMBeanImpl webDeploymentMBeanImpl = (WebDeploymentMBeanImpl)abstractDescriptorBean;
                super.finishCopy(webDeploymentMBeanImpl, bl, list);
                if ((list == null || !list.contains("VirtualHosts")) && this.bean.isVirtualHostsSet()) {
                    webDeploymentMBeanImpl._unSet(webDeploymentMBeanImpl, 10);
                    webDeploymentMBeanImpl.setVirtualHostsAsString(this.bean.getVirtualHostsAsString());
                }
                return webDeploymentMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getDeployedVirtualHosts(), clazz, object);
            this.inferSubTree(this.bean.getVirtualHosts(), clazz, object);
            this.inferSubTree(this.bean.getWebServers(), clazz, object);
        }
    }
}

