/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BootstrapProperties;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.beangen.StringHelper;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.ReferenceManager;
import weblogic.descriptor.internal.ResolvedReference;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.DistributedManagementException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.DeploymentMBeanImpl;
import weblogic.management.configuration.LoggingLegalHelper;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.configuration.WebDeploymentMBean;
import weblogic.management.configuration.WebDeploymentMBeanImpl;
import weblogic.management.configuration.WebServerLogMBean;
import weblogic.management.configuration.WebServerLogMBeanImpl;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.mbeans.custom.WebServer;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class WebServerMBeanImpl
extends DeploymentMBeanImpl
implements WebServerMBean,
Serializable {
    private boolean _AcceptContextPathInGetRealPath;
    private boolean _AuthCookieEnabled;
    private Map _Charsets;
    private boolean _ChunkedTransferDisabled;
    private String _ClientIpHeader;
    private boolean _DebugEnabled;
    private WebAppComponentMBean _DefaultWebApp;
    private String _DefaultWebAppContextRoot;
    private int _FrontendHTTPPort;
    private int _FrontendHTTPSPort;
    private String _FrontendHost;
    private int _HttpsKeepAliveSecs;
    private boolean _KeepAliveEnabled;
    private int _KeepAliveSecs;
    private int _LogFileBufferKBytes;
    private int _LogFileCount;
    private int _LogFileFlushSecs;
    private String _LogFileFormat;
    private boolean _LogFileLimitEnabled;
    private String _LogFileName;
    private int _LogRotationPeriodMins;
    private String _LogRotationTimeBegin;
    private String _LogRotationType;
    private boolean _LogTimeInGMT;
    private boolean _LoggingEnabled;
    private int _MaxLogFileSizeKBytes;
    private int _MaxPostSize;
    private int _MaxPostTimeSecs;
    private String _Name;
    private int _OverloadResponseCode;
    private int _PostTimeoutSecs;
    private boolean _SendServerHeaderEnabled;
    private boolean _SingleSignonDisabled;
    private Map _URLResource;
    private boolean _UseHeaderEncoding;
    private boolean _UseHighestCompatibleHTTPVersion;
    private boolean _WAPEnabled;
    private WebDeploymentMBean[] _WebDeployments;
    private WebServerLogMBean _WebServerLog;
    private String _WorkManagerForRemoteSessionFetching;
    private int _WriteChunkBytes;
    private WebServer _customizer;
    private static SchemaHelper2 _schemaHelper;

    public WebServerMBeanImpl() {
        try {
            this._customizer = new WebServer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public WebServerMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new WebServer(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public WebServerLogMBean getWebServerLog() {
        return this._WebServerLog;
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public boolean isWebServerLogSet() {
        return this._isSet(9) || this._isAnythingSet((AbstractDescriptorBean)this.getWebServerLog());
    }

    public void setWebServerLog(WebServerLogMBean webServerLogMBean) throws InvalidAttributeValueException {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)webServerLogMBean;
        if (this._setParent((DescriptorBean)abstractDescriptorBean, this, 9)) {
            this._postCreate(abstractDescriptorBean);
        }
        WebServerLogMBean webServerLogMBean2 = this._WebServerLog;
        this._WebServerLog = webServerLogMBean;
        this._postSet(9, webServerLogMBean2, webServerLogMBean);
    }

    public void setLoggingEnabled(boolean bl) {
        boolean bl2 = this.isLoggingEnabled();
        this._customizer.setLoggingEnabled(bl);
        this._postSet(10, bl2, bl);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public boolean isLoggingEnabled() {
        return this._customizer.isLoggingEnabled();
    }

    public boolean isLoggingEnabledSet() {
        return this._isSet(10);
    }

    public String getLogFileFormat() {
        return this._customizer.getLogFileFormat();
    }

    public boolean isLogFileFormatSet() {
        return this._isSet(11);
    }

    public void setLogFileFormat(String string) throws InvalidAttributeValueException, DistributedManagementException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"common", "extended"};
        string = LegalChecks.checkInEnum((String)"LogFileFormat", (String)string, (String[])stringArray);
        String string2 = this.getLogFileFormat();
        this._customizer.setLogFileFormat(string);
        this._postSet(11, string2, string);
    }

    public boolean getLogTimeInGMT() {
        return this._customizer.getLogTimeInGMT();
    }

    public boolean isLogTimeInGMTSet() {
        return this._isSet(12);
    }

    public void setLogTimeInGMT(boolean bl) {
        boolean bl2 = this.getLogTimeInGMT();
        this._customizer.setLogTimeInGMT(bl);
        this._postSet(12, bl2, bl);
    }

    public String getLogFileName() {
        return this._customizer.getLogFileName();
    }

    public boolean isLogFileNameSet() {
        return this._isSet(13);
    }

    public void setLogFileName(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this.getLogFileName();
        this._customizer.setLogFileName(string);
        this._postSet(13, string2, string);
    }

    public String getFrontendHost() {
        return this._FrontendHost;
    }

    public boolean isFrontendHostSet() {
        return this._isSet(14);
    }

    public void setFrontendHost(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._FrontendHost;
        this._FrontendHost = string;
        this._postSet(14, string2, string);
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public int getFrontendHTTPPort() {
        return this._FrontendHTTPPort;
    }

    public boolean isFrontendHTTPPortSet() {
        return this._isSet(15);
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public void setFrontendHTTPPort(int n) throws InvalidAttributeValueException {
        int n2 = this._FrontendHTTPPort;
        this._FrontendHTTPPort = n;
        this._postSet(15, n2, n);
    }

    public int getFrontendHTTPSPort() {
        return this._FrontendHTTPSPort;
    }

    public boolean isFrontendHTTPSPortSet() {
        return this._isSet(16);
    }

    public void setFrontendHTTPSPort(int n) throws InvalidAttributeValueException {
        int n2 = this._FrontendHTTPSPort;
        this._FrontendHTTPSPort = n;
        this._postSet(16, n2, n);
    }

    public void setLogFileBufferKBytes(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LogFileBufferKBytes", (long)n, (long)0L, (long)1024L);
        int n2 = this._LogFileBufferKBytes;
        this._LogFileBufferKBytes = n;
        this._postSet(17, n2, n);
    }

    public int getLogFileBufferKBytes() {
        return this._LogFileBufferKBytes;
    }

    public boolean isLogFileBufferKBytesSet() {
        return this._isSet(17);
    }

    public int getMaxLogFileSizeKBytes() {
        return this._MaxLogFileSizeKBytes;
    }

    public boolean isMaxLogFileSizeKBytesSet() {
        return this._isSet(18);
    }

    public void setMaxLogFileSizeKBytes(int n) throws InvalidAttributeValueException {
        LegalChecks.checkMin((String)"MaxLogFileSizeKBytes", (int)n, (int)0);
        int n2 = this._MaxLogFileSizeKBytes;
        this._MaxLogFileSizeKBytes = n;
        this._postSet(18, n2, n);
    }

    public String getLogRotationType() {
        return this._customizer.getLogRotationType();
    }

    public boolean isLogRotationTypeSet() {
        return this._isSet(19);
    }

    public void setLogRotationType(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"size", "date"};
        string = LegalChecks.checkInEnum((String)"LogRotationType", (String)string, (String[])stringArray);
        String string2 = this.getLogRotationType();
        this._customizer.setLogRotationType(string);
        this._postSet(19, string2, string);
    }

    public int getLogRotationPeriodMins() {
        return this._customizer.getLogRotationPeriodMins();
    }

    public boolean isLogRotationPeriodMinsSet() {
        return this._isSet(20);
    }

    public void setLogRotationPeriodMins(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LogRotationPeriodMins", (long)n, (long)1L, (long)Integer.MAX_VALUE);
        int n2 = this.getLogRotationPeriodMins();
        try {
            this._customizer.setLogRotationPeriodMins(n);
        }
        catch (DistributedManagementException distributedManagementException) {
            throw new UndeclaredThrowableException(distributedManagementException);
        }
        this._postSet(20, n2, n);
    }

    public int getOverloadResponseCode() {
        return this._OverloadResponseCode;
    }

    public boolean isOverloadResponseCodeSet() {
        return this._isSet(21);
    }

    public void setOverloadResponseCode(int n) {
        LegalChecks.checkInRange((String)"OverloadResponseCode", (long)n, (long)100L, (long)599L);
        int n2 = this._OverloadResponseCode;
        this._OverloadResponseCode = n;
        this._postSet(21, n2, n);
    }

    public int getLogFileFlushSecs() {
        return this._LogFileFlushSecs;
    }

    public boolean isLogFileFlushSecsSet() {
        return this._isSet(22);
    }

    public void setLogFileFlushSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LogFileFlushSecs", (long)n, (long)1L, (long)360L);
        int n2 = this._LogFileFlushSecs;
        this._LogFileFlushSecs = n;
        this._postSet(22, n2, n);
    }

    public String getLogRotationTimeBegin() {
        return this._customizer.getLogRotationTimeBegin();
    }

    public boolean isLogRotationTimeBeginSet() {
        return this._isSet(23);
    }

    public void setLogRotationTimeBegin(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        LoggingLegalHelper.validateWebServerLogRotationTimeBegin(string);
        String string2 = this.getLogRotationTimeBegin();
        this._customizer.setLogRotationTimeBegin(string);
        this._postSet(23, string2, string);
    }

    public void setKeepAliveEnabled(boolean bl) {
        boolean bl2 = this._KeepAliveEnabled;
        this._KeepAliveEnabled = bl;
        this._postSet(24, bl2, bl);
    }

    public boolean isKeepAliveEnabled() {
        return this._KeepAliveEnabled;
    }

    public boolean isKeepAliveEnabledSet() {
        return this._isSet(24);
    }

    public int getKeepAliveSecs() {
        return this._KeepAliveSecs;
    }

    public boolean isKeepAliveSecsSet() {
        return this._isSet(25);
    }

    public void setKeepAliveSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"KeepAliveSecs", (long)n, (long)5L, (long)3600L);
        int n2 = this._KeepAliveSecs;
        this._KeepAliveSecs = n;
        this._postSet(25, n2, n);
    }

    public int getHttpsKeepAliveSecs() {
        return this._HttpsKeepAliveSecs;
    }

    public boolean isHttpsKeepAliveSecsSet() {
        return this._isSet(26);
    }

    public void setHttpsKeepAliveSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"HttpsKeepAliveSecs", (long)n, (long)30L, (long)360L);
        int n2 = this._HttpsKeepAliveSecs;
        this._HttpsKeepAliveSecs = n;
        this._postSet(26, n2, n);
    }

    public void setPostTimeoutSecs(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"PostTimeoutSecs", (long)n, (long)0L, (long)120L);
        int n2 = this._PostTimeoutSecs;
        this._PostTimeoutSecs = n;
        this._postSet(27, n2, n);
    }

    public int getPostTimeoutSecs() {
        return this._PostTimeoutSecs;
    }

    public boolean isPostTimeoutSecsSet() {
        return this._isSet(27);
    }

    public void setMaxPostTimeSecs(int n) throws InvalidAttributeValueException {
        int n2 = this._MaxPostTimeSecs;
        this._MaxPostTimeSecs = n;
        this._postSet(28, n2, n);
    }

    public int getMaxPostTimeSecs() {
        return this._MaxPostTimeSecs;
    }

    public boolean isMaxPostTimeSecsSet() {
        return this._isSet(28);
    }

    public void setMaxPostSize(int n) throws InvalidAttributeValueException {
        int n2 = this._MaxPostSize;
        this._MaxPostSize = n;
        this._postSet(29, n2, n);
    }

    public int getMaxPostSize() {
        return this._MaxPostSize;
    }

    public boolean isMaxPostSizeSet() {
        return this._isSet(29);
    }

    public void setSendServerHeaderEnabled(boolean bl) {
        boolean bl2 = this._SendServerHeaderEnabled;
        this._SendServerHeaderEnabled = bl;
        this._postSet(30, bl2, bl);
    }

    public boolean isSendServerHeaderEnabled() {
        return this._SendServerHeaderEnabled;
    }

    public boolean isSendServerHeaderEnabledSet() {
        return this._isSet(30);
    }

    public String getDefaultWebAppContextRoot() {
        return this._DefaultWebAppContextRoot;
    }

    public boolean isDefaultWebAppContextRootSet() {
        return this._isSet(31);
    }

    public void setDefaultWebAppContextRoot(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._DefaultWebAppContextRoot;
        this._DefaultWebAppContextRoot = string;
        this._postSet(31, string2, string);
    }

    public WebAppComponentMBean getDefaultWebApp() {
        return this._DefaultWebApp;
    }

    public String getDefaultWebAppAsString() {
        AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)this.getDefaultWebApp();
        return abstractDescriptorBean == null ? null : abstractDescriptorBean._getKey().toString();
    }

    public boolean isDefaultWebAppSet() {
        return this._isSet(32);
    }

    public void setDefaultWebAppAsString(String string) {
        if (string == null || string.length() == 0) {
            WebAppComponentMBean webAppComponentMBean = this._DefaultWebApp;
            this._initializeProperty(32);
            this._postSet(32, webAppComponentMBean, this._DefaultWebApp);
        } else {
            string = string == null ? null : string.trim();
            this._getReferenceManager().registerUnresolvedReference(string, WebAppComponentMBean.class, new ReferenceManager.Resolver(this, 32){

                public void resolveReference(Object object) {
                    try {
                        WebServerMBeanImpl.this.setDefaultWebApp((WebAppComponentMBean)object);
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            });
        }
    }

    public void setDefaultWebApp(WebAppComponentMBean webAppComponentMBean) {
        WebAppComponentMBean webAppComponentMBean2 = this._DefaultWebApp;
        this._DefaultWebApp = webAppComponentMBean;
        this._postSet(32, webAppComponentMBean2, webAppComponentMBean);
    }

    public void setCharsets(Map map) throws InvalidAttributeValueException {
        Map map2 = this._Charsets;
        this._Charsets = map;
        this._postSet(33, map2, map);
    }

    public Map getCharsets() {
        return this._Charsets;
    }

    public String getCharsetsAsString() {
        return StringHelper.objectToString((Object)this.getCharsets());
    }

    public boolean isCharsetsSet() {
        return this._isSet(33);
    }

    public void setCharsetsAsString(String string) {
        try {
            this.setCharsets(StringHelper.stringToMap((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setURLResource(Map map) throws InvalidAttributeValueException {
        Map map2 = this._URLResource;
        this._URLResource = map;
        this._postSet(34, map2, map);
    }

    public Map getURLResource() {
        return this._URLResource;
    }

    public String getURLResourceAsString() {
        return StringHelper.objectToString((Object)this.getURLResource());
    }

    public boolean isURLResourceSet() {
        return this._isSet(34);
    }

    public void setURLResourceAsString(String string) {
        try {
            this.setURLResource(StringHelper.stringToMap((String)string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
    }

    public void setChunkedTransferDisabled(boolean bl) {
        boolean bl2 = this._ChunkedTransferDisabled;
        this._ChunkedTransferDisabled = bl;
        this._postSet(35, bl2, bl);
    }

    public boolean isChunkedTransferDisabled() {
        return this._ChunkedTransferDisabled;
    }

    public boolean isChunkedTransferDisabledSet() {
        return this._isSet(35);
    }

    public void setUseHighestCompatibleHTTPVersion(boolean bl) {
        boolean bl2 = this._UseHighestCompatibleHTTPVersion;
        this._UseHighestCompatibleHTTPVersion = bl;
        this._postSet(36, bl2, bl);
    }

    public boolean isUseHighestCompatibleHTTPVersion() {
        return this._UseHighestCompatibleHTTPVersion;
    }

    public boolean isUseHighestCompatibleHTTPVersionSet() {
        return this._isSet(36);
    }

    public void setUseHeaderEncoding(boolean bl) {
        boolean bl2 = this._UseHeaderEncoding;
        this._UseHeaderEncoding = bl;
        this._postSet(37, bl2, bl);
    }

    public boolean isUseHeaderEncoding() {
        return this._UseHeaderEncoding;
    }

    public boolean isUseHeaderEncodingSet() {
        return this._isSet(37);
    }

    public void setAuthCookieEnabled(boolean bl) {
        boolean bl2 = this._AuthCookieEnabled;
        this._AuthCookieEnabled = bl;
        this._postSet(38, bl2, bl);
    }

    public boolean isAuthCookieEnabled() {
        return this._AuthCookieEnabled;
    }

    public boolean isAuthCookieEnabledSet() {
        return this._isSet(38);
    }

    public void setWriteChunkBytes(int n) throws InvalidAttributeValueException {
        int n2 = this._WriteChunkBytes;
        this._WriteChunkBytes = n;
        this._postSet(39, n2, n);
    }

    public int getWriteChunkBytes() {
        return this._WriteChunkBytes;
    }

    public boolean isWriteChunkBytesSet() {
        return this._isSet(39);
    }

    public void setDebugEnabled(boolean bl) {
        boolean bl2 = this._DebugEnabled;
        this._DebugEnabled = bl;
        this._postSet(40, bl2, bl);
    }

    public boolean isDebugEnabled() {
        return this._DebugEnabled;
    }

    public boolean isDebugEnabledSet() {
        return this._isSet(40);
    }

    public void setWAPEnabled(boolean bl) {
        boolean bl2 = this._WAPEnabled;
        this._WAPEnabled = bl;
        this._postSet(41, bl2, bl);
    }

    public boolean isWAPEnabled() {
        return this._WAPEnabled;
    }

    public boolean isWAPEnabledSet() {
        return this._isSet(41);
    }

    public void setAcceptContextPathInGetRealPath(boolean bl) {
        boolean bl2 = this._AcceptContextPathInGetRealPath;
        this._AcceptContextPathInGetRealPath = bl;
        this._postSet(42, bl2, bl);
    }

    public boolean isAcceptContextPathInGetRealPath() {
        return this._AcceptContextPathInGetRealPath;
    }

    public boolean isAcceptContextPathInGetRealPathSet() {
        return this._isSet(42);
    }

    public void setSingleSignonDisabled(boolean bl) {
        boolean bl2 = this._SingleSignonDisabled;
        this._SingleSignonDisabled = bl;
        this._postSet(43, bl2, bl);
    }

    public boolean isSingleSignonDisabled() {
        return this._SingleSignonDisabled;
    }

    public boolean isSingleSignonDisabledSet() {
        return this._isSet(43);
    }

    public WebDeploymentMBean[] getWebDeployments() {
        return this._WebDeployments;
    }

    public String getWebDeploymentsAsString() {
        return this._getHelper()._serializeKeyList((Object)this.getWebDeployments());
    }

    public boolean isWebDeploymentsSet() {
        return this._isSet(44);
    }

    public void setWebDeploymentsAsString(String string) {
        if (string == null || string.length() == 0) {
            WebDeploymentMBean[] webDeploymentMBeanArray = this._WebDeployments;
            this._initializeProperty(44);
            this._postSet(44, webDeploymentMBeanArray, this._WebDeployments);
        } else {
            String[] stringArray = this._getHelper()._splitKeyList(string);
            List list = this._getHelper()._getKeyList((Object)this._WebDeployments);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2 = string2 == null ? null : string2.trim();
                if (list.contains(string2)) {
                    list.remove(string2);
                    continue;
                }
                this._getReferenceManager().registerUnresolvedReference(string2, WebDeploymentMBean.class, new ReferenceManager.Resolver(this, 44){

                    public void resolveReference(Object object) {
                        try {
                            WebServerMBeanImpl.this.addWebDeployment((WebDeploymentMBean)object);
                        }
                        catch (RuntimeException runtimeException) {
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            throw new AssertionError((Object)("Impossible exception: " + exception));
                        }
                    }
                });
            }
            block4: for (String string2 : list) {
                for (WebDeploymentMBean webDeploymentMBean : this._WebDeployments) {
                    if (!string2.equals(webDeploymentMBean.getName())) continue;
                    try {
                        this.removeWebDeployment(webDeploymentMBean);
                        continue block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        throw new AssertionError((Object)("Impossible exception: " + exception));
                    }
                }
            }
        }
    }

    public void setWebDeployments(WebDeploymentMBean[] webDeploymentMBeanArray) throws DistributedManagementException {
        webDeploymentMBeanArray = webDeploymentMBeanArray == null ? new WebDeploymentMBeanImpl[]{} : webDeploymentMBeanArray;
        webDeploymentMBeanArray = (WebDeploymentMBean[])this._getHelper()._cleanAndValidateArray((Object)webDeploymentMBeanArray, WebDeploymentMBean.class);
        for (int i = 0; i < webDeploymentMBeanArray.length; ++i) {
            if (webDeploymentMBeanArray[i] == null) continue;
            ResolvedReference resolvedReference = new ResolvedReference(this, 44, (AbstractDescriptorBean)webDeploymentMBeanArray[i]){

                protected Object getPropertyValue() {
                    return WebServerMBeanImpl.this.getWebDeployments();
                }
            };
            this._getReferenceManager().registerResolvedReference((AbstractDescriptorBean)webDeploymentMBeanArray[i], resolvedReference);
        }
        WebDeploymentMBean[] webDeploymentMBeanArray2 = this._WebDeployments;
        this._WebDeployments = webDeploymentMBeanArray;
        this._postSet(44, webDeploymentMBeanArray2, webDeploymentMBeanArray);
    }

    public boolean isLogFileLimitEnabled() {
        return this._customizer.isLogFileLimitEnabled();
    }

    public boolean isLogFileLimitEnabledSet() {
        return this._isSet(45);
    }

    public void setLogFileLimitEnabled(boolean bl) throws InvalidAttributeValueException {
        boolean bl2 = this.isLogFileLimitEnabled();
        this._customizer.setLogFileLimitEnabled(bl);
        this._postSet(45, bl2, bl);
    }

    public int getLogFileCount() {
        return this._customizer.getLogFileCount();
    }

    public boolean isLogFileCountSet() {
        return this._isSet(46);
    }

    public void setLogFileCount(int n) throws InvalidAttributeValueException {
        LegalChecks.checkInRange((String)"LogFileCount", (long)n, (long)1L, (long)9999L);
        int n2 = this.getLogFileCount();
        this._customizer.setLogFileCount(n);
        this._postSet(46, n2, n);
    }

    public boolean addWebDeployment(WebDeploymentMBean webDeploymentMBean) throws DistributedManagementException {
        this._getHelper()._ensureNonNull((Object)webDeploymentMBean);
        if (!((AbstractDescriptorBean)webDeploymentMBean).isChildProperty((DescriptorBean)this, 44)) {
            WebDeploymentMBean[] webDeploymentMBeanArray = this._isSet(44) ? (WebDeploymentMBean[])this._getHelper()._extendArray((Object)this.getWebDeployments(), WebDeploymentMBean.class, (Object)webDeploymentMBean) : new WebDeploymentMBean[]{webDeploymentMBean};
            try {
                this.setWebDeployments(webDeploymentMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeWebDeployment(WebDeploymentMBean webDeploymentMBean) throws DistributedManagementException {
        WebDeploymentMBean[] webDeploymentMBeanArray = this.getWebDeployments();
        WebDeploymentMBean[] webDeploymentMBeanArray2 = (WebDeploymentMBean[])this._getHelper()._removeElement((Object)webDeploymentMBeanArray, WebDeploymentMBean.class, (Object)webDeploymentMBean);
        if (webDeploymentMBeanArray2.length != webDeploymentMBeanArray.length) {
            try {
                this.setWebDeployments(webDeploymentMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof DistributedManagementException) {
                    throw (DistributedManagementException)((Object)exception);
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void setWorkManagerForRemoteSessionFetching(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._WorkManagerForRemoteSessionFetching;
        this._WorkManagerForRemoteSessionFetching = string;
        this._postSet(47, string2, string);
    }

    public String getWorkManagerForRemoteSessionFetching() {
        return this._WorkManagerForRemoteSessionFetching;
    }

    public boolean isWorkManagerForRemoteSessionFetchingSet() {
        return this._isSet(47);
    }

    public void setClientIpHeader(String string) {
        string = string == null ? null : string.trim();
        String string2 = this._ClientIpHeader;
        this._ClientIpHeader = string;
        this._postSet(48, string2, string);
    }

    public String getClientIpHeader() {
        return this._ClientIpHeader;
    }

    public boolean isClientIpHeaderSet() {
        return this._isSet(48);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet() || this.isWebServerLogSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 33;
        }
        try {
            switch (n) {
                case 33: {
                    this._Charsets = null;
                    if (bl) break;
                }
                case 48: {
                    this._ClientIpHeader = null;
                    if (bl) break;
                }
                case 32: {
                    this._DefaultWebApp = null;
                    if (bl) break;
                }
                case 31: {
                    this._DefaultWebAppContextRoot = null;
                    if (bl) break;
                }
                case 15: {
                    this._FrontendHTTPPort = 0;
                    if (bl) break;
                }
                case 16: {
                    this._FrontendHTTPSPort = 0;
                    if (bl) break;
                }
                case 14: {
                    this._FrontendHost = null;
                    if (bl) break;
                }
                case 26: {
                    this._HttpsKeepAliveSecs = 60;
                    if (bl) break;
                }
                case 25: {
                    this._KeepAliveSecs = 30;
                    if (bl) break;
                }
                case 17: {
                    this._LogFileBufferKBytes = 8;
                    if (bl) break;
                }
                case 46: {
                    this._customizer.setLogFileCount(7);
                    if (bl) break;
                }
                case 22: {
                    this._LogFileFlushSecs = 60;
                    if (bl) break;
                }
                case 11: {
                    this._customizer.setLogFileFormat("common");
                    if (bl) break;
                }
                case 13: {
                    this._customizer.setLogFileName("logs/access.log");
                    if (bl) break;
                }
                case 20: {
                    this._customizer.setLogRotationPeriodMins(1440);
                    if (bl) break;
                }
                case 23: {
                    this._customizer.setLogRotationTimeBegin(null);
                    if (bl) break;
                }
                case 19: {
                    this._customizer.setLogRotationType("size");
                    if (bl) break;
                }
                case 12: {
                    this._customizer.setLogTimeInGMT(false);
                    if (bl) break;
                }
                case 18: {
                    this._MaxLogFileSizeKBytes = 5000;
                    if (bl) break;
                }
                case 29: {
                    this._MaxPostSize = -1;
                    if (bl) break;
                }
                case 28: {
                    this._MaxPostTimeSecs = -1;
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 21: {
                    this._OverloadResponseCode = 503;
                    if (bl) break;
                }
                case 27: {
                    this._PostTimeoutSecs = 30;
                    if (bl) break;
                }
                case 34: {
                    this._URLResource = null;
                    if (bl) break;
                }
                case 44: {
                    this._WebDeployments = new WebDeploymentMBean[0];
                    if (bl) break;
                }
                case 9: {
                    this._WebServerLog = new WebServerLogMBeanImpl(this, 9);
                    this._postCreate((AbstractDescriptorBean)this._WebServerLog);
                    if (bl) break;
                }
                case 47: {
                    this._WorkManagerForRemoteSessionFetching = null;
                    if (bl) break;
                }
                case 39: {
                    this._WriteChunkBytes = 512;
                    if (bl) break;
                }
                case 42: {
                    this._AcceptContextPathInGetRealPath = false;
                    if (bl) break;
                }
                case 38: {
                    this._AuthCookieEnabled = true;
                    if (bl) break;
                }
                case 35: {
                    this._ChunkedTransferDisabled = false;
                    if (bl) break;
                }
                case 40: {
                    this._DebugEnabled = false;
                    if (bl) break;
                }
                case 24: {
                    this._KeepAliveEnabled = true;
                    if (bl) break;
                }
                case 45: {
                    this._customizer.setLogFileLimitEnabled(false);
                    if (bl) break;
                }
                case 10: {
                    this._customizer.setLoggingEnabled(true);
                    if (bl) break;
                }
                case 30: {
                    this._SendServerHeaderEnabled = false;
                    if (bl) break;
                }
                case 43: {
                    this._SingleSignonDisabled = false;
                    if (bl) break;
                }
                case 37: {
                    this._UseHeaderEncoding = false;
                    if (bl) break;
                }
                case 36: {
                    this._UseHighestCompatibleHTTPVersion = true;
                    if (bl) break;
                }
                case 41: {
                    this._WAPEnabled = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "WebServer";
    }

    public void putValue(String string, Object object) {
        if (string.equals("AcceptContextPathInGetRealPath")) {
            boolean bl = this._AcceptContextPathInGetRealPath;
            this._AcceptContextPathInGetRealPath = (Boolean)object;
            this._postSet(42, bl, this._AcceptContextPathInGetRealPath);
            return;
        }
        if (string.equals("AuthCookieEnabled")) {
            boolean bl = this._AuthCookieEnabled;
            this._AuthCookieEnabled = (Boolean)object;
            this._postSet(38, bl, this._AuthCookieEnabled);
            return;
        }
        if (string.equals("Charsets")) {
            Map map = this._Charsets;
            this._Charsets = (Map)object;
            this._postSet(33, map, this._Charsets);
            return;
        }
        if (string.equals("ChunkedTransferDisabled")) {
            boolean bl = this._ChunkedTransferDisabled;
            this._ChunkedTransferDisabled = (Boolean)object;
            this._postSet(35, bl, this._ChunkedTransferDisabled);
            return;
        }
        if (string.equals("ClientIpHeader")) {
            String string2 = this._ClientIpHeader;
            this._ClientIpHeader = (String)object;
            this._postSet(48, string2, this._ClientIpHeader);
            return;
        }
        if (string.equals("DebugEnabled")) {
            boolean bl = this._DebugEnabled;
            this._DebugEnabled = (Boolean)object;
            this._postSet(40, bl, this._DebugEnabled);
            return;
        }
        if (string.equals("DefaultWebApp")) {
            WebAppComponentMBean webAppComponentMBean = this._DefaultWebApp;
            this._DefaultWebApp = (WebAppComponentMBean)object;
            this._postSet(32, webAppComponentMBean, this._DefaultWebApp);
            return;
        }
        if (string.equals("DefaultWebAppContextRoot")) {
            String string3 = this._DefaultWebAppContextRoot;
            this._DefaultWebAppContextRoot = (String)object;
            this._postSet(31, string3, this._DefaultWebAppContextRoot);
            return;
        }
        if (string.equals("FrontendHTTPPort")) {
            int n = this._FrontendHTTPPort;
            this._FrontendHTTPPort = (Integer)object;
            this._postSet(15, n, this._FrontendHTTPPort);
            return;
        }
        if (string.equals("FrontendHTTPSPort")) {
            int n = this._FrontendHTTPSPort;
            this._FrontendHTTPSPort = (Integer)object;
            this._postSet(16, n, this._FrontendHTTPSPort);
            return;
        }
        if (string.equals("FrontendHost")) {
            String string4 = this._FrontendHost;
            this._FrontendHost = (String)object;
            this._postSet(14, string4, this._FrontendHost);
            return;
        }
        if (string.equals("HttpsKeepAliveSecs")) {
            int n = this._HttpsKeepAliveSecs;
            this._HttpsKeepAliveSecs = (Integer)object;
            this._postSet(26, n, this._HttpsKeepAliveSecs);
            return;
        }
        if (string.equals("KeepAliveEnabled")) {
            boolean bl = this._KeepAliveEnabled;
            this._KeepAliveEnabled = (Boolean)object;
            this._postSet(24, bl, this._KeepAliveEnabled);
            return;
        }
        if (string.equals("KeepAliveSecs")) {
            int n = this._KeepAliveSecs;
            this._KeepAliveSecs = (Integer)object;
            this._postSet(25, n, this._KeepAliveSecs);
            return;
        }
        if (string.equals("LogFileBufferKBytes")) {
            int n = this._LogFileBufferKBytes;
            this._LogFileBufferKBytes = (Integer)object;
            this._postSet(17, n, this._LogFileBufferKBytes);
            return;
        }
        if (string.equals("LogFileCount")) {
            int n = this._LogFileCount;
            this._LogFileCount = (Integer)object;
            this._postSet(46, n, this._LogFileCount);
            return;
        }
        if (string.equals("LogFileFlushSecs")) {
            int n = this._LogFileFlushSecs;
            this._LogFileFlushSecs = (Integer)object;
            this._postSet(22, n, this._LogFileFlushSecs);
            return;
        }
        if (string.equals("LogFileFormat")) {
            String string5 = this._LogFileFormat;
            this._LogFileFormat = (String)object;
            this._postSet(11, string5, this._LogFileFormat);
            return;
        }
        if (string.equals("LogFileLimitEnabled")) {
            boolean bl = this._LogFileLimitEnabled;
            this._LogFileLimitEnabled = (Boolean)object;
            this._postSet(45, bl, this._LogFileLimitEnabled);
            return;
        }
        if (string.equals("LogFileName")) {
            String string6 = this._LogFileName;
            this._LogFileName = (String)object;
            this._postSet(13, string6, this._LogFileName);
            return;
        }
        if (string.equals("LogRotationPeriodMins")) {
            int n = this._LogRotationPeriodMins;
            this._LogRotationPeriodMins = (Integer)object;
            this._postSet(20, n, this._LogRotationPeriodMins);
            return;
        }
        if (string.equals("LogRotationTimeBegin")) {
            String string7 = this._LogRotationTimeBegin;
            this._LogRotationTimeBegin = (String)object;
            this._postSet(23, string7, this._LogRotationTimeBegin);
            return;
        }
        if (string.equals("LogRotationType")) {
            String string8 = this._LogRotationType;
            this._LogRotationType = (String)object;
            this._postSet(19, string8, this._LogRotationType);
            return;
        }
        if (string.equals("LogTimeInGMT")) {
            boolean bl = this._LogTimeInGMT;
            this._LogTimeInGMT = (Boolean)object;
            this._postSet(12, bl, this._LogTimeInGMT);
            return;
        }
        if (string.equals("LoggingEnabled")) {
            boolean bl = this._LoggingEnabled;
            this._LoggingEnabled = (Boolean)object;
            this._postSet(10, bl, this._LoggingEnabled);
            return;
        }
        if (string.equals("MaxLogFileSizeKBytes")) {
            int n = this._MaxLogFileSizeKBytes;
            this._MaxLogFileSizeKBytes = (Integer)object;
            this._postSet(18, n, this._MaxLogFileSizeKBytes);
            return;
        }
        if (string.equals("MaxPostSize")) {
            int n = this._MaxPostSize;
            this._MaxPostSize = (Integer)object;
            this._postSet(29, n, this._MaxPostSize);
            return;
        }
        if (string.equals("MaxPostTimeSecs")) {
            int n = this._MaxPostTimeSecs;
            this._MaxPostTimeSecs = (Integer)object;
            this._postSet(28, n, this._MaxPostTimeSecs);
            return;
        }
        if (string.equals("Name")) {
            String string9 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string9, this._Name);
            return;
        }
        if (string.equals("OverloadResponseCode")) {
            int n = this._OverloadResponseCode;
            this._OverloadResponseCode = (Integer)object;
            this._postSet(21, n, this._OverloadResponseCode);
            return;
        }
        if (string.equals("PostTimeoutSecs")) {
            int n = this._PostTimeoutSecs;
            this._PostTimeoutSecs = (Integer)object;
            this._postSet(27, n, this._PostTimeoutSecs);
            return;
        }
        if (string.equals("SendServerHeaderEnabled")) {
            boolean bl = this._SendServerHeaderEnabled;
            this._SendServerHeaderEnabled = (Boolean)object;
            this._postSet(30, bl, this._SendServerHeaderEnabled);
            return;
        }
        if (string.equals("SingleSignonDisabled")) {
            boolean bl = this._SingleSignonDisabled;
            this._SingleSignonDisabled = (Boolean)object;
            this._postSet(43, bl, this._SingleSignonDisabled);
            return;
        }
        if (string.equals("URLResource")) {
            Map map = this._URLResource;
            this._URLResource = (Map)object;
            this._postSet(34, map, this._URLResource);
            return;
        }
        if (string.equals("UseHeaderEncoding")) {
            boolean bl = this._UseHeaderEncoding;
            this._UseHeaderEncoding = (Boolean)object;
            this._postSet(37, bl, this._UseHeaderEncoding);
            return;
        }
        if (string.equals("UseHighestCompatibleHTTPVersion")) {
            boolean bl = this._UseHighestCompatibleHTTPVersion;
            this._UseHighestCompatibleHTTPVersion = (Boolean)object;
            this._postSet(36, bl, this._UseHighestCompatibleHTTPVersion);
            return;
        }
        if (string.equals("WAPEnabled")) {
            boolean bl = this._WAPEnabled;
            this._WAPEnabled = (Boolean)object;
            this._postSet(41, bl, this._WAPEnabled);
            return;
        }
        if (string.equals("WebDeployments")) {
            WebDeploymentMBean[] webDeploymentMBeanArray = this._WebDeployments;
            this._WebDeployments = (WebDeploymentMBean[])object;
            this._postSet(44, webDeploymentMBeanArray, this._WebDeployments);
            return;
        }
        if (string.equals("WebServerLog")) {
            WebServerLogMBean webServerLogMBean = this._WebServerLog;
            this._WebServerLog = (WebServerLogMBean)object;
            this._postSet(9, webServerLogMBean, this._WebServerLog);
            return;
        }
        if (string.equals("WorkManagerForRemoteSessionFetching")) {
            String string10 = this._WorkManagerForRemoteSessionFetching;
            this._WorkManagerForRemoteSessionFetching = (String)object;
            this._postSet(47, string10, this._WorkManagerForRemoteSessionFetching);
            return;
        }
        if (string.equals("WriteChunkBytes")) {
            int n = this._WriteChunkBytes;
            this._WriteChunkBytes = (Integer)object;
            this._postSet(39, n, this._WriteChunkBytes);
            return;
        }
        if (string.equals("customizer")) {
            WebServer webServer = this._customizer;
            this._customizer = (WebServer)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("AcceptContextPathInGetRealPath")) {
            return new Boolean(this._AcceptContextPathInGetRealPath);
        }
        if (string.equals("AuthCookieEnabled")) {
            return new Boolean(this._AuthCookieEnabled);
        }
        if (string.equals("Charsets")) {
            return this._Charsets;
        }
        if (string.equals("ChunkedTransferDisabled")) {
            return new Boolean(this._ChunkedTransferDisabled);
        }
        if (string.equals("ClientIpHeader")) {
            return this._ClientIpHeader;
        }
        if (string.equals("DebugEnabled")) {
            return new Boolean(this._DebugEnabled);
        }
        if (string.equals("DefaultWebApp")) {
            return this._DefaultWebApp;
        }
        if (string.equals("DefaultWebAppContextRoot")) {
            return this._DefaultWebAppContextRoot;
        }
        if (string.equals("FrontendHTTPPort")) {
            return new Integer(this._FrontendHTTPPort);
        }
        if (string.equals("FrontendHTTPSPort")) {
            return new Integer(this._FrontendHTTPSPort);
        }
        if (string.equals("FrontendHost")) {
            return this._FrontendHost;
        }
        if (string.equals("HttpsKeepAliveSecs")) {
            return new Integer(this._HttpsKeepAliveSecs);
        }
        if (string.equals("KeepAliveEnabled")) {
            return new Boolean(this._KeepAliveEnabled);
        }
        if (string.equals("KeepAliveSecs")) {
            return new Integer(this._KeepAliveSecs);
        }
        if (string.equals("LogFileBufferKBytes")) {
            return new Integer(this._LogFileBufferKBytes);
        }
        if (string.equals("LogFileCount")) {
            return new Integer(this._LogFileCount);
        }
        if (string.equals("LogFileFlushSecs")) {
            return new Integer(this._LogFileFlushSecs);
        }
        if (string.equals("LogFileFormat")) {
            return this._LogFileFormat;
        }
        if (string.equals("LogFileLimitEnabled")) {
            return new Boolean(this._LogFileLimitEnabled);
        }
        if (string.equals("LogFileName")) {
            return this._LogFileName;
        }
        if (string.equals("LogRotationPeriodMins")) {
            return new Integer(this._LogRotationPeriodMins);
        }
        if (string.equals("LogRotationTimeBegin")) {
            return this._LogRotationTimeBegin;
        }
        if (string.equals("LogRotationType")) {
            return this._LogRotationType;
        }
        if (string.equals("LogTimeInGMT")) {
            return new Boolean(this._LogTimeInGMT);
        }
        if (string.equals("LoggingEnabled")) {
            return new Boolean(this._LoggingEnabled);
        }
        if (string.equals("MaxLogFileSizeKBytes")) {
            return new Integer(this._MaxLogFileSizeKBytes);
        }
        if (string.equals("MaxPostSize")) {
            return new Integer(this._MaxPostSize);
        }
        if (string.equals("MaxPostTimeSecs")) {
            return new Integer(this._MaxPostTimeSecs);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("OverloadResponseCode")) {
            return new Integer(this._OverloadResponseCode);
        }
        if (string.equals("PostTimeoutSecs")) {
            return new Integer(this._PostTimeoutSecs);
        }
        if (string.equals("SendServerHeaderEnabled")) {
            return new Boolean(this._SendServerHeaderEnabled);
        }
        if (string.equals("SingleSignonDisabled")) {
            return new Boolean(this._SingleSignonDisabled);
        }
        if (string.equals("URLResource")) {
            return this._URLResource;
        }
        if (string.equals("UseHeaderEncoding")) {
            return new Boolean(this._UseHeaderEncoding);
        }
        if (string.equals("UseHighestCompatibleHTTPVersion")) {
            return new Boolean(this._UseHighestCompatibleHTTPVersion);
        }
        if (string.equals("WAPEnabled")) {
            return new Boolean(this._WAPEnabled);
        }
        if (string.equals("WebDeployments")) {
            return this._WebDeployments;
        }
        if (string.equals("WebServerLog")) {
            return this._WebServerLog;
        }
        if (string.equals("WorkManagerForRemoteSessionFetching")) {
            return this._WorkManagerForRemoteSessionFetching;
        }
        if (string.equals("WriteChunkBytes")) {
            return new Integer(this._WriteChunkBytes);
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends DeploymentMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 8: {
                    if (!string.equals("charsets")) break;
                    return 33;
                }
                case 16: {
                    if (!string.equals("client-ip-header")) break;
                    return 48;
                }
                case 15: {
                    if (string.equals("default-web-app")) {
                        return 32;
                    }
                    if (string.equals("keep-alive-secs")) {
                        return 25;
                    }
                    if (string.equals("log-file-format")) {
                        return 11;
                    }
                    if (!string.equals("logging-enabled")) break;
                    return 10;
                }
                case 28: {
                    if (!string.equals("default-web-app-context-root")) break;
                    return 31;
                }
                case 17: {
                    if (string.equals("frontendhttp-port")) {
                        return 15;
                    }
                    if (string.equals("log-rotation-type")) {
                        return 19;
                    }
                    if (string.equals("post-timeout-secs")) {
                        return 27;
                    }
                    if (!string.equals("write-chunk-bytes")) break;
                    return 39;
                }
                case 18: {
                    if (string.equals("frontendhttps-port")) {
                        return 16;
                    }
                    if (string.equals("max-post-time-secs")) {
                        return 28;
                    }
                    if (!string.equals("keep-alive-enabled")) break;
                    return 24;
                }
                case 13: {
                    if (string.equals("frontend-host")) {
                        return 14;
                    }
                    if (string.equals("log-file-name")) {
                        return 13;
                    }
                    if (string.equals("max-post-size")) {
                        return 29;
                    }
                    if (!string.equals("debug-enabled")) break;
                    return 40;
                }
                case 21: {
                    if (!string.equals("https-keep-alive-secs")) break;
                    return 26;
                }
                case 22: {
                    if (string.equals("log-file-bufferk-bytes")) {
                        return 17;
                    }
                    if (string.equals("overload-response-code")) {
                        return 21;
                    }
                    if (string.equals("log-file-limit-enabled")) {
                        return 45;
                    }
                    if (!string.equals("single-signon-disabled")) break;
                    return 43;
                }
                case 14: {
                    if (string.equals("log-file-count")) {
                        return 46;
                    }
                    if (string.equals("log-time-ingmt")) {
                        return 12;
                    }
                    if (string.equals("web-deployment")) {
                        return 44;
                    }
                    if (!string.equals("web-server-log")) break;
                    return 9;
                }
                case 19: {
                    if (string.equals("log-file-flush-secs")) {
                        return 22;
                    }
                    if (string.equals("auth-cookie-enabled")) {
                        return 38;
                    }
                    if (!string.equals("use-header-encoding")) break;
                    return 37;
                }
                case 24: {
                    if (string.equals("log-rotation-period-mins")) {
                        return 20;
                    }
                    if (!string.equals("max-log-file-sizek-bytes")) break;
                    return 18;
                }
                case 23: {
                    if (!string.equals("log-rotation-time-begin")) break;
                    return 23;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 12: {
                    if (!string.equals("url-resource")) break;
                    return 34;
                }
                case 40: {
                    if (!string.equals("work-manager-for-remote-session-fetching")) break;
                    return 47;
                }
                case 36: {
                    if (!string.equals("accept-context-path-in-get-real-path")) break;
                    return 42;
                }
                case 25: {
                    if (!string.equals("chunked-transfer-disabled")) break;
                    return 35;
                }
                case 26: {
                    if (!string.equals("send-server-header-enabled")) break;
                    return 30;
                }
                case 34: {
                    if (!string.equals("use-highest-compatiblehttp-version")) break;
                    return 36;
                }
                case 11: {
                    if (!string.equals("wap-enabled")) break;
                    return 41;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 9: {
                    return new WebServerLogMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 33: {
                    return "charsets";
                }
                case 48: {
                    return "client-ip-header";
                }
                case 32: {
                    return "default-web-app";
                }
                case 31: {
                    return "default-web-app-context-root";
                }
                case 15: {
                    return "frontendhttp-port";
                }
                case 16: {
                    return "frontendhttps-port";
                }
                case 14: {
                    return "frontend-host";
                }
                case 26: {
                    return "https-keep-alive-secs";
                }
                case 25: {
                    return "keep-alive-secs";
                }
                case 17: {
                    return "log-file-bufferk-bytes";
                }
                case 46: {
                    return "log-file-count";
                }
                case 22: {
                    return "log-file-flush-secs";
                }
                case 11: {
                    return "log-file-format";
                }
                case 13: {
                    return "log-file-name";
                }
                case 20: {
                    return "log-rotation-period-mins";
                }
                case 23: {
                    return "log-rotation-time-begin";
                }
                case 19: {
                    return "log-rotation-type";
                }
                case 12: {
                    return "log-time-ingmt";
                }
                case 18: {
                    return "max-log-file-sizek-bytes";
                }
                case 29: {
                    return "max-post-size";
                }
                case 28: {
                    return "max-post-time-secs";
                }
                case 2: {
                    return "name";
                }
                case 21: {
                    return "overload-response-code";
                }
                case 27: {
                    return "post-timeout-secs";
                }
                case 34: {
                    return "url-resource";
                }
                case 44: {
                    return "web-deployment";
                }
                case 9: {
                    return "web-server-log";
                }
                case 47: {
                    return "work-manager-for-remote-session-fetching";
                }
                case 39: {
                    return "write-chunk-bytes";
                }
                case 42: {
                    return "accept-context-path-in-get-real-path";
                }
                case 38: {
                    return "auth-cookie-enabled";
                }
                case 35: {
                    return "chunked-transfer-disabled";
                }
                case 40: {
                    return "debug-enabled";
                }
                case 24: {
                    return "keep-alive-enabled";
                }
                case 45: {
                    return "log-file-limit-enabled";
                }
                case 10: {
                    return "logging-enabled";
                }
                case 30: {
                    return "send-server-header-enabled";
                }
                case 43: {
                    return "single-signon-disabled";
                }
                case 37: {
                    return "use-header-encoding";
                }
                case 36: {
                    return "use-highest-compatiblehttp-version";
                }
                case 41: {
                    return "wap-enabled";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 7: {
                    return true;
                }
                case 44: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 9: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isConfigurable(int n) {
            switch (n) {
                case 48: {
                    return true;
                }
                case 32: {
                    return true;
                }
                case 31: {
                    return true;
                }
                case 15: {
                    return true;
                }
                case 16: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 17: {
                    return true;
                }
                case 22: {
                    return true;
                }
                case 11: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 20: {
                    return true;
                }
                case 23: {
                    return true;
                }
                case 19: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 18: {
                    return true;
                }
                case 21: {
                    return true;
                }
                case 47: {
                    return true;
                }
                case 38: {
                    return true;
                }
                case 35: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 37: {
                    return true;
                }
                case 36: {
                    return true;
                }
            }
            return super.isConfigurable(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends DeploymentMBeanImpl.Helper {
        private WebServerMBeanImpl bean;

        protected Helper(WebServerMBeanImpl webServerMBeanImpl) {
            super(webServerMBeanImpl);
            this.bean = webServerMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 33: {
                    return "Charsets";
                }
                case 48: {
                    return "ClientIpHeader";
                }
                case 32: {
                    return "DefaultWebApp";
                }
                case 31: {
                    return "DefaultWebAppContextRoot";
                }
                case 15: {
                    return "FrontendHTTPPort";
                }
                case 16: {
                    return "FrontendHTTPSPort";
                }
                case 14: {
                    return "FrontendHost";
                }
                case 26: {
                    return "HttpsKeepAliveSecs";
                }
                case 25: {
                    return "KeepAliveSecs";
                }
                case 17: {
                    return "LogFileBufferKBytes";
                }
                case 46: {
                    return "LogFileCount";
                }
                case 22: {
                    return "LogFileFlushSecs";
                }
                case 11: {
                    return "LogFileFormat";
                }
                case 13: {
                    return "LogFileName";
                }
                case 20: {
                    return "LogRotationPeriodMins";
                }
                case 23: {
                    return "LogRotationTimeBegin";
                }
                case 19: {
                    return "LogRotationType";
                }
                case 12: {
                    return "LogTimeInGMT";
                }
                case 18: {
                    return "MaxLogFileSizeKBytes";
                }
                case 29: {
                    return "MaxPostSize";
                }
                case 28: {
                    return "MaxPostTimeSecs";
                }
                case 2: {
                    return "Name";
                }
                case 21: {
                    return "OverloadResponseCode";
                }
                case 27: {
                    return "PostTimeoutSecs";
                }
                case 34: {
                    return "URLResource";
                }
                case 44: {
                    return "WebDeployments";
                }
                case 9: {
                    return "WebServerLog";
                }
                case 47: {
                    return "WorkManagerForRemoteSessionFetching";
                }
                case 39: {
                    return "WriteChunkBytes";
                }
                case 42: {
                    return "AcceptContextPathInGetRealPath";
                }
                case 38: {
                    return "AuthCookieEnabled";
                }
                case 35: {
                    return "ChunkedTransferDisabled";
                }
                case 40: {
                    return "DebugEnabled";
                }
                case 24: {
                    return "KeepAliveEnabled";
                }
                case 45: {
                    return "LogFileLimitEnabled";
                }
                case 10: {
                    return "LoggingEnabled";
                }
                case 30: {
                    return "SendServerHeaderEnabled";
                }
                case 43: {
                    return "SingleSignonDisabled";
                }
                case 37: {
                    return "UseHeaderEncoding";
                }
                case 36: {
                    return "UseHighestCompatibleHTTPVersion";
                }
                case 41: {
                    return "WAPEnabled";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("Charsets")) {
                return 33;
            }
            if (string.equals("ClientIpHeader")) {
                return 48;
            }
            if (string.equals("DefaultWebApp")) {
                return 32;
            }
            if (string.equals("DefaultWebAppContextRoot")) {
                return 31;
            }
            if (string.equals("FrontendHTTPPort")) {
                return 15;
            }
            if (string.equals("FrontendHTTPSPort")) {
                return 16;
            }
            if (string.equals("FrontendHost")) {
                return 14;
            }
            if (string.equals("HttpsKeepAliveSecs")) {
                return 26;
            }
            if (string.equals("KeepAliveSecs")) {
                return 25;
            }
            if (string.equals("LogFileBufferKBytes")) {
                return 17;
            }
            if (string.equals("LogFileCount")) {
                return 46;
            }
            if (string.equals("LogFileFlushSecs")) {
                return 22;
            }
            if (string.equals("LogFileFormat")) {
                return 11;
            }
            if (string.equals("LogFileName")) {
                return 13;
            }
            if (string.equals("LogRotationPeriodMins")) {
                return 20;
            }
            if (string.equals("LogRotationTimeBegin")) {
                return 23;
            }
            if (string.equals("LogRotationType")) {
                return 19;
            }
            if (string.equals("LogTimeInGMT")) {
                return 12;
            }
            if (string.equals("MaxLogFileSizeKBytes")) {
                return 18;
            }
            if (string.equals("MaxPostSize")) {
                return 29;
            }
            if (string.equals("MaxPostTimeSecs")) {
                return 28;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("OverloadResponseCode")) {
                return 21;
            }
            if (string.equals("PostTimeoutSecs")) {
                return 27;
            }
            if (string.equals("URLResource")) {
                return 34;
            }
            if (string.equals("WebDeployments")) {
                return 44;
            }
            if (string.equals("WebServerLog")) {
                return 9;
            }
            if (string.equals("WorkManagerForRemoteSessionFetching")) {
                return 47;
            }
            if (string.equals("WriteChunkBytes")) {
                return 39;
            }
            if (string.equals("AcceptContextPathInGetRealPath")) {
                return 42;
            }
            if (string.equals("AuthCookieEnabled")) {
                return 38;
            }
            if (string.equals("ChunkedTransferDisabled")) {
                return 35;
            }
            if (string.equals("DebugEnabled")) {
                return 40;
            }
            if (string.equals("KeepAliveEnabled")) {
                return 24;
            }
            if (string.equals("LogFileLimitEnabled")) {
                return 45;
            }
            if (string.equals("LoggingEnabled")) {
                return 10;
            }
            if (string.equals("SendServerHeaderEnabled")) {
                return 30;
            }
            if (string.equals("SingleSignonDisabled")) {
                return 43;
            }
            if (string.equals("UseHeaderEncoding")) {
                return 37;
            }
            if (string.equals("UseHighestCompatibleHTTPVersion")) {
                return 36;
            }
            if (string.equals("WAPEnabled")) {
                return 41;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            if (this.bean.getWebServerLog() != null) {
                arrayList.add(new ArrayIterator((Object[])new WebServerLogMBean[]{this.bean.getWebServerLog()}));
            }
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isCharsetsSet()) {
                    stringBuffer.append("Charsets");
                    stringBuffer.append(String.valueOf(this.bean.getCharsets()));
                }
                if (this.bean.isClientIpHeaderSet()) {
                    stringBuffer.append("ClientIpHeader");
                    stringBuffer.append(String.valueOf(this.bean.getClientIpHeader()));
                }
                if (this.bean.isDefaultWebAppSet()) {
                    stringBuffer.append("DefaultWebApp");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultWebApp()));
                }
                if (this.bean.isDefaultWebAppContextRootSet()) {
                    stringBuffer.append("DefaultWebAppContextRoot");
                    stringBuffer.append(String.valueOf(this.bean.getDefaultWebAppContextRoot()));
                }
                if (this.bean.isFrontendHTTPPortSet()) {
                    stringBuffer.append("FrontendHTTPPort");
                    stringBuffer.append(String.valueOf(this.bean.getFrontendHTTPPort()));
                }
                if (this.bean.isFrontendHTTPSPortSet()) {
                    stringBuffer.append("FrontendHTTPSPort");
                    stringBuffer.append(String.valueOf(this.bean.getFrontendHTTPSPort()));
                }
                if (this.bean.isFrontendHostSet()) {
                    stringBuffer.append("FrontendHost");
                    stringBuffer.append(String.valueOf(this.bean.getFrontendHost()));
                }
                if (this.bean.isHttpsKeepAliveSecsSet()) {
                    stringBuffer.append("HttpsKeepAliveSecs");
                    stringBuffer.append(String.valueOf(this.bean.getHttpsKeepAliveSecs()));
                }
                if (this.bean.isKeepAliveSecsSet()) {
                    stringBuffer.append("KeepAliveSecs");
                    stringBuffer.append(String.valueOf(this.bean.getKeepAliveSecs()));
                }
                if (this.bean.isLogFileBufferKBytesSet()) {
                    stringBuffer.append("LogFileBufferKBytes");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileBufferKBytes()));
                }
                if (this.bean.isLogFileCountSet()) {
                    stringBuffer.append("LogFileCount");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileCount()));
                }
                if (this.bean.isLogFileFlushSecsSet()) {
                    stringBuffer.append("LogFileFlushSecs");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileFlushSecs()));
                }
                if (this.bean.isLogFileFormatSet()) {
                    stringBuffer.append("LogFileFormat");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileFormat()));
                }
                if (this.bean.isLogFileNameSet()) {
                    stringBuffer.append("LogFileName");
                    stringBuffer.append(String.valueOf(this.bean.getLogFileName()));
                }
                if (this.bean.isLogRotationPeriodMinsSet()) {
                    stringBuffer.append("LogRotationPeriodMins");
                    stringBuffer.append(String.valueOf(this.bean.getLogRotationPeriodMins()));
                }
                if (this.bean.isLogRotationTimeBeginSet()) {
                    stringBuffer.append("LogRotationTimeBegin");
                    stringBuffer.append(String.valueOf(this.bean.getLogRotationTimeBegin()));
                }
                if (this.bean.isLogRotationTypeSet()) {
                    stringBuffer.append("LogRotationType");
                    stringBuffer.append(String.valueOf(this.bean.getLogRotationType()));
                }
                if (this.bean.isLogTimeInGMTSet()) {
                    stringBuffer.append("LogTimeInGMT");
                    stringBuffer.append(String.valueOf(this.bean.getLogTimeInGMT()));
                }
                if (this.bean.isMaxLogFileSizeKBytesSet()) {
                    stringBuffer.append("MaxLogFileSizeKBytes");
                    stringBuffer.append(String.valueOf(this.bean.getMaxLogFileSizeKBytes()));
                }
                if (this.bean.isMaxPostSizeSet()) {
                    stringBuffer.append("MaxPostSize");
                    stringBuffer.append(String.valueOf(this.bean.getMaxPostSize()));
                }
                if (this.bean.isMaxPostTimeSecsSet()) {
                    stringBuffer.append("MaxPostTimeSecs");
                    stringBuffer.append(String.valueOf(this.bean.getMaxPostTimeSecs()));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isOverloadResponseCodeSet()) {
                    stringBuffer.append("OverloadResponseCode");
                    stringBuffer.append(String.valueOf(this.bean.getOverloadResponseCode()));
                }
                if (this.bean.isPostTimeoutSecsSet()) {
                    stringBuffer.append("PostTimeoutSecs");
                    stringBuffer.append(String.valueOf(this.bean.getPostTimeoutSecs()));
                }
                if (this.bean.isURLResourceSet()) {
                    stringBuffer.append("URLResource");
                    stringBuffer.append(String.valueOf(this.bean.getURLResource()));
                }
                if (this.bean.isWebDeploymentsSet()) {
                    stringBuffer.append("WebDeployments");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getWebDeployments())));
                }
                if ((l2 = this.computeChildHashValue(this.bean.getWebServerLog())) != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isWorkManagerForRemoteSessionFetchingSet()) {
                    stringBuffer.append("WorkManagerForRemoteSessionFetching");
                    stringBuffer.append(String.valueOf(this.bean.getWorkManagerForRemoteSessionFetching()));
                }
                if (this.bean.isWriteChunkBytesSet()) {
                    stringBuffer.append("WriteChunkBytes");
                    stringBuffer.append(String.valueOf(this.bean.getWriteChunkBytes()));
                }
                if (this.bean.isAcceptContextPathInGetRealPathSet()) {
                    stringBuffer.append("AcceptContextPathInGetRealPath");
                    stringBuffer.append(String.valueOf(this.bean.isAcceptContextPathInGetRealPath()));
                }
                if (this.bean.isAuthCookieEnabledSet()) {
                    stringBuffer.append("AuthCookieEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isAuthCookieEnabled()));
                }
                if (this.bean.isChunkedTransferDisabledSet()) {
                    stringBuffer.append("ChunkedTransferDisabled");
                    stringBuffer.append(String.valueOf(this.bean.isChunkedTransferDisabled()));
                }
                if (this.bean.isDebugEnabledSet()) {
                    stringBuffer.append("DebugEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isDebugEnabled()));
                }
                if (this.bean.isKeepAliveEnabledSet()) {
                    stringBuffer.append("KeepAliveEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isKeepAliveEnabled()));
                }
                if (this.bean.isLogFileLimitEnabledSet()) {
                    stringBuffer.append("LogFileLimitEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isLogFileLimitEnabled()));
                }
                if (this.bean.isLoggingEnabledSet()) {
                    stringBuffer.append("LoggingEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isLoggingEnabled()));
                }
                if (this.bean.isSendServerHeaderEnabledSet()) {
                    stringBuffer.append("SendServerHeaderEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isSendServerHeaderEnabled()));
                }
                if (this.bean.isSingleSignonDisabledSet()) {
                    stringBuffer.append("SingleSignonDisabled");
                    stringBuffer.append(String.valueOf(this.bean.isSingleSignonDisabled()));
                }
                if (this.bean.isUseHeaderEncodingSet()) {
                    stringBuffer.append("UseHeaderEncoding");
                    stringBuffer.append(String.valueOf(this.bean.isUseHeaderEncoding()));
                }
                if (this.bean.isUseHighestCompatibleHTTPVersionSet()) {
                    stringBuffer.append("UseHighestCompatibleHTTPVersion");
                    stringBuffer.append(String.valueOf(this.bean.isUseHighestCompatibleHTTPVersion()));
                }
                if (this.bean.isWAPEnabledSet()) {
                    stringBuffer.append("WAPEnabled");
                    stringBuffer.append(String.valueOf(this.bean.isWAPEnabled()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                WebServerMBeanImpl webServerMBeanImpl = (WebServerMBeanImpl)abstractDescriptorBean;
                this.computeDiff("Charsets", this.bean.getCharsets(), webServerMBeanImpl.getCharsets(), true);
                this.computeDiff("ClientIpHeader", this.bean.getClientIpHeader(), webServerMBeanImpl.getClientIpHeader(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DefaultWebApp", this.bean.getDefaultWebApp(), webServerMBeanImpl.getDefaultWebApp(), true);
                }
                this.computeDiff("DefaultWebAppContextRoot", this.bean.getDefaultWebAppContextRoot(), webServerMBeanImpl.getDefaultWebAppContextRoot(), true);
                this.computeDiff("FrontendHTTPPort", this.bean.getFrontendHTTPPort(), webServerMBeanImpl.getFrontendHTTPPort(), true);
                this.computeDiff("FrontendHTTPSPort", this.bean.getFrontendHTTPSPort(), webServerMBeanImpl.getFrontendHTTPSPort(), true);
                this.computeDiff("FrontendHost", this.bean.getFrontendHost(), webServerMBeanImpl.getFrontendHost(), true);
                this.computeDiff("HttpsKeepAliveSecs", this.bean.getHttpsKeepAliveSecs(), webServerMBeanImpl.getHttpsKeepAliveSecs(), true);
                this.computeDiff("KeepAliveSecs", this.bean.getKeepAliveSecs(), webServerMBeanImpl.getKeepAliveSecs(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogFileBufferKBytes", this.bean.getLogFileBufferKBytes(), webServerMBeanImpl.getLogFileBufferKBytes(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogFileCount", this.bean.getLogFileCount(), webServerMBeanImpl.getLogFileCount(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogFileFlushSecs", this.bean.getLogFileFlushSecs(), webServerMBeanImpl.getLogFileFlushSecs(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogFileFormat", this.bean.getLogFileFormat(), webServerMBeanImpl.getLogFileFormat(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogFileName", this.bean.getLogFileName(), webServerMBeanImpl.getLogFileName(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogRotationPeriodMins", this.bean.getLogRotationPeriodMins(), webServerMBeanImpl.getLogRotationPeriodMins(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogRotationTimeBegin", this.bean.getLogRotationTimeBegin(), webServerMBeanImpl.getLogRotationTimeBegin(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogRotationType", this.bean.getLogRotationType(), webServerMBeanImpl.getLogRotationType(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogTimeInGMT", this.bean.getLogTimeInGMT(), webServerMBeanImpl.getLogTimeInGMT(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("MaxLogFileSizeKBytes", this.bean.getMaxLogFileSizeKBytes(), webServerMBeanImpl.getMaxLogFileSizeKBytes(), false);
                }
                this.computeDiff("MaxPostSize", this.bean.getMaxPostSize(), webServerMBeanImpl.getMaxPostSize(), true);
                this.computeDiff("MaxPostTimeSecs", this.bean.getMaxPostTimeSecs(), webServerMBeanImpl.getMaxPostTimeSecs(), true);
                this.computeDiff("Name", this.bean.getName(), webServerMBeanImpl.getName(), false);
                this.computeDiff("OverloadResponseCode", this.bean.getOverloadResponseCode(), webServerMBeanImpl.getOverloadResponseCode(), true);
                this.computeDiff("PostTimeoutSecs", this.bean.getPostTimeoutSecs(), webServerMBeanImpl.getPostTimeoutSecs(), true);
                this.computeDiff("URLResource", this.bean.getURLResource(), webServerMBeanImpl.getURLResource(), true);
                this.computeDiff("WebDeployments", this.bean.getWebDeployments(), webServerMBeanImpl.getWebDeployments(), true);
                this.computeSubDiff("WebServerLog", this.bean.getWebServerLog(), webServerMBeanImpl.getWebServerLog());
                this.computeDiff("WorkManagerForRemoteSessionFetching", this.bean.getWorkManagerForRemoteSessionFetching(), webServerMBeanImpl.getWorkManagerForRemoteSessionFetching(), false);
                this.computeDiff("WriteChunkBytes", this.bean.getWriteChunkBytes(), webServerMBeanImpl.getWriteChunkBytes(), true);
                this.computeDiff("AcceptContextPathInGetRealPath", this.bean.isAcceptContextPathInGetRealPath(), webServerMBeanImpl.isAcceptContextPathInGetRealPath(), false);
                this.computeDiff("AuthCookieEnabled", this.bean.isAuthCookieEnabled(), webServerMBeanImpl.isAuthCookieEnabled(), true);
                this.computeDiff("ChunkedTransferDisabled", this.bean.isChunkedTransferDisabled(), webServerMBeanImpl.isChunkedTransferDisabled(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("DebugEnabled", this.bean.isDebugEnabled(), webServerMBeanImpl.isDebugEnabled(), false);
                }
                this.computeDiff("KeepAliveEnabled", this.bean.isKeepAliveEnabled(), webServerMBeanImpl.isKeepAliveEnabled(), true);
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LogFileLimitEnabled", this.bean.isLogFileLimitEnabled(), webServerMBeanImpl.isLogFileLimitEnabled(), false);
                }
                if (BootstrapProperties.INCLUDE_OBSOLETE_PROPS_IN_DIFF) {
                    this.computeDiff("LoggingEnabled", this.bean.isLoggingEnabled(), webServerMBeanImpl.isLoggingEnabled(), false);
                }
                this.computeDiff("SendServerHeaderEnabled", this.bean.isSendServerHeaderEnabled(), webServerMBeanImpl.isSendServerHeaderEnabled(), true);
                this.computeDiff("SingleSignonDisabled", this.bean.isSingleSignonDisabled(), webServerMBeanImpl.isSingleSignonDisabled(), true);
                this.computeDiff("UseHeaderEncoding", this.bean.isUseHeaderEncoding(), webServerMBeanImpl.isUseHeaderEncoding(), true);
                this.computeDiff("UseHighestCompatibleHTTPVersion", this.bean.isUseHighestCompatibleHTTPVersion(), webServerMBeanImpl.isUseHighestCompatibleHTTPVersion(), true);
                this.computeDiff("WAPEnabled", this.bean.isWAPEnabled(), webServerMBeanImpl.isWAPEnabled(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                WebServerMBeanImpl webServerMBeanImpl = (WebServerMBeanImpl)beanUpdateEvent.getSourceBean();
                WebServerMBeanImpl webServerMBeanImpl2 = (WebServerMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("Charsets")) {
                    webServerMBeanImpl.setCharsets(webServerMBeanImpl2.getCharsets());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 33);
                } else if (string.equals("ClientIpHeader")) {
                    webServerMBeanImpl.setClientIpHeader(webServerMBeanImpl2.getClientIpHeader());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 48);
                } else if (string.equals("DefaultWebApp")) {
                    webServerMBeanImpl.setDefaultWebAppAsString(webServerMBeanImpl2.getDefaultWebAppAsString());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 32);
                } else if (string.equals("DefaultWebAppContextRoot")) {
                    webServerMBeanImpl.setDefaultWebAppContextRoot(webServerMBeanImpl2.getDefaultWebAppContextRoot());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 31);
                } else if (string.equals("FrontendHTTPPort")) {
                    webServerMBeanImpl.setFrontendHTTPPort(webServerMBeanImpl2.getFrontendHTTPPort());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                } else if (string.equals("FrontendHTTPSPort")) {
                    webServerMBeanImpl.setFrontendHTTPSPort(webServerMBeanImpl2.getFrontendHTTPSPort());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                } else if (string.equals("FrontendHost")) {
                    webServerMBeanImpl.setFrontendHost(webServerMBeanImpl2.getFrontendHost());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                } else if (string.equals("HttpsKeepAliveSecs")) {
                    webServerMBeanImpl.setHttpsKeepAliveSecs(webServerMBeanImpl2.getHttpsKeepAliveSecs());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 26);
                } else if (string.equals("KeepAliveSecs")) {
                    webServerMBeanImpl.setKeepAliveSecs(webServerMBeanImpl2.getKeepAliveSecs());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 25);
                } else if (string.equals("LogFileBufferKBytes")) {
                    webServerMBeanImpl.setLogFileBufferKBytes(webServerMBeanImpl2.getLogFileBufferKBytes());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 17);
                } else if (string.equals("LogFileCount")) {
                    webServerMBeanImpl.setLogFileCount(webServerMBeanImpl2.getLogFileCount());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 46);
                } else if (string.equals("LogFileFlushSecs")) {
                    webServerMBeanImpl.setLogFileFlushSecs(webServerMBeanImpl2.getLogFileFlushSecs());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 22);
                } else if (string.equals("LogFileFormat")) {
                    webServerMBeanImpl.setLogFileFormat(webServerMBeanImpl2.getLogFileFormat());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                } else if (string.equals("LogFileName")) {
                    webServerMBeanImpl.setLogFileName(webServerMBeanImpl2.getLogFileName());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 13);
                } else if (string.equals("LogRotationPeriodMins")) {
                    webServerMBeanImpl.setLogRotationPeriodMins(webServerMBeanImpl2.getLogRotationPeriodMins());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 20);
                } else if (string.equals("LogRotationTimeBegin")) {
                    webServerMBeanImpl.setLogRotationTimeBegin(webServerMBeanImpl2.getLogRotationTimeBegin());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 23);
                } else if (string.equals("LogRotationType")) {
                    webServerMBeanImpl.setLogRotationType(webServerMBeanImpl2.getLogRotationType());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 19);
                } else if (string.equals("LogTimeInGMT")) {
                    webServerMBeanImpl.setLogTimeInGMT(webServerMBeanImpl2.getLogTimeInGMT());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 12);
                } else if (string.equals("MaxLogFileSizeKBytes")) {
                    webServerMBeanImpl.setMaxLogFileSizeKBytes(webServerMBeanImpl2.getMaxLogFileSizeKBytes());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 18);
                } else if (string.equals("MaxPostSize")) {
                    webServerMBeanImpl.setMaxPostSize(webServerMBeanImpl2.getMaxPostSize());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 29);
                } else if (string.equals("MaxPostTimeSecs")) {
                    webServerMBeanImpl.setMaxPostTimeSecs(webServerMBeanImpl2.getMaxPostTimeSecs());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 28);
                } else if (string.equals("Name")) {
                    webServerMBeanImpl.setName(webServerMBeanImpl2.getName());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                } else if (string.equals("OverloadResponseCode")) {
                    webServerMBeanImpl.setOverloadResponseCode(webServerMBeanImpl2.getOverloadResponseCode());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 21);
                } else if (string.equals("PostTimeoutSecs")) {
                    webServerMBeanImpl.setPostTimeoutSecs(webServerMBeanImpl2.getPostTimeoutSecs());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 27);
                } else if (string.equals("URLResource")) {
                    webServerMBeanImpl.setURLResource(webServerMBeanImpl2.getURLResource());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 34);
                } else if (string.equals("WebDeployments")) {
                    webServerMBeanImpl.setWebDeploymentsAsString(webServerMBeanImpl2.getWebDeploymentsAsString());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 44);
                } else if (string.equals("WebServerLog")) {
                    if (n == 2) {
                        webServerMBeanImpl.setWebServerLog((WebServerLogMBean)this.createCopy((AbstractDescriptorBean)webServerMBeanImpl2.getWebServerLog()));
                    } else if (n == 3) {
                        webServerMBeanImpl._destroySingleton("WebServerLog", webServerMBeanImpl.getWebServerLog());
                    } else {
                        throw new AssertionError((Object)("Invalid type: " + n));
                    }
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                } else if (string.equals("WorkManagerForRemoteSessionFetching")) {
                    webServerMBeanImpl.setWorkManagerForRemoteSessionFetching(webServerMBeanImpl2.getWorkManagerForRemoteSessionFetching());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 47);
                } else if (string.equals("WriteChunkBytes")) {
                    webServerMBeanImpl.setWriteChunkBytes(webServerMBeanImpl2.getWriteChunkBytes());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 39);
                } else if (string.equals("AcceptContextPathInGetRealPath")) {
                    webServerMBeanImpl.setAcceptContextPathInGetRealPath(webServerMBeanImpl2.isAcceptContextPathInGetRealPath());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 42);
                } else if (string.equals("AuthCookieEnabled")) {
                    webServerMBeanImpl.setAuthCookieEnabled(webServerMBeanImpl2.isAuthCookieEnabled());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 38);
                } else if (string.equals("ChunkedTransferDisabled")) {
                    webServerMBeanImpl.setChunkedTransferDisabled(webServerMBeanImpl2.isChunkedTransferDisabled());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 35);
                } else if (string.equals("DebugEnabled")) {
                    webServerMBeanImpl.setDebugEnabled(webServerMBeanImpl2.isDebugEnabled());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 40);
                } else if (string.equals("KeepAliveEnabled")) {
                    webServerMBeanImpl.setKeepAliveEnabled(webServerMBeanImpl2.isKeepAliveEnabled());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 24);
                } else if (string.equals("LogFileLimitEnabled")) {
                    webServerMBeanImpl.setLogFileLimitEnabled(webServerMBeanImpl2.isLogFileLimitEnabled());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 45);
                } else if (string.equals("LoggingEnabled")) {
                    webServerMBeanImpl.setLoggingEnabled(webServerMBeanImpl2.isLoggingEnabled());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 10);
                } else if (string.equals("SendServerHeaderEnabled")) {
                    webServerMBeanImpl.setSendServerHeaderEnabled(webServerMBeanImpl2.isSendServerHeaderEnabled());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 30);
                } else if (string.equals("SingleSignonDisabled")) {
                    webServerMBeanImpl.setSingleSignonDisabled(webServerMBeanImpl2.isSingleSignonDisabled());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 43);
                } else if (string.equals("UseHeaderEncoding")) {
                    webServerMBeanImpl.setUseHeaderEncoding(webServerMBeanImpl2.isUseHeaderEncoding());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 37);
                } else if (string.equals("UseHighestCompatibleHTTPVersion")) {
                    webServerMBeanImpl.setUseHighestCompatibleHTTPVersion(webServerMBeanImpl2.isUseHighestCompatibleHTTPVersion());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 36);
                } else if (string.equals("WAPEnabled")) {
                    webServerMBeanImpl.setWAPEnabled(webServerMBeanImpl2.isWAPEnabled());
                    webServerMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 41);
                } else {
                    super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                WebServerMBeanImpl webServerMBeanImpl = (WebServerMBeanImpl)abstractDescriptorBean;
                super.finishCopy(webServerMBeanImpl, bl, list);
                if ((list == null || !list.contains("Charsets")) && this.bean.isCharsetsSet()) {
                    webServerMBeanImpl.setCharsets(this.bean.getCharsets());
                }
                if ((list == null || !list.contains("ClientIpHeader")) && this.bean.isClientIpHeaderSet()) {
                    webServerMBeanImpl.setClientIpHeader(this.bean.getClientIpHeader());
                }
                if (bl && (list == null || !list.contains("DefaultWebApp")) && this.bean.isDefaultWebAppSet()) {
                    webServerMBeanImpl._unSet(webServerMBeanImpl, 32);
                    webServerMBeanImpl.setDefaultWebAppAsString(this.bean.getDefaultWebAppAsString());
                }
                if ((list == null || !list.contains("DefaultWebAppContextRoot")) && this.bean.isDefaultWebAppContextRootSet()) {
                    webServerMBeanImpl.setDefaultWebAppContextRoot(this.bean.getDefaultWebAppContextRoot());
                }
                if ((list == null || !list.contains("FrontendHTTPPort")) && this.bean.isFrontendHTTPPortSet()) {
                    webServerMBeanImpl.setFrontendHTTPPort(this.bean.getFrontendHTTPPort());
                }
                if ((list == null || !list.contains("FrontendHTTPSPort")) && this.bean.isFrontendHTTPSPortSet()) {
                    webServerMBeanImpl.setFrontendHTTPSPort(this.bean.getFrontendHTTPSPort());
                }
                if ((list == null || !list.contains("FrontendHost")) && this.bean.isFrontendHostSet()) {
                    webServerMBeanImpl.setFrontendHost(this.bean.getFrontendHost());
                }
                if ((list == null || !list.contains("HttpsKeepAliveSecs")) && this.bean.isHttpsKeepAliveSecsSet()) {
                    webServerMBeanImpl.setHttpsKeepAliveSecs(this.bean.getHttpsKeepAliveSecs());
                }
                if ((list == null || !list.contains("KeepAliveSecs")) && this.bean.isKeepAliveSecsSet()) {
                    webServerMBeanImpl.setKeepAliveSecs(this.bean.getKeepAliveSecs());
                }
                if (bl && (list == null || !list.contains("LogFileBufferKBytes")) && this.bean.isLogFileBufferKBytesSet()) {
                    webServerMBeanImpl.setLogFileBufferKBytes(this.bean.getLogFileBufferKBytes());
                }
                if (bl && (list == null || !list.contains("LogFileCount")) && this.bean.isLogFileCountSet()) {
                    webServerMBeanImpl.setLogFileCount(this.bean.getLogFileCount());
                }
                if (bl && (list == null || !list.contains("LogFileFlushSecs")) && this.bean.isLogFileFlushSecsSet()) {
                    webServerMBeanImpl.setLogFileFlushSecs(this.bean.getLogFileFlushSecs());
                }
                if (bl && (list == null || !list.contains("LogFileFormat")) && this.bean.isLogFileFormatSet()) {
                    webServerMBeanImpl.setLogFileFormat(this.bean.getLogFileFormat());
                }
                if (bl && (list == null || !list.contains("LogFileName")) && this.bean.isLogFileNameSet()) {
                    webServerMBeanImpl.setLogFileName(this.bean.getLogFileName());
                }
                if (bl && (list == null || !list.contains("LogRotationPeriodMins")) && this.bean.isLogRotationPeriodMinsSet()) {
                    webServerMBeanImpl.setLogRotationPeriodMins(this.bean.getLogRotationPeriodMins());
                }
                if (bl && (list == null || !list.contains("LogRotationTimeBegin")) && this.bean.isLogRotationTimeBeginSet()) {
                    webServerMBeanImpl.setLogRotationTimeBegin(this.bean.getLogRotationTimeBegin());
                }
                if (bl && (list == null || !list.contains("LogRotationType")) && this.bean.isLogRotationTypeSet()) {
                    webServerMBeanImpl.setLogRotationType(this.bean.getLogRotationType());
                }
                if (bl && (list == null || !list.contains("LogTimeInGMT")) && this.bean.isLogTimeInGMTSet()) {
                    webServerMBeanImpl.setLogTimeInGMT(this.bean.getLogTimeInGMT());
                }
                if (bl && (list == null || !list.contains("MaxLogFileSizeKBytes")) && this.bean.isMaxLogFileSizeKBytesSet()) {
                    webServerMBeanImpl.setMaxLogFileSizeKBytes(this.bean.getMaxLogFileSizeKBytes());
                }
                if ((list == null || !list.contains("MaxPostSize")) && this.bean.isMaxPostSizeSet()) {
                    webServerMBeanImpl.setMaxPostSize(this.bean.getMaxPostSize());
                }
                if ((list == null || !list.contains("MaxPostTimeSecs")) && this.bean.isMaxPostTimeSecsSet()) {
                    webServerMBeanImpl.setMaxPostTimeSecs(this.bean.getMaxPostTimeSecs());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    webServerMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("OverloadResponseCode")) && this.bean.isOverloadResponseCodeSet()) {
                    webServerMBeanImpl.setOverloadResponseCode(this.bean.getOverloadResponseCode());
                }
                if ((list == null || !list.contains("PostTimeoutSecs")) && this.bean.isPostTimeoutSecsSet()) {
                    webServerMBeanImpl.setPostTimeoutSecs(this.bean.getPostTimeoutSecs());
                }
                if ((list == null || !list.contains("URLResource")) && this.bean.isURLResourceSet()) {
                    webServerMBeanImpl.setURLResource(this.bean.getURLResource());
                }
                if ((list == null || !list.contains("WebDeployments")) && this.bean.isWebDeploymentsSet()) {
                    webServerMBeanImpl._unSet(webServerMBeanImpl, 44);
                    webServerMBeanImpl.setWebDeploymentsAsString(this.bean.getWebDeploymentsAsString());
                }
                if (!(list != null && list.contains("WebServerLog") || !this.bean.isWebServerLogSet() || webServerMBeanImpl._isSet(9))) {
                    WebServerLogMBean webServerLogMBean = this.bean.getWebServerLog();
                    webServerMBeanImpl.setWebServerLog(null);
                    webServerMBeanImpl.setWebServerLog(webServerLogMBean == null ? null : (WebServerLogMBean)this.createCopy((AbstractDescriptorBean)webServerLogMBean, bl));
                }
                if ((list == null || !list.contains("WorkManagerForRemoteSessionFetching")) && this.bean.isWorkManagerForRemoteSessionFetchingSet()) {
                    webServerMBeanImpl.setWorkManagerForRemoteSessionFetching(this.bean.getWorkManagerForRemoteSessionFetching());
                }
                if ((list == null || !list.contains("WriteChunkBytes")) && this.bean.isWriteChunkBytesSet()) {
                    webServerMBeanImpl.setWriteChunkBytes(this.bean.getWriteChunkBytes());
                }
                if ((list == null || !list.contains("AcceptContextPathInGetRealPath")) && this.bean.isAcceptContextPathInGetRealPathSet()) {
                    webServerMBeanImpl.setAcceptContextPathInGetRealPath(this.bean.isAcceptContextPathInGetRealPath());
                }
                if ((list == null || !list.contains("AuthCookieEnabled")) && this.bean.isAuthCookieEnabledSet()) {
                    webServerMBeanImpl.setAuthCookieEnabled(this.bean.isAuthCookieEnabled());
                }
                if ((list == null || !list.contains("ChunkedTransferDisabled")) && this.bean.isChunkedTransferDisabledSet()) {
                    webServerMBeanImpl.setChunkedTransferDisabled(this.bean.isChunkedTransferDisabled());
                }
                if (bl && (list == null || !list.contains("DebugEnabled")) && this.bean.isDebugEnabledSet()) {
                    webServerMBeanImpl.setDebugEnabled(this.bean.isDebugEnabled());
                }
                if ((list == null || !list.contains("KeepAliveEnabled")) && this.bean.isKeepAliveEnabledSet()) {
                    webServerMBeanImpl.setKeepAliveEnabled(this.bean.isKeepAliveEnabled());
                }
                if (bl && (list == null || !list.contains("LogFileLimitEnabled")) && this.bean.isLogFileLimitEnabledSet()) {
                    webServerMBeanImpl.setLogFileLimitEnabled(this.bean.isLogFileLimitEnabled());
                }
                if (bl && (list == null || !list.contains("LoggingEnabled")) && this.bean.isLoggingEnabledSet()) {
                    webServerMBeanImpl.setLoggingEnabled(this.bean.isLoggingEnabled());
                }
                if ((list == null || !list.contains("SendServerHeaderEnabled")) && this.bean.isSendServerHeaderEnabledSet()) {
                    webServerMBeanImpl.setSendServerHeaderEnabled(this.bean.isSendServerHeaderEnabled());
                }
                if ((list == null || !list.contains("SingleSignonDisabled")) && this.bean.isSingleSignonDisabledSet()) {
                    webServerMBeanImpl.setSingleSignonDisabled(this.bean.isSingleSignonDisabled());
                }
                if ((list == null || !list.contains("UseHeaderEncoding")) && this.bean.isUseHeaderEncodingSet()) {
                    webServerMBeanImpl.setUseHeaderEncoding(this.bean.isUseHeaderEncoding());
                }
                if ((list == null || !list.contains("UseHighestCompatibleHTTPVersion")) && this.bean.isUseHighestCompatibleHTTPVersionSet()) {
                    webServerMBeanImpl.setUseHighestCompatibleHTTPVersion(this.bean.isUseHighestCompatibleHTTPVersion());
                }
                if ((list == null || !list.contains("WAPEnabled")) && this.bean.isWAPEnabledSet()) {
                    webServerMBeanImpl.setWAPEnabled(this.bean.isWAPEnabled());
                }
                return webServerMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getDefaultWebApp(), clazz, object);
            this.inferSubTree(this.bean.getWebDeployments(), clazz, object);
            this.inferSubTree(this.bean.getWebServerLog(), clazz, object);
        }
    }
}

