/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.util.HashSet;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.MaxThreadsConstraintMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.WorkManagerMBean;

public final class WorkManagerLegalHelper {
    public static void validateMaxThreadsConstraint(MaxThreadsConstraintMBean maxThreadsConstraintMBean) {
        String string = maxThreadsConstraintMBean.getConnectionPoolName();
        if (maxThreadsConstraintMBean.getCount() > 0 && string != null && string.trim().length() > 0) {
            throw new IllegalArgumentException("Count and ConnectionPoolName cannot be set together. Please set either count or connection pool name but not both");
        }
    }

    public static void validateWorkManager(WorkManagerMBean workManagerMBean) {
        int n = 0;
        if (workManagerMBean.getFairShareRequestClass() != null) {
            ++n;
        }
        if (workManagerMBean.getResponseTimeRequestClass() != null) {
            ++n;
        }
        if (workManagerMBean.getContextRequestClass() != null) {
            ++n;
        }
        if (n > 1) {
            throw new IllegalArgumentException("WorkManagerMBean cannot have more than one RequestClass. Please choose either a FairShareRequestClass, ResponseTimeRequestClass, or ContextRequestClass but not more than one");
        }
    }

    public static void validateTargets(WorkManagerMBean workManagerMBean, DeploymentMBean deploymentMBean) {
        int n;
        if (workManagerMBean == null || deploymentMBean == null) {
            return;
        }
        HashSet hashSet = new HashSet();
        TargetMBean[] targetMBeanArray = workManagerMBean.getTargets();
        if (targetMBeanArray == null) {
            return;
        }
        for (n = 0; n < targetMBeanArray.length; ++n) {
            hashSet.addAll(targetMBeanArray[n].getServerNames());
        }
        targetMBeanArray = deploymentMBean.getTargets();
        if (targetMBeanArray == null) {
            return;
        }
        for (n = 0; n < targetMBeanArray.length; ++n) {
            if (!hashSet.removeAll(targetMBeanArray[n].getServerNames())) continue;
            return;
        }
        throw new IllegalArgumentException("WorkManagerMBean '" + workManagerMBean.getName() + "' refers to a constraint or request class '" + deploymentMBean.getName() + "' but they are deployed on targets that have no servers in common. " + "Please deploy the mbeans so that they have at least one server in " + "common.");
    }
}

