/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.configuration;

import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.zip.CRC32;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import weblogic.descriptor.BeanRemoveRejectedException;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.beangen.LegalChecks;
import weblogic.descriptor.internal.AbstractDescriptorBean;
import weblogic.descriptor.internal.AbstractDescriptorBeanHelper;
import weblogic.descriptor.internal.Munger;
import weblogic.descriptor.internal.SchemaHelper;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ConfigurationException;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.ConfigurationMBeanImpl;
import weblogic.management.configuration.ConfigurationValidator;
import weblogic.management.configuration.XMLEntitySpecRegistryEntryMBean;
import weblogic.management.configuration.XMLEntitySpecRegistryEntryMBeanImpl;
import weblogic.management.configuration.XMLParserSelectRegistryEntryMBean;
import weblogic.management.configuration.XMLParserSelectRegistryEntryMBeanImpl;
import weblogic.management.configuration.XMLRegistryEntryMBean;
import weblogic.management.configuration.XMLRegistryEntryMBeanImpl;
import weblogic.management.configuration.XMLRegistryMBean;
import weblogic.management.mbeans.custom.XMLRegistry;
import weblogic.utils.ArrayUtils;
import weblogic.utils.collections.ArrayIterator;
import weblogic.utils.collections.CombinedIterator;

public class XMLRegistryMBeanImpl
extends ConfigurationMBeanImpl
implements XMLRegistryMBean,
Serializable {
    private String _DocumentBuilderFactory;
    private XMLEntitySpecRegistryEntryMBean[] _EntitySpecRegistryEntries;
    private boolean _HandleEntityInvalidation;
    private String _Name;
    private XMLParserSelectRegistryEntryMBean[] _ParserSelectRegistryEntries;
    private XMLRegistryEntryMBean[] _RegistryEntries;
    private String _SAXParserFactory;
    private String _TransformerFactory;
    private String _WhenToCache;
    private XMLEntitySpecRegistryEntryMBean[] _XMLEntitySpecRegistryEntries;
    private XMLParserSelectRegistryEntryMBean[] _XMLParserSelectRegistryEntries;
    private XMLRegistry _customizer;
    private static SchemaHelper2 _schemaHelper;

    public XMLRegistryMBeanImpl() {
        try {
            this._customizer = new XMLRegistry(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public XMLRegistryMBeanImpl(DescriptorBean descriptorBean, int n) {
        super(descriptorBean, n);
        try {
            this._customizer = new XMLRegistry(this);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        this._initializeProperty(-1);
    }

    public String getDocumentBuilderFactory() {
        return this._DocumentBuilderFactory;
    }

    public String getName() {
        if (!this._isSet(2)) {
            try {
                return ((ConfigurationMBean)this.getParent()).getName();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return this._customizer.getName();
    }

    public boolean isDocumentBuilderFactorySet() {
        return this._isSet(7);
    }

    public boolean isNameSet() {
        return this._isSet(2);
    }

    public void setDocumentBuilderFactory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._DocumentBuilderFactory;
        this._DocumentBuilderFactory = string;
        this._postSet(7, string2, string);
    }

    public void setName(String string) throws InvalidAttributeValueException, ManagementException {
        string = string == null ? null : string.trim();
        LegalChecks.checkNonEmptyString((String)"Name", (String)string);
        LegalChecks.checkNonNull((String)"Name", (Object)string);
        ConfigurationValidator.validateName(string);
        String string2 = this.getName();
        this._customizer.setName(string);
        this._postSet(2, string2, string);
    }

    public String getSAXParserFactory() {
        return this._SAXParserFactory;
    }

    public boolean isSAXParserFactorySet() {
        return this._isSet(8);
    }

    public void setSAXParserFactory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._SAXParserFactory;
        this._SAXParserFactory = string;
        this._postSet(8, string2, string);
    }

    public String getTransformerFactory() {
        return this._TransformerFactory;
    }

    public boolean isTransformerFactorySet() {
        return this._isSet(9);
    }

    public void setTransformerFactory(String string) throws InvalidAttributeValueException {
        string = string == null ? null : string.trim();
        String string2 = this._TransformerFactory;
        this._TransformerFactory = string;
        this._postSet(9, string2, string);
    }

    public boolean addRegistryEntry(XMLRegistryEntryMBean xMLRegistryEntryMBean) {
        this._getHelper()._ensureNonNull((Object)xMLRegistryEntryMBean);
        if (!((AbstractDescriptorBean)xMLRegistryEntryMBean).isChildProperty((DescriptorBean)this, 10)) {
            XMLRegistryEntryMBean[] xMLRegistryEntryMBeanArray = (XMLRegistryEntryMBean[])this._getHelper()._extendArray((Object)this.getRegistryEntries(), XMLRegistryEntryMBean.class, (Object)xMLRegistryEntryMBean);
            try {
                this.setRegistryEntries(xMLRegistryEntryMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeRegistryEntry(XMLRegistryEntryMBean xMLRegistryEntryMBean) {
        XMLRegistryEntryMBean[] xMLRegistryEntryMBeanArray = this.getRegistryEntries();
        XMLRegistryEntryMBean[] xMLRegistryEntryMBeanArray2 = (XMLRegistryEntryMBean[])this._getHelper()._removeElement((Object)xMLRegistryEntryMBeanArray, XMLRegistryEntryMBean.class, (Object)xMLRegistryEntryMBean);
        if (xMLRegistryEntryMBeanArray2.length != xMLRegistryEntryMBeanArray.length) {
            try {
                this.setRegistryEntries(xMLRegistryEntryMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public XMLRegistryEntryMBean[] getRegistryEntries() {
        return this._RegistryEntries;
    }

    public boolean isRegistryEntriesSet() {
        return this._isSet(10);
    }

    public void setRegistryEntries(XMLRegistryEntryMBean[] xMLRegistryEntryMBeanArray) throws InvalidAttributeValueException {
        xMLRegistryEntryMBeanArray = xMLRegistryEntryMBeanArray == null ? new XMLRegistryEntryMBeanImpl[]{} : xMLRegistryEntryMBeanArray;
        this._RegistryEntries = xMLRegistryEntryMBeanArray;
    }

    public XMLParserSelectRegistryEntryMBean createXMLParserSelectRegistryEntry(String string) {
        XMLParserSelectRegistryEntryMBeanImpl xMLParserSelectRegistryEntryMBeanImpl = new XMLParserSelectRegistryEntryMBeanImpl(this, -1);
        try {
            xMLParserSelectRegistryEntryMBeanImpl.setName(string);
            this.addXMLParserSelectRegistryEntry(xMLParserSelectRegistryEntryMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return xMLParserSelectRegistryEntryMBeanImpl;
    }

    public void touch() throws ConfigurationException {
        this._customizer.touch();
    }

    public void destroyXMLParserSelectRegistryEntry(XMLParserSelectRegistryEntryMBean xMLParserSelectRegistryEntryMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(xMLParserSelectRegistryEntryMBean, 11);
                XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray = this.getXMLParserSelectRegistryEntries();
                XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray2 = (XMLParserSelectRegistryEntryMBean[])this._getHelper()._removeElement((Object)xMLParserSelectRegistryEntryMBeanArray, XMLParserSelectRegistryEntryMBean.class, (Object)xMLParserSelectRegistryEntryMBean);
                if (xMLParserSelectRegistryEntryMBeanArray.length == xMLParserSelectRegistryEntryMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)xMLParserSelectRegistryEntryMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)xMLParserSelectRegistryEntryMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setXMLParserSelectRegistryEntries(xMLParserSelectRegistryEntryMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void freezeCurrentValue(String string) throws AttributeNotFoundException, MBeanException {
        this._customizer.freezeCurrentValue(string);
    }

    public boolean addParserSelectRegistryEntry(XMLParserSelectRegistryEntryMBean xMLParserSelectRegistryEntryMBean) {
        this._getHelper()._ensureNonNull((Object)xMLParserSelectRegistryEntryMBean);
        if (!((AbstractDescriptorBean)xMLParserSelectRegistryEntryMBean).isChildProperty((DescriptorBean)this, 12)) {
            XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray = (XMLParserSelectRegistryEntryMBean[])this._getHelper()._extendArray((Object)this.getParserSelectRegistryEntries(), XMLParserSelectRegistryEntryMBean.class, (Object)xMLParserSelectRegistryEntryMBean);
            try {
                this.setParserSelectRegistryEntries(xMLParserSelectRegistryEntryMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public void restoreDefaultValue(String string) throws AttributeNotFoundException {
        this._customizer.restoreDefaultValue(string);
    }

    public boolean removeParserSelectRegistryEntry(XMLParserSelectRegistryEntryMBean xMLParserSelectRegistryEntryMBean) {
        XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray = this.getParserSelectRegistryEntries();
        XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray2 = (XMLParserSelectRegistryEntryMBean[])this._getHelper()._removeElement((Object)xMLParserSelectRegistryEntryMBeanArray, XMLParserSelectRegistryEntryMBean.class, (Object)xMLParserSelectRegistryEntryMBean);
        if (xMLParserSelectRegistryEntryMBeanArray2.length != xMLParserSelectRegistryEntryMBeanArray.length) {
            try {
                this.setParserSelectRegistryEntries(xMLParserSelectRegistryEntryMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public void addXMLParserSelectRegistryEntry(XMLParserSelectRegistryEntryMBean xMLParserSelectRegistryEntryMBean) {
        this._getHelper()._ensureNonNull((Object)xMLParserSelectRegistryEntryMBean);
        if (!((AbstractDescriptorBean)xMLParserSelectRegistryEntryMBean).isChildProperty((DescriptorBean)this, 11)) {
            XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray = this._isSet(11) ? (XMLParserSelectRegistryEntryMBean[])this._getHelper()._extendArray((Object)this.getXMLParserSelectRegistryEntries(), XMLParserSelectRegistryEntryMBean.class, (Object)xMLParserSelectRegistryEntryMBean) : new XMLParserSelectRegistryEntryMBean[]{xMLParserSelectRegistryEntryMBean};
            try {
                this.setXMLParserSelectRegistryEntries(xMLParserSelectRegistryEntryMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public XMLParserSelectRegistryEntryMBean[] getXMLParserSelectRegistryEntries() {
        return this._XMLParserSelectRegistryEntries;
    }

    public boolean isXMLParserSelectRegistryEntriesSet() {
        return this._isSet(11);
    }

    public void removeXMLParserSelectRegistryEntry(XMLParserSelectRegistryEntryMBean xMLParserSelectRegistryEntryMBean) {
        this.destroyXMLParserSelectRegistryEntry(xMLParserSelectRegistryEntryMBean);
    }

    public void setXMLParserSelectRegistryEntries(XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray) throws InvalidAttributeValueException {
        xMLParserSelectRegistryEntryMBeanArray = xMLParserSelectRegistryEntryMBeanArray == null ? new XMLParserSelectRegistryEntryMBeanImpl[]{} : xMLParserSelectRegistryEntryMBeanArray;
        for (int i = 0; i < xMLParserSelectRegistryEntryMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)xMLParserSelectRegistryEntryMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 11)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray2 = this._XMLParserSelectRegistryEntries;
        this._XMLParserSelectRegistryEntries = xMLParserSelectRegistryEntryMBeanArray;
        this._postSet(11, xMLParserSelectRegistryEntryMBeanArray2, xMLParserSelectRegistryEntryMBeanArray);
    }

    public XMLParserSelectRegistryEntryMBean[] getParserSelectRegistryEntries() {
        return this._customizer.getParserSelectRegistryEntries();
    }

    public boolean isParserSelectRegistryEntriesSet() {
        return this._isSet(12);
    }

    public void setParserSelectRegistryEntries(XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray) throws InvalidAttributeValueException {
        xMLParserSelectRegistryEntryMBeanArray = xMLParserSelectRegistryEntryMBeanArray == null ? new XMLParserSelectRegistryEntryMBeanImpl[]{} : xMLParserSelectRegistryEntryMBeanArray;
        this._ParserSelectRegistryEntries = xMLParserSelectRegistryEntryMBeanArray;
    }

    public boolean addEntitySpecRegistryEntry(XMLEntitySpecRegistryEntryMBean xMLEntitySpecRegistryEntryMBean) {
        this._getHelper()._ensureNonNull((Object)xMLEntitySpecRegistryEntryMBean);
        if (!((AbstractDescriptorBean)xMLEntitySpecRegistryEntryMBean).isChildProperty((DescriptorBean)this, 13)) {
            XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray = (XMLEntitySpecRegistryEntryMBean[])this._getHelper()._extendArray((Object)this.getEntitySpecRegistryEntries(), XMLEntitySpecRegistryEntryMBean.class, (Object)xMLEntitySpecRegistryEntryMBean);
            try {
                this.setEntitySpecRegistryEntries(xMLEntitySpecRegistryEntryMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
        return true;
    }

    public boolean removeEntitySpecRegistryEntry(XMLEntitySpecRegistryEntryMBean xMLEntitySpecRegistryEntryMBean) {
        XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray = this.getEntitySpecRegistryEntries();
        XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray2 = (XMLEntitySpecRegistryEntryMBean[])this._getHelper()._removeElement((Object)xMLEntitySpecRegistryEntryMBeanArray, XMLEntitySpecRegistryEntryMBean.class, (Object)xMLEntitySpecRegistryEntryMBean);
        if (xMLEntitySpecRegistryEntryMBeanArray2.length != xMLEntitySpecRegistryEntryMBeanArray.length) {
            try {
                this.setEntitySpecRegistryEntries(xMLEntitySpecRegistryEntryMBeanArray2);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
            return true;
        }
        return false;
    }

    public XMLEntitySpecRegistryEntryMBean[] getEntitySpecRegistryEntries() {
        return this._customizer.getEntitySpecRegistryEntries();
    }

    public boolean isEntitySpecRegistryEntriesSet() {
        return this._isSet(13);
    }

    public void addXMLEntitySpecRegistryEntry(XMLEntitySpecRegistryEntryMBean xMLEntitySpecRegistryEntryMBean) {
        this._getHelper()._ensureNonNull((Object)xMLEntitySpecRegistryEntryMBean);
        if (!((AbstractDescriptorBean)xMLEntitySpecRegistryEntryMBean).isChildProperty((DescriptorBean)this, 14)) {
            XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray = this._isSet(14) ? (XMLEntitySpecRegistryEntryMBean[])this._getHelper()._extendArray((Object)this.getXMLEntitySpecRegistryEntries(), XMLEntitySpecRegistryEntryMBean.class, (Object)xMLEntitySpecRegistryEntryMBean) : new XMLEntitySpecRegistryEntryMBean[]{xMLEntitySpecRegistryEntryMBean};
            try {
                this.setXMLEntitySpecRegistryEntries(xMLEntitySpecRegistryEntryMBeanArray);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public XMLEntitySpecRegistryEntryMBean[] getXMLEntitySpecRegistryEntries() {
        return this._XMLEntitySpecRegistryEntries;
    }

    public boolean isXMLEntitySpecRegistryEntriesSet() {
        return this._isSet(14);
    }

    public void removeXMLEntitySpecRegistryEntry(XMLEntitySpecRegistryEntryMBean xMLEntitySpecRegistryEntryMBean) {
        this.destroyXMLEntitySpecRegistryEntry(xMLEntitySpecRegistryEntryMBean);
    }

    public void setXMLEntitySpecRegistryEntries(XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray) throws InvalidAttributeValueException {
        xMLEntitySpecRegistryEntryMBeanArray = xMLEntitySpecRegistryEntryMBeanArray == null ? new XMLEntitySpecRegistryEntryMBeanImpl[]{} : xMLEntitySpecRegistryEntryMBeanArray;
        for (int i = 0; i < xMLEntitySpecRegistryEntryMBeanArray.length; ++i) {
            AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)xMLEntitySpecRegistryEntryMBeanArray[i];
            if (!this._setParent((DescriptorBean)abstractDescriptorBean, this, 14)) continue;
            this._getReferenceManager().registerBean(abstractDescriptorBean, false);
            this._postCreate(abstractDescriptorBean);
        }
        XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray2 = this._XMLEntitySpecRegistryEntries;
        this._XMLEntitySpecRegistryEntries = xMLEntitySpecRegistryEntryMBeanArray;
        this._postSet(14, xMLEntitySpecRegistryEntryMBeanArray2, xMLEntitySpecRegistryEntryMBeanArray);
    }

    public XMLEntitySpecRegistryEntryMBean createXMLEntitySpecRegistryEntry(String string) {
        XMLEntitySpecRegistryEntryMBeanImpl xMLEntitySpecRegistryEntryMBeanImpl = new XMLEntitySpecRegistryEntryMBeanImpl(this, -1);
        try {
            xMLEntitySpecRegistryEntryMBeanImpl.setName(string);
            this.addXMLEntitySpecRegistryEntry(xMLEntitySpecRegistryEntryMBeanImpl);
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new UndeclaredThrowableException(exception);
        }
        return xMLEntitySpecRegistryEntryMBeanImpl;
    }

    public void destroyXMLEntitySpecRegistryEntry(XMLEntitySpecRegistryEntryMBean xMLEntitySpecRegistryEntryMBean) {
        block8: {
            try {
                this._checkIsPotentialChild(xMLEntitySpecRegistryEntryMBean, 14);
                XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray = this.getXMLEntitySpecRegistryEntries();
                XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray2 = (XMLEntitySpecRegistryEntryMBean[])this._getHelper()._removeElement((Object)xMLEntitySpecRegistryEntryMBeanArray, XMLEntitySpecRegistryEntryMBean.class, (Object)xMLEntitySpecRegistryEntryMBean);
                if (xMLEntitySpecRegistryEntryMBeanArray.length == xMLEntitySpecRegistryEntryMBeanArray2.length) break block8;
                this._preDestroy((AbstractDescriptorBean)xMLEntitySpecRegistryEntryMBean);
                try {
                    AbstractDescriptorBean abstractDescriptorBean = (AbstractDescriptorBean)xMLEntitySpecRegistryEntryMBean;
                    if (abstractDescriptorBean == null) {
                        return;
                    }
                    List list = this._getReferenceManager().getResolvedReferences(abstractDescriptorBean);
                    if (list != null && list.size() > 0) {
                        throw new BeanRemoveRejectedException((DescriptorBean)abstractDescriptorBean, list);
                    }
                    this._getReferenceManager().unregisterBean(abstractDescriptorBean);
                    this._markDestroyed(abstractDescriptorBean);
                    this.setXMLEntitySpecRegistryEntries(xMLEntitySpecRegistryEntryMBeanArray2);
                }
                catch (Exception exception) {
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    throw new UndeclaredThrowableException(exception);
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                throw new UndeclaredThrowableException(exception);
            }
        }
    }

    public void setEntitySpecRegistryEntries(XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray) throws InvalidAttributeValueException {
        xMLEntitySpecRegistryEntryMBeanArray = xMLEntitySpecRegistryEntryMBeanArray == null ? new XMLEntitySpecRegistryEntryMBeanImpl[]{} : xMLEntitySpecRegistryEntryMBeanArray;
        this._EntitySpecRegistryEntries = xMLEntitySpecRegistryEntryMBeanArray;
    }

    public String getWhenToCache() {
        return this._WhenToCache;
    }

    public boolean isWhenToCacheSet() {
        return this._isSet(15);
    }

    public void setWhenToCache(String string) {
        string = string == null ? null : string.trim();
        String[] stringArray = new String[]{"cache-on-reference", "cache-at-initialization", "cache-never"};
        string = LegalChecks.checkInEnum((String)"WhenToCache", (String)string, (String[])stringArray);
        String string2 = this._WhenToCache;
        this._WhenToCache = string;
        this._postSet(15, string2, string);
    }

    public boolean isHandleEntityInvalidation() {
        return this._HandleEntityInvalidation;
    }

    public boolean isHandleEntityInvalidationSet() {
        return this._isSet(16);
    }

    public void setHandleEntityInvalidation(boolean bl) {
        boolean bl2 = this._HandleEntityInvalidation;
        this._HandleEntityInvalidation = bl;
        this._postSet(16, bl2, bl);
    }

    public XMLParserSelectRegistryEntryMBean findParserSelectMBeanByKey(String string, String string2, String string3) {
        return this._customizer.findParserSelectMBeanByKey(string, string2, string3);
    }

    public XMLEntitySpecRegistryEntryMBean findEntitySpecMBeanByKey(String string, String string2) {
        return this._customizer.findEntitySpecMBeanByKey(string, string2);
    }

    public Object _getKey() {
        return this.getName();
    }

    public void _validate() throws IllegalArgumentException {
        super._validate();
    }

    public boolean _hasKey() {
        return true;
    }

    public boolean _isPropertyAKey(Munger.ReaderEventInfo readerEventInfo) {
        String string = readerEventInfo.getElementName();
        switch (string.length()) {
            case 4: {
                if (!string.equals("name")) break;
                return readerEventInfo.compareXpaths(this._getPropertyXpath("name"));
            }
            default: {
                return super._isPropertyAKey(readerEventInfo);
            }
        }
        return super._isPropertyAKey(readerEventInfo);
    }

    protected void _unSet(int n) {
        if (!this._initializeProperty(n)) {
            super._unSet(n);
        } else {
            this._markSet(n, false);
        }
    }

    protected AbstractDescriptorBeanHelper _createHelper() {
        return new Helper(this);
    }

    public boolean _isAnythingSet() {
        return super._isAnythingSet();
    }

    private boolean _initializeProperty(int n) {
        boolean bl;
        boolean bl2 = bl = n > -1;
        if (!bl) {
            n = 7;
        }
        try {
            switch (n) {
                case 7: {
                    this._DocumentBuilderFactory = "weblogic.apache.xerces.jaxp.DocumentBuilderFactoryImpl";
                    if (bl) break;
                }
                case 13: {
                    this._EntitySpecRegistryEntries = new XMLEntitySpecRegistryEntryMBean[0];
                    if (bl) break;
                }
                case 2: {
                    this._customizer.setName(null);
                    if (bl) break;
                }
                case 12: {
                    this._ParserSelectRegistryEntries = new XMLParserSelectRegistryEntryMBean[0];
                    if (bl) break;
                }
                case 10: {
                    this._RegistryEntries = new XMLRegistryEntryMBean[0];
                    if (bl) break;
                }
                case 8: {
                    this._SAXParserFactory = "weblogic.apache.xerces.jaxp.SAXParserFactoryImpl";
                    if (bl) break;
                }
                case 9: {
                    this._TransformerFactory = "weblogic.xml.jaxp.WebLogicTransformerFactory";
                    if (bl) break;
                }
                case 15: {
                    this._WhenToCache = "cache-on-reference";
                    if (bl) break;
                }
                case 14: {
                    this._XMLEntitySpecRegistryEntries = new XMLEntitySpecRegistryEntryMBean[0];
                    if (bl) break;
                }
                case 11: {
                    this._XMLParserSelectRegistryEntries = new XMLParserSelectRegistryEntryMBean[0];
                    if (bl) break;
                }
                case 16: {
                    this._HandleEntityInvalidation = false;
                    if (bl) break;
                }
                default: {
                    if (!bl) break;
                    return false;
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
        }
    }

    public Munger.SchemaHelper _getSchemaHelper() {
        return null;
    }

    public String _getElementName(int n) {
        return this._getSchemaHelper2().getElementName(n);
    }

    protected String getSchemaLocation() {
        return "http://xmlns.oracle.com/weblogic/1.0/domain.xsd";
    }

    protected String getTargetNamespace() {
        return "http://xmlns.oracle.com/weblogic/domain";
    }

    public SchemaHelper _getSchemaHelper2() {
        if (_schemaHelper == null) {
            _schemaHelper = new SchemaHelper2();
        }
        return _schemaHelper;
    }

    public String getType() {
        return "XMLRegistry";
    }

    public void putValue(String string, Object object) {
        if (string.equals("DocumentBuilderFactory")) {
            String string2 = this._DocumentBuilderFactory;
            this._DocumentBuilderFactory = (String)object;
            this._postSet(7, string2, this._DocumentBuilderFactory);
            return;
        }
        if (string.equals("EntitySpecRegistryEntries")) {
            XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray = this._EntitySpecRegistryEntries;
            this._EntitySpecRegistryEntries = (XMLEntitySpecRegistryEntryMBean[])object;
            this._postSet(13, xMLEntitySpecRegistryEntryMBeanArray, this._EntitySpecRegistryEntries);
            return;
        }
        if (string.equals("HandleEntityInvalidation")) {
            boolean bl = this._HandleEntityInvalidation;
            this._HandleEntityInvalidation = (Boolean)object;
            this._postSet(16, bl, this._HandleEntityInvalidation);
            return;
        }
        if (string.equals("Name")) {
            String string3 = this._Name;
            this._Name = (String)object;
            this._postSet(2, string3, this._Name);
            return;
        }
        if (string.equals("ParserSelectRegistryEntries")) {
            XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray = this._ParserSelectRegistryEntries;
            this._ParserSelectRegistryEntries = (XMLParserSelectRegistryEntryMBean[])object;
            this._postSet(12, xMLParserSelectRegistryEntryMBeanArray, this._ParserSelectRegistryEntries);
            return;
        }
        if (string.equals("RegistryEntries")) {
            XMLRegistryEntryMBean[] xMLRegistryEntryMBeanArray = this._RegistryEntries;
            this._RegistryEntries = (XMLRegistryEntryMBean[])object;
            this._postSet(10, xMLRegistryEntryMBeanArray, this._RegistryEntries);
            return;
        }
        if (string.equals("SAXParserFactory")) {
            String string4 = this._SAXParserFactory;
            this._SAXParserFactory = (String)object;
            this._postSet(8, string4, this._SAXParserFactory);
            return;
        }
        if (string.equals("TransformerFactory")) {
            String string5 = this._TransformerFactory;
            this._TransformerFactory = (String)object;
            this._postSet(9, string5, this._TransformerFactory);
            return;
        }
        if (string.equals("WhenToCache")) {
            String string6 = this._WhenToCache;
            this._WhenToCache = (String)object;
            this._postSet(15, string6, this._WhenToCache);
            return;
        }
        if (string.equals("XMLEntitySpecRegistryEntries")) {
            XMLEntitySpecRegistryEntryMBean[] xMLEntitySpecRegistryEntryMBeanArray = this._XMLEntitySpecRegistryEntries;
            this._XMLEntitySpecRegistryEntries = (XMLEntitySpecRegistryEntryMBean[])object;
            this._postSet(14, xMLEntitySpecRegistryEntryMBeanArray, this._XMLEntitySpecRegistryEntries);
            return;
        }
        if (string.equals("XMLParserSelectRegistryEntries")) {
            XMLParserSelectRegistryEntryMBean[] xMLParserSelectRegistryEntryMBeanArray = this._XMLParserSelectRegistryEntries;
            this._XMLParserSelectRegistryEntries = (XMLParserSelectRegistryEntryMBean[])object;
            this._postSet(11, xMLParserSelectRegistryEntryMBeanArray, this._XMLParserSelectRegistryEntries);
            return;
        }
        if (string.equals("customizer")) {
            XMLRegistry xMLRegistry = this._customizer;
            this._customizer = (XMLRegistry)object;
            return;
        }
        super.putValue(string, object);
    }

    public Object getValue(String string) {
        if (string.equals("DocumentBuilderFactory")) {
            return this._DocumentBuilderFactory;
        }
        if (string.equals("EntitySpecRegistryEntries")) {
            return this._EntitySpecRegistryEntries;
        }
        if (string.equals("HandleEntityInvalidation")) {
            return new Boolean(this._HandleEntityInvalidation);
        }
        if (string.equals("Name")) {
            return this._Name;
        }
        if (string.equals("ParserSelectRegistryEntries")) {
            return this._ParserSelectRegistryEntries;
        }
        if (string.equals("RegistryEntries")) {
            return this._RegistryEntries;
        }
        if (string.equals("SAXParserFactory")) {
            return this._SAXParserFactory;
        }
        if (string.equals("TransformerFactory")) {
            return this._TransformerFactory;
        }
        if (string.equals("WhenToCache")) {
            return this._WhenToCache;
        }
        if (string.equals("XMLEntitySpecRegistryEntries")) {
            return this._XMLEntitySpecRegistryEntries;
        }
        if (string.equals("XMLParserSelectRegistryEntries")) {
            return this._XMLParserSelectRegistryEntries;
        }
        if (string.equals("customizer")) {
            return this._customizer;
        }
        return super.getValue(string);
    }

    public static class SchemaHelper2
    extends ConfigurationMBeanImpl.SchemaHelper2
    implements SchemaHelper {
        public int getPropertyIndex(String string) {
            switch (string.length()) {
                case 24: {
                    if (!string.equals("document-builder-factory")) break;
                    return 7;
                }
                case 26: {
                    if (string.equals("entity-spec-registry-entry")) {
                        return 13;
                    }
                    if (!string.equals("handle-entity-invalidation")) break;
                    return 16;
                }
                case 4: {
                    if (!string.equals("name")) break;
                    return 2;
                }
                case 28: {
                    if (!string.equals("parser-select-registry-entry")) break;
                    return 12;
                }
                case 14: {
                    if (!string.equals("registry-entry")) break;
                    return 10;
                }
                case 18: {
                    if (!string.equals("sax-parser-factory")) break;
                    return 8;
                }
                case 19: {
                    if (!string.equals("transformer-factory")) break;
                    return 9;
                }
                case 13: {
                    if (!string.equals("when-to-cache")) break;
                    return 15;
                }
                case 30: {
                    if (!string.equals("xml-entity-spec-registry-entry")) break;
                    return 14;
                }
                case 32: {
                    if (!string.equals("xml-parser-select-registry-entry")) break;
                    return 11;
                }
            }
            return super.getPropertyIndex(string);
        }

        public SchemaHelper getSchemaHelper(int n) {
            switch (n) {
                case 14: {
                    return new XMLEntitySpecRegistryEntryMBeanImpl.SchemaHelper2();
                }
                case 11: {
                    return new XMLParserSelectRegistryEntryMBeanImpl.SchemaHelper2();
                }
            }
            return super.getSchemaHelper(n);
        }

        public String getElementName(int n) {
            switch (n) {
                case 7: {
                    return "document-builder-factory";
                }
                case 13: {
                    return "entity-spec-registry-entry";
                }
                case 2: {
                    return "name";
                }
                case 12: {
                    return "parser-select-registry-entry";
                }
                case 10: {
                    return "registry-entry";
                }
                case 8: {
                    return "sax-parser-factory";
                }
                case 9: {
                    return "transformer-factory";
                }
                case 15: {
                    return "when-to-cache";
                }
                case 14: {
                    return "xml-entity-spec-registry-entry";
                }
                case 11: {
                    return "xml-parser-select-registry-entry";
                }
                case 16: {
                    return "handle-entity-invalidation";
                }
            }
            return super.getElementName(n);
        }

        public boolean isArray(int n) {
            switch (n) {
                case 13: {
                    return true;
                }
                case 12: {
                    return true;
                }
                case 10: {
                    return true;
                }
                case 14: {
                    return true;
                }
                case 11: {
                    return true;
                }
            }
            return super.isArray(n);
        }

        public boolean isBean(int n) {
            switch (n) {
                case 14: {
                    return true;
                }
                case 11: {
                    return true;
                }
            }
            return super.isBean(n);
        }

        public boolean isKey(int n) {
            switch (n) {
                case 2: {
                    return true;
                }
            }
            return super.isKey(n);
        }

        public boolean hasKey() {
            return true;
        }

        public String[] getKeyElementNames() {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("name");
            return arrayList.toArray(new String[0]);
        }
    }

    protected static class Helper
    extends ConfigurationMBeanImpl.Helper {
        private XMLRegistryMBeanImpl bean;

        protected Helper(XMLRegistryMBeanImpl xMLRegistryMBeanImpl) {
            super(xMLRegistryMBeanImpl);
            this.bean = xMLRegistryMBeanImpl;
        }

        public String getPropertyName(int n) {
            switch (n) {
                case 7: {
                    return "DocumentBuilderFactory";
                }
                case 13: {
                    return "EntitySpecRegistryEntries";
                }
                case 2: {
                    return "Name";
                }
                case 12: {
                    return "ParserSelectRegistryEntries";
                }
                case 10: {
                    return "RegistryEntries";
                }
                case 8: {
                    return "SAXParserFactory";
                }
                case 9: {
                    return "TransformerFactory";
                }
                case 15: {
                    return "WhenToCache";
                }
                case 14: {
                    return "XMLEntitySpecRegistryEntries";
                }
                case 11: {
                    return "XMLParserSelectRegistryEntries";
                }
                case 16: {
                    return "HandleEntityInvalidation";
                }
            }
            return super.getPropertyName(n);
        }

        public int getPropertyIndex(String string) {
            if (string.equals("DocumentBuilderFactory")) {
                return 7;
            }
            if (string.equals("EntitySpecRegistryEntries")) {
                return 13;
            }
            if (string.equals("Name")) {
                return 2;
            }
            if (string.equals("ParserSelectRegistryEntries")) {
                return 12;
            }
            if (string.equals("RegistryEntries")) {
                return 10;
            }
            if (string.equals("SAXParserFactory")) {
                return 8;
            }
            if (string.equals("TransformerFactory")) {
                return 9;
            }
            if (string.equals("WhenToCache")) {
                return 15;
            }
            if (string.equals("XMLEntitySpecRegistryEntries")) {
                return 14;
            }
            if (string.equals("XMLParserSelectRegistryEntries")) {
                return 11;
            }
            if (string.equals("HandleEntityInvalidation")) {
                return 16;
            }
            return super.getPropertyIndex(string);
        }

        public Iterator getChildren() {
            ArrayList<ArrayIterator> arrayList = new ArrayList<ArrayIterator>();
            arrayList.add(new ArrayIterator((Object[])this.bean.getXMLEntitySpecRegistryEntries()));
            arrayList.add(new ArrayIterator((Object[])this.bean.getXMLParserSelectRegistryEntries()));
            return new CombinedIterator(arrayList);
        }

        protected long computeHashValue(CRC32 cRC32) {
            try {
                int n;
                StringBuffer stringBuffer = new StringBuffer();
                long l = super.computeHashValue(cRC32);
                if (l != 0L) {
                    stringBuffer.append(String.valueOf(l));
                }
                long l2 = 0L;
                if (this.bean.isDocumentBuilderFactorySet()) {
                    stringBuffer.append("DocumentBuilderFactory");
                    stringBuffer.append(String.valueOf(this.bean.getDocumentBuilderFactory()));
                }
                if (this.bean.isEntitySpecRegistryEntriesSet()) {
                    stringBuffer.append("EntitySpecRegistryEntries");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getEntitySpecRegistryEntries())));
                }
                if (this.bean.isNameSet()) {
                    stringBuffer.append("Name");
                    stringBuffer.append(String.valueOf(this.bean.getName()));
                }
                if (this.bean.isParserSelectRegistryEntriesSet()) {
                    stringBuffer.append("ParserSelectRegistryEntries");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getParserSelectRegistryEntries())));
                }
                if (this.bean.isRegistryEntriesSet()) {
                    stringBuffer.append("RegistryEntries");
                    stringBuffer.append(Arrays.toString(ArrayUtils.copyAndSort((Object[])this.bean.getRegistryEntries())));
                }
                if (this.bean.isSAXParserFactorySet()) {
                    stringBuffer.append("SAXParserFactory");
                    stringBuffer.append(String.valueOf(this.bean.getSAXParserFactory()));
                }
                if (this.bean.isTransformerFactorySet()) {
                    stringBuffer.append("TransformerFactory");
                    stringBuffer.append(String.valueOf(this.bean.getTransformerFactory()));
                }
                if (this.bean.isWhenToCacheSet()) {
                    stringBuffer.append("WhenToCache");
                    stringBuffer.append(String.valueOf(this.bean.getWhenToCache()));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getXMLEntitySpecRegistryEntries().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getXMLEntitySpecRegistryEntries()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                l2 = 0L;
                for (n = 0; n < this.bean.getXMLParserSelectRegistryEntries().length; ++n) {
                    l2 ^= this.computeChildHashValue(this.bean.getXMLParserSelectRegistryEntries()[n]);
                }
                if (l2 != 0L) {
                    stringBuffer.append(String.valueOf(l2));
                }
                if (this.bean.isHandleEntityInvalidationSet()) {
                    stringBuffer.append("HandleEntityInvalidation");
                    stringBuffer.append(String.valueOf(this.bean.isHandleEntityInvalidation()));
                }
                cRC32.update(stringBuffer.toString().getBytes());
                return cRC32.getValue();
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void computeDiff(AbstractDescriptorBean abstractDescriptorBean) {
            try {
                super.computeDiff(abstractDescriptorBean);
                XMLRegistryMBeanImpl xMLRegistryMBeanImpl = (XMLRegistryMBeanImpl)abstractDescriptorBean;
                this.computeDiff("DocumentBuilderFactory", this.bean.getDocumentBuilderFactory(), xMLRegistryMBeanImpl.getDocumentBuilderFactory(), true);
                this.computeDiff("Name", this.bean.getName(), xMLRegistryMBeanImpl.getName(), false);
                this.computeDiff("SAXParserFactory", this.bean.getSAXParserFactory(), xMLRegistryMBeanImpl.getSAXParserFactory(), true);
                this.computeDiff("TransformerFactory", this.bean.getTransformerFactory(), xMLRegistryMBeanImpl.getTransformerFactory(), true);
                this.computeDiff("WhenToCache", this.bean.getWhenToCache(), xMLRegistryMBeanImpl.getWhenToCache(), true);
                this.computeChildDiff("XMLEntitySpecRegistryEntries", this.bean.getXMLEntitySpecRegistryEntries(), xMLRegistryMBeanImpl.getXMLEntitySpecRegistryEntries(), false);
                this.computeChildDiff("XMLParserSelectRegistryEntries", this.bean.getXMLParserSelectRegistryEntries(), xMLRegistryMBeanImpl.getXMLParserSelectRegistryEntries(), false);
                this.computeDiff("HandleEntityInvalidation", this.bean.isHandleEntityInvalidation(), xMLRegistryMBeanImpl.isHandleEntityInvalidation(), true);
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void applyPropertyUpdate(BeanUpdateEvent beanUpdateEvent, BeanUpdateEvent.PropertyUpdate propertyUpdate) {
            try {
                XMLRegistryMBeanImpl xMLRegistryMBeanImpl = (XMLRegistryMBeanImpl)beanUpdateEvent.getSourceBean();
                XMLRegistryMBeanImpl xMLRegistryMBeanImpl2 = (XMLRegistryMBeanImpl)beanUpdateEvent.getProposedBean();
                String string = propertyUpdate.getPropertyName();
                int n = propertyUpdate.getUpdateType();
                if (propertyUpdate.isDerivedUpdate()) {
                    return;
                }
                if (string.equals("DocumentBuilderFactory")) {
                    xMLRegistryMBeanImpl.setDocumentBuilderFactory(xMLRegistryMBeanImpl2.getDocumentBuilderFactory());
                    xMLRegistryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 7);
                } else if (!string.equals("EntitySpecRegistryEntries")) {
                    if (string.equals("Name")) {
                        xMLRegistryMBeanImpl.setName(xMLRegistryMBeanImpl2.getName());
                        xMLRegistryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 2);
                    } else if (!string.equals("ParserSelectRegistryEntries") && !string.equals("RegistryEntries")) {
                        if (string.equals("SAXParserFactory")) {
                            xMLRegistryMBeanImpl.setSAXParserFactory(xMLRegistryMBeanImpl2.getSAXParserFactory());
                            xMLRegistryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 8);
                        } else if (string.equals("TransformerFactory")) {
                            xMLRegistryMBeanImpl.setTransformerFactory(xMLRegistryMBeanImpl2.getTransformerFactory());
                            xMLRegistryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 9);
                        } else if (string.equals("WhenToCache")) {
                            xMLRegistryMBeanImpl.setWhenToCache(xMLRegistryMBeanImpl2.getWhenToCache());
                            xMLRegistryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 15);
                        } else if (string.equals("XMLEntitySpecRegistryEntries")) {
                            if (n == 2) {
                                propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                                xMLRegistryMBeanImpl.addXMLEntitySpecRegistryEntry((XMLEntitySpecRegistryEntryMBean)propertyUpdate.getAddedObject());
                            } else if (n == 3) {
                                xMLRegistryMBeanImpl.removeXMLEntitySpecRegistryEntry((XMLEntitySpecRegistryEntryMBean)propertyUpdate.getRemovedObject());
                            } else {
                                throw new AssertionError((Object)("Invalid type: " + n));
                            }
                            if (xMLRegistryMBeanImpl.getXMLEntitySpecRegistryEntries() == null || xMLRegistryMBeanImpl.getXMLEntitySpecRegistryEntries().length == 0) {
                                xMLRegistryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 14);
                            }
                        } else if (string.equals("XMLParserSelectRegistryEntries")) {
                            if (n == 2) {
                                propertyUpdate.resetAddedObject((Object)this.createCopy((AbstractDescriptorBean)propertyUpdate.getAddedObject()));
                                xMLRegistryMBeanImpl.addXMLParserSelectRegistryEntry((XMLParserSelectRegistryEntryMBean)propertyUpdate.getAddedObject());
                            } else if (n == 3) {
                                xMLRegistryMBeanImpl.removeXMLParserSelectRegistryEntry((XMLParserSelectRegistryEntryMBean)propertyUpdate.getRemovedObject());
                            } else {
                                throw new AssertionError((Object)("Invalid type: " + n));
                            }
                            if (xMLRegistryMBeanImpl.getXMLParserSelectRegistryEntries() == null || xMLRegistryMBeanImpl.getXMLParserSelectRegistryEntries().length == 0) {
                                xMLRegistryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 11);
                            }
                        } else if (string.equals("HandleEntityInvalidation")) {
                            xMLRegistryMBeanImpl.setHandleEntityInvalidation(xMLRegistryMBeanImpl2.isHandleEntityInvalidation());
                            xMLRegistryMBeanImpl._conditionalUnset(propertyUpdate.isUnsetUpdate(), 16);
                        } else {
                            super.applyPropertyUpdate(beanUpdateEvent, propertyUpdate);
                        }
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected AbstractDescriptorBean finishCopy(AbstractDescriptorBean abstractDescriptorBean, boolean bl, List list) {
            try {
                int n;
                ConfigurationMBean[] configurationMBeanArray;
                ConfigurationMBean[] configurationMBeanArray2;
                XMLRegistryMBeanImpl xMLRegistryMBeanImpl = (XMLRegistryMBeanImpl)abstractDescriptorBean;
                super.finishCopy(xMLRegistryMBeanImpl, bl, list);
                if ((list == null || !list.contains("DocumentBuilderFactory")) && this.bean.isDocumentBuilderFactorySet()) {
                    xMLRegistryMBeanImpl.setDocumentBuilderFactory(this.bean.getDocumentBuilderFactory());
                }
                if ((list == null || !list.contains("Name")) && this.bean.isNameSet()) {
                    xMLRegistryMBeanImpl.setName(this.bean.getName());
                }
                if ((list == null || !list.contains("SAXParserFactory")) && this.bean.isSAXParserFactorySet()) {
                    xMLRegistryMBeanImpl.setSAXParserFactory(this.bean.getSAXParserFactory());
                }
                if ((list == null || !list.contains("TransformerFactory")) && this.bean.isTransformerFactorySet()) {
                    xMLRegistryMBeanImpl.setTransformerFactory(this.bean.getTransformerFactory());
                }
                if ((list == null || !list.contains("WhenToCache")) && this.bean.isWhenToCacheSet()) {
                    xMLRegistryMBeanImpl.setWhenToCache(this.bean.getWhenToCache());
                }
                if (!(list != null && list.contains("XMLEntitySpecRegistryEntries") || !this.bean.isXMLEntitySpecRegistryEntriesSet() || xMLRegistryMBeanImpl._isSet(14))) {
                    configurationMBeanArray2 = this.bean.getXMLEntitySpecRegistryEntries();
                    configurationMBeanArray = new XMLEntitySpecRegistryEntryMBean[configurationMBeanArray2.length];
                    for (n = 0; n < configurationMBeanArray.length; ++n) {
                        configurationMBeanArray[n] = (XMLEntitySpecRegistryEntryMBean)this.createCopy((AbstractDescriptorBean)configurationMBeanArray2[n], bl);
                    }
                    xMLRegistryMBeanImpl.setXMLEntitySpecRegistryEntries((XMLEntitySpecRegistryEntryMBean[])configurationMBeanArray);
                }
                if (!(list != null && list.contains("XMLParserSelectRegistryEntries") || !this.bean.isXMLParserSelectRegistryEntriesSet() || xMLRegistryMBeanImpl._isSet(11))) {
                    configurationMBeanArray2 = this.bean.getXMLParserSelectRegistryEntries();
                    configurationMBeanArray = new XMLParserSelectRegistryEntryMBean[configurationMBeanArray2.length];
                    for (n = 0; n < configurationMBeanArray.length; ++n) {
                        configurationMBeanArray[n] = (XMLParserSelectRegistryEntryMBean)this.createCopy((AbstractDescriptorBean)configurationMBeanArray2[n], bl);
                    }
                    xMLRegistryMBeanImpl.setXMLParserSelectRegistryEntries((XMLParserSelectRegistryEntryMBean[])configurationMBeanArray);
                }
                if ((list == null || !list.contains("HandleEntityInvalidation")) && this.bean.isHandleEntityInvalidationSet()) {
                    xMLRegistryMBeanImpl.setHandleEntityInvalidation(this.bean.isHandleEntityInvalidation());
                }
                return xMLRegistryMBeanImpl;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw (Error)((Throwable)((Object)new AssertionError((Object)"Impossible Exception"))).initCause(exception);
            }
        }

        protected void inferSubTree(Class clazz, Object object) {
            super.inferSubTree(clazz, object);
            Object var3_3 = null;
            this.inferSubTree(this.bean.getEntitySpecRegistryEntries(), clazz, object);
            this.inferSubTree(this.bean.getParserSelectRegistryEntries(), clazz, object);
            this.inferSubTree(this.bean.getRegistryEntries(), clazz, object);
            this.inferSubTree(this.bean.getXMLEntitySpecRegistryEntries(), clazz, object);
            this.inferSubTree(this.bean.getXMLParserSelectRegistryEntries(), clazz, object);
        }
    }
}

