/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.context;

import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextHelper;
import weblogic.management.context.JMXContextImpl;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.workarea.NoWorkContextException;
import weblogic.workarea.PrimitiveContextFactory;
import weblogic.workarea.PropertyReadOnlyException;
import weblogic.workarea.SerializableWorkContext;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextHelper;
import weblogic.workarea.WorkContextMap;

public class JMXContextAccessImpl
implements JMXContextHelper.JMXContextAccess {
    private static final DebugLogger DEBUG_LOGGER = DebugLogger.getDebugLogger((String)"DebugJMXContext");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public JMXContext getJMXContext(boolean bl) {
        JMXContext jMXContext;
        block3: {
            jMXContext = null;
            try {
                jMXContext = (JMXContext)SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                        SerializableWorkContext serializableWorkContext = (SerializableWorkContext)workContextMap.get("weblogic.management.JMXContext");
                        if (serializableWorkContext != null) {
                            return serializableWorkContext.get();
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!DEBUG_LOGGER.isDebugEnabled()) break block3;
                DEBUG_LOGGER.debug("JMXContextAccessImpl.getJMXContext(): PrivilegedActionException: " + privilegedActionException.getStackTrace());
            }
        }
        if (bl && jMXContext == null) {
            jMXContext = new JMXContextImpl();
        }
        return jMXContext;
    }

    public void putJMXContext(final JMXContext jMXContext) {
        block2: {
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        block4: {
                            WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                            try {
                                workContextMap.put("weblogic.management.JMXContext", PrimitiveContextFactory.create((Serializable)jMXContext));
                            }
                            catch (PropertyReadOnlyException propertyReadOnlyException) {
                                if (DEBUG_LOGGER.isDebugEnabled()) {
                                    DEBUG_LOGGER.debug("JMXContextAccessImpl.putJMXContext(): WorkContext property is read-only: " + propertyReadOnlyException.getStackTrace());
                                }
                            }
                            catch (IOException iOException) {
                                if (!DEBUG_LOGGER.isDebugEnabled()) break block4;
                                DEBUG_LOGGER.debug("JMXContextAccessImpl.putJMXContext(): IOException: " + iOException.getStackTrace());
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!DEBUG_LOGGER.isDebugEnabled()) break block2;
                DEBUG_LOGGER.debug("JMXContextAccessImpl.putJMXContext(): PrivilegedActionException: " + privilegedActionException.getStackTrace());
            }
        }
    }

    public void removeJMXContext() {
        block2: {
            try {
                SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)KERNEL_ID, (PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        block5: {
                            try {
                                WorkContextMap workContextMap = WorkContextHelper.getWorkContextHelper().getWorkContextMap();
                                WorkContext workContext = workContextMap.get("weblogic.management.JMXContext");
                                if (workContext != null) {
                                    workContextMap.remove("weblogic.management.JMXContext");
                                }
                            }
                            catch (NoWorkContextException noWorkContextException) {
                                if (DEBUG_LOGGER.isDebugEnabled()) {
                                    DEBUG_LOGGER.debug("JMXContextAccessImpl.removeJMXContext(): No WorkContext is available: " + noWorkContextException.getMessage());
                                }
                            }
                            catch (PropertyReadOnlyException propertyReadOnlyException) {
                                if (!DEBUG_LOGGER.isDebugEnabled()) break block5;
                                DEBUG_LOGGER.debug("JMXContextAccessImpl.removeJMXContext(): WorkContext property is read-only: " + propertyReadOnlyException.getMessage());
                            }
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (!DEBUG_LOGGER.isDebugEnabled()) break block2;
                DEBUG_LOGGER.debug("JMXContextAccessImpl.removeJMXContext(): PrivilegedActionException: " + privilegedActionException.getStackTrace());
            }
        }
    }
}

