/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressObject;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.j2ee.J2EEUtils;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ConfigurationError;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.deploy.GenericAppPoller;
import weblogic.management.deploy.internal.ApplicationPollerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.ManagementServiceRestricted;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.FileUtils;

public class ApplicationsDirPoller
extends GenericAppPoller {
    private static final boolean debug = false;
    private static final boolean debug2 = false;
    private static final boolean methodTrace = false;
    private static final int MIN_POLLER_INTERVAL = 3000;
    private WebLogicDeploymentManager deployer;
    private boolean firstRun;
    private static final String LAST_RUN_FILE_NAME = ".app_poller_lastrun";
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static DomainMBean domain = ManagementService.getRuntimeAccess(kernelId).getDomain();
    private static final String SERVER_CACHE_DIR = ApplicationsDirPoller.ensureCacheDirInitialized();
    private Set filesBeingCopied = new HashSet();

    private static String ensureCacheDirInitialized() {
        String string = DomainDir.getCacheDirForServer((String)ManagementService.getPropertyService(kernelId).getServerName());
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        return string;
    }

    private ApplicationsDirPoller(File file, boolean bl, long l, String string) {
        super(file, bl, l, string);
        boolean bl2;
        if (!this.startDirFound && !(bl2 = file.mkdir())) {
            ApplicationPollerLogger.logCouldnotCreateAutodeployDir((String)file.toString());
        }
        this.setSleepInterval(l);
        this.firstRun = true;
        try {
            this.doit();
        }
        catch (Throwable throwable) {
            ApplicationPollerLogger.logThrowableOnServerStartup((Throwable)throwable);
        }
    }

    public ApplicationsDirPoller(File file, boolean bl, long l) {
        this(file, bl, l, SERVER_CACHE_DIR + File.separatorChar + LAST_RUN_FILE_NAME);
    }

    protected final boolean shouldActivate(File file) {
        if (this.ignoreFile(file)) {
            return false;
        }
        if (file.isDirectory()) {
            Long l = this.getLastCheckPoint(file);
            if (l == null) {
                this.setCheckPoint(file, new Date().getTime());
                return true;
            }
            File file2 = this.getRedeployFile(file);
            if (file2 == null) {
                return false;
            }
            this.setCheckPoint(file, file2.lastModified());
            return file2.lastModified() > l;
        }
        if (J2EEUtils.isValidArchiveName(file.getName()) || J2EEUtils.isValidWLSModuleName(file.getName())) {
            return super.shouldActivate(file);
        }
        return false;
    }

    public final void doActivate() {
        if (this.verbose) {
            Debug.say((String)"doActivate");
        }
        Iterator iterator = this.getActivateFileList().iterator();
        while (iterator.hasNext()) {
            DeploymentOptions deploymentOptions = this.createDeploymentOptions();
            boolean bl = false;
            String string = (String)iterator.next();
            File file = new File(string);
            String string2 = this.getUnusedNameForApp(file);
            deploymentOptions.setName(string2);
            AppDeploymentMBean appDeploymentMBean = ManagementService.getRuntimeAccess(kernelId).getDomain().lookupAppDeployment(string2);
            if (appDeploymentMBean != null) {
                bl = true;
                if (this.firstRun) {
                    ApplicationPollerLogger.logRedeployingOnStartup((String)string2);
                }
            }
            String string3 = file.getAbsolutePath();
            try {
                file = file.getCanonicalFile();
                string3 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string4 = null;
            if (!bl) {
                string4 = file.isDirectory() ? "nostage" : "stage";
                deploymentOptions.setStageMode(string4);
            }
            try {
                if ((!file.isDirectory() || !bl) && this.fileIsLocked(file)) continue;
                ApplicationPollerLogger.logActivate((String)string2);
                String string5 = DomainDir.getRootDir();
                ApplicationsDirPoller.debugSay(" +++ rootDir (before canonicalization) : " + string5);
                File file2 = new File(string5);
                try {
                    string5 = file2.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ApplicationsDirPoller.debugSay(" +++ rootDir : " + string5);
                ApplicationsDirPoller.debugSay(" +++ fileCanPath : " + string3);
                this.ensureDeploymentMgrInitialized();
                deploymentOptions.setDefaultSubmoduleTargets(domain.isAutoDeployForSubmodulesEnabled());
                ProgressObject progressObject = this.deployer.deploy(new TargetModuleID[0], new File(string3), null, deploymentOptions);
                if (progressObject.getDeploymentStatus().isFailed()) {
                    throw new ManagementException(progressObject.getDeploymentStatus().getMessage());
                }
                if (file.isDirectory()) {
                    this.warnOnManagedServerTargets(progressObject, string2);
                }
                this.waitForTimeout(progressObject);
            }
            catch (ManagementException managementException) {
                ApplicationPollerLogger.logThrowableOnActivate((String)string2, (Throwable)managementException);
            }
            catch (TargetException targetException) {
                ApplicationPollerLogger.logThrowableOnActivate((String)string2, (Throwable)targetException);
            }
            catch (DeploymentManagerCreationException deploymentManagerCreationException) {
                ApplicationPollerLogger.logThrowableOnActivate((String)string2, (Throwable)deploymentManagerCreationException);
            }
        }
        this.firstRun = false;
    }

    public final void doDeactivate() {
        for (String string : this.getDeactivateFileList()) {
            File file = new File(string);
            String string2 = this.getUnusedNameForApp(file);
            try {
                AppDeploymentMBean appDeploymentMBean = domain.lookupAppDeployment(string2);
                if (appDeploymentMBean == null) continue;
                ApplicationPollerLogger.logRemove((String)string2);
                TargetModuleID[] targetModuleIDArray = new TargetModuleID[]{};
                DeploymentOptions deploymentOptions = this.createDeploymentOptions();
                deploymentOptions.setName(string2);
                this.ensureDeploymentMgrInitialized();
                ProgressObject progressObject = null;
                try {
                    progressObject = this.deployer.undeploy(targetModuleIDArray, deploymentOptions);
                }
                catch (Exception exception) {
                    throw new ManagementException((Throwable)exception);
                }
                if (progressObject.getDeploymentStatus().isFailed()) {
                    throw new ManagementException(progressObject.getDeploymentStatus().getMessage());
                }
                this.waitForTimeout(progressObject);
            }
            catch (ManagementException managementException) {
                ApplicationPollerLogger.logThrowableOnDeactivate((String)string2, (Throwable)managementException);
            }
            catch (DeploymentManagerCreationException deploymentManagerCreationException) {
                ApplicationPollerLogger.logThrowableOnDeactivate((String)string2, (Throwable)deploymentManagerCreationException);
            }
        }
    }

    private DeploymentOptions createDeploymentOptions() {
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        deploymentOptions.setUseNonexclusiveLock(true);
        deploymentOptions.setOperationInitiatedByAutoDeployPoller(true);
        return deploymentOptions;
    }

    private void warnOnManagedServerTargets(ProgressObject progressObject, String string) {
        TargetModuleID[] targetModuleIDArray = progressObject.getResultTargetModuleIDs();
        if (targetModuleIDArray != null) {
            HashSet<Target> hashSet = new HashSet<Target>();
            for (int i = 0; i < targetModuleIDArray.length; ++i) {
                TargetModuleID targetModuleID = targetModuleIDArray[i];
                hashSet.add(targetModuleID.getTarget());
            }
            if (hashSet.size() > 1) {
                ApplicationPollerLogger.logWarnOnManagedServerTargets((String)string);
            }
        }
    }

    private void waitForTimeout(ProgressObject progressObject) {
        boolean bl = false;
        while (!bl) {
            DeploymentStatus deploymentStatus = progressObject.getDeploymentStatus();
            if (!deploymentStatus.isRunning()) {
                return;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setSleepInterval(long l) {
        if (l < 3000L) {
            super.setSleepInterval(3000L);
        } else {
            super.setSleepInterval(l);
        }
    }

    public static void removeStagedFilesForAppsRemovedSinceLastShutdown() {
        Object object;
        Object object2;
        Object object3;
        File file = new File(DomainDir.getAppPollerDir());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        AppDeploymentMBean[] appDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(domain);
        for (int i = 0; appDeploymentMBeanArray != null && i < appDeploymentMBeanArray.length; ++i) {
            File file2;
            object3 = appDeploymentMBeanArray[i];
            object2 = object3.getAbsoluteSourcePath();
            if (object2 == null || !ApplicationsDirPoller.isInAppsDir(file, (String)object2) || (file2 = new File((String)object2)).exists()) continue;
            object = ManagementService.getRuntimeAccess(kernelId).getServer().getStagingDirectoryName() + File.separatorChar + object3.getName();
            FileUtils.remove((File)new File((String)object));
            AppDeploymentHelper.destroyAppOrLib((AppDeploymentMBean)object3, domain);
            if (object3.isInternalApp()) continue;
            arrayList.add(object3);
        }
        if (arrayList.size() == 0) {
            return;
        }
        AppDeploymentMBean[] appDeploymentMBeanArray2 = arrayList.toArray(new AppDeploymentMBean[0]);
        object3 = ManagementServiceRestricted.getEditAccess(kernelId);
        try {
            object3.startEdit(0, 120000, true);
        }
        catch (ManagementException managementException) {
            return;
        }
        object2 = null;
        try {
            object2 = object3.getDomainBean();
        }
        catch (ManagementException managementException) {
            return;
        }
        for (int i = 0; i < appDeploymentMBeanArray2.length; ++i) {
            object = appDeploymentMBeanArray2[i];
            String string = object.getName();
            AppDeploymentMBean appDeploymentMBean = object instanceof LibraryMBean ? object2.lookupLibrary(string) : object2.lookupAppDeployment(string);
            if (appDeploymentMBean == null) continue;
            AppDeploymentHelper.destroyAppOrLib(appDeploymentMBean, (DomainMBean)object2);
        }
        try {
            object3.saveChanges();
            object3.activateChanges(3600000L);
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fileIsLocked(File file) {
        boolean bl;
        FileInputStream fileInputStream;
        block14: {
            boolean bl2;
            block13: {
                boolean bl3;
                block12: {
                    fileInputStream = null;
                    try {
                        try {
                            if (!file.isDirectory()) {
                                fileInputStream = new FileInputStream(file);
                                this.fileFree(file);
                                bl3 = false;
                                Object var6_7 = null;
                                if (fileInputStream == null) return bl3;
                                break block12;
                            }
                            if (file.renameTo(file)) {
                                this.fileFree(file);
                                bl2 = false;
                                break block13;
                            }
                            this.fileHeld(file);
                            this.removeFileFromMap(file);
                            bl = true;
                            break block14;
                        }
                        catch (IOException iOException) {
                            this.fileHeld(file);
                            this.removeFileFromMap(file);
                            boolean bl4 = true;
                            Object var6_10 = null;
                            if (fileInputStream == null) return bl4;
                            try {
                                fileInputStream.close();
                                return bl4;
                            }
                            catch (IOException iOException3) {
                                ApplicationPollerLogger.logIOException((IOException)iOException3);
                                return bl4;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        if (fileInputStream == null) throw throwable;
                        try {}
                        catch (IOException iOException2) {
                            ApplicationPollerLogger.logIOException((IOException)iOException2);
                            fileInputStream = null;
                            throw throwable;
                        }
                        fileInputStream.close();
                        fileInputStream = null;
                        throw throwable;
                    }
                }
                try {}
                catch (IOException iOException) {
                    ApplicationPollerLogger.logIOException((IOException)iOException);
                    return bl3;
                }
                fileInputStream.close();
                return bl3;
            }
            Object var6_8 = null;
            if (fileInputStream == null) return bl2;
            try {}
            catch (IOException iOException) {
                ApplicationPollerLogger.logIOException((IOException)iOException);
                return bl2;
            }
            fileInputStream.close();
            return bl2;
        }
        Object var6_9 = null;
        if (fileInputStream == null) return bl;
        try {}
        catch (IOException iOException) {
            ApplicationPollerLogger.logIOException((IOException)iOException);
            return bl;
        }
        fileInputStream.close();
        return bl;
    }

    private void fileHeld(File file) {
        if (this.filesBeingCopied.contains(file)) {
            return;
        }
        ApplicationPollerLogger.logFileHeld((File)file);
        this.filesBeingCopied.add(file);
    }

    private void fileFree(File file) {
        if (this.filesBeingCopied.contains(file)) {
            this.filesBeingCopied.remove(file);
        }
    }

    private String getUnusedNameForApp(File file) {
        Object object;
        Object object2;
        Object object3;
        int n;
        String string = file.getName();
        String string2 = J2EEUtils.isValidArchiveName(string) ? new String(J2EEUtils.getArchiveName(string) + "_" + J2EEUtils.getArchivePostfix(string)) : (J2EEUtils.isValidWLSModuleName(string) ? new String(J2EEUtils.getWLSModuleName(string) + "_" + J2EEUtils.getWLSModulePostfix(string)) : string + "_dir");
        String string3 = string2 = "_appsdir_" + string2;
        AppDeploymentMBean[] appDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(domain);
        for (n = 0; appDeploymentMBeanArray != null && n < appDeploymentMBeanArray.length; ++n) {
            AppDeploymentMBean appDeploymentMBean = appDeploymentMBeanArray[n];
            if (appDeploymentMBean.isInternalApp()) continue;
            object3 = appDeploymentMBean.getAbsoluteSourcePath();
            object2 = new File((String)object3);
            try {
                object = ((File)object2).getCanonicalFile();
                File file2 = file.getCanonicalFile();
                if (!((File)object).equals(file2)) continue;
                return appDeploymentMBean.getName();
            }
            catch (IOException iOException) {
                ApplicationPollerLogger.logIOException((IOException)iOException);
            }
        }
        n = 0;
        int n2 = 0;
        while (n == 0) {
            object3 = domain.lookupAppDeployment(string2);
            if (object3 == null) {
                n = 1;
                continue;
            }
            object2 = object3.getAbsoluteSourcePath();
            try {
                object = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                ApplicationPollerLogger.logIOException((IOException)iOException);
                object = file.getAbsolutePath();
            }
            if (!((String)object2).equals(object)) {
                string2 = string3 + "-" + n2++;
                continue;
            }
            n = 1;
        }
        if (n == 0) {
            throw new ConfigurationError("cannot have more than 10000 entries with the same name");
        }
        return string2;
    }

    private File getRedeployFile(File file) {
        File file2 = new File(file.getAbsolutePath() + File.separatorChar + "META-INF" + File.separatorChar + "REDEPLOY");
        if (!file2.exists()) {
            file2 = new File(file.getAbsolutePath() + File.separatorChar + "WEB-INF" + File.separatorChar + "REDEPLOY");
        }
        if (file2.exists()) {
            return file2;
        }
        return null;
    }

    private boolean ignoreFile(File file) {
        return file.getName().startsWith(".wlnot");
    }

    private void ensureDeploymentMgrInitialized() throws DeploymentManagerCreationException {
        if (this.deployer == null) {
            this.deployer = SessionHelper.getDeploymentManager(null, null);
        }
    }

    public static boolean isInAppsDir(File file, String string) {
        String string2 = file.getName();
        try {
            file = file.getCanonicalFile();
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            ApplicationPollerLogger.logIOException((IOException)iOException);
        }
        File file2 = new File(string);
        try {
            file2 = file2.getCanonicalFile();
            string = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            ApplicationPollerLogger.logIOException((IOException)iOException);
        }
        return string.indexOf(string2) > -1;
    }

    private static void debugSay(String string) {
    }
}

