/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.InstanceNotFoundException;
import weblogic.deploy.utils.DeployerHelper;
import weblogic.deploy.utils.DeployerHelperException;
import weblogic.management.MBeanHome;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.deploy.DeployerRuntime;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.GenericAppPoller;
import weblogic.management.deploy.TargetStatus;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;

public class AutoRefreshPoller
extends GenericAppPoller {
    private FileFilter filter;
    private ApplicationMBean appMBean;
    private String appName;
    private String compName;
    private DeployerRuntimeMBean deployer;
    private DeployerHelper deployerHelper;
    private String adminURL;
    private String username;
    private String password;
    private File startDir;

    public AutoRefreshPoller(File file, boolean bl, long l, FileFilter fileFilter, ApplicationMBean applicationMBean, WebAppComponentMBean webAppComponentMBean, MBeanHome mBeanHome, String string, String string2, String string3, boolean bl2) {
        super(file, bl, l);
        this.startDir = file;
        this.verbose = bl2;
        this.filter = fileFilter;
        this.appMBean = applicationMBean;
        this.appName = applicationMBean.getName();
        this.compName = webAppComponentMBean.getName();
        this.adminURL = string;
        this.username = string2;
        this.password = string3;
        try {
            this.deployer = DeployerRuntime.getDeployerRuntime(mBeanHome);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        this.deployerHelper = new DeployerHelper(mBeanHome);
    }

    public void doActivate() {
        try {
            ArrayList arrayList = this.getActivateFileList();
            if (arrayList.size() > 0) {
                String[] stringArray = this.arrayListToStringArray(arrayList);
                stringArray = this.convertPaths(stringArray);
                if (this.verbose) {
                    this.dumpStringArray("activating files: ", stringArray);
                }
                this.uploadSource(stringArray);
                DeploymentData deploymentData = new DeploymentData(stringArray);
                deploymentData.addTargetsForComponent(this.appMBean, this.compName);
                DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = this.deployer.activate(null, this.appName, null, deploymentData, null);
                if (this.verbose) {
                    System.out.println(deploymentTaskRuntimeMBean.getDescription() + "( " + deploymentTaskRuntimeMBean.getStatus() + " )");
                    TargetStatus[] targetStatusArray = deploymentTaskRuntimeMBean.getTargets();
                    for (int i = 0; i < targetStatusArray.length; ++i) {
                        Exception[] exceptionArray = targetStatusArray[i].getMessages();
                        for (int j = 0; j < exceptionArray.length; ++j) {
                            Exception exception = exceptionArray[j];
                            System.out.println(exception.getMessage());
                        }
                    }
                }
            }
        }
        catch (ManagementException managementException) {
            System.out.println(managementException.getMessage());
        }
    }

    public void doDeactivate() {
        try {
            ArrayList arrayList = this.getDeactivateFileList();
            if (arrayList.size() > 0) {
                String[] stringArray = this.arrayListToStringArray(arrayList);
                stringArray = this.convertPaths(stringArray);
                if (this.verbose) {
                    this.dumpStringArray("removing files: ", stringArray);
                }
                DeploymentData deploymentData = new DeploymentData(stringArray);
                deploymentData.addTargetsForComponent(this.appMBean, this.compName);
                deploymentData.setDelete(true);
                DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = this.deployer.activate(null, this.appName, null, deploymentData, null);
                if (this.verbose) {
                    System.out.println(deploymentTaskRuntimeMBean.getDescription() + "( " + deploymentTaskRuntimeMBean.getStatus() + " )");
                    TargetStatus[] targetStatusArray = deploymentTaskRuntimeMBean.getTargets();
                    for (int i = 0; i < targetStatusArray.length; ++i) {
                        Exception[] exceptionArray = targetStatusArray[i].getMessages();
                        for (int j = 0; j < exceptionArray.length; ++j) {
                            Exception exception = exceptionArray[j];
                            System.out.println(exception.getMessage());
                        }
                    }
                }
            }
        }
        catch (ManagementException managementException) {
            System.out.println(managementException.getMessage());
        }
    }

    private String[] arrayListToStringArray(ArrayList arrayList) {
        String[] stringArray = new String[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n] = (String)iterator.next();
            ++n;
        }
        return stringArray;
    }

    private String[] convertPaths(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            String string;
            int n2 = this.startDir.getAbsolutePath().length() + 1;
            int n3 = stringArray[i].length();
            stringArray2[i] = string = new String(stringArray[i].substring(n2, n3));
        }
        return stringArray2;
    }

    private void uploadSource(String[] stringArray) {
        block5: {
            String string = this.startDir.getAbsolutePath();
            try {
                string = this.startDir.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string2 = null;
            try {
                string2 = this.deployerHelper.uploadSource(this.adminURL, this.username, this.password, string, stringArray, this.appName);
                if (this.verbose) {
                    System.out.println("uploaded files to: " + string2);
                }
            }
            catch (DeployerHelperException deployerHelperException) {
                if (!this.verbose) break block5;
                System.out.println(deployerHelperException.getMessage());
                this.dumpStringArray("could not upload files: ", stringArray);
            }
        }
    }

    protected final boolean shouldActivate(File file) {
        if (this.filter == null) {
            boolean bl = super.shouldActivate(file) && !file.isDirectory();
            return bl;
        }
        return this.filter.accept(file) && super.shouldActivate(file);
    }

    protected final boolean shouldDeactivate(File file) {
        if (this.filter == null) {
            boolean bl = super.shouldDeactivate(file) && !file.isDirectory();
            return bl;
        }
        return this.filter.accept(file) && super.shouldDeactivate(file);
    }
}

