/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy;

import java.security.AccessController;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import weblogic.management.Helper;
import weblogic.management.MBeanHome;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class DeployerRuntime {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static DeployerRuntimeMBean getDeployerRuntime(String string, String string2, String string3) throws IllegalArgumentException, InstanceNotFoundException {
        MBeanHome mBeanHome = Helper.getAdminMBeanHome(string, string2, string3);
        return DeployerRuntime.getDeployerRuntime(mBeanHome);
    }

    public static DeployerRuntimeMBean getDeployerRuntime(MBeanHome mBeanHome) throws IllegalArgumentException, InstanceNotFoundException {
        Set set = mBeanHome.getMBeansByType("DeployerRuntime");
        if (set == null || set.size() != 1) {
            throw new InstanceNotFoundException("Could not find the DeployerRuntime");
        }
        return (DeployerRuntimeMBean)set.iterator().next();
    }

    public static DeployerRuntimeMBean getDeployerRuntime() {
        return ManagementService.getDomainAccess(kernelId).getDeployerRuntime();
    }
}

