/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.beans.factory.InvalidTargetException;
import weblogic.deploy.internal.TargetHelper;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WebDeploymentMBean;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;

public class DeploymentData
implements Serializable {
    private static final long serialVersionUID = -1065644178659248034L;
    public static final int UNKNOWN = 0;
    public static final int CLUSTER = 1;
    public static final int SERVER = 2;
    public static final int VIRTUALHOST = 3;
    public static final int JMSSERVER = 4;
    public static final int SAFAGENT = 5;
    private String[] files;
    private boolean[] isDirectory;
    private HashMap targets = null;
    private boolean deleteFlag = false;
    private boolean isNameFromSource = false;
    private boolean isNewApp = false;
    private boolean isActionFromDeployer = false;
    private String plan = null;
    private String root = null;
    private String config = null;
    private DeploymentOptions deployOpts = new DeploymentOptions();
    private ArrayList globaltargets = new ArrayList();
    private Map moduleTargets = new HashMap();
    private Map allSubModuleTargets = new HashMap();
    public static final String STANDALONE_MODULE = "_the_standalone_module";
    private boolean standaloneModule = false;
    private boolean earmodule = false;
    private boolean planUpdate = false;
    private boolean targetsFromConfig = false;
    private String intendedState;
    private boolean remote = false;
    private boolean thinClient = false;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean enforceClusterConstraints = false;
    private int timeOut = 3600000;
    private String appDD = null;
    private String webDD = null;
    private String deploymentPrincipalName = null;

    public DeploymentData copy() {
        DeploymentData deploymentData = new DeploymentData();
        deploymentData.setFile(this.files);
        deploymentData.isDirectory = this.isDirectory;
        deploymentData.deleteFlag = this.deleteFlag;
        deploymentData.isNameFromSource = this.isNameFromSource;
        deploymentData.isNewApp = this.isNewApp;
        deploymentData.isActionFromDeployer = this.isActionFromDeployer;
        deploymentData.plan = this.plan;
        deploymentData.root = this.root;
        deploymentData.config = this.config;
        deploymentData.deployOpts = this.deployOpts;
        deploymentData.globaltargets.addAll(this.globaltargets);
        deploymentData.moduleTargets.putAll(this.moduleTargets);
        deploymentData.allSubModuleTargets.putAll(this.allSubModuleTargets);
        deploymentData.standaloneModule = this.standaloneModule;
        deploymentData.earmodule = this.earmodule;
        deploymentData.planUpdate = this.planUpdate;
        deploymentData.targetsFromConfig = this.targetsFromConfig;
        deploymentData.intendedState = this.intendedState;
        deploymentData.remote = this.remote;
        deploymentData.thinClient = this.thinClient;
        return deploymentData;
    }

    public boolean isTargetsFromConfig() {
        return this.targetsFromConfig;
    }

    public void setTargetsFromConfig(boolean bl) {
        this.targetsFromConfig = bl;
    }

    public DeploymentData() {
        this.files = null;
    }

    public DeploymentData(String[] stringArray) {
        this.files = stringArray;
    }

    public boolean usesNonExclusiveLock() {
        if (this.getDeploymentOptions() != null) {
            return this.getDeploymentOptions().usesNonExclusiveLock();
        }
        return false;
    }

    public boolean isPlanUpdate() {
        return this.planUpdate;
    }

    public void setPlanUpdate(boolean bl) {
        this.planUpdate = bl;
    }

    public boolean hasTargets() {
        return !this.globaltargets.isEmpty() || !this.moduleTargets.isEmpty() || !this.allSubModuleTargets.isEmpty();
    }

    public String[] getGlobalTargets() {
        return this.globaltargets.toArray(new String[this.globaltargets.size()]);
    }

    public boolean hasGlobalTarget(String string) {
        return this.globaltargets.contains(string);
    }

    public void addGlobalTarget(String string) {
        if (!this.hasGlobalTarget(string)) {
            this.globaltargets.add(string);
        }
    }

    public void removeGlobalTarget(String string) {
        if (this.hasGlobalTarget(string)) {
            this.globaltargets.remove(string);
        }
    }

    public void addGlobalTargets(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        this.addGlobalTargets(Arrays.asList(stringArray));
    }

    public void addGlobalTargets(List list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addGlobalTarget((String)iterator.next());
        }
    }

    public void setGlobalTargets(String[] stringArray) {
        this.globaltargets = new ArrayList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.globaltargets.add(stringArray[i]);
        }
    }

    public void addOrUpdateModuleTargets(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            this.addModuleTargets((String)entry.getKey(), (String[])entry.getValue());
        }
    }

    public Map getAllModuleTargets() {
        return this.moduleTargets;
    }

    public boolean hasModuleTargets() {
        return !this.moduleTargets.isEmpty();
    }

    public String[] getModuleTargets(String string) {
        return (String[])this.moduleTargets.get(string);
    }

    public void addModuleTarget(String string, String string2) {
        if (string2 == null || string == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        String[] stringArray = (String[])this.moduleTargets.get(string);
        String[] stringArray2 = stringArray == null ? new String[]{string2} : this.merge(stringArray, new String[]{string2});
        this.moduleTargets.put(string, stringArray2);
    }

    public void addModuleTargets(String string, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0 || string == null) {
            throw new IllegalArgumentException("No module targets to add.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addModuleTarget(string, stringArray[i]);
        }
    }

    public boolean isStandaloneModule() {
        return this.standaloneModule;
    }

    public void addSubModuleTarget(String string, String string2, String[] stringArray) throws IllegalArgumentException {
        if (stringArray == null || stringArray.length == 0 || string2 == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        HashMap<String, String[]> hashMap = (HashMap<String, String[]>)this.allSubModuleTargets.get(string = this.validateModuleName(string));
        if (hashMap == null) {
            hashMap = new HashMap<String, String[]>();
            hashMap.put(string2, stringArray);
        } else {
            String[] stringArray2 = (String[])hashMap.get(string2);
            if (stringArray2 == null) {
                hashMap.put(string2, stringArray);
            } else {
                hashMap.put(string2, this.merge(stringArray2, stringArray));
            }
        }
        this.allSubModuleTargets.put(string, hashMap);
    }

    public boolean isSubModuleTargeted(String string, String string2) {
        Map map = (Map)this.allSubModuleTargets.get(string = this.validateModuleName(string));
        if (map == null) {
            return false;
        }
        String[] stringArray = (String[])map.get(string2);
        return stringArray != null;
    }

    public void addOrUpdateSubModuleTargetsFor(String string, Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string2 = (String)entry.getKey();
            String[] stringArray = (String[])entry.getValue();
            this.addSubModuleTarget(string, string2, stringArray);
        }
    }

    public void addOrUpdateSubModuleTargets(Map map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            Map map2 = (Map)entry.getValue();
            this.addOrUpdateSubModuleTargetsFor(string, map2);
        }
    }

    public Set getAllTargetedServers(Set set) throws InvalidTargetException {
        HashSet hashSet = new HashSet();
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        TargetMBean[] targetMBeanArray = TargetHelper.lookupTargetMBeans(domainMBean, set.toArray(new String[set.size()]));
        for (int i = 0; targetMBeanArray != null && i < targetMBeanArray.length; ++i) {
            hashSet.addAll(targetMBeanArray[i].getServerNames());
        }
        return hashSet;
    }

    public Set getAllTargetedServers(Set set, DomainMBean domainMBean) throws InvalidTargetException {
        TargetMBean[] targetMBeanArray;
        HashSet hashSet = new HashSet();
        DomainMBean domainMBean2 = ManagementService.getRuntimeAccess(kernelId).getDomain();
        try {
            targetMBeanArray = TargetHelper.lookupTargetMBeans(domainMBean, set.toArray(new String[set.size()]));
        }
        catch (InvalidTargetException invalidTargetException) {
            targetMBeanArray = TargetHelper.lookupTargetMBeans(domainMBean2, set.toArray(new String[set.size()]));
        }
        for (int i = 0; targetMBeanArray != null && i < targetMBeanArray.length; ++i) {
            hashSet.addAll(targetMBeanArray[i].getServerNames());
        }
        return hashSet;
    }

    public Set getAllLogicalTargets() {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(this.globaltargets);
        for (Object object : this.moduleTargets.keySet()) {
            String[] stringArray = (String[])this.moduleTargets.get(object);
            hashSet.addAll(Arrays.asList((Object[])stringArray));
        }
        for (Object object : this.allSubModuleTargets.values()) {
            for (String[] stringArray : object.values()) {
                hashSet.addAll(Arrays.asList((Object[])stringArray));
            }
        }
        return hashSet;
    }

    private String[] merge(String[] stringArray, String[] stringArray2) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        hashSet.addAll(Arrays.asList(stringArray2));
        String[] stringArray3 = new String[hashSet.size()];
        stringArray3 = hashSet.toArray(stringArray3);
        return stringArray3;
    }

    private String validateModuleName(String string) throws IllegalArgumentException {
        if (string == null) {
            if (this.earmodule) {
                throw new IllegalArgumentException(DeployerRuntimeLogger.logAppSubModuleTargetErr());
            }
            this.standaloneModule = true;
            string = STANDALONE_MODULE;
        } else if (this.standaloneModule) {
            string = STANDALONE_MODULE;
        } else {
            this.earmodule = true;
        }
        return string;
    }

    public Map getSubModuleTargets(String string) {
        return (Map)this.allSubModuleTargets.get(string);
    }

    public Map getAllSubModuleTargets() {
        return this.allSubModuleTargets;
    }

    public boolean hasSubModuleTargets() {
        return !this.allSubModuleTargets.isEmpty();
    }

    public void addTargetsFromConfig(BasicDeploymentMBean basicDeploymentMBean) {
        this.addGlobalTargets(basicDeploymentMBean.getTargets());
        SubDeploymentMBean[] subDeploymentMBeanArray = basicDeploymentMBean.getSubDeployments();
        for (int i = 0; subDeploymentMBeanArray != null && i < subDeploymentMBeanArray.length; ++i) {
            TargetMBean[] targetMBeanArray = subDeploymentMBeanArray[i].getTargets();
            if (targetMBeanArray != null && targetMBeanArray.length > 0) {
                this.addModuleTargets(subDeploymentMBeanArray[i].getName(), this.getNames(targetMBeanArray));
            }
            this.addSubModTargetsFromConfig(subDeploymentMBeanArray[i].getSubDeployments(), subDeploymentMBeanArray[i].getName());
        }
        this.setTargetsFromConfig(true);
    }

    private void addSubModTargetsFromConfig(TargetInfoMBean[] targetInfoMBeanArray, String string) {
        for (int i = 0; targetInfoMBeanArray != null && i < targetInfoMBeanArray.length; ++i) {
            TargetMBean[] targetMBeanArray = targetInfoMBeanArray[i].getTargets();
            if (targetMBeanArray == null || targetMBeanArray.length <= 0) continue;
            this.addSubModuleTarget(string, targetInfoMBeanArray[i].getName(), this.getNames(targetMBeanArray));
        }
    }

    private String[] getNames(TargetMBean[] targetMBeanArray) {
        if (targetMBeanArray == null) {
            return null;
        }
        String[] stringArray = new String[targetMBeanArray.length];
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            stringArray[i] = targetMBeanArray[i].getName();
        }
        return stringArray;
    }

    private void addGlobalTargets(TargetMBean[] targetMBeanArray) {
        for (int i = 0; targetMBeanArray != null && i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            this.addGlobalTarget(targetMBean.getName());
        }
    }

    public String getSecurityModel() {
        return this.deployOpts.getSecurityModel();
    }

    public void setSecurityModel(String string) throws IllegalArgumentException {
        this.deployOpts.setSecurityModel(string);
    }

    public boolean isSecurityValidationEnabled() {
        return this.deployOpts.isSecurityValidationEnabled();
    }

    public void setSecurityValidationEnabled(boolean bl) {
        this.deployOpts.setSecurityValidationEnabled(bl);
    }

    public boolean isLibrary() {
        return this.deployOpts.isLibrary();
    }

    public void setLibrary(boolean bl) {
        this.deployOpts.setLibrary(bl);
    }

    public void setFile(String[] stringArray) {
        this.files = stringArray;
    }

    public void addFiles(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(this.files));
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i]);
        }
        this.files = new String[hashSet.size()];
        this.files = hashSet.toArray(this.files);
    }

    public void setDelete(boolean bl) {
        this.deleteFlag = bl;
    }

    public boolean getDelete() {
        return this.deleteFlag;
    }

    public void setClusterConstraints(boolean bl) {
        this.enforceClusterConstraints = bl;
    }

    public boolean getClusterConstraints() {
        return this.enforceClusterConstraints;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public void setTimeOut(int n) {
        this.timeOut = n;
    }

    public void setAltDescriptorPath(String string) {
        this.appDD = string;
    }

    public String getAltDescriptorPath() {
        if (this.appDD == null && this.getDeploymentOptions() != null) {
            this.appDD = this.getDeploymentOptions().getAltDD();
        }
        return this.appDD;
    }

    public void setAltWLSDescriptorPath(String string) {
        this.webDD = string;
    }

    public String getAltWLSDescriptorPath() {
        if (this.webDD == null && this.getDeploymentOptions() != null) {
            this.webDD = this.getDeploymentOptions().getAltWlsDD();
        }
        return this.webDD;
    }

    public void setDeploymentPrincipalName(String string) {
        this.deploymentPrincipalName = string;
    }

    public String getDeploymentPrincipalName() {
        if (this.deploymentPrincipalName == null && this.getDeploymentOptions() != null) {
            this.deploymentPrincipalName = this.getDeploymentOptions().getDeploymentPrincipalName();
        }
        return this.deploymentPrincipalName;
    }

    public String[] getFiles() {
        return this.files;
    }

    public boolean hasFiles() {
        return this.files != null && this.files.length > 0;
    }

    public int getTargetType(String string) {
        return TargetHelper.getTypeForTarget(string);
    }

    public void setTargetType(String string, int n) {
    }

    public boolean getIsNameFromSource() {
        return this.isNameFromSource;
    }

    public void setIsNameFromSource(boolean bl) {
        this.isNameFromSource = bl;
    }

    public String toString() {
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Delete Files:" + this.getDelete() + "\n");
        stringBuffer.append("Timeout :" + this.getTimeOut() + "\n");
        stringBuffer.append("Targets: \n");
        if (this.globaltargets != null) {
            stringArray = this.globaltargets.iterator();
            while (stringArray.hasNext()) {
                stringBuffer.append((String)stringArray.next());
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append(this.getModuleTargetsAsString());
        stringBuffer.append(this.getSubModuleTargetsAsString());
        stringBuffer.append("Files: \n");
        stringArray = this.getFiles();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (this.isDirectory != null) {
                    stringBuffer.append(" - " + (this.isDirectory[i] ? "Directory" : "File"));
                }
                stringBuffer.append("\n");
            }
        } else {
            stringBuffer.append("null\n");
        }
        stringBuffer.append("Deployment Plan: ");
        stringBuffer.append(this.plan);
        stringBuffer.append("\n");
        stringBuffer.append("App root: ").append(this.root).append("\n");
        stringBuffer.append("App config: ").append(this.config).append("\n");
        stringBuffer.append("Deployment Options: ").append(this.deployOpts).append("\n");
        return stringBuffer.toString();
    }

    private String getSubModuleTargetsAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubModuleTargets=");
        stringBuffer.append("{");
        if (this.allSubModuleTargets.isEmpty()) {
            stringBuffer.append("}");
        } else {
            Iterator iterator = this.allSubModuleTargets.entrySet().iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\n");
                Map.Entry entry = iterator.next();
                stringBuffer.append(entry.getKey()).append("=");
                stringBuffer.append(DeploymentData.toStringOfModuleTargetsOrSubmoduleTargetsMap((Map)entry.getValue())).append(", ");
            }
        }
        stringBuffer.append("\n").append("}").append("\n");
        return stringBuffer.toString();
    }

    private String getModuleTargetsAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ModuleTargets=");
        stringBuffer.append(DeploymentData.toStringOfModuleTargetsOrSubmoduleTargetsMap(this.moduleTargets));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private static String toStringOfModuleTargetsOrSubmoduleTargetsMap(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        if (map.isEmpty()) {
            stringBuffer.append(map);
        } else {
            for (Map.Entry entry : map.entrySet()) {
                stringBuffer.append(entry.getKey()).append("=");
                stringBuffer.append(DeploymentData.getStringArrayAsString((String[])entry.getValue()));
                stringBuffer.append(", ");
            }
        }
        return stringBuffer.toString();
    }

    private static String getStringArrayAsString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        if (stringArray == null || stringArray.length == 0) {
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean isNewApplication() {
        return this.isNewApp;
    }

    public void setNewApp(boolean bl) {
        this.isNewApp = bl;
    }

    public boolean isActionFromDeployer() {
        return this.isActionFromDeployer;
    }

    public void setActionFromDeployer(boolean bl) {
        this.isActionFromDeployer = bl;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.globaltargets == null) {
            this.globaltargets = new ArrayList();
        }
        if (this.moduleTargets == null) {
            this.moduleTargets = new HashMap();
        }
        if (this.allSubModuleTargets == null) {
            this.allSubModuleTargets = new HashMap();
        }
        if (this.deployOpts == null) {
            this.deployOpts = new DeploymentOptions();
        }
        if (this.targets != null && !this.targets.isEmpty()) {
            this.populateFromTargetInfos();
        }
    }

    private void populateFromTargetInfos() {
        Debug.assertion((this.targets != null ? 1 : 0) != 0);
        for (String string : this.targets.keySet()) {
            TargetInfo targetInfo = (TargetInfo)this.targets.get(string);
            String[] stringArray = targetInfo.getModules();
            if (stringArray == null) {
                this.addGlobalTarget(string);
                continue;
            }
            this.addTargetToModules(stringArray, string);
        }
    }

    public String getDeploymentPlan() {
        return this.plan;
    }

    public void setDeploymentPlan(String string) {
        this.plan = string;
    }

    public String getConfigDirectory() {
        return this.config;
    }

    public void setConfigDirectory(String string) {
        this.config = string;
    }

    public String getRootDirectory() {
        return this.root;
    }

    public void setRootDirectory(String string) {
        this.root = string;
    }

    public DeploymentOptions getDeploymentOptions() {
        return this.deployOpts;
    }

    public void setDeploymentOptions(DeploymentOptions deploymentOptions) {
        if (deploymentOptions == null) {
            deploymentOptions = new DeploymentOptions();
        }
        this.deployOpts = deploymentOptions;
    }

    public String[] getTargets() {
        Object object;
        if (this.globaltargets.isEmpty() && this.moduleTargets.isEmpty()) {
            return null;
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(this.globaltargets);
        if (!this.moduleTargets.isEmpty()) {
            object = this.getModules();
            for (int i = 0; i < ((String[])object).length; ++i) {
                hashSet.addAll(Arrays.asList((Object[])this.getModuleTargets((String)object[i])));
            }
        }
        object = new ArrayList(hashSet);
        return ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
    }

    public void addTarget(String string, String[] stringArray) {
        if (stringArray == null) {
            this.addGlobalTarget(string);
        } else {
            this.addTargetToModules(stringArray, string);
        }
    }

    private void addTargetToModules(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0 || string == null) {
            throw new IllegalArgumentException("Parameters must be non null");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addModuleTargets(stringArray[i], new String[]{string});
        }
    }

    public String[] getModulesForTarget(String string) {
        if (this.globaltargets.contains(string)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : this.moduleTargets.keySet()) {
            String[] stringArray = (String[])this.moduleTargets.get(string2);
            if (!Arrays.asList((Object[])stringArray).contains(string)) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    public void addModuleToTarget(String string, String string2) {
        if (this.globaltargets.contains(string)) {
            this.globaltargets.remove(string);
            this.addModuleTargets(string2, new String[]{string});
        }
    }

    public void addTargetsForComponent(ApplicationMBean applicationMBean, String string) throws IllegalArgumentException {
        ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
        if (applicationMBean == null || componentMBeanArray == null) {
            throw new IllegalArgumentException("No application provided");
        }
        if (string == null) {
            throw new IllegalArgumentException("No component provided");
        }
        for (int i = 0; i < componentMBeanArray.length; ++i) {
            ComponentMBean componentMBean = componentMBeanArray[i];
            if (!componentMBean.getName().equals(string)) continue;
            TargetMBean[] targetMBeanArray = componentMBean.getTargets();
            for (int j = 0; j < targetMBeanArray.length; ++j) {
                this.addModuleTargets(componentMBean.getName(), new String[]{targetMBeanArray[j].getName()});
            }
            if (!(componentMBean instanceof WebDeploymentMBean)) break;
            VirtualHostMBean[] virtualHostMBeanArray = ((WebDeploymentMBean)((Object)componentMBean)).getVirtualHosts();
            for (int j = 0; j < virtualHostMBeanArray.length; ++j) {
                this.addModuleTargets(componentMBean.getName(), new String[]{virtualHostMBeanArray[j].getName()});
            }
            break;
        }
    }

    public Set getTargetsForModule(String string) {
        if (this.globaltargets.isEmpty() && this.moduleTargets.isEmpty()) {
            return new HashSet(0);
        }
        String[] stringArray = this.getModuleTargets(string);
        if (stringArray == null) {
            return new HashSet(this.globaltargets);
        }
        return new HashSet<Object>(Arrays.asList((Object[])stringArray));
    }

    public String[] getModules() {
        return this.moduleTargets.keySet().toArray(new String[this.moduleTargets.size()]);
    }

    void setAllSubModuleTargets(Map map) {
        this.allSubModuleTargets = map;
    }

    public void setIntendedState(String string) {
        this.intendedState = string;
    }

    public String getIntendedState() {
        return this.intendedState;
    }

    public void setRemote(boolean bl) {
        this.remote = bl;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public boolean hasNoTargets() {
        String[] stringArray = this.getGlobalTargets();
        if (stringArray != null && stringArray.length > 0) {
            return false;
        }
        return !this.hasModuleTargets() && !this.hasSubModuleTargets();
    }

    public void removeCommonTargets(DeploymentData deploymentData, boolean bl) {
        this.removeCommonGlobalTargets(deploymentData, bl);
        this.removeCommonModuleTargets(deploymentData, bl);
        this.removeCommonSubModuleTargets(deploymentData, bl);
    }

    public void removeCommonGlobalTargets(DeploymentData deploymentData, boolean bl) {
        String[] stringArray = this.getGlobalTargets();
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!deploymentData.hasGlobalTarget(stringArray[i])) continue;
            if (bl) {
                this.removeGlobalTarget(stringArray[i]);
            }
            deploymentData.removeGlobalTarget(stringArray[i]);
        }
    }

    public void removeCommonModuleTargets(DeploymentData deploymentData, boolean bl) {
        if (!this.hasModuleTargets() || !deploymentData.hasModuleTargets()) {
            return;
        }
        HashMap hashMap = new HashMap(this.getAllModuleTargets());
        for (String string : hashMap.keySet()) {
            String[] stringArray = this.getModuleTargets(string);
            if (stringArray == null || stringArray.length <= 0) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl2 = deploymentData.removeModuleTarget(string, stringArray[i]);
                if (!bl2 || !bl) continue;
                this.removeModuleTarget(string, stringArray[i]);
            }
        }
    }

    public void removeCommonSubModuleTargets(DeploymentData deploymentData, boolean bl) {
        if (!this.hasSubModuleTargets() || !deploymentData.hasSubModuleTargets()) {
            return;
        }
        HashMap hashMap = new HashMap(this.getAllSubModuleTargets());
        for (String string : hashMap.keySet()) {
            HashMap hashMap2 = new HashMap((Map)hashMap.get(string));
            for (String string2 : hashMap2.keySet()) {
                String[] stringArray = (String[])hashMap2.get(string2);
                if (stringArray == null || stringArray.length <= 0) continue;
                for (int i = 0; i < stringArray.length; ++i) {
                    boolean bl2 = deploymentData.removeSubModuleTarget(string, string2, stringArray[i]);
                    if (!bl2 || !bl) continue;
                    this.removeSubModuleTarget(string, string2, stringArray[i]);
                }
            }
        }
    }

    public boolean removeModuleTarget(String string, String string2) {
        if (string2 == null || string == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        String[] stringArray = (String[])this.moduleTargets.get(string);
        if (stringArray == null || stringArray.length == 0) {
            this.moduleTargets.remove(string);
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n = arrayList.size();
        arrayList.remove(string2);
        int n2 = arrayList.size();
        if (n != n2) {
            stringArray = new String[arrayList.size()];
            if (stringArray.length == 0) {
                this.moduleTargets.remove(string);
            } else {
                stringArray = arrayList.toArray(stringArray);
                this.moduleTargets.put(string, stringArray);
            }
            return true;
        }
        return false;
    }

    public boolean removeSubModuleTarget(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        Map map = (Map)this.allSubModuleTargets.get(string);
        if (map == null || map.isEmpty()) {
            this.allSubModuleTargets.remove(string);
            return false;
        }
        String[] stringArray = (String[])map.get(string2);
        if (stringArray == null || stringArray.length == 0) {
            map.remove(string2);
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        int n = arrayList.size();
        arrayList.remove(string3);
        int n2 = arrayList.size();
        if (n != n2) {
            stringArray = new String[arrayList.size()];
            if (stringArray.length == 0) {
                map.remove(string2);
                if (map.isEmpty()) {
                    this.allSubModuleTargets.remove(string);
                }
            } else {
                stringArray = arrayList.toArray(stringArray);
                map.put(string2, stringArray);
                this.allSubModuleTargets.put(string, map);
            }
            return true;
        }
        return false;
    }

    public void setThinClient(boolean bl) {
        this.thinClient = bl;
    }

    public boolean isThinClient() {
        return this.thinClient;
    }

    class TargetInfo
    implements Serializable {
        static final long serialVersionUID = -5379313404023125526L;
        private String target;
        private HashSet modules = null;
        private int type = 0;

        TargetInfo(String string, String[] stringArray) {
            this.target = string;
            if (stringArray != null) {
                this.modules = new HashSet(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.modules.add(stringArray[i]);
                }
            }
        }

        String getTarget() {
            return this.target;
        }

        String[] getModules() {
            String[] stringArray = null;
            if (this.modules != null) {
                stringArray = this.modules.toArray(new String[0]);
            }
            return stringArray;
        }

        void addModule(String string) {
            if (this.modules == null) {
                this.modules = new HashSet();
            }
            if (string != null) {
                this.modules.add(string);
            }
        }

        int getType() {
            return this.type;
        }

        void setType(int n) {
            this.type = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getTarget());
            stringBuffer.append(": (Modules: ");
            if (this.modules != null) {
                Iterator iterator = this.modules.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append((String)iterator.next());
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append("null");
            }
            stringBuffer.append(")\n");
            return stringBuffer.toString();
        }
    }
}

