/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy;

import weblogic.application.utils.XMLWriter;
import weblogic.deploy.internal.diagnostics.ImageProvider;
import weblogic.management.deploy.DeployerRuntime;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;

public class DeploymentTaskImageProvider
extends ImageProvider {
    public void writeDiagnosticImage(XMLWriter xMLWriter) {
        if (!isAdminServer) {
            return;
        }
        DeployerRuntimeMBean deployerRuntimeMBean = DeployerRuntime.getDeployerRuntime();
        DeploymentTaskRuntimeMBean[] deploymentTaskRuntimeMBeanArray = deployerRuntimeMBean.list();
        if (deploymentTaskRuntimeMBeanArray == null) {
            xMLWriter.addElement("deployment-task-count", "0");
            return;
        }
        xMLWriter.addElement("deployment-task-count", "" + deploymentTaskRuntimeMBeanArray.length);
        for (int i = 0; i < deploymentTaskRuntimeMBeanArray.length && !this.timedOut; ++i) {
            xMLWriter.addElement("deployment-task");
            xMLWriter.addElement("id", deploymentTaskRuntimeMBeanArray[i].getId());
            xMLWriter.addElement("status", this.getState(deploymentTaskRuntimeMBeanArray[i].getState()));
            DeploymentTaskRuntime.DeploymentAction deploymentAction = DeploymentTaskRuntime.DeploymentAction.getDeploymentAction(deploymentTaskRuntimeMBeanArray[i].getTask());
            xMLWriter.addElement("operation", deploymentAction.getDescription());
            xMLWriter.addElement("application-name", deploymentTaskRuntimeMBeanArray[i].getApplicationName());
            xMLWriter.closeElement();
            xMLWriter.flush();
        }
    }

    private String getState(int n) {
        switch (n) {
            case 0: {
                return "initialized";
            }
            case 1: {
                return "running";
            }
            case 2: {
                return "completed";
            }
            case 3: {
                return "failed";
            }
            case 4: {
                return "deferred";
            }
        }
        return "unknown";
    }
}

