/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ReflectionException;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.beans.factory.InvalidTargetException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.event.BaseDeploymentEvent;
import weblogic.deploy.event.DeploymentEvent;
import weblogic.deploy.event.DeploymentEventManager;
import weblogic.deploy.event.VetoableDeploymentEvent;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.adminserver.DeploymentManager;
import weblogic.deploy.internal.adminserver.EditAccessHelper;
import weblogic.deploy.internal.adminserver.operations.AbstractOperation;
import weblogic.deploy.internal.adminserver.operations.OperationHelper;
import weblogic.deploy.internal.adminserver.operations.RemoveOperation;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.service.DeploymentRequestSubTask;
import weblogic.deploy.service.internal.DeploymentRequestTaskRuntimeMBeanImpl;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateFailedException;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.logging.Loggable;
import weblogic.management.ApplicationException;
import weblogic.management.DeploymentException;
import weblogic.management.DeploymentNotification;
import weblogic.management.ManagementException;
import weblogic.management.RemoteNotificationListener;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.JMSServerMBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.configuration.SAFAgentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.configuration.WebDeploymentMBean;
import weblogic.management.context.JMXContext;
import weblogic.management.context.JMXContextHelper;
import weblogic.management.deploy.DeployerRuntimeTextTextFormatter;
import weblogic.management.deploy.DeploymentCompatibilityEventHandler;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.TargetStatus;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.ComponentTargetValidator;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.RetirementManager;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentRequestTaskRuntimeMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.TaskRuntimeMBean;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;
import weblogic.utils.StringUtils;

public final class DeploymentTaskRuntime
extends DomainRuntimeMBeanDelegate
implements DeploymentTaskRuntimeMBean,
DeploymentRequestSubTask,
BeanUpdateListener {
    private static final long serialVersionUID = 7987828709785973087L;
    private final int task;
    private final DeploymentAction deploymentAction;
    private final String sourcePath;
    private final DeploymentData requestData;
    private String[] targets;
    private boolean hasTargets;
    private TargetStatus[] targetsStatus;
    private Map targetStatusMap = new HashMap();
    private Map serverToTargetStatusMap = new HashMap();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private HashSet pendingServers = new HashSet();
    private int deploymentTaskStatus = 0;
    private String deploymentTaskStatusMessage;
    private String applicationName;
    private String applicationId;
    private String applicationVersionIdentifier;
    private int failedStatusCount;
    private final String taskId;
    private long startTime;
    private long endTime;
    private Exception lastException;
    private ApplicationMBean applicationMBean;
    private AppDeploymentMBean appDeployMBean;
    private BasicDeploymentMBean basicDeployMBean;
    private String applicationDisplayName;
    private volatile boolean failedTaskAsTargetNotUp;
    private int cancelState = 0;
    private boolean isNewApplication;
    private final Set unreachableTargets;
    private final Map versionTargetStatusMap = new HashMap();
    private static final transient DeployerRuntimeTextTextFormatter fmt = DeployerRuntimeTextTextFormatter.getInstance();
    private static final String TASK_NAME_PREFIX = "ADTR-";
    private final String saveSource;
    private String deploymentTaskDescription;
    private int notifLevel = 1;
    private boolean sysTask;
    private DeploymentTaskListener appListener;
    private final transient ArrayList taskMessages = new ArrayList();
    private static transient DomainMBean domainMBean;
    private static DeploymentManager depMgr;
    private transient DeploymentRequestTaskRuntimeMBean myParent;
    private transient DomainMBean editableDomainMBean;
    private final transient boolean isAControlOperation;
    private static final AppRuntimeStateManager appRTStateMgr;
    private boolean retired = false;
    private boolean configChange = false;
    private transient AuthenticatedSubject subject = null;
    private boolean pendingActivation = false;
    private HashMap failedTargets = new HashMap();
    private transient AbstractOperation adminOperation = null;
    private transient DeploymentTaskRuntime delegate = null;
    private transient List delegators = Collections.synchronizedList(new ArrayList());
    private Locale clientLocale = null;
    private boolean inUse;
    private final HashSet handlers = new HashSet();

    public DeploymentTaskRuntime(String string, BasicDeploymentMBean basicDeploymentMBean, DeploymentData deploymentData, String string2, int n, DomainMBean domainMBean, boolean bl, boolean bl2) throws ManagementException {
        super(TASK_NAME_PREFIX + string2, ManagementService.getDomainAccess(kernelId).getDomainRuntime().getDeployerRuntime(), false);
        this.setClientLocale();
        this.initMBeans(basicDeploymentMBean);
        this.taskId = string2;
        this.task = n;
        this.isAControlOperation = bl;
        this.configChange = bl2;
        this.deploymentAction = DeploymentAction.getDeploymentAction(n);
        this.sourcePath = string;
        this.saveSource = string == null ? this.getSourcePath() : string;
        this.requestData = deploymentData == null ? new DeploymentData() : deploymentData;
        if (domainMBean != null) {
            this.editableDomainMBean = domainMBean;
        }
        this.initializeTask();
        this.setDescription();
        if (deploymentData != null) {
            this.isNewApplication = deploymentData.isNewApplication();
        }
        this.unreachableTargets = new HashSet();
        this.register();
    }

    private AuthenticatedSubject getSubject() {
        return this.subject;
    }

    public void setSubject(AuthenticatedSubject authenticatedSubject) {
        this.debugSay("subject set to " + authenticatedSubject);
        this.subject = authenticatedSubject;
        if (this.callerOwnsEditLock() && this.editableDomainMBean != null) {
            this.editableDomainMBean.addBeanUpdateListener(this);
        }
    }

    public void initMBeans(BasicDeploymentMBean basicDeploymentMBean) {
        this.basicDeployMBean = basicDeploymentMBean;
        if (basicDeploymentMBean instanceof AppDeploymentMBean) {
            this.appDeployMBean = (AppDeploymentMBean)basicDeploymentMBean;
            this.applicationMBean = this.appDeployMBean.getAppMBean();
        }
    }

    public boolean isPendingActivation() {
        return this.pendingActivation;
    }

    public void setPendingActivation(boolean bl) {
        this.pendingActivation = bl;
        if (bl) {
            this.addMessage(DeployerRuntimeLogger.pendingActivationLoggable().getMessage(this.getClientLocale()));
        }
    }

    private String getSourcePath() {
        if (this.basicDeployMBean != null) {
            return this.basicDeployMBean.getSourcePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DomainMBean getDomain() {
        if (this.editableDomainMBean != null) {
            return this.editableDomainMBean;
        }
        if (domainMBean != null) return domainMBean;
        Class<DeploymentTaskRuntime> clazz = DeploymentTaskRuntime.class;
        synchronized (DeploymentTaskRuntime.class) {
            if (domainMBean != null) return domainMBean;
            domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return domainMBean;
        }
    }

    private static DeploymentManager getDepMgr() {
        if (depMgr == null) {
            depMgr = DeploymentManager.getInstance(kernelId);
        }
        return depMgr;
    }

    public AppDeploymentMBean getAppDeploymentMBean() {
        if (this.endTime > 0L) {
            return this.getCurrentApp();
        }
        return this.appDeployMBean;
    }

    public synchronized void printLog(PrintWriter printWriter) {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating printLog() to delegate : " + deploymentTaskRuntime);
            deploymentTaskRuntime.printLog(printWriter);
            return;
        }
        Iterator iterator = this.taskMessages.iterator();
        while (iterator.hasNext()) {
            printWriter.println((String)iterator.next());
        }
    }

    public synchronized List getTaskMessages() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating getTaskMessages() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getTaskMessages();
        }
        return (ArrayList)this.taskMessages.clone();
    }

    public final boolean isAControlOperation() {
        return this.isAControlOperation;
    }

    public TargetStatus findTarget(String string) {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating findTarget() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getTargetStatus(string);
        }
        TargetStatus targetStatus = this.getTargetStatus(string);
        return targetStatus != null ? targetStatus.copy() : targetStatus;
    }

    private TargetStatus getTargetStatus(String string) {
        return (TargetStatus)this.targetStatusMap.get(string);
    }

    public synchronized void updateTargetStatus(String string, int n, Exception exception) {
        if (this.deploymentTaskStatus != 1) {
            return;
        }
        List list = this.getTargetStatusesForServer(string);
        this.debugSay(" Pending Servers : " + this.pendingServers);
        if (list != null) {
            for (TargetStatus targetStatus : list) {
                this.debugSay("Updating target status to " + n + " for target " + targetStatus.getTarget() + " from server " + string);
                this.doUpdateTargetStatus(targetStatus, n, exception);
                this.addStatusMessage(n, this.applicationDisplayName, string);
            }
            if (n == 4 && string != null && string.length() > 0) {
                this.addUnreachableTarget(string);
            }
        } else {
            this.debugSay("Could not find a target status objects for target " + string + " - ignoring the status and will proceed by" + " setting the status on the task : " + n);
            if (this.targetsStatus != null) {
                for (int i = 0; i < this.targetsStatus.length; ++i) {
                    if (!this.targetsStatus[i].isTargetListEmpty()) continue;
                    this.doUpdateTargetStatus(this.targetsStatus[i], n, new Exception(DeployerRuntimeLogger.emptyCluster((String)this.targetsStatus[i].getTarget())));
                }
            }
        }
        if (exception != null) {
            Loggable loggable = DeployerRuntimeLogger.logExceptionReceivedLoggable((String)this.getDescription(), (String)exception.getMessage());
            this.addMessage(loggable.getMessage(this.getClientLocale()));
            this.addMessagesFromApplicationException(exception);
            this.lastException = exception;
        }
        if (n == 2 || n == 3 || n == 4) {
            this.pendingServers.remove(string);
            this.debugSay("Removed target: " + string + " from pending server " + "list");
            this.debugSay(this.dumpPendingServerList());
            if (n == 2) {
                if (exception != null) {
                    this.debugSay("DeploymentTaskRuntime: Adding target '" + string + "' with exception: " + exception + " to failed targets list");
                    this.failedTargets.put(string, exception);
                }
                ++this.failedStatusCount;
            }
        }
        if (this.pendingServers.isEmpty()) {
            if (this.failedStatusCount == 0) {
                this.finishUp(true, this.targets);
            } else {
                this.handleFailure();
            }
        }
        this.debugSay("Current status is " + this.deploymentTaskStatusMessage);
        this.debugSay(this.deploymentAction.getDescription() + " for " + this.applicationDisplayName + " took : " + (System.currentTimeMillis() - this.startTime) + " millis");
    }

    private void addStatusMessage(int n, String string, String string2) {
        String string3 = DeployHelper.getTaskName(this.task, this.getClientLocale());
        switch (n) {
            case 0: {
                this.addMessage(DeployerRuntimeLogger.logInitStatusLoggable((String)string3, (String)this.applicationDisplayName, (String)string2).getMessage(this.getClientLocale()));
                break;
            }
            case 1: {
                this.addMessage(DeployerRuntimeLogger.logProgressStatusLoggable((String)string3, (String)this.applicationDisplayName, (String)string2).getMessage(this.getClientLocale()));
                break;
            }
            case 2: {
                this.addMessage(DeployerRuntimeLogger.logFailedStatusLoggable((String)string3, (String)this.applicationDisplayName, (String)string2).getMessage(this.getClientLocale()));
                break;
            }
            case 3: {
                this.addMessage(DeployerRuntimeLogger.logSuccessStatusLoggable((String)string3, (String)this.applicationDisplayName, (String)string2).getMessage(this.getClientLocale()));
                break;
            }
            case 4: {
                this.addMessage(DeployerRuntimeLogger.logUnavailableStatusLoggable((String)string3, (String)this.applicationDisplayName, (String)string2).getMessage(this.getClientLocale()));
            }
        }
    }

    private void doUpdateTargetStatus(TargetStatus targetStatus, int n, Exception exception) {
        targetStatus.setState(n);
        if (exception != null) {
            this.debugSay("adding exception for target (" + exception.getMessage() + ")");
            targetStatus.addMessage(exception);
        }
    }

    public void handleFailure() {
        this.finishUp(false, null);
    }

    private void finishUp(boolean bl, String[] stringArray) {
        boolean bl2;
        if (this.isComplete()) {
            return;
        }
        this.debugSay("Completing task...");
        this.endTime = System.currentTimeMillis();
        this.removeAppListener();
        this.retirePreviousActiveVersion();
        if (this.getAdminOperation() instanceof RemoveOperation && !(bl2 = this.getDeploymentData().getDeploymentOptions().isGracefulProductionToAdmin())) {
            RetirementManager.waitForRetirementCompleteIfNeeded(this.getApplicationName(), this.getApplicationVersionIdentifier());
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("DTR.finishup for, app=" + this.getApplicationName() + ", version=" + this.getApplicationVersionIdentifier());
            }
        }
        if (bl) {
            if (this.task == 4) {
                if (this.getCurrentApp() == null) {
                    DeploymentTaskRuntime.removeAppRuntimeState(this.applicationId);
                } else {
                    DeploymentTaskRuntime.removeAppRuntimeStateForTargets(this.applicationId, stringArray);
                }
            }
            if (this.task == 4 && this.getCurrentApp() == null) {
                this.removeUploadedSource();
            }
            if (this.unreachableTargets.isEmpty()) {
                this.setState(2);
            } else {
                this.setState(4);
            }
        } else {
            this.setState(3);
        }
        this.logCompletion();
    }

    private static void removeAppRuntimeState(String string) {
        try {
            AppRuntimeStateManager.getManager().remove(string);
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
    }

    private static void removeAppRuntimeStateForTargets(String string, String[] stringArray) {
        try {
            AppRuntimeStateManager.getManager().removeTargets(string, stringArray);
        }
        catch (ManagementException managementException) {
            // empty catch block
        }
    }

    private void removeUploadedSource() {
        String string = ManagementService.getRuntimeAccess(kernelId).getServer().getUploadDirectoryName();
        if (this.appDeployMBean != null) {
            if (string.startsWith("." + File.separator)) {
                string = string.substring(2);
            }
            String string2 = this.appDeployMBean.getSourcePath();
            this.removeIfUploaded(string2, string);
            string2 = this.appDeployMBean.getPlanDir();
            this.removeIfUploaded(string2, string);
        }
    }

    private void removeIfUploaded(String string, String string2) {
        if (string != null && string.indexOf(string2) != -1) {
            File file = new File(string2);
            File file2 = new File(string);
            File file3 = null;
            do {
                file3 = file2.getParentFile();
                FileUtils.remove((File)file2);
            } while (!file.equals(file2 = file3) && file2.listFiles().length == 0);
        }
    }

    private void addMessagesFromApplicationException(Exception exception) {
        if (exception instanceof ApplicationException) {
            ApplicationException applicationException = (ApplicationException)((Object)exception);
            Hashtable hashtable = applicationException.getModuleErrors();
            for (String string : hashtable.keySet()) {
                String string2 = (String)hashtable.get(string);
                Loggable loggable = DeployerRuntimeLogger.logModuleMessageLoggable((String)string, (String)string2);
                this.addMessage(loggable.getMessage(this.getClientLocale()));
            }
        }
    }

    public void start() throws ManagementException {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating start() to delegate : " + deploymentTaskRuntime);
            deploymentTaskRuntime.start();
            return;
        }
        try {
            DeploymentTaskRuntime.getDepMgr().startDeploymentTask(this, this.applicationDisplayName);
        }
        catch (Throwable throwable) {
            Loggable loggable = DeployerRuntimeLogger.logExceptionOccurredLoggable((String)this.deploymentAction.getDescription(), (String)this.applicationDisplayName, (Exception)new Exception(throwable));
            loggable.log();
            if (throwable instanceof ManagementException) {
                throw (ManagementException)throwable;
            }
            throw new ManagementException(throwable);
        }
    }

    public void prepareToStart() throws ManagementException {
        if (this.hasDelegate()) {
            this.debugSay("Doing nothing in prepareToStart() since this task has been delegated to : " + this.getDelegate());
            return;
        }
        this.updateIntendedState();
        this.setUpStartedStateVariables();
        try {
            if (this.hasTargets && this.applicationMBean != null) {
                switch (this.task) {
                    case 4: {
                        break;
                    }
                    case 9: 
                    case 10: {
                        if (this.isNewApplication) {
                            Loggable loggable = DeployerRuntimeLogger.logNullAppLoggable((String)this.applicationDisplayName, (String)this.deploymentAction.getDescription());
                            loggable.log();
                            throw new ManagementException(loggable.getMessage());
                        }
                    }
                    case 1: 
                    case 7: 
                    case 11: {
                        if (this.sourcePath != null) {
                            this.destage();
                        }
                        if (this.task == 9 && (this.applicationMBean.getDeploymentType().equals(ApplicationMBean.TYPE_EAR) || this.applicationMBean.getDeploymentType().equals(ApplicationMBean.TYPE_COMPONENT))) {
                            this.destage();
                        }
                        if (this.task == 9 && (this.applicationMBean.getDeploymentType().equals(ApplicationMBean.TYPE_EXPLODED_COMPONENT) || this.applicationMBean.getDeploymentType().equals(ApplicationMBean.TYPE_EXPLODED_EAR)) && this.requestData.getFiles() == null) {
                            this.destage();
                        }
                        this.addTargets(this.task != 7);
                        break;
                    }
                    case 3: 
                    case 8: 
                    case 13: {
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        this.destage();
                        break;
                    }
                }
            }
        }
        catch (ManagementException managementException) {
            for (int i = 0; i < this.targetsStatus.length; ++i) {
                this.updateTargetStatus(this.targetsStatus[i].getTarget(), 2, (Exception)((Object)managementException));
            }
            if (!this.isComplete()) {
                this.setLastException(managementException);
                this.handleFailure();
            }
            throw managementException;
        }
    }

    public void cancel() throws Exception {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating cancel() to delegate : " + deploymentTaskRuntime);
            deploymentTaskRuntime.cancel();
            return;
        }
        if (this.myParent == null) {
            this.prepareToCancel();
        } else {
            this.myParent.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareToCancel() throws Exception {
        if (this.hasDelegate()) {
            this.debugSay("Doing nothing in prepareToCancel() since this task has been delegated to : " + this.getDelegate());
            return;
        }
        DeploymentTaskRuntime deploymentTaskRuntime = this;
        synchronized (deploymentTaskRuntime) {
            this.setCancelState(2);
            if (this.deploymentTaskStatus == 2 || this.deploymentTaskStatus == 3) {
                Loggable loggable = DeployerRuntimeLogger.logErrorCannotCancelCompletedTaskLoggable((String)this.taskId);
                loggable.log();
                this.lastException = new UnsupportedOperationException(loggable.getMessage());
                throw this.lastException;
            }
        }
    }

    private void setUpStartedStateVariables() throws ManagementException {
        this.assertNotAlreadyStarted();
        DeployerRuntimeLogger.logStartedDeployment((String)this.getDescription(), (String)this.applicationDisplayName);
        this.setPendingActivation(false);
        this.setState(1);
        this.updateAllTargetStatus(1);
        this.startTime = System.currentTimeMillis();
        this.validateAppDeploy();
        if (DeploymentTaskRuntime.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Starting deployment of " + this.applicationDisplayName + " at " + new Date(this.startTime));
            if (this.targetStatusMap != null) {
                stringBuffer.append(" to: '");
                Iterator iterator = this.targetStatusMap.keySet().iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append((String)iterator.next());
                    stringBuffer.append(" ");
                }
                stringBuffer.append("'");
            }
            this.debugSay(stringBuffer.toString());
        }
    }

    private void assertNotAlreadyStarted() throws ManagementException {
        if (this.getState() != 0) {
            Loggable loggable = DeployerRuntimeLogger.logAlreadyStartedLoggable();
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    private void replaceTargets(TargetMBean[] targetMBeanArray, ComponentMBean componentMBean) {
        ConfigurationMBean configurationMBean = null;
        if (targetMBeanArray != null) {
            try {
                for (int i = 0; i < targetMBeanArray.length; ++i) {
                    configurationMBean = targetMBeanArray[i];
                    if (configurationMBean == null) continue;
                    componentMBean.addTarget((TargetMBean)configurationMBean);
                }
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                Loggable loggable = DeployerRuntimeLogger.logNoSuchTargetLoggable((String)configurationMBean.getName());
                loggable.log();
                this.setLastException(configurationMBean.getName(), new ManagementException(loggable.getMessage(), (Throwable)invalidAttributeValueException));
            }
            catch (ManagementException managementException) {
                this.debugSay("Rcvd mgmt exception: " + managementException.toString());
                this.setLastException(configurationMBean.getName(), managementException);
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                this.debugSay("Rcvd unknown exception: " + undeclaredThrowableException.toString());
                Throwable throwable = undeclaredThrowableException.getUndeclaredThrowable();
                if (throwable instanceof ReflectionException) {
                    throwable = ((ReflectionException)throwable).getTargetException();
                }
                Loggable loggable = DeployerRuntimeLogger.logAddTargetLoggable((String)configurationMBean.getName(), (String)componentMBean.getName());
                loggable.log();
                this.setLastException(configurationMBean.getName(), new ManagementException(loggable.getMessage(), throwable));
            }
        }
    }

    private static void initializeDeploymentDataTypes(DeploymentData deploymentData) {
        String[] stringArray = deploymentData.getTargets();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            deploymentData.setTargetType(stringArray[i], TargetHelper.getTypeForTarget(stringArray[i]));
        }
    }

    private void initializeTask() throws ManagementException {
        if (this.appDeployMBean != null) {
            this.applicationName = this.appDeployMBean.getApplicationName();
            this.applicationId = this.appDeployMBean.getApplicationIdentifier();
            this.applicationVersionIdentifier = this.appDeployMBean.getVersionIdentifier();
        } else {
            this.applicationId = this.applicationName = this.basicDeployMBean.getName();
        }
        this.applicationDisplayName = ApplicationVersionUtils.getDisplayName(this.basicDeployMBean);
        this.addListenerToAppMBean();
        this.debugSay("Initializing deployment task for: " + this.basicDeployMBean);
        if (!this.requestData.hasTargets()) {
            this.requestData.addTargetsFromConfig(this.basicDeployMBean);
        }
        this.initTargetDataInTask(this.requestData);
        this.setState(0);
        this.debugSay("Normalized task info: " + this.requestData.toString());
    }

    private void setTargetTypes(DeploymentData deploymentData) throws ManagementException {
        try {
            this.debugSay("Validating target list: " + StringUtils.join((String[])deploymentData.getTargets(), (String)","));
            DeploymentTaskRuntime.initializeDeploymentDataTypes(deploymentData);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Loggable loggable = DeployerRuntimeLogger.logUnconfigTargetsLoggable(new ArrayList<Object>(Arrays.asList((Object[])deploymentData.getTargets())));
            loggable.log();
            throw this.setLastException(new ManagementException(loggable.getMessage(), (Throwable)illegalArgumentException));
        }
    }

    private synchronized String dumpPendingServerList() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PendingServers set : ");
        if (this.pendingServers == null) {
            stringBuffer.append("null");
        } else {
            Iterator iterator = this.pendingServers.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(" ");
                stringBuffer.append((String)iterator.next());
            }
        }
        return stringBuffer.toString();
    }

    private void initTargetDataInTask(DeploymentData deploymentData) throws ManagementException {
        if (deploymentData.hasTargets()) {
            this.hasTargets = true;
            this.setTargetTypes(this.requestData);
            Set set = deploymentData.getAllLogicalTargets();
            try {
                this.pendingServers = (HashSet)deploymentData.getAllTargetedServers(set, this.editableDomainMBean);
                this.debugSay(this.dumpPendingServerList());
            }
            catch (InvalidTargetException invalidTargetException) {
                this.debugSay("initTargetDataInTask: InvalidTargetException for target: " + invalidTargetException.toString());
                throw new ManagementException((Throwable)invalidTargetException);
            }
            String[] stringArray = set.toArray(new String[0]);
            this.targets = stringArray;
            this.initializeTargetStatuses(set);
        }
    }

    private void initializeTargetStatuses(Set set) {
        String string;
        int n = set.size();
        Iterator iterator = set.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.trim().equals("")) {
                --n;
            }
            ++n2;
        }
        this.targetsStatus = new TargetStatus[n];
        iterator = set.iterator();
        n2 = 0;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (string.trim().equals("")) continue;
            this.targetsStatus[n2] = new TargetStatus(string);
            this.addToServerToTargetStatusMap(string, this.targetsStatus[n2]);
            ++n2;
        }
        for (int i = 0; i < this.targetsStatus.length; ++i) {
            this.debugSay("Adding: " + this.targetsStatus[i].getTarget() + " to targetStatusMap");
            this.targetStatusMap.put(this.targetsStatus[i].getTarget(), this.targetsStatus[i]);
        }
    }

    private AppDeploymentMBean lookupAppDeployment(String string) {
        if (this.editableDomainMBean != null) {
            return this.editableDomainMBean.lookupAppDeployment(string);
        }
        return null;
    }

    private static ServerMBean lookupServer(String string, DomainMBean domainMBean) {
        return domainMBean.lookupServer(string);
    }

    private ServerMBean lookupServer(String string) {
        ServerMBean serverMBean = null;
        if (this.editableDomainMBean != null) {
            serverMBean = DeploymentTaskRuntime.lookupServer(string, this.editableDomainMBean);
        }
        if (serverMBean == null) {
            serverMBean = DeploymentTaskRuntime.lookupServer(string, ManagementService.getRuntimeAccess(kernelId).getDomain());
        }
        return serverMBean;
    }

    private static ClusterMBean lookupCluster(String string, DomainMBean domainMBean) {
        return domainMBean.lookupCluster(string);
    }

    private ClusterMBean lookupCluster(String string) {
        ClusterMBean clusterMBean = null;
        if (this.editableDomainMBean != null) {
            clusterMBean = DeploymentTaskRuntime.lookupCluster(string, this.editableDomainMBean);
        }
        if (clusterMBean == null) {
            clusterMBean = DeploymentTaskRuntime.lookupCluster(string, ManagementService.getRuntimeAccess(kernelId).getDomain());
        }
        return clusterMBean;
    }

    private static JMSServerMBean lookupJMSServer(String string, DomainMBean domainMBean) {
        return domainMBean.lookupJMSServer(string);
    }

    private static SAFAgentMBean lookupSAFAgent(String string, DomainMBean domainMBean) {
        return domainMBean.lookupSAFAgent(string);
    }

    private static VirtualHostMBean lookupVirtualHost(String string, DomainMBean domainMBean) {
        return domainMBean.lookupVirtualHost(string);
    }

    private JMSServerMBean lookupJMSServer(String string) {
        JMSServerMBean jMSServerMBean = null;
        if (this.editableDomainMBean != null) {
            jMSServerMBean = DeploymentTaskRuntime.lookupJMSServer(string, this.editableDomainMBean);
        }
        if (jMSServerMBean == null) {
            jMSServerMBean = DeploymentTaskRuntime.lookupJMSServer(string, ManagementService.getRuntimeAccess(kernelId).getDomain());
        }
        return jMSServerMBean;
    }

    private SAFAgentMBean lookupSAFAgent(String string) {
        SAFAgentMBean sAFAgentMBean = null;
        if (this.editableDomainMBean != null) {
            sAFAgentMBean = DeploymentTaskRuntime.lookupSAFAgent(string, this.editableDomainMBean);
        }
        if (sAFAgentMBean == null) {
            sAFAgentMBean = DeploymentTaskRuntime.lookupSAFAgent(string, ManagementService.getRuntimeAccess(kernelId).getDomain());
        }
        return sAFAgentMBean;
    }

    private VirtualHostMBean lookupVirtualHost(String string) {
        VirtualHostMBean virtualHostMBean = null;
        if (this.editableDomainMBean != null) {
            virtualHostMBean = DeploymentTaskRuntime.lookupVirtualHost(string, this.editableDomainMBean);
        }
        if (virtualHostMBean == null) {
            virtualHostMBean = DeploymentTaskRuntime.lookupVirtualHost(string, ManagementService.getRuntimeAccess(kernelId).getDomain());
        }
        return virtualHostMBean;
    }

    private void addToServerToTargetStatusMap(String string, TargetStatus targetStatus) {
        ServerMBean serverMBean = this.lookupServer(string);
        if (serverMBean != null) {
            this.debugSay("Adding " + serverMBean + " to server target status");
            targetStatus.setTargetListEmpty(false);
            this.checkAndAddToServerToTargetStatusMap(string, targetStatus);
        } else {
            ClusterMBean clusterMBean = this.lookupCluster(string);
            if (clusterMBean != null) {
                ServerMBean[] serverMBeanArray = clusterMBean.getServers();
                targetStatus.setTargetListEmpty(serverMBeanArray == null || serverMBeanArray.length == 0);
                for (int i = 0; i < serverMBeanArray.length; ++i) {
                    this.debugSay("Adding " + serverMBeanArray[i].getName() + " to target status for cluster: " + clusterMBean.getName());
                    this.checkAndAddToServerToTargetStatusMap(serverMBeanArray[i].getName(), targetStatus);
                }
            } else {
                JMSServerMBean jMSServerMBean = this.lookupJMSServer(string);
                if (jMSServerMBean != null) {
                    TargetMBean[] targetMBeanArray = jMSServerMBean.getTargets();
                    this.addLogicTargetToMap(targetMBeanArray, jMSServerMBean.getName(), targetStatus);
                } else {
                    SAFAgentMBean sAFAgentMBean = this.lookupSAFAgent(string);
                    if (sAFAgentMBean != null) {
                        TargetMBean[] targetMBeanArray = sAFAgentMBean.getTargets();
                        this.addLogicTargetToMap(targetMBeanArray, sAFAgentMBean.getName(), targetStatus);
                    } else {
                        VirtualHostMBean virtualHostMBean = this.lookupVirtualHost(string);
                        if (virtualHostMBean != null) {
                            TargetMBean[] targetMBeanArray = virtualHostMBean.getTargets();
                            this.addLogicTargetToMap(targetMBeanArray, virtualHostMBean.getName(), targetStatus);
                        }
                    }
                }
            }
            this.dumpServerToTargetStatusMap();
        }
    }

    private void checkAndAddToServerToTargetStatusMap(String string, TargetStatus targetStatus) {
        ArrayList<TargetStatus> arrayList = (ArrayList<TargetStatus>)this.serverToTargetStatusMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<TargetStatus>();
            arrayList.add(targetStatus);
        } else if (!arrayList.contains(targetStatus)) {
            arrayList.add(targetStatus);
        }
        this.serverToTargetStatusMap.put(string, arrayList);
    }

    private void addLogicTargetToMap(TargetMBean[] targetMBeanArray, String string, TargetStatus targetStatus) {
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            targetStatus.setTargetListEmpty(true);
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            Set object = targetMBeanArray[i].getServerNames();
            if (object == null) continue;
            if (hashSet.isEmpty() || Collections.disjoint(hashSet, object)) {
                hashSet.addAll(object);
                continue;
            }
            if (hashSet.containsAll(object)) continue;
            for (String string2 : object) {
                if (hashSet.contains(string2)) continue;
                hashSet.add(string2);
            }
        }
        this.debugSay("Collected distinct server list : " + hashSet);
        targetStatus.setTargetListEmpty(hashSet.isEmpty());
        for (String string3 : hashSet) {
            this.debugSay("Adding " + string3 + " to target status for target: " + string);
            this.checkAndAddToServerToTargetStatusMap(string3, targetStatus);
        }
    }

    private void dumpServerToTargetStatusMap() {
        if (DeploymentTaskRuntime.isDebugEnabled() && this.serverToTargetStatusMap != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("serverToTargetStatusMap for task: ");
            stringBuffer.append(this.taskId);
            for (String string : this.serverToTargetStatusMap.keySet()) {
                stringBuffer.append("\ntarget: ");
                stringBuffer.append(string);
                stringBuffer.append(" statuses: ");
                List list = (List)this.serverToTargetStatusMap.get(string);
                if (list == null) continue;
                Iterator iterator = list.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    if (n > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(iterator.next());
                }
                stringBuffer.append("\n");
            }
            Debug.deploymentDebug(stringBuffer.toString());
        }
    }

    private void logCompletion() {
        int n = this.getState();
        switch (n) {
            case 4: {
                DeployerRuntimeLogger.logTaskDeferred((String)this.getDescription());
                break;
            }
            case 2: {
                DeployerRuntimeLogger.logTaskSuccess((String)this.getDescription());
                break;
            }
            case 3: {
                Exception exception = this.getError();
                String string = this.applicationDisplayName != null ? DeployerRuntimeLogger.logTaskFailed((String)this.applicationDisplayName, (String)DeployHelper.getTaskName(this.task)) : DeployerRuntimeLogger.logTaskFailedNoApp((String)DeployHelper.getTaskName(this.task));
                if (exception == null) break;
                DeployerRuntimeLogger.logTrace((String)string, (Exception)exception);
            }
        }
    }

    private void destage() {
        this.applicationMBean.unstageTargets(this.targets);
    }

    public synchronized void updatePendingServersWithSuccess() {
        if (this.deploymentTaskStatus == 1) {
            if (this.pendingServers == null || this.pendingServers.isEmpty()) {
                this.updateTargetStatus(null, 3, null);
                return;
            }
            HashSet hashSet = (HashSet)this.pendingServers.clone();
            for (String string : hashSet) {
                this.updateTargetStatus(string, 3, null);
            }
        }
    }

    public void updateAllTargetsWithSuccessForMerging() {
        this.setState(1);
        this.updateAllTargetStatus(1);
        this.updatePendingServersWithSuccess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllTargetStatus(int n) {
        TargetStatus[] targetStatusArray = this.targetsStatus;
        if (targetStatusArray == null) {
            return;
        }
        DeploymentTaskRuntime deploymentTaskRuntime = this;
        synchronized (deploymentTaskRuntime) {
            for (int i = 0; i < targetStatusArray.length; ++i) {
                if (this.deploymentTaskStatus != 1) continue;
                targetStatusArray[i].setState(n);
            }
        }
    }

    private void addTargets(boolean bl) throws ManagementException {
        int n;
        ConfigurationMBean configurationMBean = null;
        DeploymentMBean[] deploymentMBeanArray = this.applicationMBean.getComponents();
        for (n = 0; n < deploymentMBeanArray.length; ++n) {
            ComponentTargetValidator componentTargetValidator = new ComponentTargetValidator(deploymentMBeanArray[n]);
            for (Object object : this.requestData.getTargetsForModule(deploymentMBeanArray[n].getName())) {
                this.debugSay("Checking target " + (String)object);
                componentTargetValidator.addTarget((String)object, this.editableDomainMBean, bl);
            }
        }
        for (n = 0; n < this.targets.length; ++n) {
            Object object;
            boolean bl2 = true;
            String string = this.targets[n];
            object = this.requestData.getModulesForTarget(string);
            int n2 = this.requestData.getTargetType(string);
            if (object == null || ((String[])object).length == 0) {
                this.debugSay("No Modules Specified");
                deploymentMBeanArray = this.applicationMBean.getComponents();
                bl2 = false;
            } else {
                this.debugSay("Modules Specified");
                HashSet hashSet = new HashSet();
                for (int i = 0; i < ((String[])object).length; ++i) {
                    hashSet = this.addComponentToSet(hashSet, object[i]);
                }
                deploymentMBeanArray = hashSet.toArray(new DeploymentMBean[hashSet.size()]);
            }
            try {
                for (int i = 0; i < deploymentMBeanArray.length; ++i) {
                    Object object2;
                    configurationMBean = deploymentMBeanArray[i];
                    if (n2 == 3) {
                        if (configurationMBean instanceof WebDeploymentMBean) {
                            object2 = this.getDomain().lookupVirtualHost(string);
                            this.debugSay("Adding virtual host " + (String)string + " for module, " + configurationMBean.getName());
                            if (object2 == null) continue;
                            ((WebAppComponentMBean)configurationMBean).addVirtualHost((VirtualHostMBean)object2);
                            continue;
                        }
                        if (!bl2) continue;
                        Loggable loggable = DeployerRuntimeLogger.logInvalidTargetForComponentLoggable((String)this.applicationDisplayName, (String)configurationMBean.getName(), (String)string);
                        loggable.log();
                        throw new ManagementException(loggable.getMessage());
                    }
                    object2 = new TargetMBean[]{this.getTargetMBean(string)};
                }
                continue;
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                Loggable loggable = DeployerRuntimeLogger.logNoSuchTargetLoggable((String)string);
                loggable.log();
                this.setLastException(string, new ManagementException(loggable.getMessage(), (Throwable)invalidAttributeValueException));
                continue;
            }
            catch (ManagementException managementException) {
                this.debugSay("Rcvd mgmt exception: " + managementException.toString());
                this.setLastException(string, managementException);
                continue;
            }
            catch (UndeclaredThrowableException undeclaredThrowableException) {
                this.debugSay("Rcvd unknown exception: " + undeclaredThrowableException.toString());
                Throwable throwable = undeclaredThrowableException.getUndeclaredThrowable();
                if (throwable instanceof ReflectionException) {
                    throwable = ((ReflectionException)throwable).getTargetException();
                }
                Loggable loggable = DeployerRuntimeLogger.logAddTargetLoggable((String)string, (String)configurationMBean.getName());
                loggable.log();
                this.setLastException(string, new ManagementException(loggable.getMessage(), throwable));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Loggable loggable = DeployerRuntimeLogger.logAddTargetLoggable((String)string, (String)configurationMBean.getName());
                loggable.log();
                this.setLastException(string, new ManagementException(loggable.getMessage(), (Throwable)illegalArgumentException));
            }
        }
    }

    private HashSet addComponentToSet(HashSet hashSet, String string) {
        this.debugSay("looking for component " + string);
        ComponentMBean[] componentMBeanArray = this.applicationMBean.getComponents();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < componentMBeanArray.length; ++i) {
            ComponentMBean componentMBean = componentMBeanArray[i];
            this.debugSay("found name = " + componentMBean.getName() + ", with uri " + componentMBean.getURI());
            if (i == componentMBeanArray.length - 1) {
                stringBuffer.append(componentMBean.getName() + " ");
            } else {
                stringBuffer.append(componentMBean.getName() + ", ");
            }
            if (!componentMBean.getName().equals(string)) continue;
            hashSet.add(componentMBean);
            this.debugSay("Found the component " + string);
        }
        return hashSet;
    }

    private synchronized void addMessage(String string) {
        this.taskMessages.add(string);
    }

    private void setClientLocale() {
        JMXContext jMXContext = JMXContextHelper.getJMXContext(false);
        if (jMXContext != null) {
            this.clientLocale = jMXContext.getLocale();
        }
    }

    private Locale getClientLocale() {
        return this.clientLocale;
    }

    private void addListenerToAppMBean() {
        if (this.applicationMBean != null) {
            this.getDeploymentObject().addNotificationListener(this.appListener, new DeployFilter(), this.getId());
        }
    }

    private void removeAppListener() {
        if (this.getDeploymentObject() != null) {
            try {
                this.getDeploymentObject().removeNotificationListener(this.appListener);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {
                this.debugSay("remove listener ex: " + listenerNotFoundException.toString());
            }
        }
        this.appListener = null;
    }

    public void setNotificationLevel(int n) {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating setNotificationLevel() to delegate : " + deploymentTaskRuntime);
            deploymentTaskRuntime.setNotificationLevel(n);
            return;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > 2) {
            n = 2;
        }
        this.notifLevel = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(int n) {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating setState() to delegate : " + deploymentTaskRuntime);
            deploymentTaskRuntime.setState(n);
            return;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.deploymentAction.getDescription()).append(" ");
        try {
            int n2;
            switch (n) {
                case 0: {
                    stringBuffer.append(fmt.init());
                    break;
                }
                case 1: {
                    stringBuffer.append(fmt.running());
                    break;
                }
                case 3: {
                    stringBuffer.append(fmt.failed());
                    this.notifyAppDeployEnded();
                    bl = true;
                    break;
                }
                case 2: {
                    stringBuffer.append(fmt.completed());
                    this.notifyAppDeployEnded();
                    bl = true;
                    break;
                }
                case 4: {
                    stringBuffer.append(fmt.deferred());
                    this.notifyAppDeployEnded();
                    bl = true;
                    break;
                }
                default: {
                    Object var8_5 = null;
                    if (bl) {
                        this.reset();
                    }
                    return;
                }
            }
            DeploymentTaskRuntime deploymentTaskRuntime = this;
            synchronized (deploymentTaskRuntime) {
                n2 = this.deploymentTaskStatus;
                this.deploymentTaskStatus = n;
                this.deploymentTaskStatusMessage = stringBuffer.toString();
                this.debugSay("New Status for task " + this.taskId + " is " + this.deploymentTaskStatus + ":" + this.deploymentTaskStatusMessage);
            }
            this._postSet("State", n2, n);
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (bl) {
                this.reset();
            }
            throw throwable;
        }
        Object var8_6 = null;
        if (bl) {
            this.reset();
        }
    }

    public void setSystemTask(boolean bl) {
        this.sysTask = bl;
    }

    private void reset() {
        block11: {
            this.debugSay("Resetting task " + this.getId());
            this.appDeployMBean = null;
            this.applicationMBean = null;
            this.versionTargetStatusMap.clear();
            this.basicDeployMBean = null;
            this.appListener = null;
            this.adminOperation = null;
            if (!this.callerOwnsEditLock()) {
                this.editableDomainMBean = null;
            } else if (this.editableDomainMBean != null) {
                this.editableDomainMBean.removeBeanUpdateListener(this);
                this.editableDomainMBean = null;
            }
            if (this.myParent != null) {
                try {
                    ((DeploymentRequestTaskRuntimeMBeanImpl)this.myParent).unregister();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                this.myParent = null;
            }
            if (!this.delegators.isEmpty()) {
                for (DeploymentTaskRuntime deploymentTaskRuntime : this.delegators) {
                    deploymentTaskRuntime.reset();
                }
                this.delegators.clear();
            }
            if (this.configChange) {
                try {
                    this.unregister();
                }
                catch (ManagementException managementException) {
                    if (!Debug.isDeploymentDebugEnabled()) break block11;
                    Debug.deploymentDebug("Remove DeploymentTaskRuntimeMBean failed for id: " + this.taskId + ", ex:" + managementException.getMessage());
                }
            }
        }
    }

    private AppDeploymentMBean getCurrentApp() {
        AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getAppDeployment(this.getDomain(), this.applicationId, null);
        return appDeploymentMBean;
    }

    private boolean callerOwnsEditLock() {
        if (this.getSubject() == null) {
            return false;
        }
        DeploymentManager deploymentManager = DeploymentManager.getInstance(kernelId);
        EditAccessHelper editAccessHelper = deploymentManager.getEditAccessHelper(kernelId);
        return editAccessHelper.isCurrentEditor(this.getSubject());
    }

    private void setDescription() {
        String string = DeployHelper.getTaskName(this.task);
        Set set = this.requestData.getAllLogicalTargets();
        String string2 = StringUtils.join((String[])set.toArray(new String[set.size()]), (String)",");
        Loggable loggable = this.requestData.isLibrary() ? DeployerRuntimeLogger.logLibraryDescriptionLoggable((String)this.applicationDisplayName, (String)string2, (String)string) : DeployerRuntimeLogger.logDescriptionLoggable((String)this.applicationDisplayName, (String)string2, (String)string);
        this.deploymentTaskDescription = loggable.getMessage();
        this.debugSay("New task: " + this.deploymentTaskDescription);
    }

    private ManagementException setLastException(String string, ManagementException managementException) {
        TargetStatus targetStatus;
        this.lastException = managementException;
        if (string != null && (targetStatus = this.getTargetStatus(string)) != null) {
            targetStatus.addMessage((Exception)((Object)managementException));
            targetStatus.setState(2);
        }
        return managementException;
    }

    private ManagementException setLastException(ManagementException managementException) {
        return this.setLastException(null, managementException);
    }

    public RuntimeMBean getMBean() {
        return this;
    }

    public String getSource() {
        return this.saveSource;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public String getDescription() {
        return this.deploymentTaskDescription;
    }

    public String getStatus() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating getStatus() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getStatus();
        }
        return this.deploymentTaskStatusMessage;
    }

    public boolean isRunning() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating isRunning() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.isRunning();
        }
        int n = this.getState();
        return this.cancelState != 8 && n != 2 && n != 3 && n != 4;
    }

    public long getBeginTime() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating getBeginTime() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getBeginTime();
        }
        return this.startTime;
    }

    public long getEndTime() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating getEndTime() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getEndTime();
        }
        return this.endTime;
    }

    public Exception getError() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating getError() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getError();
        }
        return this.lastException;
    }

    public int getTask() {
        return this.task;
    }

    public ApplicationMBean getDeploymentObject() {
        if (this.endTime > 0L) {
            AppDeploymentMBean appDeploymentMBean = this.getCurrentApp();
            return appDeploymentMBean == null ? null : appDeploymentMBean.getAppMBean();
        }
        return this.applicationMBean;
    }

    public BasicDeploymentMBean getDeploymentMBean() {
        return this.basicDeployMBean;
    }

    public String getApplicationVersionIdentifier() {
        return this.applicationVersionIdentifier;
    }

    public DeploymentData getDeploymentData() {
        return this.requestData;
    }

    public TargetStatus[] getTargets() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating getTargets() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getTargets();
        }
        TargetStatus[] targetStatusArray = null;
        if (this.targetsStatus != null) {
            targetStatusArray = new TargetStatus[this.targetsStatus.length];
            for (int i = 0; i < this.targetsStatus.length; ++i) {
                targetStatusArray[i] = this.targetsStatus[i].copy();
            }
        }
        return targetStatusArray;
    }

    public String getId() {
        return this.taskId;
    }

    public int getNotificationLevel() {
        return this.notifLevel;
    }

    public Map getVersionTargetStatusMap() {
        return this.versionTargetStatusMap;
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public void setInUse(boolean bl) {
        this.inUse = bl;
    }

    public synchronized int getState() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating getState() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getState();
        }
        return this.deploymentTaskStatus;
    }

    public boolean isSystemTask() {
        return this.sysTask;
    }

    private boolean hasFiles() {
        return this.requestData != null && this.requestData.getFiles() != null && this.requestData.getFiles().length > 0;
    }

    public boolean hasTargets() {
        return this.hasTargets;
    }

    public TaskRuntimeMBean[] getSubTasks() {
        return null;
    }

    public TaskRuntimeMBean getParentTask() {
        return null;
    }

    public TaskRuntimeMBean getMyParent() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating getMyParent() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getMyParent();
        }
        return this.myParent;
    }

    public void setMyParent(TaskRuntimeMBean taskRuntimeMBean) {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating setMyParent() to delegate : " + deploymentTaskRuntime);
            deploymentTaskRuntime.setMyParent(taskRuntimeMBean);
            return;
        }
        this.myParent = (DeploymentRequestTaskRuntimeMBean)taskRuntimeMBean;
    }

    public synchronized boolean isComplete() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating isComplete() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.isComplete();
        }
        if (this.deploymentTaskStatus == 2 || this.deploymentTaskStatus == 3 || this.deploymentTaskStatus == 4) {
            return true;
        }
        this.debugSay("DeploymentTaskRuntime: isComplete status for task  id: " + this.getId() + " is 'false' " + "deploymentStatus: " + this.deploymentTaskStatus + ", pending servers: " + this.dumpPendingServerList());
        return false;
    }

    public final synchronized Map getFailedTargets() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating getFailedTargets() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getFailedTargets();
        }
        return (Map)this.failedTargets.clone();
    }

    public HashSet getAllPhysicalServers() {
        HashSet hashSet = new HashSet();
        Set set = this.serverToTargetStatusMap.keySet();
        hashSet.addAll(set);
        return hashSet;
    }

    private TargetMBean getTargetMBean(String string) {
        TargetMBean targetMBean = this.getDomain().lookupServer(string);
        if (targetMBean == null) {
            targetMBean = this.getDomain().lookupCluster(string);
        }
        return targetMBean;
    }

    private List getTargetStatusesForServer(String string) {
        this.dumpServerToTargetStatusMap();
        return (List)this.serverToTargetStatusMap.get(string);
    }

    public boolean isTaskFailedAsTargetNotUp() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating isTaskFailedAsTargetNotUp() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.isTaskFailedAsTargetNotUp();
        }
        return this.failedTaskAsTargetNotUp;
    }

    public void setTaskFailedAsTargetNotUp(boolean bl) {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating setTaskFailedAsTargetNotUp() to delegate : " + deploymentTaskRuntime);
            deploymentTaskRuntime.setTaskFailedAsTargetNotUp(bl);
            return;
        }
        this.failedTaskAsTargetNotUp = true;
    }

    private void debugSay(String string) {
        if (DeploymentTaskRuntime.isDebugEnabled()) {
            Debug.deploymentDebug("[" + this.taskId + "]:" + string);
        }
    }

    private static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCancelState(int n) {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating setCancelState() to delegate : " + deploymentTaskRuntime);
            deploymentTaskRuntime.setCancelState(n);
            return;
        }
        DeploymentTaskRuntime deploymentTaskRuntime = this;
        synchronized (deploymentTaskRuntime) {
            this.cancelState = n;
        }
        this.debugSay("cancel state set to " + this.getCancelStateString());
        if (this.cancelState == 8) {
            this.reset();
        }
    }

    public synchronized int getCancelState() {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating getCancelState() to delegate : " + deploymentTaskRuntime);
            return deploymentTaskRuntime.getCancelState();
        }
        return this.cancelState;
    }

    private void validateAppDeploy() throws ManagementException {
        String[] stringArray;
        if (this.basicDeployMBean == null) {
            return;
        }
        boolean bl = this.requestData == null ? false : this.requestData.isNewApplication();
        String[] stringArray2 = this.requestData == null ? null : this.requestData.getModules();
        String[] stringArray3 = stringArray = this.requestData == null ? null : this.requestData.getTargets();
        if (this.task == 1) {
            DeploymentEventManager.sendVetoableDeploymentEvent(VetoableDeploymentEvent.create(this, VetoableDeploymentEvent.APP_ACTIVATE, this.basicDeployMBean, bl, stringArray2, stringArray));
        } else if (this.task == 11 || this.task == 9 || this.task == 10) {
            DeploymentEventManager.sendVetoableDeploymentEvent(VetoableDeploymentEvent.create(this, VetoableDeploymentEvent.APP_DEPLOY, this.basicDeployMBean, bl, stringArray2, stringArray));
        } else if (this.task == 7) {
            DeploymentEventManager.sendVetoableDeploymentEvent(VetoableDeploymentEvent.create(this, VetoableDeploymentEvent.APP_START, this.basicDeployMBean, bl, stringArray2, stringArray));
        } else if (this.task == 4 || this.task == 12) {
            DeploymentEventManager.sendVetoableDeploymentEvent(VetoableDeploymentEvent.create(this, VetoableDeploymentEvent.APP_UNDEPLOY, this.basicDeployMBean, false, stringArray2, stringArray));
        }
    }

    private void notifyAppDeployEnded() {
        String[] stringArray;
        if (this.appDeployMBean == null) {
            return;
        }
        String[] stringArray2 = this.requestData == null ? null : this.requestData.getModules();
        String[] stringArray3 = stringArray = this.requestData == null ? null : this.requestData.getTargets();
        if (this.task == 1) {
            DeploymentEventManager.sendDeploymentEvent(DeploymentEvent.create(this, DeploymentEvent.APP_ACTIVATED, this.appDeployMBean, stringArray2, stringArray));
        } else if (this.task == 11 || this.task == 9 || this.task == 10) {
            BaseDeploymentEvent.EventType eventType = DeploymentEvent.APP_DEPLOYED;
            if (this.task == 9 || this.task == 10) {
                eventType = DeploymentEvent.APP_REDEPLOYED;
            }
            DeploymentEventManager.sendDeploymentEvent(DeploymentEvent.create(this, eventType, this.appDeployMBean, stringArray2, stringArray));
        } else if (this.task == 7) {
            DeploymentEventManager.sendDeploymentEvent(DeploymentEvent.create(this, DeploymentEvent.APP_STARTED, this.appDeployMBean, stringArray2, stringArray));
        } else if ((this.task == 4 || this.task == 12) && this.lookupAppDeployment(this.applicationId) == null) {
            DeploymentEventManager.sendDeploymentEvent(DeploymentEvent.create(this, DeploymentEvent.APP_DELETED, this.appDeployMBean, false, stringArray2, stringArray));
        }
    }

    private void retirePreviousActiveVersion() {
        if (this.appDeployMBean == null || this.appDeployMBean.getVersionIdentifier() == null || this.task != 1 && this.task != 11 && this.task != 7 && this.task != 9 || this.hasFiles() || this.failedStatusCount != 0) {
            return;
        }
        AppDeploymentMBean appDeploymentMBean = DeploymentTaskRuntime.getPrevActiveAppDeployment(this.appDeployMBean);
        try {
            appRTStateMgr.setActiveVersion(this.applicationId, true);
        }
        catch (ManagementException managementException) {
            DeployerRuntimeLogger.logErrorPersistingActiveAppState((String)this.getDescription(), (Throwable)ManagementException.unWrapExceptions((Throwable)managementException));
        }
        if (this.appDeployMBean instanceof LibraryMBean) {
            return;
        }
        if (appDeploymentMBean != null && !this.appDeployMBean.getVersionIdentifier().equals(appDeploymentMBean.getVersionIdentifier())) {
            try {
                RetirementManager.retire(appDeploymentMBean, this.requestData);
            }
            catch (ManagementException managementException) {
                DeployerRuntimeLogger.logRetirementFailed((String)ApplicationVersionUtils.getDisplayName(appDeploymentMBean), (Throwable)managementException);
            }
        }
    }

    private static AppDeploymentMBean getPrevActiveAppDeployment(AppDeploymentMBean appDeploymentMBean) {
        if (appDeploymentMBean == null) {
            return null;
        }
        String string = appDeploymentMBean.getApplicationName();
        boolean bl = ApplicationVersionUtils.isAdminMode(appDeploymentMBean);
        String string2 = appDeploymentMBean.getVersionIdentifier();
        if (string2 == null) {
            return appDeploymentMBean;
        }
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        AppDeploymentMBean[] appDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(domainMBean);
        if (appDeploymentMBeanArray == null) {
            return null;
        }
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            AppDeploymentMBean appDeploymentMBean2 = appDeploymentMBeanArray[i];
            if (!appDeploymentMBean2.getApplicationName().equals(string) || string2.equals(appDeploymentMBean2.getVersionIdentifier()) || ApplicationVersionUtils.isAdminMode(appDeploymentMBean2) != bl || appDeploymentMBean2.getVersionIdentifier() != null && !appRTStateMgr.isActiveVersion(appDeploymentMBean2)) continue;
            return appDeploymentMBean2;
        }
        return null;
    }

    public void addUnreachableTarget(String string) {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating addUnreachableTarget() to delegate : " + deploymentTaskRuntime);
            deploymentTaskRuntime.addUnreachableTarget(string);
            return;
        }
        this.debugSay(" Adding unreachable target : " + string);
        this.unreachableTargets.add(string);
    }

    public void waitForTaskCompletion(long l) {
        if (this.hasDelegate()) {
            DeploymentTaskRuntime deploymentTaskRuntime = this.getDelegate();
            this.debugSay("Delegating waitForTaskCompletion() to delegate : " + deploymentTaskRuntime);
            deploymentTaskRuntime.waitForTaskCompletion(l);
            return;
        }
        while (this.isRunning() && (l <= 0L || l > System.currentTimeMillis())) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return;
    }

    public boolean isRetired() {
        return this.retired;
    }

    public void setRetired() {
        this.debugSay("<" + new Date() + "> <" + Thread.currentThread().getName() + "> Setting the task with id '" + this.getId() + "' as retired");
        this.retired = true;
        this.lastException = null;
        this.failedTargets.clear();
        this.targetStatusMap.clear();
        this.serverToTargetStatusMap.clear();
        this.versionTargetStatusMap.clear();
        this.targetsStatus = null;
    }

    public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
    }

    public void activateUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateFailedException {
        this.debugSay(" +++ undo changes invoked on EditableDomain");
        DescriptorBean descriptorBean = beanUpdateEvent.getSourceBean();
        this.debugSay(" +++ SourceBean on the event : " + descriptorBean);
        DescriptorBean descriptorBean2 = beanUpdateEvent.getProposedBean();
        this.debugSay(" +++ proposedBean on the event : " + descriptorBean2);
        this.debugSay(" +++ editableDomainMBean : " + this.editableDomainMBean);
        if (descriptorBean == this.editableDomainMBean || this.editableDomainMBean == null) {
            if (this.adminOperation != null) {
                this.adminOperation.undoChangesTriggeredByUser();
            }
            this.remove();
        }
    }

    public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelegator(DeploymentTaskRuntime deploymentTaskRuntime) throws DeploymentException {
        if (this == deploymentTaskRuntime) {
            throw new DeploymentException("Task '" + this.getId() + "' cannot be " + "set as deletate to itself");
        }
        DeploymentTaskRuntime deploymentTaskRuntime2 = this;
        synchronized (deploymentTaskRuntime2) {
            this.delegators.add(deploymentTaskRuntime);
            deploymentTaskRuntime.setDelegate(this);
        }
    }

    private void setDelegate(DeploymentTaskRuntime deploymentTaskRuntime) throws DeploymentException {
        if (this.hasDelegate()) {
            throw new DeploymentException("task '" + this.getId() + "' has already " + "been delegated to '" + this.getDelegate().getId() + "' and hence " + "cannot be delegated again to '" + this.delegate.getId() + "'");
        }
        this.delegate = deploymentTaskRuntime;
    }

    private boolean hasDelegate() {
        return this.delegate != null;
    }

    private DeploymentTaskRuntime getDelegate() {
        return this.delegate;
    }

    public boolean isNewSource() {
        return this.sourcePath != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(DeploymentCompatibilityEventHandler deploymentCompatibilityEventHandler) {
        HashSet hashSet = this.handlers;
        synchronized (hashSet) {
            this.handlers.add(deploymentCompatibilityEventHandler);
        }
    }

    private final String getCancelStateString() {
        switch (this.cancelState) {
            case 0: {
                return "CANCEL_STATE_NONE";
            }
            case 2: {
                return "CANCEL_STATE_STARTED";
            }
            case 4: {
                return "CANCEL_STATE_FAILED";
            }
            case 8: {
                return "CANCEL_STATE_COMPLETED";
            }
        }
        return "cancel state indeterminate";
    }

    public AbstractOperation getAdminOperation() {
        return this.adminOperation;
    }

    public void setAdminOperation(AbstractOperation abstractOperation) {
        this.adminOperation = abstractOperation;
    }

    private void updateIntendedState() throws ManagementException {
        if (DeploymentTaskRuntime.isDebugEnabled()) {
            this.debugSay("Updating intended state from task with task type : " + this.getTask());
        }
        String string = null;
        switch (this.getTask()) {
            case 1: 
            case 7: 
            case 9: 
            case 11: {
                OperationHelper.setAdminMode(this.getAppDeploymentMBean(), this.getDeploymentData(), "STATE_ACTIVE");
                break;
            }
            case 8: {
                string = "STATE_PREPARED";
                if (this.requestData.hasModuleTargets() && this.appDeployMBean != null) {
                    string = appRTStateMgr.getIntendedState(this.appDeployMBean.getName());
                }
                OperationHelper.setAdminMode(this.getAppDeploymentMBean(), this.getDeploymentData(), string);
                break;
            }
            case 2: 
            case 6: {
                string = "STATE_PREPARED";
                String string2 = appRTStateMgr.getIntendedState(this.getAppDeploymentMBean().getName());
                if (string2 != null) {
                    string = string2;
                }
                OperationHelper.setState(this.getAppDeploymentMBean(), this.getDeploymentData(), string);
                break;
            }
            case 13: {
                OperationHelper.setState(this.getAppDeploymentMBean(), this.getDeploymentData(), "STATE_NEW");
                break;
            }
        }
    }

    public void remove() {
        DeployerRuntimeMBean deployerRuntimeMBean = (DeployerRuntimeMBean)this.getParent();
        if (deployerRuntimeMBean != null) {
            this.debugSay(" +++ removing Task due to undo changes triggered by user : " + this.taskId);
            deployerRuntimeMBean.removeTask(this.taskId);
        }
        this.setCancelState(8);
    }

    static {
        appRTStateMgr = AppRuntimeStateManager.getManager();
    }

    public static abstract class DeploymentAction {
        static final DeploymentAction DEPLOY_TASK_ACTIVATE = new DeploymentAction(){

            String getDescription() {
                return fmt.messageActivate();
            }
        };
        static final DeploymentAction DEPLOY_TASK_PREPARE = new DeploymentAction(){

            String getDescription() {
                return fmt.messagePrepare();
            }
        };
        static final DeploymentAction DEPLOY_TASK_DEACTIVATE = new DeploymentAction(){

            String getDescription() {
                return fmt.messageDeactivate();
            }
        };
        static final DeploymentAction DEPLOY_TASK_REMOVE = new DeploymentAction(){

            String getDescription() {
                return fmt.messageRemove();
            }
        };
        static final DeploymentAction DEPLOY_TASK_UNPREPARE = new DeploymentAction(){

            String getDescription() {
                return fmt.messageUnprepare();
            }
        };
        static final DeploymentAction DEPLOY_TASK_DISTRIBUTE = new DeploymentAction(){

            String getDescription() {
                return fmt.messageDistribute();
            }
        };
        static final DeploymentAction DEPLOY_TASK_START = new DeploymentAction(){

            String getDescription() {
                return fmt.messageStart();
            }
        };
        static final DeploymentAction DEPLOY_TASK_STOP = new DeploymentAction(){

            String getDescription() {
                return fmt.messageStop();
            }
        };
        static final DeploymentAction DEPLOY_TASK_REDEPLOY = new DeploymentAction(){

            String getDescription() {
                return fmt.messageRedeploy();
            }
        };
        static final DeploymentAction DEPLOY_TASK_UPDATE = new DeploymentAction(){

            String getDescription() {
                return fmt.messageUpdate();
            }
        };
        static final DeploymentAction DEPLOY_TASK_DEPLOY = new DeploymentAction(){

            String getDescription() {
                return fmt.messageDeploy();
            }
        };
        static final DeploymentAction DEPLOY_TASK_RETIRE = new DeploymentAction(){

            String getDescription() {
                return fmt.messageRetire();
            }
        };

        abstract String getDescription();

        static DeploymentAction getDeploymentAction(int n) {
            switch (n) {
                case 1: {
                    return DEPLOY_TASK_ACTIVATE;
                }
                case 2: {
                    return DEPLOY_TASK_PREPARE;
                }
                case 3: {
                    return DEPLOY_TASK_DEACTIVATE;
                }
                case 4: {
                    return DEPLOY_TASK_REMOVE;
                }
                case 5: {
                    return DEPLOY_TASK_UNPREPARE;
                }
                case 6: {
                    return DEPLOY_TASK_DISTRIBUTE;
                }
                case 7: {
                    return DEPLOY_TASK_START;
                }
                case 8: {
                    return DEPLOY_TASK_STOP;
                }
                case 9: {
                    return DEPLOY_TASK_REDEPLOY;
                }
                case 10: {
                    return DEPLOY_TASK_UPDATE;
                }
                case 11: {
                    return DEPLOY_TASK_DEPLOY;
                }
                case 13: {
                    return DEPLOY_TASK_RETIRE;
                }
            }
            throw new AssertionError((Object)("Unexpected deployment action identifier: " + n));
        }
    }

    static final class DeployFilter
    implements NotificationFilter,
    Serializable {
        DeployFilter() {
        }

        public boolean isNotificationEnabled(Notification notification) {
            return notification instanceof DeploymentNotification;
        }
    }

    private final class DeploymentTaskListener
    implements RemoteNotificationListener {
        private DeploymentTaskListener() {
        }

        public void handleNotification(Notification notification, Object object) {
            if (notification instanceof DeploymentNotification) {
                DeploymentNotification deploymentNotification = (DeploymentNotification)notification;
                DeploymentTaskRuntime.this.debugSay("DTRM rcvd notification: " + deploymentNotification.getMessage());
                String string = deploymentNotification.getTask();
                boolean bl = false;
                if (string != null && object != null && object instanceof String) {
                    bl = string.equals(object);
                    if (bl) {
                        DeploymentTaskRuntime.this.debugSay("Received matching notification for task: " + string);
                    } else {
                        DeploymentTaskRuntime.this.debugSay("Skipping non-matching notification for task: " + string);
                    }
                } else {
                    DeploymentTaskRuntime.this.debugSay("Received non-matching notification for task: " + string);
                    if (object instanceof String) {
                        DeploymentTaskRuntime.this.debugSay("Skipping this notification for task: " + object);
                    }
                }
                if (bl) {
                    if (deploymentNotification.isAppNotification()) {
                        Loggable loggable = DeployerRuntimeLogger.logAppNotificationLoggable((String)deploymentNotification.getAppName(), (String)deploymentNotification.getServerName(), (String)deploymentNotification.getPhase());
                        loggable.log();
                        DeploymentTaskRuntime.this.addMessage(loggable.getMessage(DeploymentTaskRuntime.this.getClientLocale()));
                    } else if (deploymentNotification.isModuleNotification()) {
                        Loggable loggable = null;
                        if (deploymentNotification.isBeginTransition()) {
                            loggable = DeployerRuntimeLogger.logStartTransitionLoggable((String)deploymentNotification.getAppName(), (String)deploymentNotification.getModuleName(), (String)deploymentNotification.getCurrentState(), (String)deploymentNotification.getTargetState(), (String)deploymentNotification.getServerName());
                        } else if (deploymentNotification.isEndTransition()) {
                            loggable = DeployerRuntimeLogger.logSuccessfulTransitionLoggable((String)deploymentNotification.getAppName(), (String)deploymentNotification.getModuleName(), (String)deploymentNotification.getCurrentState(), (String)deploymentNotification.getTargetState(), (String)deploymentNotification.getServerName());
                        } else if (deploymentNotification.isFailedTransition()) {
                            loggable = DeployerRuntimeLogger.logFailedTransitionLoggable((String)deploymentNotification.getAppName(), (String)deploymentNotification.getModuleName(), (String)deploymentNotification.getCurrentState(), (String)deploymentNotification.getTargetState(), (String)deploymentNotification.getServerName());
                        }
                        if (loggable != null) {
                            DeploymentTaskRuntime.this.addMessage(loggable.getMessage(DeploymentTaskRuntime.this.getClientLocale()));
                        }
                    }
                }
            }
        }
    }
}

