/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import weblogic.management.deploy.internal.ApplicationPollerLogger;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.Debug;
import weblogic.utils.StringUtils;
import weblogic.work.WorkManagerFactory;

public abstract class GenericAppPoller {
    protected static boolean debug = false;
    protected static boolean methodTrace = false;
    protected boolean verbose = false;
    private boolean searchRecursively;
    private File startDir;
    private HashMap currentRunFileMap;
    private HashMap lastRunFileMap;
    private ArrayList activateFileList;
    private ArrayList deactivateFileList;
    private long pollInterval;
    private boolean runOnce;
    private Timer pollerTimer;
    private String lastRunFilename = null;
    protected boolean startDirFound = true;

    public GenericAppPoller(File file, boolean bl, long l) {
        this(file, bl, l, null);
    }

    public GenericAppPoller(File file, boolean bl, long l, String string) {
        if (methodTrace) {
            Debug.say((String)"<init>");
        }
        this.searchRecursively = bl;
        this.startDir = file;
        if (!file.exists()) {
            this.startDirFound = false;
        }
        this.runOnce = l == 0L;
        this.pollInterval = l;
        this.lastRunFilename = string;
    }

    public abstract void doActivate();

    public abstract void doDeactivate();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void runInSameThread() {
        if (methodTrace) {
            Debug.say((String)"run");
        }
        if (this.runOnce) {
            if (this.verbose) {
                Debug.say((String)"running in runOnce mode");
            }
            this.doit();
            return;
        }
        if (this.verbose) {
            Debug.say((String)"running in polling mode");
        }
        while (true) {
            try {
                while (true) {
                    if (this.verbose) {
                        Debug.say((String)("evaluating " + this.startDir.getName()));
                    }
                    this.doit();
                    if (this.verbose) {
                        Debug.say((String)("done evaluating " + this.startDir.getName()));
                    }
                    Thread.sleep(this.pollInterval);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (Throwable throwable) {
                ApplicationPollerLogger.logUncaughtThrowable((Throwable)throwable);
                continue;
            }
            break;
        }
    }

    public void start() {
        if (methodTrace) {
            Debug.say((String)"run");
        }
        if (this.runOnce) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (GenericAppPoller.this.verbose) {
                        Debug.say((String)"running in runOnce mode");
                    }
                    GenericAppPoller.this.doit();
                }
            };
            WorkManagerFactory.getInstance().getSystem().schedule(runnable);
        } else {
            if (this.verbose) {
                Debug.say((String)"running in polling mode");
            }
            this.startPollerTimerListener();
        }
    }

    public void setSleepInterval(long l) {
        this.pollInterval = l;
    }

    protected boolean shouldActivate(File file) {
        boolean bl = false;
        String string = file.getAbsolutePath();
        try {
            file = file.getCanonicalFile();
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            ApplicationPollerLogger.logIOException((IOException)iOException);
        }
        if (debug) {
            Debug.say((String)("SHOULD ACTIVATE: " + string));
        }
        if (this.lastRunFileMap.containsKey(string)) {
            long l = (Long)this.lastRunFileMap.get(string);
            if (file.lastModified() > l) {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    protected boolean shouldDeactivate(File file) {
        String string = file.getAbsolutePath();
        try {
            file = file.getCanonicalFile();
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            ApplicationPollerLogger.logIOException((IOException)iOException);
        }
        if (debug) {
            Debug.say((String)("SHOULD DEACTIVATE: " + file));
        }
        return !this.currentRunFileMap.containsKey(string);
    }

    protected final ArrayList getActivateFileList() {
        if (methodTrace) {
            Debug.say((String)"getActivateFileList");
        }
        return this.activateFileList;
    }

    protected final ArrayList getDeactivateFileList() {
        if (methodTrace) {
            Debug.say((String)"getDeactivateFileList");
        }
        return this.deactivateFileList;
    }

    protected final void doit() {
        if (methodTrace) {
            Debug.say((String)"doit");
        }
        try {
            this.getLastRunFileMap();
            this.activateFileList = new ArrayList();
            this.deactivateFileList = new ArrayList();
            this.currentRunFileMap = new HashMap();
            if (debug) {
                Debug.say((String)("START DIR " + this.startDir));
            }
            this.setCurrentRunMap(this.startDir);
        }
        catch (IOException iOException) {
            ApplicationPollerLogger.logIOException((IOException)iOException);
        }
        this.generateActivateFileList();
        this.generateDeactivateFileList();
        if (debug) {
            this.dumpHashMap("CURRENT RUN FILELIST", this.currentRunFileMap);
            this.dumpArrayList("ACTIVATE FILE LIST: ", this.activateFileList);
            this.dumpHashMap("LAST RUN FILELIST", this.lastRunFileMap);
            this.dumpArrayList("DEACTIVATE FILE LIST: ", this.deactivateFileList);
        }
        try {
            this.doActivate();
            this.doDeactivate();
        }
        catch (Throwable throwable) {
            ApplicationPollerLogger.logUncaughtThrowable((Throwable)throwable);
        }
        try {
            this.setLastRunFileMap();
        }
        catch (IOException iOException) {
            ApplicationPollerLogger.logIOException((IOException)iOException);
        }
    }

    protected File getStartDir() {
        return this.startDir;
    }

    private void setCurrentRunMap(File file) throws IOException {
        if (methodTrace) {
            Debug.say((String)"setCurrentRunMap");
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            String string = file2.getAbsolutePath();
            file2 = file2.getCanonicalFile();
            string = file2.getCanonicalPath();
            if (this.searchRecursively && file2.isDirectory()) {
                this.setCurrentRunMap(file2);
            }
            if (this.ignoreFile(file2)) continue;
            long l = file2.lastModified();
            this.currentRunFileMap.put(string, new Long(l));
        }
    }

    void removeFileFromMap(File file) {
        String string;
        block3: {
            string = file.getAbsolutePath();
            try {
                file = file.getCanonicalFile();
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                if (!debug) break block3;
                Debug.say((String)("Problem getting canonical file and path for file '" + file + "'\nwill try to remove: " + string + "\nexception message: " + iOException.getMessage()));
            }
        }
        Object v = this.currentRunFileMap.remove(string);
        if (v == null && debug) {
            this.dumpHashMap("Current run file map does not contain key: " + string, this.currentRunFileMap);
        }
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    private void generateActivateFileList() {
        if (methodTrace) {
            Debug.say((String)"generateActivateFileList");
        }
        Set set = this.currentRunFileMap.keySet();
        for (String string : set) {
            if (!this.shouldActivate(new File(string))) continue;
            this.activateFileList.add(string);
        }
    }

    private void generateDeactivateFileList() {
        if (methodTrace) {
            Debug.say((String)"generateDeactivateFileList");
        }
        String string2 = null;
        Set set = this.lastRunFileMap.keySet();
        for (String string2 : set) {
            if (!this.shouldDeactivate(new File(string2))) continue;
            this.deactivateFileList.add(string2);
        }
    }

    private boolean ignoreFile(File file) {
        if (methodTrace) {
            Debug.say((String)"ignoreFile");
        }
        return file.getName().equals(this.lastRunFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getLastRunFileMap() throws IOException {
        if (methodTrace) {
            Debug.say((String)"getLastRunFileMap");
        }
        if (this.lastRunFileMap != null) return;
        if (this.lastRunFilename == null) return;
        this.lastRunFileMap = new HashMap();
        File file = new File(this.lastRunFilename);
        if (!file.exists()) {
            if (!debug) return;
            Debug.say((String)"no previous delete file.");
            return;
        }
        if (debug) {
            Debug.say((String)("reading file " + this.lastRunFilename));
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(this.lastRunFilename)));
            String string = null;
            boolean bl = false;
            while (!bl) {
                string = bufferedReader.readLine();
                if (string == null) {
                    bl = true;
                    continue;
                }
                String[] stringArray = StringUtils.split((String)string, (char)'\t');
                String string2 = new String(stringArray[0]);
                long l = Long.parseLong(stringArray[1]);
                this.lastRunFileMap.put(string2, new Long(l));
            }
            Object var10_8 = null;
            if (bufferedReader == null) return;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        bufferedReader.close();
    }

    private void setLastRunFileMap() throws IOException {
        if (methodTrace) {
            Debug.say((String)"setLastRunFileMap");
        }
        if (!this.lastRunFileMap.equals(this.currentRunFileMap)) {
            this.lastRunFileMap = this.currentRunFileMap;
            if (this.lastRunFilename != null) {
                if (debug) {
                    Debug.say((String)("writing file " + this.lastRunFilename));
                }
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(this.lastRunFilename)));
                String string = new String();
                Set set = this.lastRunFileMap.keySet();
                for (String string2 : set) {
                    Long l = (Long)this.lastRunFileMap.get(string2);
                    string = string + string2;
                    string = string + "\t";
                    string = string + l.toString();
                    string = string + "\n";
                }
                bufferedWriter.write(string);
                bufferedWriter.flush();
                bufferedWriter.close();
            }
        }
    }

    private void startPollerTimerListener() {
        if (this.pollInterval <= 0L) {
            return;
        }
        this.pollerTimer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)new PollerTimerListener(), this.pollInterval, this.pollInterval);
    }

    private void cancelPollerTimerListener() {
        if (this.pollerTimer != null) {
            this.pollerTimer.cancel();
        }
    }

    protected final void setCheckPoint(File file, long l) {
        this.currentRunFileMap.put(file.getPath(), new Long(l));
    }

    protected final Long getLastCheckPoint(File file) {
        if (this.lastRunFileMap != null) {
            return (Long)this.lastRunFileMap.get(file.getPath());
        }
        return null;
    }

    protected final void dumpArrayList(String string, ArrayList arrayList) {
        StringBuffer stringBuffer = null;
        stringBuffer = string == null ? new StringBuffer("DUMPING ARRAY LIST\n") : new StringBuffer(string + "\n");
        stringBuffer.append("ARRAY LIST HAS: " + arrayList.size() + " ELEMENTS\n");
        for (Object e : arrayList) {
            stringBuffer.append(e.toString());
            stringBuffer.append("\n");
        }
        Debug.say((String)stringBuffer.toString());
    }

    protected final void dumpHashMap(String string, Map map) {
        StringBuffer stringBuffer = null;
        stringBuffer = string == null ? new StringBuffer("DUMPING HASH SET\n") : new StringBuffer(string + "\n");
        stringBuffer.append("HASH SET HAS: " + map.size() + " ELEMENTS\n");
        Set set = map.keySet();
        for (Object k : set) {
            stringBuffer.append(k.toString());
            stringBuffer.append(": ");
            stringBuffer.append(map.get(k));
            stringBuffer.append("\n");
        }
        Debug.say((String)stringBuffer.toString());
    }

    protected final void dumpStringArray(String string, String[] stringArray) {
        StringBuffer stringBuffer = null;
        stringBuffer = string == null ? new StringBuffer("DUMPING STRING ARRAY\n") : new StringBuffer(string + "\n");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append("\n");
        }
        Debug.say((String)stringBuffer.toString());
    }

    private class PollerTimerListener
    implements TimerListener {
        private PollerTimerListener() {
        }

        public final void timerExpired(Timer timer) {
            try {
                if (GenericAppPoller.this.verbose) {
                    Debug.say((String)("evaluating " + GenericAppPoller.this.startDir.getName()));
                }
                GenericAppPoller.this.doit();
                if (GenericAppPoller.this.verbose) {
                    Debug.say((String)("done evaluating " + GenericAppPoller.this.startDir.getName()));
                }
            }
            catch (Throwable throwable) {
                ApplicationPollerLogger.logUncaughtThrowable((Throwable)throwable);
            }
        }
    }
}

