/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy;

import java.io.Serializable;
import java.security.AccessController;
import java.util.ArrayList;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class TargetStatus
implements Serializable {
    private static final long serialVersionUID = -8426317304673733688L;
    private int state = 0;
    private int type;
    private ArrayList messages = new ArrayList();
    private String targetName;
    private transient boolean targetListEmpty = false;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final int STATE_INIT = 0;
    public static final int STATE_IN_PROGRESS = 1;
    public static final int STATE_FAILED = 2;
    public static final int STATE_SUCCESS = 3;
    public static final int STATE_UNAVAILABLE = 4;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_SERVER = 1;
    public static final int TYPE_CLUSTER = 2;
    public static final int TYPE_JMS_SERVER = 3;
    public static final int TYPE_VIRTUAL_HOST = 4;
    public static final int TYPE_SAF_AGENT = 5;

    public TargetStatus(String string) {
        this.targetName = string;
        this.setTargetType();
    }

    private TargetStatus() {
    }

    public int getState() {
        return this.state;
    }

    public synchronized void setState(int n) {
        boolean bl = false;
        switch (this.state) {
            case 0: {
                if (n == 1) break;
                bl = true;
                break;
            }
            case 1: 
            case 3: {
                if (n == 2 || n == 3 || n == 4) break;
                bl = true;
                break;
            }
            case 4: {
                if (n == 2) break;
                return;
            }
            case 2: {
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.state = n;
    }

    public Exception[] getMessages() {
        return this.messages.toArray(new Exception[0]);
    }

    public synchronized void addMessage(Exception exception) {
        this.messages.add(exception);
    }

    public String getTarget() {
        return this.targetName;
    }

    public int getType() {
        return this.type;
    }

    public int getTargetType() {
        return this.getType();
    }

    private void setTargetType() {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        this.type = domainMBean.lookupServer(this.getTarget()) != null ? 1 : (domainMBean.lookupCluster(this.getTarget()) != null ? 2 : (domainMBean.lookupJMSServer(this.getTarget()) != null ? 3 : (domainMBean.lookupSAFAgent(this.getTarget()) != null ? 5 : (domainMBean.lookupVirtualHost(this.getTarget()) != null ? 4 : 0))));
    }

    protected void setTargetListEmpty(boolean bl) {
        this.targetListEmpty = bl;
    }

    protected boolean isTargetListEmpty() {
        return this.targetListEmpty;
    }

    final synchronized TargetStatus copy() {
        TargetStatus targetStatus = new TargetStatus();
        targetStatus.messages = (ArrayList)this.messages.clone();
        targetStatus.state = this.state;
        targetStatus.type = this.type;
        targetStatus.targetName = this.targetName;
        return targetStatus;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("(");
        stringBuffer.append("  Name: ");
        stringBuffer.append(this.getTarget());
        stringBuffer.append('\n');
        stringBuffer.append("  Type: ");
        stringBuffer.append(this.getType());
        stringBuffer.append('\n');
        stringBuffer.append("  State: ");
        stringBuffer.append(this.getState());
        stringBuffer.append('\n');
        stringBuffer.append("  Exceptions:\n");
        Exception[] exceptionArray = this.getMessages();
        if (exceptionArray != null) {
            for (int i = 0; i < exceptionArray.length; ++i) {
                stringBuffer.append("  ");
                stringBuffer.append(exceptionArray[i].getMessage());
                stringBuffer.append('\n');
            }
        }
        stringBuffer.append(" )");
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }
}

