/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.classdeployment;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.common.T3ShutdownDef;
import weblogic.common.T3StartupDef;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.DeploymentType;
import weblogic.deploy.internal.TargetHelper;
import weblogic.kernel.T3SrvrLogger;
import weblogic.management.DeploymentException;
import weblogic.management.UndeploymentException;
import weblogic.management.configuration.ClassDeploymentMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ShutdownClassMBean;
import weblogic.management.configuration.StartupClassMBean;
import weblogic.management.internal.DeploymentHandler;
import weblogic.management.internal.DeploymentHandlerContext;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.server.ServiceFailureException;
import weblogic.t3.srvr.T3Srvr;
import weblogic.utils.AssertionError;
import weblogic.utils.StringUtils;
import weblogic.utils.TypeConversionUtils;

public class ClassDeploymentManager
implements DeploymentHandler {
    private Set loadAfterAppAdminState = Collections.synchronizedSet(new TreeSet(DeploymentType.DEPLOYMENT_HANDLER.getComparator()));
    private Set loadBeforeAppActivation = Collections.synchronizedSet(new TreeSet(DeploymentType.DEPLOYMENT_HANDLER.getComparator()));
    private Set loadAfterAppsRunning = Collections.synchronizedSet(new TreeSet(DeploymentType.DEPLOYMENT_HANDLER.getComparator()));
    private Set shutdownClasses = Collections.synchronizedSet(new TreeSet(DeploymentType.DEPLOYMENT_HANDLER.getComparator()));
    private boolean startupComplete = false;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final Class[] MAIN_SIGNATURE = new Class[]{String[].class};

    public static ClassDeploymentManager getInstance() {
        return Initializer.SINGLETON;
    }

    public void prepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
        if (deploymentMBean instanceof StartupClassMBean) {
            if (this.startupComplete) {
                return;
            }
            StartupClassMBean startupClassMBean = (StartupClassMBean)deploymentMBean;
            if (startupClassMBean.getLoadBeforeAppDeployments()) {
                return;
            }
            if (startupClassMBean.getLoadBeforeAppActivation()) {
                this.loadBeforeAppActivation.add(startupClassMBean);
            } else if (startupClassMBean.getLoadAfterAppsRunning()) {
                this.loadAfterAppsRunning.add(startupClassMBean);
            } else {
                this.loadAfterAppAdminState.add(startupClassMBean);
            }
        }
        if (deploymentMBean instanceof ShutdownClassMBean) {
            this.shutdownClasses.add(deploymentMBean);
        }
    }

    public void activateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws DeploymentException {
    }

    public void deactivateDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(kernelId).getServerRuntime();
        if (serverRuntimeMBean.getStateVal() == 4 || serverRuntimeMBean.getStateVal() == 7) {
            return;
        }
        if (deploymentMBean instanceof ShutdownClassMBean) {
            this.shutdownClasses.remove(deploymentMBean);
        }
    }

    public void unprepareDeployment(DeploymentMBean deploymentMBean, DeploymentHandlerContext deploymentHandlerContext) throws UndeploymentException {
    }

    void runStartupsBeforeAppDeployments() throws ServiceFailureException {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        StartupClassMBean[] startupClassMBeanArray = domainMBean.getStartupClasses();
        if (startupClassMBeanArray == null) {
            return;
        }
        int n = startupClassMBeanArray.length;
        for (int i = 0; i < n; ++i) {
            if (!startupClassMBeanArray[i].getLoadBeforeAppDeployments() || !TargetHelper.isTargetedLocally(startupClassMBeanArray[i])) continue;
            this.invokeClassDeployment(startupClassMBeanArray[i]);
        }
    }

    public void runStartupsBeforeAppActivation() throws ServiceFailureException {
        this.invokeTMDeployment();
        this.invokeClassDeployments(this.loadBeforeAppActivation);
        this.startupComplete = true;
    }

    void runStartupsAfterAppAdminState() throws ServiceFailureException {
        this.invokeClassDeployments(this.loadAfterAppAdminState);
    }

    void runStartupsAfterAppsRunning() throws ServiceFailureException {
        this.invokeClassDeployments(this.loadAfterAppsRunning);
    }

    void runShutdownClasses() throws ServiceFailureException {
        this.invokeClassDeployments(this.shutdownClasses);
    }

    public void invokeTMDeployment() throws ServiceFailureException {
        try {
            this.invokeClass("JTAStartupClass", "weblogic.transaction.internal.StartupClass", null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void invokeClassDeployments(Collection collection) throws ServiceFailureException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.invokeClassDeployment((ClassDeploymentMBean)iterator.next());
        }
        collection.clear();
    }

    protected void invokeClassDeployment(final ClassDeploymentMBean classDeploymentMBean) throws ServiceFailureException {
        Object object;
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("deploying ClassDeploymentMBean: " + classDeploymentMBean.getName() + ", classname: " + classDeploymentMBean.getClassName() + ", arguments: " + classDeploymentMBean.getArguments() + ", kernal id: " + kernelId);
        }
        if ((object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)kernelId, (PrivilegedAction)new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object run() {
                try {
                    try {
                        ApplicationVersionUtils.setCurrentAdminMode(true);
                        ClassDeploymentManager.this.invokeClass(classDeploymentMBean.getName(), classDeploymentMBean.getClassName(), classDeploymentMBean.getArguments());
                    }
                    catch (Exception exception) {
                        Exception exception2 = exception;
                        if (exception instanceof InvocationTargetException) {
                            Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                        }
                        if (classDeploymentMBean instanceof StartupClassMBean) {
                            void var2_8;
                            StartupClassMBean startupClassMBean = (StartupClassMBean)classDeploymentMBean;
                            if (startupClassMBean.getFailureIsFatal()) {
                                ServiceFailureException serviceFailureException = new ServiceFailureException("Can't start server due to classDeployment class failure " + classDeploymentMBean.getName(), (Throwable)var2_8);
                                Object var6_2 = null;
                                ApplicationVersionUtils.unsetCurrentAdminMode();
                                return serviceFailureException;
                            }
                            T3SrvrLogger.logFailInvokeStartupClass((String)classDeploymentMBean.getName(), (Throwable)var2_8);
                        } else {
                            void var2_10;
                            if (exception instanceof InvocationTargetException) {
                                Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                            }
                            T3SrvrLogger.logFailInvokeShutdownClass((String)classDeploymentMBean.getName(), (Throwable)var2_10);
                        }
                        Object var6_3 = null;
                        ApplicationVersionUtils.unsetCurrentAdminMode();
                        return null;
                    }
                    Object var6_1 = null;
                }
                catch (Throwable throwable) {
                    Object var6_4 = null;
                    ApplicationVersionUtils.unsetCurrentAdminMode();
                    throw throwable;
                }
                ApplicationVersionUtils.unsetCurrentAdminMode();
                return null;
            }
        })) != null) {
            throw (ServiceFailureException)((Object)object);
        }
    }

    private void invokeClass(String string, String string2, String string3) throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        Class<?> clazz = Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
        if (T3StartupDef.class.isAssignableFrom(clazz)) {
            this.invokeStartup(string, clazz, string3);
            return;
        }
        if (T3ShutdownDef.class.isAssignableFrom(clazz)) {
            ClassDeploymentManager.invokeShutdown(string, clazz, string3);
            return;
        }
        this.invokeMain(clazz, string3);
    }

    private final void invokeStartup(String string, Class clazz, String string2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        T3StartupDef t3StartupDef = (T3StartupDef)clazz.newInstance();
        Hashtable hashtable = new Hashtable();
        TypeConversionUtils.stringToDictionary((String)string2, hashtable);
        t3StartupDef.setServices(T3Srvr.getT3Srvr().getT3Services());
        T3SrvrLogger.logInvokingStartup((String)clazz.getName(), (String)string2);
        try {
            String string3 = t3StartupDef.startup(string, hashtable);
            T3SrvrLogger.logStartupClassReports((String)clazz.getName(), (String)string3);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    private static final void invokeShutdown(String string, Class clazz, String string2) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        T3ShutdownDef t3ShutdownDef = (T3ShutdownDef)clazz.newInstance();
        Hashtable hashtable = new Hashtable();
        TypeConversionUtils.stringToDictionary((String)string2, hashtable);
        t3ShutdownDef.setServices(T3Srvr.getT3Srvr().getT3Services());
        T3SrvrLogger.logInvokingShutdown((String)clazz.getName(), (String)string2);
        try {
            String string3 = t3ShutdownDef.shutdown(string, hashtable);
            T3SrvrLogger.logShutdownClassReports((String)clazz.getName(), (String)string3);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }

    private void invokeMain(Class clazz, String string) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object object;
        Object[] objectArray = null;
        if (string != null) {
            object = StringUtils.splitCompletely((String)string, (String)" ");
            objectArray = new Object[]{object};
        } else {
            objectArray = new Object[]{new String[0]};
        }
        object = null;
        int n = clazz.getModifiers();
        if (!Modifier.isPublic(n)) {
            throw new IllegalAccessException(clazz.getName() + " is not a public class");
        }
        if (Modifier.isInterface(n)) {
            throw new IllegalAccessException(clazz.getName() + " is an interface, not a public class");
        }
        try {
            object = clazz.getMethod("main", MAIN_SIGNATURE);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodException(clazz.getName() + " does not define 'public static void main(String[])'");
        }
        int n2 = ((Method)object).getModifiers();
        if (!Modifier.isStatic(n2) || !Modifier.isPublic(n2)) {
            throw new IllegalAccessException(clazz.getName() + ".main(String[]) must must be a public static method");
        }
        try {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("invoking main on: " + clazz.getName() + ", with " + string);
            }
            T3SrvrLogger.logInvokingClass((String)clazz.getName(), (String)string);
            ((Method)object).invoke(null, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new AssertionError("Should never occur", (Throwable)illegalArgumentException);
        }
    }

    private static class Initializer {
        static final ClassDeploymentManager SINGLETON = new ClassDeploymentManager();

        private Initializer() {
        }
    }
}

