/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MBeanException;
import javax.management.Notification;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.spi.DeploymentOptions;
import weblogic.deploy.api.spi.WebLogicDeploymentManager;
import weblogic.deploy.api.tools.ModuleInfo;
import weblogic.deploy.api.tools.SessionHelper;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.internal.DeploymentManagerImpl;
import weblogic.management.deploy.internal.DeploymentProgressObjectImpl;
import weblogic.management.deploy.internal.ExceptionTranslator;
import weblogic.management.jmx.modelmbean.NotificationGenerator;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.AppDeploymentRuntimeMBean;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentManagerMBean;
import weblogic.management.runtime.DeploymentProgressObjectMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class AppDeploymentRuntimeImpl
extends DomainRuntimeMBeanDelegate
implements AppDeploymentRuntimeMBean {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static Map<String, NotificationGenerator> ngs = new HashMap<String, NotificationGenerator>();
    private final String appName;
    private final String appVersion;
    private final AppDeploymentMBean deployable;
    private NotificationGenerator notificationGenerator;
    private long notificationSequence = 0L;

    AppDeploymentRuntimeImpl(AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        super(appDeploymentMBean.getName());
        this.appName = appDeploymentMBean.getApplicationName();
        this.appVersion = appDeploymentMBean.getVersionIdentifier();
        this.deployable = appDeploymentMBean;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getApplicationVersion() {
        return this.appVersion;
    }

    public DeploymentProgressObjectMBean start() throws RuntimeException {
        return this.doOperation(OperationType.START, true, null, null);
    }

    public DeploymentProgressObjectMBean start(String[] stringArray, Properties properties) throws RuntimeException {
        return this.doOperation(OperationType.START, false, stringArray, properties);
    }

    public DeploymentProgressObjectMBean stop() throws RuntimeException {
        return this.doOperation(OperationType.STOP, true, null, null);
    }

    public DeploymentProgressObjectMBean stop(String[] stringArray, Properties properties) throws RuntimeException {
        return this.doOperation(OperationType.STOP, false, stringArray, properties);
    }

    public String[] getModules() {
        ArrayList<String> arrayList;
        block13: {
            arrayList = new ArrayList<String>();
            AppDeploymentMBean appDeploymentMBean = ApplicationVersionUtils.getActiveAppDeployment(this.appName);
            if (appDeploymentMBean != null) {
                String string = appDeploymentMBean.getSourcePath();
                File file = new File(string);
                File file2 = new File(file.getParent());
                String string2 = appDeploymentMBean.getPlanPath();
                File file3 = null;
                if (string2 != null) {
                    file3 = new File(string2);
                }
                try {
                    WebLogicDeploymentManager webLogicDeploymentManager = SessionHelper.getDisconnectedDeploymentManager();
                    SessionHelper sessionHelper = SessionHelper.getInstance(webLogicDeploymentManager);
                    sessionHelper.setFullInit(false);
                    sessionHelper.setApplication(file);
                    sessionHelper.setApplicationRoot(file2);
                    if (file3 != null) {
                        sessionHelper.setPlan(file3);
                    }
                    sessionHelper.initializeConfiguration();
                    ModuleInfo moduleInfo = sessionHelper.getModuleInfo();
                    ModuleType moduleType = moduleInfo.getType();
                    if (moduleType == ModuleType.EAR) {
                        ModuleInfo[] moduleInfoArray = moduleInfo.getSubModules();
                        if (moduleInfoArray == null) break block13;
                        for (ModuleInfo moduleInfo2 : moduleInfoArray) {
                            String string3 = moduleInfo2.getName();
                            moduleType = moduleInfo2.getType();
                            if (moduleType == ModuleType.WAR) {
                                String[] stringArray = moduleInfo2.getContextRoots();
                                if (stringArray == null) continue;
                                for (String string4 : stringArray) {
                                    if (string4 == null || string4.length() <= 0) continue;
                                    arrayList.add(string4);
                                }
                                continue;
                            }
                            arrayList.add(string3);
                        }
                        break block13;
                    }
                    if (moduleType == ModuleType.WAR) {
                        String[] stringArray = moduleInfo.getContextRoots();
                        if (stringArray != null) {
                            for (String string5 : stringArray) {
                                if (string5 == null || string5.length() <= 0) continue;
                                arrayList.add(string5);
                            }
                        }
                    } else {
                        arrayList.add(moduleInfo.getName());
                    }
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String getState(String string) {
        AppRuntimeStateRuntimeMBean appRuntimeStateRuntimeMBean = ManagementService.getDomainAccess(kernelId).getAppRuntimeStateRuntime();
        return appRuntimeStateRuntimeMBean.getCurrentState(this.getName(), string);
    }

    void setNotificationGenerator(NotificationGenerator notificationGenerator) {
        this.notificationGenerator = notificationGenerator;
        ngs.put(this.appName, notificationGenerator);
    }

    void sendNotification(DeploymentState deploymentState) {
        if (this.notificationGenerator != null) {
            ++this.notificationSequence;
            Notification notification = new Notification(DeploymentManagerImpl.translateState(deploymentState.getCurrentState()), this.notificationGenerator.getObjectName(), this.notificationSequence);
            String string = deploymentState.getTarget();
            notification.setUserData(string);
            try {
                this.notificationGenerator.sendNotification(notification);
            }
            catch (MBeanException mBeanException) {
                mBeanException.printStackTrace();
            }
        }
    }

    private DeploymentData propertiesToDeploymentData(String[] stringArray, Properties properties) throws ManagementException {
        DeploymentOptions deploymentOptions = new DeploymentOptions();
        DeploymentData deploymentData = new DeploymentData();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (properties != null) {
            int n;
            String string = null;
            string = properties.getProperty("clusterDeploymentTimeout");
            if (string != null) {
                try {
                    n = new Integer(string);
                    deploymentOptions.setClusterDeploymentTimeout(n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ManagementException((Throwable)numberFormatException);
                }
            }
            if ((string = properties.getProperty("gracefulIgnoreSessions")) != null) {
                deploymentOptions.setGracefulIgnoreSessions(Boolean.parseBoolean(string));
            }
            if ((string = properties.getProperty("gracefulProductionToAdmin")) != null) {
                deploymentOptions.setGracefulProductionToAdmin(Boolean.parseBoolean(string));
            }
            if ((string = properties.getProperty("retireGracefully")) != null) {
                deploymentOptions.setRetireGracefully(Boolean.parseBoolean(string));
            }
            if ((string = properties.getProperty("retireTimeout")) != null) {
                try {
                    n = new Integer(string);
                    deploymentOptions.setRetireTime(n);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ManagementException((Throwable)numberFormatException);
                }
            }
            if ((string = properties.getProperty("adminMode")) != null) {
                deploymentOptions.setAdminMode(Boolean.parseBoolean(string));
            }
            if ((string = properties.getProperty("timeout")) != null) {
                try {
                    long l = new Long(string).intValue();
                    deploymentOptions.setTimeout(l);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ManagementException((Throwable)numberFormatException);
                }
            }
            if (this.appVersion != null) {
                deploymentOptions.setArchiveVersion(this.appVersion);
            }
            deploymentData.setDeploymentOptions(deploymentOptions);
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null) continue;
                if (stringArray[i].contains("@")) {
                    String[] stringArray2 = stringArray[i].split("@");
                    if (stringArray2 != null && stringArray2.length == 2) {
                        deploymentData.addModuleTarget(stringArray2[0].trim(), stringArray2[1].trim());
                        continue;
                    }
                    throw new ManagementException("invalid target:  " + stringArray[i]);
                }
                arrayList.add(stringArray[i]);
            }
        }
        deploymentData.addGlobalTargets(arrayList.toArray(new String[0]));
        return deploymentData;
    }

    private DeploymentProgressObjectMBean doOperation(OperationType operationType, boolean bl, String[] stringArray, Properties properties) throws RuntimeException {
        DeploymentProgressObjectMBean deploymentProgressObjectMBean = null;
        DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean = null;
        try {
            DeploymentManagerMBean deploymentManagerMBean = ManagementService.getDomainAccess(kernelId).getDeploymentManager();
            DeployerRuntimeMBean deployerRuntimeMBean = ManagementService.getDomainAccess(kernelId).getDeployerRuntime();
            DeploymentData deploymentData = null;
            deploymentData = stringArray != null || properties != null ? this.propertiesToDeploymentData(stringArray, properties) : new DeploymentData();
            deploymentTaskRuntimeMBean = operationType.equals((Object)OperationType.START) ? deployerRuntimeMBean.start(this.name, deploymentData, null, false) : deployerRuntimeMBean.stop(this.name, deploymentData, null, false);
            deploymentProgressObjectMBean = ((DeploymentManagerImpl)deploymentManagerMBean).allocateDeploymentProgressObject(this.getName(), deploymentTaskRuntimeMBean, this.deployable);
            deploymentTaskRuntimeMBean.start();
            if (bl) {
                deploymentTaskRuntimeMBean.waitForTaskCompletion(-1L);
            }
        }
        catch (Throwable throwable) {
            RuntimeException runtimeException = ExceptionTranslator.translateException(throwable);
            if (deploymentProgressObjectMBean == null || deploymentTaskRuntimeMBean == null) {
                throw runtimeException;
            }
            ((DeploymentProgressObjectImpl)deploymentProgressObjectMBean).addException(runtimeException);
        }
        return deploymentProgressObjectMBean;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum OperationType {
        START,
        STOP;

    }
}

