/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.security.AccessController;
import java.util.ArrayList;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class AppMBeanUsages {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public static DeploymentMBean[] getDeployments(TargetMBean targetMBean) {
        ArrayList<DeploymentMBean> arrayList = new ArrayList<DeploymentMBean>();
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        DeploymentMBean[] deploymentMBeanArray = domainMBean.getDeployments();
        for (int i = 0; i < deploymentMBeanArray.length; ++i) {
            if (!AppMBeanUsages.isTargeted(deploymentMBeanArray[i], targetMBean)) continue;
            arrayList.add(deploymentMBeanArray[i]);
        }
        ApplicationMBean[] applicationMBeanArray = domainMBean.getApplications();
        for (int i = 0; i < applicationMBeanArray.length; ++i) {
            ComponentMBean[] componentMBeanArray = applicationMBeanArray[i].getComponents();
            for (int j = 0; j < componentMBeanArray.length; ++j) {
                if (!AppMBeanUsages.isTargeted(componentMBeanArray[j], targetMBean)) continue;
                arrayList.add(deploymentMBeanArray[j]);
            }
        }
        DeploymentMBean[] deploymentMBeanArray2 = new DeploymentMBean[arrayList.size()];
        return arrayList.toArray(deploymentMBeanArray2);
    }

    private static boolean isTargeted(DeploymentMBean deploymentMBean, TargetMBean targetMBean) {
        TargetMBean[] targetMBeanArray = deploymentMBean.getTargets();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (!targetMBean.getName().equals(targetMBeanArray[i].getName())) continue;
            return true;
        }
        return false;
    }
}

