/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.util.Iterator;
import java.util.Map;
import weblogic.application.utils.XMLWriter;
import weblogic.deploy.internal.diagnostics.ImageProvider;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.ApplicationRuntimeState;

public class AppRuntimeStateImageProvider
extends ImageProvider {
    public void writeDiagnosticImage(XMLWriter xMLWriter) {
        AppRuntimeStateManager appRuntimeStateManager = AppRuntimeStateManager.getManager();
        Iterator iterator = appRuntimeStateManager.getAppStates().iterator();
        while (iterator.hasNext() && !this.timedOut) {
            ApplicationRuntimeState applicationRuntimeState = (ApplicationRuntimeState)((Map.Entry)iterator.next()).getValue();
            xMLWriter.addElement("app-runtime-state");
            xMLWriter.addElement("app-id", "" + applicationRuntimeState.getAppId());
            xMLWriter.addElement("retire-timeout-secs", "" + applicationRuntimeState.getRetireTimeoutSeconds());
            xMLWriter.addElement("retire-time-millis", "" + applicationRuntimeState.getRetireTimeMillis());
            if (applicationRuntimeState.getModules() != null) {
                xMLWriter.addElement("module-state", applicationRuntimeState.getModules().toString());
            }
            if (applicationRuntimeState.getAppTargetState() != null) {
                xMLWriter.addElement("app-target-state", applicationRuntimeState.getAppTargetState().toString());
            }
            if (applicationRuntimeState.getDeploymentVersion() != null) {
                xMLWriter.addElement("deployment-version", applicationRuntimeState.getDeploymentVersion().toString());
            }
            xMLWriter.closeElement();
            xMLWriter.flush();
        }
    }
}

