/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.DeploymentVersion;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.deploy.internal.targetserver.state.TargetModuleState;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.internal.AppTargetState;
import weblogic.management.deploy.internal.ApplicationRuntimeState;
import weblogic.management.deploy.internal.DeploymentManagerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.store.PersistentMap;
import weblogic.store.PersistentStore;
import weblogic.store.PersistentStoreException;
import weblogic.store.PersistentStoreManager;
import weblogic.store.xa.PersistentStoreXA;
import weblogic.utils.StackTraceUtils;

public class AppRuntimeStateManager {
    private static final String DEPLOYMENT_STORE_CONN_NAME = "weblogic.deploy.store";
    private final Map appStates = new HashMap();
    private PersistentStore pStore;
    private PersistentMap psMap;
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static AppRuntimeStateManager singleton;
    static final String ROOT = "ROOT_MODULE";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    private AppRuntimeStateManager() {
    }

    public static AppRuntimeStateManager getManager() {
        if (singleton == null) {
            singleton = new AppRuntimeStateManager();
        }
        return singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationRuntimeState get(String string) {
        Map map = this.appStates;
        synchronized (map) {
            return (ApplicationRuntimeState)this.appStates.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getAppStates() {
        Map map = this.appStates;
        synchronized (map) {
            return this.appStates.entrySet();
        }
    }

    private void initStore() throws ManagementException {
        if (this.psMap != null) {
            return;
        }
        try {
            this.pStore = (PersistentStoreXA)PersistentStoreManager.getManager().getDefaultStore();
            this.psMap = this.pStore.createPersistentMap(DEPLOYMENT_STORE_CONN_NAME);
        }
        catch (Exception exception) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug(StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            String string = DeploymentManagerLogger.storeCreateFailed(exception);
            throw new ManagementException(string, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDeploymentVersions() {
        HashMap<String, DeploymentVersion> hashMap = new HashMap<String, DeploymentVersion>();
        if (this.appStates != null) {
            Map map = this.appStates;
            synchronized (map) {
                Set set = this.appStates.entrySet();
                for (Map.Entry entry : set) {
                    String string = (String)entry.getKey();
                    ApplicationRuntimeState applicationRuntimeState = (ApplicationRuntimeState)entry.getValue();
                    DeploymentVersion deploymentVersion = applicationRuntimeState.getDeploymentVersion();
                    if (deploymentVersion == null) continue;
                    hashMap.put(string, deploymentVersion);
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getStartupStateForServer(String string) {
        DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
        if (domainMBean.getAdminServerName().equals(string)) {
            return null;
        }
        HashMap<String, ApplicationRuntimeState> hashMap = new HashMap<String, ApplicationRuntimeState>();
        Map map = this.appStates;
        synchronized (map) {
            for (Map.Entry entry : this.appStates.entrySet()) {
                String string2 = (String)entry.getKey();
                ApplicationRuntimeState applicationRuntimeState = (ApplicationRuntimeState)entry.getValue();
                if (applicationRuntimeState == null) continue;
                ApplicationRuntimeState applicationRuntimeState2 = new ApplicationRuntimeState(applicationRuntimeState);
                Map map2 = applicationRuntimeState.getAppTargetState();
                Map map3 = applicationRuntimeState.getModules();
                for (Map.Entry entry2 : map2.entrySet()) {
                    Object object;
                    TargetMBean targetMBean;
                    String string3 = (String)entry2.getKey();
                    if (string3 == null || (targetMBean = domainMBean.lookupTarget(string3)) == null) continue;
                    if (this.isInTarget(targetMBean, string)) {
                        applicationRuntimeState2.updateAppTargetState(applicationRuntimeState.getAppTargetState(string3), string3);
                        object = map3.keySet().iterator();
                        while (object.hasNext()) {
                            String string4 = (String)object.next();
                            applicationRuntimeState2.updateState(this.getModuleStates(string2, string4, string3));
                        }
                        hashMap.put(string2, applicationRuntimeState2);
                    }
                    if ((object = applicationRuntimeState.getDeploymentVersion()) == null) continue;
                    applicationRuntimeState2.setDeploymentVersion((DeploymentVersion)object);
                }
            }
        }
        return hashMap;
    }

    private boolean isInTarget(TargetMBean targetMBean, String string) {
        return targetMBean.getServerNames().contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadStartupState(Map map) throws ManagementException {
        if (map == null) {
            this.readAppStatesFromStore();
            return;
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Reading app states received from admin server ...");
        }
        this.initStore();
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.appStates;
        synchronized (iterator) {
            for (Object object : this.appStates.keySet()) {
                hashSet.add((String)object);
            }
        }
        for (String string : hashSet) {
            this.remove(string);
        }
        for (String string : map.keySet()) {
            Object object;
            object = (ApplicationRuntimeState)map.get(string);
            Map map2 = this.appStates;
            synchronized (map2) {
                this.appStates.put(string, object);
            }
            this.save((ApplicationRuntimeState)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readAppStatesFromStore() throws ManagementException {
        this.initStore();
        try {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Reading app states from store...");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            String string = ManagementService.getPropertyService(kernelId).getServerName();
            for (String string2 : this.psMap.keySet()) {
                if (AppDeploymentHelper.lookupAppOrLib(string2, domainMBean) == null) {
                    arrayList.add(string2);
                    continue;
                }
                try {
                    ApplicationRuntimeState applicationRuntimeState = (ApplicationRuntimeState)this.psMap.get((Object)string2);
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("read from store: " + applicationRuntimeState);
                    }
                    Map map = this.appStates;
                    synchronized (map) {
                        this.appStates.put(string2, applicationRuntimeState);
                    }
                }
                catch (PersistentStoreException persistentStoreException) {
                }
            }
            for (String string2 : arrayList) {
                try {
                    if (Debug.isDeploymentDebugEnabled()) {
                        Debug.deploymentDebug("remove from store: " + string2);
                    }
                    this.psMap.remove((Object)string2);
                }
                catch (PersistentStoreException persistentStoreException) {}
            }
        }
        catch (Exception exception) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug(StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            String string = DeploymentManagerLogger.cannotReadStore(exception);
            throw new ManagementException(string, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApplicationRuntimeState getOrCreate(String string) {
        Map map = this.appStates;
        synchronized (map) {
            ApplicationRuntimeState applicationRuntimeState = (ApplicationRuntimeState)this.appStates.get(string);
            if (applicationRuntimeState == null) {
                applicationRuntimeState = new ApplicationRuntimeState(string);
                this.appStates.put(string, applicationRuntimeState);
            }
            return applicationRuntimeState;
        }
    }

    public void save(ApplicationRuntimeState applicationRuntimeState) throws ManagementException {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("saving: " + applicationRuntimeState);
        }
        try {
            this.psMap.put((Object)applicationRuntimeState.getAppId(), (Object)applicationRuntimeState);
        }
        catch (Exception exception) {
            if (ManagementService.getRuntimeAccess(kernelId).getServerRuntime().isShuttingDown()) {
                return;
            }
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug(StackTraceUtils.throwable2StackTrace((Throwable)exception));
            }
            String string = DeploymentManagerLogger.cannotSaveStore(applicationRuntimeState.toString(), exception);
            throw new ManagementException(string, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String string) throws ManagementException {
        ApplicationRuntimeState applicationRuntimeState = null;
        Map map = this.appStates;
        synchronized (map) {
            applicationRuntimeState = (ApplicationRuntimeState)this.appStates.remove(string);
        }
        if (applicationRuntimeState != null) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("deleting: " + applicationRuntimeState);
            }
            try {
                this.psMap.remove((Object)applicationRuntimeState.getAppId());
            }
            catch (Exception exception) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug(StackTraceUtils.throwable2StackTrace((Throwable)exception));
                }
                String string2 = DeploymentManagerLogger.cannotDeleteStore(applicationRuntimeState.toString(), exception);
                throw new ManagementException(string2, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargets(String string, String[] stringArray) throws ManagementException {
        if (Debug.isDeploymentDebugEnabled()) {
            for (int i = 0; i < stringArray.length; ++i) {
                Debug.deploymentDebug("deleting target: " + stringArray[i] + " for app:  " + string);
            }
        }
        Map map = this.appStates;
        synchronized (map) {
            block12: {
                ApplicationRuntimeState applicationRuntimeState = (ApplicationRuntimeState)this.appStates.get(string);
                if (applicationRuntimeState != null) {
                    int n;
                    for (n = 0; n < stringArray.length; ++n) {
                        applicationRuntimeState.removeAppTargetState(stringArray[n]);
                    }
                    if (applicationRuntimeState.getAppTargetState().size() == 0) {
                        this.remove(string);
                    } else {
                        try {
                            applicationRuntimeState = (ApplicationRuntimeState)this.psMap.get((Object)string);
                            for (n = 0; n < stringArray.length; ++n) {
                                applicationRuntimeState.removeAppTargetState(stringArray[n]);
                            }
                        }
                        catch (PersistentStoreException persistentStoreException) {
                            if (!Debug.isDeploymentDebugEnabled()) break block12;
                            Debug.deploymentDebug("psMap remove error:  " + persistentStoreException.getMessage());
                        }
                    }
                }
            }
        }
    }

    public String getIntendedState(String string) {
        ApplicationRuntimeState applicationRuntimeState = AppRuntimeStateManager.getManager().get(string);
        if (applicationRuntimeState == null) {
            return null;
        }
        Collection collection = applicationRuntimeState.getAppTargetState().values();
        String string2 = "STATE_NEW";
        for (AppTargetState appTargetState : collection) {
            if (!DeployHelper.less(string2, appTargetState.getState())) continue;
            string2 = appTargetState.getState();
        }
        return string2;
    }

    public String getIntendedState(String string, String string2) {
        ApplicationRuntimeState applicationRuntimeState = AppRuntimeStateManager.getManager().get(string);
        if (applicationRuntimeState == null) {
            return null;
        }
        return applicationRuntimeState.getIntendedState(string2);
    }

    public int getStagingState(String string, String string2) {
        ApplicationRuntimeState applicationRuntimeState = AppRuntimeStateManager.getManager().get(string);
        if (applicationRuntimeState == null) {
            return -1;
        }
        return applicationRuntimeState.getStagingState(string2);
    }

    public String getCurrentState(String string, String string2) {
        String string3 = this.getCurrentState(string, ROOT, string2);
        if (!string3.equals("STATE_NEW")) {
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Returning state for root module: " + string3);
            }
            return string3;
        }
        String[] stringArray = this.getModuleIds(string, false);
        if (stringArray == null) {
            return null;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            String string5 = this.getCurrentState(string, string4, string2);
            if (!DeployHelper.less(string3, string5)) continue;
            string3 = string5;
        }
        return string3;
    }

    public String getCurrentStateOnServer(String string, String string2, String string3) {
        String[] stringArray = this.getModuleIds(string);
        if (stringArray == null) {
            return null;
        }
        String string4 = "STATE_NEW";
        for (int i = 0; i < stringArray.length; ++i) {
            String string5 = stringArray[i];
            String string6 = this.getCurrentStateOnServer(string, string5, string2, string3);
            if (!DeployHelper.less(string4, string6)) continue;
            string4 = string6;
        }
        return string4;
    }

    public String[] getModuleIds(String string) {
        return this.getModuleIds(string, true);
    }

    private String[] getModuleIds(String string, boolean bl) {
        ApplicationRuntimeState applicationRuntimeState = AppRuntimeStateManager.getManager().get(string);
        if (applicationRuntimeState == null) {
            return null;
        }
        Map map = applicationRuntimeState.getModules();
        if (map != null) {
            Set set;
            if (bl) {
                set = new HashSet();
                for (String string2 : map.keySet()) {
                    if (ROOT.equals(string2)) continue;
                    set.add(string2);
                }
            } else {
                set = map.keySet();
            }
            return set.toArray(new String[0]);
        }
        return new String[0];
    }

    public String getModuleType(String string, String string2) {
        Map map = this.getTargetLevelMap(string, string2);
        if (map == null || map.isEmpty()) {
            return WebLogicModuleType.MODULETYPE_UNKNOWN;
        }
        Object v = map.values().iterator().next();
        TargetModuleState targetModuleState = this.getAnyTMSFromTargetMap(v);
        String string3 = targetModuleState.getType();
        if (string3 == null) {
            string3 = WebLogicModuleType.MODULETYPE_UNKNOWN;
        }
        return string3;
    }

    private TargetModuleState getAnyTMSFromTargetMap(Object object) {
        Object v;
        TargetModuleState targetModuleState = object instanceof TargetModuleState ? (TargetModuleState)object : ((v = ((Map)object).values().iterator().next()) instanceof TargetModuleState ? (TargetModuleState)v : (TargetModuleState)((Map)v).values().iterator().next());
        return targetModuleState;
    }

    private TargetModuleState[] getAllTMSFromTargetMap(Object object) {
        if (object instanceof TargetModuleState) {
            return new TargetModuleState[]{(TargetModuleState)object};
        }
        Iterator iterator = ((Map)object).values().iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof TargetModuleState) {
                arrayList.add(v);
                continue;
            }
            arrayList.add(((Map)v).values().iterator().next());
        }
        return arrayList.toArray(new TargetModuleState[0]);
    }

    public String getCurrentState(String string, String string2, String string3) {
        TargetModuleState[] targetModuleStateArray = this.getModuleStates(string, string2, string3);
        String string4 = "STATE_NEW";
        for (int i = 0; targetModuleStateArray != null && i < targetModuleStateArray.length; ++i) {
            TargetModuleState targetModuleState = targetModuleStateArray[i];
            if (!DeployHelper.less(string4, targetModuleState.getCurrentState())) continue;
            string4 = targetModuleState.getCurrentState();
        }
        return string4;
    }

    public String getCurrentStateOnServer(String string, String string2, String string3, String string4) {
        TargetModuleState[] targetModuleStateArray = this.getModuleStates(string, string2, string3);
        String string5 = "STATE_NEW";
        for (int i = 0; targetModuleStateArray != null && i < targetModuleStateArray.length; ++i) {
            TargetModuleState targetModuleState = targetModuleStateArray[i];
            if (!targetModuleState.getServerName().equals(string4) || !DeployHelper.less(string5, targetModuleState.getCurrentState())) continue;
            string5 = targetModuleState.getCurrentState();
        }
        return string5;
    }

    public String getCurrentState(String string, String string2, String string3, String string4) {
        return this.getCurrentState(string, TargetModuleState.createName(string2, string3), string4);
    }

    public TargetModuleState[] getModuleStates(String string, String string2, String string3) {
        Map map = this.getTargetLevelMap(string, string2);
        if (map == null) {
            return null;
        }
        Object v = map.get(string3);
        if (v == null) {
            for (Object v2 : map.values()) {
                if (v2 instanceof Map) {
                    v = ((Map)v2).get(string3);
                }
                if (v == null) continue;
                break;
            }
        }
        if (v == null) {
            return null;
        }
        return this.getAllTMSFromTargetMap(v);
    }

    public String[] getModuleTargets(String string, String string2) {
        Map map = this.getTargetLevelMap(string, string2);
        if (map == null) {
            return null;
        }
        Set set = map.keySet();
        return set.toArray(new String[0]);
    }

    public String[] getModuleTargets(String string, String string2, String string3) {
        return this.getModuleTargets(string, TargetModuleState.createName(string2, string3));
    }

    private Map getTargetLevelMap(String string, String string2) {
        ApplicationRuntimeState applicationRuntimeState = AppRuntimeStateManager.getManager().get(string);
        if (applicationRuntimeState == null) {
            return null;
        }
        Map map = applicationRuntimeState.getModules();
        if (map == null) {
            return null;
        }
        Map map2 = (Map)map.get(string2);
        return map2;
    }

    public boolean isAdminMode(AppDeploymentMBean appDeploymentMBean) {
        return this.isAdminMode(appDeploymentMBean.getName());
    }

    public boolean isAdminMode(String string) {
        String string2 = this.getIntendedState(string);
        return "STATE_ADMIN".equals(string2);
    }

    public boolean isAdminMode(String string, String string2) {
        AppTargetState appTargetState = this.getAppTargetState(string, string2);
        if (appTargetState == null) {
            return false;
        }
        return "STATE_ADMIN".equals(appTargetState.getState());
    }

    public AppTargetState getAppTargetState(String string, String string2) {
        ApplicationRuntimeState applicationRuntimeState = this.get(string);
        if (applicationRuntimeState == null) {
            return null;
        }
        return applicationRuntimeState.getAppTargetState(string2);
    }

    public void setState(String string, String[] stringArray, String string2) throws ManagementException {
        if (stringArray == null || string2 == null) {
            return;
        }
        ApplicationRuntimeState applicationRuntimeState = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            applicationRuntimeState = this.updateIntendedState(string, string3, string2);
        }
        if (applicationRuntimeState != null) {
            this.save(applicationRuntimeState);
        }
    }

    public void setStagingState(String string, String[] stringArray, int n, boolean bl) throws ManagementException {
        ApplicationRuntimeState applicationRuntimeState = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            applicationRuntimeState = this.updateStagingState(string, string2, n);
        }
        if (applicationRuntimeState != null && !bl) {
            this.save(applicationRuntimeState);
        }
    }

    private ApplicationRuntimeState updateIntendedState(String string, String string2, String string3) {
        if (string == null || string2 == null || string3 == null) {
            return null;
        }
        ApplicationRuntimeState applicationRuntimeState = this.getOrCreate(string);
        AppTargetState appTargetState = this.getAppTargetState(string, string2);
        if (appTargetState == null) {
            appTargetState = new AppTargetState(string, string2);
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Updating intended state for target: " + string2 + " state - " + string3);
        }
        appTargetState.setState(string3);
        applicationRuntimeState.updateAppTargetState(appTargetState, string2);
        return applicationRuntimeState;
    }

    private ApplicationRuntimeState updateStagingState(String string, String string2, int n) {
        ApplicationRuntimeState applicationRuntimeState = this.getOrCreate(string);
        if (string2 == null) {
            return applicationRuntimeState;
        }
        AppTargetState appTargetState = this.getAppTargetState(string, string2);
        if (appTargetState == null) {
            appTargetState = new AppTargetState(string, string2);
        }
        if (n > -1) {
            appTargetState.setStagingState(n);
        }
        applicationRuntimeState.updateAppTargetState(appTargetState, string2);
        return applicationRuntimeState;
    }

    public boolean isActiveVersion(AppDeploymentMBean appDeploymentMBean) {
        return this.isActiveVersion(appDeploymentMBean.getName());
    }

    public boolean isActiveVersion(String string) {
        if (ApplicationVersionUtils.getVersionId(string) == null) {
            return true;
        }
        ApplicationRuntimeState applicationRuntimeState = this.get(string);
        return applicationRuntimeState != null && applicationRuntimeState.isActiveVersion();
    }

    public void setActiveVersion(String string) throws ManagementException {
        this.setActiveVersion(string, false);
    }

    public void setActiveVersion(String string, boolean bl) throws ManagementException {
        if (ApplicationVersionUtils.getVersionId(string) == null) {
            return;
        }
        ApplicationRuntimeState applicationRuntimeState = this.getOrCreate(string);
        applicationRuntimeState.setActiveVersion(bl);
        this.save(applicationRuntimeState);
    }

    public boolean isRetiredVersion(AppDeploymentMBean appDeploymentMBean) {
        if (appDeploymentMBean == null || appDeploymentMBean.getVersionIdentifier() == null) {
            return false;
        }
        return "STATE_RETIRED".equals(this.getCurrentState(appDeploymentMBean));
    }

    public boolean isFailedVersion(AppDeploymentMBean appDeploymentMBean) {
        if (appDeploymentMBean == null || appDeploymentMBean.getVersionIdentifier() == null) {
            return false;
        }
        return "STATE_FAILED".equals(this.getCurrentState(appDeploymentMBean));
    }

    public String getCurrentState(AppDeploymentMBean appDeploymentMBean) {
        TargetMBean[] targetMBeanArray = appDeploymentMBean.getTargets();
        if (targetMBeanArray == null || targetMBeanArray.length == 0) {
            return null;
        }
        String string = targetMBeanArray[0].getName();
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("getCurrentState " + appDeploymentMBean.getName() + " state " + this.getCurrentState(appDeploymentMBean.getName(), string));
        }
        return this.getCurrentState(appDeploymentMBean.getName(), string);
    }

    public int getRetireTimeoutSeconds(String string) {
        ApplicationRuntimeState applicationRuntimeState = this.get(string);
        if (applicationRuntimeState == null) {
            return 0;
        }
        return applicationRuntimeState.getRetireTimeoutSeconds();
    }

    public void setRetireTimeoutSeconds(String string, int n) throws ManagementException {
        if (ApplicationVersionUtils.getVersionId(string) == null) {
            return;
        }
        ApplicationRuntimeState applicationRuntimeState = this.getOrCreate(string);
        applicationRuntimeState.setRetireTimeoutSeconds(n);
        this.save(applicationRuntimeState);
    }

    public long getRetireTimeMillis(String string) {
        ApplicationRuntimeState applicationRuntimeState = this.get(string);
        if (applicationRuntimeState == null) {
            return 0L;
        }
        return applicationRuntimeState.getRetireTimeMillis();
    }

    public void setRetireTimeMillis(String string, long l) throws ManagementException {
        if (ApplicationVersionUtils.getVersionId(string) == null) {
            return;
        }
        ApplicationRuntimeState applicationRuntimeState = this.getOrCreate(string);
        applicationRuntimeState.setRetireTimeMillis(l);
        this.save(applicationRuntimeState);
    }

    public void addStateListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeStateListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void updateState(String string, DeploymentVersion deploymentVersion) {
        ApplicationRuntimeState applicationRuntimeState = this.getOrCreate(string);
        applicationRuntimeState.setDeploymentVersion(deploymentVersion);
        try {
            this.save(applicationRuntimeState);
        }
        catch (ManagementException managementException) {
            DeploymentManagerLogger.logStatePersistenceFailed(string, managementException);
        }
    }

    public void updateState(String string, DeploymentState deploymentState) {
        ApplicationRuntimeState applicationRuntimeState;
        if (string == null) {
            return;
        }
        ApplicationRuntimeState applicationRuntimeState2 = applicationRuntimeState = this.getOrCreate(string);
        String string2 = applicationRuntimeState.getIntendedState(deploymentState.getTarget());
        if (!(string2 == null && "__Lifecycle_taskid__".equals(deploymentState.getTaskID()) && !"STATE_ACTIVE".equals(deploymentState.getIntendedState()) || string2 != null && !DeployHelper.less(string2, deploymentState.getIntendedState()))) {
            applicationRuntimeState = this.updateIntendedState(string, deploymentState.getTarget(), deploymentState.getIntendedState());
        }
        applicationRuntimeState = this.updateStagingState(string, deploymentState.getTarget(), deploymentState.getStagingState());
        applicationRuntimeState.updateState(deploymentState);
        if (this.pcs.hasListeners(null) && deploymentState.getCurrentState() != null) {
            this.pcs.firePropertyChange(new PropertyChangeEvent(this, "State", null, deploymentState));
        }
        try {
            this.save(applicationRuntimeState);
        }
        catch (ManagementException managementException) {
            DeploymentManagerLogger.logStatePersistenceFailed(string, managementException);
        }
    }

    private void resetState(TargetModuleState targetModuleState, String string) {
        if (targetModuleState.getTargetName().equals(string) && !"STATE_RETIRED".equals(targetModuleState.getCurrentState())) {
            targetModuleState.setCurrentState("STATE_NEW");
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("reset: " + targetModuleState);
            }
        }
    }

    public void resetState(String string, String[] stringArray) throws ManagementException {
        if (stringArray == null) {
            return;
        }
        ApplicationRuntimeState applicationRuntimeState = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            applicationRuntimeState = this.updateIntendedState(string, string2, "STATE_NEW");
            Map map = applicationRuntimeState.getModules();
            for (String string3 : map.keySet()) {
                Map map2;
                Map map3 = (Map)map.get(string3);
                if (map3 == null || (map2 = (Map)map3.get(string2)) == null) continue;
                for (String string4 : map2.keySet()) {
                    Object v = map2.get(string4);
                    if (v != null && v instanceof Map) {
                        v = ((Map)v).get(string4);
                    }
                    if (v == null || !(v instanceof TargetModuleState)) continue;
                    TargetModuleState targetModuleState = (TargetModuleState)v;
                    this.resetState(targetModuleState, string2);
                }
            }
        }
        if (applicationRuntimeState != null) {
            this.save(applicationRuntimeState);
        }
    }

    public void updateStateForRedeployOperationOnCluster(String string, DeploymentState deploymentState) {
        if (string == null) {
            return;
        }
        ApplicationRuntimeState applicationRuntimeState = this.getOrCreate(string);
        String string2 = applicationRuntimeState.getIntendedState(deploymentState.getTarget());
        applicationRuntimeState = this.updateIntendedState(string, deploymentState.getTarget(), deploymentState.getIntendedState());
        applicationRuntimeState = this.updateStagingState(string, deploymentState.getTarget(), deploymentState.getStagingState());
        applicationRuntimeState.updateState(deploymentState);
        try {
            this.save(applicationRuntimeState);
        }
        catch (ManagementException managementException) {
            DeploymentManagerLogger.logStatePersistenceFailed(string, managementException);
        }
    }

    public String[] getSubmoduleIds(String string, String string2) {
        ApplicationRuntimeState applicationRuntimeState = AppRuntimeStateManager.getManager().get(string);
        if (applicationRuntimeState == null) {
            return null;
        }
        Map map = applicationRuntimeState.getModules();
        if (map == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = TargetModuleState.extractSubmodule((String)iterator.next());
            if (string3 == null) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getStoppedModuleIds(String string, String string2) {
        AppRuntimeStateManager appRuntimeStateManager = AppRuntimeStateManager.getManager();
        if ("STATE_NEW".equals(appRuntimeStateManager.getIntendedState(string))) {
            return null;
        }
        String[] stringArray = appRuntimeStateManager.getModuleIds(string, true);
        if (stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = this.getCurrentState(string, stringArray[i], string2);
            if (!"STATE_NEW".equals(string3)) continue;
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Application: " + string + " has stopped module " + stringArray[i] + " on target server " + string2);
            }
            arrayList.add(stringArray[i]);
        }
        if (stringArray.length == arrayList.size()) {
            return null;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new String[0]);
    }
}

