/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import weblogic.deploy.internal.targetserver.state.TargetModuleState;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.DeploymentManagerLogger;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.AppRuntimeStateRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class AppRuntimeStateRuntimeMBeanImpl
extends DomainRuntimeMBeanDelegate
implements AppRuntimeStateRuntimeMBean {
    public static final String NAME = "AppRuntimeStateRuntime";
    private static final long TARGET_STATE_CACHE_EXPIRY = 15000L;
    private static AppRuntimeStateRuntimeMBeanImpl singleton = null;
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private Map targetStateCache = new ConcurrentHashMap();
    private Map targetTimestampCache = new ConcurrentHashMap();

    private AppRuntimeStateRuntimeMBeanImpl() throws ManagementException {
        super(NAME);
    }

    public static final void initialize() throws ManagementException {
        if (singleton == null) {
            if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
                String string = DeploymentManagerLogger.logMBeanUnavailable();
                throw new ManagementException(string);
            }
            singleton = new AppRuntimeStateRuntimeMBeanImpl();
            DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
            domainAccess.setAppRuntimeStateRuntime(singleton);
        }
    }

    public String[] getApplicationIds() {
        AppDeploymentMBean[] appDeploymentMBeanArray = AppDeploymentHelper.getAppsAndLibs(ManagementService.getRuntimeAccess(kernelId).getDomain());
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            AppDeploymentMBean appDeploymentMBean = appDeploymentMBeanArray[i];
            if (appDeploymentMBean.isInternalApp()) continue;
            arrayList.add(appDeploymentMBean.getName());
        }
        return arrayList.toArray(new String[0]);
    }

    public boolean isAdminMode(String string, String string2) {
        return AppRuntimeStateManager.getManager().isAdminMode(string, string2);
    }

    public boolean isActiveVersion(String string) {
        return AppRuntimeStateManager.getManager().isActiveVersion(string);
    }

    public long getRetireTimeMillis(String string) {
        return AppRuntimeStateManager.getManager().getRetireTimeMillis(string);
    }

    public int getRetireTimeoutSeconds(String string) {
        return AppRuntimeStateManager.getManager().getRetireTimeoutSeconds(string);
    }

    public String getIntendedState(String string) {
        return AppRuntimeStateManager.getManager().getIntendedState(string);
    }

    public String getIntendedState(String string, String string2) {
        String string3 = AppRuntimeStateManager.getManager().getIntendedState(string, string2);
        return this.fixState(string3, string2);
    }

    public String getCurrentState(String string, String string2) {
        String string3 = AppRuntimeStateManager.getManager().getCurrentState(string, string2);
        return this.fixState(string3, string2);
    }

    public String[] getModuleIds(String string) {
        return AppRuntimeStateManager.getManager().getModuleIds(string);
    }

    public String[] getSubmoduleIds(String string, String string2) {
        return AppRuntimeStateManager.getManager().getSubmoduleIds(string, string2);
    }

    public String getModuleType(String string, String string2) {
        return AppRuntimeStateManager.getManager().getModuleType(string, string2);
    }

    public String getCurrentState(String string, String string2, String string3) {
        String string4 = AppRuntimeStateManager.getManager().getCurrentState(string, string2, string3);
        return this.fixState(string4, string3);
    }

    public TargetModuleState[] getModuleStates(String string, String string2, String string3) {
        return AppRuntimeStateManager.getManager().getModuleStates(string, string2, string3);
    }

    public String[] getModuleTargets(String string, String string2) {
        return AppRuntimeStateManager.getManager().getModuleTargets(string, string2);
    }

    public String getCurrentState(String string, String string2, String string3, String string4) {
        String string5 = AppRuntimeStateManager.getManager().getCurrentState(string, string2, string3, string4);
        return this.fixState(string5, string4);
    }

    public String[] getModuleTargets(String string, String string2, String string3) {
        return AppRuntimeStateManager.getManager().getModuleTargets(string, string2, string3);
    }

    private String fixState(String string, String string2) {
        if ("STATE_NEW".equals(string)) {
            return string;
        }
        if (this.isTargetShutDown(string2)) {
            return "STATE_NEW";
        }
        return string;
    }

    private boolean isTargetShutDown(String string) {
        if (this.targetTimestampCache.containsKey(string)) {
            long l = (Long)this.targetTimestampCache.get(string);
            if (System.currentTimeMillis() < l + 15000L) {
                return (Boolean)this.targetStateCache.get(string);
            }
        }
        try {
            DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
            Set set = null;
            TargetMBean targetMBean = domainMBean.lookupTarget(string);
            if (targetMBean != null) {
                set = targetMBean.getServerNames();
            }
            if (set != null && !set.isEmpty()) {
                DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
                DomainRuntimeMBean domainRuntimeMBean = domainAccess.getDomainRuntime();
                DomainRuntimeServiceMBean domainRuntimeServiceMBean = domainAccess.getDomainRuntimeService();
                ServerRuntimeMBean[] serverRuntimeMBeanArray = domainRuntimeServiceMBean.getServerRuntimes();
                ArrayList<String> arrayList = new ArrayList<String>(serverRuntimeMBeanArray.length);
                if (serverRuntimeMBeanArray != null) {
                    for (ServerRuntimeMBean object : serverRuntimeMBeanArray) {
                        arrayList.add(object.getName());
                    }
                }
                for (String string2 : set) {
                    ServerLifeCycleRuntimeMBean serverLifeCycleRuntimeMBean;
                    int n = arrayList.contains(string2) ? 1 : 0;
                    if (n == 0 || (serverLifeCycleRuntimeMBean = domainRuntimeMBean.lookupServerLifeCycleRuntime(string2)) == null || "SHUTDOWN".equals(serverLifeCycleRuntimeMBean.getState())) continue;
                    this.targetStateCache.put(string, false);
                    this.targetTimestampCache.put(string, System.currentTimeMillis());
                    return false;
                }
                this.targetStateCache.put(string, true);
                this.targetTimestampCache.put(string, System.currentTimeMillis());
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

