/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.io.Serializable;
import weblogic.deploy.common.Debug;

public class AppTargetState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String appName;
    private String target;
    private String state;
    private int stagingState = -1;

    public AppTargetState() {
    }

    public AppTargetState(String string) {
        this();
        this.setAppName(string);
    }

    public AppTargetState(String string, String string2) {
        this(string);
        this.setTarget(string2);
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public String getState() {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug(" +++ Returning app's state : " + this.state);
        }
        return this.state;
    }

    public void setState(String string) {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug(" +++ Setting app's state : " + string);
        }
        this.state = string;
    }

    public final int getStagingState() {
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug(" +++ Getting app's stage state : " + this.stagingState);
        }
        return this.stagingState;
    }

    public final void setStagingState(int n) {
        if (n < 0 || n > 1) {
            throw new AssertionError((Object)("Given stagingState '" + n + "' is " + "invalid. It should be in the range'" + 0 + "' or '" + 1 + "'"));
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug(" +++ Setting app's stage state : " + n);
        }
        this.stagingState = n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString()).append("(");
        stringBuffer.append("appName=").append(this.appName).append(", ");
        stringBuffer.append("target=").append(this.target).append(", ");
        stringBuffer.append("state=").append(this.state).append(", ");
        stringBuffer.append("stagingState=").append(this.stagingState).append(")");
        return stringBuffer.toString();
    }
}

