/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import weblogic.management.deploy.internal.DeploymentAdapter;

abstract class AppTransition {
    private String name = null;
    private boolean startup = true;
    static final AppTransition PREPARE = new AppTransition("Prepare", true){

        void transitionApp(DeploymentAdapter deploymentAdapter, Object object) throws Exception {
            deploymentAdapter.prepare(object);
        }
    };
    static final AppTransition ACTIVATE = new AppTransition("Activate", true){

        void transitionApp(DeploymentAdapter deploymentAdapter, Object object) throws Exception {
            deploymentAdapter.activate(object);
        }
    };
    static final AppTransition ADMIN_TO_PRODUCTION = new AppTransition("Transition from admin to production", true){

        void transitionApp(DeploymentAdapter deploymentAdapter, Object object) throws Exception {
            deploymentAdapter.adminToProduction(object);
        }
    };
    static final AppTransition GRACEFUL_PRODUCTION_TO_ADMIN = new AppTransition("Graceful transition from production to admin", false){

        void transitionApp(DeploymentAdapter deploymentAdapter, Object object) throws Exception {
            deploymentAdapter.gracefulProductionToAdmin(object);
        }
    };
    static final AppTransition FORCE_PRODUCTION_TO_ADMIN = new AppTransition("Force transition from production to admin", false){

        void transitionApp(DeploymentAdapter deploymentAdapter, Object object) throws Exception {
            deploymentAdapter.forceProductionToAdmin(object);
        }
    };
    static final AppTransition DEACTIVATE = new AppTransition("Deactivate", false){

        void transitionApp(DeploymentAdapter deploymentAdapter, Object object) throws Exception {
            deploymentAdapter.deactivate(object);
        }
    };
    static final AppTransition UNPREPARE = new AppTransition("Unprepare", false){

        void transitionApp(DeploymentAdapter deploymentAdapter, Object object) throws Exception {
            deploymentAdapter.unprepare(object);
        }
    };

    private AppTransition(String string, boolean bl) {
        this.name = string;
        this.startup = bl;
    }

    public String toString() {
        return this.name;
    }

    boolean isStartup() {
        return this.startup;
    }

    abstract void transitionApp(DeploymentAdapter var1, Object var2) throws Exception;
}

