/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.AppDeployment;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.internal.ApplicationCompatibilityProcessor;
import weblogic.management.deploy.internal.DeploymentManagerLogger;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.provider.AccessCallback;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.UpdateException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.ArrayUtils;

public class ApplicationCompatibilityEditProcessor
extends ApplicationCompatibilityProcessor
implements AccessCallback,
PropertyChangeListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    DomainMBean root;
    private boolean expectingPeerCreationCallback = false;

    public void shutdown() {
        this.root.removePropertyChangeListener(this);
    }

    public void accessed(DomainMBean domainMBean) {
        this.root = domainMBean;
        try {
            this.updateConfiguration(domainMBean);
        }
        catch (UpdateException updateException) {
            throw new RuntimeException((Throwable)((Object)updateException));
        }
        domainMBean.addPropertyChangeListener(this);
    }

    ArrayUtils.DiffHandler createAppDeploymentHandler() {
        return new ArrayUtils.DiffHandler(){

            public void addObject(Object object) {
                AppDeploymentMBean appDeploymentMBean = (AppDeploymentMBean)object;
                try {
                    ApplicationCompatibilityEditProcessor.this.createApplication(appDeploymentMBean);
                    appDeploymentMBean.addPropertyChangeListener(ApplicationCompatibilityEditProcessor.this.createAppDeploymentListener(appDeploymentMBean));
                }
                catch (DeploymentException deploymentException) {
                    DeploymentManagerLogger.logConfigureAppMBeanFailed(appDeploymentMBean.getName());
                }
            }

            public void removeObject(Object object) {
                AppDeploymentMBean appDeploymentMBean = (AppDeploymentMBean)object;
                ApplicationMBean applicationMBean = ApplicationCompatibilityEditProcessor.this.root.lookupApplication(appDeploymentMBean.getName());
                if (applicationMBean == null) {
                    return;
                }
                if (MBeanConverter.isDebugEnabled()) {
                    MBeanConverter.debug("EditProcessor: Destroy " + applicationMBean.getObjectName() + " from " + ApplicationCompatibilityEditProcessor.this.root.getObjectName());
                }
                ApplicationCompatibilityEditProcessor.this.root.destroyApplication(applicationMBean);
            }
        };
    }

    private void createApplication(AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        String string = null;
        string = ManagementService.getRuntimeAccess(kernelId).isAdminServer() ? appDeploymentMBean.getAbsoluteSourcePath() : AppDeployment.getFile(appDeploymentMBean).getAbsolutePath();
        if (MBeanConverter.isDebugEnabled()) {
            MBeanConverter.debug(" AppPath : " + string);
        }
        MBeanConverter.createApplicationForAppDeployment(this.root, appDeploymentMBean, string);
    }

    private PropertyChangeListener createAppDeploymentListener(final AppDeploymentMBean appDeploymentMBean) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Targets") && TargetHelper.isTargetedLocaly(appDeploymentMBean)) {
                    try {
                        ApplicationCompatibilityEditProcessor.this.createApplication(appDeploymentMBean);
                    }
                    catch (DeploymentException deploymentException) {
                        throw new RuntimeException((Throwable)((Object)deploymentException));
                    }
                }
            }
        };
    }

    ArrayUtils.DiffHandler createApplicationHandler() {
        return new ArrayUtils.DiffHandler(){

            public void addObject(Object object) {
                ApplicationMBean applicationMBean = (ApplicationMBean)object;
                if (ApplicationCompatibilityEditProcessor.this.root.lookupAppDeployment(applicationMBean.getName()) == null) {
                    ApplicationCompatibilityEditProcessor.this.root.createAppDeployment(applicationMBean.getName(), "bea_wls_nullApp");
                    applicationMBean.setDelegationEnabled(true);
                }
            }

            public void removeObject(Object object) {
                ApplicationMBean applicationMBean = (ApplicationMBean)object;
                if (applicationMBean == null) {
                    return;
                }
                AppDeploymentMBean appDeploymentMBean = ApplicationCompatibilityEditProcessor.this.root.lookupAppDeployment(applicationMBean.getName());
                if (appDeploymentMBean != null) {
                    if (MBeanConverter.isDebugEnabled()) {
                        MBeanConverter.debug("EditProcessor: Destroy " + appDeploymentMBean.getObjectName() + " from " + ApplicationCompatibilityEditProcessor.this.root.getObjectName());
                    }
                    ApplicationCompatibilityEditProcessor.this.root.destroyAppDeployment(appDeploymentMBean);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ConfigurationMBean[] configurationMBeanArray;
        if (propertyChangeEvent.getPropertyName().equals("AppDeployments")) {
            configurationMBeanArray = (AppDeploymentMBean[])propertyChangeEvent.getNewValue();
            if (this.expectingPeerCreationCallback) {
                this.expectingPeerCreationCallback = false;
                return;
            }
            if (MBeanConverter.isDebugEnabled()) {
                MBeanConverter.debug("EditProcessor: AppDeployment change event");
            }
            this.expectingPeerCreationCallback = true;
            try {
                ArrayUtils.computeDiff((Object[])((Object[])propertyChangeEvent.getOldValue()), (Object[])configurationMBeanArray, (ArrayUtils.DiffHandler)this.createAppDeploymentHandler());
                Object var4_3 = null;
                this.expectingPeerCreationCallback = false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.expectingPeerCreationCallback = false;
                throw throwable;
            }
        }
        if (propertyChangeEvent.getPropertyName().equals("Applications")) {
            if (MBeanConverter.isDebugEnabled()) {
                MBeanConverter.debug("EditProcessor: Applications change event");
            }
            configurationMBeanArray = (ApplicationMBean[])propertyChangeEvent.getNewValue();
            if (this.expectingPeerCreationCallback) {
                this.expectingPeerCreationCallback = false;
                return;
            }
            for (int i = 0; i < configurationMBeanArray.length; ++i) {
                Object var6_7;
                this.expectingPeerCreationCallback = true;
                try {
                    ArrayUtils.computeDiff((Object[])((Object[])propertyChangeEvent.getOldValue()), (Object[])configurationMBeanArray, (ArrayUtils.DiffHandler)this.createApplicationHandler());
                    var6_7 = null;
                    this.expectingPeerCreationCallback = false;
                    continue;
                }
                catch (Throwable throwable) {
                    var6_7 = null;
                    this.expectingPeerCreationCallback = false;
                    throw throwable;
                }
            }
        }
    }
}

