/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.io.File;
import java.security.AccessController;
import weblogic.deploy.internal.targetserver.AppDeployment;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.internal.DeploymentManagerLogger;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.UpdateException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ApplicationCompatibilityProcessor
implements ConfigurationProcessor {
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        AppDeploymentMBean[] appDeploymentMBeanArray = domainMBean.getAppDeployments();
        for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
            AppDeploymentMBean appDeploymentMBean = appDeploymentMBeanArray[i];
            File file = ManagementService.getRuntimeAccess(kernelId).isAdminServer() ? new File(appDeploymentMBean.getAbsoluteSourcePath()) : AppDeployment.getFile(appDeploymentMBean);
            if (!file.exists()) continue;
            ApplicationMBean applicationMBean = null;
            try {
                applicationMBean = MBeanConverter.createApplicationForAppDeployment(domainMBean, appDeploymentMBean, file.getPath());
                if (applicationMBean == null) continue;
                applicationMBean.setAppDeployment(appDeploymentMBean);
                continue;
            }
            catch (DeploymentException deploymentException) {
                String string = DeploymentManagerLogger.logConfigureAppMBeanFailedLoggable(appDeploymentMBean.getName()).getMessage();
                throw new UpdateException(string, (Throwable)((Object)deploymentException));
            }
        }
    }
}

