/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.InvalidAttributeValueException;
import weblogic.Home;
import weblogic.application.utils.EarUtils;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.api.tools.Inspector;
import weblogic.deploy.api.tools.ModuleInfo;
import weblogic.deploy.common.Debug;
import weblogic.management.DistributedManagementException;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.ConnectorComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.EJBComponentMBean;
import weblogic.management.configuration.JDBCPoolComponentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetInfoMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WebAppComponentMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.deploy.internal.ApplicationPollerLogger;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ConfigurationProcessor;
import weblogic.management.provider.UpdateException;
import weblogic.utils.FileUtils;
import weblogic.utils.StringUtils;
import weblogic.utils.http.HttpParsing;

public class ApplicationMigrationProcessor
implements ConfigurationProcessor {
    public void updateConfiguration(DomainMBean domainMBean) throws UpdateException {
        String[] stringArray;
        ApplicationMBean[] applicationMBeanArray = domainMBean.getApplications();
        for (int i = 0; i < applicationMBeanArray.length; ++i) {
            stringArray = applicationMBeanArray[i];
            this.migrateStagingDirectoryIfNeeded((ApplicationMBean)stringArray, domainMBean);
            this.migrateAppIfLoadedFromOldAppsDir((ApplicationMBean)stringArray, domainMBean);
            this.createAppDeploymentForApplication(domainMBean, (ApplicationMBean)stringArray);
            domainMBean.destroyApplication((ApplicationMBean)stringArray);
        }
        File file = ApplicationMigrationProcessor.getOldAppPollerDir(domainMBean);
        ApplicationMigrationProcessor.printFileList(file);
        stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            File file2 = new File(DomainDir.getAppPollerDir());
            try {
                FileUtils.copy((File)file, (File)file2);
            }
            catch (IOException iOException) {
                throw new UpdateException(iOException);
            }
        }
        FileUtils.remove((File)file);
        this.migrateDefaultWebApps(domainMBean);
    }

    private void migrateStagingDirectoryIfNeeded(ApplicationMBean applicationMBean, DomainMBean domainMBean) throws UpdateException {
        if (ApplicationMigrationProcessor.isDebugEnabled()) {
            ApplicationMigrationProcessor.debugSay(" +++ Migrating Staging directory ...");
        }
        if (applicationMBean.getStagingMode() != "external_stage") {
            return;
        }
        List list = this.getRealTargets(applicationMBean, domainMBean);
        if (ApplicationMigrationProcessor.isDebugEnabled()) {
            ApplicationMigrationProcessor.debugSay(" +++ Collected Targets : " + list);
        }
        for (TargetMBean targetMBean : list) {
            this.migrateStagingDirectoryIfNeededForTarget(applicationMBean, targetMBean);
        }
        if (ApplicationMigrationProcessor.isDebugEnabled()) {
            ApplicationMigrationProcessor.debugSay(" +++ Migration of Staging directory completed");
        }
    }

    private void migrateStagingDirectoryIfNeededForTarget(ApplicationMBean applicationMBean, TargetMBean targetMBean) throws UpdateException {
        if (targetMBean instanceof ServerMBean) {
            String string;
            File file;
            ServerMBean serverMBean = (ServerMBean)targetMBean;
            String string2 = serverMBean.get81StyleDefaultStagingDirName();
            if (string2 == null) {
                return;
            }
            String string3 = string2 + File.separatorChar + applicationMBean.getName();
            if (ApplicationMigrationProcessor.isDebugEnabled()) {
                ApplicationMigrationProcessor.debugSay(" +++ oldDefaultStagingDirName : " + string3);
            }
            if (!(file = new File(string3)).exists()) {
                return;
            }
            String string4 = serverMBean.getDefaultStagingDirName();
            if (string4 == null) {
                return;
            }
            String string5 = string4 + File.separatorChar + applicationMBean.getName();
            if (ApplicationMigrationProcessor.isDebugEnabled()) {
                ApplicationMigrationProcessor.debugSay(" +++ newDefaultStagingDir : " + string5);
            }
            if ((string = serverMBean.getStagingDirectoryName()) == null) {
                return;
            }
            String string6 = string + File.separatorChar + applicationMBean.getName();
            if (ApplicationMigrationProcessor.isDebugEnabled()) {
                ApplicationMigrationProcessor.debugSay(" +++ appStagingDir : " + string6);
            }
            if (!string5.equals(string6)) {
                return;
            }
            try {
                FileUtils.copyPreserveTimestamps((File)file, (File)new File(string5));
                if (ApplicationMigrationProcessor.isDebugEnabled()) {
                    ApplicationMigrationProcessor.debugSay(" +++ copied oldDefaultStagingDir(" + file + ") to newDefaultStagingDir(" + string5 + ")");
                }
                FileUtils.remove((File)file);
                if (ApplicationMigrationProcessor.isDebugEnabled()) {
                    ApplicationMigrationProcessor.debugSay(" +++ deleted oldDefaultStagingDir(" + file + ")");
                }
            }
            catch (IOException iOException) {
                throw new UpdateException(iOException);
            }
        }
    }

    private List getRealTargets(ApplicationMBean applicationMBean, DomainMBean domainMBean) {
        List list = new ArrayList();
        ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
        if (componentMBeanArray != null) {
            for (int i = 0; i < componentMBeanArray.length; ++i) {
                List list2 = this.getRealTargets(componentMBeanArray[i], domainMBean);
                if (list.isEmpty()) {
                    list = list2;
                    continue;
                }
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    list = this.addTargetToListIfNeeded((TargetMBean)iterator.next(), list);
                }
            }
        }
        return list;
    }

    private List getRealTargets(ComponentMBean componentMBean, DomainMBean domainMBean) {
        int n;
        TargetMBean[] targetMBeanArray;
        List<TargetMBean> list = new ArrayList<TargetMBean>();
        if (componentMBean instanceof WebAppComponentMBean && (targetMBeanArray = ((WebAppComponentMBean)componentMBean).getVirtualHosts()) != null) {
            for (n = 0; n < targetMBeanArray.length; ++n) {
                Set set = targetMBeanArray[n].getServerNames();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    ServerMBean serverMBean = domainMBean.lookupServer((String)iterator.next());
                    list = this.addTargetToListIfNeeded(serverMBean, list);
                }
            }
        }
        if ((targetMBeanArray = componentMBean.getTargets()) != null) {
            if (list.isEmpty()) {
                List<TargetMBean> list2 = Arrays.asList(targetMBeanArray);
                list.addAll(list2);
                if (ApplicationMigrationProcessor.isDebugEnabled()) {
                    ApplicationMigrationProcessor.debugSay(" +++ Added targets : " + list2);
                }
            } else {
                for (n = 0; n < targetMBeanArray.length; ++n) {
                    list = this.addTargetToListIfNeeded(targetMBeanArray[n], list);
                }
            }
        }
        return list;
    }

    private List addTargetToListIfNeeded(TargetMBean targetMBean, List list) {
        if (targetMBean != null) {
            if (targetMBean instanceof ClusterMBean) {
                ClusterMBean clusterMBean = (ClusterMBean)targetMBean;
                ServerMBean[] serverMBeanArray = clusterMBean.getServers();
                for (int i = 0; i < serverMBeanArray.length; ++i) {
                    list = this.addTargetToListIfNeeded(serverMBeanArray[i], list);
                }
                return list;
            }
            if (!list.contains(targetMBean)) {
                list.add(targetMBean);
                if (ApplicationMigrationProcessor.isDebugEnabled()) {
                    ApplicationMigrationProcessor.debugSay(" +++ Added target : " + targetMBean.getName());
                }
            }
        }
        return list;
    }

    private void migrateDefaultWebApps(DomainMBean domainMBean) {
        VirtualHostMBean[] virtualHostMBeanArray;
        ServerMBean[] serverMBeanArray = domainMBean.getServers();
        if (serverMBeanArray != null) {
            for (int i = 0; i < serverMBeanArray.length; ++i) {
                this.migrateDefaultWebApps(serverMBeanArray[i].getWebServer());
            }
        }
        if ((virtualHostMBeanArray = domainMBean.getVirtualHosts()) != null) {
            for (int i = 0; i < virtualHostMBeanArray.length; ++i) {
                this.migrateDefaultWebApps(virtualHostMBeanArray[i]);
            }
        }
    }

    private void migrateDefaultWebApps(WebServerMBean webServerMBean) {
        if (webServerMBean.isSet("DefaultWebAppContextRoot") || !webServerMBean.isSet("DefaultWebApp") || webServerMBean.getDefaultWebApp() == null) {
            return;
        }
        String string = this.findContextRoot(webServerMBean.getDefaultWebApp());
        if (string != null) {
            webServerMBean.setDefaultWebAppContextRoot(string);
        }
    }

    private String findContextRoot(WebAppComponentMBean webAppComponentMBean) {
        return HttpParsing.ensureStartingSlash((String)webAppComponentMBean.getName());
    }

    private AppDeploymentMBean createAppDeploymentForApplication(DomainMBean domainMBean, ApplicationMBean applicationMBean) throws UpdateException {
        AppDeploymentMBean appDeploymentMBean;
        if (ApplicationMigrationProcessor.isDebugEnabled()) {
            ApplicationMigrationProcessor.debugSay("creating AppDeploymentMBean for " + applicationMBean);
        }
        boolean bl = false;
        int n = applicationMBean.getInternalType();
        if (n == 4) {
            if (new File(applicationMBean.getPath()).exists()) {
                DeployerRuntimeLogger.logUnknownAppType((String)applicationMBean.getName(), (String)applicationMBean.getPath());
                return null;
            }
            n = applicationMBean.getPath().endsWith(".ear") || applicationMBean.getComponents().length > 1 ? 0 : 1;
            bl = true;
        }
        if ((appDeploymentMBean = domainMBean.lookupAppDeployment(applicationMBean.getName())) != null) {
            String string = DeployerRuntimeLogger.appAlreadyExists((String)applicationMBean.getName());
            throw new UpdateException(string);
        }
        appDeploymentMBean = this.createAppDeploymentMBean(n, applicationMBean, domainMBean);
        applicationMBean.setDelegationEnabled(false);
        try {
            this.setAppDeploymentTargets(applicationMBean, appDeploymentMBean, bl);
            appDeploymentMBean.setDeploymentOrder(applicationMBean.getLoadOrder());
            if (applicationMBean.getStagingMode() != null) {
                appDeploymentMBean.setStagingMode(applicationMBean.getStagingMode());
            }
            appDeploymentMBean.setInternalApp(false);
            appDeploymentMBean.setSecurityDDModel("Advanced");
        }
        catch (Throwable throwable) {
            DeployerRuntimeLogger.logApplicationUpgradeProblem((String)applicationMBean.getName(), (Throwable)throwable);
            domainMBean.destroyAppDeployment(appDeploymentMBean);
        }
        applicationMBean.setDelegationEnabled(true);
        return appDeploymentMBean;
    }

    private AppDeploymentMBean createAppDeploymentMBean(int n, ApplicationMBean applicationMBean, DomainMBean domainMBean) {
        String string;
        String string2 = null;
        if (n == 2 || n == 0) {
            string = applicationMBean.getPath();
            string2 = ModuleType.EAR.toString();
        } else {
            ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
            if (componentMBeanArray == null || componentMBeanArray.length != 1) {
                DeployerRuntimeLogger.getOldActivateLoggable((String)applicationMBean.getName()).log();
                string = applicationMBean.getPath();
            } else {
                String string3 = applicationMBean.getComponents()[0].getURI();
                if (string3.equals("jms-xa-adp.rar") || string3.equals("jms-local-adp.rar") || string3.equals("jms-notran-adp.rar") || string3.equals("jms-notran-adp51.rar")) {
                    Home.getHome();
                    String string4 = Home.getPath();
                    string = string4 + File.separatorChar + "lib" + File.separatorChar + applicationMBean.getComponents()[0].getURI();
                } else {
                    string = applicationMBean.getPath() + File.separatorChar + applicationMBean.getComponents()[0].getURI();
                }
                string2 = this.getTypeFromComp(applicationMBean.getComponents()[0]);
            }
        }
        AppDeploymentMBean appDeploymentMBean = domainMBean.createAppDeployment(applicationMBean.getName(), string);
        appDeploymentMBean.setModuleType(string2);
        return appDeploymentMBean;
    }

    private void setAppDeploymentTargets(ApplicationMBean applicationMBean, AppDeploymentMBean appDeploymentMBean, boolean bl) throws DistributedManagementException, InvalidAttributeValueException, UpdateException {
        ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
        if (componentMBeanArray == null) {
            return;
        }
        if (componentMBeanArray.length == 1) {
            appDeploymentMBean.setTargets(componentMBeanArray[0].getTargets());
            String string = componentMBeanArray[0].getName();
            if (!string.equals(appDeploymentMBean.getName())) {
                appDeploymentMBean.setCompatibilityName(string);
                appDeploymentMBean.setModuleType(this.getTypeFromComp(componentMBeanArray[0]));
            }
        } else {
            this.setAppDeploymentTargetsForEAR(applicationMBean, appDeploymentMBean, bl);
        }
    }

    private void setAppDeploymentTargetsForEAR(ApplicationMBean applicationMBean, AppDeploymentMBean appDeploymentMBean, boolean bl) throws InvalidAttributeValueException, DistributedManagementException, UpdateException {
        HashMap hashMap = new HashMap();
        Inspector inspector = null;
        ModuleInfo[] moduleInfoArray = null;
        if (!bl) {
            try {
                inspector = new Inspector(new File(applicationMBean.getPath()));
                moduleInfoArray = inspector.getModuleInfo().getSubModules();
            }
            catch (Throwable throwable) {
                if (inspector != null) {
                    inspector.close();
                }
                throw new UpdateException(throwable.getMessage());
            }
        }
        boolean bl2 = bl || this.hasAllModules(applicationMBean, moduleInfoArray);
        ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
        for (int i = 0; componentMBeanArray != null && i < componentMBeanArray.length; ++i) {
            TargetMBean[] targetMBeanArray = this.getTargetsAndVirtualHosts(componentMBeanArray[i]);
            for (int j = 0; j < targetMBeanArray.length; ++j) {
                String string = this.getNameForSubDeployment(componentMBeanArray[i], moduleInfoArray, bl);
                SubDeploymentMBean subDeploymentMBean = appDeploymentMBean.lookupSubDeployment(string);
                if (subDeploymentMBean == null) {
                    subDeploymentMBean = appDeploymentMBean.createSubDeployment(string);
                }
                subDeploymentMBean.setCompatibilityName(componentMBeanArray[i].getName());
                subDeploymentMBean.setModuleType(this.getTypeFromComp(componentMBeanArray[i]));
                if (bl2 && this.isGlobalTarget(componentMBeanArray, targetMBeanArray[j], hashMap)) {
                    this.addTarget(appDeploymentMBean, targetMBeanArray[j]);
                    continue;
                }
                this.addTarget(subDeploymentMBean, targetMBeanArray[j]);
            }
        }
        if (inspector != null) {
            inspector.close();
        }
    }

    private void addTarget(TargetInfoMBean targetInfoMBean, TargetMBean targetMBean) throws DistributedManagementException, InvalidAttributeValueException {
        if (targetInfoMBean.getTargets() == null || targetInfoMBean.getTargets().length == 0) {
            targetInfoMBean.addTarget(targetMBean);
        } else {
            TargetMBean[] targetMBeanArray = targetInfoMBean.getTargets();
            for (int i = 0; targetMBeanArray != null && i < targetMBeanArray.length; ++i) {
                if (!targetMBeanArray[i].getName().equals(targetMBean.getName())) continue;
                return;
            }
            targetInfoMBean.addTarget(targetMBean);
        }
    }

    private boolean hasAllModules(ApplicationMBean applicationMBean, ModuleInfo[] moduleInfoArray) {
        return moduleInfoArray.length == applicationMBean.getComponents().length;
    }

    private String getNameForSubDeployment(ComponentMBean componentMBean, ModuleInfo[] moduleInfoArray, boolean bl) {
        String string;
        if (componentMBean instanceof WebAppComponentMBean && (string = this.getContextRoot(componentMBean, moduleInfoArray, bl)) != null & !"".equals(string) & !"/".equals(string)) {
            return string;
        }
        return componentMBean.getURI() == null ? componentMBean.getName() : componentMBean.getURI();
    }

    private String getContextRoot(ComponentMBean componentMBean, ModuleInfo[] moduleInfoArray, boolean bl) {
        if (bl) {
            return null;
        }
        String string = null;
        if (moduleInfoArray.length == 0) {
            throw new AssertionError((Object)"EAR has no modules.");
        }
        for (int i = 0; moduleInfoArray != null && i < moduleInfoArray.length; ++i) {
            if (!moduleInfoArray[i].getName().equals(componentMBean.getURI())) continue;
            String[] stringArray = moduleInfoArray[i].getContextRoots();
            string = stringArray == null || stringArray.length <= 0 ? null : (stringArray.length == 1 ? EarUtils.fixAppContextRoot(stringArray[0]) : componentMBean.getName());
        }
        return string;
    }

    private String getTypeFromComp(ComponentMBean componentMBean) {
        if (componentMBean instanceof WebAppComponentMBean) {
            return ModuleType.WAR.toString();
        }
        if (componentMBean instanceof EJBComponentMBean) {
            return ModuleType.EJB.toString();
        }
        if (componentMBean instanceof ConnectorComponentMBean) {
            return ModuleType.RAR.toString();
        }
        if (componentMBean instanceof JDBCPoolComponentMBean) {
            return WebLogicModuleType.JDBC.toString();
        }
        return "unknown";
    }

    private TargetMBean[] getTargetsAndVirtualHosts(ComponentMBean componentMBean) {
        VirtualHostMBean[] virtualHostMBeanArray;
        ArrayList<TargetMBean> arrayList = new ArrayList<TargetMBean>();
        TargetMBean[] targetMBeanArray = componentMBean.getTargets();
        if (targetMBeanArray != null) {
            arrayList.addAll(Arrays.asList(targetMBeanArray));
        }
        if (componentMBean instanceof WebAppComponentMBean && (virtualHostMBeanArray = ((WebAppComponentMBean)componentMBean).getVirtualHosts()) != null) {
            arrayList.addAll(Arrays.asList(virtualHostMBeanArray));
        }
        return arrayList.toArray(new TargetMBean[arrayList.size()]);
    }

    private boolean isGlobalTarget(ComponentMBean[] componentMBeanArray, TargetMBean targetMBean, Map map) {
        for (int i = 0; i < componentMBeanArray.length; ++i) {
            Set set = this.getOrCreateTargetList(componentMBeanArray[i], map);
            if (set.contains(targetMBean.getName())) continue;
            return false;
        }
        return true;
    }

    private Set getOrCreateTargetList(ComponentMBean componentMBean, Map map) {
        HashSet<String> hashSet = (HashSet<String>)map.get(componentMBean.getName() + componentMBean.getType());
        if (hashSet == null) {
            hashSet = new HashSet<String>();
            TargetMBean[] targetMBeanArray = this.getTargetsAndVirtualHosts(componentMBean);
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                hashSet.add(targetMBeanArray[i].getName());
            }
            map.put(componentMBean.getName() + componentMBean.getType(), hashSet);
        }
        return hashSet;
    }

    private boolean ensureNewAppPollerDirExists(File file) throws UpdateException {
        boolean bl = true;
        if (!file.exists()) {
            bl = file.mkdir();
        }
        if (!bl) {
            String string = ApplicationPollerLogger.logCouldnotCreateAutodeployDirLoggable((String)file.toString()).getMessage();
            throw new UpdateException(string);
        }
        return bl;
    }

    private void migrateAppIfLoadedFromOldAppsDir(ApplicationMBean applicationMBean, DomainMBean domainMBean) throws UpdateException {
        String string = applicationMBean.getPath();
        File file = new File(string);
        File file2 = new File(DomainDir.getAppPollerDir());
        String string2 = file2.getAbsolutePath();
        boolean bl = this.ensureNewAppPollerDirExists(file2);
        if (!bl) {
            return;
        }
        File file3 = ApplicationMigrationProcessor.getOldAppPollerDir(domainMBean);
        String string3 = file3.getAbsolutePath();
        if (!file3.exists()) {
            return;
        }
        try {
            if (!file.isAbsolute()) {
                file = new File(DomainDir.getRootDir(), string);
            }
            file = file.getCanonicalFile();
            string = file.getCanonicalPath();
            file3 = file3.getCanonicalFile();
            string3 = file3.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            file2 = file2.getCanonicalFile();
            string2 = file2.getCanonicalPath();
            if (ApplicationMigrationProcessor.isLoadedFromOldAppsDir(file, domainMBean)) {
                String string4 = string2;
                if (!string.equals(string3)) {
                    string4 = StringUtils.replaceGlobal((String)string, (String)string3, (String)string2);
                }
                if (!string.equals(string3)) {
                    File file4 = new File(string4);
                    FileUtils.copy((File)file, (File)file4);
                    if (ApplicationMigrationProcessor.isDebugEnabled()) {
                        ApplicationMigrationProcessor.debugSay(" +++ copied " + file + " to " + file4);
                    }
                    boolean bl2 = FileUtils.remove((File)file);
                    if (ApplicationMigrationProcessor.isDebugEnabled()) {
                        ApplicationMigrationProcessor.debugSay(" +++ Removed " + file + " :: " + bl2);
                    }
                } else {
                    ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
                    for (int i = 0; i < componentMBeanArray.length; ++i) {
                        String string5 = string + File.separatorChar + componentMBeanArray[i].getURI();
                        File file5 = new File(string5);
                        File file6 = new File(file2, componentMBeanArray[i].getURI());
                        FileUtils.copy((File)file5, (File)file6);
                        if (ApplicationMigrationProcessor.isDebugEnabled()) {
                            ApplicationMigrationProcessor.debugSay(" +++ copied component " + file5 + " to " + file6);
                        }
                        boolean bl3 = FileUtils.remove((File)file5);
                        if (!ApplicationMigrationProcessor.isDebugEnabled()) continue;
                        ApplicationMigrationProcessor.debugSay(" +++ Removed " + file5 + " :: " + bl3);
                    }
                }
                if (ApplicationMigrationProcessor.isDebugEnabled()) {
                    ApplicationMigrationProcessor.debugSay(" +++ Application migrated to new autodeploy directory: " + string4);
                }
                applicationMBean.setPath(string4);
                ApplicationPollerLogger.logApplicationMigrated((String)applicationMBean.getName(), (String)string4);
            }
        }
        catch (IOException iOException) {
            String string6 = ApplicationPollerLogger.logIOExceptionLoggable((IOException)iOException).getMessage();
            throw new UpdateException(string6);
        }
        catch (ManagementException managementException) {
            String string7 = ApplicationPollerLogger.logExceptionWhileMigratingLoggable((Exception)((Object)managementException)).getMessage();
            throw new UpdateException(string7);
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            String string8 = ApplicationPollerLogger.logExceptionWhileMigratingLoggable((Exception)invalidAttributeValueException).getMessage();
            throw new UpdateException(string8);
        }
    }

    public static boolean isLoadedFromOldAppsDir(File file, DomainMBean domainMBean) {
        File file2 = ApplicationMigrationProcessor.getOldAppPollerDir(domainMBean);
        String string = file2.getName();
        try {
            file2 = file2.getCanonicalFile();
            string = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            ApplicationPollerLogger.logIOException((IOException)iOException);
        }
        String string2 = file.getAbsolutePath();
        try {
            file = file.getCanonicalFile();
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            ApplicationPollerLogger.logIOException((IOException)iOException);
        }
        return string2.indexOf(string) > -1;
    }

    private static void debugSay(String string) {
        Debug.deploymentDebug(string);
    }

    private static boolean isDebugEnabled() {
        return Debug.isDeploymentDebugEnabled();
    }

    private static void printFileList(File file) {
        if (ApplicationMigrationProcessor.isDebugEnabled()) {
            String[] stringArray = file.list();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("ls ").append(file.toString()).append(" - ");
            if (stringArray == null) {
                stringBuffer.append(" nothing to list since file doesn't exist");
            } else {
                stringBuffer.append("" + stringArray.length).append(" : ");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (i != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(stringArray[i]);
                }
            }
            Debug.deploymentDebug(stringBuffer.toString());
        }
    }

    private static File getOldAppPollerDir(DomainMBean domainMBean) {
        File file = null;
        if (domainMBean.getConfigurationVersion().startsWith("6")) {
            String string = DomainDir.getRootDir() + File.separator + "config" + File.separator + domainMBean.getName() + File.separator + "applications";
            file = new File(string);
        } else {
            file = new File(DomainDir.getOldAppPollerDir());
        }
        return file;
    }
}

