/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.DeploymentVersion;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.deploy.internal.targetserver.state.TargetModuleState;
import weblogic.management.deploy.internal.AppTargetState;

public class ApplicationRuntimeState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String appId;
    private int retireTimeoutSecs = -1;
    private long retireTimeMillis = -1L;
    private HashMap appTargetState = new HashMap();
    private DeploymentVersion deploymentVersion = null;
    private Map modules = new HashMap();

    public ApplicationRuntimeState() {
    }

    ApplicationRuntimeState(String string) {
        this.appId = string;
    }

    ApplicationRuntimeState(ApplicationRuntimeState applicationRuntimeState) {
        this.appId = applicationRuntimeState.getAppId();
        this.retireTimeoutSecs = applicationRuntimeState.getRetireTimeoutSeconds();
        this.retireTimeMillis = applicationRuntimeState.getRetireTimeMillis();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("AppRTState");
        stringBuffer.append("[").append("appId=").append(this.appId).append(",retireTimeoutSecs=").append(this.retireTimeoutSecs).append(",retireTimeMillis=").append(this.retireTimeMillis).append(",\nModule(s) State:").append(this.modules).append(",\nAppTarget(s) State:").append(this.appTargetState);
        if (this.deploymentVersion != null) {
            stringBuffer.append(",\nDeploymentVersion=").append(this.deploymentVersion);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getIntendedState(String string) {
        AppTargetState appTargetState = this.getAppTargetState(string);
        return appTargetState == null ? null : appTargetState.getState();
    }

    public int getStagingState(String string) {
        AppTargetState appTargetState = this.getAppTargetState(string);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug(" AppTargetState for '" + string + "' is : " + appTargetState);
        }
        return appTargetState == null ? -1 : appTargetState.getStagingState();
    }

    public String getAppId() {
        return this.appId;
    }

    public boolean isAdminMode(String string) {
        return "STATE_ADMIN".equals(this.getIntendedState(string));
    }

    public boolean isActiveVersion() {
        return this.retireTimeMillis == 0L;
    }

    void setActiveVersion(boolean bl) {
        if (this.retireTimeMillis > 0L && !bl) {
            return;
        }
        this.retireTimeMillis = 0L;
    }

    public int getRetireTimeoutSeconds() {
        return this.retireTimeoutSecs;
    }

    void setRetireTimeoutSeconds(int n) {
        this.retireTimeoutSecs = n;
    }

    public long getRetireTimeMillis() {
        return this.retireTimeMillis;
    }

    void setRetireTimeMillis(long l) {
        this.retireTimeMillis = l;
    }

    public final DeploymentVersion getDeploymentVersion() {
        return this.deploymentVersion;
    }

    public final void setDeploymentVersion(DeploymentVersion deploymentVersion) {
        this.deploymentVersion = deploymentVersion;
    }

    public Map getModules() {
        return this.modules;
    }

    public Map getAppTargetState() {
        return this.appTargetState;
    }

    public AppTargetState getAppTargetState(String string) {
        return (AppTargetState)this.appTargetState.get(string);
    }

    public void updateAppTargetState(AppTargetState appTargetState, String string) {
        this.appTargetState.put(string, appTargetState);
    }

    public void removeAppTargetState(String string) {
        this.appTargetState.remove(string);
    }

    void updateState(DeploymentState deploymentState) {
        TargetModuleState[] targetModuleStateArray = deploymentState.getTargetModules();
        this.updateState(targetModuleStateArray);
        targetModuleStateArray = new TargetModuleState[]{new TargetModuleState("ROOT_MODULE", "*", deploymentState.getTarget(), "*", deploymentState.getServerName())};
        targetModuleStateArray[0].setCurrentState(deploymentState.getCurrentState());
        this.updateState(targetModuleStateArray);
    }

    public void updateState(TargetModuleState[] targetModuleStateArray) {
        for (int i = 0; targetModuleStateArray != null && i < targetModuleStateArray.length; ++i) {
            Serializable serializable;
            HashMap<String, TargetModuleState> hashMap;
            TargetModuleState targetModuleState = targetModuleStateArray[i];
            if (this.skip(targetModuleState)) continue;
            HashMap hashMap2 = (HashMap)this.modules.get(targetModuleState.getModuleId());
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
            }
            if ((hashMap = (HashMap<String, TargetModuleState>)hashMap2.get(targetModuleState.getTargetName())) == null) {
                hashMap = new HashMap<String, TargetModuleState>();
            }
            if (targetModuleState.isLogicalTarget()) {
                serializable = hashMap.get(targetModuleState.getServerName());
                if (serializable == null) {
                    serializable = new HashMap();
                }
                ((Map)((Object)serializable)).put(targetModuleState.getServerName(), targetModuleState);
            } else {
                serializable = targetModuleState;
            }
            hashMap.put(targetModuleState.getServerName(), (TargetModuleState)serializable);
            hashMap2.put(targetModuleState.getTargetName(), hashMap);
            this.modules.put(targetModuleState.getModuleId(), hashMap2);
        }
    }

    private boolean skip(TargetModuleState targetModuleState) {
        return targetModuleState.getCurrentState() == null || targetModuleState.getModuleId() == null || targetModuleState.getTargetName() == null || targetModuleState.getServerName() == null;
    }

    void resetState(String string) {
        for (String string2 : this.modules.keySet()) {
            HashMap hashMap = (HashMap)this.modules.get(string2);
            if (hashMap == null) {
                hashMap = new HashMap();
            }
            for (String string3 : hashMap.keySet()) {
                Map map = (Map)hashMap.get(string3);
                if (map == null) continue;
                Object v = hashMap.get(string3);
                if (v instanceof Map) {
                    Map map2 = (Map)v;
                    Object v2 = map2.get(string);
                    if (v2 instanceof Map) {
                        v2 = ((Map)v2).get(string);
                    }
                    if (v2 == null) continue;
                    this.resetState((TargetModuleState)v2, string);
                    continue;
                }
                this.resetState((TargetModuleState)v, string);
            }
        }
    }

    private void resetState(TargetModuleState targetModuleState, String string) {
        if (targetModuleState.getServerName().equals(string) && !"STATE_RETIRED".equals(targetModuleState.getCurrentState())) {
            targetModuleState.setCurrentState("STATE_NEW");
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("reset: " + targetModuleState);
            }
        }
    }
}

