/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.io.Serializable;
import weblogic.utils.Debug;

public class ComponentTarget
implements Serializable {
    private static final long serialVersionUID = 3862450250430200114L;
    public static final int COMPONENT_TARGET_SERVER = 1;
    public static final int COMPONENT_TARGET_CLUSTER = 2;
    public static final int COMPONENT_TARGET_VIRTUALHOST = 3;
    private String componentTarget = null;
    private String clusterTarget = null;
    private String physicalTarget = null;
    private int targetType;
    private String signature = null;
    private int hashCodeValue;

    public ComponentTarget(String string, String string2, int n) {
        this.componentTarget = string;
        this.physicalTarget = string2;
        this.targetType = n;
        this.signature = this.computeSignature();
        this.hashCodeValue = this.signature.hashCode();
    }

    public ComponentTarget(String string, String string2, String string3, int n) {
        if (n == 3) {
            this.clusterTarget = string2;
        } else {
            Debug.assertion((boolean)false, (String)"ClusterTarget can be set only for VirtualHost");
        }
        this.componentTarget = string;
        this.physicalTarget = string3;
        this.targetType = n;
        this.signature = this.computeSignature();
        this.hashCodeValue = this.signature.hashCode();
    }

    public String getComponentTarget() {
        return this.componentTarget;
    }

    public String getClusterTarget() {
        return this.clusterTarget;
    }

    public String getPhysicalTarget() {
        return this.physicalTarget;
    }

    public boolean isVirtualHostClustered() {
        return this.clusterTarget != null;
    }

    public int getTargetType() {
        return this.targetType;
    }

    public boolean equals(Object object) {
        ComponentTarget componentTarget;
        boolean bl = false;
        if (object == this) {
            bl = true;
        } else if (object instanceof ComponentTarget && (componentTarget = (ComponentTarget)object).toString().equals(this.signature)) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.signature;
    }

    public int hashCode() {
        return this.hashCodeValue;
    }

    private String computeSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ComponentTarget:");
        stringBuffer.append(this.componentTarget);
        stringBuffer.append(":");
        if (this.clusterTarget != null) {
            stringBuffer.append(this.getTargetTypeString(2));
            stringBuffer.append(this.clusterTarget);
            stringBuffer.append(":");
        }
        stringBuffer.append(this.getTargetTypeString(1));
        stringBuffer.append(this.physicalTarget);
        return stringBuffer.toString();
    }

    private String getTargetTypeString(int n) {
        switch (n) {
            case 1: {
                return "Server:";
            }
            case 2: {
                return "Cluster:";
            }
            case 3: {
                return "VirtualHost:";
            }
        }
        Debug.assertion((boolean)false, (String)"Illegal TargetType");
        return null;
    }
}

