/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.MigratableTargetMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WebDeploymentMBean;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class ComponentTargetValidator {
    ComponentMBean component;
    Set clusterTargets = new HashSet();
    Set serverTargets = new HashSet();
    Set hostTargets = new HashSet();
    private static AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public ComponentTargetValidator(ComponentMBean componentMBean) throws ManagementException {
        this.component = componentMBean;
        TargetMBean[] targetMBeanArray = componentMBean.getTargets();
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            TargetMBean targetMBean = targetMBeanArray[i];
            if (targetMBean instanceof ServerMBean) {
                this.addServerTarget((ServerMBean)targetMBean, true);
                continue;
            }
            if (targetMBean instanceof ClusterMBean) {
                this.addClusterTarget((ClusterMBean)targetMBean);
                continue;
            }
            if (!(targetMBean instanceof MigratableTargetMBean)) continue;
        }
        if (componentMBean instanceof WebDeploymentMBean) {
            VirtualHostMBean[] virtualHostMBeanArray = ((WebDeploymentMBean)((Object)componentMBean)).getVirtualHosts();
            for (int i = 0; i < virtualHostMBeanArray.length; ++i) {
                this.addHostTarget(virtualHostMBeanArray[i]);
            }
        }
    }

    public ComponentMBean getComponent() {
        return this.component;
    }

    public void addClusterTarget(ClusterMBean clusterMBean) throws ManagementException {
        ServerMBean[] serverMBeanArray = clusterMBean.getServers();
        for (int i = 0; i < serverMBeanArray.length; ++i) {
            if (!this.serverTargets.contains(serverMBeanArray[i])) continue;
            Loggable loggable = DeployerRuntimeLogger.logClusterMemberAlreadyTargetedLoggable((String)clusterMBean.getName(), (String)serverMBeanArray[i].getName(), (String)this.component.getName());
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
        this.clusterTargets.add(clusterMBean);
    }

    public void addServerTarget(ServerMBean serverMBean, boolean bl) throws ManagementException {
        ClusterMBean clusterMBean;
        if (bl && (clusterMBean = serverMBean.getCluster()) != null) {
            if (this.clusterTargets.contains(clusterMBean)) {
                Loggable loggable = DeployerRuntimeLogger.logServerAlreadyTargetedByClusterLoggable((String)clusterMBean.getName(), (String)serverMBean.getName(), (String)this.component.getName());
                loggable.log();
                throw new ManagementException(loggable.getMessage());
            }
            ServerMBean[] serverMBeanArray = clusterMBean.getServers();
            if (serverMBeanArray != null) {
                for (int i = 0; i < serverMBeanArray.length; ++i) {
                    ServerMBean serverMBean2 = serverMBeanArray[i];
                    if (serverMBean2.getName().equals(serverMBean.getName()) || !this.serverTargets.contains(serverMBean2)) continue;
                    Loggable loggable = DeployerRuntimeLogger.logServerAlreadyTargetedByOtherClusterMemberLoggable((String)clusterMBean.getName(), (String)serverMBean.getName(), (String)serverMBean2.getName(), (String)this.component.getName());
                    loggable.log();
                }
            }
        }
        this.serverTargets.add(serverMBean);
    }

    public void addHostTarget(VirtualHostMBean virtualHostMBean) throws ManagementException {
        if (!(this.component instanceof WebDeploymentMBean)) {
            Loggable loggable = DeployerRuntimeLogger.logHostTargetForNonWebAppLoggable((String)virtualHostMBean.getName(), (String)this.component.getName());
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
        this.hostTargets.add(virtualHostMBean);
    }

    public void addTarget(String string, DomainMBean domainMBean, boolean bl) throws ManagementException {
        DomainMBean domainMBean2 = null;
        domainMBean2 = domainMBean != null ? domainMBean : ManagementService.getRuntimeAccess(kernelId).getDomain();
        ServerMBean serverMBean = domainMBean2.lookupServer(string);
        if (serverMBean != null) {
            this.addServerTarget(serverMBean, bl);
            return;
        }
        ClusterMBean clusterMBean = domainMBean2.lookupCluster(string);
        if (clusterMBean != null) {
            this.addClusterTarget(clusterMBean);
            return;
        }
        VirtualHostMBean virtualHostMBean = domainMBean2.lookupVirtualHost(string);
        if (virtualHostMBean != null) {
            this.addHostTarget(virtualHostMBean);
            return;
        }
        Loggable loggable = DeployerRuntimeLogger.logNoSuchTargetLoggable((String)string);
        loggable.log();
        throw new ManagementException(loggable.getMessage());
    }
}

