/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import weblogic.application.FatalModuleException;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.DeploymentType;
import weblogic.deploy.internal.TargetHelper;
import weblogic.deploy.internal.targetserver.AppDeployment;
import weblogic.deploy.internal.targetserver.BasicDeployment;
import weblogic.deploy.internal.targetserver.OrderedDeployments;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.AppTransition;
import weblogic.management.deploy.internal.DeploymentAdapter;
import weblogic.management.deploy.internal.SlaveDeployerLogger;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.ServerLifecycleException;
import weblogic.server.ServiceFailureException;

public class ConfiguredDeployments {
    private static ConfiguredDeployments singleton;
    private static final String PSEUDO_DEPLOYMENT_HANDLER = "PseudoDeploymentHandler";
    private static final String PSEUDO_RESOURCE_DEPENDENT_DEPLOYMENT_HANDLER = "PseudoResourceDependentDeploymentHandler";
    private static final String PSEUDO_STARTUP_CLASS = "PseudoStartupClass";
    private static final String TUNNELING_WEBAPP = "bea_wls_internal";
    private static AuthenticatedSubject kernelId;
    private static final AppRuntimeStateManager appRTStateMgr;
    private static final DomainMBean domain;

    private ConfiguredDeployments() {
        singleton = this;
    }

    static ConfiguredDeployments getConfigureDeploymentsHandler() {
        if (singleton == null) {
            new ConfiguredDeployments();
        }
        return singleton;
    }

    void deployPreStandbyInternalApps() throws ServiceFailureException {
        try {
            AppDeploymentMBean appDeploymentMBean = domain.lookupInternalAppDeployment(TUNNELING_WEBAPP);
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Deploy preStandby internal app bea_wls_internal, mbean=" + appDeploymentMBean);
            }
            if (appDeploymentMBean == null) {
                return;
            }
            BasicDeployment basicDeployment = OrderedDeployments.getOrCreateBasicDeployment(appDeploymentMBean);
            basicDeployment.prepare();
            basicDeployment.activateFromServerLifecycle();
            basicDeployment.adminToProductionFromServerLifecycle();
        }
        catch (Exception exception) {
            throw new ServiceFailureException("Cannot deploy internal app bea_wls_internal", (Throwable)exception);
        }
    }

    void undeployPreStandbyInternalApps() throws ServiceFailureException {
        block4: {
            try {
                AppDeploymentMBean appDeploymentMBean = domain.lookupInternalAppDeployment(TUNNELING_WEBAPP);
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("undeploy preStandby internal app bea_wls_internal, mbean=" + appDeploymentMBean);
                }
                if (appDeploymentMBean == null) {
                    return;
                }
                BasicDeployment basicDeployment = OrderedDeployments.getOrCreateBasicDeployment(appDeploymentMBean);
                basicDeployment.productionToAdminFromServerLifecycle(false);
                basicDeployment.deactivateFromServerLifecycle();
                basicDeployment.unprepare();
            }
            catch (Exception exception) {
                if (!Debug.isDeploymentDebugEnabled()) break block4;
                Debug.deploymentDebug("Cannot deploy internal app bea_wls_internal", exception);
            }
        }
    }

    void deploy() throws DeploymentException, ServiceFailureException {
        SlaveDeployerLogger.logSlaveResumeStart();
        this.init();
        this.prepare();
        this.activate();
    }

    private void init() throws DeploymentException, ServiceFailureException {
        BasicDeploymentMBean[] basicDeploymentMBeanArray = domain.getBasicDeployments();
        for (int i = 0; i < basicDeploymentMBeanArray.length; ++i) {
            BasicDeploymentMBean basicDeploymentMBean = basicDeploymentMBeanArray[i];
            if (this.isRetiredApp(basicDeploymentMBean)) {
                if (!Debug.isDeploymentDebugEnabled()) continue;
                Debug.deploymentDebug("Skipping retired app: " + basicDeploymentMBean);
                continue;
            }
            if (TargetHelper.isTargetedLocaly(basicDeploymentMBean)) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("+++ " + basicDeploymentMBean.getName() + " is locally targeted");
                }
                OrderedDeployments.getOrCreateBasicDeployment(basicDeploymentMBean);
                continue;
            }
            if (!TargetHelper.isPinnedToServerInCluster(basicDeploymentMBean) || basicDeploymentMBean instanceof SystemResourceMBean) continue;
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("+++ " + basicDeploymentMBean.getName() + " is pinned to other servers in cluster");
            }
            OrderedDeployments.getOrCreateBasicDeployment(basicDeploymentMBean);
        }
        OrderedDeployments.addDeployment(DeploymentType.PSEUDO_DEPLOYMENT_HANDLER_MBEAN, PSEUDO_DEPLOYMENT_HANDLER);
        OrderedDeployments.addDeployment(DeploymentType.PSEUDO_RESOURCE_DEPENDENT_DEP_HANDLER_MBEAN, PSEUDO_RESOURCE_DEPENDENT_DEPLOYMENT_HANDLER);
        OrderedDeployments.addDeployment(DeploymentType.PSEUDO_STARTUP_CLASS_MBEAN, PSEUDO_STARTUP_CLASS);
    }

    private void prepare() throws DeploymentException, ServiceFailureException {
        this.transitionApps(AppTransition.PREPARE);
    }

    private void activate() throws DeploymentException, ServiceFailureException {
        this.transitionApps(AppTransition.ACTIVATE);
    }

    void adminToProduction() throws DeploymentException, ServiceFailureException {
        this.transitionApps(AppTransition.ADMIN_TO_PRODUCTION);
    }

    void productionToAdmin(boolean bl) throws DeploymentException, ServiceFailureException {
        if (bl) {
            this.transitionApps(AppTransition.GRACEFUL_PRODUCTION_TO_ADMIN);
        } else {
            this.transitionApps(AppTransition.FORCE_PRODUCTION_TO_ADMIN);
        }
    }

    void undeploy() throws DeploymentException, ServiceFailureException {
        this.deactivate();
        this.unprepare();
    }

    private void deactivate() throws DeploymentException, ServiceFailureException {
        this.transitionApps(AppTransition.DEACTIVATE);
    }

    private void unprepare() throws DeploymentException, ServiceFailureException {
        this.transitionApps(AppTransition.UNPREPARE);
    }

    private void transitionApps(AppTransition appTransition) throws DeploymentException, ServiceFailureException {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = this.getAppsIterator(appTransition);
        while (iterator.hasNext()) {
            DeploymentAdapter deploymentAdapter;
            Object e = iterator.next();
            if (this.isPreStandbyApp(e) || (deploymentAdapter = this.getDeploymentAdapter(e)) == null) continue;
            if (!arrayList2.isEmpty() && !this.isSameApp(e, arrayList2.get(0))) {
                this.transitionApps(appTransition, arrayList2, arrayList);
                arrayList2.clear();
            }
            if (this.isAppVersion(e)) {
                boolean bl = this.isActiveAppVersion(e);
                if (appTransition.isStartup() && bl || !appTransition.isStartup() && !bl) {
                    if (!this.isAdminMode(e)) {
                        arrayList2.add(0, e);
                        continue;
                    }
                    arrayList2.add(e);
                    continue;
                }
            }
            try {
                appTransition.transitionApp(deploymentAdapter, e);
            }
            catch (Throwable throwable) {
                this.handleAppException(appTransition, e, throwable, arrayList);
            }
        }
        if (!arrayList2.isEmpty()) {
            this.transitionApps(appTransition, arrayList2, arrayList);
            arrayList2.clear();
        }
        this.handleFailedApps(arrayList, appTransition);
    }

    private void transitionApps(AppTransition appTransition, ArrayList arrayList, ArrayList arrayList2) throws DeploymentException, ServiceFailureException {
        for (Object e : arrayList) {
            DeploymentAdapter deploymentAdapter = this.getDeploymentAdapter(e);
            if (deploymentAdapter == null) continue;
            try {
                appTransition.transitionApp(deploymentAdapter, e);
            }
            catch (Throwable throwable) {
                this.handleAppException(appTransition, e, throwable, arrayList2);
            }
        }
    }

    private void handleAppException(AppTransition appTransition, Object object, Throwable throwable, ArrayList arrayList) throws DeploymentException, ServiceFailureException {
        if (throwable instanceof ServiceFailureException) {
            throw (ServiceFailureException)throwable;
        }
        if (throwable instanceof FatalModuleException) {
            try {
                ManagementService.getRuntimeAccess(kernelId).getServerRuntime().abortStartupAfterAdminState();
            }
            catch (ServerLifecycleException serverLifecycleException) {
                throw (FatalModuleException)((Object)throwable);
            }
        }
        if (!(object instanceof BasicDeployment)) {
            SlaveDeployerLogger.logAppStartupFailed((Throwable)throwable);
        }
        if (appTransition.isStartup()) {
            arrayList.add(object);
        }
    }

    private Iterator getAppsIterator(AppTransition appTransition) {
        if (appTransition.isStartup()) {
            return OrderedDeployments.getDeployments().iterator();
        }
        return new Iterator(){
            private Collection deps = OrderedDeployments.getDeployments();
            private ListIterator listIter = new ArrayList(this.deps).listIterator(this.deps.size());

            public boolean hasNext() {
                return this.listIter.hasPrevious();
            }

            public Object next() {
                return this.listIter.previous();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void handleFailedApps(List list, AppTransition appTransition) throws DeploymentException {
        block9: {
            Object object2;
            if (list.size() == 0) {
                return;
            }
            for (Object object2 : list) {
                DeploymentAdapter deploymentAdapter = this.getDeploymentAdapter(object2);
                if (deploymentAdapter == null) continue;
                try {
                    deploymentAdapter.remove(object2, false);
                }
                catch (Throwable throwable) {
                    Debug.deploymentDebug("Error in removing deployment", throwable);
                }
            }
            ServerMBean serverMBean = ManagementService.getRuntimeAccess(kernelId).getServer();
            object2 = serverMBean.getCluster();
            if (object2 == null) {
                return;
            }
            if (appTransition == AppTransition.ACTIVATE) {
                return;
            }
            if (Boolean.getBoolean("weblogic.deployment.IgnorePrepareStateFailures")) {
                return;
            }
            try {
                ManagementService.getRuntimeAccess(kernelId).getServerRuntime().abortStartupAfterAdminState();
                SlaveDeployerLogger.logStartupFailedTransitionToAdmin((String)serverMBean.getName(), (String)object2.getName());
            }
            catch (ServerLifecycleException serverLifecycleException) {
                if (appTransition != AppTransition.PREPARE) break block9;
                this.failForErrorsInCluster(serverMBean.getName(), object2.getName());
            }
        }
    }

    private void failForErrorsInCluster(String string, String string2) throws DeploymentException {
        if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            Loggable loggable = SlaveDeployerLogger.logStartupFailedLoggable((String)string, (String)string2);
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
        SlaveDeployerLogger.logFailedDeployClusterAS((String)string, (String)string2);
    }

    private DeploymentAdapter getDeploymentAdapter(Object object) {
        if (object instanceof BasicDeployment) {
            return DeploymentAdapter.BASIC_DEP_ADAPTER;
        }
        if (object == PSEUDO_DEPLOYMENT_HANDLER) {
            return DeploymentAdapter.DEPLOYMENT_HANDLERS_ADAPTER;
        }
        if (object == PSEUDO_RESOURCE_DEPENDENT_DEPLOYMENT_HANDLER) {
            return DeploymentAdapter.RESOURCE_DEPENDENT_DEPLOYMENT_HANDLERS_ADAPTER;
        }
        if (object == PSEUDO_STARTUP_CLASS) {
            return DeploymentAdapter.STARTUP_CLASSES_ADAPTER;
        }
        return null;
    }

    private boolean isPreStandbyApp(Object object) {
        if (!(object instanceof AppDeployment)) {
            return false;
        }
        return TUNNELING_WEBAPP.equals(((AppDeployment)object).getName());
    }

    private boolean isAppVersion(Object object) {
        if (!(object instanceof AppDeployment)) {
            return false;
        }
        AppDeploymentMBean appDeploymentMBean = (AppDeploymentMBean)((AppDeployment)object).getDeploymentMBean();
        return appDeploymentMBean.getVersionIdentifier() != null;
    }

    private boolean isActiveAppVersion(Object object) {
        return object instanceof AppDeployment && appRTStateMgr.isActiveVersion(((AppDeployment)object).getDeploymentMBean().getName());
    }

    private boolean isAdminMode(Object object) {
        return object instanceof AppDeployment && appRTStateMgr.isAdminMode(((AppDeployment)object).getDeploymentMBean().getName());
    }

    private boolean isSameApp(Object object, Object object2) {
        if (!(object instanceof AppDeployment) || !(object2 instanceof AppDeployment)) {
            return false;
        }
        AppDeploymentMBean appDeploymentMBean = (AppDeploymentMBean)((AppDeployment)object).getDeploymentMBean();
        AppDeploymentMBean appDeploymentMBean2 = (AppDeploymentMBean)((AppDeployment)object2).getDeploymentMBean();
        return appDeploymentMBean.getApplicationName().equals(appDeploymentMBean2.getApplicationName());
    }

    private boolean isRetiredApp(BasicDeploymentMBean basicDeploymentMBean) {
        return basicDeploymentMBean instanceof AppDeploymentMBean && appRTStateMgr.isRetiredVersion((AppDeploymentMBean)basicDeploymentMBean);
    }

    static {
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        appRTStateMgr = AppRuntimeStateManager.getManager();
        domain = ManagementService.getRuntimeAccess(kernelId).getDomain();
    }
}

