/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.adminserver.operations.AbstractOperation;
import weblogic.deploy.internal.adminserver.operations.ActivateOperation;
import weblogic.deploy.internal.adminserver.operations.DeactivateOperation;
import weblogic.deploy.internal.adminserver.operations.DeployOperation;
import weblogic.deploy.internal.adminserver.operations.DistributeOperation;
import weblogic.deploy.internal.adminserver.operations.RedeployOperation;
import weblogic.deploy.internal.adminserver.operations.RemoveOperation;
import weblogic.deploy.internal.adminserver.operations.RetireOperation;
import weblogic.deploy.internal.adminserver.operations.StartOperation;
import weblogic.deploy.internal.adminserver.operations.StopForGracefulRetireOperation;
import weblogic.deploy.internal.adminserver.operations.StopOperation;
import weblogic.deploy.internal.adminserver.operations.UnprepareOperation;
import weblogic.deploy.internal.adminserver.operations.UpdateOperation;
import weblogic.deploy.internal.targetserver.DeployHelper;
import weblogic.descriptor.DescriptorBean;
import weblogic.logging.Loggable;
import weblogic.management.ManagementException;
import weblogic.management.TargetAvailabilityStatus;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.ConfigurationMBean;
import weblogic.management.configuration.DeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.WebDeploymentMBean;
import weblogic.management.deploy.DeploymentData;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.deploy.internal.AppMBeanUsages;
import weblogic.management.deploy.internal.ComponentTarget;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.DeploymentServerService;
import weblogic.management.deploy.status.StatusFactory;
import weblogic.management.provider.DomainAccess;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RegistrationHandler;
import weblogic.management.provider.Service;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.utils.AssertionError;
import weblogic.work.WorkManagerFactory;

public final class DeployerRuntimeImpl
extends DomainRuntimeMBeanDelegate
implements DeployerRuntimeMBean {
    private static final int RETIRE_TIME = Integer.parseInt(System.getProperty("weblogic.management.deploy.taskRetireTime", "300"));
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final long serialVersionUID = 3609892051956468810L;
    private static final Map taskMap = new LinkedHashMap();
    private Timer tasksRetirePoller = null;
    private int nextId = 0;

    public DeployerRuntimeImpl() throws ManagementException {
        throw new AssertionError("Constructor not valid on singleton MBean");
    }

    DeployerRuntimeImpl(String string) throws ManagementException {
        super(string);
        DomainAccess domainAccess = ManagementService.getDomainAccess(kernelId);
        domainAccess.addRegistrationHandler(new RegistrationHandler(){

            public void registered(RuntimeMBean runtimeMBean, DescriptorBean descriptorBean) {
            }

            public void unregistered(RuntimeMBean runtimeMBean) {
                if (runtimeMBean instanceof DeploymentTaskRuntimeMBean) {
                    taskMap.remove(((DeploymentTaskRuntimeMBean)runtimeMBean).getId());
                }
            }

            public void registeredCustom(ObjectName objectName, Object object) {
            }

            public void unregisteredCustom(ObjectName objectName) {
            }

            public void registered(Service service2) {
            }

            public void unregistered(Service service2) {
            }
        });
        this.tasksRetirePoller = this.startTasksRetirePoller();
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Created deployer: " + this);
        }
    }

    private Timer startTasksRetirePoller() {
        long l = 30000L;
        Timer timer = TimerManagerFactory.getTimerManagerFactory().getTimerManager("weblogic.management.TasksRetirePoller", WorkManagerFactory.getInstance().getSystem()).schedule((TimerListener)new TasksRetirePoller(), 0L, l);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Started TasksRetirePoller to execute  repeatedly for every 30 seconds");
        }
        return timer;
    }

    private void checkAndMarkRetiredTasks() {
        for (DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean : taskMap.values()) {
            if (deploymentTaskRuntimeMBean.isRetired() || deploymentTaskRuntimeMBean.isRunning()) continue;
            long l = deploymentTaskRuntimeMBean.getEndTime();
            long l2 = l + (long)(RETIRE_TIME * 1000);
            long l3 = System.currentTimeMillis();
            if (l3 < l2) continue;
            deploymentTaskRuntimeMBean.setRetired();
        }
    }

    public DeploymentTaskRuntimeMBean activate(String string, String string2, String string3, DeploymentData deploymentData, String string4) throws ManagementException {
        return this.activate(string, string2, string3, deploymentData, string4, true);
    }

    public DeploymentTaskRuntimeMBean activate(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl) throws ManagementException {
        this.checkDeployerActions(string4, string2, 1);
        return this.performDeployerActions(string, string2, string3, deploymentData, string4, bl, new ActivateOperation());
    }

    public DeploymentTaskRuntimeMBean deactivate(String string, DeploymentData deploymentData, String string2) throws ManagementException {
        return this.deactivate(string, deploymentData, string2, true);
    }

    public DeploymentTaskRuntimeMBean deactivate(String string, DeploymentData deploymentData, String string2, boolean bl) throws ManagementException {
        this.checkDeployerActions(string2, string, 3);
        return this.performDeployerActions(null, string, null, deploymentData, string2, bl, new DeactivateOperation());
    }

    public DeploymentTaskRuntimeMBean remove(String string, DeploymentData deploymentData, String string2) throws ManagementException {
        return this.remove(string, deploymentData, string2, true);
    }

    public DeploymentTaskRuntimeMBean remove(String string, DeploymentData deploymentData, String string2, boolean bl) throws ManagementException {
        int n = 4;
        this.checkDeployerActions(string2, string, n);
        return this.performDeployerActions(null, string, null, deploymentData, string2, bl, new RemoveOperation(n));
    }

    public DeploymentTaskRuntimeMBean unprepare(String string, DeploymentData deploymentData, String string2) throws ManagementException {
        return this.unprepare(string, deploymentData, string2, true);
    }

    public DeploymentTaskRuntimeMBean unprepare(String string, DeploymentData deploymentData, String string2, boolean bl) throws ManagementException {
        this.checkDeployerActions(string2, string, 5);
        return this.performDeployerActions(null, string, null, deploymentData, string2, bl, new UnprepareOperation());
    }

    public DeploymentTaskRuntimeMBean distribute(String string, String string2, DeploymentData deploymentData, String string3) throws ManagementException {
        return this.distribute(string, string2, deploymentData, string3, true);
    }

    public DeploymentTaskRuntimeMBean distribute(String string, String string2, DeploymentData deploymentData, String string3, boolean bl) throws ManagementException {
        string2 = this.ensureAppName(string2);
        this.assertNameIsNonNull(string2, DeployHelper.getTaskName(6));
        this.checkDeployerActions(string3, string2, 6);
        String string4 = DeployHelper.getStagingModeFromOptions(deploymentData);
        return this.performDeployerActions(string, string2, string4, deploymentData, string3, bl, new DistributeOperation());
    }

    public DeploymentTaskRuntimeMBean deploy(String string, String string2, String string3, DeploymentData deploymentData, String string4) throws ManagementException {
        return this.deploy(string, string2, string3, deploymentData, string4, true);
    }

    public DeploymentTaskRuntimeMBean deploy(String string, String string2, String string3, DeploymentData deploymentData, String string4, boolean bl) throws ManagementException {
        this.checkDeployerActions(string4, string2, 11);
        return this.performDeployerActions(string, string2, string3, deploymentData, string4, bl, new DeployOperation());
    }

    public DeploymentTaskRuntimeMBean undeploy(String string, DeploymentData deploymentData, String string2) throws ManagementException {
        return this.undeploy(string, deploymentData, string2, true);
    }

    public DeploymentTaskRuntimeMBean undeploy(String string, DeploymentData deploymentData, String string2, boolean bl) throws ManagementException {
        int n = 12;
        this.checkDeployerActions(string2, string, n);
        return this.performDeployerActions(null, string, null, deploymentData, string2, bl, new RemoveOperation(n));
    }

    public DeploymentTaskRuntimeMBean start(String string, DeploymentData deploymentData, String string2) throws ManagementException {
        return this.start(string, deploymentData, string2, true);
    }

    public DeploymentTaskRuntimeMBean start(String string, DeploymentData deploymentData, String string2, boolean bl) throws ManagementException {
        string = this.ensureAppName(string);
        this.assertNameIsNonNull(string, DeployHelper.getTaskName(7));
        this.checkDeployerActions(string2, string, 7);
        return this.performDeployerActions(null, string, null, deploymentData, string2, bl, new StartOperation());
    }

    public DeploymentTaskRuntimeMBean stop(String string, DeploymentData deploymentData, String string2) throws ManagementException {
        return this.stop(string, deploymentData, string2, true);
    }

    public DeploymentTaskRuntimeMBean stop(String string, DeploymentData deploymentData, String string2, boolean bl) throws ManagementException {
        this.checkDeployerActions(string2, string, 8);
        return this.performDeployerActions(null, string, null, deploymentData, string2, bl, new StopOperation());
    }

    public DeploymentTaskRuntimeMBean redeploy(String string, DeploymentData deploymentData, String string2) throws ManagementException {
        return this.redeploy(string, deploymentData, string2, true);
    }

    public DeploymentTaskRuntimeMBean redeploy(String string, DeploymentData deploymentData, String string2, boolean bl) throws ManagementException {
        this.checkDeployerActions(string2, string, 9);
        return this.performDeployerActions(null, string, null, deploymentData, string2, bl, new RedeployOperation());
    }

    public DeploymentTaskRuntimeMBean redeploy(String string, String string2, DeploymentData deploymentData, String string3, boolean bl) throws ManagementException {
        this.checkDeployerActions(string3, string2, 9);
        return this.performDeployerActions(string, string2, null, deploymentData, string3, bl, new DeployOperation(true));
    }

    public DeploymentTaskRuntimeMBean update(String string, DeploymentData deploymentData, String string2, boolean bl) throws ManagementException {
        this.checkDeployerActions(string2, string, 10);
        return this.performDeployerActions(null, string, null, deploymentData, string2, bl, new UpdateOperation());
    }

    public DeploymentTaskRuntimeMBean stopForGracefulRetire(String string, DeploymentData deploymentData, String string2, boolean bl) throws ManagementException {
        this.checkDeployerActions(string2, string, 8);
        return this.performDeployerActions(null, string, null, deploymentData, string2, bl, new StopForGracefulRetireOperation());
    }

    public DeploymentTaskRuntimeMBean retire(String string, DeploymentData deploymentData, String string2, boolean bl) throws ManagementException {
        this.checkDeployerActions(string2, string, 13);
        return this.performDeployerActions(null, string, null, deploymentData, string2, bl, new RetireOperation());
    }

    public DeploymentTaskRuntimeMBean[] list() {
        return taskMap.values().toArray(new DeploymentTaskRuntimeMBean[taskMap.size()]);
    }

    public DeploymentTaskRuntimeMBean[] getDeploymentTaskRuntimes() {
        return this.list();
    }

    public DeploymentTaskRuntimeMBean query(String string) {
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime(string);
        return deploymentTaskRuntime;
    }

    public boolean removeTask(String string) {
        block4: {
            if (string == null || string.length() == 0) {
                return false;
            }
            try {
                DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime(string);
                if (deploymentTaskRuntime != null) {
                    ((DomainRuntimeMBeanDelegate)deploymentTaskRuntime).unregister();
                    return true;
                }
            }
            catch (Exception exception) {
                if (!Debug.isDeploymentDebugEnabled()) break block4;
                Debug.deploymentDebug("Remove DeploymentTaskRuntimeMBean failed for id: " + string + ", ex:" + exception.getMessage());
            }
        }
        return false;
    }

    public String[] purgeRetiredTasks() {
        String[] stringArray2;
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this.getRetiredTasks();
        for (String[] stringArray2 : list) {
            String string = stringArray2.getId();
            this.removeTask(string);
            arrayList.add(string);
        }
        if (arrayList.size() == 0) {
            return new String[0];
        }
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug(" +++ taskIds removed : " + arrayList);
        }
        stringArray2 = new String[arrayList.size()];
        stringArray2 = arrayList.toArray(stringArray2);
        return stringArray2;
    }

    private List getRetiredTasks() {
        ArrayList<DeploymentTaskRuntimeMBean> arrayList = new ArrayList<DeploymentTaskRuntimeMBean>();
        for (DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean : taskMap.values()) {
            if (!deploymentTaskRuntimeMBean.isRetired()) continue;
            arrayList.add(deploymentTaskRuntimeMBean);
        }
        return arrayList;
    }

    private void assertNameIsNonNull(String string, String string2) throws ManagementException {
        if (string == null) {
            Loggable loggable = DeployerRuntimeLogger.logNullAppLoggable((String)"null", (String)string2);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    private synchronized int getNextTaskId() {
        return this.nextId++;
    }

    public DeploymentTaskRuntime getTaskRuntime(String string) {
        return (DeploymentTaskRuntime)taskMap.get(string);
    }

    public void registerTaskRuntime(String string, DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        taskMap.put(string, deploymentTaskRuntimeMBean);
    }

    private void ensureTaskIsNotAlreadyRunning(String string, int n) throws ManagementException {
        if (string == null) {
            return;
        }
        DeploymentTaskRuntime deploymentTaskRuntime = this.getTaskRuntime(string);
        if (deploymentTaskRuntime != null) {
            Loggable loggable = DeployerRuntimeLogger.logTaskInUseLoggable((String)string, (String)DeployHelper.getTaskName(n), (String)this.name);
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    private void ensureDeploymentServiceStarted(String string, int n) throws ManagementException {
        if (!DeploymentServerService.isStarted()) {
            Loggable loggable = DeployerRuntimeLogger.logDeploymentServiceNotStartedLoggable((String)string, (String)DeployHelper.getTaskName(n));
            loggable.log();
            throw new ManagementException(loggable.getMessage());
        }
    }

    private void ensureNoTaskConflict(String string, int n) throws ManagementException {
        DeploymentTaskRuntimeMBean[] deploymentTaskRuntimeMBeanArray;
        if (7 == n && (deploymentTaskRuntimeMBeanArray = this.list()).length > 0) {
            for (int i = 0; i < deploymentTaskRuntimeMBeanArray.length; ++i) {
                if (deploymentTaskRuntimeMBeanArray[i].getState() != 1 || deploymentTaskRuntimeMBeanArray[i].getTask() != 8 || !deploymentTaskRuntimeMBeanArray[i].getApplicationName().equals(string)) continue;
                Loggable loggable = DeployerRuntimeLogger.logTaskConflictLoggable((String)string, (String)DeployHelper.getTaskName(n), (String)DeployHelper.getTaskName(deploymentTaskRuntimeMBeanArray[i].getTask()));
                loggable.log();
                throw new ManagementException(loggable.getMessage());
            }
        }
    }

    private void checkDeployerActions(String string, String string2, int n) throws ManagementException {
        this.ensureTaskIsNotAlreadyRunning(string, n);
        this.ensureDeploymentServiceStarted(string2, n);
        this.ensureNoTaskConflict(string2, n);
    }

    private DeploymentTaskRuntimeMBean performDeployerActions(final String string, final String string2, final String string3, DeploymentData deploymentData, String string4, boolean bl, final AbstractOperation abstractOperation) throws ManagementException {
        String string5;
        DeploymentData deploymentData2;
        Object object;
        if (string4 == null || string4.equals(" ")) {
            string4 = Integer.toString(this.getNextTaskId());
            if (Debug.isDeploymentDebugEnabled()) {
                Debug.deploymentDebug("Creating DeploymentTaskRuntime with id: " + string4);
            }
        }
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)kernelId);
        if (Debug.isDeploymentDebugEnabled()) {
            Debug.deploymentDebug("Deployment operation subject: " + authenticatedSubject);
        }
        if ((object = SecurityServiceManager.runAs((AuthenticatedSubject)kernelId, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)new PrivilegedAction(deploymentData2 = deploymentData == null ? new DeploymentData() : deploymentData, string5 = string4, bl, authenticatedSubject){
            final /* synthetic */ DeploymentData val$infoToBePassed;
            final /* synthetic */ String val$id;
            final /* synthetic */ boolean val$startIt;
            final /* synthetic */ AuthenticatedSubject val$authenticatedSubject;
            {
                this.val$infoToBePassed = deploymentData;
                this.val$id = string4;
                this.val$startIt = bl;
                this.val$authenticatedSubject = authenticatedSubject;
            }

            public Object run() {
                Object object;
                try {
                    object = abstractOperation.execute(string, string2, string3, this.val$infoToBePassed, this.val$id, this.val$startIt, this.val$authenticatedSubject);
                }
                catch (ManagementException managementException) {
                    object = managementException;
                }
                return object;
            }
        })) instanceof ManagementException) {
            throw (ManagementException)((Object)object);
        }
        return (DeploymentTaskRuntimeMBean)object;
    }

    public DeploymentMBean[] getDeployments(TargetMBean targetMBean) {
        return AppMBeanUsages.getDeployments(targetMBean);
    }

    private String ensureAppName(String string) {
        return ApplicationVersionUtils.getApplicationName(string);
    }

    public Map getAvailabilityStatusForApplication(String string, boolean bl) throws InstanceNotFoundException {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        ApplicationMBean applicationMBean = ApplicationVersionUtils.getActiveAppDeployment(string).getAppMBean();
        ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
        if (componentMBeanArray != null) {
            for (int i = 0; i < componentMBeanArray.length; ++i) {
                Map map = this.getAvailabilityStatusForComponent(componentMBeanArray[i], false);
                hashMap.put(componentMBeanArray[i].getName(), map);
            }
        }
        return hashMap;
    }

    public Map getAvailabilityStatusForComponent(ComponentMBean componentMBean, boolean bl) throws InstanceNotFoundException {
        VirtualHostMBean[] virtualHostMBeanArray;
        HashMap<String, TargetAvailabilityStatus> hashMap = new HashMap<String, TargetAvailabilityStatus>();
        ApplicationMBean applicationMBean = ApplicationVersionUtils.getActiveAppDeployment(componentMBean.getApplication().getName()).getAppMBean();
        TargetMBean[] targetMBeanArray = componentMBean.getTargets();
        if (targetMBeanArray != null) {
            for (int i = 0; i < targetMBeanArray.length; ++i) {
                TargetAvailabilityStatus targetAvailabilityStatus = this.getAvailabilityStatusForComponentTarget(applicationMBean, componentMBean, targetMBeanArray[i]);
                hashMap.put(targetMBeanArray[i].getName(), targetAvailabilityStatus);
            }
        }
        if (componentMBean instanceof WebDeploymentMBean && (virtualHostMBeanArray = ((WebDeploymentMBean)((Object)componentMBean)).getVirtualHosts()) != null) {
            for (int i = 0; i < virtualHostMBeanArray.length; ++i) {
                TargetAvailabilityStatus targetAvailabilityStatus = this.getAvailabilityStatusForComponentTarget(applicationMBean, componentMBean, virtualHostMBeanArray[i]);
                hashMap.put(virtualHostMBeanArray[i].getName(), targetAvailabilityStatus);
            }
        }
        ArrayList arrayList = new ArrayList();
        TargetMBean[] targetMBeanArray2 = componentMBean.getActivatedTargets();
        if (targetMBeanArray2 != null) {
            for (int i = 0; i < targetMBeanArray2.length; ++i) {
                TargetAvailabilityStatus targetAvailabilityStatus;
                String string = targetMBeanArray2[i].getName();
                if (hashMap.containsKey(string) || arrayList.contains(string)) continue;
                TargetMBean targetMBean = null;
                DomainMBean domainMBean = ManagementService.getRuntimeAccess(kernelId).getDomain();
                ServerMBean serverMBean = domainMBean.lookupServer(string);
                ClusterMBean clusterMBean = null;
                VirtualHostMBean virtualHostMBean = null;
                if (serverMBean != null) {
                    targetMBean = serverMBean;
                } else {
                    clusterMBean = domainMBean.lookupCluster(string);
                    if (clusterMBean != null) {
                        targetMBean = clusterMBean;
                    } else {
                        virtualHostMBean = domainMBean.lookupVirtualHost(string);
                        if (virtualHostMBean != null) {
                            targetMBean = virtualHostMBean;
                        }
                    }
                }
                if (targetMBean == null || (targetAvailabilityStatus = this.getAvailabilityStatusForComponentTarget(applicationMBean, componentMBean, targetMBean)) == null) continue;
                hashMap.put(string, targetAvailabilityStatus);
            }
        }
        return hashMap;
    }

    private TargetAvailabilityStatus getAvailabilityStatusForComponentTarget(ApplicationMBean applicationMBean, ComponentMBean componentMBean, ConfigurationMBean configurationMBean) throws InstanceNotFoundException {
        Object[] objectArray;
        TargetAvailabilityStatus targetAvailabilityStatus = StatusFactory.getInstance().createStatus(applicationMBean, configurationMBean);
        boolean bl = applicationMBean.getStagingMode().equals("stage");
        String string = configurationMBean.getName();
        TargetMBean[] targetMBeanArray = componentMBean.getActivatedTargets();
        if (configurationMBean instanceof VirtualHostMBean) {
            objectArray = ((VirtualHostMBean)configurationMBean).getTargets();
            for (int i = 0; i < objectArray.length; ++i) {
                this.updateAvailabilityStatusFromActivatedTargets(targetMBeanArray, configurationMBean, objectArray[i].getName(), targetAvailabilityStatus);
            }
        } else {
            this.updateAvailabilityStatusFromActivatedTargets(targetMBeanArray, configurationMBean, string, targetAvailabilityStatus);
        }
        if (bl) {
            objectArray = componentMBean.getApplication().getStagedTargets();
            targetAvailabilityStatus.updateUnavailabilityStatus(Arrays.asList(objectArray));
        }
        if (Debug.isDeploymentDebugEnabled()) {
            this.printStatus(targetAvailabilityStatus);
        }
        return targetAvailabilityStatus;
    }

    private void updateAvailabilityStatusFromActivatedTargets(TargetMBean[] targetMBeanArray, ConfigurationMBean configurationMBean, String string, TargetAvailabilityStatus targetAvailabilityStatus) {
        for (int i = 0; i < targetMBeanArray.length; ++i) {
            if (!targetMBeanArray[i].getName().equals(string)) continue;
            Set set = DeployerRuntimeImpl.createComponentTarget(targetMBeanArray[i], configurationMBean);
            for (ComponentTarget componentTarget : set) {
                targetAvailabilityStatus.updateAvailabilityStatus(componentTarget);
            }
            break;
        }
    }

    private static Set createComponentTarget(TargetMBean targetMBean, ConfigurationMBean configurationMBean) {
        HashSet<ComponentTarget> hashSet;
        block7: {
            block5: {
                block6: {
                    hashSet = new HashSet<ComponentTarget>();
                    if (configurationMBean == null || !(configurationMBean instanceof VirtualHostMBean)) break block5;
                    if (!(targetMBean instanceof ServerMBean)) break block6;
                    hashSet.add(new ComponentTarget(configurationMBean.getName(), targetMBean.getName(), 3));
                    break block7;
                }
                if (!(targetMBean instanceof ClusterMBean)) break block7;
                ServerMBean[] serverMBeanArray = ((ClusterMBean)targetMBean).getServers();
                for (int i = 0; i < serverMBeanArray.length; ++i) {
                    hashSet.add(new ComponentTarget(configurationMBean.getName(), targetMBean.getName(), serverMBeanArray[i].getName(), 3));
                }
                break block7;
            }
            if (targetMBean instanceof ServerMBean) {
                hashSet.add(new ComponentTarget(targetMBean.getName(), targetMBean.getName(), 1));
            } else if (targetMBean instanceof ClusterMBean) {
                ServerMBean[] serverMBeanArray = ((ClusterMBean)targetMBean).getServers();
                for (int i = 0; i < serverMBeanArray.length; ++i) {
                    hashSet.add(new ComponentTarget(targetMBean.getName(), serverMBeanArray[i].getName(), 2));
                }
            }
        }
        return hashSet;
    }

    private void printStatus(TargetAvailabilityStatus targetAvailabilityStatus) {
        switch (targetAvailabilityStatus.getTargetType()) {
            case 1: {
                Debug.deploymentDebug("Target Name:" + targetAvailabilityStatus.getTargetName() + " Target Type: Server");
                Debug.deploymentDebug("Deployment Status:" + targetAvailabilityStatus.getDeploymentStatus());
                Debug.deploymentDebug("Availability Status: " + targetAvailabilityStatus.getAvailabilityStatus());
                break;
            }
            case 2: {
                Debug.deploymentDebug("Target Name:" + targetAvailabilityStatus.getTargetName() + " Target Type: Cluster");
                Debug.deploymentDebug("Deployment Status:" + targetAvailabilityStatus.getDeploymentStatus());
                Set set = targetAvailabilityStatus.getServersAvailabilityStatus();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.printStatus((TargetAvailabilityStatus)iterator.next());
                }
                break;
            }
            case 3: {
                Debug.deploymentDebug("Target Name:" + targetAvailabilityStatus.getTargetName() + " Target Type: VirtualHost");
                Debug.deploymentDebug("Deployment Status:" + targetAvailabilityStatus.getDeploymentStatus());
                Set set = targetAvailabilityStatus.getClustersAvailabilityStatus();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    this.printStatus((TargetAvailabilityStatus)iterator.next());
                }
                Set set2 = targetAvailabilityStatus.getServersAvailabilityStatus();
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    this.printStatus((TargetAvailabilityStatus)iterator2.next());
                }
                break;
            }
        }
    }

    private final class TasksRetirePoller
    implements TimerListener {
        private TasksRetirePoller() {
        }

        public final void timerExpired(Timer timer) {
            block2: {
                try {
                    DeployerRuntimeImpl.this.checkAndMarkRetiredTasks();
                }
                catch (Throwable throwable) {
                    if (!Debug.isDeploymentDebugEnabled()) break block2;
                    Debug.deploymentDebug("TaskRetirePoller failed to mark tasks as retired due to an exception : ", throwable);
                }
            }
        }
    }
}

