/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.util.Set;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deploy.internal.targetserver.BasicDeployment;
import weblogic.deploy.internal.targetserver.SystemResourceDeployment;
import weblogic.management.configuration.CustomResourceMBean;
import weblogic.management.deploy.classdeployment.ClassDeploymentManager;
import weblogic.management.internal.DeploymentHandlerHome;

abstract class DeploymentAdapter {
    private static final boolean deploySystemResourceOnePhase = true;
    private static final boolean deployDeploymentHandlerOnePhase = true;
    static final DeploymentAdapter BASIC_DEP_ADAPTER = new DeploymentAdapter(){

        public String getName(Object object) {
            BasicDeployment basicDeployment = (BasicDeployment)object;
            return ApplicationVersionUtils.getDisplayName(basicDeployment.getDeploymentMBean());
        }

        protected void doPrepare(Object object) throws Exception {
            ((BasicDeployment)object).prepare();
            if (DeploymentAdapter.isDeployedInPhaseOne(object)) {
                ((BasicDeployment)object).activateFromServerLifecycle();
            }
        }

        protected void doActivate(Object object) throws Exception {
            if (DeploymentAdapter.isDeployedInPhaseOne(object)) {
                return;
            }
            ((BasicDeployment)object).activateFromServerLifecycle();
        }

        public void adminToProduction(Object object) throws Exception {
            ((BasicDeployment)object).adminToProductionFromServerLifecycle();
        }

        public void gracefulProductionToAdmin(Object object) throws Exception {
            ((BasicDeployment)object).productionToAdminFromServerLifecycle(true);
        }

        public void forceProductionToAdmin(Object object) throws Exception {
            ((BasicDeployment)object).productionToAdminFromServerLifecycle(false);
        }

        protected void doDeactivate(Object object) throws Exception {
            if (DeploymentAdapter.isDeployedInPhaseOne(object)) {
                return;
            }
            ((BasicDeployment)object).deactivateFromServerLifecycle();
        }

        protected void doUnprepare(Object object) throws Exception {
            if (DeploymentAdapter.isDeployedInPhaseOne(object)) {
                ((BasicDeployment)object).deactivateFromServerLifecycle();
            }
            ((BasicDeployment)object).unprepare();
        }

        public void remove(Object object) throws Exception {
            ((BasicDeployment)object).remove();
        }

        public void remove(Object object, boolean bl) throws Exception {
            ((BasicDeployment)object).remove(bl);
        }
    };
    static final DeploymentAdapter DEPLOYMENT_HANDLERS_ADAPTER = new DeploymentAdapter(){
        Set deployments;

        protected void doPrepare(Object object) throws Exception {
            this.deployments = DeploymentHandlerHome.getInstance().prepareInitialDeployments();
            DeploymentHandlerHome.getInstance().activateInitialDeployments(this.deployments);
        }

        protected void doActivate(Object object) throws Exception {
        }

        protected void doDeactivate(Object object) throws Exception {
        }

        protected void doUnprepare(Object object) throws Exception {
            this.deployments = DeploymentHandlerHome.getInstance().deactivateCurrentDeployments();
            DeploymentHandlerHome.getInstance().unprepareCurrentDeployments(this.deployments);
        }
    };
    static final DeploymentAdapter RESOURCE_DEPENDENT_DEPLOYMENT_HANDLERS_ADAPTER = new DeploymentAdapter(){
        Set deployments;

        protected void doPrepare(Object object) throws Exception {
            this.deployments = DeploymentHandlerHome.getInstance().prepareResourceDependentInitialDeployments();
            DeploymentHandlerHome.getInstance().activateResourceDependentInitialDeployments(this.deployments);
        }

        protected void doActivate(Object object) throws Exception {
        }

        protected void doDeactivate(Object object) throws Exception {
        }

        protected void doUnprepare(Object object) throws Exception {
            this.deployments = DeploymentHandlerHome.getInstance().deactivateResourceDependentCurrentDeployments();
            DeploymentHandlerHome.getInstance().unprepareResourceDependentCurrentDeployments(this.deployments);
        }
    };
    static final DeploymentAdapter STARTUP_CLASSES_ADAPTER = new DeploymentAdapter(){

        void activate(Object object) throws Exception {
            ClassDeploymentManager.getInstance().runStartupsBeforeAppActivation();
        }
    };

    private DeploymentAdapter() {
    }

    private static boolean isDeployedInPhaseOne(Object object) {
        return object instanceof SystemResourceDeployment && !(((BasicDeployment)object).getDeploymentMBean() instanceof CustomResourceMBean);
    }

    String getName(Object object) {
        return object.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepare(Object object) throws Exception {
        try {
            this.preInvoke();
            this.doPrepare(object);
            Object var3_2 = null;
            this.postInvoke();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postInvoke();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void activate(Object object) throws Exception {
        try {
            this.preInvoke();
            this.doActivate(object);
            Object var3_2 = null;
            this.postInvoke();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postInvoke();
            throw throwable;
        }
    }

    void adminToProduction(Object object) throws Exception {
    }

    void gracefulProductionToAdmin(Object object) throws Exception {
    }

    void forceProductionToAdmin(Object object) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deactivate(Object object) throws Exception {
        try {
            this.preInvoke();
            this.doDeactivate(object);
            Object var3_2 = null;
            this.postInvoke();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postInvoke();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unprepare(Object object) throws Exception {
        try {
            this.preInvoke();
            this.doUnprepare(object);
            Object var3_2 = null;
            this.postInvoke();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.postInvoke();
            throw throwable;
        }
    }

    void remove(Object object) throws Exception {
    }

    void remove(Object object, boolean bl) throws Exception {
    }

    protected void preInvoke() {
        ApplicationVersionUtils.setCurrentAdminMode(true);
    }

    protected void postInvoke() {
        ApplicationVersionUtils.unsetCurrentAdminMode();
    }

    protected void doPrepare(Object object) throws Exception {
    }

    protected void doActivate(Object object) throws Exception {
    }

    protected void doDeactivate(Object object) throws Exception {
    }

    protected void doUnprepare(Object object) throws Exception {
    }
}

