/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import weblogic.deploy.common.Debug;
import weblogic.deploy.internal.targetserver.state.DeploymentState;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.internal.AppDeploymentRuntimeImpl;
import weblogic.management.deploy.internal.AppRuntimeStateManager;
import weblogic.management.deploy.internal.DeploymentProgressObjectImpl;
import weblogic.management.jmx.modelmbean.NotificationGenerator;
import weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.AppDeploymentRuntimeMBean;
import weblogic.management.runtime.DeploymentManagerMBean;
import weblogic.management.runtime.DeploymentProgressObjectMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;

public final class DeploymentManagerImpl
extends DomainRuntimeMBeanDelegate
implements DeploymentManagerMBean,
PropertyChangeListener {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private int progressObjectsMaxCount = 20;
    private ArrayList<DeploymentProgressObjectMBean> progressObjects = new ArrayList();
    private Map<String, AppDeploymentRuntimeImpl> appDeploymentRuntimes = null;
    private MBeanNotificationInfo[] mbeanNotificationInfo = null;
    private NotificationGenerator notificationGenerator = null;
    private long notificationSequence = 0L;
    private long timerDelay = 60000L;
    private long timerPeriod = 60000L;
    private long removalTimeout = 3600000L;

    DeploymentManagerImpl(String string) throws ManagementException {
        super(string);
        this.initAppDeploymentRuntimes();
        TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule(new TimerListener(){

            public void timerExpired(Timer timer) {
                DeploymentManagerImpl.this.removeExpiredDeploymentProgressObjects();
            }
        }, this.timerDelay, this.timerPeriod);
    }

    private synchronized void removeExpiredDeploymentProgressObjects() {
        ArrayList<DeploymentProgressObjectImpl> arrayList = new ArrayList<DeploymentProgressObjectImpl>();
        for (int i = 0; i < this.progressObjects.size(); ++i) {
            DeploymentProgressObjectImpl deploymentProgressObjectImpl = (DeploymentProgressObjectImpl)this.progressObjects.get(i);
            long l = deploymentProgressObjectImpl.getEndTime();
            if (l > 0L && System.currentTimeMillis() - l > this.removalTimeout) {
                if (Debug.isDeploymentDebugEnabled()) {
                    Debug.deploymentDebug("removing expired progress object:  " + deploymentProgressObjectImpl.getApplicationName());
                }
                deploymentProgressObjectImpl.clear();
                continue;
            }
            arrayList.add(deploymentProgressObjectImpl);
        }
        this.progressObjects.clear();
        this.progressObjects = arrayList;
    }

    public synchronized AppDeploymentRuntimeMBean[] getAppDeploymentRuntimes() {
        return this.appDeploymentRuntimes.values().toArray(new AppDeploymentRuntimeMBean[0]);
    }

    public synchronized AppDeploymentRuntimeMBean lookupAppDeploymentRuntime(String string) {
        return this.appDeploymentRuntimes.get(string);
    }

    public synchronized DeploymentProgressObjectMBean[] getDeploymentProgressObjects() {
        return this.progressObjects.toArray(new DeploymentProgressObjectMBean[0]);
    }

    public synchronized void setMaximumDeploymentProgressObjectsCount(int n) {
        this.progressObjectsMaxCount = n;
    }

    public int getMaximumDeploymentProgressObjectsCount() {
        return this.progressObjectsMaxCount;
    }

    public synchronized void purgeCompletedDeploymentProgressObjects() {
        if (this.progressObjects.size() == 0) {
            return;
        }
        ArrayList<DeploymentProgressObjectImpl> arrayList = new ArrayList<DeploymentProgressObjectImpl>();
        for (int i = 0; i < this.progressObjects.size(); ++i) {
            DeploymentProgressObjectImpl deploymentProgressObjectImpl = (DeploymentProgressObjectImpl)this.progressObjects.get(i);
            String string = deploymentProgressObjectImpl.getState();
            if ("STATE_COMPLETED".equals(string) || "STATE_FAILED".equals(string)) {
                deploymentProgressObjectImpl.clear();
                continue;
            }
            arrayList.add(deploymentProgressObjectImpl);
        }
        this.progressObjects.clear();
        this.progressObjects = arrayList;
    }

    synchronized DeploymentProgressObjectMBean allocateDeploymentProgressObject(String string, DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean, AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        this.removeDeploymentProgressObject(string);
        if (this.progressObjects.size() < this.progressObjectsMaxCount) {
            DeploymentProgressObjectImpl deploymentProgressObjectImpl = new DeploymentProgressObjectImpl(string, deploymentTaskRuntimeMBean, appDeploymentMBean);
            this.progressObjects.add(deploymentProgressObjectImpl);
            return deploymentProgressObjectImpl;
        }
        throw new ManagementException("Max count reached");
    }

    public synchronized void removeDeploymentProgressObject(String string) {
        if (this.progressObjects.size() == 0 || string == null) {
            return;
        }
        for (int i = 0; i < this.progressObjects.size(); ++i) {
            if (!string.equals(this.progressObjects.get(i).getApplicationName())) continue;
            try {
                ((RuntimeMBeanDelegate)this.progressObjects.get(i)).unregister();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.progressObjects.remove(i);
        }
    }

    private synchronized void initAppDeploymentRuntimes() {
        if (this.appDeploymentRuntimes == null) {
            this.appDeploymentRuntimes = new HashMap<String, AppDeploymentRuntimeImpl>();
        } else {
            this.appDeploymentRuntimes.clear();
        }
        DomainRuntimeServiceMBean domainRuntimeServiceMBean = ManagementService.getDomainAccess(kernelId).getDomainRuntimeService();
        DomainMBean domainMBean = domainRuntimeServiceMBean.getDomainConfiguration();
        AppDeploymentMBean[] appDeploymentMBeanArray = domainMBean.getAppDeployments();
        if (appDeploymentMBeanArray != null) {
            for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
                try {
                    AppDeploymentRuntimeImpl appDeploymentRuntimeImpl = new AppDeploymentRuntimeImpl(appDeploymentMBeanArray[i]);
                    this.appDeploymentRuntimes.put(appDeploymentMBeanArray[i].getName(), appDeploymentRuntimeImpl);
                    this.sendNotification("weblogic.appdeployment.created", appDeploymentRuntimeImpl);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        domainMBean.addPropertyChangeListener(this);
        AppRuntimeStateManager.getManager().addStateListener(this);
    }

    private synchronized void initAppDeploymentRuntimes(AppDeploymentMBean[] appDeploymentMBeanArray) {
        if (appDeploymentMBeanArray != null) {
            HashMap<String, AppDeploymentRuntimeImpl> hashMap = new HashMap<String, AppDeploymentRuntimeImpl>();
            for (int i = 0; i < appDeploymentMBeanArray.length; ++i) {
                AppDeploymentRuntimeImpl appDeploymentRuntimeImpl = this.appDeploymentRuntimes.get(appDeploymentMBeanArray[i].getName());
                if (appDeploymentRuntimeImpl != null) {
                    hashMap.put(appDeploymentMBeanArray[i].getName(), appDeploymentRuntimeImpl);
                    this.appDeploymentRuntimes.remove(appDeploymentMBeanArray[i].getName());
                    continue;
                }
                try {
                    AppDeploymentRuntimeImpl appDeploymentRuntimeImpl2 = new AppDeploymentRuntimeImpl(appDeploymentMBeanArray[i]);
                    hashMap.put(appDeploymentMBeanArray[i].getName(), appDeploymentRuntimeImpl2);
                    this.sendNotification("weblogic.appdeployment.created", appDeploymentRuntimeImpl2);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (this.appDeploymentRuntimes != null) {
                Collection<AppDeploymentRuntimeImpl> collection = this.appDeploymentRuntimes.values();
                for (AppDeploymentRuntimeImpl appDeploymentRuntimeImpl2 : collection) {
                    try {
                        this.sendNotification("weblogic.appdeployment.deleted", appDeploymentRuntimeImpl2);
                        appDeploymentRuntimeImpl2.unregister();
                    }
                    catch (Exception exception) {}
                }
            }
            this.appDeploymentRuntimes.clear();
            this.appDeploymentRuntimes = hashMap;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DeploymentState deploymentState;
        if ("AppDeployments".equals(propertyChangeEvent.getPropertyName())) {
            AppDeploymentMBean[] appDeploymentMBeanArray = (AppDeploymentMBean[])propertyChangeEvent.getNewValue();
            this.initAppDeploymentRuntimes(appDeploymentMBeanArray);
        } else if ("State".equals(propertyChangeEvent.getPropertyName()) && (deploymentState = (DeploymentState)propertyChangeEvent.getNewValue()) != null) {
            AppDeploymentRuntimeImpl appDeploymentRuntimeImpl = this.appDeploymentRuntimes.get(deploymentState.getId());
            if (appDeploymentRuntimeImpl != null) {
                appDeploymentRuntimeImpl.sendNotification(deploymentState);
            }
            if (this.notificationGenerator != null) {
                this.sendNotification(DeploymentManagerImpl.translateState(deploymentState.getCurrentState()), this.appDeploymentRuntimes.get(deploymentState.getId()));
            }
        }
    }

    void setNotificationGenerator(NotificationGenerator notificationGenerator) {
        this.notificationGenerator = notificationGenerator;
    }

    private void sendNotification(String string, AppDeploymentRuntimeImpl appDeploymentRuntimeImpl) {
        if (this.notificationGenerator != null) {
            try {
                ++this.notificationSequence;
                Notification notification = new Notification(string, this.notificationGenerator.getObjectName(), this.notificationSequence);
                String string2 = "com.bea:Type=AppDeploymentRuntime,Name=" + appDeploymentRuntimeImpl.getName();
                notification.setUserData(string2);
                this.notificationGenerator.sendNotification(notification);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static String translateState(String string) {
        if ("STATE_NEW".equals(string)) {
            return "weblogic.appdeployment.state.new";
        }
        if ("STATE_PREPARED".equals(string)) {
            return "weblogic.appdeployment.state.prepared";
        }
        if ("STATE_ADMIN".equals(string)) {
            return "weblogic.appdeployment.state.admin";
        }
        if ("STATE_ACTIVE".equals(string)) {
            return "weblogic.appdeployment.state.active";
        }
        if ("STATE_RETIRED".equals(string)) {
            return "weblogic.appdeployment.state.retired";
        }
        if ("STATE_FAILED".equals(string)) {
            return "weblogic.appdeployment.state.failed";
        }
        if ("STATE_UPDATE_PENDING".equals(string)) {
            return "weblogic.appdeployment.state.update.pending";
        }
        return "weblogic.appdeployment.state.unknown";
    }
}

