/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.deploy.DeploymentTaskRuntime;
import weblogic.management.deploy.TargetStatus;
import weblogic.management.deploy.internal.ExceptionTranslator;
import weblogic.management.runtime.DeploymentProgressObjectMBean;
import weblogic.management.runtime.DeploymentTaskRuntimeMBean;
import weblogic.management.runtime.DomainRuntimeMBeanDelegate;

public final class DeploymentProgressObjectImpl
extends DomainRuntimeMBeanDelegate
implements DeploymentProgressObjectMBean {
    DeploymentTaskRuntimeMBean deploymentTaskRuntime;
    AppDeploymentMBean deployable;
    private List<Throwable> exceptions = new ArrayList<Throwable>();

    public DeploymentProgressObjectImpl(String string, DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean, AppDeploymentMBean appDeploymentMBean) throws ManagementException {
        super(string);
        this.deploymentTaskRuntime = deploymentTaskRuntimeMBean;
        this.deployable = appDeploymentMBean;
    }

    public String getId() {
        if (this.deploymentTaskRuntime != null) {
            return this.deploymentTaskRuntime.getId();
        }
        return null;
    }

    public int getOperationType() {
        if (this.deploymentTaskRuntime != null) {
            int n = this.deploymentTaskRuntime.getTask();
            if (n == 7) {
                return 1;
            }
            if (n == 8) {
                return 2;
            }
        }
        return 0;
    }

    public String getApplicationName() {
        return this.getName();
    }

    public AppDeploymentMBean getAppDeploymentMBean() {
        return this.deployable;
    }

    public String getState() {
        if (this.deploymentTaskRuntime != null) {
            int n = this.deploymentTaskRuntime.getState();
            if (0 == n) {
                return "STATE_INITIALIZED";
            }
            if (1 == n) {
                return "STATE_RUNNING";
            }
            if (2 == n) {
                return "STATE_COMPLETED";
            }
            if (3 == n) {
                return "STATE_FAILED";
            }
            if (4 == n) {
                return "STATE_DEFERRED";
            }
        }
        return "Unknown";
    }

    public String[] getTargets() {
        TargetStatus[] targetStatusArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.deploymentTaskRuntime != null && (targetStatusArray = this.deploymentTaskRuntime.getTargets()) != null) {
            for (int i = 0; i < targetStatusArray.length; ++i) {
                arrayList.add(targetStatusArray[i].getTarget());
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getFailedTargets() {
        Map map;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.deploymentTaskRuntime != null && this.deploymentTaskRuntime instanceof DeploymentTaskRuntime && (map = ((DeploymentTaskRuntime)this.deploymentTaskRuntime).getFailedTargets()) != null) {
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add((String)iterator.next());
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getMessages() {
        if (this.deploymentTaskRuntime != null) {
            return this.deploymentTaskRuntime.getTaskMessages().toArray(new String[0]);
        }
        return new String[0];
    }

    public RuntimeException[] getExceptions(String string) {
        ArrayList<RuntimeException> arrayList = new ArrayList<RuntimeException>();
        if (this.deploymentTaskRuntime != null) {
            Exception[] exceptionArray = this.deploymentTaskRuntime.findTarget(string).getMessages();
            for (int i = 0; i < exceptionArray.length; ++i) {
                arrayList.add(ExceptionTranslator.translateException(exceptionArray[i]));
            }
        }
        return arrayList.toArray(new RuntimeException[0]);
    }

    public RuntimeException[] getRootExceptions() {
        ArrayList<RuntimeException> arrayList = new ArrayList<RuntimeException>();
        for (int i = 0; i < this.exceptions.size(); ++i) {
            arrayList.add(ExceptionTranslator.translateException(this.exceptions.get(i)));
        }
        return arrayList.toArray(new RuntimeException[0]);
    }

    public void cancel() throws RuntimeException {
        if (this.deploymentTaskRuntime != null) {
            try {
                this.deploymentTaskRuntime.cancel();
            }
            catch (Throwable throwable) {
                throw ExceptionTranslator.translateException(throwable);
            }
        }
    }

    public void setDeploymentTaskRuntime(DeploymentTaskRuntimeMBean deploymentTaskRuntimeMBean) {
        this.deploymentTaskRuntime = deploymentTaskRuntimeMBean;
    }

    public DeploymentTaskRuntimeMBean getDeploymentTaskRuntime() {
        return this.deploymentTaskRuntime;
    }

    public void clear() {
        this.deploymentTaskRuntime = null;
        try {
            this.unregister();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getBeginTime() {
        if (this.deploymentTaskRuntime != null && this.deploymentTaskRuntime instanceof DeploymentTaskRuntime) {
            return ((DeploymentTaskRuntime)this.deploymentTaskRuntime).getBeginTime();
        }
        return 0L;
    }

    public long getEndTime() {
        if (this.deploymentTaskRuntime != null && this.deploymentTaskRuntime instanceof DeploymentTaskRuntime) {
            return ((DeploymentTaskRuntime)this.deploymentTaskRuntime).getEndTime();
        }
        return 0L;
    }

    public void addException(Throwable throwable) {
        this.exceptions.add(throwable);
    }
}

