/*
 * Decompiled with CFR 0.152.
 */
package weblogic.management.deploy.internal;

import java.io.File;
import java.security.AccessController;
import weblogic.deploy.beans.factory.DeploymentBeanFactory;
import weblogic.deploy.beans.factory.internal.DeploymentBeanFactoryImpl;
import weblogic.deploy.internal.InternalAppProcessor;
import weblogic.deploy.internal.diagnostics.DeploymentImageSource;
import weblogic.deploy.internal.targetserver.DeploymentManager;
import weblogic.diagnostics.image.ImageManager;
import weblogic.j2ee.J2EEApplicationService;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.ManagementLogger;
import weblogic.management.deploy.ApplicationsDirPoller;
import weblogic.management.deploy.GenericAppPoller;
import weblogic.management.deploy.internal.ApplicationCompatibilityEditProcessor;
import weblogic.management.deploy.internal.ConfiguredDeployments;
import weblogic.management.deploy.internal.DeployerRuntimeImpl;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.management.deploy.internal.DeploymentManagerImpl;
import weblogic.management.deploy.internal.DeploymentManagerLogger;
import weblogic.management.deploy.internal.RetirementManager;
import weblogic.management.internal.SecurityHelper;
import weblogic.management.provider.DomainAccessSettable;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.management.runtime.DeployerRuntimeMBean;
import weblogic.management.runtime.DeploymentManagerMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.server.AbstractServerService;
import weblogic.server.ServiceFailureException;

public final class DeploymentServerService
extends AbstractServerService {
    private static J2EEApplicationService j2eeApplicationService;
    private static ConfiguredDeployments configuredDeploymentsHandler;
    private static AuthenticatedSubject kernelId;
    private static ApplicationsDirPoller poller;
    private static DeployerRuntimeMBean deployerRuntime;
    private static DeploymentManagerMBean deploymentManager;
    private static DeploymentBeanFactory singleton;
    private static weblogic.deploy.internal.adminserver.DeploymentManager adminServerDeploymentManager;
    private static DeploymentManager targetServerDeploymentManager;
    private static boolean started;

    public DeploymentServerService() {
        ImageManager.getInstance().registerImageSource("Deployment", new DeploymentImageSource());
    }

    public static DeployerRuntimeMBean getDeployerRuntime() {
        SecurityHelper.assertIfNotKernel();
        return deployerRuntime;
    }

    public static DeploymentManagerMBean getDeploymentManager() {
        SecurityHelper.assertIfNotKernel();
        return deploymentManager;
    }

    public final void start() throws ServiceFailureException {
        DeploymentServerService.resume();
        started = true;
    }

    public final void halt() {
    }

    public final void stop() {
        this.halt();
        started = false;
    }

    public static void shutdownHelper() throws ServiceFailureException {
        DeploymentServerService.shutdownApps();
        try {
            DeploymentServerService.shutdownService();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Loggable loggable = DeploymentManagerLogger.logShutdownFailureLoggable();
            loggable.log();
        }
    }

    public static DeploymentBeanFactory getDeploymentBeanFactory() {
        if (singleton == null) {
            singleton = new DeploymentBeanFactoryImpl();
        }
        return singleton;
    }

    static final void init() throws ServiceFailureException {
        try {
            RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
            runtimeAccess.addAccessCallbackClass(ApplicationCompatibilityEditProcessor.class.getName());
            InternalAppProcessor internalAppProcessor = new InternalAppProcessor();
            internalAppProcessor.updateConfiguration(runtimeAccess.getDomain());
            j2eeApplicationService = new J2EEApplicationService();
            j2eeApplicationService.start();
            DeploymentServerService.startAdminServerDeploymentService();
            DeploymentServerService.startTargetServerDeploymentService();
        }
        catch (ManagementException managementException) {
            DeploymentServerService.shutdownService();
            throw new ServiceFailureException((Throwable)managementException);
        }
    }

    static void deployPreStandbyInternalApps() throws ServiceFailureException {
        configuredDeploymentsHandler.deployPreStandbyInternalApps();
    }

    static void undeployPreStandbyInternalApps() throws ServiceFailureException {
        configuredDeploymentsHandler.undeployPreStandbyInternalApps();
    }

    private static void resume() throws ServiceFailureException {
        try {
            configuredDeploymentsHandler.deploy();
            RetirementManager.retireAppsOnStartup();
        }
        catch (ManagementException managementException) {
            Loggable loggable = DeploymentManagerLogger.logResumeFailureLoggable();
            loggable.log();
            throw new ServiceFailureException(loggable.getMessage(), (Throwable)managementException);
        }
    }

    private static void shutdownApps() throws ServiceFailureException {
        if (j2eeApplicationService != null) {
            j2eeApplicationService.halt();
        }
        if (configuredDeploymentsHandler != null) {
            try {
                configuredDeploymentsHandler.undeploy();
            }
            catch (DeploymentException deploymentException) {
                throw new ServiceFailureException((Throwable)((Object)deploymentException));
            }
        }
    }

    private static weblogic.deploy.internal.adminserver.DeploymentManager getAdminServerDeploymentManager() {
        if (adminServerDeploymentManager == null) {
            adminServerDeploymentManager = weblogic.deploy.internal.adminserver.DeploymentManager.getInstance(kernelId);
        }
        return adminServerDeploymentManager;
    }

    private static DeploymentManager getTargetServerDeploymentManager() {
        if (targetServerDeploymentManager == null) {
            targetServerDeploymentManager = DeploymentManager.getInstance();
        }
        return targetServerDeploymentManager;
    }

    private static void shutdownService() {
        DeploymentServerService.shutdownTargetServerDeploymentManager();
        DeploymentServerService.shutdownAdminServerDeploymentManager();
    }

    private static void startAdminServerDeploymentService() throws ManagementException {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            DeploymentServerService.initializeDeployerRuntime();
            DeploymentServerService.initializeDeploymentManager();
            DeploymentServerService.initializeApplicationPoller();
            DeploymentServerService.initializeAdminServerDeploymentManager();
        }
    }

    private static void initializeDeployerRuntime() throws ManagementException {
        try {
            deployerRuntime = new DeployerRuntimeImpl("DeployerRuntime");
            DomainAccessSettable domainAccessSettable = (DomainAccessSettable)((Object)ManagementService.getDomainAccess(kernelId));
            domainAccessSettable.setDeployerRuntime(deployerRuntime);
        }
        catch (ManagementException managementException) {
            Loggable loggable = DeployerRuntimeLogger.logInitFailedLoggable((Throwable)managementException);
            loggable.log();
            throw new ManagementException(loggable.getMessage(), (Throwable)managementException);
        }
    }

    private static void initializeDeploymentManager() throws ManagementException {
        try {
            deploymentManager = new DeploymentManagerImpl("DeploymentManager");
            DomainAccessSettable domainAccessSettable = (DomainAccessSettable)((Object)ManagementService.getDomainAccess(kernelId));
            domainAccessSettable.setDeploymentManager(deploymentManager);
        }
        catch (ManagementException managementException) {
            Loggable loggable = DeploymentManagerLogger.logInitFailedLoggable(managementException);
            loggable.log();
            throw new ManagementException(loggable.getMessage(), (Throwable)managementException);
        }
    }

    private static void initializeApplicationPoller() {
        ApplicationsDirPoller.removeStagedFilesForAppsRemovedSinceLastShutdown();
    }

    private static void initializeAdminServerDeploymentManager() throws ManagementException {
        DeploymentServerService.getAdminServerDeploymentManager().initialize();
    }

    private static void shutdownAdminServerDeploymentManager() {
        if (ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            weblogic.deploy.internal.adminserver.DeploymentManager.shutdown();
        }
    }

    private static void startTargetServerDeploymentService() {
        DeploymentServerService.initializeTargetServerDeploymentManager();
        DeploymentServerService.initializeConfiguredDeployments();
    }

    private static void initializeTargetServerDeploymentManager() {
        DeploymentServerService.getTargetServerDeploymentManager().initialize();
    }

    private static void initializeConfiguredDeployments() {
        configuredDeploymentsHandler = ConfiguredDeployments.getConfigureDeploymentsHandler();
    }

    private static void shutdownTargetServerDeploymentManager() {
        DeploymentServerService.getTargetServerDeploymentManager().shutdown();
    }

    static void startAutoDeploymentPoller() {
        if (!ManagementService.getRuntimeAccess(kernelId).isAdminServer()) {
            return;
        }
        int n = 3000;
        String string = DomainDir.getAppPollerDir();
        if (!ManagementService.getRuntimeAccess(kernelId).getDomain().isProductionModeEnabled()) {
            long l = new Integer(n).longValue();
            poller = new ApplicationsDirPoller(new File(string), false, l);
            poller.start();
            ManagementLogger.logPollerStarted();
        } else {
            ManagementLogger.logPollerNotStarted();
        }
    }

    public static boolean isStarted() {
        return started;
    }

    public static GenericAppPoller getApplicationDirPoller() {
        return poller;
    }

    static {
        configuredDeploymentsHandler = null;
        kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        poller = null;
        started = false;
    }
}

